/*
 * Decompiled with CFR 0.152.
 */
package libcore.io;

import com.google.errorprone.annotations.DoNotMock;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class Streams
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static AtomicReference<byte[]> skipBuffer;

    private void $$robo$$libcore_io_Streams$__constructor__() {
    }

    private static final int $$robo$$libcore_io_Streams$readSingleByte(InputStream in) throws IOException {
        byte[] buffer = new byte[1];
        int result = in.read(buffer, 0, 1);
        return result != -1 ? buffer[0] & 0xFF : -1;
    }

    private static final void $$robo$$libcore_io_Streams$writeSingleByte(OutputStream out, int b) throws IOException {
        byte[] buffer = new byte[]{(byte)(b & 0xFF)};
        out.write(buffer);
    }

    private static final void $$robo$$libcore_io_Streams$readFully(InputStream in, byte[] dst) throws IOException {
        Streams.readFully(in, dst, 0, dst.length);
    }

    private static final void $$robo$$libcore_io_Streams$readFully(InputStream in, byte[] dst, int offset, int byteCount) throws IOException {
        if (byteCount == 0) {
            return;
        }
        if (in == null) {
            throw new NullPointerException("in == null");
        }
        if (dst == null) {
            throw new NullPointerException("dst == null");
        }
        Arrays.checkOffsetAndCount((int)dst.length, (int)offset, (int)byteCount);
        while (byteCount > 0) {
            int bytesRead = in.read(dst, offset, byteCount);
            if (bytesRead < 0) {
                throw new EOFException();
            }
            offset += bytesRead;
            byteCount -= bytesRead;
        }
    }

    private static final byte[] $$robo$$libcore_io_Streams$readFully(InputStream in) throws IOException {
        try {
            byte[] byArray = Streams.readFullyNoClose(in);
            return byArray;
        }
        finally {
            in.close();
        }
    }

    private static final byte[] $$robo$$libcore_io_Streams$readFullyNoClose(InputStream in) throws IOException {
        int count;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((count = in.read(buffer)) != -1) {
            bytes.write(buffer, 0, count);
        }
        return bytes.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String $$robo$$libcore_io_Streams$readFully(Reader reader) throws IOException {
        try {
            int count;
            StringWriter writer = new StringWriter();
            char[] buffer = new char[1024];
            while ((count = reader.read(buffer)) != -1) {
                writer.write(buffer, 0, count);
            }
            String string2 = writer.toString();
            return string2;
        }
        finally {
            reader.close();
        }
    }

    private static final void $$robo$$libcore_io_Streams$skipAll(InputStream in) throws IOException {
        do {
            in.skip(Long.MAX_VALUE);
        } while (in.read() != -1);
    }

    private static final long $$robo$$libcore_io_Streams$skipByReading(InputStream in, long byteCount) throws IOException {
        int toRead;
        long skipped;
        int read;
        byte[] buffer = skipBuffer.getAndSet(null);
        if (buffer == null) {
            buffer = new byte[4096];
        }
        for (skipped = 0L; skipped < byteCount && (read = in.read(buffer, 0, toRead = (int)Math.min(byteCount - skipped, (long)buffer.length))) != -1; skipped += (long)read) {
            if (read >= toRead) continue;
            break;
        }
        skipBuffer.set(buffer);
        return skipped;
    }

    private static final int $$robo$$libcore_io_Streams$copy(InputStream in, OutputStream out) throws IOException {
        int c;
        int total = 0;
        byte[] buffer = new byte[8192];
        while ((c = in.read(buffer)) != -1) {
            total += c;
            out.write(buffer, 0, c);
        }
        return total;
    }

    private static final String $$robo$$libcore_io_Streams$readAsciiLine(InputStream in) throws IOException {
        StringBuilder result = new StringBuilder(80);
        while (true) {
            int c;
            if ((c = in.read()) == -1) {
                throw new EOFException();
            }
            if (c == 10) break;
            result.append((char)c);
        }
        int length = result.length();
        if (length > 0 && result.charAt(length - 1) == '\r') {
            result.setLength(length - 1);
        }
        return result.toString();
    }

    static void __staticInitializer__() {
        skipBuffer = new AtomicReference();
    }

    private void __constructor__() {
        this.$$robo$$libcore_io_Streams$__constructor__();
    }

    private Streams() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_io_Streams$__constructor__(), 0, this);
    }

    public static int readSingleByte(InputStream inputStream) throws IOException {
        return (int)InvokeDynamicSupport.bootstrapStatic("readSingleByte", $$robo$$libcore_io_Streams$readSingleByte(java.io.InputStream ), 0, (InputStream)inputStream);
    }

    public static void writeSingleByte(OutputStream outputStream, int n) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("writeSingleByte", $$robo$$libcore_io_Streams$writeSingleByte(java.io.OutputStream int ), 0, (OutputStream)outputStream, (int)n);
    }

    public static void readFully(InputStream inputStream, byte[] byArray) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("readFully", $$robo$$libcore_io_Streams$readFully(java.io.InputStream byte[] ), 0, (InputStream)inputStream, (byte[])byArray);
    }

    public static void readFully(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("readFully", $$robo$$libcore_io_Streams$readFully(java.io.InputStream byte[] int int ), 0, (InputStream)inputStream, (byte[])byArray, (int)n, (int)n2);
    }

    public static byte[] readFully(InputStream inputStream) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("readFully", $$robo$$libcore_io_Streams$readFully(java.io.InputStream ), 0, (InputStream)inputStream);
    }

    public static byte[] readFullyNoClose(InputStream inputStream) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("readFullyNoClose", $$robo$$libcore_io_Streams$readFullyNoClose(java.io.InputStream ), 0, (InputStream)inputStream);
    }

    public static String readFully(Reader reader) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("readFully", $$robo$$libcore_io_Streams$readFully(java.io.Reader ), 0, (Reader)reader);
    }

    public static void skipAll(InputStream inputStream) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("skipAll", $$robo$$libcore_io_Streams$skipAll(java.io.InputStream ), 0, (InputStream)inputStream);
    }

    public static long skipByReading(InputStream inputStream, long l) throws IOException {
        return (long)InvokeDynamicSupport.bootstrapStatic("skipByReading", $$robo$$libcore_io_Streams$skipByReading(java.io.InputStream long ), 0, (InputStream)inputStream, (long)l);
    }

    public static int copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        return (int)InvokeDynamicSupport.bootstrapStatic("copy", $$robo$$libcore_io_Streams$copy(java.io.InputStream java.io.OutputStream ), 0, (InputStream)inputStream, (OutputStream)outputStream);
    }

    public static String readAsciiLine(InputStream inputStream) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("readAsciiLine", $$robo$$libcore_io_Streams$readAsciiLine(java.io.InputStream ), 0, (InputStream)inputStream);
    }

    static {
        RobolectricInternals.classInitializing(Streams.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Streams)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

