/*
 * Decompiled with CFR 0.152.
 */
package libcore.reflect;

import com.google.errorprone.annotations.DoNotMock;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.GenericSignatureFormatError;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import libcore.reflect.GenericArrayTypeImpl;
import libcore.reflect.ListOfTypes;
import libcore.reflect.ListOfVariables;
import libcore.reflect.ParameterizedTypeImpl;
import libcore.reflect.TypeVariableImpl;
import libcore.reflect.WildcardTypeImpl;
import libcore.util.EmptyArray;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class GenericSignatureParser
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public ListOfTypes exceptionTypes;
    public ListOfTypes parameterTypes;
    public TypeVariable[] formalTypeParameters;
    public Type returnType;
    public Type fieldType;
    public ListOfTypes interfaceTypes;
    public Type superclassType;
    public ClassLoader loader;
    GenericDeclaration genericDecl;
    char symbol;
    String identifier;
    private boolean eof;
    char[] buffer;
    int pos;

    private void $$robo$$libcore_reflect_GenericSignatureParser$__constructor__(ClassLoader loader) {
        this.loader = loader;
    }

    private final void $$robo$$libcore_reflect_GenericSignatureParser$setInput(GenericDeclaration genericDecl, String input) {
        if (input != null) {
            this.genericDecl = genericDecl;
            this.buffer = input.toCharArray();
            this.eof = false;
            this.scanSymbol();
        } else {
            this.eof = true;
        }
    }

    private final void $$robo$$libcore_reflect_GenericSignatureParser$parseForClass(GenericDeclaration genericDecl, String signature) {
        this.setInput(genericDecl, signature);
        if (!this.eof) {
            this.parseClassSignature();
        } else if (genericDecl instanceof Class) {
            Class c = (Class)genericDecl;
            this.formalTypeParameters = EmptyArray.TYPE_VARIABLE;
            this.superclassType = c.getSuperclass();
            Type[] interfaces = c.getInterfaces();
            this.interfaceTypes = interfaces.length == 0 ? ListOfTypes.EMPTY : new ListOfTypes(interfaces);
        } else {
            this.formalTypeParameters = EmptyArray.TYPE_VARIABLE;
            this.superclassType = Object.class;
            this.interfaceTypes = ListOfTypes.EMPTY;
        }
    }

    private final void $$robo$$libcore_reflect_GenericSignatureParser$parseForMethod(GenericDeclaration genericDecl, String signature, Class<?>[] rawExceptionTypes) {
        this.setInput(genericDecl, signature);
        if (!this.eof) {
            this.parseMethodTypeSignature(rawExceptionTypes);
        } else {
            Method m = (Method)genericDecl;
            this.formalTypeParameters = EmptyArray.TYPE_VARIABLE;
            Type[] parameterTypes = m.getParameterTypes();
            this.parameterTypes = parameterTypes.length == 0 ? ListOfTypes.EMPTY : new ListOfTypes(parameterTypes);
            Type[] exceptionTypes = m.getExceptionTypes();
            this.exceptionTypes = exceptionTypes.length == 0 ? ListOfTypes.EMPTY : new ListOfTypes(exceptionTypes);
            this.returnType = m.getReturnType();
        }
    }

    private final void $$robo$$libcore_reflect_GenericSignatureParser$parseForConstructor(GenericDeclaration genericDecl, String signature, Class<?>[] rawExceptionTypes) {
        this.setInput(genericDecl, signature);
        if (!this.eof) {
            this.parseMethodTypeSignature(rawExceptionTypes);
        } else {
            Constructor c = (Constructor)genericDecl;
            this.formalTypeParameters = EmptyArray.TYPE_VARIABLE;
            Type[] parameterTypes = c.getParameterTypes();
            this.parameterTypes = parameterTypes.length == 0 ? ListOfTypes.EMPTY : new ListOfTypes(parameterTypes);
            Type[] exceptionTypes = c.getExceptionTypes();
            this.exceptionTypes = exceptionTypes.length == 0 ? ListOfTypes.EMPTY : new ListOfTypes(exceptionTypes);
        }
    }

    private final void $$robo$$libcore_reflect_GenericSignatureParser$parseForField(GenericDeclaration genericDecl, String signature) {
        this.setInput(genericDecl, signature);
        if (!this.eof) {
            this.fieldType = this.parseFieldTypeSignature();
        }
    }

    private final void $$robo$$libcore_reflect_GenericSignatureParser$parseClassSignature() {
        this.parseOptFormalTypeParameters();
        this.superclassType = this.parseClassTypeSignature();
        this.interfaceTypes = new ListOfTypes(16);
        while (this.symbol > '\u0000') {
            this.interfaceTypes.add(this.parseClassTypeSignature());
        }
    }

    private final void $$robo$$libcore_reflect_GenericSignatureParser$parseOptFormalTypeParameters() {
        ListOfVariables typeParams = new ListOfVariables();
        if (this.symbol == '<') {
            this.scanSymbol();
            typeParams.add(this.parseFormalTypeParameter());
            while (this.symbol != '>' && this.symbol > '\u0000') {
                typeParams.add(this.parseFormalTypeParameter());
            }
            this.expect('>');
        }
        this.formalTypeParameters = typeParams.getArray();
    }

    private final TypeVariableImpl<GenericDeclaration> $$robo$$libcore_reflect_GenericSignatureParser$parseFormalTypeParameter() {
        this.scanIdentifier();
        String name = this.identifier.intern();
        ListOfTypes bounds = new ListOfTypes(8);
        this.expect(':');
        if (this.symbol == 'L' || this.symbol == '[' || this.symbol == 'T') {
            bounds.add(this.parseFieldTypeSignature());
        }
        while (this.symbol == ':') {
            this.scanSymbol();
            bounds.add(this.parseFieldTypeSignature());
        }
        return new TypeVariableImpl<GenericDeclaration>(this.genericDecl, name, bounds);
    }

    private final Type $$robo$$libcore_reflect_GenericSignatureParser$parseFieldTypeSignature() {
        switch (this.symbol) {
            case 'L': {
                return this.parseClassTypeSignature();
            }
            case '[': {
                this.scanSymbol();
                return new GenericArrayTypeImpl(this.parseTypeSignature());
            }
            case 'T': {
                return this.parseTypeVariableSignature();
            }
        }
        throw new GenericSignatureFormatError();
    }

    private final Type $$robo$$libcore_reflect_GenericSignatureParser$parseClassTypeSignature() {
        ParameterizedTypeImpl parentType;
        this.expect('L');
        StringBuilder qualIdent = new StringBuilder();
        this.scanIdentifier();
        while (this.symbol == '/') {
            this.scanSymbol();
            qualIdent.append(this.identifier).append(".");
            this.scanIdentifier();
        }
        qualIdent.append(this.identifier);
        ListOfTypes typeArgs = this.parseOptTypeArguments();
        ParameterizedTypeImpl type = parentType = new ParameterizedTypeImpl(null, qualIdent.toString(), typeArgs, this.loader);
        while (this.symbol == '.') {
            this.scanSymbol();
            this.scanIdentifier();
            qualIdent.append("$").append(this.identifier);
            typeArgs = this.parseOptTypeArguments();
            type = new ParameterizedTypeImpl(parentType, qualIdent.toString(), typeArgs, this.loader);
        }
        this.expect(';');
        return type;
    }

    private final ListOfTypes $$robo$$libcore_reflect_GenericSignatureParser$parseOptTypeArguments() {
        ListOfTypes typeArgs = new ListOfTypes(8);
        if (this.symbol == '<') {
            this.scanSymbol();
            typeArgs.add(this.parseTypeArgument());
            while (this.symbol != '>' && this.symbol > '\u0000') {
                typeArgs.add(this.parseTypeArgument());
            }
            this.expect('>');
        }
        return typeArgs;
    }

    private final Type $$robo$$libcore_reflect_GenericSignatureParser$parseTypeArgument() {
        ListOfTypes extendsBound = new ListOfTypes(1);
        ListOfTypes superBound = new ListOfTypes(1);
        if (this.symbol == '*') {
            this.scanSymbol();
            extendsBound.add((Type)((Object)Object.class));
            return new WildcardTypeImpl(extendsBound, superBound);
        }
        if (this.symbol == '+') {
            this.scanSymbol();
            extendsBound.add(this.parseFieldTypeSignature());
            return new WildcardTypeImpl(extendsBound, superBound);
        }
        if (this.symbol == '-') {
            this.scanSymbol();
            superBound.add(this.parseFieldTypeSignature());
            extendsBound.add((Type)((Object)Object.class));
            return new WildcardTypeImpl(extendsBound, superBound);
        }
        return this.parseFieldTypeSignature();
    }

    private final TypeVariableImpl<GenericDeclaration> $$robo$$libcore_reflect_GenericSignatureParser$parseTypeVariableSignature() {
        this.expect('T');
        this.scanIdentifier();
        this.expect(';');
        return new TypeVariableImpl<GenericDeclaration>(this.genericDecl, this.identifier);
    }

    private final Type $$robo$$libcore_reflect_GenericSignatureParser$parseTypeSignature() {
        switch (this.symbol) {
            case 'B': {
                this.scanSymbol();
                return Byte.TYPE;
            }
            case 'C': {
                this.scanSymbol();
                return Character.TYPE;
            }
            case 'D': {
                this.scanSymbol();
                return Double.TYPE;
            }
            case 'F': {
                this.scanSymbol();
                return Float.TYPE;
            }
            case 'I': {
                this.scanSymbol();
                return Integer.TYPE;
            }
            case 'J': {
                this.scanSymbol();
                return Long.TYPE;
            }
            case 'S': {
                this.scanSymbol();
                return Short.TYPE;
            }
            case 'Z': {
                this.scanSymbol();
                return Boolean.TYPE;
            }
        }
        return this.parseFieldTypeSignature();
    }

    private final void $$robo$$libcore_reflect_GenericSignatureParser$parseMethodTypeSignature(Class<?>[] rawExceptionTypes) {
        this.parseOptFormalTypeParameters();
        this.parameterTypes = new ListOfTypes(16);
        this.expect('(');
        while (this.symbol != ')' && this.symbol > '\u0000') {
            this.parameterTypes.add(this.parseTypeSignature());
        }
        this.expect(')');
        this.returnType = this.parseReturnType();
        if (this.symbol == '^') {
            this.exceptionTypes = new ListOfTypes(8);
            do {
                this.scanSymbol();
                if (this.symbol == 'T') {
                    this.exceptionTypes.add(this.parseTypeVariableSignature());
                    continue;
                }
                this.exceptionTypes.add(this.parseClassTypeSignature());
            } while (this.symbol == '^');
        } else {
            this.exceptionTypes = rawExceptionTypes != null ? new ListOfTypes(rawExceptionTypes) : new ListOfTypes(0);
        }
    }

    private final Type $$robo$$libcore_reflect_GenericSignatureParser$parseReturnType() {
        if (this.symbol != 'V') {
            return this.parseTypeSignature();
        }
        this.scanSymbol();
        return Void.TYPE;
    }

    private final void $$robo$$libcore_reflect_GenericSignatureParser$scanSymbol() {
        if (!this.eof) {
            if (this.pos < this.buffer.length) {
                this.symbol = this.buffer[this.pos];
                ++this.pos;
            } else {
                this.symbol = '\u0000';
                this.eof = true;
            }
        } else {
            throw new GenericSignatureFormatError();
        }
    }

    private final void $$robo$$libcore_reflect_GenericSignatureParser$expect(char c) {
        if (this.symbol != c) {
            throw new GenericSignatureFormatError();
        }
        this.scanSymbol();
    }

    private static final boolean $$robo$$libcore_reflect_GenericSignatureParser$isStopSymbol(char ch) {
        switch (ch) {
            case '.': 
            case '/': 
            case ':': 
            case ';': 
            case '<': {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void $$robo$$libcore_reflect_GenericSignatureParser$scanIdentifier() {
        if (this.eof) throw new GenericSignatureFormatError();
        StringBuilder identBuf = new StringBuilder(32);
        if (!GenericSignatureParser.isStopSymbol(this.symbol)) {
            identBuf.append(this.symbol);
            do {
                char ch;
                if ((ch = this.buffer[this.pos]) >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || !GenericSignatureParser.isStopSymbol(ch)) {
                    identBuf.append(ch);
                    ++this.pos;
                    continue;
                }
                this.identifier = identBuf.toString();
                this.scanSymbol();
                return;
            } while (this.pos != this.buffer.length);
        } else {
            this.symbol = '\u0000';
            this.eof = true;
            throw new GenericSignatureFormatError();
        }
        this.identifier = identBuf.toString();
        this.symbol = '\u0000';
        this.eof = true;
    }

    private void __constructor__(ClassLoader classLoader) {
        this.$$robo$$libcore_reflect_GenericSignatureParser$__constructor__(classLoader);
    }

    public GenericSignatureParser(ClassLoader classLoader) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_reflect_GenericSignatureParser$__constructor__(java.lang.ClassLoader ), 0, this, classLoader);
    }

    void setInput(GenericDeclaration genericDeclaration, String string2) {
        InvokeDynamicSupport.bootstrap("setInput", $$robo$$libcore_reflect_GenericSignatureParser$setInput(java.lang.reflect.GenericDeclaration java.lang.String ), 0, this, genericDeclaration, string2);
    }

    public void parseForClass(GenericDeclaration genericDeclaration, String string2) {
        InvokeDynamicSupport.bootstrap("parseForClass", $$robo$$libcore_reflect_GenericSignatureParser$parseForClass(java.lang.reflect.GenericDeclaration java.lang.String ), 0, this, genericDeclaration, string2);
    }

    public void parseForMethod(GenericDeclaration genericDeclaration, String string2, Class<?>[] classArray) {
        InvokeDynamicSupport.bootstrap("parseForMethod", $$robo$$libcore_reflect_GenericSignatureParser$parseForMethod(java.lang.reflect.GenericDeclaration java.lang.String java.lang.Class<?>[] ), 0, this, genericDeclaration, string2, classArray);
    }

    public void parseForConstructor(GenericDeclaration genericDeclaration, String string2, Class<?>[] classArray) {
        InvokeDynamicSupport.bootstrap("parseForConstructor", $$robo$$libcore_reflect_GenericSignatureParser$parseForConstructor(java.lang.reflect.GenericDeclaration java.lang.String java.lang.Class<?>[] ), 0, this, genericDeclaration, string2, classArray);
    }

    public void parseForField(GenericDeclaration genericDeclaration, String string2) {
        InvokeDynamicSupport.bootstrap("parseForField", $$robo$$libcore_reflect_GenericSignatureParser$parseForField(java.lang.reflect.GenericDeclaration java.lang.String ), 0, this, genericDeclaration, string2);
    }

    void parseClassSignature() {
        InvokeDynamicSupport.bootstrap("parseClassSignature", $$robo$$libcore_reflect_GenericSignatureParser$parseClassSignature(), 0, this);
    }

    void parseOptFormalTypeParameters() {
        InvokeDynamicSupport.bootstrap("parseOptFormalTypeParameters", $$robo$$libcore_reflect_GenericSignatureParser$parseOptFormalTypeParameters(), 0, this);
    }

    TypeVariableImpl<GenericDeclaration> parseFormalTypeParameter() {
        return InvokeDynamicSupport.bootstrap("parseFormalTypeParameter", $$robo$$libcore_reflect_GenericSignatureParser$parseFormalTypeParameter(), 0, this);
    }

    Type parseFieldTypeSignature() {
        return InvokeDynamicSupport.bootstrap("parseFieldTypeSignature", $$robo$$libcore_reflect_GenericSignatureParser$parseFieldTypeSignature(), 0, this);
    }

    Type parseClassTypeSignature() {
        return InvokeDynamicSupport.bootstrap("parseClassTypeSignature", $$robo$$libcore_reflect_GenericSignatureParser$parseClassTypeSignature(), 0, this);
    }

    ListOfTypes parseOptTypeArguments() {
        return InvokeDynamicSupport.bootstrap("parseOptTypeArguments", $$robo$$libcore_reflect_GenericSignatureParser$parseOptTypeArguments(), 0, this);
    }

    Type parseTypeArgument() {
        return InvokeDynamicSupport.bootstrap("parseTypeArgument", $$robo$$libcore_reflect_GenericSignatureParser$parseTypeArgument(), 0, this);
    }

    TypeVariableImpl<GenericDeclaration> parseTypeVariableSignature() {
        return InvokeDynamicSupport.bootstrap("parseTypeVariableSignature", $$robo$$libcore_reflect_GenericSignatureParser$parseTypeVariableSignature(), 0, this);
    }

    Type parseTypeSignature() {
        return InvokeDynamicSupport.bootstrap("parseTypeSignature", $$robo$$libcore_reflect_GenericSignatureParser$parseTypeSignature(), 0, this);
    }

    void parseMethodTypeSignature(Class<?>[] classArray) {
        InvokeDynamicSupport.bootstrap("parseMethodTypeSignature", $$robo$$libcore_reflect_GenericSignatureParser$parseMethodTypeSignature(java.lang.Class<?>[] ), 0, this, classArray);
    }

    Type parseReturnType() {
        return InvokeDynamicSupport.bootstrap("parseReturnType", $$robo$$libcore_reflect_GenericSignatureParser$parseReturnType(), 0, this);
    }

    void scanSymbol() {
        InvokeDynamicSupport.bootstrap("scanSymbol", $$robo$$libcore_reflect_GenericSignatureParser$scanSymbol(), 0, this);
    }

    void expect(char c) {
        InvokeDynamicSupport.bootstrap("expect", $$robo$$libcore_reflect_GenericSignatureParser$expect(char ), 0, this, c);
    }

    static boolean isStopSymbol(char c) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isStopSymbol", $$robo$$libcore_reflect_GenericSignatureParser$isStopSymbol(char ), 0, (char)c);
    }

    void scanIdentifier() {
        InvokeDynamicSupport.bootstrap("scanIdentifier", $$robo$$libcore_reflect_GenericSignatureParser$scanIdentifier(), 0, this);
    }

    public /* synthetic */ GenericSignatureParser() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GenericSignatureParser)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

