/*
 * Decompiled with CFR 0.152.
 */
package android.accessibilityservice;

import android.accessibilityservice.IAccessibilityServiceConnection;
import android.os.Handler;
import android.os.Looper;
import android.os.RemoteException;
import android.util.ArrayMap;
import android.util.Slog;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class AccessibilityButtonController
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "A11yButtonController";
    private IAccessibilityServiceConnection mServiceConnection;
    private Object mLock;
    private ArrayMap<AccessibilityButtonCallback, Handler> mCallbacks;

    private void $$robo$$android_accessibilityservice_AccessibilityButtonController$__constructor__(IAccessibilityServiceConnection serviceConnection) {
        this.mServiceConnection = serviceConnection;
        this.mLock = new Object();
    }

    private final boolean $$robo$$android_accessibilityservice_AccessibilityButtonController$isAccessibilityButtonAvailable() {
        try {
            return this.mServiceConnection.isAccessibilityButtonAvailable();
        }
        catch (RemoteException re) {
            Slog.w("A11yButtonController", "Failed to get accessibility button availability.", re);
            re.rethrowFromSystemServer();
            return false;
        }
    }

    private final void $$robo$$android_accessibilityservice_AccessibilityButtonController$registerAccessibilityButtonCallback(AccessibilityButtonCallback callback) {
        this.registerAccessibilityButtonCallback(callback, new Handler(Looper.getMainLooper()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_accessibilityservice_AccessibilityButtonController$registerAccessibilityButtonCallback(AccessibilityButtonCallback callback, Handler handler) {
        Preconditions.checkNotNull(callback);
        Preconditions.checkNotNull(handler);
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCallbacks == null) {
                this.mCallbacks = new ArrayMap();
            }
            this.mCallbacks.put(callback, handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_accessibilityservice_AccessibilityButtonController$unregisterAccessibilityButtonCallback(AccessibilityButtonCallback callback) {
        Preconditions.checkNotNull(callback);
        Object object = this.mLock;
        synchronized (object) {
            boolean hasKey;
            if (this.mCallbacks == null) {
                return;
            }
            int keyIndex = this.mCallbacks.indexOfKey(callback);
            boolean bl = hasKey = keyIndex >= 0;
            if (hasKey) {
                this.mCallbacks.removeAt(keyIndex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_accessibilityservice_AccessibilityButtonController$dispatchAccessibilityButtonClicked() {
        ArrayMap<AccessibilityButtonCallback, Handler> entries;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCallbacks == null || this.mCallbacks.isEmpty()) {
                Slog.w("A11yButtonController", "Received accessibility button click with no callbacks!");
                return;
            }
            entries = new ArrayMap<AccessibilityButtonCallback, Handler>(this.mCallbacks);
        }
        int count = entries.size();
        for (int i = 0; i < count; ++i) {
            AccessibilityButtonCallback callback = entries.keyAt(i);
            Handler handler = entries.valueAt(i);
            handler.post(() -> callback.onClicked(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_accessibilityservice_AccessibilityButtonController$dispatchAccessibilityButtonAvailabilityChanged(boolean available) {
        ArrayMap<AccessibilityButtonCallback, Handler> entries;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCallbacks == null || this.mCallbacks.isEmpty()) {
                Slog.w("A11yButtonController", "Received accessibility button availability change with no callbacks!");
                return;
            }
            entries = new ArrayMap<AccessibilityButtonCallback, Handler>(this.mCallbacks);
        }
        int count = entries.size();
        for (int i = 0; i < count; ++i) {
            AccessibilityButtonCallback callback = entries.keyAt(i);
            Handler handler = entries.valueAt(i);
            handler.post(() -> callback.onAvailabilityChanged(this, available));
        }
    }

    private void __constructor__(IAccessibilityServiceConnection iAccessibilityServiceConnection) {
        this.$$robo$$android_accessibilityservice_AccessibilityButtonController$__constructor__(iAccessibilityServiceConnection);
    }

    AccessibilityButtonController(IAccessibilityServiceConnection iAccessibilityServiceConnection) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accessibilityservice_AccessibilityButtonController$__constructor__(android.accessibilityservice.IAccessibilityServiceConnection ), 0, this, iAccessibilityServiceConnection);
    }

    public boolean isAccessibilityButtonAvailable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAccessibilityButtonAvailable", $$robo$$android_accessibilityservice_AccessibilityButtonController$isAccessibilityButtonAvailable(), 0, this);
    }

    public void registerAccessibilityButtonCallback(AccessibilityButtonCallback accessibilityButtonCallback) {
        InvokeDynamicSupport.bootstrap("registerAccessibilityButtonCallback", $$robo$$android_accessibilityservice_AccessibilityButtonController$registerAccessibilityButtonCallback(android.accessibilityservice.AccessibilityButtonController$AccessibilityButtonCallback ), 0, this, accessibilityButtonCallback);
    }

    public void registerAccessibilityButtonCallback(AccessibilityButtonCallback accessibilityButtonCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("registerAccessibilityButtonCallback", $$robo$$android_accessibilityservice_AccessibilityButtonController$registerAccessibilityButtonCallback(android.accessibilityservice.AccessibilityButtonController$AccessibilityButtonCallback android.os.Handler ), 0, this, accessibilityButtonCallback, handler);
    }

    public void unregisterAccessibilityButtonCallback(AccessibilityButtonCallback accessibilityButtonCallback) {
        InvokeDynamicSupport.bootstrap("unregisterAccessibilityButtonCallback", $$robo$$android_accessibilityservice_AccessibilityButtonController$unregisterAccessibilityButtonCallback(android.accessibilityservice.AccessibilityButtonController$AccessibilityButtonCallback ), 0, this, accessibilityButtonCallback);
    }

    void dispatchAccessibilityButtonClicked() {
        InvokeDynamicSupport.bootstrap("dispatchAccessibilityButtonClicked", $$robo$$android_accessibilityservice_AccessibilityButtonController$dispatchAccessibilityButtonClicked(), 0, this);
    }

    void dispatchAccessibilityButtonAvailabilityChanged(boolean bl) {
        InvokeDynamicSupport.bootstrap("dispatchAccessibilityButtonAvailabilityChanged", $$robo$$android_accessibilityservice_AccessibilityButtonController$dispatchAccessibilityButtonAvailabilityChanged(boolean ), 0, this, bl);
    }

    public /* synthetic */ AccessibilityButtonController() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AccessibilityButtonController)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static abstract class AccessibilityButtonCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_accessibilityservice_AccessibilityButtonController_AccessibilityButtonCallback$__constructor__() {
        }

        private final void $$robo$$android_accessibilityservice_AccessibilityButtonController_AccessibilityButtonCallback$onClicked(AccessibilityButtonController controller) {
        }

        private final void $$robo$$android_accessibilityservice_AccessibilityButtonController_AccessibilityButtonCallback$onAvailabilityChanged(AccessibilityButtonController controller, boolean available) {
        }

        private void __constructor__() {
            this.$$robo$$android_accessibilityservice_AccessibilityButtonController_AccessibilityButtonCallback$__constructor__();
        }

        public AccessibilityButtonCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accessibilityservice_AccessibilityButtonController_AccessibilityButtonCallback$__constructor__(), 0, this);
        }

        public void onClicked(AccessibilityButtonController accessibilityButtonController) {
            InvokeDynamicSupport.bootstrap("onClicked", $$robo$$android_accessibilityservice_AccessibilityButtonController_AccessibilityButtonCallback$onClicked(android.accessibilityservice.AccessibilityButtonController ), 0, this, accessibilityButtonController);
        }

        public void onAvailabilityChanged(AccessibilityButtonController accessibilityButtonController, boolean bl) {
            InvokeDynamicSupport.bootstrap("onAvailabilityChanged", $$robo$$android_accessibilityservice_AccessibilityButtonController_AccessibilityButtonCallback$onAvailabilityChanged(android.accessibilityservice.AccessibilityButtonController boolean ), 0, this, accessibilityButtonController, bl);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AccessibilityButtonCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

