/*
 * Decompiled with CFR 0.152.
 */
package android.accounts;

import android.accounts.Account;
import android.accounts.AccountAuthenticatorResponse;
import android.accounts.AccountManager;
import android.accounts.AccountManagerCallback;
import android.accounts.AccountManagerFuture;
import android.accounts.AuthenticatorDescription;
import android.accounts.AuthenticatorException;
import android.accounts.OperationCanceledException;
import android.app.Activity;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.io.IOException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class GrantCredentialsPermissionActivity
extends Activity
implements View.OnClickListener,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String EXTRAS_ACCOUNT = "account";
    public static String EXTRAS_AUTH_TOKEN_TYPE = "authTokenType";
    public static String EXTRAS_RESPONSE = "response";
    public static String EXTRAS_REQUESTING_UID = "uid";
    private Account mAccount;
    private String mAuthTokenType;
    private int mUid;
    private Bundle mResultBundle;
    protected LayoutInflater mInflater;

    private void $$robo$$android_accounts_GrantCredentialsPermissionActivity$__constructor__() {
        this.mResultBundle = null;
    }

    private final void $$robo$$android_accounts_GrantCredentialsPermissionActivity$onCreate(Bundle savedInstanceState) {
        String accountTypeLabel;
        super.onCreate(savedInstanceState);
        this.setContentView(17367144);
        this.setTitle(17039921);
        this.mInflater = (LayoutInflater)this.getSystemService("layout_inflater");
        Bundle extras = this.getIntent().getExtras();
        if (extras == null) {
            this.setResult(0);
            this.finish();
            return;
        }
        this.mAccount = (Account)extras.getParcelable("account");
        this.mAuthTokenType = extras.getString("authTokenType");
        this.mUid = extras.getInt("uid");
        PackageManager pm = this.getPackageManager();
        String[] packages = pm.getPackagesForUid(this.mUid);
        if (this.mAccount == null || this.mAuthTokenType == null || packages == null) {
            this.setResult(0);
            this.finish();
            return;
        }
        try {
            accountTypeLabel = this.getAccountLabel(this.mAccount);
        }
        catch (IllegalArgumentException e) {
            this.setResult(0);
            this.finish();
            return;
        }
        TextView authTokenTypeView = (TextView)this.findViewById(16908722);
        authTokenTypeView.setVisibility(8);
        AccountManagerCallback<String> callback = new AccountManagerCallback<String>(this, authTokenTypeView){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ TextView val$authTokenTypeView;
            /* synthetic */ GrantCredentialsPermissionActivity this$0;

            private void $$robo$$android_accounts_GrantCredentialsPermissionActivity_1$__constructor__(GrantCredentialsPermissionActivity this$0, TextView textView) {
            }

            private final void $$robo$$android_accounts_GrantCredentialsPermissionActivity_1$run(AccountManagerFuture<String> future) {
                try {
                    String authTokenLabel = future.getResult();
                    if (!TextUtils.isEmpty(authTokenLabel)) {
                        this.this$0.runOnUiThread(new Runnable(this, authTokenLabel){
                            public transient /* synthetic */ Object __robo_data__;
                            /* synthetic */ String val$authTokenLabel;
                            /* synthetic */ 1 this$1;

                            private void $$robo$$android_accounts_GrantCredentialsPermissionActivity_1_1$__constructor__(1 this$1, String string2) {
                            }

                            private final void $$robo$$android_accounts_GrantCredentialsPermissionActivity_1_1$run() {
                                if (!this.this$1.this$0.isFinishing()) {
                                    this.this$1.val$authTokenTypeView.setText(this.val$authTokenLabel);
                                    this.this$1.val$authTokenTypeView.setVisibility(0);
                                }
                            }

                            private void __constructor__(1 var1_1, String string2) {
                                this.$$robo$$android_accounts_GrantCredentialsPermissionActivity_1_1$__constructor__(var1_1, string2);
                            }
                            {
                                this.this$1 = var1_1;
                                this.val$authTokenLabel = string2;
                                this.$$robo$init();
                                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accounts_GrantCredentialsPermissionActivity_1_1$__constructor__(android.accounts.GrantCredentialsPermissionActivity$1 java.lang.String ), 0, this, var1_1, string2);
                            }

                            @Override
                            public void run() {
                                InvokeDynamicSupport.bootstrap("run", $$robo$$android_accounts_GrantCredentialsPermissionActivity_1_1$run(), 0, this);
                            }
                            {
                                this.$$robo$init();
                            }

                            protected /* synthetic */ void $$robo$init() {
                                if (this.__robo_data__ == null) {
                                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                                }
                            }

                            public /* synthetic */ Object $$robo$getData() {
                                return this.__robo_data__;
                            }
                        });
                    }
                }
                catch (OperationCanceledException operationCanceledException) {
                }
                catch (IOException iOException) {
                }
                catch (AuthenticatorException authenticatorException) {
                    // empty catch block
                }
            }

            private void __constructor__(GrantCredentialsPermissionActivity grantCredentialsPermissionActivity, TextView textView) {
                this.$$robo$$android_accounts_GrantCredentialsPermissionActivity_1$__constructor__(grantCredentialsPermissionActivity, textView);
            }
            {
                this.this$0 = grantCredentialsPermissionActivity;
                this.val$authTokenTypeView = textView;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accounts_GrantCredentialsPermissionActivity_1$__constructor__(android.accounts.GrantCredentialsPermissionActivity android.widget.TextView ), 0, this, grantCredentialsPermissionActivity, textView);
            }

            @Override
            public void run(AccountManagerFuture<String> accountManagerFuture) {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_accounts_GrantCredentialsPermissionActivity_1$run(android.accounts.AccountManagerFuture<java.lang.String> ), 0, this, accountManagerFuture);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        if (!"com.android.AccountManager.ACCOUNT_ACCESS_TOKEN_TYPE".equals(this.mAuthTokenType)) {
            AccountManager.get(this).getAuthTokenLabel(this.mAccount.type, this.mAuthTokenType, callback, null);
        }
        ((View)this.findViewById(16908703)).setOnClickListener(this);
        ((View)this.findViewById(16908831)).setOnClickListener(this);
        LinearLayout packagesListView = (LinearLayout)this.findViewById(16909131);
        for (String pkg : packages) {
            String packageLabel;
            try {
                packageLabel = pm.getApplicationLabel(pm.getApplicationInfo(pkg, 0)).toString();
            }
            catch (PackageManager.NameNotFoundException e) {
                packageLabel = pkg;
            }
            packagesListView.addView(this.newPackageView(packageLabel));
        }
        ((TextView)this.findViewById(16908654)).setText(this.mAccount.name);
        ((TextView)this.findViewById(16908657)).setText(accountTypeLabel);
    }

    private final String $$robo$$android_accounts_GrantCredentialsPermissionActivity$getAccountLabel(Account account) {
        for (AuthenticatorDescription desc : AccountManager.get(this).getAuthenticatorTypes()) {
            if (!desc.type.equals(account.type)) continue;
            try {
                return this.createPackageContext(desc.packageName, 0).getString(desc.labelId);
            }
            catch (PackageManager.NameNotFoundException e) {
                return account.type;
            }
            catch (Resources.NotFoundException e) {
                return account.type;
            }
        }
        return account.type;
    }

    private final View $$robo$$android_accounts_GrantCredentialsPermissionActivity$newPackageView(String packageLabel) {
        View view = this.mInflater.inflate(17367201, null);
        ((TextView)view.findViewById(16909130)).setText(packageLabel);
        return view;
    }

    private final void $$robo$$android_accounts_GrantCredentialsPermissionActivity$onClick(View v) {
        switch (v.getId()) {
            case 16908703: {
                AccountManager.get(this).updateAppPermission(this.mAccount, this.mAuthTokenType, this.mUid, true);
                Intent result = new Intent();
                result.putExtra("retry", true);
                this.setResult(-1, result);
                this.setAccountAuthenticatorResult(result.getExtras());
                break;
            }
            case 16908831: {
                AccountManager.get(this).updateAppPermission(this.mAccount, this.mAuthTokenType, this.mUid, false);
                this.setResult(0);
            }
        }
        this.finish();
    }

    private final void $$robo$$android_accounts_GrantCredentialsPermissionActivity$setAccountAuthenticatorResult(Bundle result) {
        this.mResultBundle = result;
    }

    private final void $$robo$$android_accounts_GrantCredentialsPermissionActivity$finish() {
        Intent intent = this.getIntent();
        AccountAuthenticatorResponse response = (AccountAuthenticatorResponse)intent.getParcelableExtra("response");
        if (response != null) {
            if (this.mResultBundle != null) {
                response.onResult(this.mResultBundle);
            } else {
                response.onError(4, "canceled");
            }
        }
        super.finish();
    }

    private void __constructor__() {
        this.$$robo$$android_accounts_GrantCredentialsPermissionActivity$__constructor__();
    }

    public GrantCredentialsPermissionActivity() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accounts_GrantCredentialsPermissionActivity$__constructor__(), 0, this);
    }

    @Override
    protected void onCreate(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("onCreate", $$robo$$android_accounts_GrantCredentialsPermissionActivity$onCreate(android.os.Bundle ), 0, this, bundle);
    }

    private String getAccountLabel(Account account) {
        return InvokeDynamicSupport.bootstrap("getAccountLabel", $$robo$$android_accounts_GrantCredentialsPermissionActivity$getAccountLabel(android.accounts.Account ), 0, this, account);
    }

    private View newPackageView(String string2) {
        return InvokeDynamicSupport.bootstrap("newPackageView", $$robo$$android_accounts_GrantCredentialsPermissionActivity$newPackageView(java.lang.String ), 0, this, string2);
    }

    @Override
    public void onClick(View view) {
        InvokeDynamicSupport.bootstrap("onClick", $$robo$$android_accounts_GrantCredentialsPermissionActivity$onClick(android.view.View ), 0, this, view);
    }

    public void setAccountAuthenticatorResult(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("setAccountAuthenticatorResult", $$robo$$android_accounts_GrantCredentialsPermissionActivity$setAccountAuthenticatorResult(android.os.Bundle ), 0, this, bundle);
    }

    @Override
    public void finish() {
        InvokeDynamicSupport.bootstrap("finish", $$robo$$android_accounts_GrantCredentialsPermissionActivity$finish(), 0, this);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GrantCredentialsPermissionActivity)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

