/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Activity;
import android.app.ActivityManagerInternal;
import android.app.ActivityThread;
import android.app.AppGlobals;
import android.app.IActivityManager;
import android.app.IAppTask;
import android.app.IUidObserver;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.UriPermission;
import android.content.pm.ApplicationInfo;
import android.content.pm.ConfigurationInfo;
import android.content.pm.IPackageDataObserver;
import android.content.pm.ParceledListSlice;
import android.content.pm.UserInfo;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.GraphicBuffer;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Build;
import android.os.Bundle;
import android.os.Debug;
import android.os.Handler;
import android.os.IBinder;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Singleton;
import android.util.Size;
import com.android.internal.os.RoSystemProperties;
import com.android.internal.os.TransferPipe;
import com.android.internal.util.FastPrintWriter;
import com.android.server.LocalServices;
import com.google.errorprone.annotations.DoNotMock;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlSerializer;

public class ActivityManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG;
    private static int gMaxRecentTasks;
    private Context mContext;
    private static volatile boolean sSystemReady;
    private static int FIRST_START_FATAL_ERROR_CODE = -100;
    private static int LAST_START_FATAL_ERROR_CODE = -1;
    private static int FIRST_START_SUCCESS_CODE = 0;
    private static int LAST_START_SUCCESS_CODE = 99;
    private static int FIRST_START_NON_FATAL_ERROR_CODE = 100;
    private static int LAST_START_NON_FATAL_ERROR_CODE = 199;
    public static boolean ENABLE_TASK_SNAPSHOTS;
    ArrayMap<OnUidImportanceListener, UidObserver> mImportanceListeners;
    public static int BUGREPORT_OPTION_FULL = 0;
    public static int BUGREPORT_OPTION_INTERACTIVE = 1;
    public static int BUGREPORT_OPTION_REMOTE = 2;
    public static int BUGREPORT_OPTION_WEAR = 3;
    public static int BUGREPORT_OPTION_TELEPHONY = 4;
    public static String META_HOME_ALTERNATE = "android.app.home.alternate";
    public static int START_VOICE_HIDDEN_SESSION = -100;
    public static int START_VOICE_NOT_ACTIVE_SESSION = -99;
    public static int START_NOT_CURRENT_USER_ACTIVITY = -98;
    public static int START_NOT_VOICE_COMPATIBLE = -97;
    public static int START_CANCELED = -96;
    public static int START_NOT_ACTIVITY = -95;
    public static int START_PERMISSION_DENIED = -94;
    public static int START_FORWARD_AND_REQUEST_CONFLICT = -93;
    public static int START_CLASS_NOT_FOUND = -92;
    public static int START_INTENT_NOT_RESOLVED = -91;
    public static int START_ASSISTANT_HIDDEN_SESSION = -90;
    public static int START_ASSISTANT_NOT_ACTIVE_SESSION = -89;
    public static int START_SUCCESS = 0;
    public static int START_RETURN_INTENT_TO_CALLER = 1;
    public static int START_TASK_TO_FRONT = 2;
    public static int START_DELIVERED_TO_TOP = 3;
    public static int START_SWITCHES_CANCELED = 100;
    public static int START_RETURN_LOCK_TASK_MODE_VIOLATION = 101;
    public static int START_ABORTED = 102;
    public static int START_FLAG_ONLY_IF_NEEDED = 1;
    public static int START_FLAG_DEBUG = 2;
    public static int START_FLAG_TRACK_ALLOCATION = 4;
    public static int START_FLAG_NATIVE_DEBUGGING = 8;
    public static int BROADCAST_SUCCESS = 0;
    public static int BROADCAST_STICKY_CANT_HAVE_PERMISSION = -1;
    public static int BROADCAST_FAILED_USER_STOPPED = -2;
    public static int INTENT_SENDER_BROADCAST = 1;
    public static int INTENT_SENDER_ACTIVITY = 2;
    public static int INTENT_SENDER_ACTIVITY_RESULT = 3;
    public static int INTENT_SENDER_SERVICE = 4;
    public static int INTENT_SENDER_FOREGROUND_SERVICE = 5;
    public static int USER_OP_SUCCESS = 0;
    public static int USER_OP_UNKNOWN_USER = -1;
    public static int USER_OP_IS_CURRENT = -2;
    public static int USER_OP_ERROR_IS_SYSTEM = -3;
    public static int USER_OP_ERROR_RELATED_USERS_CANNOT_STOP = -4;
    public static int PROCESS_STATE_UNKNOWN = -1;
    public static int PROCESS_STATE_PERSISTENT = 0;
    public static int PROCESS_STATE_PERSISTENT_UI = 1;
    public static int PROCESS_STATE_TOP = 2;
    public static int PROCESS_STATE_BOUND_FOREGROUND_SERVICE = 3;
    public static int PROCESS_STATE_FOREGROUND_SERVICE = 4;
    public static int PROCESS_STATE_TOP_SLEEPING = 5;
    public static int PROCESS_STATE_IMPORTANT_FOREGROUND = 6;
    public static int PROCESS_STATE_IMPORTANT_BACKGROUND = 7;
    public static int PROCESS_STATE_TRANSIENT_BACKGROUND = 8;
    public static int PROCESS_STATE_BACKUP = 9;
    public static int PROCESS_STATE_HEAVY_WEIGHT = 10;
    public static int PROCESS_STATE_SERVICE = 11;
    public static int PROCESS_STATE_RECEIVER = 12;
    public static int PROCESS_STATE_HOME = 13;
    public static int PROCESS_STATE_LAST_ACTIVITY = 14;
    public static int PROCESS_STATE_CACHED_ACTIVITY = 15;
    public static int PROCESS_STATE_CACHED_ACTIVITY_CLIENT = 16;
    public static int PROCESS_STATE_CACHED_EMPTY = 17;
    public static int PROCESS_STATE_NONEXISTENT = 18;
    public static int MIN_PROCESS_STATE = 0;
    public static int MAX_PROCESS_STATE = 18;
    public static int ASSIST_CONTEXT_BASIC = 0;
    public static int ASSIST_CONTEXT_FULL = 1;
    public static int ASSIST_CONTEXT_AUTOFILL = 2;
    public static int UID_OBSERVER_PROCSTATE = 1;
    public static int UID_OBSERVER_GONE = 2;
    public static int UID_OBSERVER_IDLE = 4;
    public static int UID_OBSERVER_ACTIVE = 8;
    public static int UID_OBSERVER_CACHED = 16;
    public static int APP_START_MODE_NORMAL = 0;
    public static int APP_START_MODE_DELAYED = 1;
    public static int APP_START_MODE_DELAYED_RIGID = 2;
    public static int APP_START_MODE_DISABLED = 3;
    public static int LOCK_TASK_MODE_NONE = 0;
    public static int LOCK_TASK_MODE_LOCKED = 1;
    public static int LOCK_TASK_MODE_PINNED = 2;
    Point mAppTaskThumbnailSize;
    public static int COMPAT_MODE_ALWAYS = -1;
    public static int COMPAT_MODE_NEVER = -2;
    public static int COMPAT_MODE_UNKNOWN = -3;
    public static int COMPAT_MODE_DISABLED = 0;
    public static int COMPAT_MODE_ENABLED = 1;
    public static int COMPAT_MODE_TOGGLE = 2;
    private static boolean DEVELOPMENT_FORCE_LOW_RAM;
    public static int DOCKED_STACK_CREATE_MODE_TOP_OR_LEFT = 0;
    public static int DOCKED_STACK_CREATE_MODE_BOTTOM_OR_RIGHT = 1;
    public static int RESIZE_MODE_SYSTEM = 0;
    public static int RESIZE_MODE_PRESERVE_WINDOW = 1;
    public static int RESIZE_MODE_FORCED = 2;
    public static int RESIZE_MODE_SYSTEM_SCREEN_ROTATION = 1;
    public static int RESIZE_MODE_USER = 1;
    public static int RESIZE_MODE_USER_FORCED = 3;
    public static int RECENT_WITH_EXCLUDED = 1;
    public static int RECENT_IGNORE_UNAVAILABLE = 2;
    public static int RECENT_INCLUDE_PROFILES = 4;
    public static int RECENT_IGNORE_HOME_AND_RECENTS_STACK_TASKS = 8;
    public static int RECENT_INGORE_DOCKED_STACK_TOP_TASK = 16;
    public static int RECENT_INGORE_PINNED_STACK_TASKS = 32;
    public static int MOVE_TASK_WITH_HOME = 1;
    public static int MOVE_TASK_NO_USER_ACTION = 2;
    public static int FLAG_OR_STOPPED = 1;
    public static int FLAG_AND_LOCKED = 2;
    public static int FLAG_AND_UNLOCKED = 4;
    public static int FLAG_AND_UNLOCKING_OR_UNLOCKED = 8;
    private static Singleton<IActivityManager> IActivityManagerSingleton;
    public static String ACTION_REPORT_HEAP_LIMIT = "android.app.action.REPORT_HEAP_LIMIT";

    private static final boolean $$robo$$android_app_ActivityManager$isProcStateBackground(int procState) {
        return procState >= 8;
    }

    private void $$robo$$android_app_ActivityManager$__constructor__(Context context, Handler handler) {
        this.mImportanceListeners = new ArrayMap();
        this.mContext = context;
    }

    private static final boolean $$robo$$android_app_ActivityManager$isStartResultSuccessful(int result) {
        return 0 <= result && result <= 99;
    }

    private static final boolean $$robo$$android_app_ActivityManager$isStartResultFatalError(int result) {
        return -100 <= result && result <= -1;
    }

    private final int $$robo$$android_app_ActivityManager$getFrontActivityScreenCompatMode() {
        try {
            return ActivityManager.getService().getFrontActivityScreenCompatMode();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ActivityManager$setFrontActivityScreenCompatMode(int mode) {
        try {
            ActivityManager.getService().setFrontActivityScreenCompatMode(mode);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_app_ActivityManager$getPackageScreenCompatMode(String packageName) {
        try {
            return ActivityManager.getService().getPackageScreenCompatMode(packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ActivityManager$setPackageScreenCompatMode(String packageName, int mode) {
        try {
            ActivityManager.getService().setPackageScreenCompatMode(packageName, mode);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_ActivityManager$getPackageAskScreenCompat(String packageName) {
        try {
            return ActivityManager.getService().getPackageAskScreenCompat(packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ActivityManager$setPackageAskScreenCompat(String packageName, boolean ask) {
        try {
            ActivityManager.getService().setPackageAskScreenCompat(packageName, ask);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_app_ActivityManager$getMemoryClass() {
        return ActivityManager.staticGetMemoryClass();
    }

    private static final int $$robo$$android_app_ActivityManager$staticGetMemoryClass() {
        String vmHeapSize = SystemProperties.get("dalvik.vm.heapgrowthlimit", "");
        if (vmHeapSize != null && !"".equals(vmHeapSize)) {
            return Integer.parseInt(vmHeapSize.substring(0, vmHeapSize.length() - 1));
        }
        return ActivityManager.staticGetLargeMemoryClass();
    }

    private final int $$robo$$android_app_ActivityManager$getLargeMemoryClass() {
        return ActivityManager.staticGetLargeMemoryClass();
    }

    private static final int $$robo$$android_app_ActivityManager$staticGetLargeMemoryClass() {
        String vmHeapSize = SystemProperties.get("dalvik.vm.heapsize", "16m");
        return Integer.parseInt(vmHeapSize.substring(0, vmHeapSize.length() - 1));
    }

    private final boolean $$robo$$android_app_ActivityManager$isLowRamDevice() {
        return ActivityManager.isLowRamDeviceStatic();
    }

    private static final boolean $$robo$$android_app_ActivityManager$isLowRamDeviceStatic() {
        return RoSystemProperties.CONFIG_LOW_RAM || Build.IS_DEBUGGABLE && DEVELOPMENT_FORCE_LOW_RAM;
    }

    private static final boolean $$robo$$android_app_ActivityManager$isSmallBatteryDevice() {
        return RoSystemProperties.CONFIG_SMALL_BATTERY;
    }

    private static final boolean $$robo$$android_app_ActivityManager$isHighEndGfx() {
        return !ActivityManager.isLowRamDeviceStatic() && !Resources.getSystem().getBoolean(17956895);
    }

    private static final int $$robo$$android_app_ActivityManager$getMaxRecentTasksStatic() {
        if (gMaxRecentTasks < 0) {
            gMaxRecentTasks = ActivityManager.isLowRamDeviceStatic() ? 36 : 48;
            return gMaxRecentTasks;
        }
        return gMaxRecentTasks;
    }

    private static final int $$robo$$android_app_ActivityManager$getDefaultAppRecentsLimitStatic() {
        return ActivityManager.getMaxRecentTasksStatic() / 6;
    }

    private static final int $$robo$$android_app_ActivityManager$getMaxAppRecentsLimitStatic() {
        return ActivityManager.getMaxRecentTasksStatic() / 2;
    }

    private static final boolean $$robo$$android_app_ActivityManager$supportsMultiWindow(Context context) {
        boolean isWatch = context.getPackageManager().hasSystemFeature("android.hardware.type.watch");
        return (!ActivityManager.isLowRamDeviceStatic() || isWatch) && Resources.getSystem().getBoolean(17957030);
    }

    private static final boolean $$robo$$android_app_ActivityManager$supportsSplitScreenMultiWindow(Context context) {
        return ActivityManager.supportsMultiWindow(context) && Resources.getSystem().getBoolean(17957031);
    }

    @Deprecated
    private static final int $$robo$$android_app_ActivityManager$getMaxNumPictureInPictureActions() {
        return 3;
    }

    @Deprecated
    private final List<RecentTaskInfo> $$robo$$android_app_ActivityManager$getRecentTasks(int maxNum, int flags) throws SecurityException {
        try {
            return ActivityManager.getService().getRecentTasks(maxNum, flags, UserHandle.myUserId()).getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final List<RecentTaskInfo> $$robo$$android_app_ActivityManager$getRecentTasksForUser(int maxNum, int flags, int userId) throws SecurityException {
        try {
            return ActivityManager.getService().getRecentTasks(maxNum, flags, userId).getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final List<AppTask> $$robo$$android_app_ActivityManager$getAppTasks() {
        List<IBinder> appTasks;
        ArrayList<AppTask> tasks = new ArrayList<AppTask>();
        try {
            appTasks = ActivityManager.getService().getAppTasks(this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        int numAppTasks = appTasks.size();
        for (int i = 0; i < numAppTasks; ++i) {
            tasks.add(new AppTask(IAppTask.Stub.asInterface(appTasks.get(i))));
        }
        return tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Size $$robo$$android_app_ActivityManager$getAppTaskThumbnailSize() {
        ActivityManager activityManager = this;
        synchronized (activityManager) {
            this.ensureAppTaskThumbnailSizeLocked();
            return new Size(this.mAppTaskThumbnailSize.x, this.mAppTaskThumbnailSize.y);
        }
    }

    private final void $$robo$$android_app_ActivityManager$ensureAppTaskThumbnailSizeLocked() {
        if (this.mAppTaskThumbnailSize == null) {
            try {
                this.mAppTaskThumbnailSize = ActivityManager.getService().getAppTaskThumbnailSize();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_app_ActivityManager$addAppTask(Activity activity, Intent intent, TaskDescription description, Bitmap thumbnail) {
        Point size;
        ActivityManager activityManager = this;
        synchronized (activityManager) {
            this.ensureAppTaskThumbnailSizeLocked();
            size = this.mAppTaskThumbnailSize;
        }
        int tw = thumbnail.getWidth();
        int th = thumbnail.getHeight();
        if (tw != size.x || th != size.y) {
            float scale;
            Bitmap bm = Bitmap.createBitmap(size.x, size.y, thumbnail.getConfig());
            float dx = 0.0f;
            float dy = 0.0f;
            if (tw * size.x > size.y * th) {
                scale = (float)size.x / (float)th;
                dx = ((float)size.y - (float)tw * scale) * 0.5f;
            } else {
                scale = (float)size.y / (float)tw;
                dy = ((float)size.x - (float)th * scale) * 0.5f;
            }
            Matrix matrix = new Matrix();
            matrix.setScale(scale, scale);
            matrix.postTranslate((int)(dx + 0.5f), 0.0f);
            Canvas canvas = new Canvas(bm);
            canvas.drawBitmap(thumbnail, matrix, null);
            canvas.setBitmap(null);
            thumbnail = bm;
        }
        if (description == null) {
            description = new TaskDescription();
        }
        try {
            return ActivityManager.getService().addAppTask(activity.getActivityToken(), intent, description, thumbnail);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final List<RunningTaskInfo> $$robo$$android_app_ActivityManager$getRunningTasks(int maxNum) throws SecurityException {
        try {
            return ActivityManager.getService().getTasks(maxNum, 0);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_ActivityManager$removeTask(int taskId) throws SecurityException {
        try {
            return ActivityManager.getService().removeTask(taskId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final TaskThumbnail $$robo$$android_app_ActivityManager$getTaskThumbnail(int id2) throws SecurityException {
        try {
            return ActivityManager.getService().getTaskThumbnail(id2);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ActivityManager$moveTaskToFront(int taskId, int flags) {
        this.moveTaskToFront(taskId, flags, null);
    }

    private final void $$robo$$android_app_ActivityManager$moveTaskToFront(int taskId, int flags, Bundle options) {
        try {
            ActivityManager.getService().moveTaskToFront(taskId, flags, options);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final List<RunningServiceInfo> $$robo$$android_app_ActivityManager$getRunningServices(int maxNum) throws SecurityException {
        try {
            return ActivityManager.getService().getServices(maxNum, 0);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final PendingIntent $$robo$$android_app_ActivityManager$getRunningServiceControlPanel(ComponentName service) throws SecurityException {
        try {
            return ActivityManager.getService().getRunningServiceControlPanel(service);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ActivityManager$getMemoryInfo(MemoryInfo outInfo) {
        try {
            ActivityManager.getService().getMemoryInfo(outInfo);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_ActivityManager$clearApplicationUserData(String packageName, IPackageDataObserver observer) {
        try {
            return ActivityManager.getService().clearApplicationUserData(packageName, observer, UserHandle.myUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_ActivityManager$clearApplicationUserData() {
        return this.clearApplicationUserData(this.mContext.getPackageName(), null);
    }

    private final ParceledListSlice<UriPermission> $$robo$$android_app_ActivityManager$getGrantedUriPermissions(String packageName) {
        try {
            return ActivityManager.getService().getGrantedUriPermissions(packageName, UserHandle.myUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ActivityManager$clearGrantedUriPermissions(String packageName) {
        try {
            ActivityManager.getService().clearGrantedUriPermissions(packageName, UserHandle.myUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final List<ProcessErrorStateInfo> $$robo$$android_app_ActivityManager$getProcessesInErrorState() {
        try {
            return ActivityManager.getService().getProcessesInErrorState();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final List<ApplicationInfo> $$robo$$android_app_ActivityManager$getRunningExternalApplications() {
        try {
            return ActivityManager.getService().getRunningExternalApplications();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_ActivityManager$setProcessMemoryTrimLevel(String process, int userId, int level) {
        try {
            return ActivityManager.getService().setProcessMemoryTrimLevel(process, userId, level);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final List<RunningAppProcessInfo> $$robo$$android_app_ActivityManager$getRunningAppProcesses() {
        try {
            return ActivityManager.getService().getRunningAppProcesses();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_app_ActivityManager$getPackageImportance(String packageName) {
        try {
            int procState = ActivityManager.getService().getPackageProcessState(packageName, this.mContext.getOpPackageName());
            return RunningAppProcessInfo.procStateToImportanceForClient(procState, this.mContext);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_app_ActivityManager$getUidImportance(int uid) {
        try {
            int procState = ActivityManager.getService().getUidProcessState(uid, this.mContext.getOpPackageName());
            return RunningAppProcessInfo.procStateToImportanceForClient(procState, this.mContext);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_ActivityManager$addOnUidImportanceListener(OnUidImportanceListener listener, int importanceCutpoint) {
        ActivityManager activityManager = this;
        synchronized (activityManager) {
            if (this.mImportanceListeners.containsKey(listener)) {
                throw new IllegalArgumentException("Listener already registered: " + listener);
            }
            UidObserver observer = new UidObserver(listener, this.mContext);
            try {
                ActivityManager.getService().registerUidObserver(observer, 3, RunningAppProcessInfo.importanceToProcState(importanceCutpoint), this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            this.mImportanceListeners.put(listener, observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_ActivityManager$removeOnUidImportanceListener(OnUidImportanceListener listener) {
        ActivityManager activityManager = this;
        synchronized (activityManager) {
            UidObserver observer = this.mImportanceListeners.remove(listener);
            if (observer == null) {
                throw new IllegalArgumentException("Listener not registered: " + listener);
            }
            try {
                ActivityManager.getService().unregisterUidObserver(observer);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private static final void $$robo$$android_app_ActivityManager$getMyMemoryState(RunningAppProcessInfo outState) {
        try {
            ActivityManager.getService().getMyMemoryState(outState);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final Debug.MemoryInfo[] $$robo$$android_app_ActivityManager$getProcessMemoryInfo(int[] pids) {
        try {
            return ActivityManager.getService().getProcessMemoryInfo(pids);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final void $$robo$$android_app_ActivityManager$restartPackage(String packageName) {
        this.killBackgroundProcesses(packageName);
    }

    private final void $$robo$$android_app_ActivityManager$killBackgroundProcesses(String packageName) {
        try {
            ActivityManager.getService().killBackgroundProcesses(packageName, UserHandle.myUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ActivityManager$killUid(int uid, String reason) {
        try {
            ActivityManager.getService().killUid(UserHandle.getAppId(uid), UserHandle.getUserId(uid), reason);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ActivityManager$forceStopPackageAsUser(String packageName, int userId) {
        try {
            ActivityManager.getService().forceStopPackage(packageName, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ActivityManager$forceStopPackage(String packageName) {
        this.forceStopPackageAsUser(packageName, UserHandle.myUserId());
    }

    private final ConfigurationInfo $$robo$$android_app_ActivityManager$getDeviceConfigurationInfo() {
        try {
            return ActivityManager.getService().getDeviceConfigurationInfo();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_app_ActivityManager$getLauncherLargeIconDensity() {
        Resources res = this.mContext.getResources();
        int density = res.getDisplayMetrics().densityDpi;
        int sw = res.getConfiguration().smallestScreenWidthDp;
        if (sw < 600) {
            return density;
        }
        switch (density) {
            case 120: {
                return 160;
            }
            case 160: {
                return 240;
            }
            case 213: {
                return 320;
            }
            case 240: {
                return 320;
            }
            case 320: {
                return 480;
            }
            case 480: {
                return 640;
            }
        }
        return (int)((float)density * 1.5f + 0.5f);
    }

    private final int $$robo$$android_app_ActivityManager$getLauncherLargeIconSize() {
        return ActivityManager.getLauncherLargeIconSizeInner(this.mContext);
    }

    private static final int $$robo$$android_app_ActivityManager$getLauncherLargeIconSizeInner(Context context) {
        Resources res = context.getResources();
        int size = res.getDimensionPixelSize(0x1050000);
        int sw = res.getConfiguration().smallestScreenWidthDp;
        if (sw < 600) {
            return size;
        }
        int density = res.getDisplayMetrics().densityDpi;
        switch (density) {
            case 120: {
                return size * 160 / 120;
            }
            case 160: {
                return size * 240 / 160;
            }
            case 213: {
                return size * 320 / 240;
            }
            case 240: {
                return size * 320 / 240;
            }
            case 320: {
                return size * 480 / 320;
            }
            case 480: {
                return size * 320 * 2 / 480;
            }
        }
        return (int)((float)size * 1.5f + 0.5f);
    }

    private static final boolean $$robo$$android_app_ActivityManager$isUserAMonkey() {
        try {
            return ActivityManager.getService().isUserAMonkey();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static final boolean $$robo$$android_app_ActivityManager$isRunningInTestHarness() {
        return SystemProperties.getBoolean("ro.test_harness", false);
    }

    private static final int $$robo$$android_app_ActivityManager$checkComponentPermission(String permission2, int uid, int owningUid, boolean exported) {
        int appId = UserHandle.getAppId(uid);
        if (appId == 0 || appId == 1000) {
            return 0;
        }
        if (UserHandle.isIsolated(uid)) {
            return -1;
        }
        if (owningUid >= 0 && UserHandle.isSameApp(uid, owningUid)) {
            return 0;
        }
        if (!exported) {
            return -1;
        }
        if (permission2 == null) {
            return 0;
        }
        try {
            return AppGlobals.getPackageManager().checkUidPermission(permission2, uid);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static final int $$robo$$android_app_ActivityManager$checkUidPermission(String permission2, int uid) {
        try {
            return AppGlobals.getPackageManager().checkUidPermission(permission2, uid);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static final int $$robo$$android_app_ActivityManager$handleIncomingUser(int callingPid, int callingUid, int userId, boolean allowAll, boolean requireFull, String name, String callerPackage) {
        if (UserHandle.getUserId(callingUid) == userId) {
            return userId;
        }
        try {
            return ActivityManager.getService().handleIncomingUser(callingPid, callingUid, userId, allowAll, requireFull, name, callerPackage);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static final int $$robo$$android_app_ActivityManager$getCurrentUser() {
        try {
            UserInfo ui = ActivityManager.getService().getCurrentUser();
            return ui != null ? ui.id : 0;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_ActivityManager$switchUser(int userid) {
        try {
            return ActivityManager.getService().switchUser(userid);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static final void $$robo$$android_app_ActivityManager$logoutCurrentUser() {
        int currentUser = ActivityManager.getCurrentUser();
        if (currentUser != 0) {
            try {
                ActivityManager.getService().switchUser(0);
                ActivityManager.getService().stopUser(currentUser, false, null);
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
            }
        }
    }

    private final boolean $$robo$$android_app_ActivityManager$isUserRunning(int userId) {
        try {
            return ActivityManager.getService().isUserRunning(userId, 0);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_ActivityManager$isVrModePackageEnabled(ComponentName component) {
        try {
            return ActivityManager.getService().isVrModePackageEnabled(component);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ActivityManager$dumpPackageState(FileDescriptor fd, String packageName) {
        ActivityManager.dumpPackageStateStatic(fd, packageName);
    }

    private static final void $$robo$$android_app_ActivityManager$dumpPackageStateStatic(FileDescriptor fd, String packageName) {
        FileOutputStream fout = new FileOutputStream(fd);
        FastPrintWriter pw = new FastPrintWriter(fout);
        ActivityManager.dumpService(pw, fd, "package", new String[]{packageName});
        ((PrintWriter)pw).println();
        ActivityManager.dumpService(pw, fd, "activity", new String[]{"-a", "package", packageName});
        ((PrintWriter)pw).println();
        ActivityManager.dumpService(pw, fd, "meminfo", new String[]{"--local", "--package", packageName});
        ((PrintWriter)pw).println();
        ActivityManager.dumpService(pw, fd, "procstats", new String[]{packageName});
        ((PrintWriter)pw).println();
        ActivityManager.dumpService(pw, fd, "usagestats", new String[]{"--packages", packageName});
        ((PrintWriter)pw).println();
        ActivityManager.dumpService(pw, fd, "batterystats", new String[]{packageName});
        ((PrintWriter)pw).flush();
    }

    private static final boolean $$robo$$android_app_ActivityManager$isSystemReady() {
        if (!sSystemReady) {
            sSystemReady = ActivityThread.isSystem() ? LocalServices.getService(ActivityManagerInternal.class).isSystemReady() : true;
        }
        return sSystemReady;
    }

    private static final void $$robo$$android_app_ActivityManager$broadcastStickyIntent(Intent intent, int userId) {
        ActivityManager.broadcastStickyIntent(intent, -1, userId);
    }

    private static final void $$robo$$android_app_ActivityManager$broadcastStickyIntent(Intent intent, int appOp, int userId) {
        try {
            ActivityManager.getService().broadcastIntent(null, intent, null, null, -1, null, null, null, appOp, null, false, true, userId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private static final void $$robo$$android_app_ActivityManager$noteWakeupAlarm(PendingIntent ps, int sourceUid, String sourcePkg, String tag) {
        try {
            ActivityManager.getService().noteWakeupAlarm(ps != null ? ps.getTarget() : null, sourceUid, sourcePkg, tag);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private static final void $$robo$$android_app_ActivityManager$noteAlarmStart(PendingIntent ps, int sourceUid, String tag) {
        try {
            ActivityManager.getService().noteAlarmStart(ps != null ? ps.getTarget() : null, sourceUid, tag);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private static final void $$robo$$android_app_ActivityManager$noteAlarmFinish(PendingIntent ps, int sourceUid, String tag) {
        try {
            ActivityManager.getService().noteAlarmFinish(ps != null ? ps.getTarget() : null, sourceUid, tag);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private static final IActivityManager $$robo$$android_app_ActivityManager$getService() {
        return IActivityManagerSingleton.get();
    }

    private static final void $$robo$$android_app_ActivityManager$dumpService(PrintWriter pw, FileDescriptor fd, String name, String[] args) {
        pw.print("DUMP OF SERVICE ");
        pw.print(name);
        pw.println(":");
        IBinder service = ServiceManager.checkService(name);
        if (service == null) {
            pw.println("  (Service not found)");
            return;
        }
        TransferPipe tp = null;
        try {
            pw.flush();
            tp = new TransferPipe();
            tp.setBufferPrefix("  ");
            service.dumpAsync(tp.getWriteFd().getFileDescriptor(), args);
            tp.go(fd, 10000L);
        }
        catch (Throwable e) {
            if (tp != null) {
                tp.kill();
            }
            pw.println("Failure dumping service:");
            e.printStackTrace(pw);
        }
    }

    private final void $$robo$$android_app_ActivityManager$setWatchHeapLimit(long pssSize) {
        try {
            ActivityManager.getService().setDumpHeapDebugLimit(null, 0, pssSize, this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ActivityManager$clearWatchHeapLimit() {
        try {
            ActivityManager.getService().setDumpHeapDebugLimit(null, 0, 0L, null);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ActivityManager$startLockTaskMode(int taskId) {
        try {
            ActivityManager.getService().startLockTaskModeById(taskId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ActivityManager$stopLockTaskMode() {
        try {
            ActivityManager.getService().stopLockTaskMode();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final boolean $$robo$$android_app_ActivityManager$isInLockTaskMode() {
        return this.getLockTaskModeState() != 0;
    }

    private final int $$robo$$android_app_ActivityManager$getLockTaskModeState() {
        try {
            return ActivityManager.getService().getLockTaskModeState();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static final void $$robo$$android_app_ActivityManager$setVrThread(int tid) {
        try {
            ActivityManager.getService().setVrThread(tid);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private static final void $$robo$$android_app_ActivityManager$setPersistentVrThread(int tid) {
        try {
            ActivityManager.getService().setPersistentVrThread(tid);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    static void __staticInitializer__() {
        TAG = "ActivityManager";
        gMaxRecentTasks = -1;
        sSystemReady = false;
        ENABLE_TASK_SNAPSHOTS = SystemProperties.getBoolean("persist.enable_task_snapshots", true);
        DEVELOPMENT_FORCE_LOW_RAM = SystemProperties.getBoolean("debug.force_low_ram", false);
        IActivityManagerSingleton = new Singleton<IActivityManager>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_app_ActivityManager_1$__constructor__() {
            }

            private final IActivityManager $$robo$$android_app_ActivityManager_1$create() {
                IBinder b = ServiceManager.getService("activity");
                IActivityManager am = IActivityManager.Stub.asInterface(b);
                return am;
            }

            private void __constructor__() {
                this.$$robo$$android_app_ActivityManager_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_1$__constructor__(), 0, this);
            }

            @Override
            protected IActivityManager create() {
                return InvokeDynamicSupport.bootstrap("create", $$robo$$android_app_ActivityManager_1$create(), 0, this);
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    public static boolean isProcStateBackground(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isProcStateBackground", $$robo$$android_app_ActivityManager$isProcStateBackground(int ), 0, (int)n);
    }

    private void __constructor__(Context context, Handler handler) {
        this.$$robo$$android_app_ActivityManager$__constructor__(context, handler);
    }

    ActivityManager(Context context, Handler handler) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager$__constructor__(android.content.Context android.os.Handler ), 0, this, context, handler);
    }

    public static boolean isStartResultSuccessful(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isStartResultSuccessful", $$robo$$android_app_ActivityManager$isStartResultSuccessful(int ), 0, (int)n);
    }

    public static boolean isStartResultFatalError(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isStartResultFatalError", $$robo$$android_app_ActivityManager$isStartResultFatalError(int ), 0, (int)n);
    }

    public int getFrontActivityScreenCompatMode() {
        return (int)InvokeDynamicSupport.bootstrap("getFrontActivityScreenCompatMode", $$robo$$android_app_ActivityManager$getFrontActivityScreenCompatMode(), 0, this);
    }

    public void setFrontActivityScreenCompatMode(int n) {
        InvokeDynamicSupport.bootstrap("setFrontActivityScreenCompatMode", $$robo$$android_app_ActivityManager$setFrontActivityScreenCompatMode(int ), 0, this, n);
    }

    public int getPackageScreenCompatMode(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("getPackageScreenCompatMode", $$robo$$android_app_ActivityManager$getPackageScreenCompatMode(java.lang.String ), 0, this, string2);
    }

    public void setPackageScreenCompatMode(String string2, int n) {
        InvokeDynamicSupport.bootstrap("setPackageScreenCompatMode", $$robo$$android_app_ActivityManager$setPackageScreenCompatMode(java.lang.String int ), 0, this, string2, n);
    }

    public boolean getPackageAskScreenCompat(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("getPackageAskScreenCompat", $$robo$$android_app_ActivityManager$getPackageAskScreenCompat(java.lang.String ), 0, this, string2);
    }

    public void setPackageAskScreenCompat(String string2, boolean bl) {
        InvokeDynamicSupport.bootstrap("setPackageAskScreenCompat", $$robo$$android_app_ActivityManager$setPackageAskScreenCompat(java.lang.String boolean ), 0, this, string2, bl);
    }

    public int getMemoryClass() {
        return (int)InvokeDynamicSupport.bootstrap("getMemoryClass", $$robo$$android_app_ActivityManager$getMemoryClass(), 0, this);
    }

    public static int staticGetMemoryClass() {
        return (int)InvokeDynamicSupport.bootstrapStatic("staticGetMemoryClass", $$robo$$android_app_ActivityManager$staticGetMemoryClass(), 0);
    }

    public int getLargeMemoryClass() {
        return (int)InvokeDynamicSupport.bootstrap("getLargeMemoryClass", $$robo$$android_app_ActivityManager$getLargeMemoryClass(), 0, this);
    }

    public static int staticGetLargeMemoryClass() {
        return (int)InvokeDynamicSupport.bootstrapStatic("staticGetLargeMemoryClass", $$robo$$android_app_ActivityManager$staticGetLargeMemoryClass(), 0);
    }

    public boolean isLowRamDevice() {
        return (boolean)InvokeDynamicSupport.bootstrap("isLowRamDevice", $$robo$$android_app_ActivityManager$isLowRamDevice(), 0, this);
    }

    public static boolean isLowRamDeviceStatic() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isLowRamDeviceStatic", $$robo$$android_app_ActivityManager$isLowRamDeviceStatic(), 0);
    }

    public static boolean isSmallBatteryDevice() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSmallBatteryDevice", $$robo$$android_app_ActivityManager$isSmallBatteryDevice(), 0);
    }

    public static boolean isHighEndGfx() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isHighEndGfx", $$robo$$android_app_ActivityManager$isHighEndGfx(), 0);
    }

    public static int getMaxRecentTasksStatic() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getMaxRecentTasksStatic", $$robo$$android_app_ActivityManager$getMaxRecentTasksStatic(), 0);
    }

    public static int getDefaultAppRecentsLimitStatic() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getDefaultAppRecentsLimitStatic", $$robo$$android_app_ActivityManager$getDefaultAppRecentsLimitStatic(), 0);
    }

    public static int getMaxAppRecentsLimitStatic() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getMaxAppRecentsLimitStatic", $$robo$$android_app_ActivityManager$getMaxAppRecentsLimitStatic(), 0);
    }

    public static boolean supportsMultiWindow(Context context) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("supportsMultiWindow", $$robo$$android_app_ActivityManager$supportsMultiWindow(android.content.Context ), 0, (Context)context);
    }

    public static boolean supportsSplitScreenMultiWindow(Context context) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("supportsSplitScreenMultiWindow", $$robo$$android_app_ActivityManager$supportsSplitScreenMultiWindow(android.content.Context ), 0, (Context)context);
    }

    @Deprecated
    public static int getMaxNumPictureInPictureActions() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getMaxNumPictureInPictureActions", $$robo$$android_app_ActivityManager$getMaxNumPictureInPictureActions(), 0);
    }

    @Deprecated
    public List<RecentTaskInfo> getRecentTasks(int n, int n2) throws SecurityException {
        return InvokeDynamicSupport.bootstrap("getRecentTasks", $$robo$$android_app_ActivityManager$getRecentTasks(int int ), 0, this, n, n2);
    }

    public List<RecentTaskInfo> getRecentTasksForUser(int n, int n2, int n3) throws SecurityException {
        return InvokeDynamicSupport.bootstrap("getRecentTasksForUser", $$robo$$android_app_ActivityManager$getRecentTasksForUser(int int int ), 0, this, n, n2, n3);
    }

    public List<AppTask> getAppTasks() {
        return InvokeDynamicSupport.bootstrap("getAppTasks", $$robo$$android_app_ActivityManager$getAppTasks(), 0, this);
    }

    public Size getAppTaskThumbnailSize() {
        return InvokeDynamicSupport.bootstrap("getAppTaskThumbnailSize", $$robo$$android_app_ActivityManager$getAppTaskThumbnailSize(), 0, this);
    }

    private void ensureAppTaskThumbnailSizeLocked() {
        InvokeDynamicSupport.bootstrap("ensureAppTaskThumbnailSizeLocked", $$robo$$android_app_ActivityManager$ensureAppTaskThumbnailSizeLocked(), 0, this);
    }

    public int addAppTask(Activity activity, Intent intent, TaskDescription taskDescription, Bitmap bitmap) {
        return (int)InvokeDynamicSupport.bootstrap("addAppTask", $$robo$$android_app_ActivityManager$addAppTask(android.app.Activity android.content.Intent android.app.ActivityManager$TaskDescription android.graphics.Bitmap ), 0, this, activity, intent, taskDescription, bitmap);
    }

    @Deprecated
    public List<RunningTaskInfo> getRunningTasks(int n) throws SecurityException {
        return InvokeDynamicSupport.bootstrap("getRunningTasks", $$robo$$android_app_ActivityManager$getRunningTasks(int ), 0, this, n);
    }

    public boolean removeTask(int n) throws SecurityException {
        return (boolean)InvokeDynamicSupport.bootstrap("removeTask", $$robo$$android_app_ActivityManager$removeTask(int ), 0, this, n);
    }

    public TaskThumbnail getTaskThumbnail(int n) throws SecurityException {
        return InvokeDynamicSupport.bootstrap("getTaskThumbnail", $$robo$$android_app_ActivityManager$getTaskThumbnail(int ), 0, this, n);
    }

    public void moveTaskToFront(int n, int n2) {
        InvokeDynamicSupport.bootstrap("moveTaskToFront", $$robo$$android_app_ActivityManager$moveTaskToFront(int int ), 0, this, n, n2);
    }

    public void moveTaskToFront(int n, int n2, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("moveTaskToFront", $$robo$$android_app_ActivityManager$moveTaskToFront(int int android.os.Bundle ), 0, this, n, n2, bundle);
    }

    @Deprecated
    public List<RunningServiceInfo> getRunningServices(int n) throws SecurityException {
        return InvokeDynamicSupport.bootstrap("getRunningServices", $$robo$$android_app_ActivityManager$getRunningServices(int ), 0, this, n);
    }

    public PendingIntent getRunningServiceControlPanel(ComponentName componentName) throws SecurityException {
        return InvokeDynamicSupport.bootstrap("getRunningServiceControlPanel", $$robo$$android_app_ActivityManager$getRunningServiceControlPanel(android.content.ComponentName ), 0, this, componentName);
    }

    public void getMemoryInfo(MemoryInfo memoryInfo) {
        InvokeDynamicSupport.bootstrap("getMemoryInfo", $$robo$$android_app_ActivityManager$getMemoryInfo(android.app.ActivityManager$MemoryInfo ), 0, this, memoryInfo);
    }

    public boolean clearApplicationUserData(String string2, IPackageDataObserver iPackageDataObserver) {
        return (boolean)InvokeDynamicSupport.bootstrap("clearApplicationUserData", $$robo$$android_app_ActivityManager$clearApplicationUserData(java.lang.String android.content.pm.IPackageDataObserver ), 0, this, string2, iPackageDataObserver);
    }

    public boolean clearApplicationUserData() {
        return (boolean)InvokeDynamicSupport.bootstrap("clearApplicationUserData", $$robo$$android_app_ActivityManager$clearApplicationUserData(), 0, this);
    }

    public ParceledListSlice<UriPermission> getGrantedUriPermissions(String string2) {
        return InvokeDynamicSupport.bootstrap("getGrantedUriPermissions", $$robo$$android_app_ActivityManager$getGrantedUriPermissions(java.lang.String ), 0, this, string2);
    }

    public void clearGrantedUriPermissions(String string2) {
        InvokeDynamicSupport.bootstrap("clearGrantedUriPermissions", $$robo$$android_app_ActivityManager$clearGrantedUriPermissions(java.lang.String ), 0, this, string2);
    }

    public List<ProcessErrorStateInfo> getProcessesInErrorState() {
        return InvokeDynamicSupport.bootstrap("getProcessesInErrorState", $$robo$$android_app_ActivityManager$getProcessesInErrorState(), 0, this);
    }

    public List<ApplicationInfo> getRunningExternalApplications() {
        return InvokeDynamicSupport.bootstrap("getRunningExternalApplications", $$robo$$android_app_ActivityManager$getRunningExternalApplications(), 0, this);
    }

    public boolean setProcessMemoryTrimLevel(String string2, int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setProcessMemoryTrimLevel", $$robo$$android_app_ActivityManager$setProcessMemoryTrimLevel(java.lang.String int int ), 0, this, string2, n, n2);
    }

    public List<RunningAppProcessInfo> getRunningAppProcesses() {
        return InvokeDynamicSupport.bootstrap("getRunningAppProcesses", $$robo$$android_app_ActivityManager$getRunningAppProcesses(), 0, this);
    }

    public int getPackageImportance(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("getPackageImportance", $$robo$$android_app_ActivityManager$getPackageImportance(java.lang.String ), 0, this, string2);
    }

    public int getUidImportance(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getUidImportance", $$robo$$android_app_ActivityManager$getUidImportance(int ), 0, this, n);
    }

    public void addOnUidImportanceListener(OnUidImportanceListener onUidImportanceListener, int n) {
        InvokeDynamicSupport.bootstrap("addOnUidImportanceListener", $$robo$$android_app_ActivityManager$addOnUidImportanceListener(android.app.ActivityManager$OnUidImportanceListener int ), 0, this, onUidImportanceListener, n);
    }

    public void removeOnUidImportanceListener(OnUidImportanceListener onUidImportanceListener) {
        InvokeDynamicSupport.bootstrap("removeOnUidImportanceListener", $$robo$$android_app_ActivityManager$removeOnUidImportanceListener(android.app.ActivityManager$OnUidImportanceListener ), 0, this, onUidImportanceListener);
    }

    public static void getMyMemoryState(RunningAppProcessInfo runningAppProcessInfo) {
        InvokeDynamicSupport.bootstrapStatic("getMyMemoryState", $$robo$$android_app_ActivityManager$getMyMemoryState(android.app.ActivityManager$RunningAppProcessInfo ), 0, (RunningAppProcessInfo)runningAppProcessInfo);
    }

    public Debug.MemoryInfo[] getProcessMemoryInfo(int[] nArray) {
        return InvokeDynamicSupport.bootstrap("getProcessMemoryInfo", $$robo$$android_app_ActivityManager$getProcessMemoryInfo(int[] ), 0, this, nArray);
    }

    @Deprecated
    public void restartPackage(String string2) {
        InvokeDynamicSupport.bootstrap("restartPackage", $$robo$$android_app_ActivityManager$restartPackage(java.lang.String ), 0, this, string2);
    }

    public void killBackgroundProcesses(String string2) {
        InvokeDynamicSupport.bootstrap("killBackgroundProcesses", $$robo$$android_app_ActivityManager$killBackgroundProcesses(java.lang.String ), 0, this, string2);
    }

    public void killUid(int n, String string2) {
        InvokeDynamicSupport.bootstrap("killUid", $$robo$$android_app_ActivityManager$killUid(int java.lang.String ), 0, this, n, string2);
    }

    public void forceStopPackageAsUser(String string2, int n) {
        InvokeDynamicSupport.bootstrap("forceStopPackageAsUser", $$robo$$android_app_ActivityManager$forceStopPackageAsUser(java.lang.String int ), 0, this, string2, n);
    }

    public void forceStopPackage(String string2) {
        InvokeDynamicSupport.bootstrap("forceStopPackage", $$robo$$android_app_ActivityManager$forceStopPackage(java.lang.String ), 0, this, string2);
    }

    public ConfigurationInfo getDeviceConfigurationInfo() {
        return InvokeDynamicSupport.bootstrap("getDeviceConfigurationInfo", $$robo$$android_app_ActivityManager$getDeviceConfigurationInfo(), 0, this);
    }

    public int getLauncherLargeIconDensity() {
        return (int)InvokeDynamicSupport.bootstrap("getLauncherLargeIconDensity", $$robo$$android_app_ActivityManager$getLauncherLargeIconDensity(), 0, this);
    }

    public int getLauncherLargeIconSize() {
        return (int)InvokeDynamicSupport.bootstrap("getLauncherLargeIconSize", $$robo$$android_app_ActivityManager$getLauncherLargeIconSize(), 0, this);
    }

    static int getLauncherLargeIconSizeInner(Context context) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getLauncherLargeIconSizeInner", $$robo$$android_app_ActivityManager$getLauncherLargeIconSizeInner(android.content.Context ), 0, (Context)context);
    }

    public static boolean isUserAMonkey() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isUserAMonkey", $$robo$$android_app_ActivityManager$isUserAMonkey(), 0);
    }

    public static boolean isRunningInTestHarness() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isRunningInTestHarness", $$robo$$android_app_ActivityManager$isRunningInTestHarness(), 0);
    }

    public static int checkComponentPermission(String string2, int n, int n2, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrapStatic("checkComponentPermission", $$robo$$android_app_ActivityManager$checkComponentPermission(java.lang.String int int boolean ), 0, (String)string2, (int)n, (int)n2, (boolean)bl);
    }

    public static int checkUidPermission(String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("checkUidPermission", $$robo$$android_app_ActivityManager$checkUidPermission(java.lang.String int ), 0, (String)string2, (int)n);
    }

    public static int handleIncomingUser(int n, int n2, int n3, boolean bl, boolean bl2, String string2, String string3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("handleIncomingUser", $$robo$$android_app_ActivityManager$handleIncomingUser(int int int boolean boolean java.lang.String java.lang.String ), 0, (int)n, (int)n2, (int)n3, (boolean)bl, (boolean)bl2, (String)string2, (String)string3);
    }

    public static int getCurrentUser() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getCurrentUser", $$robo$$android_app_ActivityManager$getCurrentUser(), 0);
    }

    public boolean switchUser(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("switchUser", $$robo$$android_app_ActivityManager$switchUser(int ), 0, this, n);
    }

    public static void logoutCurrentUser() {
        InvokeDynamicSupport.bootstrapStatic("logoutCurrentUser", $$robo$$android_app_ActivityManager$logoutCurrentUser(), 0);
    }

    public boolean isUserRunning(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isUserRunning", $$robo$$android_app_ActivityManager$isUserRunning(int ), 0, this, n);
    }

    public boolean isVrModePackageEnabled(ComponentName componentName) {
        return (boolean)InvokeDynamicSupport.bootstrap("isVrModePackageEnabled", $$robo$$android_app_ActivityManager$isVrModePackageEnabled(android.content.ComponentName ), 0, this, componentName);
    }

    public void dumpPackageState(FileDescriptor fileDescriptor, String string2) {
        InvokeDynamicSupport.bootstrap("dumpPackageState", $$robo$$android_app_ActivityManager$dumpPackageState(java.io.FileDescriptor java.lang.String ), 0, this, fileDescriptor, string2);
    }

    public static void dumpPackageStateStatic(FileDescriptor fileDescriptor, String string2) {
        InvokeDynamicSupport.bootstrapStatic("dumpPackageStateStatic", $$robo$$android_app_ActivityManager$dumpPackageStateStatic(java.io.FileDescriptor java.lang.String ), 0, (FileDescriptor)fileDescriptor, (String)string2);
    }

    public static boolean isSystemReady() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSystemReady", $$robo$$android_app_ActivityManager$isSystemReady(), 0);
    }

    public static void broadcastStickyIntent(Intent intent, int n) {
        InvokeDynamicSupport.bootstrapStatic("broadcastStickyIntent", $$robo$$android_app_ActivityManager$broadcastStickyIntent(android.content.Intent int ), 0, (Intent)intent, (int)n);
    }

    public static void broadcastStickyIntent(Intent intent, int n, int n2) {
        InvokeDynamicSupport.bootstrapStatic("broadcastStickyIntent", $$robo$$android_app_ActivityManager$broadcastStickyIntent(android.content.Intent int int ), 0, (Intent)intent, (int)n, (int)n2);
    }

    public static void noteWakeupAlarm(PendingIntent pendingIntent, int n, String string2, String string3) {
        InvokeDynamicSupport.bootstrapStatic("noteWakeupAlarm", $$robo$$android_app_ActivityManager$noteWakeupAlarm(android.app.PendingIntent int java.lang.String java.lang.String ), 0, (PendingIntent)pendingIntent, (int)n, (String)string2, (String)string3);
    }

    public static void noteAlarmStart(PendingIntent pendingIntent, int n, String string2) {
        InvokeDynamicSupport.bootstrapStatic("noteAlarmStart", $$robo$$android_app_ActivityManager$noteAlarmStart(android.app.PendingIntent int java.lang.String ), 0, (PendingIntent)pendingIntent, (int)n, (String)string2);
    }

    public static void noteAlarmFinish(PendingIntent pendingIntent, int n, String string2) {
        InvokeDynamicSupport.bootstrapStatic("noteAlarmFinish", $$robo$$android_app_ActivityManager$noteAlarmFinish(android.app.PendingIntent int java.lang.String ), 0, (PendingIntent)pendingIntent, (int)n, (String)string2);
    }

    public static IActivityManager getService() {
        return InvokeDynamicSupport.bootstrapStatic("getService", $$robo$$android_app_ActivityManager$getService(), 0);
    }

    private static void dumpService(PrintWriter printWriter, FileDescriptor fileDescriptor, String string2, String[] stringArray) {
        InvokeDynamicSupport.bootstrapStatic("dumpService", $$robo$$android_app_ActivityManager$dumpService(java.io.PrintWriter java.io.FileDescriptor java.lang.String java.lang.String[] ), 0, (PrintWriter)printWriter, (FileDescriptor)fileDescriptor, (String)string2, (String[])stringArray);
    }

    public void setWatchHeapLimit(long l) {
        InvokeDynamicSupport.bootstrap("setWatchHeapLimit", $$robo$$android_app_ActivityManager$setWatchHeapLimit(long ), 0, this, l);
    }

    public void clearWatchHeapLimit() {
        InvokeDynamicSupport.bootstrap("clearWatchHeapLimit", $$robo$$android_app_ActivityManager$clearWatchHeapLimit(), 0, this);
    }

    public void startLockTaskMode(int n) {
        InvokeDynamicSupport.bootstrap("startLockTaskMode", $$robo$$android_app_ActivityManager$startLockTaskMode(int ), 0, this, n);
    }

    public void stopLockTaskMode() {
        InvokeDynamicSupport.bootstrap("stopLockTaskMode", $$robo$$android_app_ActivityManager$stopLockTaskMode(), 0, this);
    }

    @Deprecated
    public boolean isInLockTaskMode() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInLockTaskMode", $$robo$$android_app_ActivityManager$isInLockTaskMode(), 0, this);
    }

    public int getLockTaskModeState() {
        return (int)InvokeDynamicSupport.bootstrap("getLockTaskModeState", $$robo$$android_app_ActivityManager$getLockTaskModeState(), 0, this);
    }

    public static void setVrThread(int n) {
        InvokeDynamicSupport.bootstrapStatic("setVrThread", $$robo$$android_app_ActivityManager$setVrThread(int ), 0, (int)n);
    }

    public static void setPersistentVrThread(int n) {
        InvokeDynamicSupport.bootstrapStatic("setPersistentVrThread", $$robo$$android_app_ActivityManager$setPersistentVrThread(int ), 0, (int)n);
    }

    static {
        RobolectricInternals.classInitializing(ActivityManager.class);
    }

    public /* synthetic */ ActivityManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ActivityManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class AppTask
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private IAppTask mAppTaskImpl;

        private void $$robo$$android_app_ActivityManager_AppTask$__constructor__(IAppTask task) {
            this.mAppTaskImpl = task;
        }

        private final void $$robo$$android_app_ActivityManager_AppTask$finishAndRemoveTask() {
            try {
                this.mAppTaskImpl.finishAndRemoveTask();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        private final RecentTaskInfo $$robo$$android_app_ActivityManager_AppTask$getTaskInfo() {
            try {
                return this.mAppTaskImpl.getTaskInfo();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        private final void $$robo$$android_app_ActivityManager_AppTask$moveToFront() {
            try {
                this.mAppTaskImpl.moveToFront();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        private final void $$robo$$android_app_ActivityManager_AppTask$startActivity(Context context, Intent intent, Bundle options) {
            ActivityThread thread = ActivityThread.currentActivityThread();
            thread.getInstrumentation().execStartActivityFromAppTask(context, thread.getApplicationThread(), this.mAppTaskImpl, intent, options);
        }

        private final void $$robo$$android_app_ActivityManager_AppTask$setExcludeFromRecents(boolean exclude) {
            try {
                this.mAppTaskImpl.setExcludeFromRecents(exclude);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        private void __constructor__(IAppTask iAppTask) {
            this.$$robo$$android_app_ActivityManager_AppTask$__constructor__(iAppTask);
        }

        public AppTask(IAppTask iAppTask) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_AppTask$__constructor__(android.app.IAppTask ), 0, this, iAppTask);
        }

        public void finishAndRemoveTask() {
            InvokeDynamicSupport.bootstrap("finishAndRemoveTask", $$robo$$android_app_ActivityManager_AppTask$finishAndRemoveTask(), 0, this);
        }

        public RecentTaskInfo getTaskInfo() {
            return InvokeDynamicSupport.bootstrap("getTaskInfo", $$robo$$android_app_ActivityManager_AppTask$getTaskInfo(), 0, this);
        }

        public void moveToFront() {
            InvokeDynamicSupport.bootstrap("moveToFront", $$robo$$android_app_ActivityManager_AppTask$moveToFront(), 0, this);
        }

        public void startActivity(Context context, Intent intent, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("startActivity", $$robo$$android_app_ActivityManager_AppTask$startActivity(android.content.Context android.content.Intent android.os.Bundle ), 0, this, context, intent, bundle);
        }

        public void setExcludeFromRecents(boolean bl) {
            InvokeDynamicSupport.bootstrap("setExcludeFromRecents", $$robo$$android_app_ActivityManager_AppTask$setExcludeFromRecents(boolean ), 0, this, bl);
        }

        public /* synthetic */ AppTask() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AppTask)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnUidImportanceListener
    extends InstrumentedInterface {
        public void onUidImportance(int var1, int var2);
    }

    public static class RunningAppProcessInfo
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public String processName;
        public int pid;
        public int uid;
        public String[] pkgList;
        public static int FLAG_CANT_SAVE_STATE = 1;
        public static int FLAG_PERSISTENT = 2;
        public static int FLAG_HAS_ACTIVITIES = 4;
        public int flags;
        public int lastTrimLevel;
        public static int IMPORTANCE_FOREGROUND = 100;
        public static int IMPORTANCE_FOREGROUND_SERVICE = 125;
        public static int IMPORTANCE_TOP_SLEEPING = 150;
        public static int IMPORTANCE_VISIBLE = 200;
        public static int IMPORTANCE_PERCEPTIBLE_PRE_26 = 130;
        public static int IMPORTANCE_PERCEPTIBLE = 230;
        public static int IMPORTANCE_CANT_SAVE_STATE_PRE_26 = 170;
        public static int IMPORTANCE_CANT_SAVE_STATE = 270;
        public static int IMPORTANCE_SERVICE = 300;
        public static int IMPORTANCE_CACHED = 400;
        public static int IMPORTANCE_BACKGROUND = 400;
        @Deprecated
        public static int IMPORTANCE_EMPTY = 500;
        public static int IMPORTANCE_GONE = 1000;
        public int importance;
        public int lru;
        public static int REASON_UNKNOWN = 0;
        public static int REASON_PROVIDER_IN_USE = 1;
        public static int REASON_SERVICE_IN_USE = 2;
        public int importanceReasonCode;
        public int importanceReasonPid;
        public ComponentName importanceReasonComponent;
        public int importanceReasonImportance;
        public int processState;
        public static Parcelable.Creator<RunningAppProcessInfo> CREATOR;

        private static final int $$robo$$android_app_ActivityManager_RunningAppProcessInfo$procStateToImportance(int procState) {
            if (procState == 18) {
                return 1000;
            }
            if (procState >= 13) {
                return 400;
            }
            if (procState >= 11) {
                return 300;
            }
            if (procState > 10) {
                return 270;
            }
            if (procState >= 8) {
                return 230;
            }
            if (procState >= 6) {
                return 200;
            }
            if (procState >= 5) {
                return 150;
            }
            if (procState >= 4) {
                return 125;
            }
            return 100;
        }

        private static final int $$robo$$android_app_ActivityManager_RunningAppProcessInfo$procStateToImportanceForClient(int procState, Context clientContext) {
            return RunningAppProcessInfo.procStateToImportanceForTargetSdk(procState, clientContext.getApplicationInfo().targetSdkVersion);
        }

        private static final int $$robo$$android_app_ActivityManager_RunningAppProcessInfo$procStateToImportanceForTargetSdk(int procState, int targetSdkVersion) {
            int importance = RunningAppProcessInfo.procStateToImportance(procState);
            if (targetSdkVersion < 26) {
                switch (importance) {
                    case 230: {
                        return 130;
                    }
                    case 270: {
                        return 170;
                    }
                }
            }
            return importance;
        }

        private static final int $$robo$$android_app_ActivityManager_RunningAppProcessInfo$importanceToProcState(int importance) {
            if (importance == 1000) {
                return 18;
            }
            if (importance >= 400) {
                return 13;
            }
            if (importance >= 300) {
                return 11;
            }
            if (importance > 270) {
                return 10;
            }
            if (importance >= 230) {
                return 8;
            }
            if (importance >= 200) {
                return 6;
            }
            if (importance >= 150) {
                return 5;
            }
            if (importance >= 125) {
                return 4;
            }
            return 3;
        }

        private void $$robo$$android_app_ActivityManager_RunningAppProcessInfo$__constructor__() {
            this.importance = 100;
            this.importanceReasonCode = 0;
            this.processState = 6;
        }

        private void $$robo$$android_app_ActivityManager_RunningAppProcessInfo$__constructor__(String pProcessName, int pPid, String[] pArr) {
            this.processName = pProcessName;
            this.pid = pPid;
            this.pkgList = pArr;
        }

        private final int $$robo$$android_app_ActivityManager_RunningAppProcessInfo$describeContents() {
            return 0;
        }

        private final void $$robo$$android_app_ActivityManager_RunningAppProcessInfo$writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.processName);
            dest.writeInt(this.pid);
            dest.writeInt(this.uid);
            dest.writeStringArray(this.pkgList);
            dest.writeInt(this.flags);
            dest.writeInt(this.lastTrimLevel);
            dest.writeInt(this.importance);
            dest.writeInt(this.lru);
            dest.writeInt(this.importanceReasonCode);
            dest.writeInt(this.importanceReasonPid);
            ComponentName.writeToParcel(this.importanceReasonComponent, dest);
            dest.writeInt(this.importanceReasonImportance);
            dest.writeInt(this.processState);
        }

        private final void $$robo$$android_app_ActivityManager_RunningAppProcessInfo$readFromParcel(Parcel source) {
            this.processName = source.readString();
            this.pid = source.readInt();
            this.uid = source.readInt();
            this.pkgList = source.readStringArray();
            this.flags = source.readInt();
            this.lastTrimLevel = source.readInt();
            this.importance = source.readInt();
            this.lru = source.readInt();
            this.importanceReasonCode = source.readInt();
            this.importanceReasonPid = source.readInt();
            this.importanceReasonComponent = ComponentName.readFromParcel(source);
            this.importanceReasonImportance = source.readInt();
            this.processState = source.readInt();
        }

        private void $$robo$$android_app_ActivityManager_RunningAppProcessInfo$__constructor__(Parcel source) {
            this.readFromParcel(source);
        }

        private /* synthetic */ void $$robo$$android_app_ActivityManager_RunningAppProcessInfo$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<RunningAppProcessInfo>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_app_ActivityManager_RunningAppProcessInfo_1$__constructor__() {
                }

                private final RunningAppProcessInfo $$robo$$android_app_ActivityManager_RunningAppProcessInfo_1$createFromParcel(Parcel source) {
                    return new RunningAppProcessInfo(source);
                }

                private final RunningAppProcessInfo[] $$robo$$android_app_ActivityManager_RunningAppProcessInfo_1$newArray(int size) {
                    return new RunningAppProcessInfo[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_app_ActivityManager_RunningAppProcessInfo_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_RunningAppProcessInfo_1$__constructor__(), 0, this);
                }

                @Override
                public RunningAppProcessInfo createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_app_ActivityManager_RunningAppProcessInfo_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public RunningAppProcessInfo[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_app_ActivityManager_RunningAppProcessInfo_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        public static int procStateToImportance(int n) {
            return (int)InvokeDynamicSupport.bootstrapStatic("procStateToImportance", $$robo$$android_app_ActivityManager_RunningAppProcessInfo$procStateToImportance(int ), 0, (int)n);
        }

        public static int procStateToImportanceForClient(int n, Context context) {
            return (int)InvokeDynamicSupport.bootstrapStatic("procStateToImportanceForClient", $$robo$$android_app_ActivityManager_RunningAppProcessInfo$procStateToImportanceForClient(int android.content.Context ), 0, (int)n, (Context)context);
        }

        public static int procStateToImportanceForTargetSdk(int n, int n2) {
            return (int)InvokeDynamicSupport.bootstrapStatic("procStateToImportanceForTargetSdk", $$robo$$android_app_ActivityManager_RunningAppProcessInfo$procStateToImportanceForTargetSdk(int int ), 0, (int)n, (int)n2);
        }

        public static int importanceToProcState(int n) {
            return (int)InvokeDynamicSupport.bootstrapStatic("importanceToProcState", $$robo$$android_app_ActivityManager_RunningAppProcessInfo$importanceToProcState(int ), 0, (int)n);
        }

        private void __constructor__() {
            this.$$robo$$android_app_ActivityManager_RunningAppProcessInfo$__constructor__();
        }

        public RunningAppProcessInfo() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_RunningAppProcessInfo$__constructor__(), 0, this);
        }

        private void __constructor__(String string2, int n, String[] stringArray) {
            this.$$robo$$android_app_ActivityManager_RunningAppProcessInfo$__constructor__(string2, n, stringArray);
        }

        public RunningAppProcessInfo(String string2, int n, String[] stringArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_RunningAppProcessInfo$__constructor__(java.lang.String int java.lang.String[] ), 0, this, string2, n, stringArray);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_app_ActivityManager_RunningAppProcessInfo$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_app_ActivityManager_RunningAppProcessInfo$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        public void readFromParcel(Parcel parcel) {
            InvokeDynamicSupport.bootstrap("readFromParcel", $$robo$$android_app_ActivityManager_RunningAppProcessInfo$readFromParcel(android.os.Parcel ), 0, this, parcel);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_app_ActivityManager_RunningAppProcessInfo$__constructor__(parcel);
        }

        private RunningAppProcessInfo(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_RunningAppProcessInfo$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_app_ActivityManager_RunningAppProcessInfo$__constructor__(parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(RunningAppProcessInfo.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RunningAppProcessInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Importance {
        }
    }

    public static class ProcessErrorStateInfo
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int NO_ERROR = 0;
        public static int CRASHED = 1;
        public static int NOT_RESPONDING = 2;
        public int condition;
        public String processName;
        public int pid;
        public int uid;
        public String tag;
        public String shortMsg;
        public String longMsg;
        public String stackTrace;
        public byte[] crashData;
        public static Parcelable.Creator<ProcessErrorStateInfo> CREATOR;

        private void $$robo$$android_app_ActivityManager_ProcessErrorStateInfo$__constructor__() {
            this.crashData = null;
        }

        private final int $$robo$$android_app_ActivityManager_ProcessErrorStateInfo$describeContents() {
            return 0;
        }

        private final void $$robo$$android_app_ActivityManager_ProcessErrorStateInfo$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.condition);
            dest.writeString(this.processName);
            dest.writeInt(this.pid);
            dest.writeInt(this.uid);
            dest.writeString(this.tag);
            dest.writeString(this.shortMsg);
            dest.writeString(this.longMsg);
            dest.writeString(this.stackTrace);
        }

        private final void $$robo$$android_app_ActivityManager_ProcessErrorStateInfo$readFromParcel(Parcel source) {
            this.condition = source.readInt();
            this.processName = source.readString();
            this.pid = source.readInt();
            this.uid = source.readInt();
            this.tag = source.readString();
            this.shortMsg = source.readString();
            this.longMsg = source.readString();
            this.stackTrace = source.readString();
        }

        private void $$robo$$android_app_ActivityManager_ProcessErrorStateInfo$__constructor__(Parcel source) {
            this.crashData = null;
            this.readFromParcel(source);
        }

        private /* synthetic */ void $$robo$$android_app_ActivityManager_ProcessErrorStateInfo$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<ProcessErrorStateInfo>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_app_ActivityManager_ProcessErrorStateInfo_1$__constructor__() {
                }

                private final ProcessErrorStateInfo $$robo$$android_app_ActivityManager_ProcessErrorStateInfo_1$createFromParcel(Parcel source) {
                    return new ProcessErrorStateInfo(source);
                }

                private final ProcessErrorStateInfo[] $$robo$$android_app_ActivityManager_ProcessErrorStateInfo_1$newArray(int size) {
                    return new ProcessErrorStateInfo[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_app_ActivityManager_ProcessErrorStateInfo_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_ProcessErrorStateInfo_1$__constructor__(), 0, this);
                }

                @Override
                public ProcessErrorStateInfo createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_app_ActivityManager_ProcessErrorStateInfo_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public ProcessErrorStateInfo[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_app_ActivityManager_ProcessErrorStateInfo_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__() {
            this.$$robo$$android_app_ActivityManager_ProcessErrorStateInfo$__constructor__();
        }

        public ProcessErrorStateInfo() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_ProcessErrorStateInfo$__constructor__(), 0, this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_app_ActivityManager_ProcessErrorStateInfo$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_app_ActivityManager_ProcessErrorStateInfo$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        public void readFromParcel(Parcel parcel) {
            InvokeDynamicSupport.bootstrap("readFromParcel", $$robo$$android_app_ActivityManager_ProcessErrorStateInfo$readFromParcel(android.os.Parcel ), 0, this, parcel);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_app_ActivityManager_ProcessErrorStateInfo$__constructor__(parcel);
        }

        private ProcessErrorStateInfo(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_ProcessErrorStateInfo$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_app_ActivityManager_ProcessErrorStateInfo$__constructor__(parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(ProcessErrorStateInfo.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ProcessErrorStateInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class StackInfo
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int stackId;
        public Rect bounds;
        public int[] taskIds;
        public String[] taskNames;
        public Rect[] taskBounds;
        public int[] taskUserIds;
        public ComponentName topActivity;
        public int displayId;
        public int userId;
        public boolean visible;
        public int position;
        public static Parcelable.Creator<StackInfo> CREATOR;

        private final int $$robo$$android_app_ActivityManager_StackInfo$describeContents() {
            return 0;
        }

        private final void $$robo$$android_app_ActivityManager_StackInfo$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.stackId);
            dest.writeInt(this.bounds.left);
            dest.writeInt(this.bounds.top);
            dest.writeInt(this.bounds.right);
            dest.writeInt(this.bounds.bottom);
            dest.writeIntArray(this.taskIds);
            dest.writeStringArray(this.taskNames);
            int boundsCount = this.taskBounds == null ? 0 : this.taskBounds.length;
            dest.writeInt(boundsCount);
            for (int i = 0; i < boundsCount; ++i) {
                dest.writeInt(this.taskBounds[i].left);
                dest.writeInt(this.taskBounds[i].top);
                dest.writeInt(this.taskBounds[i].right);
                dest.writeInt(this.taskBounds[i].bottom);
            }
            dest.writeIntArray(this.taskUserIds);
            dest.writeInt(this.displayId);
            dest.writeInt(this.userId);
            dest.writeInt(this.visible ? 1 : 0);
            dest.writeInt(this.position);
            if (this.topActivity != null) {
                dest.writeInt(1);
                this.topActivity.writeToParcel(dest, 0);
            } else {
                dest.writeInt(0);
            }
        }

        private final void $$robo$$android_app_ActivityManager_StackInfo$readFromParcel(Parcel source) {
            this.stackId = source.readInt();
            this.bounds = new Rect(source.readInt(), source.readInt(), source.readInt(), source.readInt());
            this.taskIds = source.createIntArray();
            this.taskNames = source.createStringArray();
            int boundsCount = source.readInt();
            if (boundsCount > 0) {
                this.taskBounds = new Rect[boundsCount];
                for (int i = 0; i < boundsCount; ++i) {
                    this.taskBounds[i] = new Rect();
                    this.taskBounds[i].set(source.readInt(), source.readInt(), source.readInt(), source.readInt());
                }
            } else {
                this.taskBounds = null;
            }
            this.taskUserIds = source.createIntArray();
            this.displayId = source.readInt();
            this.userId = source.readInt();
            this.visible = source.readInt() > 0;
            this.position = source.readInt();
            if (source.readInt() > 0) {
                this.topActivity = ComponentName.readFromParcel(source);
            }
        }

        private void $$robo$$android_app_ActivityManager_StackInfo$__constructor__() {
            this.bounds = new Rect();
        }

        private void $$robo$$android_app_ActivityManager_StackInfo$__constructor__(Parcel source) {
            this.bounds = new Rect();
            this.readFromParcel(source);
        }

        private final String $$robo$$android_app_ActivityManager_StackInfo$toString(String prefix) {
            StringBuilder sb = new StringBuilder(256);
            sb.append(prefix);
            sb.append("Stack id=");
            sb.append(this.stackId);
            sb.append(" bounds=");
            sb.append(this.bounds.toShortString());
            sb.append(" displayId=");
            sb.append(this.displayId);
            sb.append(" userId=");
            sb.append(this.userId);
            sb.append("\n");
            prefix = prefix + "  ";
            for (int i = 0; i < this.taskIds.length; ++i) {
                sb.append(prefix);
                sb.append("taskId=");
                sb.append(this.taskIds[i]);
                sb.append(": ");
                sb.append(this.taskNames[i]);
                if (this.taskBounds != null) {
                    sb.append(" bounds=");
                    sb.append(this.taskBounds[i].toShortString());
                }
                sb.append(" userId=").append(this.taskUserIds[i]);
                sb.append(" visible=").append(this.visible);
                if (this.topActivity != null) {
                    sb.append(" topActivity=").append(this.topActivity);
                }
                sb.append("\n");
            }
            return sb.toString();
        }

        private final String $$robo$$android_app_ActivityManager_StackInfo$toString() {
            return this.toString("");
        }

        private /* synthetic */ void $$robo$$android_app_ActivityManager_StackInfo$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<StackInfo>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_app_ActivityManager_StackInfo_1$__constructor__() {
                }

                private final StackInfo $$robo$$android_app_ActivityManager_StackInfo_1$createFromParcel(Parcel source) {
                    return new StackInfo(source);
                }

                private final StackInfo[] $$robo$$android_app_ActivityManager_StackInfo_1$newArray(int size) {
                    return new StackInfo[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_app_ActivityManager_StackInfo_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_StackInfo_1$__constructor__(), 0, this);
                }

                @Override
                public StackInfo createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_app_ActivityManager_StackInfo_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public StackInfo[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_app_ActivityManager_StackInfo_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_app_ActivityManager_StackInfo$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_app_ActivityManager_StackInfo$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        public void readFromParcel(Parcel parcel) {
            InvokeDynamicSupport.bootstrap("readFromParcel", $$robo$$android_app_ActivityManager_StackInfo$readFromParcel(android.os.Parcel ), 0, this, parcel);
        }

        private void __constructor__() {
            this.$$robo$$android_app_ActivityManager_StackInfo$__constructor__();
        }

        public StackInfo() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_StackInfo$__constructor__(), 0, this);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_app_ActivityManager_StackInfo$__constructor__(parcel);
        }

        private StackInfo(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_StackInfo$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        public String toString(String string2) {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_app_ActivityManager_StackInfo$toString(java.lang.String ), 0, this, string2);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_app_ActivityManager_StackInfo$toString(), 0, this);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_app_ActivityManager_StackInfo$__constructor__(parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(StackInfo.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StackInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class MemoryInfo
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public long availMem;
        public long totalMem;
        public long threshold;
        public boolean lowMemory;
        public long hiddenAppThreshold;
        public long secondaryServerThreshold;
        public long visibleAppThreshold;
        public long foregroundAppThreshold;
        public static Parcelable.Creator<MemoryInfo> CREATOR;

        private void $$robo$$android_app_ActivityManager_MemoryInfo$__constructor__() {
        }

        private final int $$robo$$android_app_ActivityManager_MemoryInfo$describeContents() {
            return 0;
        }

        private final void $$robo$$android_app_ActivityManager_MemoryInfo$writeToParcel(Parcel dest, int flags) {
            dest.writeLong(this.availMem);
            dest.writeLong(this.totalMem);
            dest.writeLong(this.threshold);
            dest.writeInt(this.lowMemory ? 1 : 0);
            dest.writeLong(this.hiddenAppThreshold);
            dest.writeLong(this.secondaryServerThreshold);
            dest.writeLong(this.visibleAppThreshold);
            dest.writeLong(this.foregroundAppThreshold);
        }

        private final void $$robo$$android_app_ActivityManager_MemoryInfo$readFromParcel(Parcel source) {
            this.availMem = source.readLong();
            this.totalMem = source.readLong();
            this.threshold = source.readLong();
            this.lowMemory = source.readInt() != 0;
            this.hiddenAppThreshold = source.readLong();
            this.secondaryServerThreshold = source.readLong();
            this.visibleAppThreshold = source.readLong();
            this.foregroundAppThreshold = source.readLong();
        }

        private void $$robo$$android_app_ActivityManager_MemoryInfo$__constructor__(Parcel source) {
            this.readFromParcel(source);
        }

        private /* synthetic */ void $$robo$$android_app_ActivityManager_MemoryInfo$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<MemoryInfo>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_app_ActivityManager_MemoryInfo_1$__constructor__() {
                }

                private final MemoryInfo $$robo$$android_app_ActivityManager_MemoryInfo_1$createFromParcel(Parcel source) {
                    return new MemoryInfo(source);
                }

                private final MemoryInfo[] $$robo$$android_app_ActivityManager_MemoryInfo_1$newArray(int size) {
                    return new MemoryInfo[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_app_ActivityManager_MemoryInfo_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_MemoryInfo_1$__constructor__(), 0, this);
                }

                @Override
                public MemoryInfo createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_app_ActivityManager_MemoryInfo_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public MemoryInfo[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_app_ActivityManager_MemoryInfo_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__() {
            this.$$robo$$android_app_ActivityManager_MemoryInfo$__constructor__();
        }

        public MemoryInfo() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_MemoryInfo$__constructor__(), 0, this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_app_ActivityManager_MemoryInfo$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_app_ActivityManager_MemoryInfo$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        public void readFromParcel(Parcel parcel) {
            InvokeDynamicSupport.bootstrap("readFromParcel", $$robo$$android_app_ActivityManager_MemoryInfo$readFromParcel(android.os.Parcel ), 0, this, parcel);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_app_ActivityManager_MemoryInfo$__constructor__(parcel);
        }

        private MemoryInfo(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_MemoryInfo$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_app_ActivityManager_MemoryInfo$__constructor__(parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(MemoryInfo.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MemoryInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class RunningServiceInfo
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public ComponentName service;
        public int pid;
        public int uid;
        public String process;
        public boolean foreground;
        public long activeSince;
        public boolean started;
        public int clientCount;
        public int crashCount;
        public long lastActivityTime;
        public long restarting;
        public static int FLAG_STARTED = 1;
        public static int FLAG_FOREGROUND = 2;
        public static int FLAG_SYSTEM_PROCESS = 4;
        public static int FLAG_PERSISTENT_PROCESS = 8;
        public int flags;
        public String clientPackage;
        public int clientLabel;
        public static Parcelable.Creator<RunningServiceInfo> CREATOR;

        private void $$robo$$android_app_ActivityManager_RunningServiceInfo$__constructor__() {
        }

        private final int $$robo$$android_app_ActivityManager_RunningServiceInfo$describeContents() {
            return 0;
        }

        private final void $$robo$$android_app_ActivityManager_RunningServiceInfo$writeToParcel(Parcel dest, int flags) {
            ComponentName.writeToParcel(this.service, dest);
            dest.writeInt(this.pid);
            dest.writeInt(this.uid);
            dest.writeString(this.process);
            dest.writeInt(this.foreground ? 1 : 0);
            dest.writeLong(this.activeSince);
            dest.writeInt(this.started ? 1 : 0);
            dest.writeInt(this.clientCount);
            dest.writeInt(this.crashCount);
            dest.writeLong(this.lastActivityTime);
            dest.writeLong(this.restarting);
            dest.writeInt(this.flags);
            dest.writeString(this.clientPackage);
            dest.writeInt(this.clientLabel);
        }

        private final void $$robo$$android_app_ActivityManager_RunningServiceInfo$readFromParcel(Parcel source) {
            this.service = ComponentName.readFromParcel(source);
            this.pid = source.readInt();
            this.uid = source.readInt();
            this.process = source.readString();
            this.foreground = source.readInt() != 0;
            this.activeSince = source.readLong();
            this.started = source.readInt() != 0;
            this.clientCount = source.readInt();
            this.crashCount = source.readInt();
            this.lastActivityTime = source.readLong();
            this.restarting = source.readLong();
            this.flags = source.readInt();
            this.clientPackage = source.readString();
            this.clientLabel = source.readInt();
        }

        private void $$robo$$android_app_ActivityManager_RunningServiceInfo$__constructor__(Parcel source) {
            this.readFromParcel(source);
        }

        private /* synthetic */ void $$robo$$android_app_ActivityManager_RunningServiceInfo$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<RunningServiceInfo>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_app_ActivityManager_RunningServiceInfo_1$__constructor__() {
                }

                private final RunningServiceInfo $$robo$$android_app_ActivityManager_RunningServiceInfo_1$createFromParcel(Parcel source) {
                    return new RunningServiceInfo(source);
                }

                private final RunningServiceInfo[] $$robo$$android_app_ActivityManager_RunningServiceInfo_1$newArray(int size) {
                    return new RunningServiceInfo[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_app_ActivityManager_RunningServiceInfo_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_RunningServiceInfo_1$__constructor__(), 0, this);
                }

                @Override
                public RunningServiceInfo createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_app_ActivityManager_RunningServiceInfo_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public RunningServiceInfo[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_app_ActivityManager_RunningServiceInfo_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__() {
            this.$$robo$$android_app_ActivityManager_RunningServiceInfo$__constructor__();
        }

        public RunningServiceInfo() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_RunningServiceInfo$__constructor__(), 0, this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_app_ActivityManager_RunningServiceInfo$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_app_ActivityManager_RunningServiceInfo$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        public void readFromParcel(Parcel parcel) {
            InvokeDynamicSupport.bootstrap("readFromParcel", $$robo$$android_app_ActivityManager_RunningServiceInfo$readFromParcel(android.os.Parcel ), 0, this, parcel);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_app_ActivityManager_RunningServiceInfo$__constructor__(parcel);
        }

        private RunningServiceInfo(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_RunningServiceInfo$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_app_ActivityManager_RunningServiceInfo$__constructor__(parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(RunningServiceInfo.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RunningServiceInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MoveTaskFlags {
    }

    public static class TaskSnapshot
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private GraphicBuffer mSnapshot;
        private int mOrientation;
        private Rect mContentInsets;
        private boolean mReducedResolution;
        private float mScale;
        public static Parcelable.Creator<TaskSnapshot> CREATOR;

        private void $$robo$$android_app_ActivityManager_TaskSnapshot$__constructor__(GraphicBuffer snapshot, int orientation, Rect contentInsets, boolean reducedResolution, float scale) {
            this.mSnapshot = snapshot;
            this.mOrientation = orientation;
            this.mContentInsets = new Rect(contentInsets);
            this.mReducedResolution = reducedResolution;
            this.mScale = scale;
        }

        private void $$robo$$android_app_ActivityManager_TaskSnapshot$__constructor__(Parcel source) {
            this.mSnapshot = (GraphicBuffer)source.readParcelable(null);
            this.mOrientation = source.readInt();
            this.mContentInsets = (Rect)source.readParcelable(null);
            this.mReducedResolution = source.readBoolean();
            this.mScale = source.readFloat();
        }

        private final GraphicBuffer $$robo$$android_app_ActivityManager_TaskSnapshot$getSnapshot() {
            return this.mSnapshot;
        }

        private final int $$robo$$android_app_ActivityManager_TaskSnapshot$getOrientation() {
            return this.mOrientation;
        }

        private final Rect $$robo$$android_app_ActivityManager_TaskSnapshot$getContentInsets() {
            return this.mContentInsets;
        }

        private final boolean $$robo$$android_app_ActivityManager_TaskSnapshot$isReducedResolution() {
            return this.mReducedResolution;
        }

        private final float $$robo$$android_app_ActivityManager_TaskSnapshot$getScale() {
            return this.mScale;
        }

        private final int $$robo$$android_app_ActivityManager_TaskSnapshot$describeContents() {
            return 0;
        }

        private final void $$robo$$android_app_ActivityManager_TaskSnapshot$writeToParcel(Parcel dest, int flags) {
            dest.writeParcelable(this.mSnapshot, 0);
            dest.writeInt(this.mOrientation);
            dest.writeParcelable(this.mContentInsets, 0);
            dest.writeBoolean(this.mReducedResolution);
            dest.writeFloat(this.mScale);
        }

        private final String $$robo$$android_app_ActivityManager_TaskSnapshot$toString() {
            return "TaskSnapshot{mSnapshot=" + this.mSnapshot + " mOrientation=" + this.mOrientation + " mContentInsets=" + this.mContentInsets.toShortString() + " mReducedResolution=" + this.mReducedResolution + " mScale=" + this.mScale;
        }

        private /* synthetic */ void $$robo$$android_app_ActivityManager_TaskSnapshot$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<TaskSnapshot>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_app_ActivityManager_TaskSnapshot_1$__constructor__() {
                }

                private final TaskSnapshot $$robo$$android_app_ActivityManager_TaskSnapshot_1$createFromParcel(Parcel source) {
                    return new TaskSnapshot(source);
                }

                private final TaskSnapshot[] $$robo$$android_app_ActivityManager_TaskSnapshot_1$newArray(int size) {
                    return new TaskSnapshot[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_app_ActivityManager_TaskSnapshot_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_TaskSnapshot_1$__constructor__(), 0, this);
                }

                @Override
                public TaskSnapshot createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_app_ActivityManager_TaskSnapshot_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public TaskSnapshot[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_app_ActivityManager_TaskSnapshot_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(GraphicBuffer graphicBuffer, int n, Rect rect, boolean bl, float f) {
            this.$$robo$$android_app_ActivityManager_TaskSnapshot$__constructor__(graphicBuffer, n, rect, bl, f);
        }

        public TaskSnapshot(GraphicBuffer graphicBuffer, int n, Rect rect, boolean bl, float f) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_TaskSnapshot$__constructor__(android.graphics.GraphicBuffer int android.graphics.Rect boolean float ), 0, this, graphicBuffer, n, rect, bl, f);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_app_ActivityManager_TaskSnapshot$__constructor__(parcel);
        }

        private TaskSnapshot(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_TaskSnapshot$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        public GraphicBuffer getSnapshot() {
            return InvokeDynamicSupport.bootstrap("getSnapshot", $$robo$$android_app_ActivityManager_TaskSnapshot$getSnapshot(), 0, this);
        }

        public int getOrientation() {
            return (int)InvokeDynamicSupport.bootstrap("getOrientation", $$robo$$android_app_ActivityManager_TaskSnapshot$getOrientation(), 0, this);
        }

        public Rect getContentInsets() {
            return InvokeDynamicSupport.bootstrap("getContentInsets", $$robo$$android_app_ActivityManager_TaskSnapshot$getContentInsets(), 0, this);
        }

        public boolean isReducedResolution() {
            return (boolean)InvokeDynamicSupport.bootstrap("isReducedResolution", $$robo$$android_app_ActivityManager_TaskSnapshot$isReducedResolution(), 0, this);
        }

        public float getScale() {
            return (float)InvokeDynamicSupport.bootstrap("getScale", $$robo$$android_app_ActivityManager_TaskSnapshot$getScale(), 0, this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_app_ActivityManager_TaskSnapshot$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_app_ActivityManager_TaskSnapshot$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_app_ActivityManager_TaskSnapshot$toString(), 0, this);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_app_ActivityManager_TaskSnapshot$__constructor__(parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(TaskSnapshot.class);
        }

        public /* synthetic */ TaskSnapshot() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TaskSnapshot)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class TaskThumbnail
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public Bitmap mainThumbnail;
        public ParcelFileDescriptor thumbnailFileDescriptor;
        public TaskThumbnailInfo thumbnailInfo;
        public static Parcelable.Creator<TaskThumbnail> CREATOR;

        private void $$robo$$android_app_ActivityManager_TaskThumbnail$__constructor__() {
        }

        private void $$robo$$android_app_ActivityManager_TaskThumbnail$__constructor__(Parcel source) {
            this.readFromParcel(source);
        }

        private final int $$robo$$android_app_ActivityManager_TaskThumbnail$describeContents() {
            if (this.thumbnailFileDescriptor != null) {
                return this.thumbnailFileDescriptor.describeContents();
            }
            return 0;
        }

        private final void $$robo$$android_app_ActivityManager_TaskThumbnail$writeToParcel(Parcel dest, int flags) {
            if (this.mainThumbnail != null) {
                dest.writeInt(1);
                this.mainThumbnail.writeToParcel(dest, flags);
            } else {
                dest.writeInt(0);
            }
            if (this.thumbnailFileDescriptor != null) {
                dest.writeInt(1);
                this.thumbnailFileDescriptor.writeToParcel(dest, flags);
            } else {
                dest.writeInt(0);
            }
            if (this.thumbnailInfo != null) {
                dest.writeInt(1);
                this.thumbnailInfo.writeToParcel(dest, flags);
            } else {
                dest.writeInt(0);
            }
        }

        private final void $$robo$$android_app_ActivityManager_TaskThumbnail$readFromParcel(Parcel source) {
            this.mainThumbnail = source.readInt() != 0 ? Bitmap.CREATOR.createFromParcel(source) : null;
            this.thumbnailFileDescriptor = source.readInt() != 0 ? ParcelFileDescriptor.CREATOR.createFromParcel(source) : null;
            this.thumbnailInfo = source.readInt() != 0 ? TaskThumbnailInfo.CREATOR.createFromParcel(source) : null;
        }

        private /* synthetic */ void $$robo$$android_app_ActivityManager_TaskThumbnail$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<TaskThumbnail>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_app_ActivityManager_TaskThumbnail_1$__constructor__() {
                }

                private final TaskThumbnail $$robo$$android_app_ActivityManager_TaskThumbnail_1$createFromParcel(Parcel source) {
                    return new TaskThumbnail(source);
                }

                private final TaskThumbnail[] $$robo$$android_app_ActivityManager_TaskThumbnail_1$newArray(int size) {
                    return new TaskThumbnail[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_app_ActivityManager_TaskThumbnail_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_TaskThumbnail_1$__constructor__(), 0, this);
                }

                @Override
                public TaskThumbnail createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_app_ActivityManager_TaskThumbnail_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public TaskThumbnail[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_app_ActivityManager_TaskThumbnail_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__() {
            this.$$robo$$android_app_ActivityManager_TaskThumbnail$__constructor__();
        }

        public TaskThumbnail() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_TaskThumbnail$__constructor__(), 0, this);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_app_ActivityManager_TaskThumbnail$__constructor__(parcel);
        }

        private TaskThumbnail(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_TaskThumbnail$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_app_ActivityManager_TaskThumbnail$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_app_ActivityManager_TaskThumbnail$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        public void readFromParcel(Parcel parcel) {
            InvokeDynamicSupport.bootstrap("readFromParcel", $$robo$$android_app_ActivityManager_TaskThumbnail$readFromParcel(android.os.Parcel ), 0, this, parcel);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_app_ActivityManager_TaskThumbnail$__constructor__(parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(TaskThumbnail.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TaskThumbnail)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class TaskThumbnailInfo
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static String ATTR_TASK_THUMBNAILINFO_PREFIX = "task_thumbnailinfo_";
        private static String ATTR_TASK_WIDTH = "task_thumbnailinfo_task_width";
        private static String ATTR_TASK_HEIGHT = "task_thumbnailinfo_task_height";
        private static String ATTR_SCREEN_ORIENTATION = "task_thumbnailinfo_screen_orientation";
        public int taskWidth;
        public int taskHeight;
        public int screenOrientation;
        public static Parcelable.Creator<TaskThumbnailInfo> CREATOR;

        private void $$robo$$android_app_ActivityManager_TaskThumbnailInfo$__constructor__() {
            this.screenOrientation = 0;
        }

        private void $$robo$$android_app_ActivityManager_TaskThumbnailInfo$__constructor__(Parcel source) {
            this.screenOrientation = 0;
            this.readFromParcel(source);
        }

        private final void $$robo$$android_app_ActivityManager_TaskThumbnailInfo$reset() {
            this.taskWidth = 0;
            this.taskHeight = 0;
            this.screenOrientation = 0;
        }

        private final void $$robo$$android_app_ActivityManager_TaskThumbnailInfo$copyFrom(TaskThumbnailInfo o) {
            this.taskWidth = o.taskWidth;
            this.taskHeight = o.taskHeight;
            this.screenOrientation = o.screenOrientation;
        }

        private final void $$robo$$android_app_ActivityManager_TaskThumbnailInfo$saveToXml(XmlSerializer out) throws IOException {
            out.attribute(null, "task_thumbnailinfo_task_width", Integer.toString(this.taskWidth));
            out.attribute(null, "task_thumbnailinfo_task_height", Integer.toString(this.taskHeight));
            out.attribute(null, "task_thumbnailinfo_screen_orientation", Integer.toString(this.screenOrientation));
        }

        private final void $$robo$$android_app_ActivityManager_TaskThumbnailInfo$restoreFromXml(String attrName, String attrValue) {
            if ("task_thumbnailinfo_task_width".equals(attrName)) {
                this.taskWidth = Integer.parseInt(attrValue);
            } else if ("task_thumbnailinfo_task_height".equals(attrName)) {
                this.taskHeight = Integer.parseInt(attrValue);
            } else if ("task_thumbnailinfo_screen_orientation".equals(attrName)) {
                this.screenOrientation = Integer.parseInt(attrValue);
            }
        }

        private final int $$robo$$android_app_ActivityManager_TaskThumbnailInfo$describeContents() {
            return 0;
        }

        private final void $$robo$$android_app_ActivityManager_TaskThumbnailInfo$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.taskWidth);
            dest.writeInt(this.taskHeight);
            dest.writeInt(this.screenOrientation);
        }

        private final void $$robo$$android_app_ActivityManager_TaskThumbnailInfo$readFromParcel(Parcel source) {
            this.taskWidth = source.readInt();
            this.taskHeight = source.readInt();
            this.screenOrientation = source.readInt();
        }

        private /* synthetic */ void $$robo$$android_app_ActivityManager_TaskThumbnailInfo$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<TaskThumbnailInfo>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_app_ActivityManager_TaskThumbnailInfo_1$__constructor__() {
                }

                private final TaskThumbnailInfo $$robo$$android_app_ActivityManager_TaskThumbnailInfo_1$createFromParcel(Parcel source) {
                    return new TaskThumbnailInfo(source);
                }

                private final TaskThumbnailInfo[] $$robo$$android_app_ActivityManager_TaskThumbnailInfo_1$newArray(int size) {
                    return new TaskThumbnailInfo[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_app_ActivityManager_TaskThumbnailInfo_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_TaskThumbnailInfo_1$__constructor__(), 0, this);
                }

                @Override
                public TaskThumbnailInfo createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_app_ActivityManager_TaskThumbnailInfo_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public TaskThumbnailInfo[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_app_ActivityManager_TaskThumbnailInfo_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__() {
            this.$$robo$$android_app_ActivityManager_TaskThumbnailInfo$__constructor__();
        }

        public TaskThumbnailInfo() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_TaskThumbnailInfo$__constructor__(), 0, this);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_app_ActivityManager_TaskThumbnailInfo$__constructor__(parcel);
        }

        private TaskThumbnailInfo(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_TaskThumbnailInfo$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        public void reset() {
            InvokeDynamicSupport.bootstrap("reset", $$robo$$android_app_ActivityManager_TaskThumbnailInfo$reset(), 0, this);
        }

        public void copyFrom(TaskThumbnailInfo taskThumbnailInfo) {
            InvokeDynamicSupport.bootstrap("copyFrom", $$robo$$android_app_ActivityManager_TaskThumbnailInfo$copyFrom(android.app.ActivityManager$TaskThumbnailInfo ), 0, this, taskThumbnailInfo);
        }

        public void saveToXml(XmlSerializer xmlSerializer) throws IOException {
            InvokeDynamicSupport.bootstrap("saveToXml", $$robo$$android_app_ActivityManager_TaskThumbnailInfo$saveToXml(org.xmlpull.v1.XmlSerializer ), 0, this, xmlSerializer);
        }

        public void restoreFromXml(String string2, String string3) {
            InvokeDynamicSupport.bootstrap("restoreFromXml", $$robo$$android_app_ActivityManager_TaskThumbnailInfo$restoreFromXml(java.lang.String java.lang.String ), 0, this, string2, string3);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_app_ActivityManager_TaskThumbnailInfo$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_app_ActivityManager_TaskThumbnailInfo$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        public void readFromParcel(Parcel parcel) {
            InvokeDynamicSupport.bootstrap("readFromParcel", $$robo$$android_app_ActivityManager_TaskThumbnailInfo$readFromParcel(android.os.Parcel ), 0, this, parcel);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_app_ActivityManager_TaskThumbnailInfo$__constructor__(parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(TaskThumbnailInfo.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TaskThumbnailInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class RunningTaskInfo
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int id;
        public int stackId;
        public ComponentName baseActivity;
        public ComponentName topActivity;
        public Bitmap thumbnail;
        public CharSequence description;
        public int numActivities;
        public int numRunning;
        public long lastActiveTime;
        public boolean supportsSplitScreenMultiWindow;
        public int resizeMode;
        public static Parcelable.Creator<RunningTaskInfo> CREATOR;

        private void $$robo$$android_app_ActivityManager_RunningTaskInfo$__constructor__() {
        }

        private final int $$robo$$android_app_ActivityManager_RunningTaskInfo$describeContents() {
            return 0;
        }

        private final void $$robo$$android_app_ActivityManager_RunningTaskInfo$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.id);
            dest.writeInt(this.stackId);
            ComponentName.writeToParcel(this.baseActivity, dest);
            ComponentName.writeToParcel(this.topActivity, dest);
            if (this.thumbnail != null) {
                dest.writeInt(1);
                this.thumbnail.writeToParcel(dest, 0);
            } else {
                dest.writeInt(0);
            }
            TextUtils.writeToParcel(this.description, dest, 1);
            dest.writeInt(this.numActivities);
            dest.writeInt(this.numRunning);
            dest.writeInt(this.supportsSplitScreenMultiWindow ? 1 : 0);
            dest.writeInt(this.resizeMode);
        }

        private final void $$robo$$android_app_ActivityManager_RunningTaskInfo$readFromParcel(Parcel source) {
            this.id = source.readInt();
            this.stackId = source.readInt();
            this.baseActivity = ComponentName.readFromParcel(source);
            this.topActivity = ComponentName.readFromParcel(source);
            this.thumbnail = source.readInt() != 0 ? Bitmap.CREATOR.createFromParcel(source) : null;
            this.description = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(source);
            this.numActivities = source.readInt();
            this.numRunning = source.readInt();
            this.supportsSplitScreenMultiWindow = source.readInt() != 0;
            this.resizeMode = source.readInt();
        }

        private void $$robo$$android_app_ActivityManager_RunningTaskInfo$__constructor__(Parcel source) {
            this.readFromParcel(source);
        }

        private /* synthetic */ void $$robo$$android_app_ActivityManager_RunningTaskInfo$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<RunningTaskInfo>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_app_ActivityManager_RunningTaskInfo_1$__constructor__() {
                }

                private final RunningTaskInfo $$robo$$android_app_ActivityManager_RunningTaskInfo_1$createFromParcel(Parcel source) {
                    return new RunningTaskInfo(source);
                }

                private final RunningTaskInfo[] $$robo$$android_app_ActivityManager_RunningTaskInfo_1$newArray(int size) {
                    return new RunningTaskInfo[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_app_ActivityManager_RunningTaskInfo_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_RunningTaskInfo_1$__constructor__(), 0, this);
                }

                @Override
                public RunningTaskInfo createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_app_ActivityManager_RunningTaskInfo_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public RunningTaskInfo[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_app_ActivityManager_RunningTaskInfo_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__() {
            this.$$robo$$android_app_ActivityManager_RunningTaskInfo$__constructor__();
        }

        public RunningTaskInfo() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_RunningTaskInfo$__constructor__(), 0, this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_app_ActivityManager_RunningTaskInfo$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_app_ActivityManager_RunningTaskInfo$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        public void readFromParcel(Parcel parcel) {
            InvokeDynamicSupport.bootstrap("readFromParcel", $$robo$$android_app_ActivityManager_RunningTaskInfo$readFromParcel(android.os.Parcel ), 0, this, parcel);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_app_ActivityManager_RunningTaskInfo$__constructor__(parcel);
        }

        private RunningTaskInfo(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_RunningTaskInfo$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_app_ActivityManager_RunningTaskInfo$__constructor__(parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(RunningTaskInfo.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RunningTaskInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class RecentTaskInfo
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int id;
        public int persistentId;
        public Intent baseIntent;
        public ComponentName origActivity;
        public ComponentName realActivity;
        public CharSequence description;
        public int stackId;
        public int userId;
        public long firstActiveTime;
        public long lastActiveTime;
        public TaskDescription taskDescription;
        public int affiliatedTaskId;
        public int affiliatedTaskColor;
        public ComponentName baseActivity;
        public ComponentName topActivity;
        public int numActivities;
        public Rect bounds;
        public boolean supportsSplitScreenMultiWindow;
        public int resizeMode;
        public static Parcelable.Creator<RecentTaskInfo> CREATOR;

        private void $$robo$$android_app_ActivityManager_RecentTaskInfo$__constructor__() {
        }

        private final int $$robo$$android_app_ActivityManager_RecentTaskInfo$describeContents() {
            return 0;
        }

        private final void $$robo$$android_app_ActivityManager_RecentTaskInfo$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.id);
            dest.writeInt(this.persistentId);
            if (this.baseIntent != null) {
                dest.writeInt(1);
                this.baseIntent.writeToParcel(dest, 0);
            } else {
                dest.writeInt(0);
            }
            ComponentName.writeToParcel(this.origActivity, dest);
            ComponentName.writeToParcel(this.realActivity, dest);
            TextUtils.writeToParcel(this.description, dest, 1);
            if (this.taskDescription != null) {
                dest.writeInt(1);
                this.taskDescription.writeToParcel(dest, 0);
            } else {
                dest.writeInt(0);
            }
            dest.writeInt(this.stackId);
            dest.writeInt(this.userId);
            dest.writeLong(this.firstActiveTime);
            dest.writeLong(this.lastActiveTime);
            dest.writeInt(this.affiliatedTaskId);
            dest.writeInt(this.affiliatedTaskColor);
            ComponentName.writeToParcel(this.baseActivity, dest);
            ComponentName.writeToParcel(this.topActivity, dest);
            dest.writeInt(this.numActivities);
            if (this.bounds != null) {
                dest.writeInt(1);
                this.bounds.writeToParcel(dest, 0);
            } else {
                dest.writeInt(0);
            }
            dest.writeInt(this.supportsSplitScreenMultiWindow ? 1 : 0);
            dest.writeInt(this.resizeMode);
        }

        private final void $$robo$$android_app_ActivityManager_RecentTaskInfo$readFromParcel(Parcel source) {
            this.id = source.readInt();
            this.persistentId = source.readInt();
            this.baseIntent = source.readInt() > 0 ? Intent.CREATOR.createFromParcel(source) : null;
            this.origActivity = ComponentName.readFromParcel(source);
            this.realActivity = ComponentName.readFromParcel(source);
            this.description = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(source);
            this.taskDescription = source.readInt() > 0 ? TaskDescription.CREATOR.createFromParcel(source) : null;
            this.stackId = source.readInt();
            this.userId = source.readInt();
            this.firstActiveTime = source.readLong();
            this.lastActiveTime = source.readLong();
            this.affiliatedTaskId = source.readInt();
            this.affiliatedTaskColor = source.readInt();
            this.baseActivity = ComponentName.readFromParcel(source);
            this.topActivity = ComponentName.readFromParcel(source);
            this.numActivities = source.readInt();
            this.bounds = source.readInt() > 0 ? Rect.CREATOR.createFromParcel(source) : null;
            this.supportsSplitScreenMultiWindow = source.readInt() == 1;
            this.resizeMode = source.readInt();
        }

        private void $$robo$$android_app_ActivityManager_RecentTaskInfo$__constructor__(Parcel source) {
            this.readFromParcel(source);
        }

        private /* synthetic */ void $$robo$$android_app_ActivityManager_RecentTaskInfo$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<RecentTaskInfo>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_app_ActivityManager_RecentTaskInfo_1$__constructor__() {
                }

                private final RecentTaskInfo $$robo$$android_app_ActivityManager_RecentTaskInfo_1$createFromParcel(Parcel source) {
                    return new RecentTaskInfo(source);
                }

                private final RecentTaskInfo[] $$robo$$android_app_ActivityManager_RecentTaskInfo_1$newArray(int size) {
                    return new RecentTaskInfo[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_app_ActivityManager_RecentTaskInfo_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_RecentTaskInfo_1$__constructor__(), 0, this);
                }

                @Override
                public RecentTaskInfo createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_app_ActivityManager_RecentTaskInfo_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public RecentTaskInfo[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_app_ActivityManager_RecentTaskInfo_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__() {
            this.$$robo$$android_app_ActivityManager_RecentTaskInfo$__constructor__();
        }

        public RecentTaskInfo() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_RecentTaskInfo$__constructor__(), 0, this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_app_ActivityManager_RecentTaskInfo$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_app_ActivityManager_RecentTaskInfo$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        public void readFromParcel(Parcel parcel) {
            InvokeDynamicSupport.bootstrap("readFromParcel", $$robo$$android_app_ActivityManager_RecentTaskInfo$readFromParcel(android.os.Parcel ), 0, this, parcel);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_app_ActivityManager_RecentTaskInfo$__constructor__(parcel);
        }

        private RecentTaskInfo(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_RecentTaskInfo$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_app_ActivityManager_RecentTaskInfo$__constructor__(parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(RecentTaskInfo.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RecentTaskInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class TaskDescription
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static String ATTR_TASKDESCRIPTION_PREFIX = "task_description_";
        private static String ATTR_TASKDESCRIPTIONLABEL = "task_description_label";
        private static String ATTR_TASKDESCRIPTIONCOLOR_PRIMARY = "task_description_color";
        private static String ATTR_TASKDESCRIPTIONCOLOR_BACKGROUND = "task_description_colorBackground";
        private static String ATTR_TASKDESCRIPTIONICONFILENAME = "task_description_icon_filename";
        private String mLabel;
        private Bitmap mIcon;
        private String mIconFilename;
        private int mColorPrimary;
        private int mColorBackground;
        private int mStatusBarColor;
        private int mNavigationBarColor;
        public static Parcelable.Creator<TaskDescription> CREATOR;

        private void $$robo$$android_app_ActivityManager_TaskDescription$__constructor__(String label, Bitmap icon, int colorPrimary) {
            if (colorPrimary != 0 && Color.alpha(colorPrimary) != 255) {
                throw new RuntimeException("A TaskDescription's primary color should be opaque");
            }
        }

        private void $$robo$$android_app_ActivityManager_TaskDescription$__constructor__(String label, Bitmap icon) {
        }

        private void $$robo$$android_app_ActivityManager_TaskDescription$__constructor__(String label) {
        }

        private void $$robo$$android_app_ActivityManager_TaskDescription$__constructor__() {
        }

        private void $$robo$$android_app_ActivityManager_TaskDescription$__constructor__(String label, Bitmap icon, String iconFilename, int colorPrimary, int colorBackground, int statusBarColor, int navigationBarColor) {
            this.mLabel = label;
            this.mIcon = icon;
            this.mIconFilename = iconFilename;
            this.mColorPrimary = colorPrimary;
            this.mColorBackground = colorBackground;
            this.mStatusBarColor = statusBarColor;
            this.mNavigationBarColor = navigationBarColor;
        }

        private void $$robo$$android_app_ActivityManager_TaskDescription$__constructor__(TaskDescription td) {
            this.copyFrom(td);
        }

        private final void $$robo$$android_app_ActivityManager_TaskDescription$copyFrom(TaskDescription other) {
            this.mLabel = other.mLabel;
            this.mIcon = other.mIcon;
            this.mIconFilename = other.mIconFilename;
            this.mColorPrimary = other.mColorPrimary;
            this.mColorBackground = other.mColorBackground;
            this.mStatusBarColor = other.mStatusBarColor;
            this.mNavigationBarColor = other.mNavigationBarColor;
        }

        private final void $$robo$$android_app_ActivityManager_TaskDescription$copyFromPreserveHiddenFields(TaskDescription other) {
            this.mLabel = other.mLabel;
            this.mIcon = other.mIcon;
            this.mIconFilename = other.mIconFilename;
            this.mColorPrimary = other.mColorPrimary;
            if (other.mColorBackground != 0) {
                this.mColorBackground = other.mColorBackground;
            }
            if (other.mStatusBarColor != 0) {
                this.mStatusBarColor = other.mStatusBarColor;
            }
            if (other.mNavigationBarColor != 0) {
                this.mNavigationBarColor = other.mNavigationBarColor;
            }
        }

        private void $$robo$$android_app_ActivityManager_TaskDescription$__constructor__(Parcel source) {
            this.readFromParcel(source);
        }

        private final void $$robo$$android_app_ActivityManager_TaskDescription$setLabel(String label) {
            this.mLabel = label;
        }

        private final void $$robo$$android_app_ActivityManager_TaskDescription$setPrimaryColor(int primaryColor) {
            if (primaryColor != 0 && Color.alpha(primaryColor) != 255) {
                throw new RuntimeException("A TaskDescription's primary color should be opaque");
            }
            this.mColorPrimary = primaryColor;
        }

        private final void $$robo$$android_app_ActivityManager_TaskDescription$setBackgroundColor(int backgroundColor) {
            if (backgroundColor != 0 && Color.alpha(backgroundColor) != 255) {
                throw new RuntimeException("A TaskDescription's background color should be opaque");
            }
            this.mColorBackground = backgroundColor;
        }

        private final void $$robo$$android_app_ActivityManager_TaskDescription$setStatusBarColor(int statusBarColor) {
            this.mStatusBarColor = statusBarColor;
        }

        private final void $$robo$$android_app_ActivityManager_TaskDescription$setNavigationBarColor(int navigationBarColor) {
            this.mNavigationBarColor = navigationBarColor;
        }

        private final void $$robo$$android_app_ActivityManager_TaskDescription$setIcon(Bitmap icon) {
            this.mIcon = icon;
        }

        private final void $$robo$$android_app_ActivityManager_TaskDescription$setIconFilename(String iconFilename) {
            this.mIconFilename = iconFilename;
            this.mIcon = null;
        }

        private final String $$robo$$android_app_ActivityManager_TaskDescription$getLabel() {
            return this.mLabel;
        }

        private final Bitmap $$robo$$android_app_ActivityManager_TaskDescription$getIcon() {
            if (this.mIcon != null) {
                return this.mIcon;
            }
            return TaskDescription.loadTaskDescriptionIcon(this.mIconFilename, UserHandle.myUserId());
        }

        private final String $$robo$$android_app_ActivityManager_TaskDescription$getIconFilename() {
            return this.mIconFilename;
        }

        private final Bitmap $$robo$$android_app_ActivityManager_TaskDescription$getInMemoryIcon() {
            return this.mIcon;
        }

        private static final Bitmap $$robo$$android_app_ActivityManager_TaskDescription$loadTaskDescriptionIcon(String iconFilename, int userId) {
            if (iconFilename != null) {
                try {
                    return ActivityManager.getService().getTaskDescriptionIcon(iconFilename, userId);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
            return null;
        }

        private final int $$robo$$android_app_ActivityManager_TaskDescription$getPrimaryColor() {
            return this.mColorPrimary;
        }

        private final int $$robo$$android_app_ActivityManager_TaskDescription$getBackgroundColor() {
            return this.mColorBackground;
        }

        private final int $$robo$$android_app_ActivityManager_TaskDescription$getStatusBarColor() {
            return this.mStatusBarColor;
        }

        private final int $$robo$$android_app_ActivityManager_TaskDescription$getNavigationBarColor() {
            return this.mNavigationBarColor;
        }

        private final void $$robo$$android_app_ActivityManager_TaskDescription$saveToXml(XmlSerializer out) throws IOException {
            if (this.mLabel != null) {
                out.attribute(null, "task_description_label", this.mLabel);
            }
            if (this.mColorPrimary != 0) {
                out.attribute(null, "task_description_color", Integer.toHexString(this.mColorPrimary));
            }
            if (this.mColorBackground != 0) {
                out.attribute(null, "task_description_colorBackground", Integer.toHexString(this.mColorBackground));
            }
            if (this.mIconFilename != null) {
                out.attribute(null, "task_description_icon_filename", this.mIconFilename);
            }
        }

        private final void $$robo$$android_app_ActivityManager_TaskDescription$restoreFromXml(String attrName, String attrValue) {
            if ("task_description_label".equals(attrName)) {
                this.setLabel(attrValue);
            } else if ("task_description_color".equals(attrName)) {
                this.setPrimaryColor((int)Long.parseLong(attrValue, 16));
            } else if ("task_description_colorBackground".equals(attrName)) {
                this.setBackgroundColor((int)Long.parseLong(attrValue, 16));
            } else if ("task_description_icon_filename".equals(attrName)) {
                this.setIconFilename(attrValue);
            }
        }

        private final int $$robo$$android_app_ActivityManager_TaskDescription$describeContents() {
            return 0;
        }

        private final void $$robo$$android_app_ActivityManager_TaskDescription$writeToParcel(Parcel dest, int flags) {
            if (this.mLabel == null) {
                dest.writeInt(0);
            } else {
                dest.writeInt(1);
                dest.writeString(this.mLabel);
            }
            if (this.mIcon == null) {
                dest.writeInt(0);
            } else {
                dest.writeInt(1);
                this.mIcon.writeToParcel(dest, 0);
            }
            dest.writeInt(this.mColorPrimary);
            dest.writeInt(this.mColorBackground);
            dest.writeInt(this.mStatusBarColor);
            dest.writeInt(this.mNavigationBarColor);
            if (this.mIconFilename == null) {
                dest.writeInt(0);
            } else {
                dest.writeInt(1);
                dest.writeString(this.mIconFilename);
            }
        }

        private final void $$robo$$android_app_ActivityManager_TaskDescription$readFromParcel(Parcel source) {
            this.mLabel = source.readInt() > 0 ? source.readString() : null;
            this.mIcon = source.readInt() > 0 ? Bitmap.CREATOR.createFromParcel(source) : null;
            this.mColorPrimary = source.readInt();
            this.mColorBackground = source.readInt();
            this.mStatusBarColor = source.readInt();
            this.mNavigationBarColor = source.readInt();
            this.mIconFilename = source.readInt() > 0 ? source.readString() : null;
        }

        private final String $$robo$$android_app_ActivityManager_TaskDescription$toString() {
            return "TaskDescription Label: " + this.mLabel + " Icon: " + this.mIcon + " IconFilename: " + this.mIconFilename + " colorPrimary: " + this.mColorPrimary + " colorBackground: " + this.mColorBackground + " statusBarColor: " + this.mColorBackground + " navigationBarColor: " + this.mNavigationBarColor;
        }

        private /* synthetic */ void $$robo$$android_app_ActivityManager_TaskDescription$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<TaskDescription>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_app_ActivityManager_TaskDescription_1$__constructor__() {
                }

                private final TaskDescription $$robo$$android_app_ActivityManager_TaskDescription_1$createFromParcel(Parcel source) {
                    return new TaskDescription(source);
                }

                private final TaskDescription[] $$robo$$android_app_ActivityManager_TaskDescription_1$newArray(int size) {
                    return new TaskDescription[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_app_ActivityManager_TaskDescription_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_TaskDescription_1$__constructor__(), 0, this);
                }

                @Override
                public TaskDescription createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_app_ActivityManager_TaskDescription_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public TaskDescription[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_app_ActivityManager_TaskDescription_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(String string2, Bitmap bitmap, int n) {
            this.$$robo$$android_app_ActivityManager_TaskDescription$__constructor__(string2, bitmap, n);
        }

        public TaskDescription(String string2, Bitmap bitmap, int n) {
            this(string2, bitmap, null, n, 0, 0, 0);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_TaskDescription$__constructor__(java.lang.String android.graphics.Bitmap int ), 0, this, string2, bitmap, n);
        }

        private void __constructor__(String string2, Bitmap bitmap) {
            this.$$robo$$android_app_ActivityManager_TaskDescription$__constructor__(string2, bitmap);
        }

        public TaskDescription(String string2, Bitmap bitmap) {
            this(string2, bitmap, null, 0, 0, 0, 0);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_TaskDescription$__constructor__(java.lang.String android.graphics.Bitmap ), 0, this, string2, bitmap);
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_app_ActivityManager_TaskDescription$__constructor__(string2);
        }

        public TaskDescription(String string2) {
            this(string2, null, null, 0, 0, 0, 0);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_TaskDescription$__constructor__(java.lang.String ), 0, this, string2);
        }

        private void __constructor__() {
            this.$$robo$$android_app_ActivityManager_TaskDescription$__constructor__();
        }

        public TaskDescription() {
            this(null, null, null, 0, 0, 0, 0);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_TaskDescription$__constructor__(), 0, this);
        }

        private void __constructor__(String string2, Bitmap bitmap, String string3, int n, int n2, int n3, int n4) {
            this.$$robo$$android_app_ActivityManager_TaskDescription$__constructor__(string2, bitmap, string3, n, n2, n3, n4);
        }

        public TaskDescription(String string2, Bitmap bitmap, String string3, int n, int n2, int n3, int n4) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_TaskDescription$__constructor__(java.lang.String android.graphics.Bitmap java.lang.String int int int int ), 0, this, string2, bitmap, string3, n, n2, n3, n4);
        }

        private void __constructor__(TaskDescription taskDescription) {
            this.$$robo$$android_app_ActivityManager_TaskDescription$__constructor__(taskDescription);
        }

        public TaskDescription(TaskDescription taskDescription) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_TaskDescription$__constructor__(android.app.ActivityManager$TaskDescription ), 0, this, taskDescription);
        }

        public void copyFrom(TaskDescription taskDescription) {
            InvokeDynamicSupport.bootstrap("copyFrom", $$robo$$android_app_ActivityManager_TaskDescription$copyFrom(android.app.ActivityManager$TaskDescription ), 0, this, taskDescription);
        }

        public void copyFromPreserveHiddenFields(TaskDescription taskDescription) {
            InvokeDynamicSupport.bootstrap("copyFromPreserveHiddenFields", $$robo$$android_app_ActivityManager_TaskDescription$copyFromPreserveHiddenFields(android.app.ActivityManager$TaskDescription ), 0, this, taskDescription);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_app_ActivityManager_TaskDescription$__constructor__(parcel);
        }

        private TaskDescription(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_TaskDescription$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        public void setLabel(String string2) {
            InvokeDynamicSupport.bootstrap("setLabel", $$robo$$android_app_ActivityManager_TaskDescription$setLabel(java.lang.String ), 0, this, string2);
        }

        public void setPrimaryColor(int n) {
            InvokeDynamicSupport.bootstrap("setPrimaryColor", $$robo$$android_app_ActivityManager_TaskDescription$setPrimaryColor(int ), 0, this, n);
        }

        public void setBackgroundColor(int n) {
            InvokeDynamicSupport.bootstrap("setBackgroundColor", $$robo$$android_app_ActivityManager_TaskDescription$setBackgroundColor(int ), 0, this, n);
        }

        public void setStatusBarColor(int n) {
            InvokeDynamicSupport.bootstrap("setStatusBarColor", $$robo$$android_app_ActivityManager_TaskDescription$setStatusBarColor(int ), 0, this, n);
        }

        public void setNavigationBarColor(int n) {
            InvokeDynamicSupport.bootstrap("setNavigationBarColor", $$robo$$android_app_ActivityManager_TaskDescription$setNavigationBarColor(int ), 0, this, n);
        }

        public void setIcon(Bitmap bitmap) {
            InvokeDynamicSupport.bootstrap("setIcon", $$robo$$android_app_ActivityManager_TaskDescription$setIcon(android.graphics.Bitmap ), 0, this, bitmap);
        }

        public void setIconFilename(String string2) {
            InvokeDynamicSupport.bootstrap("setIconFilename", $$robo$$android_app_ActivityManager_TaskDescription$setIconFilename(java.lang.String ), 0, this, string2);
        }

        public String getLabel() {
            return InvokeDynamicSupport.bootstrap("getLabel", $$robo$$android_app_ActivityManager_TaskDescription$getLabel(), 0, this);
        }

        public Bitmap getIcon() {
            return InvokeDynamicSupport.bootstrap("getIcon", $$robo$$android_app_ActivityManager_TaskDescription$getIcon(), 0, this);
        }

        public String getIconFilename() {
            return InvokeDynamicSupport.bootstrap("getIconFilename", $$robo$$android_app_ActivityManager_TaskDescription$getIconFilename(), 0, this);
        }

        public Bitmap getInMemoryIcon() {
            return InvokeDynamicSupport.bootstrap("getInMemoryIcon", $$robo$$android_app_ActivityManager_TaskDescription$getInMemoryIcon(), 0, this);
        }

        public static Bitmap loadTaskDescriptionIcon(String string2, int n) {
            return InvokeDynamicSupport.bootstrapStatic("loadTaskDescriptionIcon", $$robo$$android_app_ActivityManager_TaskDescription$loadTaskDescriptionIcon(java.lang.String int ), 0, (String)string2, (int)n);
        }

        public int getPrimaryColor() {
            return (int)InvokeDynamicSupport.bootstrap("getPrimaryColor", $$robo$$android_app_ActivityManager_TaskDescription$getPrimaryColor(), 0, this);
        }

        public int getBackgroundColor() {
            return (int)InvokeDynamicSupport.bootstrap("getBackgroundColor", $$robo$$android_app_ActivityManager_TaskDescription$getBackgroundColor(), 0, this);
        }

        public int getStatusBarColor() {
            return (int)InvokeDynamicSupport.bootstrap("getStatusBarColor", $$robo$$android_app_ActivityManager_TaskDescription$getStatusBarColor(), 0, this);
        }

        public int getNavigationBarColor() {
            return (int)InvokeDynamicSupport.bootstrap("getNavigationBarColor", $$robo$$android_app_ActivityManager_TaskDescription$getNavigationBarColor(), 0, this);
        }

        public void saveToXml(XmlSerializer xmlSerializer) throws IOException {
            InvokeDynamicSupport.bootstrap("saveToXml", $$robo$$android_app_ActivityManager_TaskDescription$saveToXml(org.xmlpull.v1.XmlSerializer ), 0, this, xmlSerializer);
        }

        public void restoreFromXml(String string2, String string3) {
            InvokeDynamicSupport.bootstrap("restoreFromXml", $$robo$$android_app_ActivityManager_TaskDescription$restoreFromXml(java.lang.String java.lang.String ), 0, this, string2, string3);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_app_ActivityManager_TaskDescription$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_app_ActivityManager_TaskDescription$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        public void readFromParcel(Parcel parcel) {
            InvokeDynamicSupport.bootstrap("readFromParcel", $$robo$$android_app_ActivityManager_TaskDescription$readFromParcel(android.os.Parcel ), 0, this, parcel);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_app_ActivityManager_TaskDescription$toString(), 0, this);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_app_ActivityManager_TaskDescription$__constructor__(parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(TaskDescription.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TaskDescription)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class StackId
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int INVALID_STACK_ID = -1;
        public static int FIRST_STATIC_STACK_ID = 0;
        public static int HOME_STACK_ID = 0;
        public static int FULLSCREEN_WORKSPACE_STACK_ID = 1;
        public static int FREEFORM_WORKSPACE_STACK_ID = 2;
        public static int DOCKED_STACK_ID = 3;
        public static int PINNED_STACK_ID = 4;
        public static int RECENTS_STACK_ID = 5;
        public static int ASSISTANT_STACK_ID = 6;
        public static int LAST_STATIC_STACK_ID = 6;
        public static int FIRST_DYNAMIC_STACK_ID = 7;

        private void $$robo$$android_app_ActivityManager_StackId$__constructor__() {
        }

        private static final boolean $$robo$$android_app_ActivityManager_StackId$isStaticStack(int stackId) {
            return stackId >= 0 && stackId <= 6;
        }

        private static final boolean $$robo$$android_app_ActivityManager_StackId$isDynamicStack(int stackId) {
            return stackId >= 7;
        }

        private static final boolean $$robo$$android_app_ActivityManager_StackId$hasWindowShadow(int stackId) {
            return stackId == 2 || stackId == 4;
        }

        private static final boolean $$robo$$android_app_ActivityManager_StackId$hasWindowDecor(int stackId) {
            return stackId == 2;
        }

        private static final boolean $$robo$$android_app_ActivityManager_StackId$isTaskResizeAllowed(int stackId) {
            return stackId == 2;
        }

        private static final boolean $$robo$$android_app_ActivityManager_StackId$persistTaskBounds(int stackId) {
            return stackId == 2;
        }

        private static final boolean $$robo$$android_app_ActivityManager_StackId$isDynamicStacksVisibleBehindAllowed(int stackId) {
            return stackId == 4 || stackId == 6;
        }

        private static final boolean $$robo$$android_app_ActivityManager_StackId$keepFocusInStackIfPossible(int stackId) {
            return stackId == 2 || stackId == 3 || stackId == 4;
        }

        private static final boolean $$robo$$android_app_ActivityManager_StackId$isResizeableByDockedStack(int stackId) {
            return StackId.isStaticStack(stackId) && stackId != 3 && stackId != 4 && stackId != 6;
        }

        private static final boolean $$robo$$android_app_ActivityManager_StackId$isTaskResizeableByDockedStack(int stackId) {
            return StackId.isStaticStack(stackId) && stackId != 2 && stackId != 3 && stackId != 4 && stackId != 6;
        }

        private static final boolean $$robo$$android_app_ActivityManager_StackId$isStackAffectedByDragResizing(int stackId) {
            return StackId.isStaticStack(stackId) && stackId != 4 && stackId != 6;
        }

        private static final boolean $$robo$$android_app_ActivityManager_StackId$replaceWindowsOnTaskMove(int sourceStackId, int targetStackId) {
            return sourceStackId == 2 || targetStackId == 2;
        }

        private static final boolean $$robo$$android_app_ActivityManager_StackId$tasksAreFloating(int stackId) {
            return stackId == 2 || stackId == 4;
        }

        private static final boolean $$robo$$android_app_ActivityManager_StackId$isBackdropToTranslucentActivity(int stackId) {
            return stackId == 1 || stackId == 6;
        }

        private static final boolean $$robo$$android_app_ActivityManager_StackId$useAnimationSpecForAppTransition(int stackId) {
            return stackId == 2 || stackId == 1 || stackId == 6 || stackId == 3 || stackId == -1;
        }

        private static final boolean $$robo$$android_app_ActivityManager_StackId$canReceiveKeys(int stackId) {
            return stackId != 4;
        }

        private static final boolean $$robo$$android_app_ActivityManager_StackId$isAllowedOverLockscreen(int stackId) {
            return stackId == 0 || stackId == 1 || stackId == 6;
        }

        private static final boolean $$robo$$android_app_ActivityManager_StackId$isAllowedToEnterPictureInPicture(int stackId) {
            return stackId != 0 && stackId != 6 && stackId != 5;
        }

        private static final boolean $$robo$$android_app_ActivityManager_StackId$isAlwaysOnTop(int stackId) {
            return stackId == 4;
        }

        private static final boolean $$robo$$android_app_ActivityManager_StackId$allowTopTaskToReturnHome(int stackId) {
            return stackId != 4;
        }

        private static final boolean $$robo$$android_app_ActivityManager_StackId$resizeStackWithLaunchBounds(int stackId) {
            return stackId == 4;
        }

        private static final boolean $$robo$$android_app_ActivityManager_StackId$keepVisibleDeadAppWindowOnScreen(int stackId) {
            return stackId != 4;
        }

        private static final boolean $$robo$$android_app_ActivityManager_StackId$useWindowFrameForBackdrop(int stackId) {
            return stackId == 2 || stackId == 4;
        }

        private static final boolean $$robo$$android_app_ActivityManager_StackId$normallyFullscreenWindows(int stackId) {
            return stackId != 4 && stackId != 2 && stackId != 3;
        }

        private static final boolean $$robo$$android_app_ActivityManager_StackId$isMultiWindowStack(int stackId) {
            return stackId == 4 || stackId == 2 || stackId == 3;
        }

        private static final boolean $$robo$$android_app_ActivityManager_StackId$isHomeOrRecentsStack(int stackId) {
            return stackId == 0 || stackId == 5;
        }

        private static final boolean $$robo$$android_app_ActivityManager_StackId$windowsAreScaleable(int stackId) {
            return stackId == 4;
        }

        private static final boolean $$robo$$android_app_ActivityManager_StackId$hasMovementAnimations(int stackId) {
            return stackId != 4;
        }

        private static final boolean $$robo$$android_app_ActivityManager_StackId$canSpecifyOrientation(int stackId) {
            return stackId == 0 || stackId == 5 || stackId == 1 || stackId == 6 || StackId.isDynamicStack(stackId);
        }

        private void __constructor__() {
            this.$$robo$$android_app_ActivityManager_StackId$__constructor__();
        }

        public StackId() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_StackId$__constructor__(), 0, this);
        }

        public static boolean isStaticStack(int n) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("isStaticStack", $$robo$$android_app_ActivityManager_StackId$isStaticStack(int ), 0, (int)n);
        }

        public static boolean isDynamicStack(int n) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("isDynamicStack", $$robo$$android_app_ActivityManager_StackId$isDynamicStack(int ), 0, (int)n);
        }

        public static boolean hasWindowShadow(int n) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("hasWindowShadow", $$robo$$android_app_ActivityManager_StackId$hasWindowShadow(int ), 0, (int)n);
        }

        public static boolean hasWindowDecor(int n) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("hasWindowDecor", $$robo$$android_app_ActivityManager_StackId$hasWindowDecor(int ), 0, (int)n);
        }

        public static boolean isTaskResizeAllowed(int n) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("isTaskResizeAllowed", $$robo$$android_app_ActivityManager_StackId$isTaskResizeAllowed(int ), 0, (int)n);
        }

        public static boolean persistTaskBounds(int n) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("persistTaskBounds", $$robo$$android_app_ActivityManager_StackId$persistTaskBounds(int ), 0, (int)n);
        }

        public static boolean isDynamicStacksVisibleBehindAllowed(int n) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("isDynamicStacksVisibleBehindAllowed", $$robo$$android_app_ActivityManager_StackId$isDynamicStacksVisibleBehindAllowed(int ), 0, (int)n);
        }

        public static boolean keepFocusInStackIfPossible(int n) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("keepFocusInStackIfPossible", $$robo$$android_app_ActivityManager_StackId$keepFocusInStackIfPossible(int ), 0, (int)n);
        }

        public static boolean isResizeableByDockedStack(int n) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("isResizeableByDockedStack", $$robo$$android_app_ActivityManager_StackId$isResizeableByDockedStack(int ), 0, (int)n);
        }

        public static boolean isTaskResizeableByDockedStack(int n) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("isTaskResizeableByDockedStack", $$robo$$android_app_ActivityManager_StackId$isTaskResizeableByDockedStack(int ), 0, (int)n);
        }

        public static boolean isStackAffectedByDragResizing(int n) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("isStackAffectedByDragResizing", $$robo$$android_app_ActivityManager_StackId$isStackAffectedByDragResizing(int ), 0, (int)n);
        }

        public static boolean replaceWindowsOnTaskMove(int n, int n2) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("replaceWindowsOnTaskMove", $$robo$$android_app_ActivityManager_StackId$replaceWindowsOnTaskMove(int int ), 0, (int)n, (int)n2);
        }

        public static boolean tasksAreFloating(int n) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("tasksAreFloating", $$robo$$android_app_ActivityManager_StackId$tasksAreFloating(int ), 0, (int)n);
        }

        public static boolean isBackdropToTranslucentActivity(int n) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("isBackdropToTranslucentActivity", $$robo$$android_app_ActivityManager_StackId$isBackdropToTranslucentActivity(int ), 0, (int)n);
        }

        public static boolean useAnimationSpecForAppTransition(int n) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("useAnimationSpecForAppTransition", $$robo$$android_app_ActivityManager_StackId$useAnimationSpecForAppTransition(int ), 0, (int)n);
        }

        public static boolean canReceiveKeys(int n) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("canReceiveKeys", $$robo$$android_app_ActivityManager_StackId$canReceiveKeys(int ), 0, (int)n);
        }

        public static boolean isAllowedOverLockscreen(int n) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("isAllowedOverLockscreen", $$robo$$android_app_ActivityManager_StackId$isAllowedOverLockscreen(int ), 0, (int)n);
        }

        public static boolean isAllowedToEnterPictureInPicture(int n) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("isAllowedToEnterPictureInPicture", $$robo$$android_app_ActivityManager_StackId$isAllowedToEnterPictureInPicture(int ), 0, (int)n);
        }

        public static boolean isAlwaysOnTop(int n) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("isAlwaysOnTop", $$robo$$android_app_ActivityManager_StackId$isAlwaysOnTop(int ), 0, (int)n);
        }

        public static boolean allowTopTaskToReturnHome(int n) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("allowTopTaskToReturnHome", $$robo$$android_app_ActivityManager_StackId$allowTopTaskToReturnHome(int ), 0, (int)n);
        }

        public static boolean resizeStackWithLaunchBounds(int n) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("resizeStackWithLaunchBounds", $$robo$$android_app_ActivityManager_StackId$resizeStackWithLaunchBounds(int ), 0, (int)n);
        }

        public static boolean keepVisibleDeadAppWindowOnScreen(int n) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("keepVisibleDeadAppWindowOnScreen", $$robo$$android_app_ActivityManager_StackId$keepVisibleDeadAppWindowOnScreen(int ), 0, (int)n);
        }

        public static boolean useWindowFrameForBackdrop(int n) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("useWindowFrameForBackdrop", $$robo$$android_app_ActivityManager_StackId$useWindowFrameForBackdrop(int ), 0, (int)n);
        }

        public static boolean normallyFullscreenWindows(int n) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("normallyFullscreenWindows", $$robo$$android_app_ActivityManager_StackId$normallyFullscreenWindows(int ), 0, (int)n);
        }

        public static boolean isMultiWindowStack(int n) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("isMultiWindowStack", $$robo$$android_app_ActivityManager_StackId$isMultiWindowStack(int ), 0, (int)n);
        }

        public static boolean isHomeOrRecentsStack(int n) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("isHomeOrRecentsStack", $$robo$$android_app_ActivityManager_StackId$isHomeOrRecentsStack(int ), 0, (int)n);
        }

        public static boolean windowsAreScaleable(int n) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("windowsAreScaleable", $$robo$$android_app_ActivityManager_StackId$windowsAreScaleable(int ), 0, (int)n);
        }

        public static boolean hasMovementAnimations(int n) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("hasMovementAnimations", $$robo$$android_app_ActivityManager_StackId$hasMovementAnimations(int ), 0, (int)n);
        }

        public static boolean canSpecifyOrientation(int n) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("canSpecifyOrientation", $$robo$$android_app_ActivityManager_StackId$canSpecifyOrientation(int ), 0, (int)n);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StackId)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BugreportMode {
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class UidObserver
    extends IUidObserver.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        OnUidImportanceListener mListener;
        Context mContext;

        private void $$robo$$android_app_ActivityManager_UidObserver$__constructor__(OnUidImportanceListener listener, Context clientContext) {
            this.mListener = listener;
            this.mContext = clientContext;
        }

        private final void $$robo$$android_app_ActivityManager_UidObserver$onUidStateChanged(int uid, int procState, long procStateSeq) {
            this.mListener.onUidImportance(uid, RunningAppProcessInfo.procStateToImportanceForClient(procState, this.mContext));
        }

        private final void $$robo$$android_app_ActivityManager_UidObserver$onUidGone(int uid, boolean disabled) {
            this.mListener.onUidImportance(uid, 1000);
        }

        private final void $$robo$$android_app_ActivityManager_UidObserver$onUidActive(int uid) {
        }

        private final void $$robo$$android_app_ActivityManager_UidObserver$onUidIdle(int uid, boolean disabled) {
        }

        private final void $$robo$$android_app_ActivityManager_UidObserver$onUidCachedChanged(int uid, boolean cached) {
        }

        private void __constructor__(OnUidImportanceListener onUidImportanceListener, Context context) {
            this.$$robo$$android_app_ActivityManager_UidObserver$__constructor__(onUidImportanceListener, context);
        }

        UidObserver(OnUidImportanceListener onUidImportanceListener, Context context) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_UidObserver$__constructor__(android.app.ActivityManager$OnUidImportanceListener android.content.Context ), 0, this, onUidImportanceListener, context);
        }

        @Override
        public void onUidStateChanged(int n, int n2, long l) {
            InvokeDynamicSupport.bootstrap("onUidStateChanged", $$robo$$android_app_ActivityManager_UidObserver$onUidStateChanged(int int long ), 0, this, n, n2, l);
        }

        @Override
        public void onUidGone(int n, boolean bl) {
            InvokeDynamicSupport.bootstrap("onUidGone", $$robo$$android_app_ActivityManager_UidObserver$onUidGone(int boolean ), 0, this, n, bl);
        }

        @Override
        public void onUidActive(int n) {
            InvokeDynamicSupport.bootstrap("onUidActive", $$robo$$android_app_ActivityManager_UidObserver$onUidActive(int ), 0, this, n);
        }

        @Override
        public void onUidIdle(int n, boolean bl) {
            InvokeDynamicSupport.bootstrap("onUidIdle", $$robo$$android_app_ActivityManager_UidObserver$onUidIdle(int boolean ), 0, this, n, bl);
        }

        @Override
        public void onUidCachedChanged(int n, boolean bl) {
            InvokeDynamicSupport.bootstrap("onUidCachedChanged", $$robo$$android_app_ActivityManager_UidObserver$onUidCachedChanged(int boolean ), 0, this, n, bl);
        }

        public /* synthetic */ UidObserver() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UidObserver)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

