/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActivityOptions;
import android.app.IInputForwarder;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.hardware.display.DisplayManager;
import android.hardware.display.VirtualDisplay;
import android.hardware.input.InputManager;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.InputEvent;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.ViewGroup;
import android.view.WindowManager;
import dalvik.system.CloseGuard;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ActivityView
extends ViewGroup
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String DISPLAY_NAME = "ActivityViewVirtualDisplay";
    private static String TAG = "ActivityView";
    private VirtualDisplay mVirtualDisplay;
    private SurfaceView mSurfaceView;
    private Surface mSurface;
    private SurfaceCallback mSurfaceCallback;
    private StateCallback mActivityViewCallback;
    private IInputForwarder mInputForwarder;
    private CloseGuard mGuard;
    private boolean mOpened;

    private void $$robo$$android_app_ActivityView$__constructor__(Context context) {
    }

    private void $$robo$$android_app_ActivityView$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_app_ActivityView$__constructor__(Context context, AttributeSet attrs, int defStyle) {
        this.mGuard = CloseGuard.get();
        this.mSurfaceView = new SurfaceView(context);
        this.mSurfaceCallback = new SurfaceCallback(this);
        this.mSurfaceView.getHolder().addCallback(this.mSurfaceCallback);
        this.addView(this.mSurfaceView);
        this.mOpened = true;
        this.mGuard.open("release");
    }

    private final void $$robo$$android_app_ActivityView$setCallback(StateCallback callback) {
        this.mActivityViewCallback = callback;
        if (this.mVirtualDisplay != null && this.mActivityViewCallback != null) {
            this.mActivityViewCallback.onActivityViewReady(this);
        }
    }

    private final void $$robo$$android_app_ActivityView$startActivity(Intent intent) {
        ActivityOptions options = this.prepareActivityOptions();
        this.getContext().startActivity(intent, options.toBundle());
    }

    private final void $$robo$$android_app_ActivityView$startActivity(PendingIntent pendingIntent) {
        ActivityOptions options = this.prepareActivityOptions();
        try {
            pendingIntent.send(null, 0, null, null, null, null, options.toBundle());
        }
        catch (PendingIntent.CanceledException e) {
            throw new RuntimeException(e);
        }
    }

    private final ActivityOptions $$robo$$android_app_ActivityView$prepareActivityOptions() {
        if (this.mVirtualDisplay == null) {
            throw new IllegalStateException("Trying to start activity before ActivityView is ready.");
        }
        ActivityOptions options = ActivityOptions.makeBasic();
        options.setLaunchDisplayId(this.mVirtualDisplay.getDisplay().getDisplayId());
        return options;
    }

    private final void $$robo$$android_app_ActivityView$release() {
        if (this.mVirtualDisplay == null) {
            throw new IllegalStateException("Trying to release container that is not initialized.");
        }
        this.performRelease();
    }

    private final void $$robo$$android_app_ActivityView$onLayout(boolean changed, int l, int t, int r, int b) {
        this.mSurfaceView.layout(0, 0, r - l, b - t);
    }

    private final boolean $$robo$$android_app_ActivityView$onTouchEvent(MotionEvent event) {
        return this.injectInputEvent(event) || super.onTouchEvent(event);
    }

    private final boolean $$robo$$android_app_ActivityView$onGenericMotionEvent(MotionEvent event) {
        if (event.isFromSource(2) && this.injectInputEvent(event)) {
            return true;
        }
        return super.onGenericMotionEvent(event);
    }

    private final boolean $$robo$$android_app_ActivityView$injectInputEvent(InputEvent event) {
        if (this.mInputForwarder != null) {
            try {
                return this.mInputForwarder.forwardEvent(event);
            }
            catch (RemoteException e) {
                e.rethrowAsRuntimeException();
            }
        }
        return false;
    }

    private final void $$robo$$android_app_ActivityView$initVirtualDisplay() {
        if (this.mVirtualDisplay != null) {
            throw new IllegalStateException("Trying to initialize for the second time.");
        }
        int width = this.mSurfaceView.getWidth();
        int height = this.mSurfaceView.getHeight();
        DisplayManager displayManager = this.mContext.getSystemService(DisplayManager.class);
        this.mVirtualDisplay = displayManager.createVirtualDisplay("ActivityViewVirtualDisplay@" + System.identityHashCode(this), width, height, this.getBaseDisplayDensity(), this.mSurface, 0);
        if (this.mVirtualDisplay == null) {
            Log.e("ActivityView", "Failed to initialize ActivityView");
            return;
        }
        this.mInputForwarder = InputManager.getInstance().createInputForwarder(this.mVirtualDisplay.getDisplay().getDisplayId());
    }

    private final void $$robo$$android_app_ActivityView$performRelease() {
        boolean displayReleased;
        if (!this.mOpened) {
            return;
        }
        this.mSurfaceView.getHolder().removeCallback(this.mSurfaceCallback);
        if (this.mInputForwarder != null) {
            this.mInputForwarder = null;
        }
        if (this.mVirtualDisplay != null) {
            this.mVirtualDisplay.release();
            this.mVirtualDisplay = null;
            displayReleased = true;
        } else {
            displayReleased = false;
        }
        if (this.mSurface != null) {
            this.mSurface.release();
            this.mSurface = null;
        }
        if (displayReleased && this.mActivityViewCallback != null) {
            this.mActivityViewCallback.onActivityViewDestroyed(this);
        }
        this.mGuard.close();
        this.mOpened = false;
    }

    private final int $$robo$$android_app_ActivityView$getBaseDisplayDensity() {
        WindowManager wm = this.mContext.getSystemService(WindowManager.class);
        DisplayMetrics metrics = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(metrics);
        return metrics.densityDpi;
    }

    private final void $$robo$$android_app_ActivityView$finalize() throws Throwable {
        try {
            if (this.mGuard != null) {
                this.mGuard.warnIfOpen();
                this.performRelease();
            }
        }
        finally {
            super.finalize();
        }
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_app_ActivityView$__constructor__(context);
    }

    public ActivityView(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityView$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_app_ActivityView$__constructor__(context, attributeSet);
    }

    public ActivityView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityView$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_app_ActivityView$__constructor__(context, attributeSet, n);
    }

    public ActivityView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityView$__constructor__(android.content.Context android.util.AttributeSet int ), 0, this, context, attributeSet, n);
    }

    public void setCallback(StateCallback stateCallback) {
        InvokeDynamicSupport.bootstrap("setCallback", $$robo$$android_app_ActivityView$setCallback(android.app.ActivityView$StateCallback ), 0, this, stateCallback);
    }

    public void startActivity(Intent intent) {
        InvokeDynamicSupport.bootstrap("startActivity", $$robo$$android_app_ActivityView$startActivity(android.content.Intent ), 0, this, intent);
    }

    public void startActivity(PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("startActivity", $$robo$$android_app_ActivityView$startActivity(android.app.PendingIntent ), 0, this, pendingIntent);
    }

    private ActivityOptions prepareActivityOptions() {
        return InvokeDynamicSupport.bootstrap("prepareActivityOptions", $$robo$$android_app_ActivityView$prepareActivityOptions(), 0, this);
    }

    public void release() {
        InvokeDynamicSupport.bootstrap("release", $$robo$$android_app_ActivityView$release(), 0, this);
    }

    @Override
    public void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onLayout", $$robo$$android_app_ActivityView$onLayout(boolean int int int int ), 0, this, bl, n, n2, n3, n4);
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTouchEvent", $$robo$$android_app_ActivityView$onTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    public boolean onGenericMotionEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onGenericMotionEvent", $$robo$$android_app_ActivityView$onGenericMotionEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    private boolean injectInputEvent(InputEvent inputEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("injectInputEvent", $$robo$$android_app_ActivityView$injectInputEvent(android.view.InputEvent ), 0, this, inputEvent);
    }

    private void initVirtualDisplay() {
        InvokeDynamicSupport.bootstrap("initVirtualDisplay", $$robo$$android_app_ActivityView$initVirtualDisplay(), 0, this);
    }

    private void performRelease() {
        InvokeDynamicSupport.bootstrap("performRelease", $$robo$$android_app_ActivityView$performRelease(), 0, this);
    }

    private int getBaseDisplayDensity() {
        return (int)InvokeDynamicSupport.bootstrap("getBaseDisplayDensity", $$robo$$android_app_ActivityView$getBaseDisplayDensity(), 0, this);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_app_ActivityView$finalize(), 0, this);
    }

    public /* synthetic */ ActivityView() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ActivityView)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class SurfaceCallback
    implements SurfaceHolder.Callback,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ ActivityView this$0;

        private void $$robo$$android_app_ActivityView_SurfaceCallback$__constructor__(ActivityView activityView) {
        }

        private final void $$robo$$android_app_ActivityView_SurfaceCallback$surfaceCreated(SurfaceHolder surfaceHolder) {
            this.this$0.mSurface = this.this$0.mSurfaceView.getHolder().getSurface();
            if (this.this$0.mVirtualDisplay == null) {
                this.this$0.initVirtualDisplay();
                if (this.this$0.mVirtualDisplay != null && this.this$0.mActivityViewCallback != null) {
                    this.this$0.mActivityViewCallback.onActivityViewReady(this.this$0);
                }
            } else {
                this.this$0.mVirtualDisplay.setSurface(surfaceHolder.getSurface());
            }
        }

        private final void $$robo$$android_app_ActivityView_SurfaceCallback$surfaceChanged(SurfaceHolder surfaceHolder, int format, int width, int height) {
            if (this.this$0.mVirtualDisplay != null) {
                this.this$0.mVirtualDisplay.resize(width, height, this.this$0.getBaseDisplayDensity());
            }
        }

        private final void $$robo$$android_app_ActivityView_SurfaceCallback$surfaceDestroyed(SurfaceHolder surfaceHolder) {
            this.this$0.mSurface.release();
            this.this$0.mSurface = null;
            if (this.this$0.mVirtualDisplay != null) {
                this.this$0.mVirtualDisplay.setSurface(null);
            }
        }

        private /* synthetic */ void $$robo$$android_app_ActivityView_SurfaceCallback$__constructor__(ActivityView x0, 1 x1) {
        }

        private void __constructor__(ActivityView activityView) {
            this.$$robo$$android_app_ActivityView_SurfaceCallback$__constructor__(activityView);
        }

        private SurfaceCallback(ActivityView activityView) {
            this.this$0 = activityView;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityView_SurfaceCallback$__constructor__(android.app.ActivityView ), 0, this, activityView);
        }

        @Override
        public void surfaceCreated(SurfaceHolder surfaceHolder) {
            InvokeDynamicSupport.bootstrap("surfaceCreated", $$robo$$android_app_ActivityView_SurfaceCallback$surfaceCreated(android.view.SurfaceHolder ), 0, this, surfaceHolder);
        }

        @Override
        public void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
            InvokeDynamicSupport.bootstrap("surfaceChanged", $$robo$$android_app_ActivityView_SurfaceCallback$surfaceChanged(android.view.SurfaceHolder int int int ), 0, this, surfaceHolder, n, n2, n3);
        }

        @Override
        public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
            InvokeDynamicSupport.bootstrap("surfaceDestroyed", $$robo$$android_app_ActivityView_SurfaceCallback$surfaceDestroyed(android.view.SurfaceHolder ), 0, this, surfaceHolder);
        }

        private /* synthetic */ void __constructor__(ActivityView activityView, 1 var2_2) {
            this.$$robo$$android_app_ActivityView_SurfaceCallback$__constructor__(activityView, var2_2);
        }

        public /* synthetic */ SurfaceCallback() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SurfaceCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class StateCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_app_ActivityView_StateCallback$__constructor__() {
        }

        public abstract void onActivityViewReady(ActivityView var1);

        public abstract void onActivityViewDestroyed(ActivityView var1);

        private void __constructor__() {
            this.$$robo$$android_app_ActivityView_StateCallback$__constructor__();
        }

        public StateCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityView_StateCallback$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StateCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

