/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.ActivityThread;
import android.app.Application;
import android.app.IActivityManager;
import android.app.IAppTask;
import android.app.IApplicationThread;
import android.app.IInstrumentationWatcher;
import android.app.IUiAutomationConnection;
import android.app.UiAutomation;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.res.Configuration;
import android.hardware.input.InputManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Debug;
import android.os.IBinder;
import android.os.Looper;
import android.os.MessageQueue;
import android.os.PerformanceCollector;
import android.os.PersistableBundle;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.TestLooperManager;
import android.os.UserHandle;
import android.util.AndroidRuntimeException;
import android.util.Log;
import android.view.IWindowManager;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import android.view.Window;
import com.android.internal.content.ReferrerIntent;
import com.google.errorprone.annotations.DoNotMock;
import java.io.File;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Instrumentation
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String REPORT_KEY_IDENTIFIER = "id";
    public static String REPORT_KEY_STREAMRESULT = "stream";
    private static String TAG = "Instrumentation";
    private Object mSync;
    private ActivityThread mThread;
    private MessageQueue mMessageQueue;
    private Context mInstrContext;
    private Context mAppContext;
    private ComponentName mComponent;
    private Thread mRunner;
    private List<ActivityWaiter> mWaitingActivities;
    private List<ActivityMonitor> mActivityMonitors;
    private IInstrumentationWatcher mWatcher;
    private IUiAutomationConnection mUiAutomationConnection;
    private boolean mAutomaticPerformanceSnapshots;
    private PerformanceCollector mPerformanceCollector;
    private Bundle mPerfMetrics;
    private UiAutomation mUiAutomation;

    private void $$robo$$android_app_Instrumentation$__constructor__() {
        this.mSync = new Object();
        this.mThread = null;
        this.mMessageQueue = null;
        this.mAutomaticPerformanceSnapshots = false;
        this.mPerfMetrics = new Bundle();
    }

    private final void $$robo$$android_app_Instrumentation$checkInstrumenting(String method) {
        if (this.mInstrContext == null) {
            throw new RuntimeException(method + " cannot be called outside of instrumented processes");
        }
    }

    private final void $$robo$$android_app_Instrumentation$onCreate(Bundle arguments) {
    }

    private final void $$robo$$android_app_Instrumentation$start() {
        if (this.mRunner != null) {
            throw new RuntimeException("Instrumentation already started");
        }
        this.mRunner = new InstrumentationThread(this, "Instr: " + this.getClass().getName());
        this.mRunner.start();
    }

    private final void $$robo$$android_app_Instrumentation$onStart() {
    }

    private final boolean $$robo$$android_app_Instrumentation$onException(Object obj, Throwable e) {
        return false;
    }

    private final void $$robo$$android_app_Instrumentation$sendStatus(int resultCode, Bundle results) {
        if (this.mWatcher != null) {
            try {
                this.mWatcher.instrumentationStatus(this.mComponent, resultCode, results);
            }
            catch (RemoteException e) {
                this.mWatcher = null;
            }
        }
    }

    private final void $$robo$$android_app_Instrumentation$addResults(Bundle results) {
        IActivityManager am = ActivityManager.getService();
        try {
            am.addInstrumentationResults(this.mThread.getApplicationThread(), results);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_Instrumentation$finish(int resultCode, Bundle results) {
        if (this.mAutomaticPerformanceSnapshots) {
            this.endPerformanceSnapshot();
        }
        if (this.mPerfMetrics != null) {
            if (results == null) {
                results = new Bundle();
            }
            results.putAll(this.mPerfMetrics);
        }
        if (this.mUiAutomation != null && !this.mUiAutomation.isDestroyed()) {
            this.mUiAutomation.disconnect();
            this.mUiAutomation = null;
        }
        this.mThread.finishInstrumentation(resultCode, results);
    }

    private final void $$robo$$android_app_Instrumentation$setAutomaticPerformanceSnapshots() {
        this.mAutomaticPerformanceSnapshots = true;
        this.mPerformanceCollector = new PerformanceCollector();
    }

    private final void $$robo$$android_app_Instrumentation$startPerformanceSnapshot() {
        if (!this.isProfiling()) {
            this.mPerformanceCollector.beginSnapshot(null);
        }
    }

    private final void $$robo$$android_app_Instrumentation$endPerformanceSnapshot() {
        if (!this.isProfiling()) {
            this.mPerfMetrics = this.mPerformanceCollector.endSnapshot();
        }
    }

    private final void $$robo$$android_app_Instrumentation$onDestroy() {
    }

    private final Context $$robo$$android_app_Instrumentation$getContext() {
        return this.mInstrContext;
    }

    private final ComponentName $$robo$$android_app_Instrumentation$getComponentName() {
        return this.mComponent;
    }

    private final Context $$robo$$android_app_Instrumentation$getTargetContext() {
        return this.mAppContext;
    }

    private final String $$robo$$android_app_Instrumentation$getProcessName() {
        return this.mThread.getProcessName();
    }

    private final boolean $$robo$$android_app_Instrumentation$isProfiling() {
        return this.mThread.isProfiling();
    }

    private final void $$robo$$android_app_Instrumentation$startProfiling() {
        if (this.mThread.isProfiling()) {
            File file = new File(this.mThread.getProfileFilePath());
            file.getParentFile().mkdirs();
            Debug.startMethodTracing(file.toString(), 0x800000);
        }
    }

    private final void $$robo$$android_app_Instrumentation$stopProfiling() {
        if (this.mThread.isProfiling()) {
            Debug.stopMethodTracing();
        }
    }

    private final void $$robo$$android_app_Instrumentation$setInTouchMode(boolean inTouch) {
        try {
            IWindowManager.Stub.asInterface(ServiceManager.getService("window")).setInTouchMode(inTouch);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_app_Instrumentation$waitForIdle(Runnable recipient) {
        this.mMessageQueue.addIdleHandler(new Idler(recipient));
        this.mThread.getHandler().post(new EmptyRunnable());
    }

    private final void $$robo$$android_app_Instrumentation$waitForIdleSync() {
        this.validateNotAppThread();
        Idler idler = new Idler(null);
        this.mMessageQueue.addIdleHandler(idler);
        this.mThread.getHandler().post(new EmptyRunnable());
        idler.waitForIdle();
    }

    private final void $$robo$$android_app_Instrumentation$runOnMainSync(Runnable runner) {
        this.validateNotAppThread();
        SyncRunnable sr = new SyncRunnable(runner);
        this.mThread.getHandler().post(sr);
        sr.waitForComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Activity $$robo$$android_app_Instrumentation$startActivitySync(Intent intent) {
        this.validateNotAppThread();
        Object object = this.mSync;
        synchronized (object) {
            intent = new Intent(intent);
            ActivityInfo ai = intent.resolveActivityInfo(this.getTargetContext().getPackageManager(), 0);
            if (ai == null) {
                throw new RuntimeException("Unable to resolve activity for: " + intent);
            }
            String myProc = this.mThread.getProcessName();
            if (!ai.processName.equals(myProc)) {
                throw new RuntimeException("Intent in process " + myProc + " resolved to different process " + ai.processName + ": " + intent);
            }
            intent.setComponent(new ComponentName(ai.applicationInfo.packageName, ai.name));
            ActivityWaiter aw = new ActivityWaiter(intent);
            if (this.mWaitingActivities == null) {
                this.mWaitingActivities = new ArrayList<ActivityWaiter>();
            }
            this.mWaitingActivities.add(aw);
            this.getTargetContext().startActivity(intent);
            do {
                try {
                    this.mSync.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (this.mWaitingActivities.contains(aw));
            return aw.activity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_Instrumentation$addMonitor(ActivityMonitor monitor) {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mActivityMonitors == null) {
                this.mActivityMonitors = new ArrayList<ActivityMonitor>();
            }
            this.mActivityMonitors.add(monitor);
        }
    }

    private final ActivityMonitor $$robo$$android_app_Instrumentation$addMonitor(IntentFilter filter, ActivityResult result, boolean block) {
        ActivityMonitor am = new ActivityMonitor(filter, result, block);
        this.addMonitor(am);
        return am;
    }

    private final ActivityMonitor $$robo$$android_app_Instrumentation$addMonitor(String cls, ActivityResult result, boolean block) {
        ActivityMonitor am = new ActivityMonitor(cls, result, block);
        this.addMonitor(am);
        return am;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_app_Instrumentation$checkMonitorHit(ActivityMonitor monitor, int minHits) {
        this.waitForIdleSync();
        Object object = this.mSync;
        synchronized (object) {
            if (monitor.getHits() < minHits) {
                return false;
            }
            this.mActivityMonitors.remove(monitor);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Activity $$robo$$android_app_Instrumentation$waitForMonitor(ActivityMonitor monitor) {
        Activity activity = monitor.waitForActivity();
        Object object = this.mSync;
        synchronized (object) {
            this.mActivityMonitors.remove(monitor);
        }
        return activity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Activity $$robo$$android_app_Instrumentation$waitForMonitorWithTimeout(ActivityMonitor monitor, long timeOut) {
        Activity activity = monitor.waitForActivityWithTimeout(timeOut);
        Object object = this.mSync;
        synchronized (object) {
            this.mActivityMonitors.remove(monitor);
        }
        return activity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_Instrumentation$removeMonitor(ActivityMonitor monitor) {
        Object object = this.mSync;
        synchronized (object) {
            this.mActivityMonitors.remove(monitor);
        }
    }

    private final boolean $$robo$$android_app_Instrumentation$invokeMenuActionSync(Activity targetActivity, int id2, int flag) {
        public class MenuRunnable
        implements Runnable,
        ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            private Activity activity;
            private int identifier;
            private int flags;
            boolean returnValue;
            /* synthetic */ Instrumentation this$0;

            private void $$robo$$android_app_Instrumentation_1MenuRunnable$__constructor__(Instrumentation this$0, Activity _activity, int _identifier, int _flags) {
                this.activity = _activity;
                this.identifier = _identifier;
                this.flags = _flags;
            }

            private final void $$robo$$android_app_Instrumentation_1MenuRunnable$run() {
                Window win = this.activity.getWindow();
                this.returnValue = win.performPanelIdentifierAction(0, this.identifier, this.flags);
            }

            private void __constructor__(Instrumentation instrumentation, Activity activity, int n, int n2) {
                this.$$robo$$android_app_Instrumentation_1MenuRunnable$__constructor__(instrumentation, activity, n, n2);
            }

            public MenuRunnable(Instrumentation instrumentation, Activity activity, int n, int n2) {
                this.this$0 = instrumentation;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Instrumentation_1MenuRunnable$__constructor__(android.app.Instrumentation android.app.Activity int int ), 0, this, instrumentation, activity, n, n2);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_app_Instrumentation_1MenuRunnable$run(), 0, this);
            }

            public /* synthetic */ MenuRunnable() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MenuRunnable)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
        MenuRunnable mr = new MenuRunnable(this, targetActivity, id2, flag);
        this.runOnMainSync(mr);
        return mr.returnValue;
    }

    private final boolean $$robo$$android_app_Instrumentation$invokeContextMenuAction(Activity targetActivity, int id2, int flag) {
        this.validateNotAppThread();
        KeyEvent downEvent = new KeyEvent(0, 23);
        this.sendKeySync(downEvent);
        this.waitForIdleSync();
        try {
            Thread.sleep(ViewConfiguration.getLongPressTimeout());
        }
        catch (InterruptedException e) {
            Log.e("Instrumentation", "Could not sleep for long press timeout", e);
            return false;
        }
        KeyEvent upEvent = new KeyEvent(1, 23);
        this.sendKeySync(upEvent);
        this.waitForIdleSync();
        public class ContextMenuRunnable
        implements Runnable,
        ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            private Activity activity;
            private int identifier;
            private int flags;
            boolean returnValue;
            /* synthetic */ Instrumentation this$0;

            private void $$robo$$android_app_Instrumentation_1ContextMenuRunnable$__constructor__(Instrumentation this$0, Activity _activity, int _identifier, int _flags) {
                this.activity = _activity;
                this.identifier = _identifier;
                this.flags = _flags;
            }

            private final void $$robo$$android_app_Instrumentation_1ContextMenuRunnable$run() {
                Window win = this.activity.getWindow();
                this.returnValue = win.performContextMenuIdentifierAction(this.identifier, this.flags);
            }

            private void __constructor__(Instrumentation instrumentation, Activity activity, int n, int n2) {
                this.$$robo$$android_app_Instrumentation_1ContextMenuRunnable$__constructor__(instrumentation, activity, n, n2);
            }

            public ContextMenuRunnable(Instrumentation instrumentation, Activity activity, int n, int n2) {
                this.this$0 = instrumentation;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Instrumentation_1ContextMenuRunnable$__constructor__(android.app.Instrumentation android.app.Activity int int ), 0, this, instrumentation, activity, n, n2);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_app_Instrumentation_1ContextMenuRunnable$run(), 0, this);
            }

            public /* synthetic */ ContextMenuRunnable() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ContextMenuRunnable)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
        ContextMenuRunnable cmr = new ContextMenuRunnable(this, targetActivity, id2, flag);
        this.runOnMainSync(cmr);
        return cmr.returnValue;
    }

    private final void $$robo$$android_app_Instrumentation$sendStringSync(String text) {
        if (text == null) {
            return;
        }
        KeyCharacterMap keyCharacterMap = KeyCharacterMap.load(-1);
        KeyEvent[] events = keyCharacterMap.getEvents(text.toCharArray());
        if (events != null) {
            for (int i = 0; i < events.length; ++i) {
                this.sendKeySync(KeyEvent.changeTimeRepeat(events[i], SystemClock.uptimeMillis(), 0));
            }
        }
    }

    private final void $$robo$$android_app_Instrumentation$sendKeySync(KeyEvent event) {
        this.validateNotAppThread();
        long downTime = event.getDownTime();
        long eventTime = event.getEventTime();
        int action = event.getAction();
        int code = event.getKeyCode();
        int repeatCount = event.getRepeatCount();
        int metaState = event.getMetaState();
        int deviceId = event.getDeviceId();
        int scancode = event.getScanCode();
        int source = event.getSource();
        int flags = event.getFlags();
        if (source == 0) {
            source = 257;
        }
        if (eventTime == 0L) {
            eventTime = SystemClock.uptimeMillis();
        }
        if (downTime == 0L) {
            downTime = eventTime;
        }
        KeyEvent newEvent = new KeyEvent(downTime, eventTime, action, code, repeatCount, metaState, deviceId, scancode, flags | 8, source);
        InputManager.getInstance().injectInputEvent(newEvent, 2);
    }

    private final void $$robo$$android_app_Instrumentation$sendKeyDownUpSync(int key) {
        this.sendKeySync(new KeyEvent(0, key));
        this.sendKeySync(new KeyEvent(1, key));
    }

    private final void $$robo$$android_app_Instrumentation$sendCharacterSync(int keyCode) {
        this.sendKeySync(new KeyEvent(0, keyCode));
        this.sendKeySync(new KeyEvent(1, keyCode));
    }

    private final void $$robo$$android_app_Instrumentation$sendPointerSync(MotionEvent event) {
        this.validateNotAppThread();
        if ((event.getSource() & 2) == 0) {
            event.setSource(4098);
        }
        InputManager.getInstance().injectInputEvent(event, 2);
    }

    private final void $$robo$$android_app_Instrumentation$sendTrackballEventSync(MotionEvent event) {
        this.validateNotAppThread();
        if ((event.getSource() & 4) == 0) {
            event.setSource(65540);
        }
        InputManager.getInstance().injectInputEvent(event, 2);
    }

    private final Application $$robo$$android_app_Instrumentation$newApplication(ClassLoader cl, String className, Context context) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return Instrumentation.newApplication(cl.loadClass(className), context);
    }

    private static final Application $$robo$$android_app_Instrumentation$newApplication(Class<?> clazz, Context context) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Application app = (Application)clazz.newInstance();
        app.attach(context);
        return app;
    }

    private final void $$robo$$android_app_Instrumentation$callApplicationOnCreate(Application app) {
        app.onCreate();
    }

    private final Activity $$robo$$android_app_Instrumentation$newActivity(Class<?> clazz, Context context, IBinder token, Application application, Intent intent, ActivityInfo info, CharSequence title, Activity parent, String id2, Object lastNonConfigurationInstance) throws InstantiationException, IllegalAccessException {
        Activity activity = (Activity)clazz.newInstance();
        ActivityThread aThread = null;
        activity.attach(context, aThread, this, token, 0, application, intent, info, title, parent, id2, (Activity.NonConfigurationInstances)lastNonConfigurationInstance, new Configuration(), null, null, null, null);
        return activity;
    }

    private final Activity $$robo$$android_app_Instrumentation$newActivity(ClassLoader cl, String className, Intent intent) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return (Activity)cl.loadClass(className).newInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_Instrumentation$prePerformCreate(Activity activity) {
        if (this.mWaitingActivities != null) {
            Object object = this.mSync;
            synchronized (object) {
                int N = this.mWaitingActivities.size();
                for (int i = 0; i < N; ++i) {
                    ActivityWaiter aw = this.mWaitingActivities.get(i);
                    Intent intent = aw.intent;
                    if (!intent.filterEquals(activity.getIntent())) continue;
                    aw.activity = activity;
                    this.mMessageQueue.addIdleHandler(new ActivityGoing(this, aw));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_Instrumentation$postPerformCreate(Activity activity) {
        if (this.mActivityMonitors != null) {
            Object object = this.mSync;
            synchronized (object) {
                int N = this.mActivityMonitors.size();
                for (int i = 0; i < N; ++i) {
                    ActivityMonitor am = this.mActivityMonitors.get(i);
                    am.match(activity, activity, activity.getIntent());
                }
            }
        }
    }

    private final void $$robo$$android_app_Instrumentation$callActivityOnCreate(Activity activity, Bundle icicle) {
        this.prePerformCreate(activity);
        activity.performCreate(icicle);
        this.postPerformCreate(activity);
    }

    private final void $$robo$$android_app_Instrumentation$callActivityOnCreate(Activity activity, Bundle icicle, PersistableBundle persistentState) {
        this.prePerformCreate(activity);
        activity.performCreate(icicle, persistentState);
        this.postPerformCreate(activity);
    }

    private final void $$robo$$android_app_Instrumentation$callActivityOnDestroy(Activity activity) {
        activity.performDestroy();
    }

    private final void $$robo$$android_app_Instrumentation$callActivityOnRestoreInstanceState(Activity activity, Bundle savedInstanceState) {
        activity.performRestoreInstanceState(savedInstanceState);
    }

    private final void $$robo$$android_app_Instrumentation$callActivityOnRestoreInstanceState(Activity activity, Bundle savedInstanceState, PersistableBundle persistentState) {
        activity.performRestoreInstanceState(savedInstanceState, persistentState);
    }

    private final void $$robo$$android_app_Instrumentation$callActivityOnPostCreate(Activity activity, Bundle icicle) {
        activity.onPostCreate(icicle);
    }

    private final void $$robo$$android_app_Instrumentation$callActivityOnPostCreate(Activity activity, Bundle icicle, PersistableBundle persistentState) {
        activity.onPostCreate(icicle, persistentState);
    }

    private final void $$robo$$android_app_Instrumentation$callActivityOnNewIntent(Activity activity, Intent intent) {
        activity.performNewIntent(intent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_Instrumentation$callActivityOnNewIntent(Activity activity, ReferrerIntent intent) {
        String oldReferrer = activity.mReferrer;
        try {
            if (intent != null) {
                activity.mReferrer = intent.mReferrer;
            }
            this.callActivityOnNewIntent(activity, intent != null ? new Intent(intent) : null);
        }
        finally {
            activity.mReferrer = oldReferrer;
        }
    }

    private final void $$robo$$android_app_Instrumentation$callActivityOnStart(Activity activity) {
        activity.onStart();
    }

    private final void $$robo$$android_app_Instrumentation$callActivityOnRestart(Activity activity) {
        activity.onRestart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_Instrumentation$callActivityOnResume(Activity activity) {
        activity.mResumed = true;
        activity.onResume();
        if (this.mActivityMonitors != null) {
            Object object = this.mSync;
            synchronized (object) {
                int N = this.mActivityMonitors.size();
                for (int i = 0; i < N; ++i) {
                    ActivityMonitor am = this.mActivityMonitors.get(i);
                    am.match(activity, activity, activity.getIntent());
                }
            }
        }
    }

    private final void $$robo$$android_app_Instrumentation$callActivityOnStop(Activity activity) {
        activity.onStop();
    }

    private final void $$robo$$android_app_Instrumentation$callActivityOnSaveInstanceState(Activity activity, Bundle outState) {
        activity.performSaveInstanceState(outState);
    }

    private final void $$robo$$android_app_Instrumentation$callActivityOnSaveInstanceState(Activity activity, Bundle outState, PersistableBundle outPersistentState) {
        activity.performSaveInstanceState(outState, outPersistentState);
    }

    private final void $$robo$$android_app_Instrumentation$callActivityOnPause(Activity activity) {
        activity.performPause();
    }

    private final void $$robo$$android_app_Instrumentation$callActivityOnUserLeaving(Activity activity) {
        activity.performUserLeaving();
    }

    @Deprecated
    private final void $$robo$$android_app_Instrumentation$startAllocCounting() {
        Runtime.getRuntime().gc();
        Runtime.getRuntime().runFinalization();
        Runtime.getRuntime().gc();
        Debug.resetAllCounts();
        Debug.startAllocCounting();
    }

    @Deprecated
    private final void $$robo$$android_app_Instrumentation$stopAllocCounting() {
        Runtime.getRuntime().gc();
        Runtime.getRuntime().runFinalization();
        Runtime.getRuntime().gc();
        Debug.stopAllocCounting();
    }

    private final void $$robo$$android_app_Instrumentation$addValue(String key, int value, Bundle results) {
        if (results.containsKey(key)) {
            ArrayList<Integer> list = results.getIntegerArrayList(key);
            if (list != null) {
                list.add(value);
            }
        } else {
            ArrayList<Integer> list = new ArrayList<Integer>();
            list.add(value);
            results.putIntegerArrayList(key, list);
        }
    }

    private final Bundle $$robo$$android_app_Instrumentation$getAllocCounts() {
        Bundle results = new Bundle();
        results.putLong("global_alloc_count", Debug.getGlobalAllocCount());
        results.putLong("global_alloc_size", Debug.getGlobalAllocSize());
        results.putLong("global_freed_count", Debug.getGlobalFreedCount());
        results.putLong("global_freed_size", Debug.getGlobalFreedSize());
        results.putLong("gc_invocation_count", Debug.getGlobalGcInvocationCount());
        return results;
    }

    private final Bundle $$robo$$android_app_Instrumentation$getBinderCounts() {
        Bundle results = new Bundle();
        results.putLong("sent_transactions", Debug.getBinderSentTransactions());
        results.putLong("received_transactions", Debug.getBinderReceivedTransactions());
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ActivityResult $$robo$$android_app_Instrumentation$execStartActivity(Context who, IBinder contextThread, IBinder token, Activity target, Intent intent, int requestCode, Bundle options) {
        Uri referrer;
        IApplicationThread whoThread = (IApplicationThread)((Object)contextThread);
        Uri uri = referrer = target != null ? target.onProvideReferrer() : null;
        if (referrer != null) {
            intent.putExtra("android.intent.extra.REFERRER", referrer);
        }
        if (this.mActivityMonitors != null) {
            Object object = this.mSync;
            synchronized (object) {
                int N = this.mActivityMonitors.size();
                for (int i = 0; i < N; ++i) {
                    ActivityMonitor am = this.mActivityMonitors.get(i);
                    ActivityResult result = null;
                    if (am.ignoreMatchingSpecificIntents()) {
                        result = am.onStartActivity(intent);
                    }
                    if (result != null) {
                        ++am.mHits;
                        return result;
                    }
                    if (!am.match(who, null, intent)) continue;
                    ++am.mHits;
                    if (!am.isBlocking()) break;
                    return requestCode >= 0 ? am.getResult() : null;
                }
            }
        }
        try {
            intent.migrateExtraStreamToClipData();
            intent.prepareToLeaveProcess(who);
            int result = ActivityManager.getService().startActivity(whoThread, who.getBasePackageName(), intent, intent.resolveTypeIfNeeded(who.getContentResolver()), token, target != null ? target.mEmbeddedID : null, requestCode, 0, null, options);
            Instrumentation.checkStartActivityResult(result, intent);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Failure from system", e);
        }
        return null;
    }

    private final void $$robo$$android_app_Instrumentation$execStartActivities(Context who, IBinder contextThread, IBinder token, Activity target, Intent[] intents, Bundle options) {
        this.execStartActivitiesAsUser(who, contextThread, token, target, intents, options, UserHandle.myUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_Instrumentation$execStartActivitiesAsUser(Context who, IBinder contextThread, IBinder token, Activity target, Intent[] intents, Bundle options, int userId) {
        IApplicationThread whoThread = (IApplicationThread)((Object)contextThread);
        if (this.mActivityMonitors != null) {
            Object object = this.mSync;
            synchronized (object) {
                int N = this.mActivityMonitors.size();
                for (int i = 0; i < N; ++i) {
                    ActivityMonitor am = this.mActivityMonitors.get(i);
                    ActivityResult result = null;
                    if (am.ignoreMatchingSpecificIntents()) {
                        result = am.onStartActivity(intents[0]);
                    }
                    if (result != null) {
                        ++am.mHits;
                        return;
                    }
                    if (!am.match(who, null, intents[0])) continue;
                    ++am.mHits;
                    if (!am.isBlocking()) break;
                    return;
                }
            }
        }
        try {
            String[] resolvedTypes = new String[intents.length];
            for (int i = 0; i < intents.length; ++i) {
                intents[i].migrateExtraStreamToClipData();
                intents[i].prepareToLeaveProcess(who);
                resolvedTypes[i] = intents[i].resolveTypeIfNeeded(who.getContentResolver());
            }
            int result = ActivityManager.getService().startActivities(whoThread, who.getBasePackageName(), intents, resolvedTypes, token, options, userId);
            Instrumentation.checkStartActivityResult(result, intents[0]);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Failure from system", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ActivityResult $$robo$$android_app_Instrumentation$execStartActivity(Context who, IBinder contextThread, IBinder token, String target, Intent intent, int requestCode, Bundle options) {
        IApplicationThread whoThread = (IApplicationThread)((Object)contextThread);
        if (this.mActivityMonitors != null) {
            Object object = this.mSync;
            synchronized (object) {
                int N = this.mActivityMonitors.size();
                for (int i = 0; i < N; ++i) {
                    ActivityMonitor am = this.mActivityMonitors.get(i);
                    ActivityResult result = null;
                    if (am.ignoreMatchingSpecificIntents()) {
                        result = am.onStartActivity(intent);
                    }
                    if (result != null) {
                        ++am.mHits;
                        return result;
                    }
                    if (!am.match(who, null, intent)) continue;
                    ++am.mHits;
                    if (!am.isBlocking()) break;
                    return requestCode >= 0 ? am.getResult() : null;
                }
            }
        }
        try {
            intent.migrateExtraStreamToClipData();
            intent.prepareToLeaveProcess(who);
            int result = ActivityManager.getService().startActivity(whoThread, who.getBasePackageName(), intent, intent.resolveTypeIfNeeded(who.getContentResolver()), token, target, requestCode, 0, null, options);
            Instrumentation.checkStartActivityResult(result, intent);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Failure from system", e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ActivityResult $$robo$$android_app_Instrumentation$execStartActivity(Context who, IBinder contextThread, IBinder token, String resultWho, Intent intent, int requestCode, Bundle options, UserHandle user) {
        IApplicationThread whoThread = (IApplicationThread)((Object)contextThread);
        if (this.mActivityMonitors != null) {
            Object object = this.mSync;
            synchronized (object) {
                int N = this.mActivityMonitors.size();
                for (int i = 0; i < N; ++i) {
                    ActivityMonitor am = this.mActivityMonitors.get(i);
                    ActivityResult result = null;
                    if (am.ignoreMatchingSpecificIntents()) {
                        result = am.onStartActivity(intent);
                    }
                    if (result != null) {
                        ++am.mHits;
                        return result;
                    }
                    if (!am.match(who, null, intent)) continue;
                    ++am.mHits;
                    if (!am.isBlocking()) break;
                    return requestCode >= 0 ? am.getResult() : null;
                }
            }
        }
        try {
            intent.migrateExtraStreamToClipData();
            intent.prepareToLeaveProcess(who);
            int result = ActivityManager.getService().startActivityAsUser(whoThread, who.getBasePackageName(), intent, intent.resolveTypeIfNeeded(who.getContentResolver()), token, resultWho, requestCode, 0, null, options, user.getIdentifier());
            Instrumentation.checkStartActivityResult(result, intent);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Failure from system", e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ActivityResult $$robo$$android_app_Instrumentation$execStartActivityAsCaller(Context who, IBinder contextThread, IBinder token, Activity target, Intent intent, int requestCode, Bundle options, boolean ignoreTargetSecurity, int userId) {
        IApplicationThread whoThread = (IApplicationThread)((Object)contextThread);
        if (this.mActivityMonitors != null) {
            Object object = this.mSync;
            synchronized (object) {
                int N = this.mActivityMonitors.size();
                for (int i = 0; i < N; ++i) {
                    ActivityMonitor am = this.mActivityMonitors.get(i);
                    ActivityResult result = null;
                    if (am.ignoreMatchingSpecificIntents()) {
                        result = am.onStartActivity(intent);
                    }
                    if (result != null) {
                        ++am.mHits;
                        return result;
                    }
                    if (!am.match(who, null, intent)) continue;
                    ++am.mHits;
                    if (!am.isBlocking()) break;
                    return requestCode >= 0 ? am.getResult() : null;
                }
            }
        }
        try {
            intent.migrateExtraStreamToClipData();
            intent.prepareToLeaveProcess(who);
            int result = ActivityManager.getService().startActivityAsCaller(whoThread, who.getBasePackageName(), intent, intent.resolveTypeIfNeeded(who.getContentResolver()), token, target != null ? target.mEmbeddedID : null, requestCode, 0, null, options, ignoreTargetSecurity, userId);
            Instrumentation.checkStartActivityResult(result, intent);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Failure from system", e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_Instrumentation$execStartActivityFromAppTask(Context who, IBinder contextThread, IAppTask appTask, Intent intent, Bundle options) {
        IApplicationThread whoThread = (IApplicationThread)((Object)contextThread);
        if (this.mActivityMonitors != null) {
            Object object = this.mSync;
            synchronized (object) {
                int N = this.mActivityMonitors.size();
                for (int i = 0; i < N; ++i) {
                    ActivityMonitor am = this.mActivityMonitors.get(i);
                    ActivityResult result = null;
                    if (am.ignoreMatchingSpecificIntents()) {
                        result = am.onStartActivity(intent);
                    }
                    if (result != null) {
                        ++am.mHits;
                        return;
                    }
                    if (!am.match(who, null, intent)) continue;
                    ++am.mHits;
                    if (!am.isBlocking()) break;
                    return;
                }
            }
        }
        try {
            intent.migrateExtraStreamToClipData();
            intent.prepareToLeaveProcess(who);
            int result = appTask.startActivity(whoThread.asBinder(), who.getBasePackageName(), intent, intent.resolveTypeIfNeeded(who.getContentResolver()), options);
            Instrumentation.checkStartActivityResult(result, intent);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Failure from system", e);
        }
    }

    private final void $$robo$$android_app_Instrumentation$init(ActivityThread thread, Context instrContext, Context appContext, ComponentName component, IInstrumentationWatcher watcher, IUiAutomationConnection uiAutomationConnection) {
        this.mThread = thread;
        this.mThread.getLooper();
        this.mMessageQueue = Looper.myQueue();
        this.mInstrContext = instrContext;
        this.mAppContext = appContext;
        this.mComponent = component;
        this.mWatcher = watcher;
        this.mUiAutomationConnection = uiAutomationConnection;
    }

    private static final void $$robo$$android_app_Instrumentation$checkStartActivityResult(int res, Object intent) {
        if (!ActivityManager.isStartResultFatalError(res)) {
            return;
        }
        switch (res) {
            case -92: 
            case -91: {
                if (intent instanceof Intent && ((Intent)intent).getComponent() != null) {
                    throw new ActivityNotFoundException("Unable to find explicit activity class " + ((Intent)intent).getComponent().toShortString() + "; have you declared this activity in your AndroidManifest.xml?");
                }
                throw new ActivityNotFoundException("No Activity found to handle " + intent);
            }
            case -94: {
                throw new SecurityException("Not allowed to start activity " + intent);
            }
            case -93: {
                throw new AndroidRuntimeException("FORWARD_RESULT_FLAG used while also requesting a result");
            }
            case -95: {
                throw new IllegalArgumentException("PendingIntent is not an activity");
            }
            case -97: {
                throw new SecurityException("Starting under voice control not allowed for: " + intent);
            }
            case -99: {
                throw new IllegalStateException("Session calling startVoiceActivity does not match active session");
            }
            case -100: {
                throw new IllegalStateException("Cannot start voice activity on a hidden session");
            }
            case -89: {
                throw new IllegalStateException("Session calling startAssistantActivity does not match active session");
            }
            case -90: {
                throw new IllegalStateException("Cannot start assistant activity on a hidden session");
            }
            case -96: {
                throw new AndroidRuntimeException("Activity could not be started for " + intent);
            }
        }
        throw new AndroidRuntimeException("Unknown error code " + res + " when starting " + intent);
    }

    private final void $$robo$$android_app_Instrumentation$validateNotAppThread() {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("This method can not be called from the main application thread");
        }
    }

    private final UiAutomation $$robo$$android_app_Instrumentation$getUiAutomation() {
        return this.getUiAutomation(0);
    }

    private final UiAutomation $$robo$$android_app_Instrumentation$getUiAutomation(int flags) {
        boolean mustCreateNewAutomation;
        boolean bl = mustCreateNewAutomation = this.mUiAutomation == null || this.mUiAutomation.isDestroyed();
        if (this.mUiAutomationConnection != null) {
            if (!mustCreateNewAutomation && this.mUiAutomation.getFlags() == flags) {
                return this.mUiAutomation;
            }
            if (mustCreateNewAutomation) {
                this.mUiAutomation = new UiAutomation(this.getTargetContext().getMainLooper(), this.mUiAutomationConnection);
            } else {
                this.mUiAutomation.disconnect();
            }
            this.mUiAutomation.connect(flags);
            return this.mUiAutomation;
        }
        return null;
    }

    private final TestLooperManager $$robo$$android_app_Instrumentation$acquireLooperManager(Looper looper) {
        this.checkInstrumenting("acquireLooperManager");
        return new TestLooperManager(looper);
    }

    private void __constructor__() {
        this.$$robo$$android_app_Instrumentation$__constructor__();
    }

    public Instrumentation() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Instrumentation$__constructor__(), 0, this);
    }

    private void checkInstrumenting(String string2) {
        InvokeDynamicSupport.bootstrap("checkInstrumenting", $$robo$$android_app_Instrumentation$checkInstrumenting(java.lang.String ), 0, this, string2);
    }

    public void onCreate(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("onCreate", $$robo$$android_app_Instrumentation$onCreate(android.os.Bundle ), 0, this, bundle);
    }

    public void start() {
        InvokeDynamicSupport.bootstrap("start", $$robo$$android_app_Instrumentation$start(), 0, this);
    }

    public void onStart() {
        InvokeDynamicSupport.bootstrap("onStart", $$robo$$android_app_Instrumentation$onStart(), 0, this);
    }

    public boolean onException(Object object, Throwable throwable) {
        return (boolean)InvokeDynamicSupport.bootstrap("onException", $$robo$$android_app_Instrumentation$onException(java.lang.Object java.lang.Throwable ), 0, this, object, throwable);
    }

    public void sendStatus(int n, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("sendStatus", $$robo$$android_app_Instrumentation$sendStatus(int android.os.Bundle ), 0, this, n, bundle);
    }

    public void addResults(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("addResults", $$robo$$android_app_Instrumentation$addResults(android.os.Bundle ), 0, this, bundle);
    }

    public void finish(int n, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("finish", $$robo$$android_app_Instrumentation$finish(int android.os.Bundle ), 0, this, n, bundle);
    }

    public void setAutomaticPerformanceSnapshots() {
        InvokeDynamicSupport.bootstrap("setAutomaticPerformanceSnapshots", $$robo$$android_app_Instrumentation$setAutomaticPerformanceSnapshots(), 0, this);
    }

    public void startPerformanceSnapshot() {
        InvokeDynamicSupport.bootstrap("startPerformanceSnapshot", $$robo$$android_app_Instrumentation$startPerformanceSnapshot(), 0, this);
    }

    public void endPerformanceSnapshot() {
        InvokeDynamicSupport.bootstrap("endPerformanceSnapshot", $$robo$$android_app_Instrumentation$endPerformanceSnapshot(), 0, this);
    }

    public void onDestroy() {
        InvokeDynamicSupport.bootstrap("onDestroy", $$robo$$android_app_Instrumentation$onDestroy(), 0, this);
    }

    public Context getContext() {
        return InvokeDynamicSupport.bootstrap("getContext", $$robo$$android_app_Instrumentation$getContext(), 0, this);
    }

    public ComponentName getComponentName() {
        return InvokeDynamicSupport.bootstrap("getComponentName", $$robo$$android_app_Instrumentation$getComponentName(), 0, this);
    }

    public Context getTargetContext() {
        return InvokeDynamicSupport.bootstrap("getTargetContext", $$robo$$android_app_Instrumentation$getTargetContext(), 0, this);
    }

    public String getProcessName() {
        return InvokeDynamicSupport.bootstrap("getProcessName", $$robo$$android_app_Instrumentation$getProcessName(), 0, this);
    }

    public boolean isProfiling() {
        return (boolean)InvokeDynamicSupport.bootstrap("isProfiling", $$robo$$android_app_Instrumentation$isProfiling(), 0, this);
    }

    public void startProfiling() {
        InvokeDynamicSupport.bootstrap("startProfiling", $$robo$$android_app_Instrumentation$startProfiling(), 0, this);
    }

    public void stopProfiling() {
        InvokeDynamicSupport.bootstrap("stopProfiling", $$robo$$android_app_Instrumentation$stopProfiling(), 0, this);
    }

    public void setInTouchMode(boolean bl) {
        InvokeDynamicSupport.bootstrap("setInTouchMode", $$robo$$android_app_Instrumentation$setInTouchMode(boolean ), 0, this, bl);
    }

    public void waitForIdle(Runnable runnable) {
        InvokeDynamicSupport.bootstrap("waitForIdle", $$robo$$android_app_Instrumentation$waitForIdle(java.lang.Runnable ), 0, this, runnable);
    }

    public void waitForIdleSync() {
        InvokeDynamicSupport.bootstrap("waitForIdleSync", $$robo$$android_app_Instrumentation$waitForIdleSync(), 0, this);
    }

    public void runOnMainSync(Runnable runnable) {
        InvokeDynamicSupport.bootstrap("runOnMainSync", $$robo$$android_app_Instrumentation$runOnMainSync(java.lang.Runnable ), 0, this, runnable);
    }

    public Activity startActivitySync(Intent intent) {
        return InvokeDynamicSupport.bootstrap("startActivitySync", $$robo$$android_app_Instrumentation$startActivitySync(android.content.Intent ), 0, this, intent);
    }

    public void addMonitor(ActivityMonitor activityMonitor) {
        InvokeDynamicSupport.bootstrap("addMonitor", $$robo$$android_app_Instrumentation$addMonitor(android.app.Instrumentation$ActivityMonitor ), 0, this, activityMonitor);
    }

    public ActivityMonitor addMonitor(IntentFilter intentFilter, ActivityResult activityResult, boolean bl) {
        return InvokeDynamicSupport.bootstrap("addMonitor", $$robo$$android_app_Instrumentation$addMonitor(android.content.IntentFilter android.app.Instrumentation$ActivityResult boolean ), 0, this, intentFilter, activityResult, bl);
    }

    public ActivityMonitor addMonitor(String string2, ActivityResult activityResult, boolean bl) {
        return InvokeDynamicSupport.bootstrap("addMonitor", $$robo$$android_app_Instrumentation$addMonitor(java.lang.String android.app.Instrumentation$ActivityResult boolean ), 0, this, string2, activityResult, bl);
    }

    public boolean checkMonitorHit(ActivityMonitor activityMonitor, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("checkMonitorHit", $$robo$$android_app_Instrumentation$checkMonitorHit(android.app.Instrumentation$ActivityMonitor int ), 0, this, activityMonitor, n);
    }

    public Activity waitForMonitor(ActivityMonitor activityMonitor) {
        return InvokeDynamicSupport.bootstrap("waitForMonitor", $$robo$$android_app_Instrumentation$waitForMonitor(android.app.Instrumentation$ActivityMonitor ), 0, this, activityMonitor);
    }

    public Activity waitForMonitorWithTimeout(ActivityMonitor activityMonitor, long l) {
        return InvokeDynamicSupport.bootstrap("waitForMonitorWithTimeout", $$robo$$android_app_Instrumentation$waitForMonitorWithTimeout(android.app.Instrumentation$ActivityMonitor long ), 0, this, activityMonitor, l);
    }

    public void removeMonitor(ActivityMonitor activityMonitor) {
        InvokeDynamicSupport.bootstrap("removeMonitor", $$robo$$android_app_Instrumentation$removeMonitor(android.app.Instrumentation$ActivityMonitor ), 0, this, activityMonitor);
    }

    public boolean invokeMenuActionSync(Activity activity, int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("invokeMenuActionSync", $$robo$$android_app_Instrumentation$invokeMenuActionSync(android.app.Activity int int ), 0, this, activity, n, n2);
    }

    public boolean invokeContextMenuAction(Activity activity, int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("invokeContextMenuAction", $$robo$$android_app_Instrumentation$invokeContextMenuAction(android.app.Activity int int ), 0, this, activity, n, n2);
    }

    public void sendStringSync(String string2) {
        InvokeDynamicSupport.bootstrap("sendStringSync", $$robo$$android_app_Instrumentation$sendStringSync(java.lang.String ), 0, this, string2);
    }

    public void sendKeySync(KeyEvent keyEvent) {
        InvokeDynamicSupport.bootstrap("sendKeySync", $$robo$$android_app_Instrumentation$sendKeySync(android.view.KeyEvent ), 0, this, keyEvent);
    }

    public void sendKeyDownUpSync(int n) {
        InvokeDynamicSupport.bootstrap("sendKeyDownUpSync", $$robo$$android_app_Instrumentation$sendKeyDownUpSync(int ), 0, this, n);
    }

    public void sendCharacterSync(int n) {
        InvokeDynamicSupport.bootstrap("sendCharacterSync", $$robo$$android_app_Instrumentation$sendCharacterSync(int ), 0, this, n);
    }

    public void sendPointerSync(MotionEvent motionEvent) {
        InvokeDynamicSupport.bootstrap("sendPointerSync", $$robo$$android_app_Instrumentation$sendPointerSync(android.view.MotionEvent ), 0, this, motionEvent);
    }

    public void sendTrackballEventSync(MotionEvent motionEvent) {
        InvokeDynamicSupport.bootstrap("sendTrackballEventSync", $$robo$$android_app_Instrumentation$sendTrackballEventSync(android.view.MotionEvent ), 0, this, motionEvent);
    }

    public Application newApplication(ClassLoader classLoader, String string2, Context context) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return InvokeDynamicSupport.bootstrap("newApplication", $$robo$$android_app_Instrumentation$newApplication(java.lang.ClassLoader java.lang.String android.content.Context ), 0, this, classLoader, string2, context);
    }

    public static Application newApplication(Class<?> clazz, Context context) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return InvokeDynamicSupport.bootstrapStatic("newApplication", $$robo$$android_app_Instrumentation$newApplication(java.lang.Class<?> android.content.Context ), 0, clazz, (Context)context);
    }

    public void callApplicationOnCreate(Application application) {
        InvokeDynamicSupport.bootstrap("callApplicationOnCreate", $$robo$$android_app_Instrumentation$callApplicationOnCreate(android.app.Application ), 0, this, application);
    }

    public Activity newActivity(Class<?> clazz, Context context, IBinder iBinder, Application application, Intent intent, ActivityInfo activityInfo, CharSequence charSequence, Activity activity, String string2, Object object) throws InstantiationException, IllegalAccessException {
        return InvokeDynamicSupport.bootstrap("newActivity", $$robo$$android_app_Instrumentation$newActivity(java.lang.Class<?> android.content.Context android.os.IBinder android.app.Application android.content.Intent android.content.pm.ActivityInfo java.lang.CharSequence android.app.Activity java.lang.String java.lang.Object ), 0, this, clazz, context, iBinder, application, intent, activityInfo, charSequence, activity, string2, object);
    }

    public Activity newActivity(ClassLoader classLoader, String string2, Intent intent) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return InvokeDynamicSupport.bootstrap("newActivity", $$robo$$android_app_Instrumentation$newActivity(java.lang.ClassLoader java.lang.String android.content.Intent ), 0, this, classLoader, string2, intent);
    }

    private void prePerformCreate(Activity activity) {
        InvokeDynamicSupport.bootstrap("prePerformCreate", $$robo$$android_app_Instrumentation$prePerformCreate(android.app.Activity ), 0, this, activity);
    }

    private void postPerformCreate(Activity activity) {
        InvokeDynamicSupport.bootstrap("postPerformCreate", $$robo$$android_app_Instrumentation$postPerformCreate(android.app.Activity ), 0, this, activity);
    }

    public void callActivityOnCreate(Activity activity, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("callActivityOnCreate", $$robo$$android_app_Instrumentation$callActivityOnCreate(android.app.Activity android.os.Bundle ), 0, this, activity, bundle);
    }

    public void callActivityOnCreate(Activity activity, Bundle bundle, PersistableBundle persistableBundle) {
        InvokeDynamicSupport.bootstrap("callActivityOnCreate", $$robo$$android_app_Instrumentation$callActivityOnCreate(android.app.Activity android.os.Bundle android.os.PersistableBundle ), 0, this, activity, bundle, persistableBundle);
    }

    public void callActivityOnDestroy(Activity activity) {
        InvokeDynamicSupport.bootstrap("callActivityOnDestroy", $$robo$$android_app_Instrumentation$callActivityOnDestroy(android.app.Activity ), 0, this, activity);
    }

    public void callActivityOnRestoreInstanceState(Activity activity, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("callActivityOnRestoreInstanceState", $$robo$$android_app_Instrumentation$callActivityOnRestoreInstanceState(android.app.Activity android.os.Bundle ), 0, this, activity, bundle);
    }

    public void callActivityOnRestoreInstanceState(Activity activity, Bundle bundle, PersistableBundle persistableBundle) {
        InvokeDynamicSupport.bootstrap("callActivityOnRestoreInstanceState", $$robo$$android_app_Instrumentation$callActivityOnRestoreInstanceState(android.app.Activity android.os.Bundle android.os.PersistableBundle ), 0, this, activity, bundle, persistableBundle);
    }

    public void callActivityOnPostCreate(Activity activity, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("callActivityOnPostCreate", $$robo$$android_app_Instrumentation$callActivityOnPostCreate(android.app.Activity android.os.Bundle ), 0, this, activity, bundle);
    }

    public void callActivityOnPostCreate(Activity activity, Bundle bundle, PersistableBundle persistableBundle) {
        InvokeDynamicSupport.bootstrap("callActivityOnPostCreate", $$robo$$android_app_Instrumentation$callActivityOnPostCreate(android.app.Activity android.os.Bundle android.os.PersistableBundle ), 0, this, activity, bundle, persistableBundle);
    }

    public void callActivityOnNewIntent(Activity activity, Intent intent) {
        InvokeDynamicSupport.bootstrap("callActivityOnNewIntent", $$robo$$android_app_Instrumentation$callActivityOnNewIntent(android.app.Activity android.content.Intent ), 0, this, activity, intent);
    }

    public void callActivityOnNewIntent(Activity activity, ReferrerIntent referrerIntent) {
        InvokeDynamicSupport.bootstrap("callActivityOnNewIntent", $$robo$$android_app_Instrumentation$callActivityOnNewIntent(android.app.Activity com.android.internal.content.ReferrerIntent ), 0, this, activity, referrerIntent);
    }

    public void callActivityOnStart(Activity activity) {
        InvokeDynamicSupport.bootstrap("callActivityOnStart", $$robo$$android_app_Instrumentation$callActivityOnStart(android.app.Activity ), 0, this, activity);
    }

    public void callActivityOnRestart(Activity activity) {
        InvokeDynamicSupport.bootstrap("callActivityOnRestart", $$robo$$android_app_Instrumentation$callActivityOnRestart(android.app.Activity ), 0, this, activity);
    }

    public void callActivityOnResume(Activity activity) {
        InvokeDynamicSupport.bootstrap("callActivityOnResume", $$robo$$android_app_Instrumentation$callActivityOnResume(android.app.Activity ), 0, this, activity);
    }

    public void callActivityOnStop(Activity activity) {
        InvokeDynamicSupport.bootstrap("callActivityOnStop", $$robo$$android_app_Instrumentation$callActivityOnStop(android.app.Activity ), 0, this, activity);
    }

    public void callActivityOnSaveInstanceState(Activity activity, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("callActivityOnSaveInstanceState", $$robo$$android_app_Instrumentation$callActivityOnSaveInstanceState(android.app.Activity android.os.Bundle ), 0, this, activity, bundle);
    }

    public void callActivityOnSaveInstanceState(Activity activity, Bundle bundle, PersistableBundle persistableBundle) {
        InvokeDynamicSupport.bootstrap("callActivityOnSaveInstanceState", $$robo$$android_app_Instrumentation$callActivityOnSaveInstanceState(android.app.Activity android.os.Bundle android.os.PersistableBundle ), 0, this, activity, bundle, persistableBundle);
    }

    public void callActivityOnPause(Activity activity) {
        InvokeDynamicSupport.bootstrap("callActivityOnPause", $$robo$$android_app_Instrumentation$callActivityOnPause(android.app.Activity ), 0, this, activity);
    }

    public void callActivityOnUserLeaving(Activity activity) {
        InvokeDynamicSupport.bootstrap("callActivityOnUserLeaving", $$robo$$android_app_Instrumentation$callActivityOnUserLeaving(android.app.Activity ), 0, this, activity);
    }

    @Deprecated
    public void startAllocCounting() {
        InvokeDynamicSupport.bootstrap("startAllocCounting", $$robo$$android_app_Instrumentation$startAllocCounting(), 0, this);
    }

    @Deprecated
    public void stopAllocCounting() {
        InvokeDynamicSupport.bootstrap("stopAllocCounting", $$robo$$android_app_Instrumentation$stopAllocCounting(), 0, this);
    }

    private void addValue(String string2, int n, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("addValue", $$robo$$android_app_Instrumentation$addValue(java.lang.String int android.os.Bundle ), 0, this, string2, n, bundle);
    }

    public Bundle getAllocCounts() {
        return InvokeDynamicSupport.bootstrap("getAllocCounts", $$robo$$android_app_Instrumentation$getAllocCounts(), 0, this);
    }

    public Bundle getBinderCounts() {
        return InvokeDynamicSupport.bootstrap("getBinderCounts", $$robo$$android_app_Instrumentation$getBinderCounts(), 0, this);
    }

    public ActivityResult execStartActivity(Context context, IBinder iBinder, IBinder iBinder2, Activity activity, Intent intent, int n, Bundle bundle) {
        return InvokeDynamicSupport.bootstrap("execStartActivity", $$robo$$android_app_Instrumentation$execStartActivity(android.content.Context android.os.IBinder android.os.IBinder android.app.Activity android.content.Intent int android.os.Bundle ), 0, this, context, iBinder, iBinder2, activity, intent, n, bundle);
    }

    public void execStartActivities(Context context, IBinder iBinder, IBinder iBinder2, Activity activity, Intent[] intentArray, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("execStartActivities", $$robo$$android_app_Instrumentation$execStartActivities(android.content.Context android.os.IBinder android.os.IBinder android.app.Activity android.content.Intent[] android.os.Bundle ), 0, this, context, iBinder, iBinder2, activity, intentArray, bundle);
    }

    public void execStartActivitiesAsUser(Context context, IBinder iBinder, IBinder iBinder2, Activity activity, Intent[] intentArray, Bundle bundle, int n) {
        InvokeDynamicSupport.bootstrap("execStartActivitiesAsUser", $$robo$$android_app_Instrumentation$execStartActivitiesAsUser(android.content.Context android.os.IBinder android.os.IBinder android.app.Activity android.content.Intent[] android.os.Bundle int ), 0, this, context, iBinder, iBinder2, activity, intentArray, bundle, n);
    }

    public ActivityResult execStartActivity(Context context, IBinder iBinder, IBinder iBinder2, String string2, Intent intent, int n, Bundle bundle) {
        return InvokeDynamicSupport.bootstrap("execStartActivity", $$robo$$android_app_Instrumentation$execStartActivity(android.content.Context android.os.IBinder android.os.IBinder java.lang.String android.content.Intent int android.os.Bundle ), 0, this, context, iBinder, iBinder2, string2, intent, n, bundle);
    }

    public ActivityResult execStartActivity(Context context, IBinder iBinder, IBinder iBinder2, String string2, Intent intent, int n, Bundle bundle, UserHandle userHandle) {
        return InvokeDynamicSupport.bootstrap("execStartActivity", $$robo$$android_app_Instrumentation$execStartActivity(android.content.Context android.os.IBinder android.os.IBinder java.lang.String android.content.Intent int android.os.Bundle android.os.UserHandle ), 0, this, context, iBinder, iBinder2, string2, intent, n, bundle, userHandle);
    }

    public ActivityResult execStartActivityAsCaller(Context context, IBinder iBinder, IBinder iBinder2, Activity activity, Intent intent, int n, Bundle bundle, boolean bl, int n2) {
        return InvokeDynamicSupport.bootstrap("execStartActivityAsCaller", $$robo$$android_app_Instrumentation$execStartActivityAsCaller(android.content.Context android.os.IBinder android.os.IBinder android.app.Activity android.content.Intent int android.os.Bundle boolean int ), 0, this, context, iBinder, iBinder2, activity, intent, n, bundle, bl, n2);
    }

    public void execStartActivityFromAppTask(Context context, IBinder iBinder, IAppTask iAppTask, Intent intent, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("execStartActivityFromAppTask", $$robo$$android_app_Instrumentation$execStartActivityFromAppTask(android.content.Context android.os.IBinder android.app.IAppTask android.content.Intent android.os.Bundle ), 0, this, context, iBinder, iAppTask, intent, bundle);
    }

    void init(ActivityThread activityThread, Context context, Context context2, ComponentName componentName, IInstrumentationWatcher iInstrumentationWatcher, IUiAutomationConnection iUiAutomationConnection) {
        InvokeDynamicSupport.bootstrap("init", $$robo$$android_app_Instrumentation$init(android.app.ActivityThread android.content.Context android.content.Context android.content.ComponentName android.app.IInstrumentationWatcher android.app.IUiAutomationConnection ), 0, this, activityThread, context, context2, componentName, iInstrumentationWatcher, iUiAutomationConnection);
    }

    public static void checkStartActivityResult(int n, Object object) {
        InvokeDynamicSupport.bootstrapStatic("checkStartActivityResult", $$robo$$android_app_Instrumentation$checkStartActivityResult(int java.lang.Object ), 0, (int)n, (Object)object);
    }

    private void validateNotAppThread() {
        InvokeDynamicSupport.bootstrap("validateNotAppThread", $$robo$$android_app_Instrumentation$validateNotAppThread(), 0, this);
    }

    public UiAutomation getUiAutomation() {
        return InvokeDynamicSupport.bootstrap("getUiAutomation", $$robo$$android_app_Instrumentation$getUiAutomation(), 0, this);
    }

    public UiAutomation getUiAutomation(int n) {
        return InvokeDynamicSupport.bootstrap("getUiAutomation", $$robo$$android_app_Instrumentation$getUiAutomation(int ), 0, this, n);
    }

    public TestLooperManager acquireLooperManager(Looper looper) {
        return InvokeDynamicSupport.bootstrap("acquireLooperManager", $$robo$$android_app_Instrumentation$acquireLooperManager(android.os.Looper ), 0, this, looper);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Instrumentation)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class Idler
    implements MessageQueue.IdleHandler,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Runnable mCallback;
        private boolean mIdle;

        private void $$robo$$android_app_Instrumentation_Idler$__constructor__(Runnable callback) {
            this.mCallback = callback;
            this.mIdle = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean $$robo$$android_app_Instrumentation_Idler$queueIdle() {
            if (this.mCallback != null) {
                this.mCallback.run();
            }
            Idler idler = this;
            synchronized (idler) {
                this.mIdle = true;
                this.notifyAll();
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_app_Instrumentation_Idler$waitForIdle() {
            Idler idler = this;
            synchronized (idler) {
                while (!this.mIdle) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        private void __constructor__(Runnable runnable) {
            this.$$robo$$android_app_Instrumentation_Idler$__constructor__(runnable);
        }

        public Idler(Runnable runnable) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Instrumentation_Idler$__constructor__(java.lang.Runnable ), 0, this, runnable);
        }

        @Override
        public boolean queueIdle() {
            return (boolean)InvokeDynamicSupport.bootstrap("queueIdle", $$robo$$android_app_Instrumentation_Idler$queueIdle(), 0, this);
        }

        public void waitForIdle() {
            InvokeDynamicSupport.bootstrap("waitForIdle", $$robo$$android_app_Instrumentation_Idler$waitForIdle(), 0, this);
        }

        public /* synthetic */ Idler() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Idler)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private final class ActivityGoing
    implements MessageQueue.IdleHandler,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private ActivityWaiter mWaiter;
        /* synthetic */ Instrumentation this$0;

        private void $$robo$$android_app_Instrumentation_ActivityGoing$__constructor__(Instrumentation instrumentation, ActivityWaiter waiter) {
            this.mWaiter = waiter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean $$robo$$android_app_Instrumentation_ActivityGoing$queueIdle() {
            Object object = this.this$0.mSync;
            synchronized (object) {
                this.this$0.mWaitingActivities.remove(this.mWaiter);
                this.this$0.mSync.notifyAll();
            }
            return false;
        }

        private void __constructor__(Instrumentation instrumentation, ActivityWaiter activityWaiter) {
            this.$$robo$$android_app_Instrumentation_ActivityGoing$__constructor__(instrumentation, activityWaiter);
        }

        public ActivityGoing(Instrumentation instrumentation, ActivityWaiter activityWaiter) {
            this.this$0 = instrumentation;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Instrumentation_ActivityGoing$__constructor__(android.app.Instrumentation android.app.Instrumentation$ActivityWaiter ), 0, this, instrumentation, activityWaiter);
        }

        @Override
        public boolean queueIdle() {
            return (boolean)InvokeDynamicSupport.bootstrap("queueIdle", $$robo$$android_app_Instrumentation_ActivityGoing$queueIdle(), 0, this);
        }

        public /* synthetic */ ActivityGoing() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ActivityGoing)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class ActivityWaiter
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public Intent intent;
        public Activity activity;

        private void $$robo$$android_app_Instrumentation_ActivityWaiter$__constructor__(Intent _intent) {
            this.intent = _intent;
        }

        private void __constructor__(Intent intent) {
            this.$$robo$$android_app_Instrumentation_ActivityWaiter$__constructor__(intent);
        }

        public ActivityWaiter(Intent intent) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Instrumentation_ActivityWaiter$__constructor__(android.content.Intent ), 0, this, intent);
        }

        public /* synthetic */ ActivityWaiter() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ActivityWaiter)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class SyncRunnable
    implements Runnable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Runnable mTarget;
        private boolean mComplete;

        private void $$robo$$android_app_Instrumentation_SyncRunnable$__constructor__(Runnable target) {
            this.mTarget = target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_app_Instrumentation_SyncRunnable$run() {
            this.mTarget.run();
            SyncRunnable syncRunnable = this;
            synchronized (syncRunnable) {
                this.mComplete = true;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_app_Instrumentation_SyncRunnable$waitForComplete() {
            SyncRunnable syncRunnable = this;
            synchronized (syncRunnable) {
                while (!this.mComplete) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        private void __constructor__(Runnable runnable) {
            this.$$robo$$android_app_Instrumentation_SyncRunnable$__constructor__(runnable);
        }

        public SyncRunnable(Runnable runnable) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Instrumentation_SyncRunnable$__constructor__(java.lang.Runnable ), 0, this, runnable);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_app_Instrumentation_SyncRunnable$run(), 0, this);
        }

        public void waitForComplete() {
            InvokeDynamicSupport.bootstrap("waitForComplete", $$robo$$android_app_Instrumentation_SyncRunnable$waitForComplete(), 0, this);
        }

        public /* synthetic */ SyncRunnable() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SyncRunnable)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class EmptyRunnable
    implements Runnable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_app_Instrumentation_EmptyRunnable$__constructor__() {
        }

        private final void $$robo$$android_app_Instrumentation_EmptyRunnable$run() {
        }

        private /* synthetic */ void $$robo$$android_app_Instrumentation_EmptyRunnable$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_app_Instrumentation_EmptyRunnable$__constructor__();
        }

        private EmptyRunnable() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Instrumentation_EmptyRunnable$__constructor__(), 0, this);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_app_Instrumentation_EmptyRunnable$run(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_app_Instrumentation_EmptyRunnable$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EmptyRunnable)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private final class InstrumentationThread
    extends Thread
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ Instrumentation this$0;

        private void $$robo$$android_app_Instrumentation_InstrumentationThread$__constructor__(Instrumentation instrumentation, String name) {
        }

        private final void $$robo$$android_app_Instrumentation_InstrumentationThread$run() {
            try {
                Process.setThreadPriority(-8);
            }
            catch (RuntimeException e) {
                Log.w("Instrumentation", "Exception setting priority of instrumentation thread " + Process.myTid(), e);
            }
            if (this.this$0.mAutomaticPerformanceSnapshots) {
                this.this$0.startPerformanceSnapshot();
            }
            this.this$0.onStart();
        }

        private void __constructor__(Instrumentation instrumentation, String string2) {
            this.$$robo$$android_app_Instrumentation_InstrumentationThread$__constructor__(instrumentation, string2);
        }

        public InstrumentationThread(Instrumentation instrumentation, String string2) {
            this.this$0 = instrumentation;
            super(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Instrumentation_InstrumentationThread$__constructor__(android.app.Instrumentation java.lang.String ), 0, this, instrumentation, string2);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_app_Instrumentation_InstrumentationThread$run(), 0, this);
        }

        public /* synthetic */ InstrumentationThread() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InstrumentationThread)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class ActivityResult
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mResultCode;
        private Intent mResultData;

        private void $$robo$$android_app_Instrumentation_ActivityResult$__constructor__(int resultCode, Intent resultData) {
            this.mResultCode = resultCode;
            this.mResultData = resultData;
        }

        private final int $$robo$$android_app_Instrumentation_ActivityResult$getResultCode() {
            return this.mResultCode;
        }

        private final Intent $$robo$$android_app_Instrumentation_ActivityResult$getResultData() {
            return this.mResultData;
        }

        private void __constructor__(int n, Intent intent) {
            this.$$robo$$android_app_Instrumentation_ActivityResult$__constructor__(n, intent);
        }

        public ActivityResult(int n, Intent intent) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Instrumentation_ActivityResult$__constructor__(int android.content.Intent ), 0, this, n, intent);
        }

        public int getResultCode() {
            return (int)InvokeDynamicSupport.bootstrap("getResultCode", $$robo$$android_app_Instrumentation_ActivityResult$getResultCode(), 0, this);
        }

        public Intent getResultData() {
            return InvokeDynamicSupport.bootstrap("getResultData", $$robo$$android_app_Instrumentation_ActivityResult$getResultData(), 0, this);
        }

        public /* synthetic */ ActivityResult() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ActivityResult)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ActivityMonitor
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private IntentFilter mWhich;
        private String mClass;
        private ActivityResult mResult;
        private boolean mBlock;
        private boolean mIgnoreMatchingSpecificIntents;
        int mHits;
        Activity mLastActivity;

        private void $$robo$$android_app_Instrumentation_ActivityMonitor$__constructor__(IntentFilter which, ActivityResult result, boolean block) {
            this.mHits = 0;
            this.mLastActivity = null;
            this.mWhich = which;
            this.mClass = null;
            this.mResult = result;
            this.mBlock = block;
            this.mIgnoreMatchingSpecificIntents = false;
        }

        private void $$robo$$android_app_Instrumentation_ActivityMonitor$__constructor__(String cls, ActivityResult result, boolean block) {
            this.mHits = 0;
            this.mLastActivity = null;
            this.mWhich = null;
            this.mClass = cls;
            this.mResult = result;
            this.mBlock = block;
            this.mIgnoreMatchingSpecificIntents = false;
        }

        private void $$robo$$android_app_Instrumentation_ActivityMonitor$__constructor__() {
            this.mHits = 0;
            this.mLastActivity = null;
            this.mWhich = null;
            this.mClass = null;
            this.mResult = null;
            this.mBlock = false;
            this.mIgnoreMatchingSpecificIntents = true;
        }

        private final boolean $$robo$$android_app_Instrumentation_ActivityMonitor$ignoreMatchingSpecificIntents() {
            return this.mIgnoreMatchingSpecificIntents;
        }

        private final IntentFilter $$robo$$android_app_Instrumentation_ActivityMonitor$getFilter() {
            return this.mWhich;
        }

        private final ActivityResult $$robo$$android_app_Instrumentation_ActivityMonitor$getResult() {
            return this.mResult;
        }

        private final boolean $$robo$$android_app_Instrumentation_ActivityMonitor$isBlocking() {
            return this.mBlock;
        }

        private final int $$robo$$android_app_Instrumentation_ActivityMonitor$getHits() {
            return this.mHits;
        }

        private final Activity $$robo$$android_app_Instrumentation_ActivityMonitor$getLastActivity() {
            return this.mLastActivity;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final Activity $$robo$$android_app_Instrumentation_ActivityMonitor$waitForActivity() {
            ActivityMonitor activityMonitor = this;
            synchronized (activityMonitor) {
                while (this.mLastActivity == null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                Activity res = this.mLastActivity;
                this.mLastActivity = null;
                return res;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final Activity $$robo$$android_app_Instrumentation_ActivityMonitor$waitForActivityWithTimeout(long timeOut) {
            ActivityMonitor activityMonitor = this;
            synchronized (activityMonitor) {
                if (this.mLastActivity == null) {
                    try {
                        this.wait(timeOut);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.mLastActivity == null) {
                    return null;
                }
                Activity res = this.mLastActivity;
                this.mLastActivity = null;
                return res;
            }
        }

        private final ActivityResult $$robo$$android_app_Instrumentation_ActivityMonitor$onStartActivity(Intent intent) {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean $$robo$$android_app_Instrumentation_ActivityMonitor$match(Context who, Activity activity, Intent intent) {
            if (this.mIgnoreMatchingSpecificIntents) {
                return false;
            }
            ActivityMonitor activityMonitor = this;
            synchronized (activityMonitor) {
                if (this.mWhich != null && this.mWhich.match(who.getContentResolver(), intent, true, "Instrumentation") < 0) {
                    return false;
                }
                if (this.mClass != null) {
                    String cls = null;
                    if (activity != null) {
                        cls = activity.getClass().getName();
                    } else if (intent.getComponent() != null) {
                        cls = intent.getComponent().getClassName();
                    }
                    if (cls == null || !this.mClass.equals(cls)) {
                        return false;
                    }
                }
                if (activity != null) {
                    this.mLastActivity = activity;
                    this.notifyAll();
                }
                return true;
            }
        }

        private void __constructor__(IntentFilter intentFilter, ActivityResult activityResult, boolean bl) {
            this.$$robo$$android_app_Instrumentation_ActivityMonitor$__constructor__(intentFilter, activityResult, bl);
        }

        public ActivityMonitor(IntentFilter intentFilter, ActivityResult activityResult, boolean bl) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Instrumentation_ActivityMonitor$__constructor__(android.content.IntentFilter android.app.Instrumentation$ActivityResult boolean ), 0, this, intentFilter, activityResult, bl);
        }

        private void __constructor__(String string2, ActivityResult activityResult, boolean bl) {
            this.$$robo$$android_app_Instrumentation_ActivityMonitor$__constructor__(string2, activityResult, bl);
        }

        public ActivityMonitor(String string2, ActivityResult activityResult, boolean bl) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Instrumentation_ActivityMonitor$__constructor__(java.lang.String android.app.Instrumentation$ActivityResult boolean ), 0, this, string2, activityResult, bl);
        }

        private void __constructor__() {
            this.$$robo$$android_app_Instrumentation_ActivityMonitor$__constructor__();
        }

        public ActivityMonitor() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_Instrumentation_ActivityMonitor$__constructor__(), 0, this);
        }

        boolean ignoreMatchingSpecificIntents() {
            return (boolean)InvokeDynamicSupport.bootstrap("ignoreMatchingSpecificIntents", $$robo$$android_app_Instrumentation_ActivityMonitor$ignoreMatchingSpecificIntents(), 0, this);
        }

        public IntentFilter getFilter() {
            return InvokeDynamicSupport.bootstrap("getFilter", $$robo$$android_app_Instrumentation_ActivityMonitor$getFilter(), 0, this);
        }

        public ActivityResult getResult() {
            return InvokeDynamicSupport.bootstrap("getResult", $$robo$$android_app_Instrumentation_ActivityMonitor$getResult(), 0, this);
        }

        public boolean isBlocking() {
            return (boolean)InvokeDynamicSupport.bootstrap("isBlocking", $$robo$$android_app_Instrumentation_ActivityMonitor$isBlocking(), 0, this);
        }

        public int getHits() {
            return (int)InvokeDynamicSupport.bootstrap("getHits", $$robo$$android_app_Instrumentation_ActivityMonitor$getHits(), 0, this);
        }

        public Activity getLastActivity() {
            return InvokeDynamicSupport.bootstrap("getLastActivity", $$robo$$android_app_Instrumentation_ActivityMonitor$getLastActivity(), 0, this);
        }

        public Activity waitForActivity() {
            return InvokeDynamicSupport.bootstrap("waitForActivity", $$robo$$android_app_Instrumentation_ActivityMonitor$waitForActivity(), 0, this);
        }

        public Activity waitForActivityWithTimeout(long l) {
            return InvokeDynamicSupport.bootstrap("waitForActivityWithTimeout", $$robo$$android_app_Instrumentation_ActivityMonitor$waitForActivityWithTimeout(long ), 0, this, l);
        }

        public ActivityResult onStartActivity(Intent intent) {
            return InvokeDynamicSupport.bootstrap("onStartActivity", $$robo$$android_app_Instrumentation_ActivityMonitor$onStartActivity(android.content.Intent ), 0, this, intent);
        }

        boolean match(Context context, Activity activity, Intent intent) {
            return (boolean)InvokeDynamicSupport.bootstrap("match", $$robo$$android_app_Instrumentation_ActivityMonitor$match(android.content.Context android.app.Activity android.content.Intent ), 0, this, context, activity, intent);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ActivityMonitor)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface UiAutomationFlags {
    }
}

