/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.IActivityManager;
import android.app.trust.ITrustManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.provider.Settings;
import android.service.persistentdata.IPersistentDataBlockService;
import android.util.Log;
import android.view.IOnKeyguardExitResult;
import android.view.IWindowManager;
import android.view.WindowManagerGlobal;
import com.android.internal.policy.IKeyguardDismissCallback;
import com.android.internal.widget.LockPatternUtils;
import java.util.List;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class KeyguardManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "KeyguardManager";
    private Context mContext;
    private IWindowManager mWM;
    private IActivityManager mAm;
    private ITrustManager mTrustManager;
    public static String ACTION_CONFIRM_DEVICE_CREDENTIAL = "android.app.action.CONFIRM_DEVICE_CREDENTIAL";
    public static String ACTION_CONFIRM_DEVICE_CREDENTIAL_WITH_USER = "android.app.action.CONFIRM_DEVICE_CREDENTIAL_WITH_USER";
    public static String ACTION_CONFIRM_FRP_CREDENTIAL = "android.app.action.CONFIRM_FRP_CREDENTIAL";
    public static String EXTRA_TITLE = "android.app.extra.TITLE";
    public static String EXTRA_DESCRIPTION = "android.app.extra.DESCRIPTION";
    public static String EXTRA_ALTERNATE_BUTTON_LABEL = "android.app.extra.ALTERNATE_BUTTON_LABEL";
    public static int RESULT_ALTERNATE = 1;

    private final Intent $$robo$$android_app_KeyguardManager$createConfirmDeviceCredentialIntent(CharSequence title, CharSequence description) {
        if (!this.isDeviceSecure()) {
            return null;
        }
        Intent intent = new Intent("android.app.action.CONFIRM_DEVICE_CREDENTIAL");
        intent.putExtra("android.app.extra.TITLE", title);
        intent.putExtra("android.app.extra.DESCRIPTION", description);
        intent.setPackage(this.getSettingsPackageForIntent(intent));
        return intent;
    }

    private final Intent $$robo$$android_app_KeyguardManager$createConfirmDeviceCredentialIntent(CharSequence title, CharSequence description, int userId) {
        if (!this.isDeviceSecure(userId)) {
            return null;
        }
        Intent intent = new Intent("android.app.action.CONFIRM_DEVICE_CREDENTIAL_WITH_USER");
        intent.putExtra("android.app.extra.TITLE", title);
        intent.putExtra("android.app.extra.DESCRIPTION", description);
        intent.putExtra("android.intent.extra.USER_ID", userId);
        intent.setPackage(this.getSettingsPackageForIntent(intent));
        return intent;
    }

    private final Intent $$robo$$android_app_KeyguardManager$createConfirmFactoryResetCredentialIntent(CharSequence title, CharSequence description, CharSequence alternateButtonLabel) {
        if (!LockPatternUtils.frpCredentialEnabled(this.mContext)) {
            Log.w("KeyguardManager", "Factory reset credentials not supported.");
            return null;
        }
        if (Settings.Global.getInt(this.mContext.getContentResolver(), "device_provisioned", 0) != 0) {
            Log.e("KeyguardManager", "Factory reset credential cannot be verified after provisioning.");
            return null;
        }
        try {
            IPersistentDataBlockService pdb = IPersistentDataBlockService.Stub.asInterface(ServiceManager.getService("persistent_data_block"));
            if (pdb == null) {
                Log.e("KeyguardManager", "No persistent data block service");
                return null;
            }
            if (!pdb.hasFrpCredentialHandle()) {
                Log.i("KeyguardManager", "The persistent data block does not have a factory reset credential.");
                return null;
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        Intent intent = new Intent("android.app.action.CONFIRM_FRP_CREDENTIAL");
        intent.putExtra("android.app.extra.TITLE", title);
        intent.putExtra("android.app.extra.DESCRIPTION", description);
        intent.putExtra("android.app.extra.ALTERNATE_BUTTON_LABEL", alternateButtonLabel);
        intent.setPackage(this.getSettingsPackageForIntent(intent));
        return intent;
    }

    private final String $$robo$$android_app_KeyguardManager$getSettingsPackageForIntent(Intent intent) {
        int i = 0;
        List<ResolveInfo> resolveInfos = this.mContext.getPackageManager().queryIntentActivities(intent, 0x100000);
        if (i < resolveInfos.size()) {
            return resolveInfos.get((int)i).activityInfo.packageName;
        }
        return "com.android.settings";
    }

    private void $$robo$$android_app_KeyguardManager$__constructor__(Context context) throws ServiceManager.ServiceNotFoundException {
        this.mContext = context;
        this.mWM = WindowManagerGlobal.getWindowManagerService();
        this.mAm = ActivityManager.getService();
        this.mTrustManager = ITrustManager.Stub.asInterface(ServiceManager.getServiceOrThrow("trust"));
    }

    @Deprecated
    private final KeyguardLock $$robo$$android_app_KeyguardManager$newKeyguardLock(String tag) {
        return new KeyguardLock(this, tag);
    }

    private final boolean $$robo$$android_app_KeyguardManager$isKeyguardLocked() {
        try {
            return this.mWM.isKeyguardLocked();
        }
        catch (RemoteException ex) {
            return false;
        }
    }

    private final boolean $$robo$$android_app_KeyguardManager$isKeyguardSecure() {
        try {
            return this.mWM.isKeyguardSecure();
        }
        catch (RemoteException ex) {
            return false;
        }
    }

    private final boolean $$robo$$android_app_KeyguardManager$inKeyguardRestrictedInputMode() {
        try {
            return this.mWM.inKeyguardRestrictedInputMode();
        }
        catch (RemoteException ex) {
            return false;
        }
    }

    private final boolean $$robo$$android_app_KeyguardManager$isDeviceLocked() {
        return this.isDeviceLocked(UserHandle.myUserId());
    }

    private final boolean $$robo$$android_app_KeyguardManager$isDeviceLocked(int userId) {
        try {
            return this.mTrustManager.isDeviceLocked(userId);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    private final boolean $$robo$$android_app_KeyguardManager$isDeviceSecure() {
        return this.isDeviceSecure(UserHandle.myUserId());
    }

    private final boolean $$robo$$android_app_KeyguardManager$isDeviceSecure(int userId) {
        try {
            return this.mTrustManager.isDeviceSecure(userId);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Deprecated
    private final void $$robo$$android_app_KeyguardManager$dismissKeyguard(Activity activity, KeyguardDismissCallback callback, Handler handler) {
        this.requestDismissKeyguard(activity, callback);
    }

    private final void $$robo$$android_app_KeyguardManager$requestDismissKeyguard(Activity activity, KeyguardDismissCallback callback) {
        try {
            this.mAm.dismissKeyguard(activity.getActivityToken(), (IKeyguardDismissCallback)new ShadowedObject(this, callback, activity){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ KeyguardDismissCallback val$callback;
                /* synthetic */ Activity val$activity;
                /* synthetic */ KeyguardManager this$0;

                private void $$robo$$android_app_KeyguardManager_1$__constructor__(KeyguardManager this$0, KeyguardDismissCallback keyguardDismissCallback, Activity activity) {
                }

                private final void $$robo$$android_app_KeyguardManager_1$onDismissError() throws RemoteException {
                    if (this.val$callback != null && !this.val$activity.isDestroyed()) {
                        this.val$activity.mHandler.post(this.val$callback::onDismissError);
                    }
                }

                private final void $$robo$$android_app_KeyguardManager_1$onDismissSucceeded() throws RemoteException {
                    if (this.val$callback != null && !this.val$activity.isDestroyed()) {
                        this.val$activity.mHandler.post(this.val$callback::onDismissSucceeded);
                    }
                }

                private final void $$robo$$android_app_KeyguardManager_1$onDismissCancelled() throws RemoteException {
                    if (this.val$callback != null && !this.val$activity.isDestroyed()) {
                        this.val$activity.mHandler.post(this.val$callback::onDismissCancelled);
                    }
                }

                private void __constructor__(KeyguardManager keyguardManager, KeyguardDismissCallback keyguardDismissCallback, Activity activity) {
                    this.$$robo$$android_app_KeyguardManager_1$__constructor__(keyguardManager, keyguardDismissCallback, activity);
                }
                {
                    this.this$0 = keyguardManager;
                    this.val$callback = keyguardDismissCallback;
                    this.val$activity = activity;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_KeyguardManager_1$__constructor__(android.app.KeyguardManager android.app.KeyguardManager$KeyguardDismissCallback android.app.Activity ), 0, this, keyguardManager, keyguardDismissCallback, activity);
                }

                @Override
                public void onDismissError() throws RemoteException {
                    InvokeDynamicSupport.bootstrap("onDismissError", $$robo$$android_app_KeyguardManager_1$onDismissError(), 0, this);
                }

                @Override
                public void onDismissSucceeded() throws RemoteException {
                    InvokeDynamicSupport.bootstrap("onDismissSucceeded", $$robo$$android_app_KeyguardManager_1$onDismissSucceeded(), 0, this);
                }

                @Override
                public void onDismissCancelled() throws RemoteException {
                    InvokeDynamicSupport.bootstrap("onDismissCancelled", $$robo$$android_app_KeyguardManager_1$onDismissCancelled(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
        catch (RemoteException e) {
            Log.i("KeyguardManager", "Failed to dismiss keyguard: " + e);
        }
    }

    @Deprecated
    private final void $$robo$$android_app_KeyguardManager$exitKeyguardSecurely(OnKeyguardExitResult callback) {
        try {
            this.mWM.exitKeyguardSecurely((IOnKeyguardExitResult)new ShadowedObject(this, callback){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ OnKeyguardExitResult val$callback;
                /* synthetic */ KeyguardManager this$0;

                private void $$robo$$android_app_KeyguardManager_2$__constructor__(KeyguardManager this$0, OnKeyguardExitResult onKeyguardExitResult) {
                }

                private final void $$robo$$android_app_KeyguardManager_2$onKeyguardExitResult(boolean success) throws RemoteException {
                    if (this.val$callback != null) {
                        this.val$callback.onKeyguardExitResult(success);
                    }
                }

                private void __constructor__(KeyguardManager keyguardManager, OnKeyguardExitResult onKeyguardExitResult) {
                    this.$$robo$$android_app_KeyguardManager_2$__constructor__(keyguardManager, onKeyguardExitResult);
                }
                {
                    this.this$0 = keyguardManager;
                    this.val$callback = onKeyguardExitResult;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_KeyguardManager_2$__constructor__(android.app.KeyguardManager android.app.KeyguardManager$OnKeyguardExitResult ), 0, this, keyguardManager, onKeyguardExitResult);
                }

                @Override
                public void onKeyguardExitResult(boolean bl) throws RemoteException {
                    InvokeDynamicSupport.bootstrap("onKeyguardExitResult", $$robo$$android_app_KeyguardManager_2$onKeyguardExitResult(boolean ), 0, this, bl);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public Intent createConfirmDeviceCredentialIntent(CharSequence charSequence, CharSequence charSequence2) {
        return InvokeDynamicSupport.bootstrap("createConfirmDeviceCredentialIntent", $$robo$$android_app_KeyguardManager$createConfirmDeviceCredentialIntent(java.lang.CharSequence java.lang.CharSequence ), 0, this, charSequence, charSequence2);
    }

    public Intent createConfirmDeviceCredentialIntent(CharSequence charSequence, CharSequence charSequence2, int n) {
        return InvokeDynamicSupport.bootstrap("createConfirmDeviceCredentialIntent", $$robo$$android_app_KeyguardManager$createConfirmDeviceCredentialIntent(java.lang.CharSequence java.lang.CharSequence int ), 0, this, charSequence, charSequence2, n);
    }

    public Intent createConfirmFactoryResetCredentialIntent(CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3) {
        return InvokeDynamicSupport.bootstrap("createConfirmFactoryResetCredentialIntent", $$robo$$android_app_KeyguardManager$createConfirmFactoryResetCredentialIntent(java.lang.CharSequence java.lang.CharSequence java.lang.CharSequence ), 0, this, charSequence, charSequence2, charSequence3);
    }

    private String getSettingsPackageForIntent(Intent intent) {
        return InvokeDynamicSupport.bootstrap("getSettingsPackageForIntent", $$robo$$android_app_KeyguardManager$getSettingsPackageForIntent(android.content.Intent ), 0, this, intent);
    }

    private void __constructor__(Context context) throws ServiceManager.ServiceNotFoundException {
        this.$$robo$$android_app_KeyguardManager$__constructor__(context);
    }

    KeyguardManager(Context context) throws ServiceManager.ServiceNotFoundException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_KeyguardManager$__constructor__(android.content.Context ), 0, this, context);
    }

    @Deprecated
    public KeyguardLock newKeyguardLock(String string2) {
        return InvokeDynamicSupport.bootstrap("newKeyguardLock", $$robo$$android_app_KeyguardManager$newKeyguardLock(java.lang.String ), 0, this, string2);
    }

    public boolean isKeyguardLocked() {
        return (boolean)InvokeDynamicSupport.bootstrap("isKeyguardLocked", $$robo$$android_app_KeyguardManager$isKeyguardLocked(), 0, this);
    }

    public boolean isKeyguardSecure() {
        return (boolean)InvokeDynamicSupport.bootstrap("isKeyguardSecure", $$robo$$android_app_KeyguardManager$isKeyguardSecure(), 0, this);
    }

    public boolean inKeyguardRestrictedInputMode() {
        return (boolean)InvokeDynamicSupport.bootstrap("inKeyguardRestrictedInputMode", $$robo$$android_app_KeyguardManager$inKeyguardRestrictedInputMode(), 0, this);
    }

    public boolean isDeviceLocked() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDeviceLocked", $$robo$$android_app_KeyguardManager$isDeviceLocked(), 0, this);
    }

    public boolean isDeviceLocked(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isDeviceLocked", $$robo$$android_app_KeyguardManager$isDeviceLocked(int ), 0, this, n);
    }

    public boolean isDeviceSecure() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDeviceSecure", $$robo$$android_app_KeyguardManager$isDeviceSecure(), 0, this);
    }

    public boolean isDeviceSecure(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isDeviceSecure", $$robo$$android_app_KeyguardManager$isDeviceSecure(int ), 0, this, n);
    }

    @Deprecated
    public void dismissKeyguard(Activity activity, KeyguardDismissCallback keyguardDismissCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("dismissKeyguard", $$robo$$android_app_KeyguardManager$dismissKeyguard(android.app.Activity android.app.KeyguardManager$KeyguardDismissCallback android.os.Handler ), 0, this, activity, keyguardDismissCallback, handler);
    }

    public void requestDismissKeyguard(Activity activity, KeyguardDismissCallback keyguardDismissCallback) {
        InvokeDynamicSupport.bootstrap("requestDismissKeyguard", $$robo$$android_app_KeyguardManager$requestDismissKeyguard(android.app.Activity android.app.KeyguardManager$KeyguardDismissCallback ), 0, this, activity, keyguardDismissCallback);
    }

    @Deprecated
    public void exitKeyguardSecurely(OnKeyguardExitResult onKeyguardExitResult) {
        InvokeDynamicSupport.bootstrap("exitKeyguardSecurely", $$robo$$android_app_KeyguardManager$exitKeyguardSecurely(android.app.KeyguardManager$OnKeyguardExitResult ), 0, this, onKeyguardExitResult);
    }

    public /* synthetic */ KeyguardManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (KeyguardManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static abstract class KeyguardDismissCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_app_KeyguardManager_KeyguardDismissCallback$__constructor__() {
        }

        private final void $$robo$$android_app_KeyguardManager_KeyguardDismissCallback$onDismissError() {
        }

        private final void $$robo$$android_app_KeyguardManager_KeyguardDismissCallback$onDismissSucceeded() {
        }

        private final void $$robo$$android_app_KeyguardManager_KeyguardDismissCallback$onDismissCancelled() {
        }

        private void __constructor__() {
            this.$$robo$$android_app_KeyguardManager_KeyguardDismissCallback$__constructor__();
        }

        public KeyguardDismissCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_KeyguardManager_KeyguardDismissCallback$__constructor__(), 0, this);
        }

        public void onDismissError() {
            InvokeDynamicSupport.bootstrap("onDismissError", $$robo$$android_app_KeyguardManager_KeyguardDismissCallback$onDismissError(), 0, this);
        }

        public void onDismissSucceeded() {
            InvokeDynamicSupport.bootstrap("onDismissSucceeded", $$robo$$android_app_KeyguardManager_KeyguardDismissCallback$onDismissSucceeded(), 0, this);
        }

        public void onDismissCancelled() {
            InvokeDynamicSupport.bootstrap("onDismissCancelled", $$robo$$android_app_KeyguardManager_KeyguardDismissCallback$onDismissCancelled(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (KeyguardDismissCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Deprecated
    public static interface OnKeyguardExitResult
    extends InstrumentedInterface {
        public void onKeyguardExitResult(boolean var1);
    }

    @Deprecated
    public class KeyguardLock
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private IBinder mToken;
        private String mTag;
        /* synthetic */ KeyguardManager this$0;

        private void $$robo$$android_app_KeyguardManager_KeyguardLock$__constructor__(KeyguardManager this$0, String tag) {
            this.mToken = new Binder();
            this.mTag = tag;
        }

        private final void $$robo$$android_app_KeyguardManager_KeyguardLock$disableKeyguard() {
            try {
                this.this$0.mWM.disableKeyguard(this.mToken, this.mTag);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        private final void $$robo$$android_app_KeyguardManager_KeyguardLock$reenableKeyguard() {
            try {
                this.this$0.mWM.reenableKeyguard(this.mToken);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        private void __constructor__(KeyguardManager keyguardManager, String string2) {
            this.$$robo$$android_app_KeyguardManager_KeyguardLock$__constructor__(keyguardManager, string2);
        }

        KeyguardLock(KeyguardManager keyguardManager, String string2) {
            this.this$0 = keyguardManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_KeyguardManager_KeyguardLock$__constructor__(android.app.KeyguardManager java.lang.String ), 0, this, keyguardManager, string2);
        }

        public void disableKeyguard() {
            InvokeDynamicSupport.bootstrap("disableKeyguard", $$robo$$android_app_KeyguardManager_KeyguardLock$disableKeyguard(), 0, this);
        }

        public void reenableKeyguard() {
            InvokeDynamicSupport.bootstrap("reenableKeyguard", $$robo$$android_app_KeyguardManager_KeyguardLock$reenableKeyguard(), 0, this);
        }

        public /* synthetic */ KeyguardLock() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (KeyguardLock)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

