/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.FragmentHostCallback;
import android.app.LoaderManager;
import android.content.Loader;
import android.os.Bundle;
import android.util.DebugUtils;
import android.util.Log;
import android.util.SparseArray;
import com.google.errorprone.annotations.DoNotMock;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class LoaderManagerImpl
extends LoaderManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String TAG = "LoaderManager";
    static boolean DEBUG;
    SparseArray<LoaderInfo> mLoaders;
    SparseArray<LoaderInfo> mInactiveLoaders;
    String mWho;
    boolean mStarted;
    boolean mRetaining;
    boolean mRetainingStarted;
    boolean mCreatingLoader;
    private FragmentHostCallback mHost;

    private void $$robo$$android_app_LoaderManagerImpl$__constructor__(String who, FragmentHostCallback host, boolean started) {
        this.mLoaders = new SparseArray(0);
        this.mInactiveLoaders = new SparseArray(0);
        this.mWho = who;
        this.mHost = host;
        this.mStarted = started;
    }

    private final void $$robo$$android_app_LoaderManagerImpl$updateHostController(FragmentHostCallback host) {
        this.mHost = host;
    }

    private final FragmentHostCallback $$robo$$android_app_LoaderManagerImpl$getFragmentHostCallback() {
        return this.mHost;
    }

    private final LoaderInfo $$robo$$android_app_LoaderManagerImpl$createLoader(int id2, Bundle args, LoaderManager.LoaderCallbacks<Object> callback) {
        LoaderInfo info = new LoaderInfo(this, id2, args, callback);
        Loader<Object> loader = callback.onCreateLoader(id2, args);
        info.mLoader = loader;
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final LoaderInfo $$robo$$android_app_LoaderManagerImpl$createAndInstallLoader(int id2, Bundle args, LoaderManager.LoaderCallbacks<Object> callback) {
        try {
            this.mCreatingLoader = true;
            LoaderInfo info = this.createLoader(id2, args, callback);
            this.installLoader(info);
            LoaderInfo loaderInfo = info;
            return loaderInfo;
        }
        finally {
            this.mCreatingLoader = false;
        }
    }

    private final void $$robo$$android_app_LoaderManagerImpl$installLoader(LoaderInfo info) {
        this.mLoaders.put(info.mId, info);
        if (this.mStarted) {
            info.start();
        }
    }

    private final <D> Loader<D> $$robo$$android_app_LoaderManagerImpl$initLoader(int id2, Bundle args, LoaderManager.LoaderCallbacks<D> callback) {
        if (this.mCreatingLoader) {
            throw new IllegalStateException("Called while creating a loader");
        }
        LoaderInfo info = this.mLoaders.get(id2);
        if (DEBUG) {
            Log.v("LoaderManager", "initLoader in " + this + ": args=" + args);
        }
        if (info == null) {
            info = this.createAndInstallLoader(id2, args, callback);
            if (DEBUG) {
                Log.v("LoaderManager", "  Created new loader " + info);
            }
        } else {
            if (DEBUG) {
                Log.v("LoaderManager", "  Re-using existing loader " + info);
            }
            info.mCallbacks = callback;
        }
        if (info.mHaveData && this.mStarted) {
            info.callOnLoadFinished(info.mLoader, info.mData);
        }
        return info.mLoader;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final <D> Loader<D> $$robo$$android_app_LoaderManagerImpl$restartLoader(int id2, Bundle args, LoaderManager.LoaderCallbacks<D> callback) {
        LoaderInfo info;
        block13: {
            block14: {
                if (this.mCreatingLoader) {
                    throw new IllegalStateException("Called while creating a loader");
                }
                info = this.mLoaders.get(id2);
                if (DEBUG) {
                    Log.v("LoaderManager", "restartLoader in " + this + ": args=" + args);
                }
                if (info == null) break block13;
                LoaderInfo inactive = this.mInactiveLoaders.get(id2);
                if (inactive == null) break block14;
                if (info.mHaveData) {
                    if (DEBUG) {
                        Log.v("LoaderManager", "  Removing last inactive loader: " + info);
                    }
                    inactive.mDeliveredData = false;
                    inactive.destroy();
                    info.mLoader.abandon();
                    this.mInactiveLoaders.put(id2, info);
                    break block13;
                } else if (!info.cancel()) {
                    if (DEBUG) {
                        Log.v("LoaderManager", "  Current loader is stopped; replacing");
                    }
                    this.mLoaders.put(id2, null);
                    info.destroy();
                    break block13;
                } else {
                    if (DEBUG) {
                        Log.v("LoaderManager", "  Current loader is running; configuring pending loader");
                    }
                    if (info.mPendingLoader != null) {
                        if (DEBUG) {
                            Log.v("LoaderManager", "  Removing pending loader: " + info.mPendingLoader);
                        }
                        info.mPendingLoader.destroy();
                        info.mPendingLoader = null;
                    }
                    if (DEBUG) {
                        Log.v("LoaderManager", "  Enqueuing as new pending loader");
                    }
                    info.mPendingLoader = this.createLoader(id2, args, callback);
                    return info.mPendingLoader.mLoader;
                }
            }
            if (DEBUG) {
                Log.v("LoaderManager", "  Making last loader inactive: " + info);
            }
            info.mLoader.abandon();
            this.mInactiveLoaders.put(id2, info);
        }
        info = this.createAndInstallLoader(id2, args, callback);
        return info.mLoader;
    }

    private final void $$robo$$android_app_LoaderManagerImpl$destroyLoader(int id2) {
        LoaderInfo info;
        int idx;
        if (this.mCreatingLoader) {
            throw new IllegalStateException("Called while creating a loader");
        }
        if (DEBUG) {
            Log.v("LoaderManager", "destroyLoader in " + this + " of " + id2);
        }
        if ((idx = this.mLoaders.indexOfKey(id2)) >= 0) {
            info = this.mLoaders.valueAt(idx);
            this.mLoaders.removeAt(idx);
            info.destroy();
        }
        if ((idx = this.mInactiveLoaders.indexOfKey(id2)) >= 0) {
            info = this.mInactiveLoaders.valueAt(idx);
            this.mInactiveLoaders.removeAt(idx);
            info.destroy();
        }
        if (this.mHost != null && !this.hasRunningLoaders()) {
            this.mHost.mFragmentManager.startPendingDeferredFragments();
        }
    }

    private final <D> Loader<D> $$robo$$android_app_LoaderManagerImpl$getLoader(int id2) {
        if (this.mCreatingLoader) {
            throw new IllegalStateException("Called while creating a loader");
        }
        LoaderInfo loaderInfo = this.mLoaders.get(id2);
        if (loaderInfo != null) {
            if (loaderInfo.mPendingLoader != null) {
                return loaderInfo.mPendingLoader.mLoader;
            }
            return loaderInfo.mLoader;
        }
        return null;
    }

    private final void $$robo$$android_app_LoaderManagerImpl$doStart() {
        if (DEBUG) {
            Log.v("LoaderManager", "Starting in " + this);
        }
        if (this.mStarted) {
            RuntimeException e = new RuntimeException("here");
            e.fillInStackTrace();
            Log.w("LoaderManager", "Called doStart when already started: " + this, e);
            return;
        }
        this.mStarted = true;
        for (int i = this.mLoaders.size() - 1; i >= 0; --i) {
            this.mLoaders.valueAt(i).start();
        }
    }

    private final void $$robo$$android_app_LoaderManagerImpl$doStop() {
        if (DEBUG) {
            Log.v("LoaderManager", "Stopping in " + this);
        }
        if (!this.mStarted) {
            RuntimeException e = new RuntimeException("here");
            e.fillInStackTrace();
            Log.w("LoaderManager", "Called doStop when not started: " + this, e);
            return;
        }
        for (int i = this.mLoaders.size() - 1; i >= 0; --i) {
            this.mLoaders.valueAt(i).stop();
        }
        this.mStarted = false;
    }

    private final void $$robo$$android_app_LoaderManagerImpl$doRetain() {
        if (DEBUG) {
            Log.v("LoaderManager", "Retaining in " + this);
        }
        if (!this.mStarted) {
            RuntimeException e = new RuntimeException("here");
            e.fillInStackTrace();
            Log.w("LoaderManager", "Called doRetain when not started: " + this, e);
            return;
        }
        this.mRetaining = true;
        this.mStarted = false;
        for (int i = this.mLoaders.size() - 1; i >= 0; --i) {
            this.mLoaders.valueAt(i).retain();
        }
    }

    private final void $$robo$$android_app_LoaderManagerImpl$finishRetain() {
        if (this.mRetaining) {
            if (DEBUG) {
                Log.v("LoaderManager", "Finished Retaining in " + this);
            }
            this.mRetaining = false;
            for (int i = this.mLoaders.size() - 1; i >= 0; --i) {
                this.mLoaders.valueAt(i).finishRetain();
            }
        }
    }

    private final void $$robo$$android_app_LoaderManagerImpl$doReportNextStart() {
        for (int i = this.mLoaders.size() - 1; i >= 0; --i) {
            this.mLoaders.valueAt((int)i).mReportNextStart = true;
        }
    }

    private final void $$robo$$android_app_LoaderManagerImpl$doReportStart() {
        for (int i = this.mLoaders.size() - 1; i >= 0; --i) {
            this.mLoaders.valueAt(i).reportStart();
        }
    }

    private final void $$robo$$android_app_LoaderManagerImpl$doDestroy() {
        int i;
        if (!this.mRetaining) {
            if (DEBUG) {
                Log.v("LoaderManager", "Destroying Active in " + this);
            }
            for (i = this.mLoaders.size() - 1; i >= 0; --i) {
                this.mLoaders.valueAt(i).destroy();
            }
            this.mLoaders.clear();
        }
        if (DEBUG) {
            Log.v("LoaderManager", "Destroying Inactive in " + this);
        }
        for (i = this.mInactiveLoaders.size() - 1; i >= 0; --i) {
            this.mInactiveLoaders.valueAt(i).destroy();
        }
        this.mInactiveLoaders.clear();
        this.mHost = null;
    }

    private final String $$robo$$android_app_LoaderManagerImpl$toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("LoaderManager{");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(" in ");
        DebugUtils.buildShortClassTag(this.mHost, sb);
        sb.append("}}");
        return sb.toString();
    }

    private final void $$robo$$android_app_LoaderManagerImpl$dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
        LoaderInfo li;
        int i;
        String innerPrefix;
        if (this.mLoaders.size() > 0) {
            writer.print(prefix);
            writer.println("Active Loaders:");
            innerPrefix = prefix + "    ";
            for (i = 0; i < this.mLoaders.size(); ++i) {
                li = this.mLoaders.valueAt(i);
                writer.print(prefix);
                writer.print("  #");
                writer.print(this.mLoaders.keyAt(i));
                writer.print(": ");
                writer.println(li.toString());
                li.dump(innerPrefix, fd, writer, args);
            }
        }
        if (this.mInactiveLoaders.size() > 0) {
            writer.print(prefix);
            writer.println("Inactive Loaders:");
            innerPrefix = prefix + "    ";
            for (i = 0; i < this.mInactiveLoaders.size(); ++i) {
                li = this.mInactiveLoaders.valueAt(i);
                writer.print(prefix);
                writer.print("  #");
                writer.print(this.mInactiveLoaders.keyAt(i));
                writer.print(": ");
                writer.println(li.toString());
                li.dump(innerPrefix, fd, writer, args);
            }
        }
    }

    private final boolean $$robo$$android_app_LoaderManagerImpl$hasRunningLoaders() {
        boolean loadersRunning = false;
        int count = this.mLoaders.size();
        for (int i = 0; i < count; ++i) {
            LoaderInfo li = this.mLoaders.valueAt(i);
            loadersRunning |= li.mStarted && !li.mDeliveredData;
        }
        return loadersRunning;
    }

    static void __staticInitializer__() {
        DEBUG = false;
    }

    private void __constructor__(String string2, FragmentHostCallback fragmentHostCallback, boolean bl) {
        this.$$robo$$android_app_LoaderManagerImpl$__constructor__(string2, fragmentHostCallback, bl);
    }

    LoaderManagerImpl(String string2, FragmentHostCallback fragmentHostCallback, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_LoaderManagerImpl$__constructor__(java.lang.String android.app.FragmentHostCallback boolean ), 0, this, string2, fragmentHostCallback, bl);
    }

    void updateHostController(FragmentHostCallback fragmentHostCallback) {
        InvokeDynamicSupport.bootstrap("updateHostController", $$robo$$android_app_LoaderManagerImpl$updateHostController(android.app.FragmentHostCallback ), 0, this, fragmentHostCallback);
    }

    @Override
    public FragmentHostCallback getFragmentHostCallback() {
        return InvokeDynamicSupport.bootstrap("getFragmentHostCallback", $$robo$$android_app_LoaderManagerImpl$getFragmentHostCallback(), 0, this);
    }

    private LoaderInfo createLoader(int n, Bundle bundle, LoaderManager.LoaderCallbacks<Object> loaderCallbacks) {
        return InvokeDynamicSupport.bootstrap("createLoader", $$robo$$android_app_LoaderManagerImpl$createLoader(int android.os.Bundle android.app.LoaderManager$LoaderCallbacks<java.lang.Object> ), 0, this, n, bundle, loaderCallbacks);
    }

    private LoaderInfo createAndInstallLoader(int n, Bundle bundle, LoaderManager.LoaderCallbacks<Object> loaderCallbacks) {
        return InvokeDynamicSupport.bootstrap("createAndInstallLoader", $$robo$$android_app_LoaderManagerImpl$createAndInstallLoader(int android.os.Bundle android.app.LoaderManager$LoaderCallbacks<java.lang.Object> ), 0, this, n, bundle, loaderCallbacks);
    }

    void installLoader(LoaderInfo loaderInfo) {
        InvokeDynamicSupport.bootstrap("installLoader", $$robo$$android_app_LoaderManagerImpl$installLoader(android.app.LoaderManagerImpl$LoaderInfo ), 0, this, loaderInfo);
    }

    @Override
    public <D> Loader<D> initLoader(int n, Bundle bundle, LoaderManager.LoaderCallbacks<D> loaderCallbacks) {
        return InvokeDynamicSupport.bootstrap("initLoader", $$robo$$android_app_LoaderManagerImpl$initLoader(int android.os.Bundle android.app.LoaderManager$LoaderCallbacks<D> ), 0, this, n, bundle, loaderCallbacks);
    }

    @Override
    public <D> Loader<D> restartLoader(int n, Bundle bundle, LoaderManager.LoaderCallbacks<D> loaderCallbacks) {
        return InvokeDynamicSupport.bootstrap("restartLoader", $$robo$$android_app_LoaderManagerImpl$restartLoader(int android.os.Bundle android.app.LoaderManager$LoaderCallbacks<D> ), 0, this, n, bundle, loaderCallbacks);
    }

    @Override
    public void destroyLoader(int n) {
        InvokeDynamicSupport.bootstrap("destroyLoader", $$robo$$android_app_LoaderManagerImpl$destroyLoader(int ), 0, this, n);
    }

    @Override
    public <D> Loader<D> getLoader(int n) {
        return InvokeDynamicSupport.bootstrap("getLoader", $$robo$$android_app_LoaderManagerImpl$getLoader(int ), 0, this, n);
    }

    void doStart() {
        InvokeDynamicSupport.bootstrap("doStart", $$robo$$android_app_LoaderManagerImpl$doStart(), 0, this);
    }

    void doStop() {
        InvokeDynamicSupport.bootstrap("doStop", $$robo$$android_app_LoaderManagerImpl$doStop(), 0, this);
    }

    void doRetain() {
        InvokeDynamicSupport.bootstrap("doRetain", $$robo$$android_app_LoaderManagerImpl$doRetain(), 0, this);
    }

    void finishRetain() {
        InvokeDynamicSupport.bootstrap("finishRetain", $$robo$$android_app_LoaderManagerImpl$finishRetain(), 0, this);
    }

    void doReportNextStart() {
        InvokeDynamicSupport.bootstrap("doReportNextStart", $$robo$$android_app_LoaderManagerImpl$doReportNextStart(), 0, this);
    }

    void doReportStart() {
        InvokeDynamicSupport.bootstrap("doReportStart", $$robo$$android_app_LoaderManagerImpl$doReportStart(), 0, this);
    }

    void doDestroy() {
        InvokeDynamicSupport.bootstrap("doDestroy", $$robo$$android_app_LoaderManagerImpl$doDestroy(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_app_LoaderManagerImpl$toString(), 0, this);
    }

    @Override
    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_app_LoaderManagerImpl$dump(java.lang.String java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, string2, fileDescriptor, printWriter, stringArray);
    }

    public boolean hasRunningLoaders() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasRunningLoaders", $$robo$$android_app_LoaderManagerImpl$hasRunningLoaders(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(LoaderManagerImpl.class);
    }

    public /* synthetic */ LoaderManagerImpl() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LoaderManagerImpl)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public final class LoaderInfo
    implements Loader.OnLoadCompleteListener<Object>,
    Loader.OnLoadCanceledListener<Object> {
        public transient /* synthetic */ Object __robo_data__;
        int mId;
        Bundle mArgs;
        LoaderManager.LoaderCallbacks<Object> mCallbacks;
        Loader<Object> mLoader;
        boolean mHaveData;
        boolean mDeliveredData;
        Object mData;
        boolean mStarted;
        boolean mRetaining;
        boolean mRetainingStarted;
        boolean mReportNextStart;
        boolean mDestroyed;
        boolean mListenerRegistered;
        LoaderInfo mPendingLoader;
        /* synthetic */ LoaderManagerImpl this$0;

        private void $$robo$$android_app_LoaderManagerImpl_LoaderInfo$__constructor__(LoaderManagerImpl this$0, int id2, Bundle args, LoaderManager.LoaderCallbacks<Object> callbacks) {
            this.mId = id2;
            this.mArgs = args;
            this.mCallbacks = callbacks;
        }

        private final void $$robo$$android_app_LoaderManagerImpl_LoaderInfo$start() {
            if (this.mRetaining && this.mRetainingStarted) {
                this.mStarted = true;
                return;
            }
            if (this.mStarted) {
                return;
            }
            this.mStarted = true;
            if (DEBUG) {
                Log.v("LoaderManager", "  Starting: " + this);
            }
            if (this.mLoader == null && this.mCallbacks != null) {
                this.mLoader = this.mCallbacks.onCreateLoader(this.mId, this.mArgs);
            }
            if (this.mLoader != null) {
                if (this.mLoader.getClass().isMemberClass() && !Modifier.isStatic(this.mLoader.getClass().getModifiers())) {
                    throw new IllegalArgumentException("Object returned from onCreateLoader must not be a non-static inner member class: " + this.mLoader);
                }
                if (!this.mListenerRegistered) {
                    this.mLoader.registerListener(this.mId, this);
                    this.mLoader.registerOnLoadCanceledListener(this);
                    this.mListenerRegistered = true;
                }
                this.mLoader.startLoading();
            }
        }

        private final void $$robo$$android_app_LoaderManagerImpl_LoaderInfo$retain() {
            if (DEBUG) {
                Log.v("LoaderManager", "  Retaining: " + this);
            }
            this.mRetaining = true;
            this.mRetainingStarted = this.mStarted;
            this.mStarted = false;
            this.mCallbacks = null;
        }

        private final void $$robo$$android_app_LoaderManagerImpl_LoaderInfo$finishRetain() {
            if (this.mRetaining) {
                if (DEBUG) {
                    Log.v("LoaderManager", "  Finished Retaining: " + this);
                }
                this.mRetaining = false;
                if (this.mStarted != this.mRetainingStarted && !this.mStarted) {
                    this.stop();
                }
            }
            if (this.mStarted && this.mHaveData && !this.mReportNextStart) {
                this.callOnLoadFinished(this.mLoader, this.mData);
            }
        }

        private final void $$robo$$android_app_LoaderManagerImpl_LoaderInfo$reportStart() {
            if (this.mStarted && this.mReportNextStart) {
                this.mReportNextStart = false;
                if (this.mHaveData && !this.mRetaining) {
                    this.callOnLoadFinished(this.mLoader, this.mData);
                }
            }
        }

        private final void $$robo$$android_app_LoaderManagerImpl_LoaderInfo$stop() {
            if (DEBUG) {
                Log.v("LoaderManager", "  Stopping: " + this);
            }
            this.mStarted = false;
            if (!this.mRetaining && this.mLoader != null && this.mListenerRegistered) {
                this.mListenerRegistered = false;
                this.mLoader.unregisterListener(this);
                this.mLoader.unregisterOnLoadCanceledListener(this);
                this.mLoader.stopLoading();
            }
        }

        private final boolean $$robo$$android_app_LoaderManagerImpl_LoaderInfo$cancel() {
            if (DEBUG) {
                Log.v("LoaderManager", "  Canceling: " + this);
            }
            if (this.mStarted && this.mLoader != null && this.mListenerRegistered) {
                boolean cancelLoadResult = this.mLoader.cancelLoad();
                if (!cancelLoadResult) {
                    this.onLoadCanceled(this.mLoader);
                }
                return cancelLoadResult;
            }
            return false;
        }

        private final void $$robo$$android_app_LoaderManagerImpl_LoaderInfo$destroy() {
            if (DEBUG) {
                Log.v("LoaderManager", "  Destroying: " + this);
            }
            this.mDestroyed = true;
            boolean needReset = this.mDeliveredData;
            this.mDeliveredData = false;
            if (this.mCallbacks != null && this.mLoader != null && this.mHaveData && needReset) {
                if (DEBUG) {
                    Log.v("LoaderManager", "  Reseting: " + this);
                }
                String lastBecause = null;
                if (this.this$0.mHost != null) {
                    lastBecause = ((LoaderManagerImpl)this.this$0).mHost.mFragmentManager.mNoTransactionsBecause;
                    ((LoaderManagerImpl)this.this$0).mHost.mFragmentManager.mNoTransactionsBecause = "onLoaderReset";
                }
                try {
                    this.mCallbacks.onLoaderReset(this.mLoader);
                }
                finally {
                    if (this.this$0.mHost != null) {
                        ((LoaderManagerImpl)this.this$0).mHost.mFragmentManager.mNoTransactionsBecause = lastBecause;
                    }
                }
            }
            this.mCallbacks = null;
            this.mData = null;
            this.mHaveData = false;
            if (this.mLoader != null) {
                if (this.mListenerRegistered) {
                    this.mListenerRegistered = false;
                    this.mLoader.unregisterListener(this);
                    this.mLoader.unregisterOnLoadCanceledListener(this);
                }
                this.mLoader.reset();
            }
            if (this.mPendingLoader != null) {
                this.mPendingLoader.destroy();
            }
        }

        private final void $$robo$$android_app_LoaderManagerImpl_LoaderInfo$onLoadCanceled(Loader<Object> loader) {
            if (DEBUG) {
                Log.v("LoaderManager", "onLoadCanceled: " + this);
            }
            if (this.mDestroyed) {
                if (DEBUG) {
                    Log.v("LoaderManager", "  Ignoring load canceled -- destroyed");
                }
                return;
            }
            if (this.this$0.mLoaders.get(this.mId) != this) {
                if (DEBUG) {
                    Log.v("LoaderManager", "  Ignoring load canceled -- not active");
                }
                return;
            }
            LoaderInfo pending = this.mPendingLoader;
            if (pending != null) {
                if (DEBUG) {
                    Log.v("LoaderManager", "  Switching to pending loader: " + pending);
                }
                this.mPendingLoader = null;
                this.this$0.mLoaders.put(this.mId, null);
                this.destroy();
                this.this$0.installLoader(pending);
            }
        }

        private final void $$robo$$android_app_LoaderManagerImpl_LoaderInfo$onLoadComplete(Loader<Object> loader, Object data) {
            LoaderInfo info;
            if (DEBUG) {
                Log.v("LoaderManager", "onLoadComplete: " + this);
            }
            if (this.mDestroyed) {
                if (DEBUG) {
                    Log.v("LoaderManager", "  Ignoring load complete -- destroyed");
                }
                return;
            }
            if (this.this$0.mLoaders.get(this.mId) != this) {
                if (DEBUG) {
                    Log.v("LoaderManager", "  Ignoring load complete -- not active");
                }
                return;
            }
            LoaderInfo pending = this.mPendingLoader;
            if (pending != null) {
                if (DEBUG) {
                    Log.v("LoaderManager", "  Switching to pending loader: " + pending);
                }
                this.mPendingLoader = null;
                this.this$0.mLoaders.put(this.mId, null);
                this.destroy();
                this.this$0.installLoader(pending);
                return;
            }
            if (this.mData != data || !this.mHaveData) {
                this.mData = data;
                this.mHaveData = true;
                if (this.mStarted) {
                    this.callOnLoadFinished(loader, data);
                }
            }
            if ((info = this.this$0.mInactiveLoaders.get(this.mId)) != null && info != this) {
                info.mDeliveredData = false;
                info.destroy();
                this.this$0.mInactiveLoaders.remove(this.mId);
            }
            if (this.this$0.mHost != null && !this.this$0.hasRunningLoaders()) {
                ((LoaderManagerImpl)this.this$0).mHost.mFragmentManager.startPendingDeferredFragments();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_app_LoaderManagerImpl_LoaderInfo$callOnLoadFinished(Loader<Object> loader, Object data) {
            if (this.mCallbacks != null) {
                String lastBecause = null;
                if (this.this$0.mHost != null) {
                    lastBecause = ((LoaderManagerImpl)this.this$0).mHost.mFragmentManager.mNoTransactionsBecause;
                    ((LoaderManagerImpl)this.this$0).mHost.mFragmentManager.mNoTransactionsBecause = "onLoadFinished";
                }
                try {
                    if (DEBUG) {
                        Log.v("LoaderManager", "  onLoadFinished in " + loader + ": " + loader.dataToString(data));
                    }
                    this.mCallbacks.onLoadFinished(loader, data);
                }
                finally {
                    if (this.this$0.mHost != null) {
                        ((LoaderManagerImpl)this.this$0).mHost.mFragmentManager.mNoTransactionsBecause = lastBecause;
                    }
                }
                this.mDeliveredData = true;
            }
        }

        private final String $$robo$$android_app_LoaderManagerImpl_LoaderInfo$toString() {
            StringBuilder sb = new StringBuilder(64);
            sb.append("LoaderInfo{");
            sb.append(Integer.toHexString(System.identityHashCode(this)));
            sb.append(" #");
            sb.append(this.mId);
            sb.append(" : ");
            DebugUtils.buildShortClassTag(this.mLoader, sb);
            sb.append("}}");
            return sb.toString();
        }

        private final void $$robo$$android_app_LoaderManagerImpl_LoaderInfo$dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
            writer.print(prefix);
            writer.print("mId=");
            writer.print(this.mId);
            writer.print(" mArgs=");
            writer.println(this.mArgs);
            writer.print(prefix);
            writer.print("mCallbacks=");
            writer.println(this.mCallbacks);
            writer.print(prefix);
            writer.print("mLoader=");
            writer.println(this.mLoader);
            if (this.mLoader != null) {
                this.mLoader.dump(prefix + "  ", fd, writer, args);
            }
            if (this.mHaveData || this.mDeliveredData) {
                writer.print(prefix);
                writer.print("mHaveData=");
                writer.print(this.mHaveData);
                writer.print("  mDeliveredData=");
                writer.println(this.mDeliveredData);
                writer.print(prefix);
                writer.print("mData=");
                writer.println(this.mData);
            }
            writer.print(prefix);
            writer.print("mStarted=");
            writer.print(this.mStarted);
            writer.print(" mReportNextStart=");
            writer.print(this.mReportNextStart);
            writer.print(" mDestroyed=");
            writer.println(this.mDestroyed);
            writer.print(prefix);
            writer.print("mRetaining=");
            writer.print(this.mRetaining);
            writer.print(" mRetainingStarted=");
            writer.print(this.mRetainingStarted);
            writer.print(" mListenerRegistered=");
            writer.println(this.mListenerRegistered);
            if (this.mPendingLoader != null) {
                writer.print(prefix);
                writer.println("Pending Loader ");
                writer.print(this.mPendingLoader);
                writer.println(":");
                this.mPendingLoader.dump(prefix + "  ", fd, writer, args);
            }
        }

        private void __constructor__(LoaderManagerImpl loaderManagerImpl, int n, Bundle bundle, LoaderManager.LoaderCallbacks<Object> loaderCallbacks) {
            this.$$robo$$android_app_LoaderManagerImpl_LoaderInfo$__constructor__(loaderManagerImpl, n, bundle, loaderCallbacks);
        }

        public LoaderInfo(LoaderManagerImpl loaderManagerImpl, int n, Bundle bundle, LoaderManager.LoaderCallbacks<Object> loaderCallbacks) {
            this.this$0 = loaderManagerImpl;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_LoaderManagerImpl_LoaderInfo$__constructor__(android.app.LoaderManagerImpl int android.os.Bundle android.app.LoaderManager$LoaderCallbacks<java.lang.Object> ), 0, this, loaderManagerImpl, n, bundle, loaderCallbacks);
        }

        void start() {
            InvokeDynamicSupport.bootstrap("start", $$robo$$android_app_LoaderManagerImpl_LoaderInfo$start(), 0, this);
        }

        void retain() {
            InvokeDynamicSupport.bootstrap("retain", $$robo$$android_app_LoaderManagerImpl_LoaderInfo$retain(), 0, this);
        }

        void finishRetain() {
            InvokeDynamicSupport.bootstrap("finishRetain", $$robo$$android_app_LoaderManagerImpl_LoaderInfo$finishRetain(), 0, this);
        }

        void reportStart() {
            InvokeDynamicSupport.bootstrap("reportStart", $$robo$$android_app_LoaderManagerImpl_LoaderInfo$reportStart(), 0, this);
        }

        void stop() {
            InvokeDynamicSupport.bootstrap("stop", $$robo$$android_app_LoaderManagerImpl_LoaderInfo$stop(), 0, this);
        }

        boolean cancel() {
            return (boolean)InvokeDynamicSupport.bootstrap("cancel", $$robo$$android_app_LoaderManagerImpl_LoaderInfo$cancel(), 0, this);
        }

        void destroy() {
            InvokeDynamicSupport.bootstrap("destroy", $$robo$$android_app_LoaderManagerImpl_LoaderInfo$destroy(), 0, this);
        }

        @Override
        public void onLoadCanceled(Loader<Object> loader) {
            InvokeDynamicSupport.bootstrap("onLoadCanceled", $$robo$$android_app_LoaderManagerImpl_LoaderInfo$onLoadCanceled(android.content.Loader<java.lang.Object> ), 0, this, loader);
        }

        @Override
        public void onLoadComplete(Loader<Object> loader, Object object) {
            InvokeDynamicSupport.bootstrap("onLoadComplete", $$robo$$android_app_LoaderManagerImpl_LoaderInfo$onLoadComplete(android.content.Loader<java.lang.Object> java.lang.Object ), 0, this, loader, object);
        }

        void callOnLoadFinished(Loader<Object> loader, Object object) {
            InvokeDynamicSupport.bootstrap("callOnLoadFinished", $$robo$$android_app_LoaderManagerImpl_LoaderInfo$callOnLoadFinished(android.content.Loader<java.lang.Object> java.lang.Object ), 0, this, loader, object);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_app_LoaderManagerImpl_LoaderInfo$toString(), 0, this);
        }

        public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
            InvokeDynamicSupport.bootstrap("dump", $$robo$$android_app_LoaderManagerImpl_LoaderInfo$dump(java.lang.String java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, string2, fileDescriptor, printWriter, stringArray);
        }

        public /* synthetic */ LoaderInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LoaderInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

