/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActivityManager;
import android.app.AutomaticZenRule;
import android.app.INotificationManager;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationChannelGroup;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ParceledListSlice;
import android.graphics.drawable.Icon;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.StrictMode;
import android.os.UserHandle;
import android.service.notification.StatusBarNotification;
import android.service.notification.ZenModeConfig;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class NotificationManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG;
    private static boolean localLOGV;
    public static String ACTION_EFFECTS_SUPPRESSOR_CHANGED = "android.os.action.ACTION_EFFECTS_SUPPRESSOR_CHANGED";
    public static String ACTION_NOTIFICATION_POLICY_ACCESS_GRANTED_CHANGED = "android.app.action.NOTIFICATION_POLICY_ACCESS_GRANTED_CHANGED";
    public static String ACTION_NOTIFICATION_POLICY_CHANGED = "android.app.action.NOTIFICATION_POLICY_CHANGED";
    public static String ACTION_INTERRUPTION_FILTER_CHANGED = "android.app.action.INTERRUPTION_FILTER_CHANGED";
    public static String ACTION_INTERRUPTION_FILTER_CHANGED_INTERNAL = "android.app.action.INTERRUPTION_FILTER_CHANGED_INTERNAL";
    public static int INTERRUPTION_FILTER_ALL = 1;
    public static int INTERRUPTION_FILTER_PRIORITY = 2;
    public static int INTERRUPTION_FILTER_NONE = 3;
    public static int INTERRUPTION_FILTER_ALARMS = 4;
    public static int INTERRUPTION_FILTER_UNKNOWN = 0;
    public static int VISIBILITY_NO_OVERRIDE = -1000;
    public static int IMPORTANCE_UNSPECIFIED = -1000;
    public static int IMPORTANCE_NONE = 0;
    public static int IMPORTANCE_MIN = 1;
    public static int IMPORTANCE_LOW = 2;
    public static int IMPORTANCE_DEFAULT = 3;
    public static int IMPORTANCE_HIGH = 4;
    public static int IMPORTANCE_MAX = 5;
    private static INotificationManager sService;
    private Context mContext;

    private static final INotificationManager $$robo$$android_app_NotificationManager$getService() {
        if (sService != null) {
            return sService;
        }
        IBinder b = ServiceManager.getService("notification");
        sService = INotificationManager.Stub.asInterface(b);
        return sService;
    }

    private void $$robo$$android_app_NotificationManager$__constructor__(Context context, Handler handler) {
        this.mContext = context;
    }

    private static final NotificationManager $$robo$$android_app_NotificationManager$from(Context context) {
        return (NotificationManager)context.getSystemService("notification");
    }

    private final void $$robo$$android_app_NotificationManager$notify(int id2, Notification notification) {
        this.notify(null, id2, notification);
    }

    private final void $$robo$$android_app_NotificationManager$notify(String tag, int id2, Notification notification) {
        this.notifyAsUser(tag, id2, notification, new UserHandle(UserHandle.myUserId()));
    }

    private final void $$robo$$android_app_NotificationManager$notifyAsUser(String tag, int id2, Notification notification, UserHandle user) {
        INotificationManager service = NotificationManager.getService();
        String pkg = this.mContext.getPackageName();
        Notification.addFieldsFromContext(this.mContext, notification);
        if (notification.sound != null) {
            notification.sound = notification.sound.getCanonicalUri();
            if (StrictMode.vmFileUriExposureEnabled()) {
                notification.sound.checkFileUriExposed("Notification.sound");
            }
        }
        this.fixLegacySmallIcon(notification, pkg);
        if (this.mContext.getApplicationInfo().targetSdkVersion > 22 && notification.getSmallIcon() == null) {
            throw new IllegalArgumentException("Invalid notification (no valid small icon): " + notification);
        }
        if (localLOGV) {
            Log.v(TAG, pkg + ": notify(" + id2 + ", " + notification + ")");
        }
        notification.reduceImageSizes(this.mContext);
        ActivityManager am = (ActivityManager)this.mContext.getSystemService("activity");
        boolean isLowRam = am.isLowRamDevice();
        Notification copy = Notification.Builder.maybeCloneStrippedForDelivery(notification, isLowRam);
        try {
            service.enqueueNotificationWithTag(pkg, this.mContext.getOpPackageName(), tag, id2, copy, user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_NotificationManager$fixLegacySmallIcon(Notification n, String pkg) {
        if (n.getSmallIcon() == null && n.icon != 0) {
            n.setSmallIcon(Icon.createWithResource(pkg, n.icon));
        }
    }

    private final void $$robo$$android_app_NotificationManager$cancel(int id2) {
        this.cancel(null, id2);
    }

    private final void $$robo$$android_app_NotificationManager$cancel(String tag, int id2) {
        this.cancelAsUser(tag, id2, new UserHandle(UserHandle.myUserId()));
    }

    private final void $$robo$$android_app_NotificationManager$cancelAsUser(String tag, int id2, UserHandle user) {
        INotificationManager service = NotificationManager.getService();
        String pkg = this.mContext.getPackageName();
        if (localLOGV) {
            Log.v(TAG, pkg + ": cancel(" + id2 + ")");
        }
        try {
            service.cancelNotificationWithTag(pkg, tag, id2, user.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_NotificationManager$cancelAll() {
        INotificationManager service = NotificationManager.getService();
        String pkg = this.mContext.getPackageName();
        if (localLOGV) {
            Log.v(TAG, pkg + ": cancelAll()");
        }
        try {
            service.cancelAllNotifications(pkg, UserHandle.myUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_NotificationManager$createNotificationChannelGroup(NotificationChannelGroup group) {
        this.createNotificationChannelGroups(Arrays.asList(group));
    }

    private final void $$robo$$android_app_NotificationManager$createNotificationChannelGroups(List<NotificationChannelGroup> groups) {
        INotificationManager service = NotificationManager.getService();
        try {
            service.createNotificationChannelGroups(this.mContext.getPackageName(), new ParceledListSlice<NotificationChannelGroup>(groups));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_NotificationManager$createNotificationChannel(NotificationChannel channel) {
        this.createNotificationChannels(Arrays.asList(channel));
    }

    private final void $$robo$$android_app_NotificationManager$createNotificationChannels(List<NotificationChannel> channels) {
        INotificationManager service = NotificationManager.getService();
        try {
            service.createNotificationChannels(this.mContext.getPackageName(), new ParceledListSlice<NotificationChannel>(channels));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final NotificationChannel $$robo$$android_app_NotificationManager$getNotificationChannel(String channelId) {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.getNotificationChannel(this.mContext.getPackageName(), channelId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final List<NotificationChannel> $$robo$$android_app_NotificationManager$getNotificationChannels() {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.getNotificationChannels(this.mContext.getPackageName()).getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_NotificationManager$deleteNotificationChannel(String channelId) {
        INotificationManager service = NotificationManager.getService();
        try {
            service.deleteNotificationChannel(this.mContext.getPackageName(), channelId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final List<NotificationChannelGroup> $$robo$$android_app_NotificationManager$getNotificationChannelGroups() {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.getNotificationChannelGroups(this.mContext.getPackageName()).getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_NotificationManager$deleteNotificationChannelGroup(String groupId) {
        INotificationManager service = NotificationManager.getService();
        try {
            service.deleteNotificationChannelGroup(this.mContext.getPackageName(), groupId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final ComponentName $$robo$$android_app_NotificationManager$getEffectsSuppressor() {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.getEffectsSuppressor();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_NotificationManager$matchesCallFilter(Bundle extras) {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.matchesCallFilter(extras);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_NotificationManager$isSystemConditionProviderEnabled(String path) {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.isSystemConditionProviderEnabled(path);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_NotificationManager$setZenMode(int mode, Uri conditionId, String reason) {
        INotificationManager service = NotificationManager.getService();
        try {
            service.setZenMode(mode, conditionId, reason);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_app_NotificationManager$getZenMode() {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.getZenMode();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final ZenModeConfig $$robo$$android_app_NotificationManager$getZenModeConfig() {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.getZenModeConfig();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_app_NotificationManager$getRuleInstanceCount(ComponentName owner) {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.getRuleInstanceCount(owner);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final Map<String, AutomaticZenRule> $$robo$$android_app_NotificationManager$getAutomaticZenRules() {
        INotificationManager service = NotificationManager.getService();
        try {
            List<ZenModeConfig.ZenRule> rules = service.getZenRules();
            HashMap<String, AutomaticZenRule> ruleMap = new HashMap<String, AutomaticZenRule>();
            for (ZenModeConfig.ZenRule rule : rules) {
                ruleMap.put(rule.id, new AutomaticZenRule(rule.name, rule.component, rule.conditionId, NotificationManager.zenModeToInterruptionFilter(rule.zenMode), rule.enabled, rule.creationTime));
            }
            return ruleMap;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final AutomaticZenRule $$robo$$android_app_NotificationManager$getAutomaticZenRule(String id2) {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.getAutomaticZenRule(id2);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final String $$robo$$android_app_NotificationManager$addAutomaticZenRule(AutomaticZenRule automaticZenRule) {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.addAutomaticZenRule(automaticZenRule);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_NotificationManager$updateAutomaticZenRule(String id2, AutomaticZenRule automaticZenRule) {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.updateAutomaticZenRule(id2, automaticZenRule);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_NotificationManager$removeAutomaticZenRule(String id2) {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.removeAutomaticZenRule(id2);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_NotificationManager$removeAutomaticZenRules(String packageName) {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.removeAutomaticZenRules(packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_app_NotificationManager$getImportance() {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.getPackageImportance(this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_NotificationManager$areNotificationsEnabled() {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.areNotificationsEnabled(this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_NotificationManager$isNotificationPolicyAccessGranted() {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.isNotificationPolicyAccessGranted(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_NotificationManager$isNotificationListenerAccessGranted(ComponentName listener) {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.isNotificationListenerAccessGranted(listener);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_NotificationManager$isNotificationAssistantAccessGranted(ComponentName assistant) {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.isNotificationAssistantAccessGranted(assistant);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_NotificationManager$isNotificationPolicyAccessGrantedForPackage(String pkg) {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.isNotificationPolicyAccessGrantedForPackage(pkg);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final List<String> $$robo$$android_app_NotificationManager$getEnabledNotificationListenerPackages() {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.getEnabledNotificationListenerPackages();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final Policy $$robo$$android_app_NotificationManager$getNotificationPolicy() {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.getNotificationPolicy(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_NotificationManager$setNotificationPolicy(Policy policy) {
        NotificationManager.checkRequired("policy", policy);
        INotificationManager service = NotificationManager.getService();
        try {
            service.setNotificationPolicy(this.mContext.getOpPackageName(), policy);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_NotificationManager$setNotificationPolicyAccessGranted(String pkg, boolean granted) {
        INotificationManager service = NotificationManager.getService();
        try {
            service.setNotificationPolicyAccessGranted(pkg, granted);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_NotificationManager$setNotificationListenerAccessGranted(ComponentName listener, boolean granted) {
        INotificationManager service = NotificationManager.getService();
        try {
            service.setNotificationListenerAccessGranted(listener, granted);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_NotificationManager$setNotificationListenerAccessGrantedForUser(ComponentName listener, int userId, boolean granted) {
        INotificationManager service = NotificationManager.getService();
        try {
            service.setNotificationListenerAccessGrantedForUser(listener, userId, granted);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final List<ComponentName> $$robo$$android_app_NotificationManager$getEnabledNotificationListeners(int userId) {
        INotificationManager service = NotificationManager.getService();
        try {
            return service.getEnabledNotificationListeners(userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static final void $$robo$$android_app_NotificationManager$checkRequired(String name, Object value) {
        if (value == null) {
            throw new IllegalArgumentException(name + " is required");
        }
    }

    private final StatusBarNotification[] $$robo$$android_app_NotificationManager$getActiveNotifications() {
        INotificationManager service = NotificationManager.getService();
        String pkg = this.mContext.getPackageName();
        try {
            ParceledListSlice parceledList = service.getAppActiveNotifications(pkg, UserHandle.myUserId());
            List list = parceledList.getList();
            return list.toArray(new StatusBarNotification[list.size()]);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_app_NotificationManager$getCurrentInterruptionFilter() {
        INotificationManager service = NotificationManager.getService();
        try {
            return NotificationManager.zenModeToInterruptionFilter(service.getZenMode());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_NotificationManager$setInterruptionFilter(int interruptionFilter) {
        INotificationManager service = NotificationManager.getService();
        try {
            service.setInterruptionFilter(this.mContext.getOpPackageName(), interruptionFilter);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static final int $$robo$$android_app_NotificationManager$zenModeToInterruptionFilter(int zen) {
        switch (zen) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 3: {
                return 4;
            }
            case 2: {
                return 3;
            }
        }
        return 0;
    }

    private static final int $$robo$$android_app_NotificationManager$zenModeFromInterruptionFilter(int interruptionFilter, int defValue) {
        switch (interruptionFilter) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 3;
            }
            case 3: {
                return 2;
            }
        }
        return defValue;
    }

    static void __staticInitializer__() {
        TAG = "NotificationManager";
        localLOGV = false;
    }

    public static INotificationManager getService() {
        return InvokeDynamicSupport.bootstrapStatic("getService", $$robo$$android_app_NotificationManager$getService(), 0);
    }

    private void __constructor__(Context context, Handler handler) {
        this.$$robo$$android_app_NotificationManager$__constructor__(context, handler);
    }

    NotificationManager(Context context, Handler handler) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_NotificationManager$__constructor__(android.content.Context android.os.Handler ), 0, this, context, handler);
    }

    public static NotificationManager from(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("from", $$robo$$android_app_NotificationManager$from(android.content.Context ), 0, (Context)context);
    }

    public void notify(int n, Notification notification) {
        InvokeDynamicSupport.bootstrap("notify", $$robo$$android_app_NotificationManager$notify(int android.app.Notification ), 0, this, n, notification);
    }

    public void notify(String string2, int n, Notification notification) {
        InvokeDynamicSupport.bootstrap("notify", $$robo$$android_app_NotificationManager$notify(java.lang.String int android.app.Notification ), 0, this, string2, n, notification);
    }

    public void notifyAsUser(String string2, int n, Notification notification, UserHandle userHandle) {
        InvokeDynamicSupport.bootstrap("notifyAsUser", $$robo$$android_app_NotificationManager$notifyAsUser(java.lang.String int android.app.Notification android.os.UserHandle ), 0, this, string2, n, notification, userHandle);
    }

    private void fixLegacySmallIcon(Notification notification, String string2) {
        InvokeDynamicSupport.bootstrap("fixLegacySmallIcon", $$robo$$android_app_NotificationManager$fixLegacySmallIcon(android.app.Notification java.lang.String ), 0, this, notification, string2);
    }

    public void cancel(int n) {
        InvokeDynamicSupport.bootstrap("cancel", $$robo$$android_app_NotificationManager$cancel(int ), 0, this, n);
    }

    public void cancel(String string2, int n) {
        InvokeDynamicSupport.bootstrap("cancel", $$robo$$android_app_NotificationManager$cancel(java.lang.String int ), 0, this, string2, n);
    }

    public void cancelAsUser(String string2, int n, UserHandle userHandle) {
        InvokeDynamicSupport.bootstrap("cancelAsUser", $$robo$$android_app_NotificationManager$cancelAsUser(java.lang.String int android.os.UserHandle ), 0, this, string2, n, userHandle);
    }

    public void cancelAll() {
        InvokeDynamicSupport.bootstrap("cancelAll", $$robo$$android_app_NotificationManager$cancelAll(), 0, this);
    }

    public void createNotificationChannelGroup(NotificationChannelGroup notificationChannelGroup) {
        InvokeDynamicSupport.bootstrap("createNotificationChannelGroup", $$robo$$android_app_NotificationManager$createNotificationChannelGroup(android.app.NotificationChannelGroup ), 0, this, notificationChannelGroup);
    }

    public void createNotificationChannelGroups(List<NotificationChannelGroup> list) {
        InvokeDynamicSupport.bootstrap("createNotificationChannelGroups", $$robo$$android_app_NotificationManager$createNotificationChannelGroups(java.util.List<android.app.NotificationChannelGroup> ), 0, this, list);
    }

    public void createNotificationChannel(NotificationChannel notificationChannel) {
        InvokeDynamicSupport.bootstrap("createNotificationChannel", $$robo$$android_app_NotificationManager$createNotificationChannel(android.app.NotificationChannel ), 0, this, notificationChannel);
    }

    public void createNotificationChannels(List<NotificationChannel> list) {
        InvokeDynamicSupport.bootstrap("createNotificationChannels", $$robo$$android_app_NotificationManager$createNotificationChannels(java.util.List<android.app.NotificationChannel> ), 0, this, list);
    }

    public NotificationChannel getNotificationChannel(String string2) {
        return InvokeDynamicSupport.bootstrap("getNotificationChannel", $$robo$$android_app_NotificationManager$getNotificationChannel(java.lang.String ), 0, this, string2);
    }

    public List<NotificationChannel> getNotificationChannels() {
        return InvokeDynamicSupport.bootstrap("getNotificationChannels", $$robo$$android_app_NotificationManager$getNotificationChannels(), 0, this);
    }

    public void deleteNotificationChannel(String string2) {
        InvokeDynamicSupport.bootstrap("deleteNotificationChannel", $$robo$$android_app_NotificationManager$deleteNotificationChannel(java.lang.String ), 0, this, string2);
    }

    public List<NotificationChannelGroup> getNotificationChannelGroups() {
        return InvokeDynamicSupport.bootstrap("getNotificationChannelGroups", $$robo$$android_app_NotificationManager$getNotificationChannelGroups(), 0, this);
    }

    public void deleteNotificationChannelGroup(String string2) {
        InvokeDynamicSupport.bootstrap("deleteNotificationChannelGroup", $$robo$$android_app_NotificationManager$deleteNotificationChannelGroup(java.lang.String ), 0, this, string2);
    }

    public ComponentName getEffectsSuppressor() {
        return InvokeDynamicSupport.bootstrap("getEffectsSuppressor", $$robo$$android_app_NotificationManager$getEffectsSuppressor(), 0, this);
    }

    public boolean matchesCallFilter(Bundle bundle) {
        return (boolean)InvokeDynamicSupport.bootstrap("matchesCallFilter", $$robo$$android_app_NotificationManager$matchesCallFilter(android.os.Bundle ), 0, this, bundle);
    }

    public boolean isSystemConditionProviderEnabled(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isSystemConditionProviderEnabled", $$robo$$android_app_NotificationManager$isSystemConditionProviderEnabled(java.lang.String ), 0, this, string2);
    }

    public void setZenMode(int n, Uri uri, String string2) {
        InvokeDynamicSupport.bootstrap("setZenMode", $$robo$$android_app_NotificationManager$setZenMode(int android.net.Uri java.lang.String ), 0, this, n, uri, string2);
    }

    public int getZenMode() {
        return (int)InvokeDynamicSupport.bootstrap("getZenMode", $$robo$$android_app_NotificationManager$getZenMode(), 0, this);
    }

    public ZenModeConfig getZenModeConfig() {
        return InvokeDynamicSupport.bootstrap("getZenModeConfig", $$robo$$android_app_NotificationManager$getZenModeConfig(), 0, this);
    }

    public int getRuleInstanceCount(ComponentName componentName) {
        return (int)InvokeDynamicSupport.bootstrap("getRuleInstanceCount", $$robo$$android_app_NotificationManager$getRuleInstanceCount(android.content.ComponentName ), 0, this, componentName);
    }

    public Map<String, AutomaticZenRule> getAutomaticZenRules() {
        return InvokeDynamicSupport.bootstrap("getAutomaticZenRules", $$robo$$android_app_NotificationManager$getAutomaticZenRules(), 0, this);
    }

    public AutomaticZenRule getAutomaticZenRule(String string2) {
        return InvokeDynamicSupport.bootstrap("getAutomaticZenRule", $$robo$$android_app_NotificationManager$getAutomaticZenRule(java.lang.String ), 0, this, string2);
    }

    public String addAutomaticZenRule(AutomaticZenRule automaticZenRule) {
        return InvokeDynamicSupport.bootstrap("addAutomaticZenRule", $$robo$$android_app_NotificationManager$addAutomaticZenRule(android.app.AutomaticZenRule ), 0, this, automaticZenRule);
    }

    public boolean updateAutomaticZenRule(String string2, AutomaticZenRule automaticZenRule) {
        return (boolean)InvokeDynamicSupport.bootstrap("updateAutomaticZenRule", $$robo$$android_app_NotificationManager$updateAutomaticZenRule(java.lang.String android.app.AutomaticZenRule ), 0, this, string2, automaticZenRule);
    }

    public boolean removeAutomaticZenRule(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeAutomaticZenRule", $$robo$$android_app_NotificationManager$removeAutomaticZenRule(java.lang.String ), 0, this, string2);
    }

    public boolean removeAutomaticZenRules(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeAutomaticZenRules", $$robo$$android_app_NotificationManager$removeAutomaticZenRules(java.lang.String ), 0, this, string2);
    }

    public int getImportance() {
        return (int)InvokeDynamicSupport.bootstrap("getImportance", $$robo$$android_app_NotificationManager$getImportance(), 0, this);
    }

    public boolean areNotificationsEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("areNotificationsEnabled", $$robo$$android_app_NotificationManager$areNotificationsEnabled(), 0, this);
    }

    public boolean isNotificationPolicyAccessGranted() {
        return (boolean)InvokeDynamicSupport.bootstrap("isNotificationPolicyAccessGranted", $$robo$$android_app_NotificationManager$isNotificationPolicyAccessGranted(), 0, this);
    }

    public boolean isNotificationListenerAccessGranted(ComponentName componentName) {
        return (boolean)InvokeDynamicSupport.bootstrap("isNotificationListenerAccessGranted", $$robo$$android_app_NotificationManager$isNotificationListenerAccessGranted(android.content.ComponentName ), 0, this, componentName);
    }

    public boolean isNotificationAssistantAccessGranted(ComponentName componentName) {
        return (boolean)InvokeDynamicSupport.bootstrap("isNotificationAssistantAccessGranted", $$robo$$android_app_NotificationManager$isNotificationAssistantAccessGranted(android.content.ComponentName ), 0, this, componentName);
    }

    public boolean isNotificationPolicyAccessGrantedForPackage(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isNotificationPolicyAccessGrantedForPackage", $$robo$$android_app_NotificationManager$isNotificationPolicyAccessGrantedForPackage(java.lang.String ), 0, this, string2);
    }

    public List<String> getEnabledNotificationListenerPackages() {
        return InvokeDynamicSupport.bootstrap("getEnabledNotificationListenerPackages", $$robo$$android_app_NotificationManager$getEnabledNotificationListenerPackages(), 0, this);
    }

    public Policy getNotificationPolicy() {
        return InvokeDynamicSupport.bootstrap("getNotificationPolicy", $$robo$$android_app_NotificationManager$getNotificationPolicy(), 0, this);
    }

    public void setNotificationPolicy(Policy policy) {
        InvokeDynamicSupport.bootstrap("setNotificationPolicy", $$robo$$android_app_NotificationManager$setNotificationPolicy(android.app.NotificationManager$Policy ), 0, this, policy);
    }

    public void setNotificationPolicyAccessGranted(String string2, boolean bl) {
        InvokeDynamicSupport.bootstrap("setNotificationPolicyAccessGranted", $$robo$$android_app_NotificationManager$setNotificationPolicyAccessGranted(java.lang.String boolean ), 0, this, string2, bl);
    }

    public void setNotificationListenerAccessGranted(ComponentName componentName, boolean bl) {
        InvokeDynamicSupport.bootstrap("setNotificationListenerAccessGranted", $$robo$$android_app_NotificationManager$setNotificationListenerAccessGranted(android.content.ComponentName boolean ), 0, this, componentName, bl);
    }

    public void setNotificationListenerAccessGrantedForUser(ComponentName componentName, int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("setNotificationListenerAccessGrantedForUser", $$robo$$android_app_NotificationManager$setNotificationListenerAccessGrantedForUser(android.content.ComponentName int boolean ), 0, this, componentName, n, bl);
    }

    public List<ComponentName> getEnabledNotificationListeners(int n) {
        return InvokeDynamicSupport.bootstrap("getEnabledNotificationListeners", $$robo$$android_app_NotificationManager$getEnabledNotificationListeners(int ), 0, this, n);
    }

    private static void checkRequired(String string2, Object object) {
        InvokeDynamicSupport.bootstrapStatic("checkRequired", $$robo$$android_app_NotificationManager$checkRequired(java.lang.String java.lang.Object ), 0, (String)string2, (Object)object);
    }

    public StatusBarNotification[] getActiveNotifications() {
        return InvokeDynamicSupport.bootstrap("getActiveNotifications", $$robo$$android_app_NotificationManager$getActiveNotifications(), 0, this);
    }

    public int getCurrentInterruptionFilter() {
        return (int)InvokeDynamicSupport.bootstrap("getCurrentInterruptionFilter", $$robo$$android_app_NotificationManager$getCurrentInterruptionFilter(), 0, this);
    }

    public void setInterruptionFilter(int n) {
        InvokeDynamicSupport.bootstrap("setInterruptionFilter", $$robo$$android_app_NotificationManager$setInterruptionFilter(int ), 0, this, n);
    }

    public static int zenModeToInterruptionFilter(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("zenModeToInterruptionFilter", $$robo$$android_app_NotificationManager$zenModeToInterruptionFilter(int ), 0, (int)n);
    }

    public static int zenModeFromInterruptionFilter(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("zenModeFromInterruptionFilter", $$robo$$android_app_NotificationManager$zenModeFromInterruptionFilter(int int ), 0, (int)n, (int)n2);
    }

    static {
        RobolectricInternals.classInitializing(NotificationManager.class);
    }

    public /* synthetic */ NotificationManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NotificationManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Policy
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int PRIORITY_CATEGORY_REMINDERS = 1;
        public static int PRIORITY_CATEGORY_EVENTS = 2;
        public static int PRIORITY_CATEGORY_MESSAGES = 4;
        public static int PRIORITY_CATEGORY_CALLS = 8;
        public static int PRIORITY_CATEGORY_REPEAT_CALLERS = 16;
        private static int[] ALL_PRIORITY_CATEGORIES;
        public static int PRIORITY_SENDERS_ANY = 0;
        public static int PRIORITY_SENDERS_CONTACTS = 1;
        public static int PRIORITY_SENDERS_STARRED = 2;
        public int priorityCategories;
        public int priorityCallSenders;
        public int priorityMessageSenders;
        public static int SUPPRESSED_EFFECTS_UNSET = -1;
        public static int SUPPRESSED_EFFECT_SCREEN_OFF = 1;
        public static int SUPPRESSED_EFFECT_SCREEN_ON = 2;
        private static int[] ALL_SUPPRESSED_EFFECTS;
        public int suppressedVisualEffects;
        public static Parcelable.Creator<Policy> CREATOR;

        private void $$robo$$android_app_NotificationManager_Policy$__constructor__(int priorityCategories, int priorityCallSenders, int priorityMessageSenders) {
        }

        private void $$robo$$android_app_NotificationManager_Policy$__constructor__(int priorityCategories, int priorityCallSenders, int priorityMessageSenders, int suppressedVisualEffects) {
            this.priorityCategories = priorityCategories;
            this.priorityCallSenders = priorityCallSenders;
            this.priorityMessageSenders = priorityMessageSenders;
            this.suppressedVisualEffects = suppressedVisualEffects;
        }

        private void $$robo$$android_app_NotificationManager_Policy$__constructor__(Parcel source) {
        }

        private final void $$robo$$android_app_NotificationManager_Policy$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.priorityCategories);
            dest.writeInt(this.priorityCallSenders);
            dest.writeInt(this.priorityMessageSenders);
            dest.writeInt(this.suppressedVisualEffects);
        }

        private final int $$robo$$android_app_NotificationManager_Policy$describeContents() {
            return 0;
        }

        private final int $$robo$$android_app_NotificationManager_Policy$hashCode() {
            return Objects.hash(this.priorityCategories, this.priorityCallSenders, this.priorityMessageSenders, this.suppressedVisualEffects);
        }

        private final boolean $$robo$$android_app_NotificationManager_Policy$equals(Object o) {
            if (!(o instanceof Policy)) {
                return false;
            }
            if (o == this) {
                return true;
            }
            Policy other = (Policy)o;
            return other.priorityCategories == this.priorityCategories && other.priorityCallSenders == this.priorityCallSenders && other.priorityMessageSenders == this.priorityMessageSenders && other.suppressedVisualEffects == this.suppressedVisualEffects;
        }

        private final String $$robo$$android_app_NotificationManager_Policy$toString() {
            return "NotificationManager.Policy[priorityCategories=" + Policy.priorityCategoriesToString(this.priorityCategories) + ",priorityCallSenders=" + Policy.prioritySendersToString(this.priorityCallSenders) + ",priorityMessageSenders=" + Policy.prioritySendersToString(this.priorityMessageSenders) + ",suppressedVisualEffects=" + Policy.suppressedEffectsToString(this.suppressedVisualEffects) + "]";
        }

        private static final String $$robo$$android_app_NotificationManager_Policy$suppressedEffectsToString(int effects) {
            if (effects <= 0) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < ALL_SUPPRESSED_EFFECTS.length; ++i) {
                int effect = ALL_SUPPRESSED_EFFECTS[i];
                if ((effects & effect) != 0) {
                    if (sb.length() > 0) {
                        sb.append(',');
                    }
                    sb.append(Policy.effectToString(effect));
                }
                effects &= ~effect;
            }
            if (effects != 0) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append("UNKNOWN_").append(effects);
            }
            return sb.toString();
        }

        private static final String $$robo$$android_app_NotificationManager_Policy$priorityCategoriesToString(int priorityCategories) {
            if (priorityCategories == 0) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < ALL_PRIORITY_CATEGORIES.length; ++i) {
                int priorityCategory = ALL_PRIORITY_CATEGORIES[i];
                if ((priorityCategories & priorityCategory) != 0) {
                    if (sb.length() > 0) {
                        sb.append(',');
                    }
                    sb.append(Policy.priorityCategoryToString(priorityCategory));
                }
                priorityCategories &= ~priorityCategory;
            }
            if (priorityCategories != 0) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append("PRIORITY_CATEGORY_UNKNOWN_").append(priorityCategories);
            }
            return sb.toString();
        }

        private static final String $$robo$$android_app_NotificationManager_Policy$effectToString(int effect) {
            switch (effect) {
                case 1: {
                    return "SUPPRESSED_EFFECT_SCREEN_OFF";
                }
                case 2: {
                    return "SUPPRESSED_EFFECT_SCREEN_ON";
                }
                case -1: {
                    return "SUPPRESSED_EFFECTS_UNSET";
                }
            }
            return "UNKNOWN_" + effect;
        }

        private static final String $$robo$$android_app_NotificationManager_Policy$priorityCategoryToString(int priorityCategory) {
            switch (priorityCategory) {
                case 1: {
                    return "PRIORITY_CATEGORY_REMINDERS";
                }
                case 2: {
                    return "PRIORITY_CATEGORY_EVENTS";
                }
                case 4: {
                    return "PRIORITY_CATEGORY_MESSAGES";
                }
                case 8: {
                    return "PRIORITY_CATEGORY_CALLS";
                }
                case 16: {
                    return "PRIORITY_CATEGORY_REPEAT_CALLERS";
                }
            }
            return "PRIORITY_CATEGORY_UNKNOWN_" + priorityCategory;
        }

        private static final String $$robo$$android_app_NotificationManager_Policy$prioritySendersToString(int prioritySenders) {
            switch (prioritySenders) {
                case 0: {
                    return "PRIORITY_SENDERS_ANY";
                }
                case 1: {
                    return "PRIORITY_SENDERS_CONTACTS";
                }
                case 2: {
                    return "PRIORITY_SENDERS_STARRED";
                }
            }
            return "PRIORITY_SENDERS_UNKNOWN_" + prioritySenders;
        }

        static void __staticInitializer__() {
            ALL_PRIORITY_CATEGORIES = new int[]{1, 2, 4, 8, 16};
            ALL_SUPPRESSED_EFFECTS = new int[]{1, 2};
            CREATOR = new Parcelable.Creator<Policy>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_app_NotificationManager_Policy_1$__constructor__() {
                }

                private final Policy $$robo$$android_app_NotificationManager_Policy_1$createFromParcel(Parcel in) {
                    return new Policy(in);
                }

                private final Policy[] $$robo$$android_app_NotificationManager_Policy_1$newArray(int size) {
                    return new Policy[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_app_NotificationManager_Policy_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_NotificationManager_Policy_1$__constructor__(), 0, this);
                }

                @Override
                public Policy createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_app_NotificationManager_Policy_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public Policy[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_app_NotificationManager_Policy_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(int n, int n2, int n3) {
            this.$$robo$$android_app_NotificationManager_Policy$__constructor__(n, n2, n3);
        }

        public Policy(int n, int n2, int n3) {
            this(n, n2, n3, -1);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_NotificationManager_Policy$__constructor__(int int int ), 0, this, n, n2, n3);
        }

        private void __constructor__(int n, int n2, int n3, int n4) {
            this.$$robo$$android_app_NotificationManager_Policy$__constructor__(n, n2, n3, n4);
        }

        public Policy(int n, int n2, int n3, int n4) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_NotificationManager_Policy$__constructor__(int int int int ), 0, this, n, n2, n3, n4);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_app_NotificationManager_Policy$__constructor__(parcel);
        }

        public Policy(Parcel parcel) {
            this(parcel.readInt(), parcel.readInt(), parcel.readInt(), parcel.readInt());
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_NotificationManager_Policy$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_app_NotificationManager_Policy$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_app_NotificationManager_Policy$describeContents(), 0, this);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_app_NotificationManager_Policy$hashCode(), 0, this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_app_NotificationManager_Policy$equals(java.lang.Object ), 0, this, object);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_app_NotificationManager_Policy$toString(), 0, this);
        }

        public static String suppressedEffectsToString(int n) {
            return InvokeDynamicSupport.bootstrapStatic("suppressedEffectsToString", $$robo$$android_app_NotificationManager_Policy$suppressedEffectsToString(int ), 0, (int)n);
        }

        public static String priorityCategoriesToString(int n) {
            return InvokeDynamicSupport.bootstrapStatic("priorityCategoriesToString", $$robo$$android_app_NotificationManager_Policy$priorityCategoriesToString(int ), 0, (int)n);
        }

        private static String effectToString(int n) {
            return InvokeDynamicSupport.bootstrapStatic("effectToString", $$robo$$android_app_NotificationManager_Policy$effectToString(int ), 0, (int)n);
        }

        private static String priorityCategoryToString(int n) {
            return InvokeDynamicSupport.bootstrapStatic("priorityCategoryToString", $$robo$$android_app_NotificationManager_Policy$priorityCategoryToString(int ), 0, (int)n);
        }

        public static String prioritySendersToString(int n) {
            return InvokeDynamicSupport.bootstrapStatic("prioritySendersToString", $$robo$$android_app_NotificationManager_Policy$prioritySendersToString(int ), 0, (int)n);
        }

        static {
            RobolectricInternals.classInitializing(Policy.class);
        }

        public /* synthetic */ Policy() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Policy)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Importance {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface InterruptionFilter {
    }
}

