/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Size;
import com.android.internal.graphics.ColorUtils;
import com.android.internal.graphics.palette.Palette;
import com.android.internal.graphics.palette.VariationalKMeansQuantizer;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class WallpaperColors
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int HINT_SUPPORTS_DARK_TEXT = 1;
    public static int HINT_SUPPORTS_DARK_THEME = 2;
    public static int HINT_FROM_BITMAP = 4;
    private static int MAX_BITMAP_SIZE = 112;
    private static int MAX_WALLPAPER_EXTRACTION_AREA = 12544;
    private static float MIN_COLOR_OCCURRENCE = 0.05f;
    private static float DARK_THEME_MEAN_LUMINANCE = 0.25f;
    private static float BRIGHT_IMAGE_MEAN_LUMINANCE = 0.75f;
    private static float DARK_PIXEL_LUMINANCE = 0.45f;
    private static float MAX_DARK_AREA = 0.05f;
    private ArrayList<Color> mMainColors;
    private int mColorHints;
    public static Parcelable.Creator<WallpaperColors> CREATOR;

    private void $$robo$$android_app_WallpaperColors$__constructor__(Parcel parcel) {
        this.mMainColors = new ArrayList();
        int count = parcel.readInt();
        for (int i = 0; i < count; ++i) {
            int colorInt = parcel.readInt();
            Color color2 = Color.valueOf(colorInt);
            this.mMainColors.add(color2);
        }
        this.mColorHints = parcel.readInt();
    }

    private static final WallpaperColors $$robo$$android_app_WallpaperColors$fromDrawable(Drawable drawable2) {
        int width = drawable2.getIntrinsicWidth();
        int height = drawable2.getIntrinsicHeight();
        if (width <= 0 || height <= 0) {
            width = 112;
            height = 112;
        }
        Size optimalSize = WallpaperColors.calculateOptimalSize(width, height);
        Bitmap bitmap = Bitmap.createBitmap(optimalSize.getWidth(), optimalSize.getHeight(), Bitmap.Config.ARGB_8888);
        Canvas bmpCanvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, bitmap.getWidth(), bitmap.getHeight());
        drawable2.draw(bmpCanvas);
        WallpaperColors colors = WallpaperColors.fromBitmap(bitmap);
        bitmap.recycle();
        return colors;
    }

    private static final WallpaperColors $$robo$$android_app_WallpaperColors$fromBitmap(Bitmap bitmap) {
        if (bitmap == null) {
            throw new IllegalArgumentException("Bitmap can't be null");
        }
        int bitmapArea = bitmap.getWidth() * bitmap.getHeight();
        boolean shouldRecycle = false;
        if (bitmapArea > 12544) {
            shouldRecycle = true;
            Size optimalSize = WallpaperColors.calculateOptimalSize(bitmap.getWidth(), bitmap.getHeight());
            bitmap = Bitmap.createScaledBitmap(bitmap, optimalSize.getWidth(), optimalSize.getHeight(), true);
        }
        Palette palette = Palette.from(bitmap).setQuantizer(new VariationalKMeansQuantizer()).maximumColorCount(5).clearFilters().resizeBitmapArea(12544).generate();
        ArrayList<Palette.Swatch> swatches = new ArrayList<Palette.Swatch>(palette.getSwatches());
        float minColorArea = (float)(bitmap.getWidth() * bitmap.getHeight()) * 0.05f;
        swatches.removeIf(s -> (float)s.getPopulation() < minColorArea);
        swatches.sort((a, b) -> b.getPopulation() - a.getPopulation());
        int swatchesSize = swatches.size();
        Color primary = null;
        Color secondary = null;
        Color tertiary = null;
        block5: for (int i = 0; i < swatchesSize; ++i) {
            Color color2 = Color.valueOf(swatches.get(i).getRgb());
            switch (i) {
                case 0: {
                    primary = color2;
                    continue block5;
                }
                case 1: {
                    secondary = color2;
                    continue block5;
                }
                case 2: {
                    tertiary = color2;
                    continue block5;
                }
            }
        }
        int hints = WallpaperColors.calculateDarkHints(bitmap);
        if (shouldRecycle) {
            bitmap.recycle();
        }
        return new WallpaperColors(primary, secondary, tertiary, 4 | hints);
    }

    private void $$robo$$android_app_WallpaperColors$__constructor__(Color primaryColor, Color secondaryColor, Color tertiaryColor) {
    }

    private void $$robo$$android_app_WallpaperColors$__constructor__(Color primaryColor, Color secondaryColor, Color tertiaryColor, int colorHints) {
        if (primaryColor == null) {
            throw new IllegalArgumentException("Primary color should never be null.");
        }
        this.mMainColors = new ArrayList(3);
        this.mMainColors.add(primaryColor);
        if (secondaryColor != null) {
            this.mMainColors.add(secondaryColor);
        }
        if (tertiaryColor != null) {
            if (secondaryColor == null) {
                throw new IllegalArgumentException("tertiaryColor can't be specified when secondaryColor is null");
            }
            this.mMainColors.add(tertiaryColor);
        }
        this.mColorHints = colorHints;
    }

    private final int $$robo$$android_app_WallpaperColors$describeContents() {
        return 0;
    }

    private final void $$robo$$android_app_WallpaperColors$writeToParcel(Parcel dest, int flags) {
        List<Color> mainColors = this.getMainColors();
        int count = mainColors.size();
        dest.writeInt(count);
        for (int i = 0; i < count; ++i) {
            Color color2 = mainColors.get(i);
            dest.writeInt(color2.toArgb());
        }
        dest.writeInt(this.mColorHints);
    }

    private final Color $$robo$$android_app_WallpaperColors$getPrimaryColor() {
        return this.mMainColors.get(0);
    }

    private final Color $$robo$$android_app_WallpaperColors$getSecondaryColor() {
        return this.mMainColors.size() < 2 ? null : this.mMainColors.get(1);
    }

    private final Color $$robo$$android_app_WallpaperColors$getTertiaryColor() {
        return this.mMainColors.size() < 3 ? null : this.mMainColors.get(2);
    }

    private final List<Color> $$robo$$android_app_WallpaperColors$getMainColors() {
        return Collections.unmodifiableList(this.mMainColors);
    }

    private final boolean $$robo$$android_app_WallpaperColors$equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WallpaperColors other = (WallpaperColors)o;
        return this.mMainColors.equals(other.mMainColors) && this.mColorHints == other.mColorHints;
    }

    private final int $$robo$$android_app_WallpaperColors$hashCode() {
        return 31 * this.mMainColors.hashCode() + this.mColorHints;
    }

    private final int $$robo$$android_app_WallpaperColors$getColorHints() {
        return this.mColorHints;
    }

    private final void $$robo$$android_app_WallpaperColors$setColorHints(int colorHints) {
        this.mColorHints = colorHints;
    }

    private static final int $$robo$$android_app_WallpaperColors$calculateDarkHints(Bitmap source) {
        if (source == null) {
            return 0;
        }
        int[] pixels = new int[source.getWidth() * source.getHeight()];
        double totalLuminance = 0.0;
        int maxDarkPixels = (int)((float)pixels.length * 0.05f);
        int darkPixels = 0;
        source.getPixels(pixels, 0, source.getWidth(), 0, 0, source.getWidth(), source.getHeight());
        float[] tmpHsl = new float[3];
        for (int i = 0; i < pixels.length; ++i) {
            ColorUtils.colorToHSL(pixels[i], tmpHsl);
            float luminance = tmpHsl[2];
            int alpha = Color.alpha(pixels[i]);
            if (luminance < 0.45f && alpha != 0) {
                ++darkPixels;
            }
            totalLuminance += (double)luminance;
        }
        int hints = 0;
        double meanLuminance = totalLuminance / (double)pixels.length;
        if (meanLuminance > 0.75 && darkPixels < maxDarkPixels) {
            hints |= 1;
        }
        if (meanLuminance < 0.25) {
            hints |= 2;
        }
        return hints;
    }

    private static final Size $$robo$$android_app_WallpaperColors$calculateOptimalSize(int width, int height) {
        int requestedArea = width * height;
        double scale = 1.0;
        if (requestedArea > 12544) {
            scale = Math.sqrt(12544.0 / (double)requestedArea);
        }
        int newWidth = (int)((double)width * scale);
        int newHeight = (int)((double)height * scale);
        if (newWidth == 0) {
            newWidth = 1;
        }
        if (newHeight == 0) {
            newHeight = 1;
        }
        return new Size(newWidth, newHeight);
    }

    private final String $$robo$$android_app_WallpaperColors$toString() {
        StringBuilder colors = new StringBuilder();
        for (int i = 0; i < this.mMainColors.size(); ++i) {
            colors.append(Integer.toHexString(this.mMainColors.get(i).toArgb())).append(" ");
        }
        return "[WallpaperColors: " + colors.toString() + "h: " + this.mColorHints + "]";
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<WallpaperColors>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_app_WallpaperColors_1$__constructor__() {
            }

            private final WallpaperColors $$robo$$android_app_WallpaperColors_1$createFromParcel(Parcel in) {
                return new WallpaperColors(in);
            }

            private final WallpaperColors[] $$robo$$android_app_WallpaperColors_1$newArray(int size) {
                return new WallpaperColors[size];
            }

            private void __constructor__() {
                this.$$robo$$android_app_WallpaperColors_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_WallpaperColors_1$__constructor__(), 0, this);
            }

            @Override
            public WallpaperColors createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_app_WallpaperColors_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public WallpaperColors[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_app_WallpaperColors_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_app_WallpaperColors$__constructor__(parcel);
    }

    public WallpaperColors(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_WallpaperColors$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    public static WallpaperColors fromDrawable(Drawable drawable2) {
        return InvokeDynamicSupport.bootstrapStatic("fromDrawable", $$robo$$android_app_WallpaperColors$fromDrawable(android.graphics.drawable.Drawable ), 0, (Drawable)drawable2);
    }

    public static WallpaperColors fromBitmap(Bitmap bitmap) {
        return InvokeDynamicSupport.bootstrapStatic("fromBitmap", $$robo$$android_app_WallpaperColors$fromBitmap(android.graphics.Bitmap ), 0, (Bitmap)bitmap);
    }

    private void __constructor__(Color color2, Color color3, Color color4) {
        this.$$robo$$android_app_WallpaperColors$__constructor__(color2, color3, color4);
    }

    public WallpaperColors(Color color2, Color color3, Color color4) {
        this(color2, color3, color4, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_WallpaperColors$__constructor__(android.graphics.Color android.graphics.Color android.graphics.Color ), 0, this, color2, color3, color4);
    }

    private void __constructor__(Color color2, Color color3, Color color4, int n) {
        this.$$robo$$android_app_WallpaperColors$__constructor__(color2, color3, color4, n);
    }

    public WallpaperColors(Color color2, Color color3, Color color4, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_WallpaperColors$__constructor__(android.graphics.Color android.graphics.Color android.graphics.Color int ), 0, this, color2, color3, color4, n);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_app_WallpaperColors$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_app_WallpaperColors$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    public Color getPrimaryColor() {
        return InvokeDynamicSupport.bootstrap("getPrimaryColor", $$robo$$android_app_WallpaperColors$getPrimaryColor(), 0, this);
    }

    public Color getSecondaryColor() {
        return InvokeDynamicSupport.bootstrap("getSecondaryColor", $$robo$$android_app_WallpaperColors$getSecondaryColor(), 0, this);
    }

    public Color getTertiaryColor() {
        return InvokeDynamicSupport.bootstrap("getTertiaryColor", $$robo$$android_app_WallpaperColors$getTertiaryColor(), 0, this);
    }

    public List<Color> getMainColors() {
        return InvokeDynamicSupport.bootstrap("getMainColors", $$robo$$android_app_WallpaperColors$getMainColors(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_app_WallpaperColors$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_app_WallpaperColors$hashCode(), 0, this);
    }

    public int getColorHints() {
        return (int)InvokeDynamicSupport.bootstrap("getColorHints", $$robo$$android_app_WallpaperColors$getColorHints(), 0, this);
    }

    public void setColorHints(int n) {
        InvokeDynamicSupport.bootstrap("setColorHints", $$robo$$android_app_WallpaperColors$setColorHints(int ), 0, this, n);
    }

    private static int calculateDarkHints(Bitmap bitmap) {
        return (int)InvokeDynamicSupport.bootstrapStatic("calculateDarkHints", $$robo$$android_app_WallpaperColors$calculateDarkHints(android.graphics.Bitmap ), 0, (Bitmap)bitmap);
    }

    private static Size calculateOptimalSize(int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("calculateOptimalSize", $$robo$$android_app_WallpaperColors$calculateOptimalSize(int int ), 0, (int)n, (int)n2);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_app_WallpaperColors$toString(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(WallpaperColors.class);
    }

    public /* synthetic */ WallpaperColors() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WallpaperColors)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

