/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.IWallpaperManager;
import android.app.IWallpaperManagerCallback;
import android.app.WallpaperColors;
import android.app.WallpaperInfo;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapRegionDecoder;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.DeadSystemException;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import android.view.WindowManagerGlobal;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import libcore.io.IoUtils;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class WallpaperManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG;
    private static boolean DEBUG;
    private float mWallpaperXStep;
    private float mWallpaperYStep;
    private static String PROP_WALLPAPER = "ro.config.wallpaper";
    private static String PROP_LOCK_WALLPAPER = "ro.config.lock_wallpaper";
    private static String PROP_WALLPAPER_COMPONENT = "ro.config.wallpaper_component";
    public static String ACTION_CROP_AND_SET_WALLPAPER = "android.service.wallpaper.CROP_AND_SET_WALLPAPER";
    public static String ACTION_LIVE_WALLPAPER_CHOOSER = "android.service.wallpaper.LIVE_WALLPAPER_CHOOSER";
    public static String ACTION_CHANGE_LIVE_WALLPAPER = "android.service.wallpaper.CHANGE_LIVE_WALLPAPER";
    public static String EXTRA_LIVE_WALLPAPER_COMPONENT = "android.service.wallpaper.extra.LIVE_WALLPAPER_COMPONENT";
    public static String WALLPAPER_PREVIEW_META_DATA = "android.wallpaper.preview";
    public static String COMMAND_TAP = "android.wallpaper.tap";
    public static String COMMAND_SECONDARY_TAP = "android.wallpaper.secondaryTap";
    public static String COMMAND_DROP = "android.home.drop";
    public static String EXTRA_NEW_WALLPAPER_ID = "android.service.wallpaper.extra.ID";
    public static int FLAG_SYSTEM = 1;
    public static int FLAG_LOCK = 2;
    private Context mContext;
    private static Object sSync;
    private static Globals sGlobals;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_app_WallpaperManager$initGlobals(Looper looper) {
        Object object = sSync;
        synchronized (object) {
            if (sGlobals == null) {
                sGlobals = new Globals(looper);
            }
        }
    }

    private void $$robo$$android_app_WallpaperManager$__constructor__(Context context, Handler handler) {
        this.mWallpaperXStep = -1.0f;
        this.mWallpaperYStep = -1.0f;
        this.mContext = context;
        WallpaperManager.initGlobals(context.getMainLooper());
    }

    private static final WallpaperManager $$robo$$android_app_WallpaperManager$getInstance(Context context) {
        return (WallpaperManager)context.getSystemService("wallpaper");
    }

    private final IWallpaperManager $$robo$$android_app_WallpaperManager$getIWallpaperManager() {
        return sGlobals.mService;
    }

    private final Drawable $$robo$$android_app_WallpaperManager$getDrawable() {
        Bitmap bm = sGlobals.peekWallpaperBitmap(this.mContext, true, 1);
        if (bm != null) {
            BitmapDrawable dr = new BitmapDrawable(this.mContext.getResources(), bm);
            ((Drawable)dr).setDither(false);
            return dr;
        }
        return null;
    }

    private final Drawable $$robo$$android_app_WallpaperManager$getBuiltInDrawable() {
        return this.getBuiltInDrawable(0, 0, false, 0.0f, 0.0f, 1);
    }

    private final Drawable $$robo$$android_app_WallpaperManager$getBuiltInDrawable(int which) {
        return this.getBuiltInDrawable(0, 0, false, 0.0f, 0.0f, which);
    }

    private final Drawable $$robo$$android_app_WallpaperManager$getBuiltInDrawable(int outWidth, int outHeight, boolean scaleToFit, float horizontalAlignment, float verticalAlignment) {
        return this.getBuiltInDrawable(outWidth, outHeight, scaleToFit, horizontalAlignment, verticalAlignment, 1);
    }

    private final Drawable $$robo$$android_app_WallpaperManager$getBuiltInDrawable(int outWidth, int outHeight, boolean scaleToFit, float horizontalAlignment, float verticalAlignment, int which) {
        RectF cropRectF;
        if (sGlobals.mService == null) {
            Log.w(TAG, "WallpaperService not running");
            throw new RuntimeException(new DeadSystemException());
        }
        if (which != 1 && which != 2) {
            throw new IllegalArgumentException("Must request exactly one kind of wallpaper");
        }
        Resources resources = this.mContext.getResources();
        horizontalAlignment = Math.max(0.0f, Math.min(1.0f, horizontalAlignment));
        verticalAlignment = Math.max(0.0f, Math.min(1.0f, verticalAlignment));
        InputStream wpStream = WallpaperManager.openDefaultWallpaper(this.mContext, which);
        if (wpStream == null) {
            if (DEBUG) {
                Log.w(TAG, "default wallpaper stream " + which + " is null");
            }
            return null;
        }
        BufferedInputStream is = new BufferedInputStream(wpStream);
        if (outWidth <= 0 || outHeight <= 0) {
            Bitmap fullSize = BitmapFactory.decodeStream(is, null, null);
            return new BitmapDrawable(resources, fullSize);
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeStream(is, null, options);
        if (options.outWidth == 0 || options.outHeight == 0) {
            Log.e(TAG, "default wallpaper dimensions are 0");
            return null;
        }
        int inWidth = options.outWidth;
        int inHeight = options.outHeight;
        is = new BufferedInputStream(WallpaperManager.openDefaultWallpaper(this.mContext, which));
        outWidth = Math.min(inWidth, outWidth);
        outHeight = Math.min(inHeight, outHeight);
        if (scaleToFit) {
            cropRectF = WallpaperManager.getMaxCropRect(inWidth, inHeight, outWidth, outHeight, horizontalAlignment, verticalAlignment);
        } else {
            float left = (float)(inWidth - outWidth) * horizontalAlignment;
            float right = left + (float)outWidth;
            float top = (float)(inHeight - outHeight) * verticalAlignment;
            float bottom = top + (float)outHeight;
            cropRectF = new RectF(left, top, right, bottom);
        }
        Rect roundedTrueCrop = new Rect();
        cropRectF.roundOut(roundedTrueCrop);
        if (roundedTrueCrop.width() <= 0 || roundedTrueCrop.height() <= 0) {
            Log.w(TAG, "crop has bad values for full size image");
            return null;
        }
        int scaleDownSampleSize = Math.min(roundedTrueCrop.width() / outWidth, roundedTrueCrop.height() / outHeight);
        BitmapRegionDecoder decoder = null;
        try {
            decoder = BitmapRegionDecoder.newInstance(is, true);
        }
        catch (IOException e) {
            Log.w(TAG, "cannot open region decoder for default wallpaper");
        }
        Bitmap crop = null;
        if (decoder != null) {
            BitmapFactory.Options options2 = new BitmapFactory.Options();
            if (scaleDownSampleSize > 1) {
                options2.inSampleSize = scaleDownSampleSize;
            }
            crop = decoder.decodeRegion(roundedTrueCrop, options2);
            decoder.recycle();
        }
        if (crop == null) {
            is = new BufferedInputStream(WallpaperManager.openDefaultWallpaper(this.mContext, which));
            Bitmap fullSize = null;
            BitmapFactory.Options options3 = new BitmapFactory.Options();
            if (scaleDownSampleSize > 1) {
                options3.inSampleSize = scaleDownSampleSize;
            }
            if ((fullSize = BitmapFactory.decodeStream(is, null, options3)) != null) {
                crop = Bitmap.createBitmap(fullSize, roundedTrueCrop.left, roundedTrueCrop.top, roundedTrueCrop.width(), roundedTrueCrop.height());
            }
        }
        if (crop == null) {
            Log.w(TAG, "cannot decode default wallpaper");
            return null;
        }
        if (outWidth > 0 && outHeight > 0 && (crop.getWidth() != outWidth || crop.getHeight() != outHeight)) {
            Matrix m = new Matrix();
            RectF cropRect = new RectF(0.0f, 0.0f, crop.getWidth(), crop.getHeight());
            RectF returnRect = new RectF(0.0f, 0.0f, outWidth, outHeight);
            m.setRectToRect(cropRect, returnRect, Matrix.ScaleToFit.FILL);
            Bitmap tmp = Bitmap.createBitmap((int)returnRect.width(), (int)returnRect.height(), Bitmap.Config.ARGB_8888);
            if (tmp != null) {
                Canvas c = new Canvas(tmp);
                Paint p = new Paint();
                p.setFilterBitmap(true);
                c.drawBitmap(crop, m, p);
                crop = tmp;
            }
        }
        return new BitmapDrawable(resources, crop);
    }

    private static final RectF $$robo$$android_app_WallpaperManager$getMaxCropRect(int inWidth, int inHeight, int outWidth, int outHeight, float horizontalAlignment, float verticalAlignment) {
        RectF cropRect = new RectF();
        if ((float)inWidth / (float)inHeight > (float)outWidth / (float)outHeight) {
            cropRect.top = 0.0f;
            cropRect.bottom = inHeight;
            float cropWidth = (float)outWidth * ((float)inHeight / (float)outHeight);
            cropRect.left = ((float)inWidth - cropWidth) * horizontalAlignment;
            cropRect.right = cropRect.left + cropWidth;
        } else {
            cropRect.left = 0.0f;
            cropRect.right = inWidth;
            float cropHeight = (float)outHeight * ((float)inWidth / (float)outWidth);
            cropRect.top = ((float)inHeight - cropHeight) * verticalAlignment;
            cropRect.bottom = cropRect.top + cropHeight;
        }
        return cropRect;
    }

    private final Drawable $$robo$$android_app_WallpaperManager$peekDrawable() {
        Bitmap bm = sGlobals.peekWallpaperBitmap(this.mContext, false, 1);
        if (bm != null) {
            BitmapDrawable dr = new BitmapDrawable(this.mContext.getResources(), bm);
            ((Drawable)dr).setDither(false);
            return dr;
        }
        return null;
    }

    private final Drawable $$robo$$android_app_WallpaperManager$getFastDrawable() {
        Bitmap bm = sGlobals.peekWallpaperBitmap(this.mContext, true, 1);
        if (bm != null) {
            return new FastBitmapDrawable(bm);
        }
        return null;
    }

    private final Drawable $$robo$$android_app_WallpaperManager$peekFastDrawable() {
        Bitmap bm = sGlobals.peekWallpaperBitmap(this.mContext, false, 1);
        if (bm != null) {
            return new FastBitmapDrawable(bm);
        }
        return null;
    }

    private final Bitmap $$robo$$android_app_WallpaperManager$getBitmap() {
        return this.getBitmapAsUser(this.mContext.getUserId());
    }

    private final Bitmap $$robo$$android_app_WallpaperManager$getBitmapAsUser(int userId) {
        return sGlobals.peekWallpaperBitmap(this.mContext, true, 1, userId);
    }

    private final ParcelFileDescriptor $$robo$$android_app_WallpaperManager$getWallpaperFile(int which) {
        return this.getWallpaperFile(which, this.mContext.getUserId());
    }

    private final void $$robo$$android_app_WallpaperManager$addOnColorsChangedListener(OnColorsChangedListener listener, Handler handler) {
        this.addOnColorsChangedListener(listener, handler, this.mContext.getUserId());
    }

    private final void $$robo$$android_app_WallpaperManager$addOnColorsChangedListener(OnColorsChangedListener listener, Handler handler, int userId) {
        sGlobals.addOnColorsChangedListener(listener, handler, userId);
    }

    private final void $$robo$$android_app_WallpaperManager$removeOnColorsChangedListener(OnColorsChangedListener callback) {
        this.removeOnColorsChangedListener(callback, this.mContext.getUserId());
    }

    private final void $$robo$$android_app_WallpaperManager$removeOnColorsChangedListener(OnColorsChangedListener callback, int userId) {
        sGlobals.removeOnColorsChangedListener(callback, userId);
    }

    private final WallpaperColors $$robo$$android_app_WallpaperManager$getWallpaperColors(int which) {
        return this.getWallpaperColors(which, this.mContext.getUserId());
    }

    private final WallpaperColors $$robo$$android_app_WallpaperManager$getWallpaperColors(int which, int userId) {
        return sGlobals.getWallpaperColors(which, userId);
    }

    private final ParcelFileDescriptor $$robo$$android_app_WallpaperManager$getWallpaperFile(int which, int userId) {
        if (which != 1 && which != 2) {
            throw new IllegalArgumentException("Must request exactly one kind of wallpaper");
        }
        if (sGlobals.mService == null) {
            Log.w(TAG, "WallpaperService not running");
            throw new RuntimeException(new DeadSystemException());
        }
        try {
            Bundle outParams = new Bundle();
            return sGlobals.mService.getWallpaper(this.mContext.getOpPackageName(), null, which, outParams, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (SecurityException e) {
            if (this.mContext.getApplicationInfo().targetSdkVersion <= 26) {
                Log.w(TAG, "No permission to access wallpaper, suppressing exception to avoid crashing legacy app.");
                return null;
            }
            throw e;
        }
    }

    private final void $$robo$$android_app_WallpaperManager$forgetLoadedWallpaper() {
        sGlobals.forgetLoadedWallpaper();
    }

    private final WallpaperInfo $$robo$$android_app_WallpaperManager$getWallpaperInfo() {
        try {
            if (sGlobals.mService == null) {
                Log.w(TAG, "WallpaperService not running");
                throw new RuntimeException(new DeadSystemException());
            }
            return sGlobals.mService.getWallpaperInfo(UserHandle.myUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_app_WallpaperManager$getWallpaperId(int which) {
        return this.getWallpaperIdForUser(which, this.mContext.getUserId());
    }

    private final int $$robo$$android_app_WallpaperManager$getWallpaperIdForUser(int which, int userId) {
        try {
            if (sGlobals.mService == null) {
                Log.w(TAG, "WallpaperService not running");
                throw new RuntimeException(new DeadSystemException());
            }
            return sGlobals.mService.getWallpaperIdForUser(which, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final Intent $$robo$$android_app_WallpaperManager$getCropAndSetWallpaperIntent(Uri imageUri) {
        if (imageUri == null) {
            throw new IllegalArgumentException("Image URI must not be null");
        }
        if (!"content".equals(imageUri.getScheme())) {
            throw new IllegalArgumentException("Image URI must be of the content scheme type");
        }
        PackageManager packageManager = this.mContext.getPackageManager();
        Intent cropAndSetWallpaperIntent = new Intent("android.service.wallpaper.CROP_AND_SET_WALLPAPER", imageUri);
        cropAndSetWallpaperIntent.addFlags(1);
        Intent homeIntent = new Intent("android.intent.action.MAIN").addCategory("android.intent.category.HOME");
        ResolveInfo resolvedHome = packageManager.resolveActivity(homeIntent, 65536);
        if (resolvedHome != null) {
            cropAndSetWallpaperIntent.setPackage(resolvedHome.activityInfo.packageName);
            List<ResolveInfo> cropAppList = packageManager.queryIntentActivities(cropAndSetWallpaperIntent, 0);
            if (cropAppList.size() > 0) {
                return cropAndSetWallpaperIntent;
            }
        }
        String cropperPackage = this.mContext.getString(17039690);
        cropAndSetWallpaperIntent.setPackage(cropperPackage);
        List<ResolveInfo> cropAppList = packageManager.queryIntentActivities(cropAndSetWallpaperIntent, 0);
        if (cropAppList.size() > 0) {
            return cropAndSetWallpaperIntent;
        }
        throw new IllegalArgumentException("Cannot use passed URI to set wallpaper; check that the type returned by ContentProvider matches image/*");
    }

    private final void $$robo$$android_app_WallpaperManager$setResource(int resid) throws IOException {
        this.setResource(resid, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_app_WallpaperManager$setResource(int resid, int which) throws IOException {
        Bundle result;
        block5: {
            if (sGlobals.mService == null) {
                Log.w(TAG, "WallpaperService not running");
                throw new RuntimeException(new DeadSystemException());
            }
            result = new Bundle();
            WallpaperSetCompletion completion = new WallpaperSetCompletion(this);
            try {
                Resources resources = this.mContext.getResources();
                ParcelFileDescriptor fd = sGlobals.mService.setWallpaper("res:" + resources.getResourceName(resid), this.mContext.getOpPackageName(), null, false, result, which, completion, UserHandle.myUserId());
                if (fd == null) break block5;
                ParcelFileDescriptor.AutoCloseOutputStream fos = null;
                boolean ok = false;
                try {
                    fos = new ParcelFileDescriptor.AutoCloseOutputStream(fd);
                    this.copyStreamToWallpaperFile(resources.openRawResource(resid), fos);
                    ((FileOutputStream)fos).close();
                    completion.waitForCompletion();
                }
                catch (Throwable throwable) {
                    IoUtils.closeQuietly(fos);
                    throw throwable;
                }
                IoUtils.closeQuietly(fos);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return result.getInt("android.service.wallpaper.extra.ID", 0);
    }

    private final void $$robo$$android_app_WallpaperManager$setBitmap(Bitmap bitmap) throws IOException {
        this.setBitmap(bitmap, null, true);
    }

    private final int $$robo$$android_app_WallpaperManager$setBitmap(Bitmap fullImage, Rect visibleCropHint, boolean allowBackup) throws IOException {
        return this.setBitmap(fullImage, visibleCropHint, allowBackup, 3);
    }

    private final int $$robo$$android_app_WallpaperManager$setBitmap(Bitmap fullImage, Rect visibleCropHint, boolean allowBackup, int which) throws IOException {
        return this.setBitmap(fullImage, visibleCropHint, allowBackup, which, UserHandle.myUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_app_WallpaperManager$setBitmap(Bitmap fullImage, Rect visibleCropHint, boolean allowBackup, int which, int userId) throws IOException {
        Bundle result;
        block5: {
            this.validateRect(visibleCropHint);
            if (sGlobals.mService == null) {
                Log.w(TAG, "WallpaperService not running");
                throw new RuntimeException(new DeadSystemException());
            }
            result = new Bundle();
            WallpaperSetCompletion completion = new WallpaperSetCompletion(this);
            try {
                ParcelFileDescriptor fd = sGlobals.mService.setWallpaper(null, this.mContext.getOpPackageName(), visibleCropHint, allowBackup, result, which, completion, userId);
                if (fd == null) break block5;
                ParcelFileDescriptor.AutoCloseOutputStream fos = null;
                try {
                    fos = new ParcelFileDescriptor.AutoCloseOutputStream(fd);
                    fullImage.compress(Bitmap.CompressFormat.PNG, 90, fos);
                    ((FileOutputStream)fos).close();
                    completion.waitForCompletion();
                }
                catch (Throwable throwable) {
                    IoUtils.closeQuietly(fos);
                    throw throwable;
                }
                IoUtils.closeQuietly(fos);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return result.getInt("android.service.wallpaper.extra.ID", 0);
    }

    private final void $$robo$$android_app_WallpaperManager$validateRect(Rect rect) {
        if (rect != null && rect.isEmpty()) {
            throw new IllegalArgumentException("visibleCrop rectangle must be valid and non-empty");
        }
    }

    private final void $$robo$$android_app_WallpaperManager$setStream(InputStream bitmapData) throws IOException {
        this.setStream(bitmapData, null, true);
    }

    private final void $$robo$$android_app_WallpaperManager$copyStreamToWallpaperFile(InputStream data, FileOutputStream fos) throws IOException {
        int amt;
        byte[] buffer = new byte[32768];
        while ((amt = data.read(buffer)) > 0) {
            fos.write(buffer, 0, amt);
        }
    }

    private final int $$robo$$android_app_WallpaperManager$setStream(InputStream bitmapData, Rect visibleCropHint, boolean allowBackup) throws IOException {
        return this.setStream(bitmapData, visibleCropHint, allowBackup, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_app_WallpaperManager$setStream(InputStream bitmapData, Rect visibleCropHint, boolean allowBackup, int which) throws IOException {
        Bundle result;
        block5: {
            this.validateRect(visibleCropHint);
            if (sGlobals.mService == null) {
                Log.w(TAG, "WallpaperService not running");
                throw new RuntimeException(new DeadSystemException());
            }
            result = new Bundle();
            WallpaperSetCompletion completion = new WallpaperSetCompletion(this);
            try {
                ParcelFileDescriptor fd = sGlobals.mService.setWallpaper(null, this.mContext.getOpPackageName(), visibleCropHint, allowBackup, result, which, completion, UserHandle.myUserId());
                if (fd == null) break block5;
                ParcelFileDescriptor.AutoCloseOutputStream fos = null;
                try {
                    fos = new ParcelFileDescriptor.AutoCloseOutputStream(fd);
                    this.copyStreamToWallpaperFile(bitmapData, fos);
                    ((FileOutputStream)fos).close();
                    completion.waitForCompletion();
                }
                catch (Throwable throwable) {
                    IoUtils.closeQuietly(fos);
                    throw throwable;
                }
                IoUtils.closeQuietly(fos);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return result.getInt("android.service.wallpaper.extra.ID", 0);
    }

    private final boolean $$robo$$android_app_WallpaperManager$hasResourceWallpaper(int resid) {
        if (sGlobals.mService == null) {
            Log.w(TAG, "WallpaperService not running");
            throw new RuntimeException(new DeadSystemException());
        }
        try {
            Resources resources = this.mContext.getResources();
            String name = "res:" + resources.getResourceName(resid);
            return sGlobals.mService.hasNamedWallpaper(name);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_app_WallpaperManager$getDesiredMinimumWidth() {
        if (sGlobals.mService == null) {
            Log.w(TAG, "WallpaperService not running");
            throw new RuntimeException(new DeadSystemException());
        }
        try {
            return sGlobals.mService.getWidthHint();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_app_WallpaperManager$getDesiredMinimumHeight() {
        if (sGlobals.mService == null) {
            Log.w(TAG, "WallpaperService not running");
            throw new RuntimeException(new DeadSystemException());
        }
        try {
            return sGlobals.mService.getHeightHint();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_WallpaperManager$suggestDesiredDimensions(int minimumWidth, int minimumHeight) {
        try {
            int maximumTextureSize;
            try {
                maximumTextureSize = SystemProperties.getInt("sys.max_texture_size", 0);
            }
            catch (Exception e) {
                maximumTextureSize = 0;
            }
            if (maximumTextureSize > 0 && (minimumWidth > maximumTextureSize || minimumHeight > maximumTextureSize)) {
                float aspect = (float)minimumHeight / (float)minimumWidth;
                if (minimumWidth > minimumHeight) {
                    minimumWidth = maximumTextureSize;
                    minimumHeight = (int)((double)((float)minimumWidth * aspect) + 0.5);
                } else {
                    minimumHeight = maximumTextureSize;
                    minimumWidth = (int)((double)((float)minimumHeight / aspect) + 0.5);
                }
            }
            if (sGlobals.mService == null) {
                Log.w(TAG, "WallpaperService not running");
                throw new RuntimeException(new DeadSystemException());
            }
            sGlobals.mService.setDimensionHints(minimumWidth, minimumHeight, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_WallpaperManager$setDisplayPadding(Rect padding) {
        try {
            if (sGlobals.mService == null) {
                Log.w(TAG, "WallpaperService not running");
                throw new RuntimeException(new DeadSystemException());
            }
            sGlobals.mService.setDisplayPadding(padding, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_WallpaperManager$setDisplayOffset(IBinder windowToken, int x, int y) {
        try {
            WindowManagerGlobal.getWindowSession().setWallpaperDisplayOffset(windowToken, x, y);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_WallpaperManager$clearWallpaper() {
        this.clearWallpaper(2, this.mContext.getUserId());
        this.clearWallpaper(1, this.mContext.getUserId());
    }

    private final void $$robo$$android_app_WallpaperManager$clearWallpaper(int which, int userId) {
        if (sGlobals.mService == null) {
            Log.w(TAG, "WallpaperService not running");
            throw new RuntimeException(new DeadSystemException());
        }
        try {
            sGlobals.mService.clearWallpaper(this.mContext.getOpPackageName(), which, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_WallpaperManager$setWallpaperComponent(ComponentName name) {
        return this.setWallpaperComponent(name, UserHandle.myUserId());
    }

    private final boolean $$robo$$android_app_WallpaperManager$setWallpaperComponent(ComponentName name, int userId) {
        if (sGlobals.mService == null) {
            Log.w(TAG, "WallpaperService not running");
            throw new RuntimeException(new DeadSystemException());
        }
        try {
            sGlobals.mService.setWallpaperComponentChecked(name, this.mContext.getOpPackageName(), userId);
            return true;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_WallpaperManager$setWallpaperOffsets(IBinder windowToken, float xOffset, float yOffset) {
        try {
            WindowManagerGlobal.getWindowSession().setWallpaperPosition(windowToken, xOffset, yOffset, this.mWallpaperXStep, this.mWallpaperYStep);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_WallpaperManager$setWallpaperOffsetSteps(float xStep, float yStep) {
        this.mWallpaperXStep = xStep;
        this.mWallpaperYStep = yStep;
    }

    private final void $$robo$$android_app_WallpaperManager$sendWallpaperCommand(IBinder windowToken, String action, int x, int y, int z, Bundle extras) {
        try {
            WindowManagerGlobal.getWindowSession().sendWallpaperCommand(windowToken, action, x, y, z, extras, false);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_WallpaperManager$isWallpaperSupported() {
        if (sGlobals.mService == null) {
            Log.w(TAG, "WallpaperService not running");
            throw new RuntimeException(new DeadSystemException());
        }
        try {
            return sGlobals.mService.isWallpaperSupported(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_WallpaperManager$isSetWallpaperAllowed() {
        if (sGlobals.mService == null) {
            Log.w(TAG, "WallpaperService not running");
            throw new RuntimeException(new DeadSystemException());
        }
        try {
            return sGlobals.mService.isSetWallpaperAllowed(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_WallpaperManager$clearWallpaperOffsets(IBinder windowToken) {
        try {
            WindowManagerGlobal.getWindowSession().setWallpaperPosition(windowToken, -1.0f, -1.0f, -1.0f, -1.0f);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_WallpaperManager$clear() throws IOException {
        this.setStream(WallpaperManager.openDefaultWallpaper(this.mContext, 1), null, false);
    }

    private final void $$robo$$android_app_WallpaperManager$clear(int which) throws IOException {
        if ((which & 1) != 0) {
            this.clear();
        }
        if ((which & 2) != 0) {
            this.clearWallpaper(2, this.mContext.getUserId());
        }
    }

    private static final InputStream $$robo$$android_app_WallpaperManager$openDefaultWallpaper(Context context, int which) {
        File file;
        if (which == 2) {
            return null;
        }
        String whichProp = "ro.config.wallpaper";
        int defaultResId = 17302115;
        String path = SystemProperties.get(whichProp);
        if (!TextUtils.isEmpty(path) && (file = new File(path)).exists()) {
            try {
                return new FileInputStream(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            return context.getResources().openRawResource(defaultResId);
        }
        catch (Resources.NotFoundException notFoundException) {
            return null;
        }
    }

    private static final ComponentName $$robo$$android_app_WallpaperManager$getDefaultWallpaperComponent(Context context) {
        ComponentName cn;
        String flat = SystemProperties.get("ro.config.wallpaper_component");
        if (!TextUtils.isEmpty(flat) && (cn = ComponentName.unflattenFromString(flat)) != null) {
            return cn;
        }
        flat = context.getString(17039756);
        if (!TextUtils.isEmpty(flat) && (cn = ComponentName.unflattenFromString(flat)) != null) {
            return cn;
        }
        return null;
    }

    private final boolean $$robo$$android_app_WallpaperManager$setLockWallpaperCallback(IWallpaperManagerCallback callback) {
        if (sGlobals.mService == null) {
            Log.w(TAG, "WallpaperService not running");
            throw new RuntimeException(new DeadSystemException());
        }
        try {
            return sGlobals.mService.setLockWallpaperCallback(callback);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_WallpaperManager$isWallpaperBackupEligible(int which) {
        if (sGlobals.mService == null) {
            Log.w(TAG, "WallpaperService not running");
            throw new RuntimeException(new DeadSystemException());
        }
        try {
            return sGlobals.mService.isWallpaperBackupEligible(which, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            Log.e(TAG, "Exception querying wallpaper backup eligibility: " + e.getMessage());
            return false;
        }
    }

    static void __staticInitializer__() {
        TAG = "WallpaperManager";
        DEBUG = false;
        sSync = new Object[0];
    }

    static void initGlobals(Looper looper) {
        InvokeDynamicSupport.bootstrapStatic("initGlobals", $$robo$$android_app_WallpaperManager$initGlobals(android.os.Looper ), 0, (Looper)looper);
    }

    private void __constructor__(Context context, Handler handler) {
        this.$$robo$$android_app_WallpaperManager$__constructor__(context, handler);
    }

    WallpaperManager(Context context, Handler handler) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_WallpaperManager$__constructor__(android.content.Context android.os.Handler ), 0, this, context, handler);
    }

    public static WallpaperManager getInstance(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_app_WallpaperManager$getInstance(android.content.Context ), 0, (Context)context);
    }

    public IWallpaperManager getIWallpaperManager() {
        return InvokeDynamicSupport.bootstrap("getIWallpaperManager", $$robo$$android_app_WallpaperManager$getIWallpaperManager(), 0, this);
    }

    public Drawable getDrawable() {
        return InvokeDynamicSupport.bootstrap("getDrawable", $$robo$$android_app_WallpaperManager$getDrawable(), 0, this);
    }

    public Drawable getBuiltInDrawable() {
        return InvokeDynamicSupport.bootstrap("getBuiltInDrawable", $$robo$$android_app_WallpaperManager$getBuiltInDrawable(), 0, this);
    }

    public Drawable getBuiltInDrawable(int n) {
        return InvokeDynamicSupport.bootstrap("getBuiltInDrawable", $$robo$$android_app_WallpaperManager$getBuiltInDrawable(int ), 0, this, n);
    }

    public Drawable getBuiltInDrawable(int n, int n2, boolean bl, float f, float f2) {
        return InvokeDynamicSupport.bootstrap("getBuiltInDrawable", $$robo$$android_app_WallpaperManager$getBuiltInDrawable(int int boolean float float ), 0, this, n, n2, bl, f, f2);
    }

    public Drawable getBuiltInDrawable(int n, int n2, boolean bl, float f, float f2, int n3) {
        return InvokeDynamicSupport.bootstrap("getBuiltInDrawable", $$robo$$android_app_WallpaperManager$getBuiltInDrawable(int int boolean float float int ), 0, this, n, n2, bl, f, f2, n3);
    }

    private static RectF getMaxCropRect(int n, int n2, int n3, int n4, float f, float f2) {
        return InvokeDynamicSupport.bootstrapStatic("getMaxCropRect", $$robo$$android_app_WallpaperManager$getMaxCropRect(int int int int float float ), 0, (int)n, (int)n2, (int)n3, (int)n4, (float)f, (float)f2);
    }

    public Drawable peekDrawable() {
        return InvokeDynamicSupport.bootstrap("peekDrawable", $$robo$$android_app_WallpaperManager$peekDrawable(), 0, this);
    }

    public Drawable getFastDrawable() {
        return InvokeDynamicSupport.bootstrap("getFastDrawable", $$robo$$android_app_WallpaperManager$getFastDrawable(), 0, this);
    }

    public Drawable peekFastDrawable() {
        return InvokeDynamicSupport.bootstrap("peekFastDrawable", $$robo$$android_app_WallpaperManager$peekFastDrawable(), 0, this);
    }

    public Bitmap getBitmap() {
        return InvokeDynamicSupport.bootstrap("getBitmap", $$robo$$android_app_WallpaperManager$getBitmap(), 0, this);
    }

    public Bitmap getBitmapAsUser(int n) {
        return InvokeDynamicSupport.bootstrap("getBitmapAsUser", $$robo$$android_app_WallpaperManager$getBitmapAsUser(int ), 0, this, n);
    }

    public ParcelFileDescriptor getWallpaperFile(int n) {
        return InvokeDynamicSupport.bootstrap("getWallpaperFile", $$robo$$android_app_WallpaperManager$getWallpaperFile(int ), 0, this, n);
    }

    public void addOnColorsChangedListener(OnColorsChangedListener onColorsChangedListener, Handler handler) {
        InvokeDynamicSupport.bootstrap("addOnColorsChangedListener", $$robo$$android_app_WallpaperManager$addOnColorsChangedListener(android.app.WallpaperManager$OnColorsChangedListener android.os.Handler ), 0, this, onColorsChangedListener, handler);
    }

    public void addOnColorsChangedListener(OnColorsChangedListener onColorsChangedListener, Handler handler, int n) {
        InvokeDynamicSupport.bootstrap("addOnColorsChangedListener", $$robo$$android_app_WallpaperManager$addOnColorsChangedListener(android.app.WallpaperManager$OnColorsChangedListener android.os.Handler int ), 0, this, onColorsChangedListener, handler, n);
    }

    public void removeOnColorsChangedListener(OnColorsChangedListener onColorsChangedListener) {
        InvokeDynamicSupport.bootstrap("removeOnColorsChangedListener", $$robo$$android_app_WallpaperManager$removeOnColorsChangedListener(android.app.WallpaperManager$OnColorsChangedListener ), 0, this, onColorsChangedListener);
    }

    public void removeOnColorsChangedListener(OnColorsChangedListener onColorsChangedListener, int n) {
        InvokeDynamicSupport.bootstrap("removeOnColorsChangedListener", $$robo$$android_app_WallpaperManager$removeOnColorsChangedListener(android.app.WallpaperManager$OnColorsChangedListener int ), 0, this, onColorsChangedListener, n);
    }

    public WallpaperColors getWallpaperColors(int n) {
        return InvokeDynamicSupport.bootstrap("getWallpaperColors", $$robo$$android_app_WallpaperManager$getWallpaperColors(int ), 0, this, n);
    }

    public WallpaperColors getWallpaperColors(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getWallpaperColors", $$robo$$android_app_WallpaperManager$getWallpaperColors(int int ), 0, this, n, n2);
    }

    public ParcelFileDescriptor getWallpaperFile(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getWallpaperFile", $$robo$$android_app_WallpaperManager$getWallpaperFile(int int ), 0, this, n, n2);
    }

    public void forgetLoadedWallpaper() {
        InvokeDynamicSupport.bootstrap("forgetLoadedWallpaper", $$robo$$android_app_WallpaperManager$forgetLoadedWallpaper(), 0, this);
    }

    public WallpaperInfo getWallpaperInfo() {
        return InvokeDynamicSupport.bootstrap("getWallpaperInfo", $$robo$$android_app_WallpaperManager$getWallpaperInfo(), 0, this);
    }

    public int getWallpaperId(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getWallpaperId", $$robo$$android_app_WallpaperManager$getWallpaperId(int ), 0, this, n);
    }

    public int getWallpaperIdForUser(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("getWallpaperIdForUser", $$robo$$android_app_WallpaperManager$getWallpaperIdForUser(int int ), 0, this, n, n2);
    }

    public Intent getCropAndSetWallpaperIntent(Uri uri) {
        return InvokeDynamicSupport.bootstrap("getCropAndSetWallpaperIntent", $$robo$$android_app_WallpaperManager$getCropAndSetWallpaperIntent(android.net.Uri ), 0, this, uri);
    }

    public void setResource(int n) throws IOException {
        InvokeDynamicSupport.bootstrap("setResource", $$robo$$android_app_WallpaperManager$setResource(int ), 0, this, n);
    }

    public int setResource(int n, int n2) throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("setResource", $$robo$$android_app_WallpaperManager$setResource(int int ), 0, this, n, n2);
    }

    public void setBitmap(Bitmap bitmap) throws IOException {
        InvokeDynamicSupport.bootstrap("setBitmap", $$robo$$android_app_WallpaperManager$setBitmap(android.graphics.Bitmap ), 0, this, bitmap);
    }

    public int setBitmap(Bitmap bitmap, Rect rect, boolean bl) throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("setBitmap", $$robo$$android_app_WallpaperManager$setBitmap(android.graphics.Bitmap android.graphics.Rect boolean ), 0, this, bitmap, rect, bl);
    }

    public int setBitmap(Bitmap bitmap, Rect rect, boolean bl, int n) throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("setBitmap", $$robo$$android_app_WallpaperManager$setBitmap(android.graphics.Bitmap android.graphics.Rect boolean int ), 0, this, bitmap, rect, bl, n);
    }

    public int setBitmap(Bitmap bitmap, Rect rect, boolean bl, int n, int n2) throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("setBitmap", $$robo$$android_app_WallpaperManager$setBitmap(android.graphics.Bitmap android.graphics.Rect boolean int int ), 0, this, bitmap, rect, bl, n, n2);
    }

    private void validateRect(Rect rect) {
        InvokeDynamicSupport.bootstrap("validateRect", $$robo$$android_app_WallpaperManager$validateRect(android.graphics.Rect ), 0, this, rect);
    }

    public void setStream(InputStream inputStream) throws IOException {
        InvokeDynamicSupport.bootstrap("setStream", $$robo$$android_app_WallpaperManager$setStream(java.io.InputStream ), 0, this, inputStream);
    }

    private void copyStreamToWallpaperFile(InputStream inputStream, FileOutputStream fileOutputStream) throws IOException {
        InvokeDynamicSupport.bootstrap("copyStreamToWallpaperFile", $$robo$$android_app_WallpaperManager$copyStreamToWallpaperFile(java.io.InputStream java.io.FileOutputStream ), 0, this, inputStream, fileOutputStream);
    }

    public int setStream(InputStream inputStream, Rect rect, boolean bl) throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("setStream", $$robo$$android_app_WallpaperManager$setStream(java.io.InputStream android.graphics.Rect boolean ), 0, this, inputStream, rect, bl);
    }

    public int setStream(InputStream inputStream, Rect rect, boolean bl, int n) throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("setStream", $$robo$$android_app_WallpaperManager$setStream(java.io.InputStream android.graphics.Rect boolean int ), 0, this, inputStream, rect, bl, n);
    }

    public boolean hasResourceWallpaper(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasResourceWallpaper", $$robo$$android_app_WallpaperManager$hasResourceWallpaper(int ), 0, this, n);
    }

    public int getDesiredMinimumWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getDesiredMinimumWidth", $$robo$$android_app_WallpaperManager$getDesiredMinimumWidth(), 0, this);
    }

    public int getDesiredMinimumHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getDesiredMinimumHeight", $$robo$$android_app_WallpaperManager$getDesiredMinimumHeight(), 0, this);
    }

    public void suggestDesiredDimensions(int n, int n2) {
        InvokeDynamicSupport.bootstrap("suggestDesiredDimensions", $$robo$$android_app_WallpaperManager$suggestDesiredDimensions(int int ), 0, this, n, n2);
    }

    public void setDisplayPadding(Rect rect) {
        InvokeDynamicSupport.bootstrap("setDisplayPadding", $$robo$$android_app_WallpaperManager$setDisplayPadding(android.graphics.Rect ), 0, this, rect);
    }

    public void setDisplayOffset(IBinder iBinder, int n, int n2) {
        InvokeDynamicSupport.bootstrap("setDisplayOffset", $$robo$$android_app_WallpaperManager$setDisplayOffset(android.os.IBinder int int ), 0, this, iBinder, n, n2);
    }

    public void clearWallpaper() {
        InvokeDynamicSupport.bootstrap("clearWallpaper", $$robo$$android_app_WallpaperManager$clearWallpaper(), 0, this);
    }

    public void clearWallpaper(int n, int n2) {
        InvokeDynamicSupport.bootstrap("clearWallpaper", $$robo$$android_app_WallpaperManager$clearWallpaper(int int ), 0, this, n, n2);
    }

    public boolean setWallpaperComponent(ComponentName componentName) {
        return (boolean)InvokeDynamicSupport.bootstrap("setWallpaperComponent", $$robo$$android_app_WallpaperManager$setWallpaperComponent(android.content.ComponentName ), 0, this, componentName);
    }

    public boolean setWallpaperComponent(ComponentName componentName, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("setWallpaperComponent", $$robo$$android_app_WallpaperManager$setWallpaperComponent(android.content.ComponentName int ), 0, this, componentName, n);
    }

    public void setWallpaperOffsets(IBinder iBinder, float f, float f2) {
        InvokeDynamicSupport.bootstrap("setWallpaperOffsets", $$robo$$android_app_WallpaperManager$setWallpaperOffsets(android.os.IBinder float float ), 0, this, iBinder, f, f2);
    }

    public void setWallpaperOffsetSteps(float f, float f2) {
        InvokeDynamicSupport.bootstrap("setWallpaperOffsetSteps", $$robo$$android_app_WallpaperManager$setWallpaperOffsetSteps(float float ), 0, this, f, f2);
    }

    public void sendWallpaperCommand(IBinder iBinder, String string2, int n, int n2, int n3, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("sendWallpaperCommand", $$robo$$android_app_WallpaperManager$sendWallpaperCommand(android.os.IBinder java.lang.String int int int android.os.Bundle ), 0, this, iBinder, string2, n, n2, n3, bundle);
    }

    public boolean isWallpaperSupported() {
        return (boolean)InvokeDynamicSupport.bootstrap("isWallpaperSupported", $$robo$$android_app_WallpaperManager$isWallpaperSupported(), 0, this);
    }

    public boolean isSetWallpaperAllowed() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSetWallpaperAllowed", $$robo$$android_app_WallpaperManager$isSetWallpaperAllowed(), 0, this);
    }

    public void clearWallpaperOffsets(IBinder iBinder) {
        InvokeDynamicSupport.bootstrap("clearWallpaperOffsets", $$robo$$android_app_WallpaperManager$clearWallpaperOffsets(android.os.IBinder ), 0, this, iBinder);
    }

    public void clear() throws IOException {
        InvokeDynamicSupport.bootstrap("clear", $$robo$$android_app_WallpaperManager$clear(), 0, this);
    }

    public void clear(int n) throws IOException {
        InvokeDynamicSupport.bootstrap("clear", $$robo$$android_app_WallpaperManager$clear(int ), 0, this, n);
    }

    public static InputStream openDefaultWallpaper(Context context, int n) {
        return InvokeDynamicSupport.bootstrapStatic("openDefaultWallpaper", $$robo$$android_app_WallpaperManager$openDefaultWallpaper(android.content.Context int ), 0, (Context)context, (int)n);
    }

    public static ComponentName getDefaultWallpaperComponent(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getDefaultWallpaperComponent", $$robo$$android_app_WallpaperManager$getDefaultWallpaperComponent(android.content.Context ), 0, (Context)context);
    }

    public boolean setLockWallpaperCallback(IWallpaperManagerCallback iWallpaperManagerCallback) {
        return (boolean)InvokeDynamicSupport.bootstrap("setLockWallpaperCallback", $$robo$$android_app_WallpaperManager$setLockWallpaperCallback(android.app.IWallpaperManagerCallback ), 0, this, iWallpaperManagerCallback);
    }

    public boolean isWallpaperBackupEligible(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isWallpaperBackupEligible", $$robo$$android_app_WallpaperManager$isWallpaperBackupEligible(int ), 0, this, n);
    }

    static {
        RobolectricInternals.classInitializing(WallpaperManager.class);
    }

    public /* synthetic */ WallpaperManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WallpaperManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface OnColorsChangedListener
    extends InstrumentedInterface {
        public void onColorsChanged(WallpaperColors var1, int var2);

        default public void onColorsChanged(WallpaperColors colors, int which, int userId) {
            this.onColorsChanged(colors, which);
        }
    }

    private class WallpaperSetCompletion
    extends IWallpaperManagerCallback.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        CountDownLatch mLatch;
        /* synthetic */ WallpaperManager this$0;

        private void $$robo$$android_app_WallpaperManager_WallpaperSetCompletion$__constructor__(WallpaperManager wallpaperManager) {
            this.mLatch = new CountDownLatch(1);
        }

        private final void $$robo$$android_app_WallpaperManager_WallpaperSetCompletion$waitForCompletion() {
            try {
                this.mLatch.await(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        private final void $$robo$$android_app_WallpaperManager_WallpaperSetCompletion$onWallpaperChanged() throws RemoteException {
            this.mLatch.countDown();
        }

        private final void $$robo$$android_app_WallpaperManager_WallpaperSetCompletion$onWallpaperColorsChanged(WallpaperColors colors, int which, int userId) throws RemoteException {
            sGlobals.onWallpaperColorsChanged(colors, which, userId);
        }

        private void __constructor__(WallpaperManager wallpaperManager) {
            this.$$robo$$android_app_WallpaperManager_WallpaperSetCompletion$__constructor__(wallpaperManager);
        }

        public WallpaperSetCompletion(WallpaperManager wallpaperManager) {
            this.this$0 = wallpaperManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_WallpaperManager_WallpaperSetCompletion$__constructor__(android.app.WallpaperManager ), 0, this, wallpaperManager);
        }

        public void waitForCompletion() {
            InvokeDynamicSupport.bootstrap("waitForCompletion", $$robo$$android_app_WallpaperManager_WallpaperSetCompletion$waitForCompletion(), 0, this);
        }

        @Override
        public void onWallpaperChanged() throws RemoteException {
            InvokeDynamicSupport.bootstrap("onWallpaperChanged", $$robo$$android_app_WallpaperManager_WallpaperSetCompletion$onWallpaperChanged(), 0, this);
        }

        @Override
        public void onWallpaperColorsChanged(WallpaperColors wallpaperColors, int n, int n2) throws RemoteException {
            InvokeDynamicSupport.bootstrap("onWallpaperColorsChanged", $$robo$$android_app_WallpaperManager_WallpaperSetCompletion$onWallpaperColorsChanged(android.app.WallpaperColors int int ), 0, this, wallpaperColors, n, n2);
        }

        public /* synthetic */ WallpaperSetCompletion() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WallpaperSetCompletion)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class Globals
    extends IWallpaperManagerCallback.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private IWallpaperManager mService;
        private boolean mColorCallbackRegistered;
        private ArrayList<Pair<OnColorsChangedListener, Handler>> mColorListeners;
        private Bitmap mCachedWallpaper;
        private int mCachedWallpaperUserId;
        private Bitmap mDefaultWallpaper;
        private Handler mMainLooperHandler;

        private void $$robo$$android_app_WallpaperManager_Globals$__constructor__(Looper looper) {
            this.mColorListeners = new ArrayList();
            IBinder b = ServiceManager.getService("wallpaper");
            this.mService = IWallpaperManager.Stub.asInterface(b);
            this.mMainLooperHandler = new Handler(looper);
            this.forgetLoadedWallpaper();
        }

        private final void $$robo$$android_app_WallpaperManager_Globals$onWallpaperChanged() {
            this.forgetLoadedWallpaper();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_app_WallpaperManager_Globals$addOnColorsChangedListener(OnColorsChangedListener callback, Handler handler, int userId) {
            Globals globals = this;
            synchronized (globals) {
                if (!this.mColorCallbackRegistered) {
                    try {
                        this.mService.registerWallpaperColorsCallback(this, userId);
                        this.mColorCallbackRegistered = true;
                    }
                    catch (RemoteException e) {
                        Log.w(TAG, "Can't register for color updates", e);
                    }
                }
                this.mColorListeners.add(new Pair<OnColorsChangedListener, Handler>(callback, handler));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_app_WallpaperManager_Globals$removeOnColorsChangedListener(OnColorsChangedListener callback, int userId) {
            Globals globals = this;
            synchronized (globals) {
                this.mColorListeners.removeIf(pair -> pair.first == callback);
                if (this.mColorListeners.size() == 0 && this.mColorCallbackRegistered) {
                    this.mColorCallbackRegistered = false;
                    try {
                        this.mService.unregisterWallpaperColorsCallback(this, userId);
                    }
                    catch (RemoteException e) {
                        Log.w(TAG, "Can't unregister color updates", e);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_app_WallpaperManager_Globals$onWallpaperColorsChanged(WallpaperColors colors, int which, int userId) {
            Globals globals = this;
            synchronized (globals) {
                for (Pair<OnColorsChangedListener, Handler> listener : this.mColorListeners) {
                    Handler handler = (Handler)listener.second;
                    if (listener.second == null) {
                        handler = this.mMainLooperHandler;
                    }
                    handler.post(() -> {
                        boolean stillExists;
                        Globals globals = sGlobals;
                        synchronized (globals) {
                            stillExists = this.mColorListeners.contains(listener);
                        }
                        if (stillExists) {
                            ((OnColorsChangedListener)pair.first).onColorsChanged(colors, which, userId);
                        }
                    });
                }
            }
        }

        private final WallpaperColors $$robo$$android_app_WallpaperManager_Globals$getWallpaperColors(int which, int userId) {
            if (which != 2 && which != 1) {
                throw new IllegalArgumentException("Must request colors for exactly one kind of wallpaper");
            }
            try {
                return this.mService.getWallpaperColors(which, userId);
            }
            catch (RemoteException remoteException) {
                return null;
            }
        }

        private final Bitmap $$robo$$android_app_WallpaperManager_Globals$peekWallpaperBitmap(Context context, boolean returnDefault, int which) {
            return this.peekWallpaperBitmap(context, returnDefault, which, context.getUserId());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final Bitmap $$robo$$android_app_WallpaperManager_Globals$peekWallpaperBitmap(Context context, boolean returnDefault, int which, int userId) {
            if (this.mService != null) {
                try {
                    if (!this.mService.isWallpaperSupported(context.getOpPackageName())) {
                        return null;
                    }
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
            Globals e = this;
            synchronized (e) {
                if (this.mCachedWallpaper != null && this.mCachedWallpaperUserId == userId) {
                    return this.mCachedWallpaper;
                }
                this.mCachedWallpaper = null;
                this.mCachedWallpaperUserId = 0;
                try {
                    this.mCachedWallpaper = this.getCurrentWallpaperLocked(context, userId);
                    this.mCachedWallpaperUserId = userId;
                }
                catch (OutOfMemoryError e2) {
                    Log.w(TAG, "Out of memory loading the current wallpaper: " + e2);
                }
                catch (SecurityException e3) {
                    if (context.getApplicationInfo().targetSdkVersion <= 26) {
                        Log.w(TAG, "No permission to access wallpaper, suppressing exception to avoid crashing legacy app.");
                    }
                    throw e3;
                }
                if (this.mCachedWallpaper != null) {
                    return this.mCachedWallpaper;
                }
            }
            if (returnDefault) {
                Bitmap defaultWallpaper = this.mDefaultWallpaper;
                if (defaultWallpaper == null) {
                    defaultWallpaper = this.getDefaultWallpaper(context, which);
                    Globals globals = this;
                    synchronized (globals) {
                        this.mDefaultWallpaper = defaultWallpaper;
                    }
                }
                return defaultWallpaper;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_app_WallpaperManager_Globals$forgetLoadedWallpaper() {
            Globals globals = this;
            synchronized (globals) {
                this.mCachedWallpaper = null;
                this.mCachedWallpaperUserId = 0;
                this.mDefaultWallpaper = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private final Bitmap $$robo$$android_app_WallpaperManager_Globals$getCurrentWallpaperLocked(Context context, int userId) {
            if (this.mService == null) {
                Log.w(TAG, "WallpaperService not running");
                return null;
            }
            try {
                Bundle params = new Bundle();
                ParcelFileDescriptor fd = this.mService.getWallpaper(context.getOpPackageName(), this, 1, params, userId);
                if (fd == null) return null;
                try {
                    BitmapFactory.Options options = new BitmapFactory.Options();
                    Bitmap bitmap = BitmapFactory.decodeFileDescriptor(fd.getFileDescriptor(), null, options);
                    return bitmap;
                }
                catch (OutOfMemoryError e) {
                    Log.w(TAG, "Can't decode file", e);
                    return null;
                }
                finally {
                    IoUtils.closeQuietly(fd);
                }
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final Bitmap $$robo$$android_app_WallpaperManager_Globals$getDefaultWallpaper(Context context, int which) {
            InputStream is = WallpaperManager.openDefaultWallpaper(context, which);
            if (is != null) {
                try {
                    BitmapFactory.Options options = new BitmapFactory.Options();
                    Bitmap bitmap = BitmapFactory.decodeStream(is, null, options);
                    return bitmap;
                }
                catch (OutOfMemoryError e) {
                    Log.w(TAG, "Can't decode stream", e);
                }
                finally {
                    IoUtils.closeQuietly(is);
                }
            }
            return null;
        }

        private void __constructor__(Looper looper) {
            this.$$robo$$android_app_WallpaperManager_Globals$__constructor__(looper);
        }

        Globals(Looper looper) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_WallpaperManager_Globals$__constructor__(android.os.Looper ), 0, this, looper);
        }

        @Override
        public void onWallpaperChanged() {
            InvokeDynamicSupport.bootstrap("onWallpaperChanged", $$robo$$android_app_WallpaperManager_Globals$onWallpaperChanged(), 0, this);
        }

        public void addOnColorsChangedListener(OnColorsChangedListener onColorsChangedListener, Handler handler, int n) {
            InvokeDynamicSupport.bootstrap("addOnColorsChangedListener", $$robo$$android_app_WallpaperManager_Globals$addOnColorsChangedListener(android.app.WallpaperManager$OnColorsChangedListener android.os.Handler int ), 0, this, onColorsChangedListener, handler, n);
        }

        public void removeOnColorsChangedListener(OnColorsChangedListener onColorsChangedListener, int n) {
            InvokeDynamicSupport.bootstrap("removeOnColorsChangedListener", $$robo$$android_app_WallpaperManager_Globals$removeOnColorsChangedListener(android.app.WallpaperManager$OnColorsChangedListener int ), 0, this, onColorsChangedListener, n);
        }

        @Override
        public void onWallpaperColorsChanged(WallpaperColors wallpaperColors, int n, int n2) {
            InvokeDynamicSupport.bootstrap("onWallpaperColorsChanged", $$robo$$android_app_WallpaperManager_Globals$onWallpaperColorsChanged(android.app.WallpaperColors int int ), 0, this, wallpaperColors, n, n2);
        }

        WallpaperColors getWallpaperColors(int n, int n2) {
            return InvokeDynamicSupport.bootstrap("getWallpaperColors", $$robo$$android_app_WallpaperManager_Globals$getWallpaperColors(int int ), 0, this, n, n2);
        }

        public Bitmap peekWallpaperBitmap(Context context, boolean bl, int n) {
            return InvokeDynamicSupport.bootstrap("peekWallpaperBitmap", $$robo$$android_app_WallpaperManager_Globals$peekWallpaperBitmap(android.content.Context boolean int ), 0, this, context, bl, n);
        }

        public Bitmap peekWallpaperBitmap(Context context, boolean bl, int n, int n2) {
            return InvokeDynamicSupport.bootstrap("peekWallpaperBitmap", $$robo$$android_app_WallpaperManager_Globals$peekWallpaperBitmap(android.content.Context boolean int int ), 0, this, context, bl, n, n2);
        }

        void forgetLoadedWallpaper() {
            InvokeDynamicSupport.bootstrap("forgetLoadedWallpaper", $$robo$$android_app_WallpaperManager_Globals$forgetLoadedWallpaper(), 0, this);
        }

        private Bitmap getCurrentWallpaperLocked(Context context, int n) {
            return InvokeDynamicSupport.bootstrap("getCurrentWallpaperLocked", $$robo$$android_app_WallpaperManager_Globals$getCurrentWallpaperLocked(android.content.Context int ), 0, this, context, n);
        }

        private Bitmap getDefaultWallpaper(Context context, int n) {
            return InvokeDynamicSupport.bootstrap("getDefaultWallpaper", $$robo$$android_app_WallpaperManager_Globals$getDefaultWallpaper(android.content.Context int ), 0, this, context, n);
        }

        public /* synthetic */ Globals() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Globals)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class FastBitmapDrawable
    extends Drawable
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Bitmap mBitmap;
        private int mWidth;
        private int mHeight;
        private int mDrawLeft;
        private int mDrawTop;
        private Paint mPaint;

        private void $$robo$$android_app_WallpaperManager_FastBitmapDrawable$__constructor__(Bitmap bitmap) {
            this.mBitmap = bitmap;
            this.mWidth = bitmap.getWidth();
            this.mHeight = bitmap.getHeight();
            this.setBounds(0, 0, this.mWidth, this.mHeight);
            this.mPaint = new Paint();
            this.mPaint.setXfermode(new PorterDuffXfermode(PorterDuff.Mode.SRC));
        }

        private final void $$robo$$android_app_WallpaperManager_FastBitmapDrawable$draw(Canvas canvas) {
            canvas.drawBitmap(this.mBitmap, this.mDrawLeft, this.mDrawTop, this.mPaint);
        }

        private final int $$robo$$android_app_WallpaperManager_FastBitmapDrawable$getOpacity() {
            return -1;
        }

        private final void $$robo$$android_app_WallpaperManager_FastBitmapDrawable$setBounds(int left, int top, int right, int bottom) {
            this.mDrawLeft = left + (right - left - this.mWidth) / 2;
            this.mDrawTop = top + (bottom - top - this.mHeight) / 2;
        }

        private final void $$robo$$android_app_WallpaperManager_FastBitmapDrawable$setAlpha(int alpha) {
            throw new UnsupportedOperationException("Not supported with this drawable");
        }

        private final void $$robo$$android_app_WallpaperManager_FastBitmapDrawable$setColorFilter(ColorFilter colorFilter) {
            throw new UnsupportedOperationException("Not supported with this drawable");
        }

        private final void $$robo$$android_app_WallpaperManager_FastBitmapDrawable$setDither(boolean dither) {
            throw new UnsupportedOperationException("Not supported with this drawable");
        }

        private final void $$robo$$android_app_WallpaperManager_FastBitmapDrawable$setFilterBitmap(boolean filter) {
            throw new UnsupportedOperationException("Not supported with this drawable");
        }

        private final int $$robo$$android_app_WallpaperManager_FastBitmapDrawable$getIntrinsicWidth() {
            return this.mWidth;
        }

        private final int $$robo$$android_app_WallpaperManager_FastBitmapDrawable$getIntrinsicHeight() {
            return this.mHeight;
        }

        private final int $$robo$$android_app_WallpaperManager_FastBitmapDrawable$getMinimumWidth() {
            return this.mWidth;
        }

        private final int $$robo$$android_app_WallpaperManager_FastBitmapDrawable$getMinimumHeight() {
            return this.mHeight;
        }

        private /* synthetic */ void $$robo$$android_app_WallpaperManager_FastBitmapDrawable$__constructor__(Bitmap x0, 1 x1) {
        }

        private void __constructor__(Bitmap bitmap) {
            this.$$robo$$android_app_WallpaperManager_FastBitmapDrawable$__constructor__(bitmap);
        }

        private FastBitmapDrawable(Bitmap bitmap) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_WallpaperManager_FastBitmapDrawable$__constructor__(android.graphics.Bitmap ), 0, this, bitmap);
        }

        @Override
        public void draw(Canvas canvas) {
            InvokeDynamicSupport.bootstrap("draw", $$robo$$android_app_WallpaperManager_FastBitmapDrawable$draw(android.graphics.Canvas ), 0, this, canvas);
        }

        @Override
        public int getOpacity() {
            return (int)InvokeDynamicSupport.bootstrap("getOpacity", $$robo$$android_app_WallpaperManager_FastBitmapDrawable$getOpacity(), 0, this);
        }

        @Override
        public void setBounds(int n, int n2, int n3, int n4) {
            InvokeDynamicSupport.bootstrap("setBounds", $$robo$$android_app_WallpaperManager_FastBitmapDrawable$setBounds(int int int int ), 0, this, n, n2, n3, n4);
        }

        @Override
        public void setAlpha(int n) {
            InvokeDynamicSupport.bootstrap("setAlpha", $$robo$$android_app_WallpaperManager_FastBitmapDrawable$setAlpha(int ), 0, this, n);
        }

        @Override
        public void setColorFilter(ColorFilter colorFilter) {
            InvokeDynamicSupport.bootstrap("setColorFilter", $$robo$$android_app_WallpaperManager_FastBitmapDrawable$setColorFilter(android.graphics.ColorFilter ), 0, this, colorFilter);
        }

        @Override
        public void setDither(boolean bl) {
            InvokeDynamicSupport.bootstrap("setDither", $$robo$$android_app_WallpaperManager_FastBitmapDrawable$setDither(boolean ), 0, this, bl);
        }

        @Override
        public void setFilterBitmap(boolean bl) {
            InvokeDynamicSupport.bootstrap("setFilterBitmap", $$robo$$android_app_WallpaperManager_FastBitmapDrawable$setFilterBitmap(boolean ), 0, this, bl);
        }

        @Override
        public int getIntrinsicWidth() {
            return (int)InvokeDynamicSupport.bootstrap("getIntrinsicWidth", $$robo$$android_app_WallpaperManager_FastBitmapDrawable$getIntrinsicWidth(), 0, this);
        }

        @Override
        public int getIntrinsicHeight() {
            return (int)InvokeDynamicSupport.bootstrap("getIntrinsicHeight", $$robo$$android_app_WallpaperManager_FastBitmapDrawable$getIntrinsicHeight(), 0, this);
        }

        @Override
        public int getMinimumWidth() {
            return (int)InvokeDynamicSupport.bootstrap("getMinimumWidth", $$robo$$android_app_WallpaperManager_FastBitmapDrawable$getMinimumWidth(), 0, this);
        }

        @Override
        public int getMinimumHeight() {
            return (int)InvokeDynamicSupport.bootstrap("getMinimumHeight", $$robo$$android_app_WallpaperManager_FastBitmapDrawable$getMinimumHeight(), 0, this);
        }

        private /* synthetic */ void __constructor__(Bitmap bitmap, 1 var2_2) {
            this.$$robo$$android_app_WallpaperManager_FastBitmapDrawable$__constructor__(bitmap, var2_2);
        }

        public /* synthetic */ FastBitmapDrawable() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FastBitmapDrawable)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SetWallpaperFlags {
    }
}

