/*
 * Decompiled with CFR 0.152.
 */
package android.app.job;

import android.app.Service;
import android.app.job.IJobCallback;
import android.app.job.IJobService;
import android.app.job.JobParameters;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.ref.WeakReference;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class JobServiceEngine
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "JobServiceEngine";
    private static int MSG_EXECUTE_JOB = 0;
    private static int MSG_STOP_JOB = 1;
    private static int MSG_JOB_FINISHED = 2;
    private IJobService mBinder;
    JobHandler mHandler;

    private void $$robo$$android_app_job_JobServiceEngine$__constructor__(Service service) {
        this.mBinder = new JobInterface(this);
        this.mHandler = new JobHandler(this, service.getMainLooper());
    }

    private final IBinder $$robo$$android_app_job_JobServiceEngine$getBinder() {
        return this.mBinder.asBinder();
    }

    public abstract boolean onStartJob(JobParameters var1);

    public abstract boolean onStopJob(JobParameters var1);

    private final void $$robo$$android_app_job_JobServiceEngine$jobFinished(JobParameters params, boolean needsReschedule) {
        if (params == null) {
            throw new NullPointerException("params");
        }
        Message m = Message.obtain(this.mHandler, 2, params);
        m.arg2 = needsReschedule ? 1 : 0;
        m.sendToTarget();
    }

    private void __constructor__(Service service) {
        this.$$robo$$android_app_job_JobServiceEngine$__constructor__(service);
    }

    public JobServiceEngine(Service service) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_job_JobServiceEngine$__constructor__(android.app.Service ), 0, this, service);
    }

    public IBinder getBinder() {
        return InvokeDynamicSupport.bootstrap("getBinder", $$robo$$android_app_job_JobServiceEngine$getBinder(), 0, this);
    }

    public void jobFinished(JobParameters jobParameters, boolean bl) {
        InvokeDynamicSupport.bootstrap("jobFinished", $$robo$$android_app_job_JobServiceEngine$jobFinished(android.app.job.JobParameters boolean ), 0, this, jobParameters, bl);
    }

    public /* synthetic */ JobServiceEngine() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (JobServiceEngine)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class JobHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ JobServiceEngine this$0;

        private void $$robo$$android_app_job_JobServiceEngine_JobHandler$__constructor__(JobServiceEngine this$0, Looper looper) {
        }

        private final void $$robo$$android_app_job_JobServiceEngine_JobHandler$handleMessage(Message msg) {
            JobParameters params = (JobParameters)msg.obj;
            switch (msg.what) {
                case 0: {
                    try {
                        boolean workOngoing = this.this$0.onStartJob(params);
                        this.ackStartMessage(params, workOngoing);
                        break;
                    }
                    catch (Exception e) {
                        Log.e("JobServiceEngine", "Error while executing job: " + params.getJobId());
                        throw new RuntimeException(e);
                    }
                }
                case 1: {
                    try {
                        boolean ret = this.this$0.onStopJob(params);
                        this.ackStopMessage(params, ret);
                        break;
                    }
                    catch (Exception e) {
                        Log.e("JobServiceEngine", "Application unable to handle onStopJob.", e);
                        throw new RuntimeException(e);
                    }
                }
                case 2: {
                    boolean needsReschedule = msg.arg2 == 1;
                    IJobCallback callback = params.getCallback();
                    if (callback != null) {
                        try {
                            callback.jobFinished(params.getJobId(), needsReschedule);
                        }
                        catch (RemoteException e) {
                            Log.e("JobServiceEngine", "Error reporting job finish to system: binder has goneaway.");
                        }
                        break;
                    }
                    Log.e("JobServiceEngine", "finishJob() called for a nonexistent job id.");
                    break;
                }
                default: {
                    Log.e("JobServiceEngine", "Unrecognised message received.");
                }
            }
        }

        private final void $$robo$$android_app_job_JobServiceEngine_JobHandler$ackStartMessage(JobParameters params, boolean workOngoing) {
            IJobCallback callback = params.getCallback();
            int jobId = params.getJobId();
            if (callback != null) {
                try {
                    callback.acknowledgeStartMessage(jobId, workOngoing);
                }
                catch (RemoteException e) {
                    Log.e("JobServiceEngine", "System unreachable for starting job.");
                }
            } else if (Log.isLoggable("JobServiceEngine", 3)) {
                Log.d("JobServiceEngine", "Attempting to ack a job that has already been processed.");
            }
        }

        private final void $$robo$$android_app_job_JobServiceEngine_JobHandler$ackStopMessage(JobParameters params, boolean reschedule) {
            IJobCallback callback = params.getCallback();
            int jobId = params.getJobId();
            if (callback != null) {
                try {
                    callback.acknowledgeStopMessage(jobId, reschedule);
                }
                catch (RemoteException e) {
                    Log.e("JobServiceEngine", "System unreachable for stopping job.");
                }
            } else if (Log.isLoggable("JobServiceEngine", 3)) {
                Log.d("JobServiceEngine", "Attempting to ack a job that has already been processed.");
            }
        }

        private void __constructor__(JobServiceEngine jobServiceEngine, Looper looper) {
            this.$$robo$$android_app_job_JobServiceEngine_JobHandler$__constructor__(jobServiceEngine, looper);
        }

        JobHandler(JobServiceEngine jobServiceEngine, Looper looper) {
            this.this$0 = jobServiceEngine;
            super(looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_job_JobServiceEngine_JobHandler$__constructor__(android.app.job.JobServiceEngine android.os.Looper ), 0, this, jobServiceEngine, looper);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_app_job_JobServiceEngine_JobHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        private void ackStartMessage(JobParameters jobParameters, boolean bl) {
            InvokeDynamicSupport.bootstrap("ackStartMessage", $$robo$$android_app_job_JobServiceEngine_JobHandler$ackStartMessage(android.app.job.JobParameters boolean ), 0, this, jobParameters, bl);
        }

        private void ackStopMessage(JobParameters jobParameters, boolean bl) {
            InvokeDynamicSupport.bootstrap("ackStopMessage", $$robo$$android_app_job_JobServiceEngine_JobHandler$ackStopMessage(android.app.job.JobParameters boolean ), 0, this, jobParameters, bl);
        }

        public /* synthetic */ JobHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (JobHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class JobInterface
    extends IJobService.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        WeakReference<JobServiceEngine> mService;

        private void $$robo$$android_app_job_JobServiceEngine_JobInterface$__constructor__(JobServiceEngine service) {
            this.mService = new WeakReference<JobServiceEngine>(service);
        }

        private final void $$robo$$android_app_job_JobServiceEngine_JobInterface$startJob(JobParameters jobParams) throws RemoteException {
            JobServiceEngine service = (JobServiceEngine)this.mService.get();
            if (service != null) {
                Message m = Message.obtain(service.mHandler, 0, jobParams);
                m.sendToTarget();
            }
        }

        private final void $$robo$$android_app_job_JobServiceEngine_JobInterface$stopJob(JobParameters jobParams) throws RemoteException {
            JobServiceEngine service = (JobServiceEngine)this.mService.get();
            if (service != null) {
                Message m = Message.obtain(service.mHandler, 1, jobParams);
                m.sendToTarget();
            }
        }

        private void __constructor__(JobServiceEngine jobServiceEngine) {
            this.$$robo$$android_app_job_JobServiceEngine_JobInterface$__constructor__(jobServiceEngine);
        }

        JobInterface(JobServiceEngine jobServiceEngine) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_job_JobServiceEngine_JobInterface$__constructor__(android.app.job.JobServiceEngine ), 0, this, jobServiceEngine);
        }

        @Override
        public void startJob(JobParameters jobParameters) throws RemoteException {
            InvokeDynamicSupport.bootstrap("startJob", $$robo$$android_app_job_JobServiceEngine_JobInterface$startJob(android.app.job.JobParameters ), 0, this, jobParameters);
        }

        @Override
        public void stopJob(JobParameters jobParameters) throws RemoteException {
            InvokeDynamicSupport.bootstrap("stopJob", $$robo$$android_app_job_JobServiceEngine_JobInterface$stopJob(android.app.job.JobParameters ), 0, this, jobParameters);
        }

        public /* synthetic */ JobInterface() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (JobInterface)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

