/*
 * Decompiled with CFR 0.152.
 */
package android.app.timezone;

import android.app.timezone.DistroFormatVersion;
import android.app.timezone.DistroRulesVersion;
import android.app.timezone.Utils;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class RulesState
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int STAGED_OPERATION_UNKNOWN = 0;
    public static int STAGED_OPERATION_NONE = 1;
    public static int STAGED_OPERATION_UNINSTALL = 2;
    public static int STAGED_OPERATION_INSTALL = 3;
    public static int DISTRO_STATUS_UNKNOWN = 0;
    public static int DISTRO_STATUS_NONE = 1;
    public static int DISTRO_STATUS_INSTALLED = 2;
    private static byte BYTE_FALSE = 0;
    private static byte BYTE_TRUE = 1;
    private String mSystemRulesVersion;
    private DistroFormatVersion mDistroFormatVersionSupported;
    private boolean mOperationInProgress;
    private int mStagedOperationType;
    private DistroRulesVersion mStagedDistroRulesVersion;
    private int mDistroStatus;
    private DistroRulesVersion mInstalledDistroRulesVersion;
    public static Parcelable.Creator<RulesState> CREATOR;

    private void $$robo$$android_app_timezone_RulesState$__constructor__(String systemRulesVersion, DistroFormatVersion distroFormatVersionSupported, boolean operationInProgress, int stagedOperationType, DistroRulesVersion stagedDistroRulesVersion, int distroStatus, DistroRulesVersion installedDistroRulesVersion) {
        this.mSystemRulesVersion = Utils.validateRulesVersion("systemRulesVersion", systemRulesVersion);
        this.mDistroFormatVersionSupported = Utils.validateNotNull("distroFormatVersionSupported", distroFormatVersionSupported);
        this.mOperationInProgress = operationInProgress;
        if (operationInProgress && stagedOperationType != 0) {
            throw new IllegalArgumentException("stagedOperationType != STAGED_OPERATION_UNKNOWN");
        }
        this.mStagedOperationType = RulesState.validateStagedOperation(stagedOperationType);
        this.mStagedDistroRulesVersion = Utils.validateConditionalNull(this.mStagedOperationType == 3, "stagedDistroRulesVersion", stagedDistroRulesVersion);
        if (operationInProgress && distroStatus != 0) {
            throw new IllegalArgumentException("distroInstalled != DISTRO_STATUS_UNKNOWN");
        }
        this.mDistroStatus = RulesState.validateDistroStatus(distroStatus);
        this.mInstalledDistroRulesVersion = Utils.validateConditionalNull(this.mDistroStatus == 2, "installedDistroRulesVersion", installedDistroRulesVersion);
    }

    private final String $$robo$$android_app_timezone_RulesState$getSystemRulesVersion() {
        return this.mSystemRulesVersion;
    }

    private final boolean $$robo$$android_app_timezone_RulesState$isOperationInProgress() {
        return this.mOperationInProgress;
    }

    private final int $$robo$$android_app_timezone_RulesState$getStagedOperationType() {
        return this.mStagedOperationType;
    }

    private final DistroRulesVersion $$robo$$android_app_timezone_RulesState$getStagedDistroRulesVersion() {
        return this.mStagedDistroRulesVersion;
    }

    private final int $$robo$$android_app_timezone_RulesState$getDistroStatus() {
        return this.mDistroStatus;
    }

    private final DistroRulesVersion $$robo$$android_app_timezone_RulesState$getInstalledDistroRulesVersion() {
        return this.mInstalledDistroRulesVersion;
    }

    private final boolean $$robo$$android_app_timezone_RulesState$isDistroFormatVersionSupported(DistroFormatVersion distroFormatVersion) {
        return this.mDistroFormatVersionSupported.supports(distroFormatVersion);
    }

    private final boolean $$robo$$android_app_timezone_RulesState$isSystemVersionNewerThan(DistroRulesVersion distroRulesVersion) {
        return this.mSystemRulesVersion.compareTo(distroRulesVersion.getRulesVersion()) > 0;
    }

    private static final RulesState $$robo$$android_app_timezone_RulesState$createFromParcel(Parcel in) {
        String systemRulesVersion = in.readString();
        DistroFormatVersion distroFormatVersionSupported = (DistroFormatVersion)in.readParcelable(null);
        boolean operationInProgress = in.readByte() == 1;
        byte distroStagedState = in.readByte();
        DistroRulesVersion stagedDistroRulesVersion = (DistroRulesVersion)in.readParcelable(null);
        byte installedDistroStatus = in.readByte();
        DistroRulesVersion installedDistroRulesVersion = (DistroRulesVersion)in.readParcelable(null);
        return new RulesState(systemRulesVersion, distroFormatVersionSupported, operationInProgress, distroStagedState, stagedDistroRulesVersion, installedDistroStatus, installedDistroRulesVersion);
    }

    private final int $$robo$$android_app_timezone_RulesState$describeContents() {
        return 0;
    }

    private final void $$robo$$android_app_timezone_RulesState$writeToParcel(Parcel out, int flags) {
        out.writeString(this.mSystemRulesVersion);
        out.writeParcelable(this.mDistroFormatVersionSupported, 0);
        out.writeByte(this.mOperationInProgress ? (byte)1 : 0);
        out.writeByte((byte)this.mStagedOperationType);
        out.writeParcelable(this.mStagedDistroRulesVersion, 0);
        out.writeByte((byte)this.mDistroStatus);
        out.writeParcelable(this.mInstalledDistroRulesVersion, 0);
    }

    private final boolean $$robo$$android_app_timezone_RulesState$equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RulesState that = (RulesState)o;
        if (this.mOperationInProgress != that.mOperationInProgress) {
            return false;
        }
        if (this.mStagedOperationType != that.mStagedOperationType) {
            return false;
        }
        if (this.mDistroStatus != that.mDistroStatus) {
            return false;
        }
        if (!this.mSystemRulesVersion.equals(that.mSystemRulesVersion)) {
            return false;
        }
        if (!this.mDistroFormatVersionSupported.equals(that.mDistroFormatVersionSupported)) {
            return false;
        }
        if (this.mStagedDistroRulesVersion != null ? !this.mStagedDistroRulesVersion.equals(that.mStagedDistroRulesVersion) : that.mStagedDistroRulesVersion != null) {
            return false;
        }
        return this.mInstalledDistroRulesVersion != null ? this.mInstalledDistroRulesVersion.equals(that.mInstalledDistroRulesVersion) : that.mInstalledDistroRulesVersion == null;
    }

    private final int $$robo$$android_app_timezone_RulesState$hashCode() {
        int result = this.mSystemRulesVersion.hashCode();
        result = 31 * result + this.mDistroFormatVersionSupported.hashCode();
        result = 31 * result + (this.mOperationInProgress ? 1 : 0);
        result = 31 * result + this.mStagedOperationType;
        result = 31 * result + (this.mStagedDistroRulesVersion != null ? this.mStagedDistroRulesVersion.hashCode() : 0);
        result = 31 * result + this.mDistroStatus;
        result = 31 * result + (this.mInstalledDistroRulesVersion != null ? this.mInstalledDistroRulesVersion.hashCode() : 0);
        return result;
    }

    private final String $$robo$$android_app_timezone_RulesState$toString() {
        return "RulesState{mSystemRulesVersion='" + this.mSystemRulesVersion + '\'' + ", mDistroFormatVersionSupported=" + this.mDistroFormatVersionSupported + ", mOperationInProgress=" + this.mOperationInProgress + ", mStagedOperationType=" + this.mStagedOperationType + ", mStagedDistroRulesVersion=" + this.mStagedDistroRulesVersion + ", mDistroStatus=" + this.mDistroStatus + ", mInstalledDistroRulesVersion=" + this.mInstalledDistroRulesVersion + '}';
    }

    private static final int $$robo$$android_app_timezone_RulesState$validateStagedOperation(int stagedOperationType) {
        if (stagedOperationType < 0 || stagedOperationType > 3) {
            throw new IllegalArgumentException("Unknown operation type=" + stagedOperationType);
        }
        return stagedOperationType;
    }

    private static final int $$robo$$android_app_timezone_RulesState$validateDistroStatus(int distroStatus) {
        if (distroStatus < 0 || distroStatus > 2) {
            throw new IllegalArgumentException("Unknown distro status=" + distroStatus);
        }
        return distroStatus;
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<RulesState>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_app_timezone_RulesState_1$__constructor__() {
            }

            private final RulesState $$robo$$android_app_timezone_RulesState_1$createFromParcel(Parcel in) {
                return RulesState.createFromParcel(in);
            }

            private final RulesState[] $$robo$$android_app_timezone_RulesState_1$newArray(int size) {
                return new RulesState[size];
            }

            private void __constructor__() {
                this.$$robo$$android_app_timezone_RulesState_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_timezone_RulesState_1$__constructor__(), 0, this);
            }

            @Override
            public RulesState createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_app_timezone_RulesState_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public RulesState[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_app_timezone_RulesState_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(String string2, DistroFormatVersion distroFormatVersion, boolean bl, int n, DistroRulesVersion distroRulesVersion, int n2, DistroRulesVersion distroRulesVersion2) {
        this.$$robo$$android_app_timezone_RulesState$__constructor__(string2, distroFormatVersion, bl, n, distroRulesVersion, n2, distroRulesVersion2);
    }

    public RulesState(String string2, DistroFormatVersion distroFormatVersion, boolean bl, int n, DistroRulesVersion distroRulesVersion, int n2, DistroRulesVersion distroRulesVersion2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_timezone_RulesState$__constructor__(java.lang.String android.app.timezone.DistroFormatVersion boolean int android.app.timezone.DistroRulesVersion int android.app.timezone.DistroRulesVersion ), 0, this, string2, distroFormatVersion, bl, n, distroRulesVersion, n2, distroRulesVersion2);
    }

    public String getSystemRulesVersion() {
        return InvokeDynamicSupport.bootstrap("getSystemRulesVersion", $$robo$$android_app_timezone_RulesState$getSystemRulesVersion(), 0, this);
    }

    public boolean isOperationInProgress() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOperationInProgress", $$robo$$android_app_timezone_RulesState$isOperationInProgress(), 0, this);
    }

    public int getStagedOperationType() {
        return (int)InvokeDynamicSupport.bootstrap("getStagedOperationType", $$robo$$android_app_timezone_RulesState$getStagedOperationType(), 0, this);
    }

    public DistroRulesVersion getStagedDistroRulesVersion() {
        return InvokeDynamicSupport.bootstrap("getStagedDistroRulesVersion", $$robo$$android_app_timezone_RulesState$getStagedDistroRulesVersion(), 0, this);
    }

    public int getDistroStatus() {
        return (int)InvokeDynamicSupport.bootstrap("getDistroStatus", $$robo$$android_app_timezone_RulesState$getDistroStatus(), 0, this);
    }

    public DistroRulesVersion getInstalledDistroRulesVersion() {
        return InvokeDynamicSupport.bootstrap("getInstalledDistroRulesVersion", $$robo$$android_app_timezone_RulesState$getInstalledDistroRulesVersion(), 0, this);
    }

    public boolean isDistroFormatVersionSupported(DistroFormatVersion distroFormatVersion) {
        return (boolean)InvokeDynamicSupport.bootstrap("isDistroFormatVersionSupported", $$robo$$android_app_timezone_RulesState$isDistroFormatVersionSupported(android.app.timezone.DistroFormatVersion ), 0, this, distroFormatVersion);
    }

    public boolean isSystemVersionNewerThan(DistroRulesVersion distroRulesVersion) {
        return (boolean)InvokeDynamicSupport.bootstrap("isSystemVersionNewerThan", $$robo$$android_app_timezone_RulesState$isSystemVersionNewerThan(android.app.timezone.DistroRulesVersion ), 0, this, distroRulesVersion);
    }

    private static RulesState createFromParcel(Parcel parcel) {
        return InvokeDynamicSupport.bootstrapStatic("createFromParcel", $$robo$$android_app_timezone_RulesState$createFromParcel(android.os.Parcel ), 0, (Parcel)parcel);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_app_timezone_RulesState$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_app_timezone_RulesState$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_app_timezone_RulesState$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_app_timezone_RulesState$hashCode(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_app_timezone_RulesState$toString(), 0, this);
    }

    private static int validateStagedOperation(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("validateStagedOperation", $$robo$$android_app_timezone_RulesState$validateStagedOperation(int ), 0, (int)n);
    }

    private static int validateDistroStatus(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("validateDistroStatus", $$robo$$android_app_timezone_RulesState$validateDistroStatus(int ), 0, (int)n);
    }

    static {
        RobolectricInternals.classInitializing(RulesState.class);
    }

    public /* synthetic */ RulesState() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RulesState)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface DistroStatus {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface StagedOperationType {
    }
}

