/*
 * Decompiled with CFR 0.152.
 */
package android.app.usage;

import android.content.Context;
import android.net.INetworkStatsService;
import android.net.INetworkStatsSession;
import android.net.NetworkStats;
import android.net.NetworkStatsHistory;
import android.net.NetworkTemplate;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.IntArray;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import dalvik.system.CloseGuard;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class NetworkStats
implements AutoCloseable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "NetworkStats";
    private CloseGuard mCloseGuard;
    private long mStartTimeStamp;
    private long mEndTimeStamp;
    private int[] mUids;
    private int mUidOrUidIndex;
    private int mTag;
    private INetworkStatsSession mSession;
    private NetworkTemplate mTemplate;
    private android.net.NetworkStats mSummary;
    private NetworkStatsHistory mHistory;
    private int mEnumerationIndex;
    private NetworkStats.Entry mRecycledSummaryEntry;
    private NetworkStatsHistory.Entry mRecycledHistoryEntry;

    private void $$robo$$android_app_usage_NetworkStats$__constructor__(Context context, NetworkTemplate template, int flags, long startTimestamp, long endTimestamp) throws RemoteException, SecurityException {
        this.mCloseGuard = CloseGuard.get();
        this.mTag = 0;
        this.mSummary = null;
        this.mHistory = null;
        this.mEnumerationIndex = 0;
        this.mRecycledSummaryEntry = null;
        this.mRecycledHistoryEntry = null;
        INetworkStatsService statsService = INetworkStatsService.Stub.asInterface(ServiceManager.getService("netstats"));
        this.mSession = statsService.openSessionForUsageStats(flags, context.getOpPackageName());
        this.mCloseGuard.open("close");
        this.mTemplate = template;
        this.mStartTimeStamp = startTimestamp;
        this.mEndTimeStamp = endTimestamp;
    }

    private final void $$robo$$android_app_usage_NetworkStats$finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private final boolean $$robo$$android_app_usage_NetworkStats$getNextBucket(Bucket bucketOut) {
        if (this.mSummary != null) {
            return this.getNextSummaryBucket(bucketOut);
        }
        return this.getNextHistoryBucket(bucketOut);
    }

    private final boolean $$robo$$android_app_usage_NetworkStats$hasNextBucket() {
        if (this.mSummary != null) {
            return this.mEnumerationIndex < this.mSummary.size();
        }
        if (this.mHistory != null) {
            return this.mEnumerationIndex < this.mHistory.size() || this.hasNextUid();
        }
        return false;
    }

    private final void $$robo$$android_app_usage_NetworkStats$close() {
        if (this.mSession != null) {
            try {
                this.mSession.close();
            }
            catch (RemoteException e) {
                Log.w("NetworkStats", e);
            }
        }
        this.mSession = null;
        if (this.mCloseGuard != null) {
            this.mCloseGuard.close();
        }
    }

    private final Bucket $$robo$$android_app_usage_NetworkStats$getDeviceSummaryForNetwork() throws RemoteException {
        this.mSummary = this.mSession.getDeviceSummaryForNetwork(this.mTemplate, this.mStartTimeStamp, this.mEndTimeStamp);
        this.mEnumerationIndex = this.mSummary.size();
        return this.getSummaryAggregate();
    }

    private final void $$robo$$android_app_usage_NetworkStats$startSummaryEnumeration() throws RemoteException {
        this.mSummary = this.mSession.getSummaryForAllUid(this.mTemplate, this.mStartTimeStamp, this.mEndTimeStamp, false);
        this.mEnumerationIndex = 0;
    }

    private final void $$robo$$android_app_usage_NetworkStats$startHistoryEnumeration(int uid) {
        this.startHistoryEnumeration(uid, 0);
    }

    private final void $$robo$$android_app_usage_NetworkStats$startHistoryEnumeration(int uid, int tag) {
        this.mHistory = null;
        try {
            this.mHistory = this.mSession.getHistoryIntervalForUid(this.mTemplate, uid, -1, tag, -1, this.mStartTimeStamp, this.mEndTimeStamp);
            this.setSingleUidTag(uid, tag);
        }
        catch (RemoteException e) {
            Log.w("NetworkStats", e);
        }
        this.mEnumerationIndex = 0;
    }

    private final void $$robo$$android_app_usage_NetworkStats$startUserUidEnumeration() throws RemoteException {
        int[] uids = this.mSession.getRelevantUids();
        IntArray filteredUids = new IntArray(uids.length);
        for (int uid : uids) {
            try {
                NetworkStatsHistory history = this.mSession.getHistoryIntervalForUid(this.mTemplate, uid, -1, 0, -1, this.mStartTimeStamp, this.mEndTimeStamp);
                if (history == null || history.size() <= 0) continue;
                filteredUids.add(uid);
            }
            catch (RemoteException e) {
                Log.w("NetworkStats", "Error while getting history of uid " + uid, e);
            }
        }
        this.mUids = filteredUids.toArray();
        this.mUidOrUidIndex = -1;
        this.stepHistory();
    }

    private final void $$robo$$android_app_usage_NetworkStats$stepHistory() {
        if (this.hasNextUid()) {
            this.stepUid();
            this.mHistory = null;
            try {
                this.mHistory = this.mSession.getHistoryIntervalForUid(this.mTemplate, this.getUid(), -1, 0, -1, this.mStartTimeStamp, this.mEndTimeStamp);
            }
            catch (RemoteException e) {
                Log.w("NetworkStats", e);
            }
            this.mEnumerationIndex = 0;
        }
    }

    private final void $$robo$$android_app_usage_NetworkStats$fillBucketFromSummaryEntry(Bucket bucketOut) {
        bucketOut.mUid = Bucket.convertUid(this.mRecycledSummaryEntry.uid);
        bucketOut.mTag = Bucket.convertTag(this.mRecycledSummaryEntry.tag);
        bucketOut.mState = Bucket.convertState(this.mRecycledSummaryEntry.set);
        bucketOut.mMetered = Bucket.convertMetered(this.mRecycledSummaryEntry.metered);
        bucketOut.mRoaming = Bucket.convertRoaming(this.mRecycledSummaryEntry.roaming);
        bucketOut.mBeginTimeStamp = this.mStartTimeStamp;
        bucketOut.mEndTimeStamp = this.mEndTimeStamp;
        bucketOut.mRxBytes = this.mRecycledSummaryEntry.rxBytes;
        bucketOut.mRxPackets = this.mRecycledSummaryEntry.rxPackets;
        bucketOut.mTxBytes = this.mRecycledSummaryEntry.txBytes;
        bucketOut.mTxPackets = this.mRecycledSummaryEntry.txPackets;
    }

    private final boolean $$robo$$android_app_usage_NetworkStats$getNextSummaryBucket(Bucket bucketOut) {
        if (bucketOut != null && this.mEnumerationIndex < this.mSummary.size()) {
            this.mRecycledSummaryEntry = this.mSummary.getValues(this.mEnumerationIndex++, this.mRecycledSummaryEntry);
            this.fillBucketFromSummaryEntry(bucketOut);
            return true;
        }
        return false;
    }

    private final Bucket $$robo$$android_app_usage_NetworkStats$getSummaryAggregate() {
        if (this.mSummary == null) {
            return null;
        }
        Bucket bucket = new Bucket();
        if (this.mRecycledSummaryEntry == null) {
            this.mRecycledSummaryEntry = new NetworkStats.Entry();
        }
        this.mSummary.getTotal(this.mRecycledSummaryEntry);
        this.fillBucketFromSummaryEntry(bucket);
        return bucket;
    }

    private final boolean $$robo$$android_app_usage_NetworkStats$getNextHistoryBucket(Bucket bucketOut) {
        if (bucketOut != null && this.mHistory != null) {
            if (this.mEnumerationIndex < this.mHistory.size()) {
                this.mRecycledHistoryEntry = this.mHistory.getValues(this.mEnumerationIndex++, this.mRecycledHistoryEntry);
                bucketOut.mUid = Bucket.convertUid(this.getUid());
                bucketOut.mTag = Bucket.convertTag(this.mTag);
                bucketOut.mState = -1;
                bucketOut.mMetered = -1;
                bucketOut.mRoaming = -1;
                bucketOut.mBeginTimeStamp = this.mRecycledHistoryEntry.bucketStart;
                bucketOut.mEndTimeStamp = this.mRecycledHistoryEntry.bucketStart + this.mRecycledHistoryEntry.bucketDuration;
                bucketOut.mRxBytes = this.mRecycledHistoryEntry.rxBytes;
                bucketOut.mRxPackets = this.mRecycledHistoryEntry.rxPackets;
                bucketOut.mTxBytes = this.mRecycledHistoryEntry.txBytes;
                bucketOut.mTxPackets = this.mRecycledHistoryEntry.txPackets;
                return true;
            }
            if (this.hasNextUid()) {
                this.stepHistory();
                return this.getNextHistoryBucket(bucketOut);
            }
        }
        return false;
    }

    private final boolean $$robo$$android_app_usage_NetworkStats$isUidEnumeration() {
        return this.mUids != null;
    }

    private final boolean $$robo$$android_app_usage_NetworkStats$hasNextUid() {
        return this.isUidEnumeration() && this.mUidOrUidIndex + 1 < this.mUids.length;
    }

    private final int $$robo$$android_app_usage_NetworkStats$getUid() {
        if (this.isUidEnumeration()) {
            if (this.mUidOrUidIndex < 0 || this.mUidOrUidIndex >= this.mUids.length) {
                throw new IndexOutOfBoundsException("Index=" + this.mUidOrUidIndex + " mUids.length=" + this.mUids.length);
            }
            return this.mUids[this.mUidOrUidIndex];
        }
        return this.mUidOrUidIndex;
    }

    private final void $$robo$$android_app_usage_NetworkStats$setSingleUidTag(int uid, int tag) {
        this.mUidOrUidIndex = uid;
        this.mTag = tag;
    }

    private final void $$robo$$android_app_usage_NetworkStats$stepUid() {
        if (this.mUids != null) {
            ++this.mUidOrUidIndex;
        }
    }

    private void __constructor__(Context context, NetworkTemplate networkTemplate, int n, long l, long l2) throws RemoteException, SecurityException {
        this.$$robo$$android_app_usage_NetworkStats$__constructor__(context, networkTemplate, n, l, l2);
    }

    NetworkStats(Context context, NetworkTemplate networkTemplate, int n, long l, long l2) throws RemoteException, SecurityException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_usage_NetworkStats$__constructor__(android.content.Context android.net.NetworkTemplate int long long ), 0, this, context, networkTemplate, n, l, l2);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_app_usage_NetworkStats$finalize(), 0, this);
    }

    public boolean getNextBucket(Bucket bucket) {
        return (boolean)InvokeDynamicSupport.bootstrap("getNextBucket", $$robo$$android_app_usage_NetworkStats$getNextBucket(android.app.usage.NetworkStats$Bucket ), 0, this, bucket);
    }

    public boolean hasNextBucket() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasNextBucket", $$robo$$android_app_usage_NetworkStats$hasNextBucket(), 0, this);
    }

    @Override
    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_app_usage_NetworkStats$close(), 0, this);
    }

    Bucket getDeviceSummaryForNetwork() throws RemoteException {
        return InvokeDynamicSupport.bootstrap("getDeviceSummaryForNetwork", $$robo$$android_app_usage_NetworkStats$getDeviceSummaryForNetwork(), 0, this);
    }

    void startSummaryEnumeration() throws RemoteException {
        InvokeDynamicSupport.bootstrap("startSummaryEnumeration", $$robo$$android_app_usage_NetworkStats$startSummaryEnumeration(), 0, this);
    }

    void startHistoryEnumeration(int n) {
        InvokeDynamicSupport.bootstrap("startHistoryEnumeration", $$robo$$android_app_usage_NetworkStats$startHistoryEnumeration(int ), 0, this, n);
    }

    void startHistoryEnumeration(int n, int n2) {
        InvokeDynamicSupport.bootstrap("startHistoryEnumeration", $$robo$$android_app_usage_NetworkStats$startHistoryEnumeration(int int ), 0, this, n, n2);
    }

    void startUserUidEnumeration() throws RemoteException {
        InvokeDynamicSupport.bootstrap("startUserUidEnumeration", $$robo$$android_app_usage_NetworkStats$startUserUidEnumeration(), 0, this);
    }

    private void stepHistory() {
        InvokeDynamicSupport.bootstrap("stepHistory", $$robo$$android_app_usage_NetworkStats$stepHistory(), 0, this);
    }

    private void fillBucketFromSummaryEntry(Bucket bucket) {
        InvokeDynamicSupport.bootstrap("fillBucketFromSummaryEntry", $$robo$$android_app_usage_NetworkStats$fillBucketFromSummaryEntry(android.app.usage.NetworkStats$Bucket ), 0, this, bucket);
    }

    private boolean getNextSummaryBucket(Bucket bucket) {
        return (boolean)InvokeDynamicSupport.bootstrap("getNextSummaryBucket", $$robo$$android_app_usage_NetworkStats$getNextSummaryBucket(android.app.usage.NetworkStats$Bucket ), 0, this, bucket);
    }

    Bucket getSummaryAggregate() {
        return InvokeDynamicSupport.bootstrap("getSummaryAggregate", $$robo$$android_app_usage_NetworkStats$getSummaryAggregate(), 0, this);
    }

    private boolean getNextHistoryBucket(Bucket bucket) {
        return (boolean)InvokeDynamicSupport.bootstrap("getNextHistoryBucket", $$robo$$android_app_usage_NetworkStats$getNextHistoryBucket(android.app.usage.NetworkStats$Bucket ), 0, this, bucket);
    }

    private boolean isUidEnumeration() {
        return (boolean)InvokeDynamicSupport.bootstrap("isUidEnumeration", $$robo$$android_app_usage_NetworkStats$isUidEnumeration(), 0, this);
    }

    private boolean hasNextUid() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasNextUid", $$robo$$android_app_usage_NetworkStats$hasNextUid(), 0, this);
    }

    private int getUid() {
        return (int)InvokeDynamicSupport.bootstrap("getUid", $$robo$$android_app_usage_NetworkStats$getUid(), 0, this);
    }

    private void setSingleUidTag(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setSingleUidTag", $$robo$$android_app_usage_NetworkStats$setSingleUidTag(int int ), 0, this, n, n2);
    }

    private void stepUid() {
        InvokeDynamicSupport.bootstrap("stepUid", $$robo$$android_app_usage_NetworkStats$stepUid(), 0, this);
    }

    public /* synthetic */ NetworkStats() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NetworkStats)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Bucket
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int STATE_ALL = -1;
        public static int STATE_DEFAULT = 1;
        public static int STATE_FOREGROUND = 2;
        public static int UID_ALL = -1;
        public static int UID_REMOVED = -4;
        public static int UID_TETHERING = -5;
        public static int METERED_ALL = -1;
        public static int METERED_NO = 1;
        public static int METERED_YES = 2;
        public static int ROAMING_ALL = -1;
        public static int ROAMING_NO = 1;
        public static int ROAMING_YES = 2;
        public static int TAG_NONE = 0;
        private int mUid;
        private int mTag;
        private int mState;
        private int mMetered;
        private int mRoaming;
        private long mBeginTimeStamp;
        private long mEndTimeStamp;
        private long mRxBytes;
        private long mRxPackets;
        private long mTxBytes;
        private long mTxPackets;

        private static final int $$robo$$android_app_usage_NetworkStats_Bucket$convertState(int networkStatsSet) {
            switch (networkStatsSet) {
                case -1: {
                    return -1;
                }
                case 0: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
            }
            return 0;
        }

        private static final int $$robo$$android_app_usage_NetworkStats_Bucket$convertUid(int uid) {
            switch (uid) {
                case -4: {
                    return -4;
                }
                case -5: {
                    return -5;
                }
            }
            return uid;
        }

        private static final int $$robo$$android_app_usage_NetworkStats_Bucket$convertTag(int tag) {
            switch (tag) {
                case 0: {
                    return 0;
                }
            }
            return tag;
        }

        private static final int $$robo$$android_app_usage_NetworkStats_Bucket$convertMetered(int metered) {
            switch (metered) {
                case -1: {
                    return -1;
                }
                case 0: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
            }
            return 0;
        }

        private static final int $$robo$$android_app_usage_NetworkStats_Bucket$convertRoaming(int roaming) {
            switch (roaming) {
                case -1: {
                    return -1;
                }
                case 0: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
            }
            return 0;
        }

        private void $$robo$$android_app_usage_NetworkStats_Bucket$__constructor__() {
        }

        private final int $$robo$$android_app_usage_NetworkStats_Bucket$getUid() {
            return this.mUid;
        }

        private final int $$robo$$android_app_usage_NetworkStats_Bucket$getTag() {
            return this.mTag;
        }

        private final int $$robo$$android_app_usage_NetworkStats_Bucket$getState() {
            return this.mState;
        }

        private final int $$robo$$android_app_usage_NetworkStats_Bucket$getMetered() {
            return this.mMetered;
        }

        private final int $$robo$$android_app_usage_NetworkStats_Bucket$getRoaming() {
            return this.mRoaming;
        }

        private final long $$robo$$android_app_usage_NetworkStats_Bucket$getStartTimeStamp() {
            return this.mBeginTimeStamp;
        }

        private final long $$robo$$android_app_usage_NetworkStats_Bucket$getEndTimeStamp() {
            return this.mEndTimeStamp;
        }

        private final long $$robo$$android_app_usage_NetworkStats_Bucket$getRxBytes() {
            return this.mRxBytes;
        }

        private final long $$robo$$android_app_usage_NetworkStats_Bucket$getTxBytes() {
            return this.mTxBytes;
        }

        private final long $$robo$$android_app_usage_NetworkStats_Bucket$getRxPackets() {
            return this.mRxPackets;
        }

        private final long $$robo$$android_app_usage_NetworkStats_Bucket$getTxPackets() {
            return this.mTxPackets;
        }

        private static int convertState(int n) {
            return (int)InvokeDynamicSupport.bootstrapStatic("convertState", $$robo$$android_app_usage_NetworkStats_Bucket$convertState(int ), 0, (int)n);
        }

        private static int convertUid(int n) {
            return (int)InvokeDynamicSupport.bootstrapStatic("convertUid", $$robo$$android_app_usage_NetworkStats_Bucket$convertUid(int ), 0, (int)n);
        }

        private static int convertTag(int n) {
            return (int)InvokeDynamicSupport.bootstrapStatic("convertTag", $$robo$$android_app_usage_NetworkStats_Bucket$convertTag(int ), 0, (int)n);
        }

        private static int convertMetered(int n) {
            return (int)InvokeDynamicSupport.bootstrapStatic("convertMetered", $$robo$$android_app_usage_NetworkStats_Bucket$convertMetered(int ), 0, (int)n);
        }

        private static int convertRoaming(int n) {
            return (int)InvokeDynamicSupport.bootstrapStatic("convertRoaming", $$robo$$android_app_usage_NetworkStats_Bucket$convertRoaming(int ), 0, (int)n);
        }

        private void __constructor__() {
            this.$$robo$$android_app_usage_NetworkStats_Bucket$__constructor__();
        }

        public Bucket() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_usage_NetworkStats_Bucket$__constructor__(), 0, this);
        }

        public int getUid() {
            return (int)InvokeDynamicSupport.bootstrap("getUid", $$robo$$android_app_usage_NetworkStats_Bucket$getUid(), 0, this);
        }

        public int getTag() {
            return (int)InvokeDynamicSupport.bootstrap("getTag", $$robo$$android_app_usage_NetworkStats_Bucket$getTag(), 0, this);
        }

        public int getState() {
            return (int)InvokeDynamicSupport.bootstrap("getState", $$robo$$android_app_usage_NetworkStats_Bucket$getState(), 0, this);
        }

        public int getMetered() {
            return (int)InvokeDynamicSupport.bootstrap("getMetered", $$robo$$android_app_usage_NetworkStats_Bucket$getMetered(), 0, this);
        }

        public int getRoaming() {
            return (int)InvokeDynamicSupport.bootstrap("getRoaming", $$robo$$android_app_usage_NetworkStats_Bucket$getRoaming(), 0, this);
        }

        public long getStartTimeStamp() {
            return (long)InvokeDynamicSupport.bootstrap("getStartTimeStamp", $$robo$$android_app_usage_NetworkStats_Bucket$getStartTimeStamp(), 0, this);
        }

        public long getEndTimeStamp() {
            return (long)InvokeDynamicSupport.bootstrap("getEndTimeStamp", $$robo$$android_app_usage_NetworkStats_Bucket$getEndTimeStamp(), 0, this);
        }

        public long getRxBytes() {
            return (long)InvokeDynamicSupport.bootstrap("getRxBytes", $$robo$$android_app_usage_NetworkStats_Bucket$getRxBytes(), 0, this);
        }

        public long getTxBytes() {
            return (long)InvokeDynamicSupport.bootstrap("getTxBytes", $$robo$$android_app_usage_NetworkStats_Bucket$getTxBytes(), 0, this);
        }

        public long getRxPackets() {
            return (long)InvokeDynamicSupport.bootstrap("getRxPackets", $$robo$$android_app_usage_NetworkStats_Bucket$getRxPackets(), 0, this);
        }

        public long getTxPackets() {
            return (long)InvokeDynamicSupport.bootstrap("getTxPackets", $$robo$$android_app_usage_NetworkStats_Bucket$getTxPackets(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Bucket)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Roaming {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Metered {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface State {
        }
    }
}

