/*
 * Decompiled with CFR 0.152.
 */
package android.appwidget;

import android.app.Activity;
import android.appwidget.AppWidgetHostView;
import android.appwidget.AppWidgetProviderInfo;
import android.appwidget.PendingHostUpdate;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.IntentSender;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.DisplayMetrics;
import android.util.SparseArray;
import android.widget.RemoteViews;
import com.android.internal.appwidget.IAppWidgetHost;
import com.android.internal.appwidget.IAppWidgetService;
import java.lang.ref.WeakReference;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AppWidgetHost
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static int HANDLE_UPDATE = 1;
    static int HANDLE_PROVIDER_CHANGED = 2;
    static int HANDLE_PROVIDERS_CHANGED = 3;
    static int HANDLE_VIEW_DATA_CHANGED = 4;
    static Object sServiceLock;
    static IAppWidgetService sService;
    static boolean sServiceInitialized;
    private DisplayMetrics mDisplayMetrics;
    private String mContextOpPackageName;
    private Handler mHandler;
    private int mHostId;
    private Callbacks mCallbacks;
    private SparseArray<AppWidgetHostView> mViews;
    private RemoteViews.OnClickHandler mOnClickHandler;

    private void $$robo$$android_appwidget_AppWidgetHost$__constructor__(Context context, int hostId) {
    }

    private void $$robo$$android_appwidget_AppWidgetHost$__constructor__(Context context, int hostId, RemoteViews.OnClickHandler handler, Looper looper) {
        this.mViews = new SparseArray();
        this.mContextOpPackageName = context.getOpPackageName();
        this.mHostId = hostId;
        this.mOnClickHandler = handler;
        this.mHandler = new UpdateHandler(this, looper);
        this.mCallbacks = new Callbacks(this.mHandler);
        this.mDisplayMetrics = context.getResources().getDisplayMetrics();
        AppWidgetHost.bindService(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_appwidget_AppWidgetHost$bindService(Context context) {
        Object object = sServiceLock;
        synchronized (object) {
            if (sServiceInitialized) {
                return;
            }
            sServiceInitialized = true;
            if (!context.getPackageManager().hasSystemFeature("android.software.app_widgets")) {
                return;
            }
            IBinder b = ServiceManager.getService("appwidget");
            sService = IAppWidgetService.Stub.asInterface(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_appwidget_AppWidgetHost$startListening() {
        List updates;
        int i;
        int[] idsToUpdate;
        int N;
        if (sService == null) {
            return;
        }
        SparseArray<AppWidgetHostView> sparseArray = this.mViews;
        synchronized (sparseArray) {
            N = this.mViews.size();
            idsToUpdate = new int[N];
            for (i = 0; i < N; ++i) {
                idsToUpdate[i] = this.mViews.keyAt(i);
            }
        }
        try {
            updates = sService.startListening(this.mCallbacks, this.mContextOpPackageName, this.mHostId, idsToUpdate).getList();
        }
        catch (RemoteException e) {
            throw new RuntimeException("system server dead?", e);
        }
        N = updates.size();
        block11: for (i = 0; i < N; ++i) {
            PendingHostUpdate update = (PendingHostUpdate)updates.get(i);
            switch (update.type) {
                case 0: {
                    this.updateAppWidgetView(update.appWidgetId, update.views);
                    continue block11;
                }
                case 1: {
                    this.onProviderChanged(update.appWidgetId, update.widgetInfo);
                    continue block11;
                }
                case 2: {
                    this.viewDataChanged(update.appWidgetId, update.viewId);
                }
            }
        }
    }

    private final void $$robo$$android_appwidget_AppWidgetHost$stopListening() {
        if (sService == null) {
            return;
        }
        try {
            sService.stopListening(this.mContextOpPackageName, this.mHostId);
        }
        catch (RemoteException e) {
            throw new RuntimeException("system server dead?", e);
        }
    }

    private final int $$robo$$android_appwidget_AppWidgetHost$allocateAppWidgetId() {
        if (sService == null) {
            return -1;
        }
        try {
            return sService.allocateAppWidgetId(this.mContextOpPackageName, this.mHostId);
        }
        catch (RemoteException e) {
            throw new RuntimeException("system server dead?", e);
        }
    }

    private final void $$robo$$android_appwidget_AppWidgetHost$startAppWidgetConfigureActivityForResult(Activity activity, int appWidgetId, int intentFlags, int requestCode, Bundle options) {
        if (sService == null) {
            return;
        }
        try {
            IntentSender intentSender = sService.createAppWidgetConfigIntentSender(this.mContextOpPackageName, appWidgetId, intentFlags);
            if (intentSender == null) {
                throw new ActivityNotFoundException();
            }
            activity.startIntentSenderForResult(intentSender, requestCode, null, 0, 0, 0, options);
        }
        catch (IntentSender.SendIntentException e) {
            throw new ActivityNotFoundException();
        }
        catch (RemoteException e) {
            throw new RuntimeException("system server dead?", e);
        }
    }

    private final int[] $$robo$$android_appwidget_AppWidgetHost$getAppWidgetIds() {
        if (sService == null) {
            return new int[0];
        }
        try {
            return sService.getAppWidgetIdsForHost(this.mContextOpPackageName, this.mHostId);
        }
        catch (RemoteException e) {
            throw new RuntimeException("system server dead?", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_appwidget_AppWidgetHost$deleteAppWidgetId(int appWidgetId) {
        if (sService == null) {
            return;
        }
        SparseArray<AppWidgetHostView> sparseArray = this.mViews;
        synchronized (sparseArray) {
            this.mViews.remove(appWidgetId);
            try {
                sService.deleteAppWidgetId(this.mContextOpPackageName, appWidgetId);
            }
            catch (RemoteException e) {
                throw new RuntimeException("system server dead?", e);
            }
        }
    }

    private final void $$robo$$android_appwidget_AppWidgetHost$deleteHost() {
        if (sService == null) {
            return;
        }
        try {
            sService.deleteHost(this.mContextOpPackageName, this.mHostId);
        }
        catch (RemoteException e) {
            throw new RuntimeException("system server dead?", e);
        }
    }

    private static final void $$robo$$android_appwidget_AppWidgetHost$deleteAllHosts() {
        if (sService == null) {
            return;
        }
        try {
            sService.deleteAllHosts();
        }
        catch (RemoteException e) {
            throw new RuntimeException("system server dead?", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final AppWidgetHostView $$robo$$android_appwidget_AppWidgetHost$createView(Context context, int appWidgetId, AppWidgetProviderInfo appWidget) {
        RemoteViews views;
        if (sService == null) {
            return null;
        }
        AppWidgetHostView view = this.onCreateView(context, appWidgetId, appWidget);
        view.setOnClickHandler(this.mOnClickHandler);
        view.setAppWidget(appWidgetId, appWidget);
        SparseArray<AppWidgetHostView> sparseArray = this.mViews;
        synchronized (sparseArray) {
            this.mViews.put(appWidgetId, view);
        }
        try {
            views = sService.getAppWidgetViews(this.mContextOpPackageName, appWidgetId);
        }
        catch (RemoteException e) {
            throw new RuntimeException("system server dead?", e);
        }
        view.updateAppWidget(views);
        return view;
    }

    private final AppWidgetHostView $$robo$$android_appwidget_AppWidgetHost$onCreateView(Context context, int appWidgetId, AppWidgetProviderInfo appWidget) {
        return new AppWidgetHostView(context, this.mOnClickHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_appwidget_AppWidgetHost$onProviderChanged(int appWidgetId, AppWidgetProviderInfo appWidget) {
        AppWidgetHostView v;
        appWidget.updateDimensions(this.mDisplayMetrics);
        SparseArray<AppWidgetHostView> sparseArray = this.mViews;
        synchronized (sparseArray) {
            v = this.mViews.get(appWidgetId);
        }
        if (v != null) {
            v.resetAppWidget(appWidget);
        }
    }

    private final void $$robo$$android_appwidget_AppWidgetHost$onProvidersChanged() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_appwidget_AppWidgetHost$updateAppWidgetView(int appWidgetId, RemoteViews views) {
        AppWidgetHostView v;
        SparseArray<AppWidgetHostView> sparseArray = this.mViews;
        synchronized (sparseArray) {
            v = this.mViews.get(appWidgetId);
        }
        if (v != null) {
            v.updateAppWidget(views);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_appwidget_AppWidgetHost$viewDataChanged(int appWidgetId, int viewId) {
        AppWidgetHostView v;
        SparseArray<AppWidgetHostView> sparseArray = this.mViews;
        synchronized (sparseArray) {
            v = this.mViews.get(appWidgetId);
        }
        if (v != null) {
            v.viewDataChanged(viewId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_appwidget_AppWidgetHost$clearViews() {
        SparseArray<AppWidgetHostView> sparseArray = this.mViews;
        synchronized (sparseArray) {
            this.mViews.clear();
        }
    }

    static void __staticInitializer__() {
        sServiceLock = new Object();
        sServiceInitialized = false;
    }

    private void __constructor__(Context context, int n) {
        this.$$robo$$android_appwidget_AppWidgetHost$__constructor__(context, n);
    }

    public AppWidgetHost(Context context, int n) {
        this(context, n, null, context.getMainLooper());
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_appwidget_AppWidgetHost$__constructor__(android.content.Context int ), 0, this, context, n);
    }

    private void __constructor__(Context context, int n, RemoteViews.OnClickHandler onClickHandler, Looper looper) {
        this.$$robo$$android_appwidget_AppWidgetHost$__constructor__(context, n, onClickHandler, looper);
    }

    public AppWidgetHost(Context context, int n, RemoteViews.OnClickHandler onClickHandler, Looper looper) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_appwidget_AppWidgetHost$__constructor__(android.content.Context int android.widget.RemoteViews$OnClickHandler android.os.Looper ), 0, this, context, n, onClickHandler, looper);
    }

    private static void bindService(Context context) {
        InvokeDynamicSupport.bootstrapStatic("bindService", $$robo$$android_appwidget_AppWidgetHost$bindService(android.content.Context ), 0, (Context)context);
    }

    public void startListening() {
        InvokeDynamicSupport.bootstrap("startListening", $$robo$$android_appwidget_AppWidgetHost$startListening(), 0, this);
    }

    public void stopListening() {
        InvokeDynamicSupport.bootstrap("stopListening", $$robo$$android_appwidget_AppWidgetHost$stopListening(), 0, this);
    }

    public int allocateAppWidgetId() {
        return (int)InvokeDynamicSupport.bootstrap("allocateAppWidgetId", $$robo$$android_appwidget_AppWidgetHost$allocateAppWidgetId(), 0, this);
    }

    public void startAppWidgetConfigureActivityForResult(Activity activity, int n, int n2, int n3, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("startAppWidgetConfigureActivityForResult", $$robo$$android_appwidget_AppWidgetHost$startAppWidgetConfigureActivityForResult(android.app.Activity int int int android.os.Bundle ), 0, this, activity, n, n2, n3, bundle);
    }

    public int[] getAppWidgetIds() {
        return InvokeDynamicSupport.bootstrap("getAppWidgetIds", $$robo$$android_appwidget_AppWidgetHost$getAppWidgetIds(), 0, this);
    }

    public void deleteAppWidgetId(int n) {
        InvokeDynamicSupport.bootstrap("deleteAppWidgetId", $$robo$$android_appwidget_AppWidgetHost$deleteAppWidgetId(int ), 0, this, n);
    }

    public void deleteHost() {
        InvokeDynamicSupport.bootstrap("deleteHost", $$robo$$android_appwidget_AppWidgetHost$deleteHost(), 0, this);
    }

    public static void deleteAllHosts() {
        InvokeDynamicSupport.bootstrapStatic("deleteAllHosts", $$robo$$android_appwidget_AppWidgetHost$deleteAllHosts(), 0);
    }

    public AppWidgetHostView createView(Context context, int n, AppWidgetProviderInfo appWidgetProviderInfo) {
        return InvokeDynamicSupport.bootstrap("createView", $$robo$$android_appwidget_AppWidgetHost$createView(android.content.Context int android.appwidget.AppWidgetProviderInfo ), 0, this, context, n, appWidgetProviderInfo);
    }

    protected AppWidgetHostView onCreateView(Context context, int n, AppWidgetProviderInfo appWidgetProviderInfo) {
        return InvokeDynamicSupport.bootstrap("onCreateView", $$robo$$android_appwidget_AppWidgetHost$onCreateView(android.content.Context int android.appwidget.AppWidgetProviderInfo ), 0, this, context, n, appWidgetProviderInfo);
    }

    protected void onProviderChanged(int n, AppWidgetProviderInfo appWidgetProviderInfo) {
        InvokeDynamicSupport.bootstrap("onProviderChanged", $$robo$$android_appwidget_AppWidgetHost$onProviderChanged(int android.appwidget.AppWidgetProviderInfo ), 0, this, n, appWidgetProviderInfo);
    }

    protected void onProvidersChanged() {
        InvokeDynamicSupport.bootstrap("onProvidersChanged", $$robo$$android_appwidget_AppWidgetHost$onProvidersChanged(), 0, this);
    }

    void updateAppWidgetView(int n, RemoteViews remoteViews) {
        InvokeDynamicSupport.bootstrap("updateAppWidgetView", $$robo$$android_appwidget_AppWidgetHost$updateAppWidgetView(int android.widget.RemoteViews ), 0, this, n, remoteViews);
    }

    void viewDataChanged(int n, int n2) {
        InvokeDynamicSupport.bootstrap("viewDataChanged", $$robo$$android_appwidget_AppWidgetHost$viewDataChanged(int int ), 0, this, n, n2);
    }

    protected void clearViews() {
        InvokeDynamicSupport.bootstrap("clearViews", $$robo$$android_appwidget_AppWidgetHost$clearViews(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(AppWidgetHost.class);
    }

    public /* synthetic */ AppWidgetHost() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AppWidgetHost)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class UpdateHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ AppWidgetHost this$0;

        private void $$robo$$android_appwidget_AppWidgetHost_UpdateHandler$__constructor__(AppWidgetHost this$0, Looper looper) {
        }

        private final void $$robo$$android_appwidget_AppWidgetHost_UpdateHandler$handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    this.this$0.updateAppWidgetView(msg.arg1, (RemoteViews)msg.obj);
                    break;
                }
                case 2: {
                    this.this$0.onProviderChanged(msg.arg1, (AppWidgetProviderInfo)msg.obj);
                    break;
                }
                case 3: {
                    this.this$0.onProvidersChanged();
                    break;
                }
                case 4: {
                    this.this$0.viewDataChanged(msg.arg1, msg.arg2);
                }
            }
        }

        private void __constructor__(AppWidgetHost appWidgetHost, Looper looper) {
            this.$$robo$$android_appwidget_AppWidgetHost_UpdateHandler$__constructor__(appWidgetHost, looper);
        }

        public UpdateHandler(AppWidgetHost appWidgetHost, Looper looper) {
            this.this$0 = appWidgetHost;
            super(looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_appwidget_AppWidgetHost_UpdateHandler$__constructor__(android.appwidget.AppWidgetHost android.os.Looper ), 0, this, appWidgetHost, looper);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_appwidget_AppWidgetHost_UpdateHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ UpdateHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UpdateHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Callbacks
    extends IAppWidgetHost.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private WeakReference<Handler> mWeakHandler;

        private void $$robo$$android_appwidget_AppWidgetHost_Callbacks$__constructor__(Handler handler) {
            this.mWeakHandler = new WeakReference<Handler>(handler);
        }

        private final void $$robo$$android_appwidget_AppWidgetHost_Callbacks$updateAppWidget(int appWidgetId, RemoteViews views) {
            Handler handler;
            if (Callbacks.isLocalBinder() && views != null) {
                views = ((RemoteViews)views).clone();
            }
            if ((handler = (Handler)this.mWeakHandler.get()) == null) {
                return;
            }
            Message msg = handler.obtainMessage(1, appWidgetId, 0, views);
            msg.sendToTarget();
        }

        private final void $$robo$$android_appwidget_AppWidgetHost_Callbacks$providerChanged(int appWidgetId, AppWidgetProviderInfo info) {
            Handler handler;
            if (Callbacks.isLocalBinder() && info != null) {
                info = ((AppWidgetProviderInfo)info).clone();
            }
            if ((handler = (Handler)this.mWeakHandler.get()) == null) {
                return;
            }
            Message msg = handler.obtainMessage(2, appWidgetId, 0, info);
            msg.sendToTarget();
        }

        private final void $$robo$$android_appwidget_AppWidgetHost_Callbacks$providersChanged() {
            Handler handler = (Handler)this.mWeakHandler.get();
            if (handler == null) {
                return;
            }
            handler.obtainMessage(3).sendToTarget();
        }

        private final void $$robo$$android_appwidget_AppWidgetHost_Callbacks$viewDataChanged(int appWidgetId, int viewId) {
            Handler handler = (Handler)this.mWeakHandler.get();
            if (handler == null) {
                return;
            }
            Message msg = handler.obtainMessage(4, appWidgetId, viewId);
            msg.sendToTarget();
        }

        private static final boolean $$robo$$android_appwidget_AppWidgetHost_Callbacks$isLocalBinder() {
            return Process.myPid() == Binder.getCallingPid();
        }

        private void __constructor__(Handler handler) {
            this.$$robo$$android_appwidget_AppWidgetHost_Callbacks$__constructor__(handler);
        }

        public Callbacks(Handler handler) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_appwidget_AppWidgetHost_Callbacks$__constructor__(android.os.Handler ), 0, this, handler);
        }

        @Override
        public void updateAppWidget(int n, RemoteViews remoteViews) {
            InvokeDynamicSupport.bootstrap("updateAppWidget", $$robo$$android_appwidget_AppWidgetHost_Callbacks$updateAppWidget(int android.widget.RemoteViews ), 0, this, n, remoteViews);
        }

        @Override
        public void providerChanged(int n, AppWidgetProviderInfo appWidgetProviderInfo) {
            InvokeDynamicSupport.bootstrap("providerChanged", $$robo$$android_appwidget_AppWidgetHost_Callbacks$providerChanged(int android.appwidget.AppWidgetProviderInfo ), 0, this, n, appWidgetProviderInfo);
        }

        @Override
        public void providersChanged() {
            InvokeDynamicSupport.bootstrap("providersChanged", $$robo$$android_appwidget_AppWidgetHost_Callbacks$providersChanged(), 0, this);
        }

        @Override
        public void viewDataChanged(int n, int n2) {
            InvokeDynamicSupport.bootstrap("viewDataChanged", $$robo$$android_appwidget_AppWidgetHost_Callbacks$viewDataChanged(int int ), 0, this, n, n2);
        }

        private static boolean isLocalBinder() {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("isLocalBinder", $$robo$$android_appwidget_AppWidgetHost_Callbacks$isLocalBinder(), 0);
        }

        public /* synthetic */ Callbacks() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Callbacks)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

