/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class BluetoothCodecConfig
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int SOURCE_CODEC_TYPE_SBC = 0;
    public static int SOURCE_CODEC_TYPE_AAC = 1;
    public static int SOURCE_CODEC_TYPE_APTX = 2;
    public static int SOURCE_CODEC_TYPE_APTX_HD = 3;
    public static int SOURCE_CODEC_TYPE_LDAC = 4;
    public static int SOURCE_CODEC_TYPE_MAX = 5;
    public static int SOURCE_CODEC_TYPE_INVALID = 1000000;
    public static int CODEC_PRIORITY_DISABLED = -1;
    public static int CODEC_PRIORITY_DEFAULT = 0;
    public static int CODEC_PRIORITY_HIGHEST = 1000000;
    public static int SAMPLE_RATE_NONE = 0;
    public static int SAMPLE_RATE_44100 = 1;
    public static int SAMPLE_RATE_48000 = 2;
    public static int SAMPLE_RATE_88200 = 4;
    public static int SAMPLE_RATE_96000 = 8;
    public static int SAMPLE_RATE_176400 = 16;
    public static int SAMPLE_RATE_192000 = 32;
    public static int BITS_PER_SAMPLE_NONE = 0;
    public static int BITS_PER_SAMPLE_16 = 1;
    public static int BITS_PER_SAMPLE_24 = 2;
    public static int BITS_PER_SAMPLE_32 = 4;
    public static int CHANNEL_MODE_NONE = 0;
    public static int CHANNEL_MODE_MONO = 1;
    public static int CHANNEL_MODE_STEREO = 2;
    private int mCodecType;
    private int mCodecPriority;
    private int mSampleRate;
    private int mBitsPerSample;
    private int mChannelMode;
    private long mCodecSpecific1;
    private long mCodecSpecific2;
    private long mCodecSpecific3;
    private long mCodecSpecific4;
    public static Parcelable.Creator<BluetoothCodecConfig> CREATOR;

    private void $$robo$$android_bluetooth_BluetoothCodecConfig$__constructor__(int codecType, int codecPriority, int sampleRate, int bitsPerSample, int channelMode, long codecSpecific1, long codecSpecific2, long codecSpecific3, long codecSpecific4) {
        this.mCodecType = codecType;
        this.mCodecPriority = codecPriority;
        this.mSampleRate = sampleRate;
        this.mBitsPerSample = bitsPerSample;
        this.mChannelMode = channelMode;
        this.mCodecSpecific1 = codecSpecific1;
        this.mCodecSpecific2 = codecSpecific2;
        this.mCodecSpecific3 = codecSpecific3;
        this.mCodecSpecific4 = codecSpecific4;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothCodecConfig$equals(Object o) {
        if (o instanceof BluetoothCodecConfig) {
            BluetoothCodecConfig other = (BluetoothCodecConfig)o;
            return other.mCodecType == this.mCodecType && other.mCodecPriority == this.mCodecPriority && other.mSampleRate == this.mSampleRate && other.mBitsPerSample == this.mBitsPerSample && other.mChannelMode == this.mChannelMode && other.mCodecSpecific1 == this.mCodecSpecific1 && other.mCodecSpecific2 == this.mCodecSpecific2 && other.mCodecSpecific3 == this.mCodecSpecific3 && other.mCodecSpecific4 == this.mCodecSpecific4;
        }
        return false;
    }

    private final int $$robo$$android_bluetooth_BluetoothCodecConfig$hashCode() {
        return Objects.hash(this.mCodecType, this.mCodecPriority, this.mSampleRate, this.mBitsPerSample, this.mChannelMode, this.mCodecSpecific1, this.mCodecSpecific2, this.mCodecSpecific3, this.mCodecSpecific4);
    }

    private final boolean $$robo$$android_bluetooth_BluetoothCodecConfig$isValid() {
        return this.mSampleRate != 0 && this.mBitsPerSample != 0 && this.mChannelMode != 0;
    }

    private static final String $$robo$$android_bluetooth_BluetoothCodecConfig$appendCapabilityToString(String prevStr, String capStr) {
        if (prevStr == null) {
            return capStr;
        }
        return prevStr + "|" + capStr;
    }

    private final String $$robo$$android_bluetooth_BluetoothCodecConfig$toString() {
        String sampleRateStr = null;
        if (this.mSampleRate == 0) {
            sampleRateStr = BluetoothCodecConfig.appendCapabilityToString(sampleRateStr, "NONE");
        }
        if ((this.mSampleRate & 1) != 0) {
            sampleRateStr = BluetoothCodecConfig.appendCapabilityToString(sampleRateStr, "44100");
        }
        if ((this.mSampleRate & 2) != 0) {
            sampleRateStr = BluetoothCodecConfig.appendCapabilityToString(sampleRateStr, "48000");
        }
        if ((this.mSampleRate & 4) != 0) {
            sampleRateStr = BluetoothCodecConfig.appendCapabilityToString(sampleRateStr, "88200");
        }
        if ((this.mSampleRate & 8) != 0) {
            sampleRateStr = BluetoothCodecConfig.appendCapabilityToString(sampleRateStr, "96000");
        }
        if ((this.mSampleRate & 0x10) != 0) {
            sampleRateStr = BluetoothCodecConfig.appendCapabilityToString(sampleRateStr, "176400");
        }
        if ((this.mSampleRate & 0x20) != 0) {
            sampleRateStr = BluetoothCodecConfig.appendCapabilityToString(sampleRateStr, "192000");
        }
        String bitsPerSampleStr = null;
        if (this.mBitsPerSample == 0) {
            bitsPerSampleStr = BluetoothCodecConfig.appendCapabilityToString(bitsPerSampleStr, "NONE");
        }
        if ((this.mBitsPerSample & 1) != 0) {
            bitsPerSampleStr = BluetoothCodecConfig.appendCapabilityToString(bitsPerSampleStr, "16");
        }
        if ((this.mBitsPerSample & 2) != 0) {
            bitsPerSampleStr = BluetoothCodecConfig.appendCapabilityToString(bitsPerSampleStr, "24");
        }
        if ((this.mBitsPerSample & 4) != 0) {
            bitsPerSampleStr = BluetoothCodecConfig.appendCapabilityToString(bitsPerSampleStr, "32");
        }
        String channelModeStr = null;
        if (this.mChannelMode == 0) {
            channelModeStr = BluetoothCodecConfig.appendCapabilityToString(channelModeStr, "NONE");
        }
        if ((this.mChannelMode & 1) != 0) {
            channelModeStr = BluetoothCodecConfig.appendCapabilityToString(channelModeStr, "MONO");
        }
        if ((this.mChannelMode & 2) != 0) {
            channelModeStr = BluetoothCodecConfig.appendCapabilityToString(channelModeStr, "STEREO");
        }
        return "{codecName:" + this.getCodecName() + ",mCodecType:" + this.mCodecType + ",mCodecPriority:" + this.mCodecPriority + ",mSampleRate:" + String.format("0x%x", this.mSampleRate) + "(" + sampleRateStr + ")" + ",mBitsPerSample:" + String.format("0x%x", this.mBitsPerSample) + "(" + bitsPerSampleStr + ")" + ",mChannelMode:" + String.format("0x%x", this.mChannelMode) + "(" + channelModeStr + ")" + ",mCodecSpecific1:" + this.mCodecSpecific1 + ",mCodecSpecific2:" + this.mCodecSpecific2 + ",mCodecSpecific3:" + this.mCodecSpecific3 + ",mCodecSpecific4:" + this.mCodecSpecific4 + "}";
    }

    private final int $$robo$$android_bluetooth_BluetoothCodecConfig$describeContents() {
        return 0;
    }

    private final void $$robo$$android_bluetooth_BluetoothCodecConfig$writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mCodecType);
        out.writeInt(this.mCodecPriority);
        out.writeInt(this.mSampleRate);
        out.writeInt(this.mBitsPerSample);
        out.writeInt(this.mChannelMode);
        out.writeLong(this.mCodecSpecific1);
        out.writeLong(this.mCodecSpecific2);
        out.writeLong(this.mCodecSpecific3);
        out.writeLong(this.mCodecSpecific4);
    }

    private final String $$robo$$android_bluetooth_BluetoothCodecConfig$getCodecName() {
        switch (this.mCodecType) {
            case 0: {
                return "SBC";
            }
            case 1: {
                return "AAC";
            }
            case 2: {
                return "aptX";
            }
            case 3: {
                return "aptX HD";
            }
            case 4: {
                return "LDAC";
            }
            case 1000000: {
                return "INVALID CODEC";
            }
        }
        return "UNKNOWN CODEC(" + this.mCodecType + ")";
    }

    private final int $$robo$$android_bluetooth_BluetoothCodecConfig$getCodecType() {
        return this.mCodecType;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothCodecConfig$isMandatoryCodec() {
        return this.mCodecType == 0;
    }

    private final int $$robo$$android_bluetooth_BluetoothCodecConfig$getCodecPriority() {
        return this.mCodecPriority;
    }

    private final void $$robo$$android_bluetooth_BluetoothCodecConfig$setCodecPriority(int codecPriority) {
        this.mCodecPriority = codecPriority;
    }

    private final int $$robo$$android_bluetooth_BluetoothCodecConfig$getSampleRate() {
        return this.mSampleRate;
    }

    private final int $$robo$$android_bluetooth_BluetoothCodecConfig$getBitsPerSample() {
        return this.mBitsPerSample;
    }

    private final int $$robo$$android_bluetooth_BluetoothCodecConfig$getChannelMode() {
        return this.mChannelMode;
    }

    private final long $$robo$$android_bluetooth_BluetoothCodecConfig$getCodecSpecific1() {
        return this.mCodecSpecific1;
    }

    private final long $$robo$$android_bluetooth_BluetoothCodecConfig$getCodecSpecific2() {
        return this.mCodecSpecific2;
    }

    private final long $$robo$$android_bluetooth_BluetoothCodecConfig$getCodecSpecific3() {
        return this.mCodecSpecific3;
    }

    private final long $$robo$$android_bluetooth_BluetoothCodecConfig$getCodecSpecific4() {
        return this.mCodecSpecific4;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothCodecConfig$sameAudioFeedingParameters(BluetoothCodecConfig other) {
        return other != null && other.mSampleRate == this.mSampleRate && other.mBitsPerSample == this.mBitsPerSample && other.mChannelMode == this.mChannelMode;
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<BluetoothCodecConfig>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_bluetooth_BluetoothCodecConfig_1$__constructor__() {
            }

            private final BluetoothCodecConfig $$robo$$android_bluetooth_BluetoothCodecConfig_1$createFromParcel(Parcel in) {
                int codecType = in.readInt();
                int codecPriority = in.readInt();
                int sampleRate = in.readInt();
                int bitsPerSample = in.readInt();
                int channelMode = in.readInt();
                long codecSpecific1 = in.readLong();
                long codecSpecific2 = in.readLong();
                long codecSpecific3 = in.readLong();
                long codecSpecific4 = in.readLong();
                return new BluetoothCodecConfig(codecType, codecPriority, sampleRate, bitsPerSample, channelMode, codecSpecific1, codecSpecific2, codecSpecific3, codecSpecific4);
            }

            private final BluetoothCodecConfig[] $$robo$$android_bluetooth_BluetoothCodecConfig_1$newArray(int size) {
                return new BluetoothCodecConfig[size];
            }

            private void __constructor__() {
                this.$$robo$$android_bluetooth_BluetoothCodecConfig_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothCodecConfig_1$__constructor__(), 0, this);
            }

            @Override
            public BluetoothCodecConfig createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_bluetooth_BluetoothCodecConfig_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public BluetoothCodecConfig[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_bluetooth_BluetoothCodecConfig_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(int n, int n2, int n3, int n4, int n5, long l, long l2, long l3, long l4) {
        this.$$robo$$android_bluetooth_BluetoothCodecConfig$__constructor__(n, n2, n3, n4, n5, l, l2, l3, l4);
    }

    public BluetoothCodecConfig(int n, int n2, int n3, int n4, int n5, long l, long l2, long l3, long l4) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothCodecConfig$__constructor__(int int int int int long long long long ), 0, this, n, n2, n3, n4, n5, l, l2, l3, l4);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_bluetooth_BluetoothCodecConfig$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_bluetooth_BluetoothCodecConfig$hashCode(), 0, this);
    }

    public boolean isValid() {
        return (boolean)InvokeDynamicSupport.bootstrap("isValid", $$robo$$android_bluetooth_BluetoothCodecConfig$isValid(), 0, this);
    }

    private static String appendCapabilityToString(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("appendCapabilityToString", $$robo$$android_bluetooth_BluetoothCodecConfig$appendCapabilityToString(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_bluetooth_BluetoothCodecConfig$toString(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_bluetooth_BluetoothCodecConfig$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_bluetooth_BluetoothCodecConfig$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    public String getCodecName() {
        return InvokeDynamicSupport.bootstrap("getCodecName", $$robo$$android_bluetooth_BluetoothCodecConfig$getCodecName(), 0, this);
    }

    public int getCodecType() {
        return (int)InvokeDynamicSupport.bootstrap("getCodecType", $$robo$$android_bluetooth_BluetoothCodecConfig$getCodecType(), 0, this);
    }

    public boolean isMandatoryCodec() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMandatoryCodec", $$robo$$android_bluetooth_BluetoothCodecConfig$isMandatoryCodec(), 0, this);
    }

    public int getCodecPriority() {
        return (int)InvokeDynamicSupport.bootstrap("getCodecPriority", $$robo$$android_bluetooth_BluetoothCodecConfig$getCodecPriority(), 0, this);
    }

    public void setCodecPriority(int n) {
        InvokeDynamicSupport.bootstrap("setCodecPriority", $$robo$$android_bluetooth_BluetoothCodecConfig$setCodecPriority(int ), 0, this, n);
    }

    public int getSampleRate() {
        return (int)InvokeDynamicSupport.bootstrap("getSampleRate", $$robo$$android_bluetooth_BluetoothCodecConfig$getSampleRate(), 0, this);
    }

    public int getBitsPerSample() {
        return (int)InvokeDynamicSupport.bootstrap("getBitsPerSample", $$robo$$android_bluetooth_BluetoothCodecConfig$getBitsPerSample(), 0, this);
    }

    public int getChannelMode() {
        return (int)InvokeDynamicSupport.bootstrap("getChannelMode", $$robo$$android_bluetooth_BluetoothCodecConfig$getChannelMode(), 0, this);
    }

    public long getCodecSpecific1() {
        return (long)InvokeDynamicSupport.bootstrap("getCodecSpecific1", $$robo$$android_bluetooth_BluetoothCodecConfig$getCodecSpecific1(), 0, this);
    }

    public long getCodecSpecific2() {
        return (long)InvokeDynamicSupport.bootstrap("getCodecSpecific2", $$robo$$android_bluetooth_BluetoothCodecConfig$getCodecSpecific2(), 0, this);
    }

    public long getCodecSpecific3() {
        return (long)InvokeDynamicSupport.bootstrap("getCodecSpecific3", $$robo$$android_bluetooth_BluetoothCodecConfig$getCodecSpecific3(), 0, this);
    }

    public long getCodecSpecific4() {
        return (long)InvokeDynamicSupport.bootstrap("getCodecSpecific4", $$robo$$android_bluetooth_BluetoothCodecConfig$getCodecSpecific4(), 0, this);
    }

    public boolean sameAudioFeedingParameters(BluetoothCodecConfig bluetoothCodecConfig) {
        return (boolean)InvokeDynamicSupport.bootstrap("sameAudioFeedingParameters", $$robo$$android_bluetooth_BluetoothCodecConfig$sameAudioFeedingParameters(android.bluetooth.BluetoothCodecConfig ), 0, this, bluetoothCodecConfig);
    }

    static {
        RobolectricInternals.classInitializing(BluetoothCodecConfig.class);
    }

    public /* synthetic */ BluetoothCodecConfig() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BluetoothCodecConfig)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

