/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattServerCallback;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.IBluetoothGatt;
import android.bluetooth.IBluetoothGattServerCallback;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class BluetoothGattServer
implements BluetoothProfile,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "BluetoothGattServer";
    private static boolean DBG = true;
    private static boolean VDBG = false;
    private BluetoothAdapter mAdapter;
    private IBluetoothGatt mService;
    private BluetoothGattServerCallback mCallback;
    private Object mServerIfLock;
    private int mServerIf;
    private int mTransport;
    private BluetoothGattService mPendingService;
    private List<BluetoothGattService> mServices;
    private static int CALLBACK_REG_TIMEOUT = 10000;
    private IBluetoothGattServerCallback mBluetoothGattServerCallback;

    private void $$robo$$android_bluetooth_BluetoothGattServer$__constructor__(IBluetoothGatt iGatt, int transport) {
        this.mServerIfLock = new Object();
        this.mBluetoothGattServerCallback = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ BluetoothGattServer this$0;

            private void $$robo$$android_bluetooth_BluetoothGattServer_1$__constructor__(BluetoothGattServer this$0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_BluetoothGattServer_1$onServerRegistered(int status, int serverIf) {
                Log.d("BluetoothGattServer", "onServerRegistered() - status=" + status + " serverIf=" + serverIf);
                Object object = this.this$0.mServerIfLock;
                synchronized (object) {
                    if (this.this$0.mCallback != null) {
                        this.this$0.mServerIf = serverIf;
                        this.this$0.mServerIfLock.notify();
                    } else {
                        Log.e("BluetoothGattServer", "onServerRegistered: mCallback is null");
                    }
                }
            }

            private final void $$robo$$android_bluetooth_BluetoothGattServer_1$onServerConnectionState(int status, int serverIf, boolean connected, String address) {
                Log.d("BluetoothGattServer", "onServerConnectionState() - status=" + status + " serverIf=" + serverIf + " device=" + address);
                try {
                    this.this$0.mCallback.onConnectionStateChange(this.this$0.mAdapter.getRemoteDevice(address), status, connected ? 2 : 0);
                }
                catch (Exception ex) {
                    Log.w("BluetoothGattServer", "Unhandled exception in callback", ex);
                }
            }

            private final void $$robo$$android_bluetooth_BluetoothGattServer_1$onServiceAdded(int status, BluetoothGattService service) {
                Log.d("BluetoothGattServer", "onServiceAdded() - handle=" + service.getInstanceId() + " uuid=" + service.getUuid() + " status=" + status);
                if (this.this$0.mPendingService == null) {
                    return;
                }
                BluetoothGattService tmp = this.this$0.mPendingService;
                this.this$0.mPendingService = null;
                tmp.setInstanceId(service.getInstanceId());
                List<BluetoothGattCharacteristic> temp_chars = tmp.getCharacteristics();
                List<BluetoothGattCharacteristic> svc_chars = service.getCharacteristics();
                for (int i = 0; i < svc_chars.size(); ++i) {
                    BluetoothGattCharacteristic temp_char = temp_chars.get(i);
                    BluetoothGattCharacteristic svc_char = svc_chars.get(i);
                    temp_char.setInstanceId(svc_char.getInstanceId());
                    List<BluetoothGattDescriptor> temp_descs = temp_char.getDescriptors();
                    List<BluetoothGattDescriptor> svc_descs = svc_char.getDescriptors();
                    for (int j = 0; j < svc_descs.size(); ++j) {
                        temp_descs.get(j).setInstanceId(svc_descs.get(j).getInstanceId());
                    }
                }
                this.this$0.mServices.add(tmp);
                try {
                    this.this$0.mCallback.onServiceAdded(status, tmp);
                }
                catch (Exception ex) {
                    Log.w("BluetoothGattServer", "Unhandled exception in callback", ex);
                }
            }

            private final void $$robo$$android_bluetooth_BluetoothGattServer_1$onCharacteristicReadRequest(String address, int transId, int offset, boolean isLong, int handle) {
                BluetoothDevice device = this.this$0.mAdapter.getRemoteDevice(address);
                BluetoothGattCharacteristic characteristic = this.this$0.getCharacteristicByHandle(handle);
                if (characteristic == null) {
                    Log.w("BluetoothGattServer", "onCharacteristicReadRequest() no char for handle " + handle);
                    return;
                }
                try {
                    this.this$0.mCallback.onCharacteristicReadRequest(device, transId, offset, characteristic);
                }
                catch (Exception ex) {
                    Log.w("BluetoothGattServer", "Unhandled exception in callback", ex);
                }
            }

            private final void $$robo$$android_bluetooth_BluetoothGattServer_1$onDescriptorReadRequest(String address, int transId, int offset, boolean isLong, int handle) {
                BluetoothDevice device = this.this$0.mAdapter.getRemoteDevice(address);
                BluetoothGattDescriptor descriptor = this.this$0.getDescriptorByHandle(handle);
                if (descriptor == null) {
                    Log.w("BluetoothGattServer", "onDescriptorReadRequest() no desc for handle " + handle);
                    return;
                }
                try {
                    this.this$0.mCallback.onDescriptorReadRequest(device, transId, offset, descriptor);
                }
                catch (Exception ex) {
                    Log.w("BluetoothGattServer", "Unhandled exception in callback", ex);
                }
            }

            private final void $$robo$$android_bluetooth_BluetoothGattServer_1$onCharacteristicWriteRequest(String address, int transId, int offset, int length, boolean isPrep, boolean needRsp, int handle, byte[] value) {
                BluetoothDevice device = this.this$0.mAdapter.getRemoteDevice(address);
                BluetoothGattCharacteristic characteristic = this.this$0.getCharacteristicByHandle(handle);
                if (characteristic == null) {
                    Log.w("BluetoothGattServer", "onCharacteristicWriteRequest() no char for handle " + handle);
                    return;
                }
                try {
                    this.this$0.mCallback.onCharacteristicWriteRequest(device, transId, characteristic, isPrep, needRsp, offset, value);
                }
                catch (Exception ex) {
                    Log.w("BluetoothGattServer", "Unhandled exception in callback", ex);
                }
            }

            private final void $$robo$$android_bluetooth_BluetoothGattServer_1$onDescriptorWriteRequest(String address, int transId, int offset, int length, boolean isPrep, boolean needRsp, int handle, byte[] value) {
                BluetoothDevice device = this.this$0.mAdapter.getRemoteDevice(address);
                BluetoothGattDescriptor descriptor = this.this$0.getDescriptorByHandle(handle);
                if (descriptor == null) {
                    Log.w("BluetoothGattServer", "onDescriptorWriteRequest() no desc for handle " + handle);
                    return;
                }
                try {
                    this.this$0.mCallback.onDescriptorWriteRequest(device, transId, descriptor, isPrep, needRsp, offset, value);
                }
                catch (Exception ex) {
                    Log.w("BluetoothGattServer", "Unhandled exception in callback", ex);
                }
            }

            private final void $$robo$$android_bluetooth_BluetoothGattServer_1$onExecuteWrite(String address, int transId, boolean execWrite) {
                Log.d("BluetoothGattServer", "onExecuteWrite() - device=" + address + ", transId=" + transId + "execWrite=" + execWrite);
                BluetoothDevice device = this.this$0.mAdapter.getRemoteDevice(address);
                if (device == null) {
                    return;
                }
                try {
                    this.this$0.mCallback.onExecuteWrite(device, transId, execWrite);
                }
                catch (Exception ex) {
                    Log.w("BluetoothGattServer", "Unhandled exception in callback", ex);
                }
            }

            private final void $$robo$$android_bluetooth_BluetoothGattServer_1$onNotificationSent(String address, int status) {
                BluetoothDevice device = this.this$0.mAdapter.getRemoteDevice(address);
                if (device == null) {
                    return;
                }
                try {
                    this.this$0.mCallback.onNotificationSent(device, status);
                }
                catch (Exception ex) {
                    Log.w("BluetoothGattServer", "Unhandled exception: " + ex);
                }
            }

            private final void $$robo$$android_bluetooth_BluetoothGattServer_1$onMtuChanged(String address, int mtu) {
                Log.d("BluetoothGattServer", "onMtuChanged() - device=" + address + ", mtu=" + mtu);
                BluetoothDevice device = this.this$0.mAdapter.getRemoteDevice(address);
                if (device == null) {
                    return;
                }
                try {
                    this.this$0.mCallback.onMtuChanged(device, mtu);
                }
                catch (Exception ex) {
                    Log.w("BluetoothGattServer", "Unhandled exception: " + ex);
                }
            }

            private final void $$robo$$android_bluetooth_BluetoothGattServer_1$onPhyUpdate(String address, int txPhy, int rxPhy, int status) {
                Log.d("BluetoothGattServer", "onPhyUpdate() - device=" + address + ", txPHy=" + txPhy + ", rxPHy=" + rxPhy);
                BluetoothDevice device = this.this$0.mAdapter.getRemoteDevice(address);
                if (device == null) {
                    return;
                }
                try {
                    this.this$0.mCallback.onPhyUpdate(device, txPhy, rxPhy, status);
                }
                catch (Exception ex) {
                    Log.w("BluetoothGattServer", "Unhandled exception: " + ex);
                }
            }

            private final void $$robo$$android_bluetooth_BluetoothGattServer_1$onPhyRead(String address, int txPhy, int rxPhy, int status) {
                Log.d("BluetoothGattServer", "onPhyUpdate() - device=" + address + ", txPHy=" + txPhy + ", rxPHy=" + rxPhy);
                BluetoothDevice device = this.this$0.mAdapter.getRemoteDevice(address);
                if (device == null) {
                    return;
                }
                try {
                    this.this$0.mCallback.onPhyRead(device, txPhy, rxPhy, status);
                }
                catch (Exception ex) {
                    Log.w("BluetoothGattServer", "Unhandled exception: " + ex);
                }
            }

            private final void $$robo$$android_bluetooth_BluetoothGattServer_1$onConnectionUpdated(String address, int interval, int latency, int timeout, int status) {
                Log.d("BluetoothGattServer", "onConnectionUpdated() - Device=" + address + " interval=" + interval + " latency=" + latency + " timeout=" + timeout + " status=" + status);
                BluetoothDevice device = this.this$0.mAdapter.getRemoteDevice(address);
                if (device == null) {
                    return;
                }
                try {
                    this.this$0.mCallback.onConnectionUpdated(device, interval, latency, timeout, status);
                }
                catch (Exception ex) {
                    Log.w("BluetoothGattServer", "Unhandled exception: " + ex);
                }
            }

            private void __constructor__(BluetoothGattServer bluetoothGattServer) {
                this.$$robo$$android_bluetooth_BluetoothGattServer_1$__constructor__(bluetoothGattServer);
            }
            {
                this.this$0 = bluetoothGattServer;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothGattServer_1$__constructor__(android.bluetooth.BluetoothGattServer ), 0, this, bluetoothGattServer);
            }

            @Override
            public void onServerRegistered(int n, int n2) {
                InvokeDynamicSupport.bootstrap("onServerRegistered", $$robo$$android_bluetooth_BluetoothGattServer_1$onServerRegistered(int int ), 0, this, n, n2);
            }

            @Override
            public void onServerConnectionState(int n, int n2, boolean bl, String string2) {
                InvokeDynamicSupport.bootstrap("onServerConnectionState", $$robo$$android_bluetooth_BluetoothGattServer_1$onServerConnectionState(int int boolean java.lang.String ), 0, this, n, n2, bl, string2);
            }

            @Override
            public void onServiceAdded(int n, BluetoothGattService bluetoothGattService) {
                InvokeDynamicSupport.bootstrap("onServiceAdded", $$robo$$android_bluetooth_BluetoothGattServer_1$onServiceAdded(int android.bluetooth.BluetoothGattService ), 0, this, n, bluetoothGattService);
            }

            @Override
            public void onCharacteristicReadRequest(String string2, int n, int n2, boolean bl, int n3) {
                InvokeDynamicSupport.bootstrap("onCharacteristicReadRequest", $$robo$$android_bluetooth_BluetoothGattServer_1$onCharacteristicReadRequest(java.lang.String int int boolean int ), 0, this, string2, n, n2, bl, n3);
            }

            @Override
            public void onDescriptorReadRequest(String string2, int n, int n2, boolean bl, int n3) {
                InvokeDynamicSupport.bootstrap("onDescriptorReadRequest", $$robo$$android_bluetooth_BluetoothGattServer_1$onDescriptorReadRequest(java.lang.String int int boolean int ), 0, this, string2, n, n2, bl, n3);
            }

            @Override
            public void onCharacteristicWriteRequest(String string2, int n, int n2, int n3, boolean bl, boolean bl2, int n4, byte[] byArray) {
                InvokeDynamicSupport.bootstrap("onCharacteristicWriteRequest", $$robo$$android_bluetooth_BluetoothGattServer_1$onCharacteristicWriteRequest(java.lang.String int int int boolean boolean int byte[] ), 0, this, string2, n, n2, n3, bl, bl2, n4, byArray);
            }

            @Override
            public void onDescriptorWriteRequest(String string2, int n, int n2, int n3, boolean bl, boolean bl2, int n4, byte[] byArray) {
                InvokeDynamicSupport.bootstrap("onDescriptorWriteRequest", $$robo$$android_bluetooth_BluetoothGattServer_1$onDescriptorWriteRequest(java.lang.String int int int boolean boolean int byte[] ), 0, this, string2, n, n2, n3, bl, bl2, n4, byArray);
            }

            @Override
            public void onExecuteWrite(String string2, int n, boolean bl) {
                InvokeDynamicSupport.bootstrap("onExecuteWrite", $$robo$$android_bluetooth_BluetoothGattServer_1$onExecuteWrite(java.lang.String int boolean ), 0, this, string2, n, bl);
            }

            @Override
            public void onNotificationSent(String string2, int n) {
                InvokeDynamicSupport.bootstrap("onNotificationSent", $$robo$$android_bluetooth_BluetoothGattServer_1$onNotificationSent(java.lang.String int ), 0, this, string2, n);
            }

            @Override
            public void onMtuChanged(String string2, int n) {
                InvokeDynamicSupport.bootstrap("onMtuChanged", $$robo$$android_bluetooth_BluetoothGattServer_1$onMtuChanged(java.lang.String int ), 0, this, string2, n);
            }

            @Override
            public void onPhyUpdate(String string2, int n, int n2, int n3) {
                InvokeDynamicSupport.bootstrap("onPhyUpdate", $$robo$$android_bluetooth_BluetoothGattServer_1$onPhyUpdate(java.lang.String int int int ), 0, this, string2, n, n2, n3);
            }

            @Override
            public void onPhyRead(String string2, int n, int n2, int n3) {
                InvokeDynamicSupport.bootstrap("onPhyRead", $$robo$$android_bluetooth_BluetoothGattServer_1$onPhyRead(java.lang.String int int int ), 0, this, string2, n, n2, n3);
            }

            @Override
            public void onConnectionUpdated(String string2, int n, int n2, int n3, int n4) {
                InvokeDynamicSupport.bootstrap("onConnectionUpdated", $$robo$$android_bluetooth_BluetoothGattServer_1$onConnectionUpdated(java.lang.String int int int int ), 0, this, string2, n, n2, n3, n4);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mService = iGatt;
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        this.mCallback = null;
        this.mServerIf = 0;
        this.mTransport = transport;
        this.mServices = new ArrayList<BluetoothGattService>();
    }

    private final BluetoothGattCharacteristic $$robo$$android_bluetooth_BluetoothGattServer$getCharacteristicByHandle(int handle) {
        for (BluetoothGattService svc : this.mServices) {
            for (BluetoothGattCharacteristic charac : svc.getCharacteristics()) {
                if (charac.getInstanceId() != handle) continue;
                return charac;
            }
        }
        return null;
    }

    private final BluetoothGattDescriptor $$robo$$android_bluetooth_BluetoothGattServer$getDescriptorByHandle(int handle) {
        for (BluetoothGattService svc : this.mServices) {
            for (BluetoothGattCharacteristic charac : svc.getCharacteristics()) {
                for (BluetoothGattDescriptor desc : charac.getDescriptors()) {
                    if (desc.getInstanceId() != handle) continue;
                    return desc;
                }
            }
        }
        return null;
    }

    private final void $$robo$$android_bluetooth_BluetoothGattServer$close() {
        Log.d("BluetoothGattServer", "close()");
        this.unregisterCallback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_bluetooth_BluetoothGattServer$registerCallback(BluetoothGattServerCallback callback) {
        Log.d("BluetoothGattServer", "registerCallback()");
        if (this.mService == null) {
            Log.e("BluetoothGattServer", "GATT service not available");
            return false;
        }
        UUID uuid = UUID.randomUUID();
        Log.d("BluetoothGattServer", "registerCallback() - UUID=" + uuid);
        Object object = this.mServerIfLock;
        synchronized (object) {
            if (this.mCallback != null) {
                Log.e("BluetoothGattServer", "App can register callback only once");
                return false;
            }
            this.mCallback = callback;
            try {
                this.mService.registerServer(new ParcelUuid(uuid), this.mBluetoothGattServerCallback);
            }
            catch (RemoteException e) {
                Log.e("BluetoothGattServer", "", e);
                this.mCallback = null;
                return false;
            }
            try {
                this.mServerIfLock.wait(10000L);
            }
            catch (InterruptedException e) {
                Log.e("BluetoothGattServer", "" + e);
                this.mCallback = null;
            }
            if (this.mServerIf == 0) {
                this.mCallback = null;
                return false;
            }
            return true;
        }
    }

    private final void $$robo$$android_bluetooth_BluetoothGattServer$unregisterCallback() {
        Log.d("BluetoothGattServer", "unregisterCallback() - mServerIf=" + this.mServerIf);
        if (this.mService == null || this.mServerIf == 0) {
            return;
        }
        try {
            this.mCallback = null;
            this.mService.unregisterServer(this.mServerIf);
            this.mServerIf = 0;
        }
        catch (RemoteException e) {
            Log.e("BluetoothGattServer", "", e);
        }
    }

    private final BluetoothGattService $$robo$$android_bluetooth_BluetoothGattServer$getService(UUID uuid, int instanceId, int type) {
        for (BluetoothGattService svc : this.mServices) {
            if (svc.getType() != type || svc.getInstanceId() != instanceId || !svc.getUuid().equals(uuid)) continue;
            return svc;
        }
        return null;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothGattServer$connect(BluetoothDevice device, boolean autoConnect) {
        Log.d("BluetoothGattServer", "connect() - device: " + device.getAddress() + ", auto: " + autoConnect);
        if (this.mService == null || this.mServerIf == 0) {
            return false;
        }
        try {
            this.mService.serverConnect(this.mServerIf, device.getAddress(), !autoConnect, this.mTransport);
        }
        catch (RemoteException e) {
            Log.e("BluetoothGattServer", "", e);
            return false;
        }
        return true;
    }

    private final void $$robo$$android_bluetooth_BluetoothGattServer$cancelConnection(BluetoothDevice device) {
        Log.d("BluetoothGattServer", "cancelConnection() - device: " + device.getAddress());
        if (this.mService == null || this.mServerIf == 0) {
            return;
        }
        try {
            this.mService.serverDisconnect(this.mServerIf, device.getAddress());
        }
        catch (RemoteException e) {
            Log.e("BluetoothGattServer", "", e);
        }
    }

    private final void $$robo$$android_bluetooth_BluetoothGattServer$setPreferredPhy(BluetoothDevice device, int txPhy, int rxPhy, int phyOptions) {
        try {
            this.mService.serverSetPreferredPhy(this.mServerIf, device.getAddress(), txPhy, rxPhy, phyOptions);
        }
        catch (RemoteException e) {
            Log.e("BluetoothGattServer", "", e);
        }
    }

    private final void $$robo$$android_bluetooth_BluetoothGattServer$readPhy(BluetoothDevice device) {
        try {
            this.mService.serverReadPhy(this.mServerIf, device.getAddress());
        }
        catch (RemoteException e) {
            Log.e("BluetoothGattServer", "", e);
        }
    }

    private final boolean $$robo$$android_bluetooth_BluetoothGattServer$sendResponse(BluetoothDevice device, int requestId, int status, int offset, byte[] value) {
        if (this.mService == null || this.mServerIf == 0) {
            return false;
        }
        try {
            this.mService.sendResponse(this.mServerIf, device.getAddress(), requestId, status, offset, value);
        }
        catch (RemoteException e) {
            Log.e("BluetoothGattServer", "", e);
            return false;
        }
        return true;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothGattServer$notifyCharacteristicChanged(BluetoothDevice device, BluetoothGattCharacteristic characteristic, boolean confirm) {
        if (this.mService == null || this.mServerIf == 0) {
            return false;
        }
        BluetoothGattService service = characteristic.getService();
        if (service == null) {
            return false;
        }
        if (characteristic.getValue() == null) {
            throw new IllegalArgumentException("Chracteristic value is empty. Use BluetoothGattCharacteristic#setvalue to update");
        }
        try {
            this.mService.sendNotification(this.mServerIf, device.getAddress(), characteristic.getInstanceId(), confirm, characteristic.getValue());
        }
        catch (RemoteException e) {
            Log.e("BluetoothGattServer", "", e);
            return false;
        }
        return true;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothGattServer$addService(BluetoothGattService service) {
        Log.d("BluetoothGattServer", "addService() - service: " + service.getUuid());
        if (this.mService == null || this.mServerIf == 0) {
            return false;
        }
        this.mPendingService = service;
        try {
            this.mService.addService(this.mServerIf, service);
        }
        catch (RemoteException e) {
            Log.e("BluetoothGattServer", "", e);
            return false;
        }
        return true;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothGattServer$removeService(BluetoothGattService service) {
        Log.d("BluetoothGattServer", "removeService() - service: " + service.getUuid());
        if (this.mService == null || this.mServerIf == 0) {
            return false;
        }
        BluetoothGattService intService = this.getService(service.getUuid(), service.getInstanceId(), service.getType());
        if (intService == null) {
            return false;
        }
        try {
            this.mService.removeService(this.mServerIf, service.getInstanceId());
            this.mServices.remove(intService);
        }
        catch (RemoteException e) {
            Log.e("BluetoothGattServer", "", e);
            return false;
        }
        return true;
    }

    private final void $$robo$$android_bluetooth_BluetoothGattServer$clearServices() {
        Log.d("BluetoothGattServer", "clearServices()");
        if (this.mService == null || this.mServerIf == 0) {
            return;
        }
        try {
            this.mService.clearServices(this.mServerIf);
            this.mServices.clear();
        }
        catch (RemoteException e) {
            Log.e("BluetoothGattServer", "", e);
        }
    }

    private final List<BluetoothGattService> $$robo$$android_bluetooth_BluetoothGattServer$getServices() {
        return this.mServices;
    }

    private final BluetoothGattService $$robo$$android_bluetooth_BluetoothGattServer$getService(UUID uuid) {
        for (BluetoothGattService service : this.mServices) {
            if (!service.getUuid().equals(uuid)) continue;
            return service;
        }
        return null;
    }

    private final int $$robo$$android_bluetooth_BluetoothGattServer$getConnectionState(BluetoothDevice device) {
        throw new UnsupportedOperationException("Use BluetoothManager#getConnectionState instead.");
    }

    private final List<BluetoothDevice> $$robo$$android_bluetooth_BluetoothGattServer$getConnectedDevices() {
        throw new UnsupportedOperationException("Use BluetoothManager#getConnectedDevices instead.");
    }

    private final List<BluetoothDevice> $$robo$$android_bluetooth_BluetoothGattServer$getDevicesMatchingConnectionStates(int[] states) {
        throw new UnsupportedOperationException("Use BluetoothManager#getDevicesMatchingConnectionStates instead.");
    }

    private void __constructor__(IBluetoothGatt iBluetoothGatt, int n) {
        this.$$robo$$android_bluetooth_BluetoothGattServer$__constructor__(iBluetoothGatt, n);
    }

    BluetoothGattServer(IBluetoothGatt iBluetoothGatt, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothGattServer$__constructor__(android.bluetooth.IBluetoothGatt int ), 0, this, iBluetoothGatt, n);
    }

    BluetoothGattCharacteristic getCharacteristicByHandle(int n) {
        return InvokeDynamicSupport.bootstrap("getCharacteristicByHandle", $$robo$$android_bluetooth_BluetoothGattServer$getCharacteristicByHandle(int ), 0, this, n);
    }

    BluetoothGattDescriptor getDescriptorByHandle(int n) {
        return InvokeDynamicSupport.bootstrap("getDescriptorByHandle", $$robo$$android_bluetooth_BluetoothGattServer$getDescriptorByHandle(int ), 0, this, n);
    }

    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_bluetooth_BluetoothGattServer$close(), 0, this);
    }

    boolean registerCallback(BluetoothGattServerCallback bluetoothGattServerCallback) {
        return (boolean)InvokeDynamicSupport.bootstrap("registerCallback", $$robo$$android_bluetooth_BluetoothGattServer$registerCallback(android.bluetooth.BluetoothGattServerCallback ), 0, this, bluetoothGattServerCallback);
    }

    private void unregisterCallback() {
        InvokeDynamicSupport.bootstrap("unregisterCallback", $$robo$$android_bluetooth_BluetoothGattServer$unregisterCallback(), 0, this);
    }

    BluetoothGattService getService(UUID uUID, int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getService", $$robo$$android_bluetooth_BluetoothGattServer$getService(java.util.UUID int int ), 0, this, uUID, n, n2);
    }

    public boolean connect(BluetoothDevice bluetoothDevice, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("connect", $$robo$$android_bluetooth_BluetoothGattServer$connect(android.bluetooth.BluetoothDevice boolean ), 0, this, bluetoothDevice, bl);
    }

    public void cancelConnection(BluetoothDevice bluetoothDevice) {
        InvokeDynamicSupport.bootstrap("cancelConnection", $$robo$$android_bluetooth_BluetoothGattServer$cancelConnection(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    public void setPreferredPhy(BluetoothDevice bluetoothDevice, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("setPreferredPhy", $$robo$$android_bluetooth_BluetoothGattServer$setPreferredPhy(android.bluetooth.BluetoothDevice int int int ), 0, this, bluetoothDevice, n, n2, n3);
    }

    public void readPhy(BluetoothDevice bluetoothDevice) {
        InvokeDynamicSupport.bootstrap("readPhy", $$robo$$android_bluetooth_BluetoothGattServer$readPhy(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    public boolean sendResponse(BluetoothDevice bluetoothDevice, int n, int n2, int n3, byte[] byArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("sendResponse", $$robo$$android_bluetooth_BluetoothGattServer$sendResponse(android.bluetooth.BluetoothDevice int int int byte[] ), 0, this, bluetoothDevice, n, n2, n3, byArray);
    }

    public boolean notifyCharacteristicChanged(BluetoothDevice bluetoothDevice, BluetoothGattCharacteristic bluetoothGattCharacteristic, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("notifyCharacteristicChanged", $$robo$$android_bluetooth_BluetoothGattServer$notifyCharacteristicChanged(android.bluetooth.BluetoothDevice android.bluetooth.BluetoothGattCharacteristic boolean ), 0, this, bluetoothDevice, bluetoothGattCharacteristic, bl);
    }

    public boolean addService(BluetoothGattService bluetoothGattService) {
        return (boolean)InvokeDynamicSupport.bootstrap("addService", $$robo$$android_bluetooth_BluetoothGattServer$addService(android.bluetooth.BluetoothGattService ), 0, this, bluetoothGattService);
    }

    public boolean removeService(BluetoothGattService bluetoothGattService) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeService", $$robo$$android_bluetooth_BluetoothGattServer$removeService(android.bluetooth.BluetoothGattService ), 0, this, bluetoothGattService);
    }

    public void clearServices() {
        InvokeDynamicSupport.bootstrap("clearServices", $$robo$$android_bluetooth_BluetoothGattServer$clearServices(), 0, this);
    }

    public List<BluetoothGattService> getServices() {
        return InvokeDynamicSupport.bootstrap("getServices", $$robo$$android_bluetooth_BluetoothGattServer$getServices(), 0, this);
    }

    public BluetoothGattService getService(UUID uUID) {
        return InvokeDynamicSupport.bootstrap("getService", $$robo$$android_bluetooth_BluetoothGattServer$getService(java.util.UUID ), 0, this, uUID);
    }

    @Override
    public int getConnectionState(BluetoothDevice bluetoothDevice) {
        return (int)InvokeDynamicSupport.bootstrap("getConnectionState", $$robo$$android_bluetooth_BluetoothGattServer$getConnectionState(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    @Override
    public List<BluetoothDevice> getConnectedDevices() {
        return InvokeDynamicSupport.bootstrap("getConnectedDevices", $$robo$$android_bluetooth_BluetoothGattServer$getConnectedDevices(), 0, this);
    }

    @Override
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] nArray) {
        return InvokeDynamicSupport.bootstrap("getDevicesMatchingConnectionStates", $$robo$$android_bluetooth_BluetoothGattServer$getDevicesMatchingConnectionStates(int[] ), 0, this, nArray);
    }

    public /* synthetic */ BluetoothGattServer() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BluetoothGattServer)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

