/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.IBluetoothHeadset;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.IBluetoothProfileServiceConnection;
import android.bluetooth.IBluetoothStateChangeCallback;
import android.content.ComponentName;
import android.content.Context;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class BluetoothHeadset
implements BluetoothProfile,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "BluetoothHeadset";
    private static boolean DBG = true;
    private static boolean VDBG = false;
    public static String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED";
    public static String ACTION_AUDIO_STATE_CHANGED = "android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED";
    public static String ACTION_VENDOR_SPECIFIC_HEADSET_EVENT = "android.bluetooth.headset.action.VENDOR_SPECIFIC_HEADSET_EVENT";
    public static String EXTRA_VENDOR_SPECIFIC_HEADSET_EVENT_CMD = "android.bluetooth.headset.extra.VENDOR_SPECIFIC_HEADSET_EVENT_CMD";
    public static String EXTRA_VENDOR_SPECIFIC_HEADSET_EVENT_CMD_TYPE = "android.bluetooth.headset.extra.VENDOR_SPECIFIC_HEADSET_EVENT_CMD_TYPE";
    public static int AT_CMD_TYPE_READ = 0;
    public static int AT_CMD_TYPE_TEST = 1;
    public static int AT_CMD_TYPE_SET = 2;
    public static int AT_CMD_TYPE_BASIC = 3;
    public static int AT_CMD_TYPE_ACTION = 4;
    public static String EXTRA_VENDOR_SPECIFIC_HEADSET_EVENT_ARGS = "android.bluetooth.headset.extra.VENDOR_SPECIFIC_HEADSET_EVENT_ARGS";
    public static String VENDOR_SPECIFIC_HEADSET_EVENT_COMPANY_ID_CATEGORY = "android.bluetooth.headset.intent.category.companyid";
    public static String VENDOR_RESULT_CODE_COMMAND_ANDROID = "+ANDROID";
    public static String VENDOR_SPECIFIC_HEADSET_EVENT_XAPL = "+XAPL";
    public static String VENDOR_SPECIFIC_HEADSET_EVENT_IPHONEACCEV = "+IPHONEACCEV";
    public static int VENDOR_SPECIFIC_HEADSET_EVENT_IPHONEACCEV_BATTERY_LEVEL = 1;
    public static String VENDOR_SPECIFIC_HEADSET_EVENT_XEVENT = "+XEVENT";
    public static String VENDOR_SPECIFIC_HEADSET_EVENT_XEVENT_BATTERY_LEVEL = "BATTERY";
    public static int STATE_AUDIO_DISCONNECTED = 10;
    public static int STATE_AUDIO_CONNECTING = 11;
    public static String ACTION_HF_INDICATORS_VALUE_CHANGED = "android.bluetooth.headset.action.HF_INDICATORS_VALUE_CHANGED";
    public static String EXTRA_HF_INDICATORS_IND_ID = "android.bluetooth.headset.extra.HF_INDICATORS_IND_ID";
    public static String EXTRA_HF_INDICATORS_IND_VALUE = "android.bluetooth.headset.extra.HF_INDICATORS_IND_VALUE";
    public static int STATE_AUDIO_CONNECTED = 12;
    private static int MESSAGE_HEADSET_SERVICE_CONNECTED = 100;
    private static int MESSAGE_HEADSET_SERVICE_DISCONNECTED = 101;
    private Context mContext;
    private BluetoothProfile.ServiceListener mServiceListener;
    private volatile IBluetoothHeadset mService;
    private BluetoothAdapter mAdapter;
    private IBluetoothStateChangeCallback mBluetoothStateChangeCallback;
    private IBluetoothProfileServiceConnection mConnection;
    private Handler mHandler;

    private void $$robo$$android_bluetooth_BluetoothHeadset$__constructor__(Context context, BluetoothProfile.ServiceListener l) {
        this.mBluetoothStateChangeCallback = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ BluetoothHeadset this$0;

            private void $$robo$$android_bluetooth_BluetoothHeadset_1$__constructor__(BluetoothHeadset this$0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_BluetoothHeadset_1$onBluetoothStateChange(boolean up) {
                Log.d("BluetoothHeadset", "onBluetoothStateChange: up=" + up);
                if (!up) {
                    this.this$0.doUnbind();
                } else {
                    IBluetoothProfileServiceConnection iBluetoothProfileServiceConnection = this.this$0.mConnection;
                    synchronized (iBluetoothProfileServiceConnection) {
                        try {
                            if (this.this$0.mService == null) {
                                this.this$0.doBind();
                            }
                        }
                        catch (Exception re) {
                            Log.e("BluetoothHeadset", "", re);
                        }
                    }
                }
            }

            private void __constructor__(BluetoothHeadset bluetoothHeadset) {
                this.$$robo$$android_bluetooth_BluetoothHeadset_1$__constructor__(bluetoothHeadset);
            }
            {
                this.this$0 = bluetoothHeadset;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothHeadset_1$__constructor__(android.bluetooth.BluetoothHeadset ), 0, this, bluetoothHeadset);
            }

            @Override
            public void onBluetoothStateChange(boolean bl) {
                InvokeDynamicSupport.bootstrap("onBluetoothStateChange", $$robo$$android_bluetooth_BluetoothHeadset_1$onBluetoothStateChange(boolean ), 0, this, bl);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mConnection = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ BluetoothHeadset this$0;

            private void $$robo$$android_bluetooth_BluetoothHeadset_2$__constructor__(BluetoothHeadset this$0) {
            }

            private final void $$robo$$android_bluetooth_BluetoothHeadset_2$onServiceConnected(ComponentName className, IBinder service) {
                Log.d("BluetoothHeadset", "Proxy object connected");
                this.this$0.mService = IBluetoothHeadset.Stub.asInterface(Binder.allowBlocking(service));
                this.this$0.mHandler.sendMessage(this.this$0.mHandler.obtainMessage(100));
            }

            private final void $$robo$$android_bluetooth_BluetoothHeadset_2$onServiceDisconnected(ComponentName className) {
                Log.d("BluetoothHeadset", "Proxy object disconnected");
                this.this$0.mService = null;
                this.this$0.mHandler.sendMessage(this.this$0.mHandler.obtainMessage(101));
            }

            private void __constructor__(BluetoothHeadset bluetoothHeadset) {
                this.$$robo$$android_bluetooth_BluetoothHeadset_2$__constructor__(bluetoothHeadset);
            }
            {
                this.this$0 = bluetoothHeadset;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothHeadset_2$__constructor__(android.bluetooth.BluetoothHeadset ), 0, this, bluetoothHeadset);
            }

            @Override
            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                InvokeDynamicSupport.bootstrap("onServiceConnected", $$robo$$android_bluetooth_BluetoothHeadset_2$onServiceConnected(android.content.ComponentName android.os.IBinder ), 0, this, componentName, iBinder);
            }

            @Override
            public void onServiceDisconnected(ComponentName componentName) {
                InvokeDynamicSupport.bootstrap("onServiceDisconnected", $$robo$$android_bluetooth_BluetoothHeadset_2$onServiceDisconnected(android.content.ComponentName ), 0, this, componentName);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mHandler = new ShadowedObject(this, Looper.getMainLooper()){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ BluetoothHeadset this$0;

            private void $$robo$$android_bluetooth_BluetoothHeadset_3$__constructor__(BluetoothHeadset this$0, Looper looper) {
            }

            private final void $$robo$$android_bluetooth_BluetoothHeadset_3$handleMessage(Message msg) {
                switch (msg.what) {
                    case 100: {
                        if (this.this$0.mServiceListener == null) break;
                        this.this$0.mServiceListener.onServiceConnected(1, this.this$0);
                        break;
                    }
                    case 101: {
                        if (this.this$0.mServiceListener == null) break;
                        this.this$0.mServiceListener.onServiceDisconnected(1);
                    }
                }
            }

            private void __constructor__(BluetoothHeadset bluetoothHeadset, Looper looper) {
                this.$$robo$$android_bluetooth_BluetoothHeadset_3$__constructor__(bluetoothHeadset, looper);
            }
            {
                this.this$0 = bluetoothHeadset;
                super(looper);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothHeadset_3$__constructor__(android.bluetooth.BluetoothHeadset android.os.Looper ), 0, this, bluetoothHeadset, looper);
            }

            @Override
            public void handleMessage(Message message) {
                InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_bluetooth_BluetoothHeadset_3$handleMessage(android.os.Message ), 0, this, message);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mContext = context;
        this.mServiceListener = l;
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        IBluetoothManager mgr = this.mAdapter.getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.registerStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", "", e);
            }
        }
        this.doBind();
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadset$doBind() {
        try {
            return this.mAdapter.getBluetoothManager().bindBluetoothProfileService(1, this.mConnection);
        }
        catch (RemoteException e) {
            Log.e("BluetoothHeadset", "Unable to bind HeadsetService", e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_bluetooth_BluetoothHeadset$doUnbind() {
        IBluetoothProfileServiceConnection iBluetoothProfileServiceConnection = this.mConnection;
        synchronized (iBluetoothProfileServiceConnection) {
            if (this.mService != null) {
                try {
                    this.mAdapter.getBluetoothManager().unbindBluetoothProfileService(1, this.mConnection);
                }
                catch (RemoteException e) {
                    Log.e("BluetoothHeadset", "Unable to unbind HeadsetService", e);
                }
            }
        }
    }

    private final void $$robo$$android_bluetooth_BluetoothHeadset$close() {
        IBluetoothManager mgr = this.mAdapter.getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.unregisterStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (Exception e) {
                Log.e("BluetoothHeadset", "", e);
            }
        }
        this.mServiceListener = null;
        this.doUnbind();
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadset$connect(BluetoothDevice device) {
        BluetoothHeadset.log("connect(" + device + ")");
        IBluetoothHeadset service = this.mService;
        if (service != null && this.isEnabled() && BluetoothHeadset.isValidDevice(device)) {
            try {
                return service.connect(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (service == null) {
            Log.w("BluetoothHeadset", "Proxy not attached to service");
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadset$disconnect(BluetoothDevice device) {
        BluetoothHeadset.log("disconnect(" + device + ")");
        IBluetoothHeadset service = this.mService;
        if (service != null && this.isEnabled() && BluetoothHeadset.isValidDevice(device)) {
            try {
                return service.disconnect(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (service == null) {
            Log.w("BluetoothHeadset", "Proxy not attached to service");
        }
        return false;
    }

    private final List<BluetoothDevice> $$robo$$android_bluetooth_BluetoothHeadset$getConnectedDevices() {
        IBluetoothHeadset service = this.mService;
        if (service != null && this.isEnabled()) {
            try {
                return service.getConnectedDevices();
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", Log.getStackTraceString(new Throwable()));
                return new ArrayList<BluetoothDevice>();
            }
        }
        if (service == null) {
            Log.w("BluetoothHeadset", "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    private final List<BluetoothDevice> $$robo$$android_bluetooth_BluetoothHeadset$getDevicesMatchingConnectionStates(int[] states) {
        IBluetoothHeadset service = this.mService;
        if (service != null && this.isEnabled()) {
            try {
                return service.getDevicesMatchingConnectionStates(states);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", Log.getStackTraceString(new Throwable()));
                return new ArrayList<BluetoothDevice>();
            }
        }
        if (service == null) {
            Log.w("BluetoothHeadset", "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    private final int $$robo$$android_bluetooth_BluetoothHeadset$getConnectionState(BluetoothDevice device) {
        IBluetoothHeadset service = this.mService;
        if (service != null && this.isEnabled() && BluetoothHeadset.isValidDevice(device)) {
            try {
                return service.getConnectionState(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", Log.getStackTraceString(new Throwable()));
                return 0;
            }
        }
        if (service == null) {
            Log.w("BluetoothHeadset", "Proxy not attached to service");
        }
        return 0;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadset$setPriority(BluetoothDevice device, int priority) {
        BluetoothHeadset.log("setPriority(" + device + ", " + priority + ")");
        IBluetoothHeadset service = this.mService;
        if (service != null && this.isEnabled() && BluetoothHeadset.isValidDevice(device)) {
            if (priority != 0 && priority != 100) {
                return false;
            }
            try {
                return service.setPriority(device, priority);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (service == null) {
            Log.w("BluetoothHeadset", "Proxy not attached to service");
        }
        return false;
    }

    private final int $$robo$$android_bluetooth_BluetoothHeadset$getPriority(BluetoothDevice device) {
        IBluetoothHeadset service = this.mService;
        if (service != null && this.isEnabled() && BluetoothHeadset.isValidDevice(device)) {
            try {
                return service.getPriority(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", Log.getStackTraceString(new Throwable()));
                return 0;
            }
        }
        if (service == null) {
            Log.w("BluetoothHeadset", "Proxy not attached to service");
        }
        return 0;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadset$startVoiceRecognition(BluetoothDevice device) {
        BluetoothHeadset.log("startVoiceRecognition()");
        IBluetoothHeadset service = this.mService;
        if (service != null && this.isEnabled() && BluetoothHeadset.isValidDevice(device)) {
            try {
                return service.startVoiceRecognition(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", Log.getStackTraceString(new Throwable()));
            }
        }
        if (service == null) {
            Log.w("BluetoothHeadset", "Proxy not attached to service");
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadset$stopVoiceRecognition(BluetoothDevice device) {
        BluetoothHeadset.log("stopVoiceRecognition()");
        IBluetoothHeadset service = this.mService;
        if (service != null && this.isEnabled() && BluetoothHeadset.isValidDevice(device)) {
            try {
                return service.stopVoiceRecognition(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", Log.getStackTraceString(new Throwable()));
            }
        }
        if (service == null) {
            Log.w("BluetoothHeadset", "Proxy not attached to service");
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadset$isAudioConnected(BluetoothDevice device) {
        IBluetoothHeadset service = this.mService;
        if (service != null && this.isEnabled() && BluetoothHeadset.isValidDevice(device)) {
            try {
                return service.isAudioConnected(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", Log.getStackTraceString(new Throwable()));
            }
        }
        if (service == null) {
            Log.w("BluetoothHeadset", "Proxy not attached to service");
        }
        return false;
    }

    private final int $$robo$$android_bluetooth_BluetoothHeadset$getBatteryUsageHint(BluetoothDevice device) {
        IBluetoothHeadset service = this.mService;
        if (service != null && this.isEnabled() && BluetoothHeadset.isValidDevice(device)) {
            try {
                return service.getBatteryUsageHint(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", Log.getStackTraceString(new Throwable()));
            }
        }
        if (service == null) {
            Log.w("BluetoothHeadset", "Proxy not attached to service");
        }
        return -1;
    }

    private static final boolean $$robo$$android_bluetooth_BluetoothHeadset$isBluetoothVoiceDialingEnabled(Context context) {
        return context.getResources().getBoolean(17956903);
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadset$acceptIncomingConnect(BluetoothDevice device) {
        BluetoothHeadset.log("acceptIncomingConnect");
        IBluetoothHeadset service = this.mService;
        if (service != null && this.isEnabled()) {
            try {
                return service.acceptIncomingConnect(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", e.toString());
            }
        } else {
            Log.w("BluetoothHeadset", "Proxy not attached to service");
            Log.d("BluetoothHeadset", Log.getStackTraceString(new Throwable()));
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadset$rejectIncomingConnect(BluetoothDevice device) {
        BluetoothHeadset.log("rejectIncomingConnect");
        IBluetoothHeadset service = this.mService;
        if (service != null) {
            try {
                return service.rejectIncomingConnect(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", e.toString());
            }
        } else {
            Log.w("BluetoothHeadset", "Proxy not attached to service");
            Log.d("BluetoothHeadset", Log.getStackTraceString(new Throwable()));
        }
        return false;
    }

    private final int $$robo$$android_bluetooth_BluetoothHeadset$getAudioState(BluetoothDevice device) {
        IBluetoothHeadset service = this.mService;
        if (service != null && !this.isDisabled()) {
            try {
                return service.getAudioState(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", e.toString());
            }
        } else {
            Log.w("BluetoothHeadset", "Proxy not attached to service");
            Log.d("BluetoothHeadset", Log.getStackTraceString(new Throwable()));
        }
        return 10;
    }

    private final void $$robo$$android_bluetooth_BluetoothHeadset$setAudioRouteAllowed(boolean allowed) {
        IBluetoothHeadset service = this.mService;
        if (service != null && this.isEnabled()) {
            try {
                service.setAudioRouteAllowed(allowed);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", e.toString());
            }
        } else {
            Log.w("BluetoothHeadset", "Proxy not attached to service");
            Log.d("BluetoothHeadset", Log.getStackTraceString(new Throwable()));
        }
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadset$getAudioRouteAllowed() {
        IBluetoothHeadset service = this.mService;
        if (service != null && this.isEnabled()) {
            try {
                return service.getAudioRouteAllowed();
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", e.toString());
            }
        } else {
            Log.w("BluetoothHeadset", "Proxy not attached to service");
            Log.d("BluetoothHeadset", Log.getStackTraceString(new Throwable()));
        }
        return false;
    }

    private final void $$robo$$android_bluetooth_BluetoothHeadset$setForceScoAudio(boolean forced) {
        IBluetoothHeadset service = this.mService;
        if (service != null && this.isEnabled()) {
            try {
                service.setForceScoAudio(forced);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", e.toString());
            }
        } else {
            Log.w("BluetoothHeadset", "Proxy not attached to service");
            Log.d("BluetoothHeadset", Log.getStackTraceString(new Throwable()));
        }
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadset$isAudioOn() {
        IBluetoothHeadset service = this.mService;
        if (service != null && this.isEnabled()) {
            try {
                return service.isAudioOn();
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", Log.getStackTraceString(new Throwable()));
            }
        }
        if (service == null) {
            Log.w("BluetoothHeadset", "Proxy not attached to service");
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadset$connectAudio() {
        IBluetoothHeadset service = this.mService;
        if (service != null && this.isEnabled()) {
            try {
                return service.connectAudio();
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", e.toString());
            }
        } else {
            Log.w("BluetoothHeadset", "Proxy not attached to service");
            Log.d("BluetoothHeadset", Log.getStackTraceString(new Throwable()));
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadset$disconnectAudio() {
        IBluetoothHeadset service = this.mService;
        if (service != null && this.isEnabled()) {
            try {
                return service.disconnectAudio();
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", e.toString());
            }
        } else {
            Log.w("BluetoothHeadset", "Proxy not attached to service");
            Log.d("BluetoothHeadset", Log.getStackTraceString(new Throwable()));
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadset$startScoUsingVirtualVoiceCall(BluetoothDevice device) {
        BluetoothHeadset.log("startScoUsingVirtualVoiceCall()");
        IBluetoothHeadset service = this.mService;
        if (service != null && this.isEnabled() && BluetoothHeadset.isValidDevice(device)) {
            try {
                return service.startScoUsingVirtualVoiceCall(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", e.toString());
            }
        } else {
            Log.w("BluetoothHeadset", "Proxy not attached to service");
            Log.d("BluetoothHeadset", Log.getStackTraceString(new Throwable()));
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadset$stopScoUsingVirtualVoiceCall(BluetoothDevice device) {
        BluetoothHeadset.log("stopScoUsingVirtualVoiceCall()");
        IBluetoothHeadset service = this.mService;
        if (service != null && this.isEnabled() && BluetoothHeadset.isValidDevice(device)) {
            try {
                return service.stopScoUsingVirtualVoiceCall(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", e.toString());
            }
        } else {
            Log.w("BluetoothHeadset", "Proxy not attached to service");
            Log.d("BluetoothHeadset", Log.getStackTraceString(new Throwable()));
        }
        return false;
    }

    private final void $$robo$$android_bluetooth_BluetoothHeadset$phoneStateChanged(int numActive, int numHeld, int callState, String number, int type) {
        IBluetoothHeadset service = this.mService;
        if (service != null && this.isEnabled()) {
            try {
                service.phoneStateChanged(numActive, numHeld, callState, number, type);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", e.toString());
            }
        } else {
            Log.w("BluetoothHeadset", "Proxy not attached to service");
            Log.d("BluetoothHeadset", Log.getStackTraceString(new Throwable()));
        }
    }

    private final void $$robo$$android_bluetooth_BluetoothHeadset$clccResponse(int index, int direction, int status, int mode, boolean mpty, String number, int type) {
        IBluetoothHeadset service = this.mService;
        if (service != null && this.isEnabled()) {
            try {
                service.clccResponse(index, direction, status, mode, mpty, number, type);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", e.toString());
            }
        } else {
            Log.w("BluetoothHeadset", "Proxy not attached to service");
            Log.d("BluetoothHeadset", Log.getStackTraceString(new Throwable()));
        }
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadset$sendVendorSpecificResultCode(BluetoothDevice device, String command, String arg) {
        BluetoothHeadset.log("sendVendorSpecificResultCode()");
        if (command == null) {
            throw new IllegalArgumentException("command is null");
        }
        IBluetoothHeadset service = this.mService;
        if (service != null && this.isEnabled() && BluetoothHeadset.isValidDevice(device)) {
            try {
                return service.sendVendorSpecificResultCode(device, command, arg);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", Log.getStackTraceString(new Throwable()));
            }
        }
        if (service == null) {
            Log.w("BluetoothHeadset", "Proxy not attached to service");
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadset$enableWBS() {
        IBluetoothHeadset service = this.mService;
        if (service != null && this.isEnabled()) {
            try {
                return service.enableWBS();
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", e.toString());
            }
        } else {
            Log.w("BluetoothHeadset", "Proxy not attached to service");
            Log.d("BluetoothHeadset", Log.getStackTraceString(new Throwable()));
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadset$disableWBS() {
        IBluetoothHeadset service = this.mService;
        if (service != null && this.isEnabled()) {
            try {
                return service.disableWBS();
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", e.toString());
            }
        } else {
            Log.w("BluetoothHeadset", "Proxy not attached to service");
            Log.d("BluetoothHeadset", Log.getStackTraceString(new Throwable()));
        }
        return false;
    }

    private static final boolean $$robo$$android_bluetooth_BluetoothHeadset$isInbandRingingSupported(Context context) {
        return context.getResources().getBoolean(17956899);
    }

    private final void $$robo$$android_bluetooth_BluetoothHeadset$bindResponse(int indId, boolean indStatus) {
        IBluetoothHeadset service = this.mService;
        if (service != null && this.isEnabled()) {
            try {
                service.bindResponse(indId, indStatus);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHeadset", e.toString());
            }
        } else {
            Log.w("BluetoothHeadset", "Proxy not attached to service");
            Log.d("BluetoothHeadset", Log.getStackTraceString(new Throwable()));
        }
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadset$isEnabled() {
        return this.mAdapter.getState() == 12;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHeadset$isDisabled() {
        return this.mAdapter.getState() == 10;
    }

    private static final boolean $$robo$$android_bluetooth_BluetoothHeadset$isValidDevice(BluetoothDevice device) {
        return device != null && BluetoothAdapter.checkBluetoothAddress(device.getAddress());
    }

    private static final void $$robo$$android_bluetooth_BluetoothHeadset$log(String msg) {
        Log.d("BluetoothHeadset", msg);
    }

    private void __constructor__(Context context, BluetoothProfile.ServiceListener serviceListener) {
        this.$$robo$$android_bluetooth_BluetoothHeadset$__constructor__(context, serviceListener);
    }

    BluetoothHeadset(Context context, BluetoothProfile.ServiceListener serviceListener) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothHeadset$__constructor__(android.content.Context android.bluetooth.BluetoothProfile$ServiceListener ), 0, this, context, serviceListener);
    }

    boolean doBind() {
        return (boolean)InvokeDynamicSupport.bootstrap("doBind", $$robo$$android_bluetooth_BluetoothHeadset$doBind(), 0, this);
    }

    void doUnbind() {
        InvokeDynamicSupport.bootstrap("doUnbind", $$robo$$android_bluetooth_BluetoothHeadset$doUnbind(), 0, this);
    }

    void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_bluetooth_BluetoothHeadset$close(), 0, this);
    }

    public boolean connect(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("connect", $$robo$$android_bluetooth_BluetoothHeadset$connect(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    public boolean disconnect(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("disconnect", $$robo$$android_bluetooth_BluetoothHeadset$disconnect(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    @Override
    public List<BluetoothDevice> getConnectedDevices() {
        return InvokeDynamicSupport.bootstrap("getConnectedDevices", $$robo$$android_bluetooth_BluetoothHeadset$getConnectedDevices(), 0, this);
    }

    @Override
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] nArray) {
        return InvokeDynamicSupport.bootstrap("getDevicesMatchingConnectionStates", $$robo$$android_bluetooth_BluetoothHeadset$getDevicesMatchingConnectionStates(int[] ), 0, this, nArray);
    }

    @Override
    public int getConnectionState(BluetoothDevice bluetoothDevice) {
        return (int)InvokeDynamicSupport.bootstrap("getConnectionState", $$robo$$android_bluetooth_BluetoothHeadset$getConnectionState(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    public boolean setPriority(BluetoothDevice bluetoothDevice, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("setPriority", $$robo$$android_bluetooth_BluetoothHeadset$setPriority(android.bluetooth.BluetoothDevice int ), 0, this, bluetoothDevice, n);
    }

    public int getPriority(BluetoothDevice bluetoothDevice) {
        return (int)InvokeDynamicSupport.bootstrap("getPriority", $$robo$$android_bluetooth_BluetoothHeadset$getPriority(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    public boolean startVoiceRecognition(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("startVoiceRecognition", $$robo$$android_bluetooth_BluetoothHeadset$startVoiceRecognition(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    public boolean stopVoiceRecognition(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("stopVoiceRecognition", $$robo$$android_bluetooth_BluetoothHeadset$stopVoiceRecognition(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    public boolean isAudioConnected(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("isAudioConnected", $$robo$$android_bluetooth_BluetoothHeadset$isAudioConnected(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    public int getBatteryUsageHint(BluetoothDevice bluetoothDevice) {
        return (int)InvokeDynamicSupport.bootstrap("getBatteryUsageHint", $$robo$$android_bluetooth_BluetoothHeadset$getBatteryUsageHint(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    public static boolean isBluetoothVoiceDialingEnabled(Context context) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isBluetoothVoiceDialingEnabled", $$robo$$android_bluetooth_BluetoothHeadset$isBluetoothVoiceDialingEnabled(android.content.Context ), 0, (Context)context);
    }

    public boolean acceptIncomingConnect(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("acceptIncomingConnect", $$robo$$android_bluetooth_BluetoothHeadset$acceptIncomingConnect(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    public boolean rejectIncomingConnect(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("rejectIncomingConnect", $$robo$$android_bluetooth_BluetoothHeadset$rejectIncomingConnect(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    public int getAudioState(BluetoothDevice bluetoothDevice) {
        return (int)InvokeDynamicSupport.bootstrap("getAudioState", $$robo$$android_bluetooth_BluetoothHeadset$getAudioState(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    public void setAudioRouteAllowed(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAudioRouteAllowed", $$robo$$android_bluetooth_BluetoothHeadset$setAudioRouteAllowed(boolean ), 0, this, bl);
    }

    public boolean getAudioRouteAllowed() {
        return (boolean)InvokeDynamicSupport.bootstrap("getAudioRouteAllowed", $$robo$$android_bluetooth_BluetoothHeadset$getAudioRouteAllowed(), 0, this);
    }

    public void setForceScoAudio(boolean bl) {
        InvokeDynamicSupport.bootstrap("setForceScoAudio", $$robo$$android_bluetooth_BluetoothHeadset$setForceScoAudio(boolean ), 0, this, bl);
    }

    public boolean isAudioOn() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAudioOn", $$robo$$android_bluetooth_BluetoothHeadset$isAudioOn(), 0, this);
    }

    public boolean connectAudio() {
        return (boolean)InvokeDynamicSupport.bootstrap("connectAudio", $$robo$$android_bluetooth_BluetoothHeadset$connectAudio(), 0, this);
    }

    public boolean disconnectAudio() {
        return (boolean)InvokeDynamicSupport.bootstrap("disconnectAudio", $$robo$$android_bluetooth_BluetoothHeadset$disconnectAudio(), 0, this);
    }

    public boolean startScoUsingVirtualVoiceCall(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("startScoUsingVirtualVoiceCall", $$robo$$android_bluetooth_BluetoothHeadset$startScoUsingVirtualVoiceCall(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    public boolean stopScoUsingVirtualVoiceCall(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("stopScoUsingVirtualVoiceCall", $$robo$$android_bluetooth_BluetoothHeadset$stopScoUsingVirtualVoiceCall(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    public void phoneStateChanged(int n, int n2, int n3, String string2, int n4) {
        InvokeDynamicSupport.bootstrap("phoneStateChanged", $$robo$$android_bluetooth_BluetoothHeadset$phoneStateChanged(int int int java.lang.String int ), 0, this, n, n2, n3, string2, n4);
    }

    public void clccResponse(int n, int n2, int n3, int n4, boolean bl, String string2, int n5) {
        InvokeDynamicSupport.bootstrap("clccResponse", $$robo$$android_bluetooth_BluetoothHeadset$clccResponse(int int int int boolean java.lang.String int ), 0, this, n, n2, n3, n4, bl, string2, n5);
    }

    public boolean sendVendorSpecificResultCode(BluetoothDevice bluetoothDevice, String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrap("sendVendorSpecificResultCode", $$robo$$android_bluetooth_BluetoothHeadset$sendVendorSpecificResultCode(android.bluetooth.BluetoothDevice java.lang.String java.lang.String ), 0, this, bluetoothDevice, string2, string3);
    }

    public boolean enableWBS() {
        return (boolean)InvokeDynamicSupport.bootstrap("enableWBS", $$robo$$android_bluetooth_BluetoothHeadset$enableWBS(), 0, this);
    }

    public boolean disableWBS() {
        return (boolean)InvokeDynamicSupport.bootstrap("disableWBS", $$robo$$android_bluetooth_BluetoothHeadset$disableWBS(), 0, this);
    }

    public static boolean isInbandRingingSupported(Context context) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isInbandRingingSupported", $$robo$$android_bluetooth_BluetoothHeadset$isInbandRingingSupported(android.content.Context ), 0, (Context)context);
    }

    public void bindResponse(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("bindResponse", $$robo$$android_bluetooth_BluetoothHeadset$bindResponse(int boolean ), 0, this, n, bl);
    }

    private boolean isEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$android_bluetooth_BluetoothHeadset$isEnabled(), 0, this);
    }

    private boolean isDisabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDisabled", $$robo$$android_bluetooth_BluetoothHeadset$isDisabled(), 0, this);
    }

    private static boolean isValidDevice(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidDevice", $$robo$$android_bluetooth_BluetoothHeadset$isValidDevice(android.bluetooth.BluetoothDevice ), 0, (BluetoothDevice)bluetoothDevice);
    }

    private static void log(String string2) {
        InvokeDynamicSupport.bootstrapStatic("log", $$robo$$android_bluetooth_BluetoothHeadset$log(java.lang.String ), 0, (String)string2);
    }

    public /* synthetic */ BluetoothHeadset() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BluetoothHeadset)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

