/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.IBluetoothInputDevice;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.IBluetoothStateChangeCallback;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Binder;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class BluetoothInputDevice
implements BluetoothProfile,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "BluetoothInputDevice";
    private static boolean DBG = true;
    private static boolean VDBG = false;
    public static String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.input.profile.action.CONNECTION_STATE_CHANGED";
    public static String ACTION_PROTOCOL_MODE_CHANGED = "android.bluetooth.input.profile.action.PROTOCOL_MODE_CHANGED";
    public static String ACTION_HANDSHAKE = "android.bluetooth.input.profile.action.HANDSHAKE";
    public static String ACTION_REPORT = "android.bluetooth.input.profile.action.REPORT";
    public static String ACTION_VIRTUAL_UNPLUG_STATUS = "android.bluetooth.input.profile.action.VIRTUAL_UNPLUG_STATUS";
    public static String ACTION_IDLE_TIME_CHANGED = "android.bluetooth.input.profile.action.IDLE_TIME_CHANGED";
    public static int INPUT_DISCONNECT_FAILED_NOT_CONNECTED = 5000;
    public static int INPUT_CONNECT_FAILED_ALREADY_CONNECTED = 5001;
    public static int INPUT_CONNECT_FAILED_ATTEMPT_FAILED = 5002;
    public static int INPUT_OPERATION_GENERIC_FAILURE = 5003;
    public static int INPUT_OPERATION_SUCCESS = 5004;
    public static int PROTOCOL_REPORT_MODE = 0;
    public static int PROTOCOL_BOOT_MODE = 1;
    public static int PROTOCOL_UNSUPPORTED_MODE = 255;
    public static byte REPORT_TYPE_INPUT = 1;
    public static byte REPORT_TYPE_OUTPUT = 2;
    public static byte REPORT_TYPE_FEATURE = 3;
    public static int VIRTUAL_UNPLUG_STATUS_SUCCESS = 0;
    public static int VIRTUAL_UNPLUG_STATUS_FAIL = 1;
    public static String EXTRA_PROTOCOL_MODE = "android.bluetooth.BluetoothInputDevice.extra.PROTOCOL_MODE";
    public static String EXTRA_REPORT_TYPE = "android.bluetooth.BluetoothInputDevice.extra.REPORT_TYPE";
    public static String EXTRA_REPORT_ID = "android.bluetooth.BluetoothInputDevice.extra.REPORT_ID";
    public static String EXTRA_REPORT_BUFFER_SIZE = "android.bluetooth.BluetoothInputDevice.extra.REPORT_BUFFER_SIZE";
    public static String EXTRA_REPORT = "android.bluetooth.BluetoothInputDevice.extra.REPORT";
    public static String EXTRA_STATUS = "android.bluetooth.BluetoothInputDevice.extra.STATUS";
    public static String EXTRA_VIRTUAL_UNPLUG_STATUS = "android.bluetooth.BluetoothInputDevice.extra.VIRTUAL_UNPLUG_STATUS";
    public static String EXTRA_IDLE_TIME = "android.bluetooth.BluetoothInputDevice.extra.IDLE_TIME";
    private Context mContext;
    private BluetoothProfile.ServiceListener mServiceListener;
    private BluetoothAdapter mAdapter;
    private volatile IBluetoothInputDevice mService;
    private IBluetoothStateChangeCallback mBluetoothStateChangeCallback;
    private ServiceConnection mConnection;

    private void $$robo$$android_bluetooth_BluetoothInputDevice$__constructor__(Context context, BluetoothProfile.ServiceListener l) {
        this.mBluetoothStateChangeCallback = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ BluetoothInputDevice this$0;

            private void $$robo$$android_bluetooth_BluetoothInputDevice_1$__constructor__(BluetoothInputDevice this$0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_BluetoothInputDevice_1$onBluetoothStateChange(boolean up) {
                Log.d("BluetoothInputDevice", "onBluetoothStateChange: up=" + up);
                if (!up) {
                    ServiceConnection serviceConnection = this.this$0.mConnection;
                    synchronized (serviceConnection) {
                        try {
                            this.this$0.mService = null;
                            this.this$0.mContext.unbindService(this.this$0.mConnection);
                        }
                        catch (Exception re) {
                            Log.e("BluetoothInputDevice", "", re);
                        }
                    }
                }
                ServiceConnection serviceConnection = this.this$0.mConnection;
                synchronized (serviceConnection) {
                    try {
                        if (this.this$0.mService == null) {
                            this.this$0.doBind();
                        }
                    }
                    catch (Exception re) {
                        Log.e("BluetoothInputDevice", "", re);
                    }
                }
            }

            private void __constructor__(BluetoothInputDevice bluetoothInputDevice) {
                this.$$robo$$android_bluetooth_BluetoothInputDevice_1$__constructor__(bluetoothInputDevice);
            }
            {
                this.this$0 = bluetoothInputDevice;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothInputDevice_1$__constructor__(android.bluetooth.BluetoothInputDevice ), 0, this, bluetoothInputDevice);
            }

            @Override
            public void onBluetoothStateChange(boolean bl) {
                InvokeDynamicSupport.bootstrap("onBluetoothStateChange", $$robo$$android_bluetooth_BluetoothInputDevice_1$onBluetoothStateChange(boolean ), 0, this, bl);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mConnection = new ServiceConnection(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ BluetoothInputDevice this$0;

            private void $$robo$$android_bluetooth_BluetoothInputDevice_2$__constructor__(BluetoothInputDevice this$0) {
            }

            private final void $$robo$$android_bluetooth_BluetoothInputDevice_2$onServiceConnected(ComponentName className, IBinder service) {
                Log.d("BluetoothInputDevice", "Proxy object connected");
                this.this$0.mService = IBluetoothInputDevice.Stub.asInterface(Binder.allowBlocking(service));
                if (this.this$0.mServiceListener != null) {
                    this.this$0.mServiceListener.onServiceConnected(4, this.this$0);
                }
            }

            private final void $$robo$$android_bluetooth_BluetoothInputDevice_2$onServiceDisconnected(ComponentName className) {
                Log.d("BluetoothInputDevice", "Proxy object disconnected");
                this.this$0.mService = null;
                if (this.this$0.mServiceListener != null) {
                    this.this$0.mServiceListener.onServiceDisconnected(4);
                }
            }

            private void __constructor__(BluetoothInputDevice bluetoothInputDevice) {
                this.$$robo$$android_bluetooth_BluetoothInputDevice_2$__constructor__(bluetoothInputDevice);
            }
            {
                this.this$0 = bluetoothInputDevice;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothInputDevice_2$__constructor__(android.bluetooth.BluetoothInputDevice ), 0, this, bluetoothInputDevice);
            }

            @Override
            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                InvokeDynamicSupport.bootstrap("onServiceConnected", $$robo$$android_bluetooth_BluetoothInputDevice_2$onServiceConnected(android.content.ComponentName android.os.IBinder ), 0, this, componentName, iBinder);
            }

            @Override
            public void onServiceDisconnected(ComponentName componentName) {
                InvokeDynamicSupport.bootstrap("onServiceDisconnected", $$robo$$android_bluetooth_BluetoothInputDevice_2$onServiceDisconnected(android.content.ComponentName ), 0, this, componentName);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mContext = context;
        this.mServiceListener = l;
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        IBluetoothManager mgr = this.mAdapter.getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.registerStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (RemoteException e) {
                Log.e("BluetoothInputDevice", "", e);
            }
        }
        this.doBind();
    }

    private final boolean $$robo$$android_bluetooth_BluetoothInputDevice$doBind() {
        Intent intent = new Intent(IBluetoothInputDevice.class.getName());
        ComponentName comp = intent.resolveSystemService(this.mContext.getPackageManager(), 0);
        intent.setComponent(comp);
        if (comp == null || !this.mContext.bindServiceAsUser(intent, this.mConnection, 0, Process.myUserHandle())) {
            Log.e("BluetoothInputDevice", "Could not bind to Bluetooth HID Service with " + intent);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_bluetooth_BluetoothInputDevice$close() {
        IBluetoothManager mgr = this.mAdapter.getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.unregisterStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (Exception e) {
                Log.e("BluetoothInputDevice", "", e);
            }
        }
        ServiceConnection serviceConnection = this.mConnection;
        synchronized (serviceConnection) {
            if (this.mService != null) {
                try {
                    this.mService = null;
                    this.mContext.unbindService(this.mConnection);
                }
                catch (Exception re) {
                    Log.e("BluetoothInputDevice", "", re);
                }
            }
        }
        this.mServiceListener = null;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothInputDevice$connect(BluetoothDevice device) {
        BluetoothInputDevice.log("connect(" + device + ")");
        IBluetoothInputDevice service = this.mService;
        if (service != null && this.isEnabled() && BluetoothInputDevice.isValidDevice(device)) {
            try {
                return service.connect(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothInputDevice", "Stack:" + Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (service == null) {
            Log.w("BluetoothInputDevice", "Proxy not attached to service");
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothInputDevice$disconnect(BluetoothDevice device) {
        BluetoothInputDevice.log("disconnect(" + device + ")");
        IBluetoothInputDevice service = this.mService;
        if (service != null && this.isEnabled() && BluetoothInputDevice.isValidDevice(device)) {
            try {
                return service.disconnect(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothInputDevice", "Stack:" + Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (service == null) {
            Log.w("BluetoothInputDevice", "Proxy not attached to service");
        }
        return false;
    }

    private final List<BluetoothDevice> $$robo$$android_bluetooth_BluetoothInputDevice$getConnectedDevices() {
        IBluetoothInputDevice service = this.mService;
        if (service != null && this.isEnabled()) {
            try {
                return service.getConnectedDevices();
            }
            catch (RemoteException e) {
                Log.e("BluetoothInputDevice", "Stack:" + Log.getStackTraceString(new Throwable()));
                return new ArrayList<BluetoothDevice>();
            }
        }
        if (service == null) {
            Log.w("BluetoothInputDevice", "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    private final List<BluetoothDevice> $$robo$$android_bluetooth_BluetoothInputDevice$getDevicesMatchingConnectionStates(int[] states) {
        IBluetoothInputDevice service = this.mService;
        if (service != null && this.isEnabled()) {
            try {
                return service.getDevicesMatchingConnectionStates(states);
            }
            catch (RemoteException e) {
                Log.e("BluetoothInputDevice", "Stack:" + Log.getStackTraceString(new Throwable()));
                return new ArrayList<BluetoothDevice>();
            }
        }
        if (service == null) {
            Log.w("BluetoothInputDevice", "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    private final int $$robo$$android_bluetooth_BluetoothInputDevice$getConnectionState(BluetoothDevice device) {
        IBluetoothInputDevice service = this.mService;
        if (service != null && this.isEnabled() && BluetoothInputDevice.isValidDevice(device)) {
            try {
                return service.getConnectionState(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothInputDevice", "Stack:" + Log.getStackTraceString(new Throwable()));
                return 0;
            }
        }
        if (service == null) {
            Log.w("BluetoothInputDevice", "Proxy not attached to service");
        }
        return 0;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothInputDevice$setPriority(BluetoothDevice device, int priority) {
        BluetoothInputDevice.log("setPriority(" + device + ", " + priority + ")");
        IBluetoothInputDevice service = this.mService;
        if (service != null && this.isEnabled() && BluetoothInputDevice.isValidDevice(device)) {
            if (priority != 0 && priority != 100) {
                return false;
            }
            try {
                return service.setPriority(device, priority);
            }
            catch (RemoteException e) {
                Log.e("BluetoothInputDevice", "Stack:" + Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (service == null) {
            Log.w("BluetoothInputDevice", "Proxy not attached to service");
        }
        return false;
    }

    private final int $$robo$$android_bluetooth_BluetoothInputDevice$getPriority(BluetoothDevice device) {
        IBluetoothInputDevice service = this.mService;
        if (service != null && this.isEnabled() && BluetoothInputDevice.isValidDevice(device)) {
            try {
                return service.getPriority(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothInputDevice", "Stack:" + Log.getStackTraceString(new Throwable()));
                return 0;
            }
        }
        if (service == null) {
            Log.w("BluetoothInputDevice", "Proxy not attached to service");
        }
        return 0;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothInputDevice$isEnabled() {
        return this.mAdapter.getState() == 12;
    }

    private static final boolean $$robo$$android_bluetooth_BluetoothInputDevice$isValidDevice(BluetoothDevice device) {
        return device != null && BluetoothAdapter.checkBluetoothAddress(device.getAddress());
    }

    private final boolean $$robo$$android_bluetooth_BluetoothInputDevice$virtualUnplug(BluetoothDevice device) {
        BluetoothInputDevice.log("virtualUnplug(" + device + ")");
        IBluetoothInputDevice service = this.mService;
        if (service != null && this.isEnabled() && BluetoothInputDevice.isValidDevice(device)) {
            try {
                return service.virtualUnplug(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothInputDevice", "Stack:" + Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (service == null) {
            Log.w("BluetoothInputDevice", "Proxy not attached to service");
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothInputDevice$getProtocolMode(BluetoothDevice device) {
        IBluetoothInputDevice service = this.mService;
        if (service != null && this.isEnabled() && BluetoothInputDevice.isValidDevice(device)) {
            try {
                return service.getProtocolMode(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothInputDevice", "Stack:" + Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (service == null) {
            Log.w("BluetoothInputDevice", "Proxy not attached to service");
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothInputDevice$setProtocolMode(BluetoothDevice device, int protocolMode) {
        BluetoothInputDevice.log("setProtocolMode(" + device + ")");
        IBluetoothInputDevice service = this.mService;
        if (service != null && this.isEnabled() && BluetoothInputDevice.isValidDevice(device)) {
            try {
                return service.setProtocolMode(device, protocolMode);
            }
            catch (RemoteException e) {
                Log.e("BluetoothInputDevice", "Stack:" + Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (service == null) {
            Log.w("BluetoothInputDevice", "Proxy not attached to service");
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothInputDevice$getReport(BluetoothDevice device, byte reportType, byte reportId, int bufferSize) {
        IBluetoothInputDevice service = this.mService;
        if (service != null && this.isEnabled() && BluetoothInputDevice.isValidDevice(device)) {
            try {
                return service.getReport(device, reportType, reportId, bufferSize);
            }
            catch (RemoteException e) {
                Log.e("BluetoothInputDevice", "Stack:" + Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (service == null) {
            Log.w("BluetoothInputDevice", "Proxy not attached to service");
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothInputDevice$setReport(BluetoothDevice device, byte reportType, String report) {
        IBluetoothInputDevice service = this.mService;
        if (service != null && this.isEnabled() && BluetoothInputDevice.isValidDevice(device)) {
            try {
                return service.setReport(device, reportType, report);
            }
            catch (RemoteException e) {
                Log.e("BluetoothInputDevice", "Stack:" + Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (service == null) {
            Log.w("BluetoothInputDevice", "Proxy not attached to service");
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothInputDevice$sendData(BluetoothDevice device, String report) {
        BluetoothInputDevice.log("sendData(" + device + "), report=" + report);
        IBluetoothInputDevice service = this.mService;
        if (service != null && this.isEnabled() && BluetoothInputDevice.isValidDevice(device)) {
            try {
                return service.sendData(device, report);
            }
            catch (RemoteException e) {
                Log.e("BluetoothInputDevice", "Stack:" + Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (service == null) {
            Log.w("BluetoothInputDevice", "Proxy not attached to service");
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothInputDevice$getIdleTime(BluetoothDevice device) {
        BluetoothInputDevice.log("getIdletime(" + device + ")");
        IBluetoothInputDevice service = this.mService;
        if (service != null && this.isEnabled() && BluetoothInputDevice.isValidDevice(device)) {
            try {
                return service.getIdleTime(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothInputDevice", "Stack:" + Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (service == null) {
            Log.w("BluetoothInputDevice", "Proxy not attached to service");
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothInputDevice$setIdleTime(BluetoothDevice device, byte idleTime) {
        BluetoothInputDevice.log("setIdletime(" + device + "), idleTime=" + idleTime);
        IBluetoothInputDevice service = this.mService;
        if (service != null && this.isEnabled() && BluetoothInputDevice.isValidDevice(device)) {
            try {
                return service.setIdleTime(device, idleTime);
            }
            catch (RemoteException e) {
                Log.e("BluetoothInputDevice", "Stack:" + Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (service == null) {
            Log.w("BluetoothInputDevice", "Proxy not attached to service");
        }
        return false;
    }

    private static final void $$robo$$android_bluetooth_BluetoothInputDevice$log(String msg) {
        Log.d("BluetoothInputDevice", msg);
    }

    private void __constructor__(Context context, BluetoothProfile.ServiceListener serviceListener) {
        this.$$robo$$android_bluetooth_BluetoothInputDevice$__constructor__(context, serviceListener);
    }

    BluetoothInputDevice(Context context, BluetoothProfile.ServiceListener serviceListener) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothInputDevice$__constructor__(android.content.Context android.bluetooth.BluetoothProfile$ServiceListener ), 0, this, context, serviceListener);
    }

    boolean doBind() {
        return (boolean)InvokeDynamicSupport.bootstrap("doBind", $$robo$$android_bluetooth_BluetoothInputDevice$doBind(), 0, this);
    }

    void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_bluetooth_BluetoothInputDevice$close(), 0, this);
    }

    public boolean connect(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("connect", $$robo$$android_bluetooth_BluetoothInputDevice$connect(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    public boolean disconnect(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("disconnect", $$robo$$android_bluetooth_BluetoothInputDevice$disconnect(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    @Override
    public List<BluetoothDevice> getConnectedDevices() {
        return InvokeDynamicSupport.bootstrap("getConnectedDevices", $$robo$$android_bluetooth_BluetoothInputDevice$getConnectedDevices(), 0, this);
    }

    @Override
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] nArray) {
        return InvokeDynamicSupport.bootstrap("getDevicesMatchingConnectionStates", $$robo$$android_bluetooth_BluetoothInputDevice$getDevicesMatchingConnectionStates(int[] ), 0, this, nArray);
    }

    @Override
    public int getConnectionState(BluetoothDevice bluetoothDevice) {
        return (int)InvokeDynamicSupport.bootstrap("getConnectionState", $$robo$$android_bluetooth_BluetoothInputDevice$getConnectionState(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    public boolean setPriority(BluetoothDevice bluetoothDevice, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("setPriority", $$robo$$android_bluetooth_BluetoothInputDevice$setPriority(android.bluetooth.BluetoothDevice int ), 0, this, bluetoothDevice, n);
    }

    public int getPriority(BluetoothDevice bluetoothDevice) {
        return (int)InvokeDynamicSupport.bootstrap("getPriority", $$robo$$android_bluetooth_BluetoothInputDevice$getPriority(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    private boolean isEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$android_bluetooth_BluetoothInputDevice$isEnabled(), 0, this);
    }

    private static boolean isValidDevice(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidDevice", $$robo$$android_bluetooth_BluetoothInputDevice$isValidDevice(android.bluetooth.BluetoothDevice ), 0, (BluetoothDevice)bluetoothDevice);
    }

    public boolean virtualUnplug(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("virtualUnplug", $$robo$$android_bluetooth_BluetoothInputDevice$virtualUnplug(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    public boolean getProtocolMode(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("getProtocolMode", $$robo$$android_bluetooth_BluetoothInputDevice$getProtocolMode(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    public boolean setProtocolMode(BluetoothDevice bluetoothDevice, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("setProtocolMode", $$robo$$android_bluetooth_BluetoothInputDevice$setProtocolMode(android.bluetooth.BluetoothDevice int ), 0, this, bluetoothDevice, n);
    }

    public boolean getReport(BluetoothDevice bluetoothDevice, byte by, byte by2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("getReport", $$robo$$android_bluetooth_BluetoothInputDevice$getReport(android.bluetooth.BluetoothDevice byte byte int ), 0, this, bluetoothDevice, by, by2, n);
    }

    public boolean setReport(BluetoothDevice bluetoothDevice, byte by, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setReport", $$robo$$android_bluetooth_BluetoothInputDevice$setReport(android.bluetooth.BluetoothDevice byte java.lang.String ), 0, this, bluetoothDevice, by, string2);
    }

    public boolean sendData(BluetoothDevice bluetoothDevice, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("sendData", $$robo$$android_bluetooth_BluetoothInputDevice$sendData(android.bluetooth.BluetoothDevice java.lang.String ), 0, this, bluetoothDevice, string2);
    }

    public boolean getIdleTime(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("getIdleTime", $$robo$$android_bluetooth_BluetoothInputDevice$getIdleTime(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    public boolean setIdleTime(BluetoothDevice bluetoothDevice, byte by) {
        return (boolean)InvokeDynamicSupport.bootstrap("setIdleTime", $$robo$$android_bluetooth_BluetoothInputDevice$setIdleTime(android.bluetooth.BluetoothDevice byte ), 0, this, bluetoothDevice, by);
    }

    private static void log(String string2) {
        InvokeDynamicSupport.bootstrapStatic("log", $$robo$$android_bluetooth_BluetoothInputDevice$log(java.lang.String ), 0, (String)string2);
    }

    public /* synthetic */ BluetoothInputDevice() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BluetoothInputDevice)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

