/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGattServer;
import android.bluetooth.BluetoothGattServerCallback;
import android.bluetooth.IBluetoothGatt;
import android.bluetooth.IBluetoothManager;
import android.content.Context;
import android.os.RemoteException;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class BluetoothManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "BluetoothManager";
    private static boolean DBG = true;
    private static boolean VDBG = true;
    private BluetoothAdapter mAdapter;

    private void $$robo$$android_bluetooth_BluetoothManager$__constructor__(Context context) {
        if ((context = context.getApplicationContext()) == null) {
            throw new IllegalArgumentException("context not associated with any application (using a mock context?)");
        }
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
    }

    private final BluetoothAdapter $$robo$$android_bluetooth_BluetoothManager$getAdapter() {
        return this.mAdapter;
    }

    private final int $$robo$$android_bluetooth_BluetoothManager$getConnectionState(BluetoothDevice device, int profile) {
        Log.d("BluetoothManager", "getConnectionState()");
        List<BluetoothDevice> connectedDevices = this.getConnectedDevices(profile);
        for (BluetoothDevice connectedDevice : connectedDevices) {
            if (!device.equals(connectedDevice)) continue;
            return 2;
        }
        return 0;
    }

    private final List<BluetoothDevice> $$robo$$android_bluetooth_BluetoothManager$getConnectedDevices(int profile) {
        Log.d("BluetoothManager", "getConnectedDevices");
        if (profile != 7 && profile != 8) {
            throw new IllegalArgumentException("Profile not supported: " + profile);
        }
        List<BluetoothDevice> connectedDevices = new ArrayList<BluetoothDevice>();
        try {
            IBluetoothManager managerService = this.mAdapter.getBluetoothManager();
            IBluetoothGatt iGatt = managerService.getBluetoothGatt();
            if (iGatt == null) {
                return connectedDevices;
            }
            connectedDevices = iGatt.getDevicesMatchingConnectionStates(new int[]{2});
        }
        catch (RemoteException e) {
            Log.e("BluetoothManager", "", e);
        }
        return connectedDevices;
    }

    private final List<BluetoothDevice> $$robo$$android_bluetooth_BluetoothManager$getDevicesMatchingConnectionStates(int profile, int[] states) {
        Log.d("BluetoothManager", "getDevicesMatchingConnectionStates");
        if (profile != 7 && profile != 8) {
            throw new IllegalArgumentException("Profile not supported: " + profile);
        }
        List<BluetoothDevice> devices = new ArrayList<BluetoothDevice>();
        try {
            IBluetoothManager managerService = this.mAdapter.getBluetoothManager();
            IBluetoothGatt iGatt = managerService.getBluetoothGatt();
            if (iGatt == null) {
                return devices;
            }
            devices = iGatt.getDevicesMatchingConnectionStates(states);
        }
        catch (RemoteException e) {
            Log.e("BluetoothManager", "", e);
        }
        return devices;
    }

    private final BluetoothGattServer $$robo$$android_bluetooth_BluetoothManager$openGattServer(Context context, BluetoothGattServerCallback callback) {
        return this.openGattServer(context, callback, 0);
    }

    private final BluetoothGattServer $$robo$$android_bluetooth_BluetoothManager$openGattServer(Context context, BluetoothGattServerCallback callback, int transport) {
        if (context == null || callback == null) {
            throw new IllegalArgumentException("null parameter: " + context + " " + callback);
        }
        try {
            IBluetoothManager managerService = this.mAdapter.getBluetoothManager();
            IBluetoothGatt iGatt = managerService.getBluetoothGatt();
            if (iGatt == null) {
                Log.e("BluetoothManager", "Fail to get GATT Server connection");
                return null;
            }
            BluetoothGattServer mGattServer = new BluetoothGattServer(iGatt, transport);
            Boolean regStatus = mGattServer.registerCallback(callback);
            return regStatus != false ? mGattServer : null;
        }
        catch (RemoteException e) {
            Log.e("BluetoothManager", "", e);
            return null;
        }
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_bluetooth_BluetoothManager$__constructor__(context);
    }

    public BluetoothManager(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothManager$__constructor__(android.content.Context ), 0, this, context);
    }

    public BluetoothAdapter getAdapter() {
        return InvokeDynamicSupport.bootstrap("getAdapter", $$robo$$android_bluetooth_BluetoothManager$getAdapter(), 0, this);
    }

    public int getConnectionState(BluetoothDevice bluetoothDevice, int n) {
        return (int)InvokeDynamicSupport.bootstrap("getConnectionState", $$robo$$android_bluetooth_BluetoothManager$getConnectionState(android.bluetooth.BluetoothDevice int ), 0, this, bluetoothDevice, n);
    }

    public List<BluetoothDevice> getConnectedDevices(int n) {
        return InvokeDynamicSupport.bootstrap("getConnectedDevices", $$robo$$android_bluetooth_BluetoothManager$getConnectedDevices(int ), 0, this, n);
    }

    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int n, int[] nArray) {
        return InvokeDynamicSupport.bootstrap("getDevicesMatchingConnectionStates", $$robo$$android_bluetooth_BluetoothManager$getDevicesMatchingConnectionStates(int int[] ), 0, this, n, nArray);
    }

    public BluetoothGattServer openGattServer(Context context, BluetoothGattServerCallback bluetoothGattServerCallback) {
        return InvokeDynamicSupport.bootstrap("openGattServer", $$robo$$android_bluetooth_BluetoothManager$openGattServer(android.content.Context android.bluetooth.BluetoothGattServerCallback ), 0, this, context, bluetoothGattServerCallback);
    }

    public BluetoothGattServer openGattServer(Context context, BluetoothGattServerCallback bluetoothGattServerCallback, int n) {
        return InvokeDynamicSupport.bootstrap("openGattServer", $$robo$$android_bluetooth_BluetoothManager$openGattServer(android.content.Context android.bluetooth.BluetoothGattServerCallback int ), 0, this, context, bluetoothGattServerCallback, n);
    }

    public /* synthetic */ BluetoothManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BluetoothManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

