/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.app.PendingIntent;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.IBluetoothMapClient;
import android.bluetooth.IBluetoothStateChangeCallback;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.net.Uri;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class BluetoothMapClient
implements BluetoothProfile,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "BluetoothMapClient";
    private static boolean DBG;
    private static boolean VDBG;
    public static String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.mapmce.profile.action.CONNECTION_STATE_CHANGED";
    public static String ACTION_MESSAGE_RECEIVED = "android.bluetooth.mapmce.profile.action.MESSAGE_RECEIVED";
    public static String ACTION_MESSAGE_SENT_SUCCESSFULLY = "android.bluetooth.mapmce.profile.action.MESSAGE_SENT_SUCCESSFULLY";
    public static String ACTION_MESSAGE_DELIVERED_SUCCESSFULLY = "android.bluetooth.mapmce.profile.action.MESSAGE_DELIVERED_SUCCESSFULLY";
    public static String EXTRA_MESSAGE_HANDLE = "android.bluetooth.mapmce.profile.extra.MESSAGE_HANDLE";
    public static String EXTRA_SENDER_CONTACT_URI = "android.bluetooth.mapmce.profile.extra.SENDER_CONTACT_URI";
    public static String EXTRA_SENDER_CONTACT_NAME = "android.bluetooth.mapmce.profile.extra.SENDER_CONTACT_NAME";
    private volatile IBluetoothMapClient mService;
    private Context mContext;
    private BluetoothProfile.ServiceListener mServiceListener;
    private BluetoothAdapter mAdapter;
    public static int STATE_ERROR = -1;
    public static int RESULT_FAILURE = 0;
    public static int RESULT_SUCCESS = 1;
    public static int RESULT_CANCELED = 2;
    private IBluetoothStateChangeCallback mBluetoothStateChangeCallback;
    private ServiceConnection mConnection;

    private void $$robo$$android_bluetooth_BluetoothMapClient$__constructor__(Context context, BluetoothProfile.ServiceListener l) {
        this.mBluetoothStateChangeCallback = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ BluetoothMapClient this$0;

            private void $$robo$$android_bluetooth_BluetoothMapClient_1$__constructor__(BluetoothMapClient this$0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_BluetoothMapClient_1$onBluetoothStateChange(boolean up) {
                if (DBG) {
                    Log.d("BluetoothMapClient", "onBluetoothStateChange: up=" + up);
                }
                if (!up) {
                    if (VDBG) {
                        Log.d("BluetoothMapClient", "Unbinding service...");
                    }
                    ServiceConnection serviceConnection = this.this$0.mConnection;
                    synchronized (serviceConnection) {
                        try {
                            this.this$0.mService = null;
                            this.this$0.mContext.unbindService(this.this$0.mConnection);
                        }
                        catch (Exception re) {
                            Log.e("BluetoothMapClient", "", re);
                        }
                    }
                }
                ServiceConnection serviceConnection = this.this$0.mConnection;
                synchronized (serviceConnection) {
                    try {
                        if (this.this$0.mService == null) {
                            if (VDBG) {
                                Log.d("BluetoothMapClient", "Binding service...");
                            }
                            this.this$0.doBind();
                        }
                    }
                    catch (Exception re) {
                        Log.e("BluetoothMapClient", "", re);
                    }
                }
            }

            private void __constructor__(BluetoothMapClient bluetoothMapClient) {
                this.$$robo$$android_bluetooth_BluetoothMapClient_1$__constructor__(bluetoothMapClient);
            }
            {
                this.this$0 = bluetoothMapClient;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothMapClient_1$__constructor__(android.bluetooth.BluetoothMapClient ), 0, this, bluetoothMapClient);
            }

            @Override
            public void onBluetoothStateChange(boolean bl) {
                InvokeDynamicSupport.bootstrap("onBluetoothStateChange", $$robo$$android_bluetooth_BluetoothMapClient_1$onBluetoothStateChange(boolean ), 0, this, bl);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mConnection = new ServiceConnection(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ BluetoothMapClient this$0;

            private void $$robo$$android_bluetooth_BluetoothMapClient_2$__constructor__(BluetoothMapClient this$0) {
            }

            private final void $$robo$$android_bluetooth_BluetoothMapClient_2$onServiceConnected(ComponentName className, IBinder service) {
                if (DBG) {
                    Log.d("BluetoothMapClient", "Proxy object connected");
                }
                this.this$0.mService = IBluetoothMapClient.Stub.asInterface(service);
                if (this.this$0.mServiceListener != null) {
                    this.this$0.mServiceListener.onServiceConnected(18, this.this$0);
                }
            }

            private final void $$robo$$android_bluetooth_BluetoothMapClient_2$onServiceDisconnected(ComponentName className) {
                if (DBG) {
                    Log.d("BluetoothMapClient", "Proxy object disconnected");
                }
                this.this$0.mService = null;
                if (this.this$0.mServiceListener != null) {
                    this.this$0.mServiceListener.onServiceDisconnected(18);
                }
            }

            private void __constructor__(BluetoothMapClient bluetoothMapClient) {
                this.$$robo$$android_bluetooth_BluetoothMapClient_2$__constructor__(bluetoothMapClient);
            }
            {
                this.this$0 = bluetoothMapClient;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothMapClient_2$__constructor__(android.bluetooth.BluetoothMapClient ), 0, this, bluetoothMapClient);
            }

            @Override
            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                InvokeDynamicSupport.bootstrap("onServiceConnected", $$robo$$android_bluetooth_BluetoothMapClient_2$onServiceConnected(android.content.ComponentName android.os.IBinder ), 0, this, componentName, iBinder);
            }

            @Override
            public void onServiceDisconnected(ComponentName componentName) {
                InvokeDynamicSupport.bootstrap("onServiceDisconnected", $$robo$$android_bluetooth_BluetoothMapClient_2$onServiceDisconnected(android.content.ComponentName ), 0, this, componentName);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        if (DBG) {
            Log.d("BluetoothMapClient", "Create BluetoothMapClient proxy object");
        }
        this.mContext = context;
        this.mServiceListener = l;
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        IBluetoothManager mgr = this.mAdapter.getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.registerStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (RemoteException e) {
                Log.e("BluetoothMapClient", "", e);
            }
        }
        this.doBind();
    }

    private final boolean $$robo$$android_bluetooth_BluetoothMapClient$doBind() {
        Intent intent = new Intent(IBluetoothMapClient.class.getName());
        ComponentName comp = intent.resolveSystemService(this.mContext.getPackageManager(), 0);
        intent.setComponent(comp);
        if (comp == null || !this.mContext.bindServiceAsUser(intent, this.mConnection, 0, Process.myUserHandle())) {
            Log.e("BluetoothMapClient", "Could not bind to Bluetooth MAP MCE Service with " + intent);
            return false;
        }
        return true;
    }

    private final void $$robo$$android_bluetooth_BluetoothMapClient$finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_bluetooth_BluetoothMapClient$close() {
        IBluetoothManager mgr = this.mAdapter.getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.unregisterStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (Exception e) {
                Log.e("BluetoothMapClient", "", e);
            }
        }
        ServiceConnection serviceConnection = this.mConnection;
        synchronized (serviceConnection) {
            if (this.mService != null) {
                try {
                    this.mService = null;
                    this.mContext.unbindService(this.mConnection);
                }
                catch (Exception re) {
                    Log.e("BluetoothMapClient", "", re);
                }
            }
        }
        this.mServiceListener = null;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothMapClient$isConnected(BluetoothDevice device) {
        IBluetoothMapClient service;
        if (VDBG) {
            Log.d("BluetoothMapClient", "isConnected(" + device + ")");
        }
        if ((service = this.mService) != null) {
            try {
                return service.isConnected(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothMapClient", e.toString());
            }
        } else {
            Log.w("BluetoothMapClient", "Proxy not attached to service");
            if (DBG) {
                Log.d("BluetoothMapClient", Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothMapClient$connect(BluetoothDevice device) {
        IBluetoothMapClient service;
        if (DBG) {
            Log.d("BluetoothMapClient", "connect(" + device + ")" + "for MAPS MCE");
        }
        if ((service = this.mService) != null) {
            try {
                return service.connect(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothMapClient", e.toString());
            }
        } else {
            Log.w("BluetoothMapClient", "Proxy not attached to service");
            if (DBG) {
                Log.d("BluetoothMapClient", Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothMapClient$disconnect(BluetoothDevice device) {
        IBluetoothMapClient service;
        if (DBG) {
            Log.d("BluetoothMapClient", "disconnect(" + device + ")");
        }
        if ((service = this.mService) != null && this.isEnabled() && BluetoothMapClient.isValidDevice(device)) {
            try {
                return service.disconnect(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothMapClient", Log.getStackTraceString(new Throwable()));
            }
        }
        if (service == null) {
            Log.w("BluetoothMapClient", "Proxy not attached to service");
        }
        return false;
    }

    private final List<BluetoothDevice> $$robo$$android_bluetooth_BluetoothMapClient$getConnectedDevices() {
        IBluetoothMapClient service;
        if (DBG) {
            Log.d("BluetoothMapClient", "getConnectedDevices()");
        }
        if ((service = this.mService) != null && this.isEnabled()) {
            try {
                return service.getConnectedDevices();
            }
            catch (RemoteException e) {
                Log.e("BluetoothMapClient", Log.getStackTraceString(new Throwable()));
                return new ArrayList<BluetoothDevice>();
            }
        }
        if (service == null) {
            Log.w("BluetoothMapClient", "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    private final List<BluetoothDevice> $$robo$$android_bluetooth_BluetoothMapClient$getDevicesMatchingConnectionStates(int[] states) {
        IBluetoothMapClient service;
        if (DBG) {
            Log.d("BluetoothMapClient", "getDevicesMatchingStates()");
        }
        if ((service = this.mService) != null && this.isEnabled()) {
            try {
                return service.getDevicesMatchingConnectionStates(states);
            }
            catch (RemoteException e) {
                Log.e("BluetoothMapClient", Log.getStackTraceString(new Throwable()));
                return new ArrayList<BluetoothDevice>();
            }
        }
        if (service == null) {
            Log.w("BluetoothMapClient", "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    private final int $$robo$$android_bluetooth_BluetoothMapClient$getConnectionState(BluetoothDevice device) {
        IBluetoothMapClient service;
        if (DBG) {
            Log.d("BluetoothMapClient", "getConnectionState(" + device + ")");
        }
        if ((service = this.mService) != null && this.isEnabled() && BluetoothMapClient.isValidDevice(device)) {
            try {
                return service.getConnectionState(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothMapClient", Log.getStackTraceString(new Throwable()));
                return 0;
            }
        }
        if (service == null) {
            Log.w("BluetoothMapClient", "Proxy not attached to service");
        }
        return 0;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothMapClient$setPriority(BluetoothDevice device, int priority) {
        IBluetoothMapClient service;
        if (DBG) {
            Log.d("BluetoothMapClient", "setPriority(" + device + ", " + priority + ")");
        }
        if ((service = this.mService) != null && this.isEnabled() && BluetoothMapClient.isValidDevice(device)) {
            if (priority != 0 && priority != 100) {
                return false;
            }
            try {
                return service.setPriority(device, priority);
            }
            catch (RemoteException e) {
                Log.e("BluetoothMapClient", Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (service == null) {
            Log.w("BluetoothMapClient", "Proxy not attached to service");
        }
        return false;
    }

    private final int $$robo$$android_bluetooth_BluetoothMapClient$getPriority(BluetoothDevice device) {
        IBluetoothMapClient service;
        if (VDBG) {
            Log.d("BluetoothMapClient", "getPriority(" + device + ")");
        }
        if ((service = this.mService) != null && this.isEnabled() && BluetoothMapClient.isValidDevice(device)) {
            try {
                return service.getPriority(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothMapClient", Log.getStackTraceString(new Throwable()));
                return 0;
            }
        }
        if (service == null) {
            Log.w("BluetoothMapClient", "Proxy not attached to service");
        }
        return 0;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothMapClient$sendMessage(BluetoothDevice device, Uri[] contacts, String message, PendingIntent sentIntent, PendingIntent deliveredIntent) {
        IBluetoothMapClient service;
        if (DBG) {
            Log.d("BluetoothMapClient", "sendMessage(" + device + ", " + contacts + ", " + message);
        }
        if ((service = this.mService) != null && this.isEnabled() && BluetoothMapClient.isValidDevice(device)) {
            try {
                return service.sendMessage(device, contacts, message, sentIntent, deliveredIntent);
            }
            catch (RemoteException e) {
                Log.e("BluetoothMapClient", Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothMapClient$getUnreadMessages(BluetoothDevice device) {
        IBluetoothMapClient service;
        if (DBG) {
            Log.d("BluetoothMapClient", "getUnreadMessages(" + device + ")");
        }
        if ((service = this.mService) != null && this.isEnabled() && BluetoothMapClient.isValidDevice(device)) {
            try {
                return service.getUnreadMessages(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothMapClient", Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothMapClient$isEnabled() {
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter != null && adapter.getState() == 12) {
            return true;
        }
        if (DBG) {
            Log.d("BluetoothMapClient", "Bluetooth is Not enabled");
        }
        return false;
    }

    private static final boolean $$robo$$android_bluetooth_BluetoothMapClient$isValidDevice(BluetoothDevice device) {
        return device != null && BluetoothAdapter.checkBluetoothAddress(device.getAddress());
    }

    static void __staticInitializer__() {
        DBG = Log.isLoggable("BluetoothMapClient", 3);
        VDBG = Log.isLoggable("BluetoothMapClient", 2);
    }

    private void __constructor__(Context context, BluetoothProfile.ServiceListener serviceListener) {
        this.$$robo$$android_bluetooth_BluetoothMapClient$__constructor__(context, serviceListener);
    }

    BluetoothMapClient(Context context, BluetoothProfile.ServiceListener serviceListener) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothMapClient$__constructor__(android.content.Context android.bluetooth.BluetoothProfile$ServiceListener ), 0, this, context, serviceListener);
    }

    boolean doBind() {
        return (boolean)InvokeDynamicSupport.bootstrap("doBind", $$robo$$android_bluetooth_BluetoothMapClient$doBind(), 0, this);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_bluetooth_BluetoothMapClient$finalize(), 0, this);
    }

    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_bluetooth_BluetoothMapClient$close(), 0, this);
    }

    public boolean isConnected(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("isConnected", $$robo$$android_bluetooth_BluetoothMapClient$isConnected(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    public boolean connect(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("connect", $$robo$$android_bluetooth_BluetoothMapClient$connect(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    public boolean disconnect(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("disconnect", $$robo$$android_bluetooth_BluetoothMapClient$disconnect(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    @Override
    public List<BluetoothDevice> getConnectedDevices() {
        return InvokeDynamicSupport.bootstrap("getConnectedDevices", $$robo$$android_bluetooth_BluetoothMapClient$getConnectedDevices(), 0, this);
    }

    @Override
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] nArray) {
        return InvokeDynamicSupport.bootstrap("getDevicesMatchingConnectionStates", $$robo$$android_bluetooth_BluetoothMapClient$getDevicesMatchingConnectionStates(int[] ), 0, this, nArray);
    }

    @Override
    public int getConnectionState(BluetoothDevice bluetoothDevice) {
        return (int)InvokeDynamicSupport.bootstrap("getConnectionState", $$robo$$android_bluetooth_BluetoothMapClient$getConnectionState(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    public boolean setPriority(BluetoothDevice bluetoothDevice, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("setPriority", $$robo$$android_bluetooth_BluetoothMapClient$setPriority(android.bluetooth.BluetoothDevice int ), 0, this, bluetoothDevice, n);
    }

    public int getPriority(BluetoothDevice bluetoothDevice) {
        return (int)InvokeDynamicSupport.bootstrap("getPriority", $$robo$$android_bluetooth_BluetoothMapClient$getPriority(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    public boolean sendMessage(BluetoothDevice bluetoothDevice, Uri[] uriArray, String string2, PendingIntent pendingIntent, PendingIntent pendingIntent2) {
        return (boolean)InvokeDynamicSupport.bootstrap("sendMessage", $$robo$$android_bluetooth_BluetoothMapClient$sendMessage(android.bluetooth.BluetoothDevice android.net.Uri[] java.lang.String android.app.PendingIntent android.app.PendingIntent ), 0, this, bluetoothDevice, uriArray, string2, pendingIntent, pendingIntent2);
    }

    public boolean getUnreadMessages(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("getUnreadMessages", $$robo$$android_bluetooth_BluetoothMapClient$getUnreadMessages(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    private boolean isEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$android_bluetooth_BluetoothMapClient$isEnabled(), 0, this);
    }

    private static boolean isValidDevice(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidDevice", $$robo$$android_bluetooth_BluetoothMapClient$isValidDevice(android.bluetooth.BluetoothDevice ), 0, (BluetoothDevice)bluetoothDevice);
    }

    static {
        RobolectricInternals.classInitializing(BluetoothMapClient.class);
    }

    public /* synthetic */ BluetoothMapClient() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BluetoothMapClient)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

