/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth.le;

import android.bluetooth.IBluetoothGatt;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.le.AdvertiseData;
import android.bluetooth.le.AdvertisingSetParameters;
import android.bluetooth.le.PeriodicAdvertisingParameters;
import android.os.RemoteException;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class AdvertisingSet
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "AdvertisingSet";
    private IBluetoothGatt gatt;
    private int advertiserId;

    private void $$robo$$android_bluetooth_le_AdvertisingSet$__constructor__(int advertiserId, IBluetoothManager bluetoothManager) {
        this.advertiserId = advertiserId;
        try {
            this.gatt = bluetoothManager.getBluetoothGatt();
        }
        catch (RemoteException e) {
            Log.e("AdvertisingSet", "Failed to get Bluetooth gatt - ", e);
            throw new IllegalStateException("Failed to get Bluetooth");
        }
    }

    private final void $$robo$$android_bluetooth_le_AdvertisingSet$setAdvertiserId(int advertiserId) {
        this.advertiserId = advertiserId;
    }

    private final void $$robo$$android_bluetooth_le_AdvertisingSet$enableAdvertising(boolean enable, int duration, int maxExtendedAdvertisingEvents) {
        try {
            this.gatt.enableAdvertisingSet(this.advertiserId, enable, duration, maxExtendedAdvertisingEvents);
        }
        catch (RemoteException e) {
            Log.e("AdvertisingSet", "remote exception - ", e);
        }
    }

    private final void $$robo$$android_bluetooth_le_AdvertisingSet$setAdvertisingData(AdvertiseData advertiseData) {
        try {
            this.gatt.setAdvertisingData(this.advertiserId, advertiseData);
        }
        catch (RemoteException e) {
            Log.e("AdvertisingSet", "remote exception - ", e);
        }
    }

    private final void $$robo$$android_bluetooth_le_AdvertisingSet$setScanResponseData(AdvertiseData scanResponse) {
        try {
            this.gatt.setScanResponseData(this.advertiserId, scanResponse);
        }
        catch (RemoteException e) {
            Log.e("AdvertisingSet", "remote exception - ", e);
        }
    }

    private final void $$robo$$android_bluetooth_le_AdvertisingSet$setAdvertisingParameters(AdvertisingSetParameters parameters) {
        try {
            this.gatt.setAdvertisingParameters(this.advertiserId, parameters);
        }
        catch (RemoteException e) {
            Log.e("AdvertisingSet", "remote exception - ", e);
        }
    }

    private final void $$robo$$android_bluetooth_le_AdvertisingSet$setPeriodicAdvertisingParameters(PeriodicAdvertisingParameters parameters) {
        try {
            this.gatt.setPeriodicAdvertisingParameters(this.advertiserId, parameters);
        }
        catch (RemoteException e) {
            Log.e("AdvertisingSet", "remote exception - ", e);
        }
    }

    private final void $$robo$$android_bluetooth_le_AdvertisingSet$setPeriodicAdvertisingData(AdvertiseData periodicData) {
        try {
            this.gatt.setPeriodicAdvertisingData(this.advertiserId, periodicData);
        }
        catch (RemoteException e) {
            Log.e("AdvertisingSet", "remote exception - ", e);
        }
    }

    private final void $$robo$$android_bluetooth_le_AdvertisingSet$setPeriodicAdvertisingEnabled(boolean enable) {
        try {
            this.gatt.setPeriodicAdvertisingEnable(this.advertiserId, enable);
        }
        catch (RemoteException e) {
            Log.e("AdvertisingSet", "remote exception - ", e);
        }
    }

    private final void $$robo$$android_bluetooth_le_AdvertisingSet$getOwnAddress() {
        try {
            this.gatt.getOwnAddress(this.advertiserId);
        }
        catch (RemoteException e) {
            Log.e("AdvertisingSet", "remote exception - ", e);
        }
    }

    private final int $$robo$$android_bluetooth_le_AdvertisingSet$getAdvertiserId() {
        return this.advertiserId;
    }

    private void __constructor__(int n, IBluetoothManager iBluetoothManager) {
        this.$$robo$$android_bluetooth_le_AdvertisingSet$__constructor__(n, iBluetoothManager);
    }

    AdvertisingSet(int n, IBluetoothManager iBluetoothManager) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_le_AdvertisingSet$__constructor__(int android.bluetooth.IBluetoothManager ), 0, this, n, iBluetoothManager);
    }

    void setAdvertiserId(int n) {
        InvokeDynamicSupport.bootstrap("setAdvertiserId", $$robo$$android_bluetooth_le_AdvertisingSet$setAdvertiserId(int ), 0, this, n);
    }

    public void enableAdvertising(boolean bl, int n, int n2) {
        InvokeDynamicSupport.bootstrap("enableAdvertising", $$robo$$android_bluetooth_le_AdvertisingSet$enableAdvertising(boolean int int ), 0, this, bl, n, n2);
    }

    public void setAdvertisingData(AdvertiseData advertiseData) {
        InvokeDynamicSupport.bootstrap("setAdvertisingData", $$robo$$android_bluetooth_le_AdvertisingSet$setAdvertisingData(android.bluetooth.le.AdvertiseData ), 0, this, advertiseData);
    }

    public void setScanResponseData(AdvertiseData advertiseData) {
        InvokeDynamicSupport.bootstrap("setScanResponseData", $$robo$$android_bluetooth_le_AdvertisingSet$setScanResponseData(android.bluetooth.le.AdvertiseData ), 0, this, advertiseData);
    }

    public void setAdvertisingParameters(AdvertisingSetParameters advertisingSetParameters) {
        InvokeDynamicSupport.bootstrap("setAdvertisingParameters", $$robo$$android_bluetooth_le_AdvertisingSet$setAdvertisingParameters(android.bluetooth.le.AdvertisingSetParameters ), 0, this, advertisingSetParameters);
    }

    public void setPeriodicAdvertisingParameters(PeriodicAdvertisingParameters periodicAdvertisingParameters) {
        InvokeDynamicSupport.bootstrap("setPeriodicAdvertisingParameters", $$robo$$android_bluetooth_le_AdvertisingSet$setPeriodicAdvertisingParameters(android.bluetooth.le.PeriodicAdvertisingParameters ), 0, this, periodicAdvertisingParameters);
    }

    public void setPeriodicAdvertisingData(AdvertiseData advertiseData) {
        InvokeDynamicSupport.bootstrap("setPeriodicAdvertisingData", $$robo$$android_bluetooth_le_AdvertisingSet$setPeriodicAdvertisingData(android.bluetooth.le.AdvertiseData ), 0, this, advertiseData);
    }

    public void setPeriodicAdvertisingEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setPeriodicAdvertisingEnabled", $$robo$$android_bluetooth_le_AdvertisingSet$setPeriodicAdvertisingEnabled(boolean ), 0, this, bl);
    }

    public void getOwnAddress() {
        InvokeDynamicSupport.bootstrap("getOwnAddress", $$robo$$android_bluetooth_le_AdvertisingSet$getOwnAddress(), 0, this);
    }

    public int getAdvertiserId() {
        return (int)InvokeDynamicSupport.bootstrap("getAdvertiserId", $$robo$$android_bluetooth_le_AdvertisingSet$getAdvertiserId(), 0, this);
    }

    public /* synthetic */ AdvertisingSet() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AdvertisingSet)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

