/*
 * Decompiled with CFR 0.152.
 */
package android.companion;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanResult;
import android.companion.BluetoothDeviceFilterUtils;
import android.companion.DeviceFilter;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.OneTimeUseBuilder;
import android.text.TextUtils;
import com.android.internal.util.BitUtils;
import com.android.internal.util.ObjectUtils;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Pattern;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class BluetoothLeDeviceFilter
implements DeviceFilter<ScanResult> {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean DEBUG = false;
    private static String LOG_TAG = "BluetoothLeDeviceFilter";
    private static int RENAME_PREFIX_LENGTH_LIMIT = 10;
    private Pattern mNamePattern;
    private ScanFilter mScanFilter;
    private byte[] mRawDataFilter;
    private byte[] mRawDataFilterMask;
    private String mRenamePrefix;
    private String mRenameSuffix;
    private int mRenameBytesFrom;
    private int mRenameBytesLength;
    private int mRenameNameFrom;
    private int mRenameNameLength;
    private boolean mRenameBytesReverseOrder;
    public static Parcelable.Creator<BluetoothLeDeviceFilter> CREATOR;

    private void $$robo$$android_companion_BluetoothLeDeviceFilter$__constructor__(Pattern namePattern, ScanFilter scanFilter, byte[] rawDataFilter, byte[] rawDataFilterMask, String renamePrefix, String renameSuffix, int renameBytesFrom, int renameBytesLength, int renameNameFrom, int renameNameLength, boolean renameBytesReverseOrder) {
        this.mNamePattern = namePattern;
        this.mScanFilter = ObjectUtils.firstNotNull(scanFilter, ScanFilter.EMPTY);
        this.mRawDataFilter = rawDataFilter;
        this.mRawDataFilterMask = rawDataFilterMask;
        this.mRenamePrefix = renamePrefix;
        this.mRenameSuffix = renameSuffix;
        this.mRenameBytesFrom = renameBytesFrom;
        this.mRenameBytesLength = renameBytesLength;
        this.mRenameNameFrom = renameNameFrom;
        this.mRenameNameLength = renameNameLength;
        this.mRenameBytesReverseOrder = renameBytesReverseOrder;
    }

    private final Pattern $$robo$$android_companion_BluetoothLeDeviceFilter$getNamePattern() {
        return this.mNamePattern;
    }

    private final ScanFilter $$robo$$android_companion_BluetoothLeDeviceFilter$getScanFilter() {
        return this.mScanFilter;
    }

    private final byte[] $$robo$$android_companion_BluetoothLeDeviceFilter$getRawDataFilter() {
        return this.mRawDataFilter;
    }

    private final byte[] $$robo$$android_companion_BluetoothLeDeviceFilter$getRawDataFilterMask() {
        return this.mRawDataFilterMask;
    }

    private final String $$robo$$android_companion_BluetoothLeDeviceFilter$getRenamePrefix() {
        return this.mRenamePrefix;
    }

    private final String $$robo$$android_companion_BluetoothLeDeviceFilter$getRenameSuffix() {
        return this.mRenameSuffix;
    }

    private final int $$robo$$android_companion_BluetoothLeDeviceFilter$getRenameBytesFrom() {
        return this.mRenameBytesFrom;
    }

    private final int $$robo$$android_companion_BluetoothLeDeviceFilter$getRenameBytesLength() {
        return this.mRenameBytesLength;
    }

    private final boolean $$robo$$android_companion_BluetoothLeDeviceFilter$isRenameBytesReverseOrder() {
        return this.mRenameBytesReverseOrder;
    }

    private final String $$robo$$android_companion_BluetoothLeDeviceFilter$getDeviceDisplayName(ScanResult sr) {
        if (this.mRenameBytesFrom < 0 && this.mRenameNameFrom < 0) {
            return BluetoothDeviceFilterUtils.getDeviceDisplayNameInternal(sr.getDevice());
        }
        StringBuilder sb = new StringBuilder(TextUtils.emptyIfNull(this.mRenamePrefix));
        if (this.mRenameBytesFrom >= 0) {
            byte[] bytes = sr.getScanRecord().getBytes();
            int startInclusive = this.mRenameBytesFrom;
            int endInclusive = this.mRenameBytesFrom + this.mRenameBytesLength - 1;
            int initial = this.mRenameBytesReverseOrder ? endInclusive : startInclusive;
            int step = this.mRenameBytesReverseOrder ? -1 : 1;
            for (int i = initial; startInclusive <= i && i <= endInclusive; i += step) {
                sb.append(Byte.toHexString((byte)bytes[i], (boolean)true));
            }
        } else {
            sb.append(BluetoothDeviceFilterUtils.getDeviceDisplayNameInternal(sr.getDevice()).substring(this.mRenameNameFrom, this.mRenameNameFrom + this.mRenameNameLength));
        }
        return sb.append(TextUtils.emptyIfNull(this.mRenameSuffix)).toString();
    }

    private final boolean $$robo$$android_companion_BluetoothLeDeviceFilter$matches(ScanResult device) {
        boolean result = this.matches(device.getDevice()) && (this.mRawDataFilter == null || BitUtils.maskedEquals(device.getScanRecord().getBytes(), this.mRawDataFilter, this.mRawDataFilterMask));
        return result;
    }

    private final boolean $$robo$$android_companion_BluetoothLeDeviceFilter$matches(BluetoothDevice device) {
        return BluetoothDeviceFilterUtils.matches(this.getScanFilter(), device) && BluetoothDeviceFilterUtils.matchesName(this.getNamePattern(), device);
    }

    private final int $$robo$$android_companion_BluetoothLeDeviceFilter$getMediumType() {
        return 1;
    }

    private final boolean $$robo$$android_companion_BluetoothLeDeviceFilter$equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BluetoothLeDeviceFilter that = (BluetoothLeDeviceFilter)o;
        return this.mRenameBytesFrom == that.mRenameBytesFrom && this.mRenameBytesLength == that.mRenameBytesLength && this.mRenameNameFrom == that.mRenameNameFrom && this.mRenameNameLength == that.mRenameNameLength && this.mRenameBytesReverseOrder == that.mRenameBytesReverseOrder && Objects.equals(this.mNamePattern, that.mNamePattern) && Objects.equals(this.mScanFilter, that.mScanFilter) && Arrays.equals(this.mRawDataFilter, that.mRawDataFilter) && Arrays.equals(this.mRawDataFilterMask, that.mRawDataFilterMask) && Objects.equals(this.mRenamePrefix, that.mRenamePrefix) && Objects.equals(this.mRenameSuffix, that.mRenameSuffix);
    }

    private final int $$robo$$android_companion_BluetoothLeDeviceFilter$hashCode() {
        return Objects.hash(this.mNamePattern, this.mScanFilter, this.mRawDataFilter, this.mRawDataFilterMask, this.mRenamePrefix, this.mRenameSuffix, this.mRenameBytesFrom, this.mRenameBytesLength, this.mRenameNameFrom, this.mRenameNameLength, this.mRenameBytesReverseOrder);
    }

    private final void $$robo$$android_companion_BluetoothLeDeviceFilter$writeToParcel(Parcel dest, int flags) {
        dest.writeString(BluetoothDeviceFilterUtils.patternToString(this.getNamePattern()));
        dest.writeParcelable(this.mScanFilter, flags);
        dest.writeByteArray(this.mRawDataFilter);
        dest.writeByteArray(this.mRawDataFilterMask);
        dest.writeString(this.mRenamePrefix);
        dest.writeString(this.mRenameSuffix);
        dest.writeInt(this.mRenameBytesFrom);
        dest.writeInt(this.mRenameBytesLength);
        dest.writeInt(this.mRenameNameFrom);
        dest.writeInt(this.mRenameNameLength);
        dest.writeBoolean(this.mRenameBytesReverseOrder);
    }

    private final int $$robo$$android_companion_BluetoothLeDeviceFilter$describeContents() {
        return 0;
    }

    private final String $$robo$$android_companion_BluetoothLeDeviceFilter$toString() {
        return "BluetoothLEDeviceFilter{mNamePattern=" + this.mNamePattern + ", mScanFilter=" + this.mScanFilter + ", mRawDataFilter=" + Arrays.toString(this.mRawDataFilter) + ", mRawDataFilterMask=" + Arrays.toString(this.mRawDataFilterMask) + ", mRenamePrefix='" + this.mRenamePrefix + '\'' + ", mRenameSuffix='" + this.mRenameSuffix + '\'' + ", mRenameBytesFrom=" + this.mRenameBytesFrom + ", mRenameBytesLength=" + this.mRenameBytesLength + ", mRenameNameFrom=" + this.mRenameNameFrom + ", mRenameNameLength=" + this.mRenameNameLength + ", mRenameBytesReverseOrder=" + this.mRenameBytesReverseOrder + '}';
    }

    private static final int $$robo$$android_companion_BluetoothLeDeviceFilter$getRenamePrefixLengthLimit() {
        return 10;
    }

    private /* synthetic */ void $$robo$$android_companion_BluetoothLeDeviceFilter$__constructor__(Pattern x0, ScanFilter x1, byte[] x2, byte[] x3, String x4, String x5, int x6, int x7, int x8, int x9, boolean x10, 1 x11) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<BluetoothLeDeviceFilter>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_companion_BluetoothLeDeviceFilter_1$__constructor__() {
            }

            private final BluetoothLeDeviceFilter $$robo$$android_companion_BluetoothLeDeviceFilter_1$createFromParcel(Parcel in) {
                Builder builder = new Builder().setNamePattern(BluetoothDeviceFilterUtils.patternFromString(in.readString())).setScanFilter((ScanFilter)in.readParcelable(null));
                byte[] rawDataFilter = in.createByteArray();
                byte[] rawDataFilterMask = in.createByteArray();
                if (rawDataFilter != null) {
                    builder.setRawDataFilter(rawDataFilter, rawDataFilterMask);
                }
                String renamePrefix = in.readString();
                String suffix = in.readString();
                int bytesFrom = in.readInt();
                int bytesTo = in.readInt();
                int nameFrom = in.readInt();
                int nameTo = in.readInt();
                boolean bytesReverseOrder = in.readBoolean();
                if (renamePrefix != null) {
                    if (bytesFrom >= 0) {
                        builder.setRenameFromBytes(renamePrefix, suffix, bytesFrom, bytesTo, bytesReverseOrder ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
                    } else {
                        builder.setRenameFromName(renamePrefix, suffix, nameFrom, nameTo);
                    }
                }
                return builder.build();
            }

            private final BluetoothLeDeviceFilter[] $$robo$$android_companion_BluetoothLeDeviceFilter_1$newArray(int size) {
                return new BluetoothLeDeviceFilter[size];
            }

            private void __constructor__() {
                this.$$robo$$android_companion_BluetoothLeDeviceFilter_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_companion_BluetoothLeDeviceFilter_1$__constructor__(), 0, this);
            }

            @Override
            public BluetoothLeDeviceFilter createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_companion_BluetoothLeDeviceFilter_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public BluetoothLeDeviceFilter[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_companion_BluetoothLeDeviceFilter_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(Pattern pattern, ScanFilter scanFilter, byte[] byArray, byte[] byArray2, String string2, String string3, int n, int n2, int n3, int n4, boolean bl) {
        this.$$robo$$android_companion_BluetoothLeDeviceFilter$__constructor__(pattern, scanFilter, byArray, byArray2, string2, string3, n, n2, n3, n4, bl);
    }

    private BluetoothLeDeviceFilter(Pattern pattern, ScanFilter scanFilter, byte[] byArray, byte[] byArray2, String string2, String string3, int n, int n2, int n3, int n4, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_companion_BluetoothLeDeviceFilter$__constructor__(java.util.regex.Pattern android.bluetooth.le.ScanFilter byte[] byte[] java.lang.String java.lang.String int int int int boolean ), 0, this, pattern, scanFilter, byArray, byArray2, string2, string3, n, n2, n3, n4, bl);
    }

    public Pattern getNamePattern() {
        return InvokeDynamicSupport.bootstrap("getNamePattern", $$robo$$android_companion_BluetoothLeDeviceFilter$getNamePattern(), 0, this);
    }

    public ScanFilter getScanFilter() {
        return InvokeDynamicSupport.bootstrap("getScanFilter", $$robo$$android_companion_BluetoothLeDeviceFilter$getScanFilter(), 0, this);
    }

    public byte[] getRawDataFilter() {
        return InvokeDynamicSupport.bootstrap("getRawDataFilter", $$robo$$android_companion_BluetoothLeDeviceFilter$getRawDataFilter(), 0, this);
    }

    public byte[] getRawDataFilterMask() {
        return InvokeDynamicSupport.bootstrap("getRawDataFilterMask", $$robo$$android_companion_BluetoothLeDeviceFilter$getRawDataFilterMask(), 0, this);
    }

    public String getRenamePrefix() {
        return InvokeDynamicSupport.bootstrap("getRenamePrefix", $$robo$$android_companion_BluetoothLeDeviceFilter$getRenamePrefix(), 0, this);
    }

    public String getRenameSuffix() {
        return InvokeDynamicSupport.bootstrap("getRenameSuffix", $$robo$$android_companion_BluetoothLeDeviceFilter$getRenameSuffix(), 0, this);
    }

    public int getRenameBytesFrom() {
        return (int)InvokeDynamicSupport.bootstrap("getRenameBytesFrom", $$robo$$android_companion_BluetoothLeDeviceFilter$getRenameBytesFrom(), 0, this);
    }

    public int getRenameBytesLength() {
        return (int)InvokeDynamicSupport.bootstrap("getRenameBytesLength", $$robo$$android_companion_BluetoothLeDeviceFilter$getRenameBytesLength(), 0, this);
    }

    public boolean isRenameBytesReverseOrder() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRenameBytesReverseOrder", $$robo$$android_companion_BluetoothLeDeviceFilter$isRenameBytesReverseOrder(), 0, this);
    }

    @Override
    public String getDeviceDisplayName(ScanResult scanResult) {
        return InvokeDynamicSupport.bootstrap("getDeviceDisplayName", $$robo$$android_companion_BluetoothLeDeviceFilter$getDeviceDisplayName(android.bluetooth.le.ScanResult ), 0, this, scanResult);
    }

    @Override
    public boolean matches(ScanResult scanResult) {
        return (boolean)InvokeDynamicSupport.bootstrap("matches", $$robo$$android_companion_BluetoothLeDeviceFilter$matches(android.bluetooth.le.ScanResult ), 0, this, scanResult);
    }

    @Override
    private boolean matches(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("matches", $$robo$$android_companion_BluetoothLeDeviceFilter$matches(android.bluetooth.BluetoothDevice ), 0, this, bluetoothDevice);
    }

    @Override
    public int getMediumType() {
        return (int)InvokeDynamicSupport.bootstrap("getMediumType", $$robo$$android_companion_BluetoothLeDeviceFilter$getMediumType(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_companion_BluetoothLeDeviceFilter$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_companion_BluetoothLeDeviceFilter$hashCode(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_companion_BluetoothLeDeviceFilter$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_companion_BluetoothLeDeviceFilter$describeContents(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_companion_BluetoothLeDeviceFilter$toString(), 0, this);
    }

    public static int getRenamePrefixLengthLimit() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getRenamePrefixLengthLimit", $$robo$$android_companion_BluetoothLeDeviceFilter$getRenamePrefixLengthLimit(), 0);
    }

    private /* synthetic */ void __constructor__(Pattern pattern, ScanFilter scanFilter, byte[] byArray, byte[] byArray2, String string2, String string3, int n, int n2, int n3, int n4, boolean bl, 1 var12_12) {
        this.$$robo$$android_companion_BluetoothLeDeviceFilter$__constructor__(pattern, scanFilter, byArray, byArray2, string2, string3, n, n2, n3, n4, bl, var12_12);
    }

    static {
        RobolectricInternals.classInitializing(BluetoothLeDeviceFilter.class);
    }

    public /* synthetic */ BluetoothLeDeviceFilter() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BluetoothLeDeviceFilter)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class Builder
    extends OneTimeUseBuilder<BluetoothLeDeviceFilter> {
        public transient /* synthetic */ Object __robo_data__;
        private ScanFilter mScanFilter;
        private Pattern mNamePattern;
        private byte[] mRawDataFilter;
        private byte[] mRawDataFilterMask;
        private String mRenamePrefix;
        private String mRenameSuffix;
        private int mRenameBytesFrom;
        private int mRenameBytesLength;
        private int mRenameNameFrom;
        private int mRenameNameLength;
        private boolean mRenameBytesReverseOrder;

        private void $$robo$$android_companion_BluetoothLeDeviceFilter_Builder$__constructor__() {
            this.mRenameBytesFrom = -1;
            this.mRenameNameFrom = -1;
            this.mRenameBytesReverseOrder = false;
        }

        private final Builder $$robo$$android_companion_BluetoothLeDeviceFilter_Builder$setNamePattern(Pattern regex) {
            this.checkNotUsed();
            this.mNamePattern = regex;
            return this;
        }

        private final Builder $$robo$$android_companion_BluetoothLeDeviceFilter_Builder$setScanFilter(ScanFilter scanFilter) {
            this.checkNotUsed();
            this.mScanFilter = scanFilter;
            return this;
        }

        private final Builder $$robo$$android_companion_BluetoothLeDeviceFilter_Builder$setRawDataFilter(byte[] rawDataFilter, byte[] rawDataFilterMask) {
            this.checkNotUsed();
            Preconditions.checkNotNull(rawDataFilter);
            Preconditions.checkArgument(rawDataFilterMask == null || rawDataFilter.length == rawDataFilterMask.length, "Mask and filter should be the same length");
            this.mRawDataFilter = rawDataFilter;
            this.mRawDataFilterMask = rawDataFilterMask;
            return this;
        }

        private final Builder $$robo$$android_companion_BluetoothLeDeviceFilter_Builder$setRenameFromBytes(String prefix, String suffix, int bytesFrom, int bytesLength, ByteOrder byteOrder) {
            this.checkRenameNotSet();
            this.checkRangeNotEmpty(bytesLength);
            this.mRenameBytesFrom = bytesFrom;
            this.mRenameBytesLength = bytesLength;
            this.mRenameBytesReverseOrder = byteOrder == ByteOrder.LITTLE_ENDIAN;
            return this.setRename(prefix, suffix);
        }

        private final Builder $$robo$$android_companion_BluetoothLeDeviceFilter_Builder$setRenameFromName(String prefix, String suffix, int nameFrom, int nameLength) {
            this.checkRenameNotSet();
            this.checkRangeNotEmpty(nameLength);
            this.mRenameNameFrom = nameFrom;
            this.mRenameNameLength = nameLength;
            this.mRenameBytesReverseOrder = false;
            return this.setRename(prefix, suffix);
        }

        private final void $$robo$$android_companion_BluetoothLeDeviceFilter_Builder$checkRenameNotSet() {
            Preconditions.checkState(this.mRenamePrefix == null, "Renaming rule can only be set once");
        }

        private final void $$robo$$android_companion_BluetoothLeDeviceFilter_Builder$checkRangeNotEmpty(int length) {
            Preconditions.checkArgument(length > 0, "Range must be non-empty");
        }

        private final Builder $$robo$$android_companion_BluetoothLeDeviceFilter_Builder$setRename(String prefix, String suffix) {
            this.checkNotUsed();
            Preconditions.checkArgument(TextUtils.length(prefix) <= BluetoothLeDeviceFilter.getRenamePrefixLengthLimit(), "Prefix is too long");
            this.mRenamePrefix = prefix;
            this.mRenameSuffix = suffix;
            return this;
        }

        private final BluetoothLeDeviceFilter $$robo$$android_companion_BluetoothLeDeviceFilter_Builder$build() {
            this.markUsed();
            return new BluetoothLeDeviceFilter(this.mNamePattern, this.mScanFilter, this.mRawDataFilter, this.mRawDataFilterMask, this.mRenamePrefix, this.mRenameSuffix, this.mRenameBytesFrom, this.mRenameBytesLength, this.mRenameNameFrom, this.mRenameNameLength, this.mRenameBytesReverseOrder);
        }

        private void __constructor__() {
            this.$$robo$$android_companion_BluetoothLeDeviceFilter_Builder$__constructor__();
        }

        public Builder() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_companion_BluetoothLeDeviceFilter_Builder$__constructor__(), 0, this);
        }

        public Builder setNamePattern(Pattern pattern) {
            return InvokeDynamicSupport.bootstrap("setNamePattern", $$robo$$android_companion_BluetoothLeDeviceFilter_Builder$setNamePattern(java.util.regex.Pattern ), 0, this, pattern);
        }

        public Builder setScanFilter(ScanFilter scanFilter) {
            return InvokeDynamicSupport.bootstrap("setScanFilter", $$robo$$android_companion_BluetoothLeDeviceFilter_Builder$setScanFilter(android.bluetooth.le.ScanFilter ), 0, this, scanFilter);
        }

        public Builder setRawDataFilter(byte[] byArray, byte[] byArray2) {
            return InvokeDynamicSupport.bootstrap("setRawDataFilter", $$robo$$android_companion_BluetoothLeDeviceFilter_Builder$setRawDataFilter(byte[] byte[] ), 0, this, byArray, byArray2);
        }

        public Builder setRenameFromBytes(String string2, String string3, int n, int n2, ByteOrder byteOrder) {
            return InvokeDynamicSupport.bootstrap("setRenameFromBytes", $$robo$$android_companion_BluetoothLeDeviceFilter_Builder$setRenameFromBytes(java.lang.String java.lang.String int int java.nio.ByteOrder ), 0, this, string2, string3, n, n2, byteOrder);
        }

        public Builder setRenameFromName(String string2, String string3, int n, int n2) {
            return InvokeDynamicSupport.bootstrap("setRenameFromName", $$robo$$android_companion_BluetoothLeDeviceFilter_Builder$setRenameFromName(java.lang.String java.lang.String int int ), 0, this, string2, string3, n, n2);
        }

        private void checkRenameNotSet() {
            InvokeDynamicSupport.bootstrap("checkRenameNotSet", $$robo$$android_companion_BluetoothLeDeviceFilter_Builder$checkRenameNotSet(), 0, this);
        }

        private void checkRangeNotEmpty(int n) {
            InvokeDynamicSupport.bootstrap("checkRangeNotEmpty", $$robo$$android_companion_BluetoothLeDeviceFilter_Builder$checkRangeNotEmpty(int ), 0, this, n);
        }

        private Builder setRename(String string2, String string3) {
            return InvokeDynamicSupport.bootstrap("setRename", $$robo$$android_companion_BluetoothLeDeviceFilter_Builder$setRename(java.lang.String java.lang.String ), 0, this, string2, string3);
        }

        @Override
        public BluetoothLeDeviceFilter build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_companion_BluetoothLeDeviceFilter_Builder$build(), 0, this);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

