/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.accounts.Account;
import android.content.ContentProviderClient;
import android.content.ContentResolver;
import android.content.Context;
import android.content.ISyncAdapter;
import android.content.ISyncContext;
import android.content.SyncContext;
import android.content.SyncResult;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Process;
import android.os.Trace;
import android.util.Log;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class AbstractThreadedSyncAdapter
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "SyncAdapter";
    @Deprecated
    public static int LOG_SYNC_DETAILS = 2743;
    private static boolean ENABLE_LOG;
    private Context mContext;
    private AtomicInteger mNumSyncStarts;
    private ISyncAdapterImpl mISyncAdapterImpl;
    private HashMap<Account, SyncThread> mSyncThreads;
    private Object mSyncThreadLock;
    private boolean mAutoInitialize;
    private boolean mAllowParallelSyncs;

    private void $$robo$$android_content_AbstractThreadedSyncAdapter$__constructor__(Context context, boolean autoInitialize) {
    }

    private void $$robo$$android_content_AbstractThreadedSyncAdapter$__constructor__(Context context, boolean autoInitialize, boolean allowParallelSyncs) {
        this.mSyncThreads = new HashMap();
        this.mSyncThreadLock = new Object();
        this.mContext = context;
        this.mISyncAdapterImpl = new ISyncAdapterImpl(this);
        this.mNumSyncStarts = new AtomicInteger(0);
        this.mAutoInitialize = autoInitialize;
        this.mAllowParallelSyncs = allowParallelSyncs;
    }

    private final Context $$robo$$android_content_AbstractThreadedSyncAdapter$getContext() {
        return this.mContext;
    }

    private final Account $$robo$$android_content_AbstractThreadedSyncAdapter$toSyncKey(Account account) {
        if (this.mAllowParallelSyncs) {
            return account;
        }
        return null;
    }

    private final IBinder $$robo$$android_content_AbstractThreadedSyncAdapter$getSyncAdapterBinder() {
        return this.mISyncAdapterImpl.asBinder();
    }

    public abstract void onPerformSync(Account var1, Bundle var2, String var3, ContentProviderClient var4, SyncResult var5);

    private final void $$robo$$android_content_AbstractThreadedSyncAdapter$onSecurityException(Account account, Bundle extras, String authority, SyncResult syncResult) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_content_AbstractThreadedSyncAdapter$onSyncCanceled() {
        SyncThread syncThread;
        Object object = this.mSyncThreadLock;
        synchronized (object) {
            syncThread = this.mSyncThreads.get(null);
        }
        if (syncThread != null) {
            syncThread.interrupt();
        }
    }

    private final void $$robo$$android_content_AbstractThreadedSyncAdapter$onSyncCanceled(Thread thread) {
        thread.interrupt();
    }

    static void __staticInitializer__() {
        ENABLE_LOG = Build.IS_DEBUGGABLE && Log.isLoggable("SyncAdapter", 3);
    }

    private void __constructor__(Context context, boolean bl) {
        this.$$robo$$android_content_AbstractThreadedSyncAdapter$__constructor__(context, bl);
    }

    public AbstractThreadedSyncAdapter(Context context, boolean bl) {
        this(context, bl, false);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_AbstractThreadedSyncAdapter$__constructor__(android.content.Context boolean ), 0, this, context, bl);
    }

    private void __constructor__(Context context, boolean bl, boolean bl2) {
        this.$$robo$$android_content_AbstractThreadedSyncAdapter$__constructor__(context, bl, bl2);
    }

    public AbstractThreadedSyncAdapter(Context context, boolean bl, boolean bl2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_AbstractThreadedSyncAdapter$__constructor__(android.content.Context boolean boolean ), 0, this, context, bl, bl2);
    }

    public Context getContext() {
        return InvokeDynamicSupport.bootstrap("getContext", $$robo$$android_content_AbstractThreadedSyncAdapter$getContext(), 0, this);
    }

    private Account toSyncKey(Account account) {
        return InvokeDynamicSupport.bootstrap("toSyncKey", $$robo$$android_content_AbstractThreadedSyncAdapter$toSyncKey(android.accounts.Account ), 0, this, account);
    }

    public IBinder getSyncAdapterBinder() {
        return InvokeDynamicSupport.bootstrap("getSyncAdapterBinder", $$robo$$android_content_AbstractThreadedSyncAdapter$getSyncAdapterBinder(), 0, this);
    }

    public void onSecurityException(Account account, Bundle bundle, String string2, SyncResult syncResult) {
        InvokeDynamicSupport.bootstrap("onSecurityException", $$robo$$android_content_AbstractThreadedSyncAdapter$onSecurityException(android.accounts.Account android.os.Bundle java.lang.String android.content.SyncResult ), 0, this, account, bundle, string2, syncResult);
    }

    public void onSyncCanceled() {
        InvokeDynamicSupport.bootstrap("onSyncCanceled", $$robo$$android_content_AbstractThreadedSyncAdapter$onSyncCanceled(), 0, this);
    }

    public void onSyncCanceled(Thread thread) {
        InvokeDynamicSupport.bootstrap("onSyncCanceled", $$robo$$android_content_AbstractThreadedSyncAdapter$onSyncCanceled(java.lang.Thread ), 0, this, thread);
    }

    static {
        RobolectricInternals.classInitializing(AbstractThreadedSyncAdapter.class);
    }

    public /* synthetic */ AbstractThreadedSyncAdapter() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AbstractThreadedSyncAdapter)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class SyncThread
    extends Thread
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private SyncContext mSyncContext;
        private String mAuthority;
        private Account mAccount;
        private Bundle mExtras;
        private Account mThreadsKey;
        /* synthetic */ AbstractThreadedSyncAdapter this$0;

        private void $$robo$$android_content_AbstractThreadedSyncAdapter_SyncThread$__constructor__(AbstractThreadedSyncAdapter abstractThreadedSyncAdapter, String name, SyncContext syncContext, String authority, Account account, Bundle extras) {
            this.mSyncContext = syncContext;
            this.mAuthority = authority;
            this.mAccount = account;
            this.mExtras = extras;
            this.mThreadsKey = abstractThreadedSyncAdapter.toSyncKey(account);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_content_AbstractThreadedSyncAdapter_SyncThread$run() {
            Process.setThreadPriority(10);
            if (ENABLE_LOG) {
                Log.d("SyncAdapter", "Thread started");
            }
            Trace.traceBegin(128L, this.mAuthority);
            SyncResult syncResult = new SyncResult();
            ContentProviderClient provider = null;
            try {
                if (this.isCanceled()) {
                    if (ENABLE_LOG) {
                        Log.d("SyncAdapter", "Already canceled");
                    }
                    return;
                }
                if (ENABLE_LOG) {
                    Log.d("SyncAdapter", "Calling onPerformSync...");
                }
                if ((provider = this.this$0.mContext.getContentResolver().acquireContentProviderClient(this.mAuthority)) != null) {
                    this.this$0.onPerformSync(this.mAccount, this.mExtras, this.mAuthority, provider, syncResult);
                } else {
                    syncResult.databaseError = true;
                }
                if (ENABLE_LOG) {
                    Log.d("SyncAdapter", "onPerformSync done");
                }
            }
            catch (SecurityException e) {
                if (ENABLE_LOG) {
                    Log.d("SyncAdapter", "SecurityException", e);
                }
                this.this$0.onSecurityException(this.mAccount, this.mExtras, this.mAuthority, syncResult);
                syncResult.databaseError = true;
            }
            catch (Error | RuntimeException th) {
                if (ENABLE_LOG) {
                    Log.d("SyncAdapter", "caught exception", th);
                }
                throw th;
            }
            finally {
                Trace.traceEnd(128L);
                if (provider != null) {
                    provider.release();
                }
                if (!this.isCanceled()) {
                    this.mSyncContext.onFinished(syncResult);
                }
                Object e = this.this$0.mSyncThreadLock;
                synchronized (e) {
                    this.this$0.mSyncThreads.remove(this.mThreadsKey);
                }
                if (ENABLE_LOG) {
                    Log.d("SyncAdapter", "Thread finished");
                }
            }
        }

        private final boolean $$robo$$android_content_AbstractThreadedSyncAdapter_SyncThread$isCanceled() {
            return Thread.currentThread().isInterrupted();
        }

        private /* synthetic */ void $$robo$$android_content_AbstractThreadedSyncAdapter_SyncThread$__constructor__(AbstractThreadedSyncAdapter x0, String x1, SyncContext x2, String x3, Account x4, Bundle x5, 1 x6) {
        }

        private void __constructor__(AbstractThreadedSyncAdapter abstractThreadedSyncAdapter, String string2, SyncContext syncContext, String string3, Account account, Bundle bundle) {
            this.$$robo$$android_content_AbstractThreadedSyncAdapter_SyncThread$__constructor__(abstractThreadedSyncAdapter, string2, syncContext, string3, account, bundle);
        }

        private SyncThread(AbstractThreadedSyncAdapter abstractThreadedSyncAdapter, String string2, SyncContext syncContext, String string3, Account account, Bundle bundle) {
            this.this$0 = abstractThreadedSyncAdapter;
            super(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_AbstractThreadedSyncAdapter_SyncThread$__constructor__(android.content.AbstractThreadedSyncAdapter java.lang.String android.content.SyncContext java.lang.String android.accounts.Account android.os.Bundle ), 0, this, abstractThreadedSyncAdapter, string2, syncContext, string3, account, bundle);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_content_AbstractThreadedSyncAdapter_SyncThread$run(), 0, this);
        }

        private boolean isCanceled() {
            return (boolean)InvokeDynamicSupport.bootstrap("isCanceled", $$robo$$android_content_AbstractThreadedSyncAdapter_SyncThread$isCanceled(), 0, this);
        }

        private /* synthetic */ void __constructor__(AbstractThreadedSyncAdapter abstractThreadedSyncAdapter, String string2, SyncContext syncContext, String string3, Account account, Bundle bundle, 1 var7_7) {
            this.$$robo$$android_content_AbstractThreadedSyncAdapter_SyncThread$__constructor__(abstractThreadedSyncAdapter, string2, syncContext, string3, account, bundle, var7_7);
        }

        public /* synthetic */ SyncThread() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SyncThread)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class ISyncAdapterImpl
    extends ISyncAdapter.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ AbstractThreadedSyncAdapter this$0;

        private void $$robo$$android_content_AbstractThreadedSyncAdapter_ISyncAdapterImpl$__constructor__(AbstractThreadedSyncAdapter abstractThreadedSyncAdapter) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private final void $$robo$$android_content_AbstractThreadedSyncAdapter_ISyncAdapterImpl$startSync(ISyncContext syncContext, String authority, Account account, Bundle extras) {
            if (ENABLE_LOG) {
                if (extras != null) {
                    extras.size();
                }
                Log.d("SyncAdapter", "startSync() start " + authority + " " + account + " " + extras);
            }
            try {
                boolean alreadyInProgress;
                SyncContext syncContextClient = new SyncContext(syncContext);
                Account threadsKey = this.this$0.toSyncKey(account);
                Object object = this.this$0.mSyncThreadLock;
                synchronized (object) {
                    if (!this.this$0.mSyncThreads.containsKey(threadsKey)) {
                        if (this.this$0.mAutoInitialize && extras != null && extras.getBoolean("initialize", false)) {
                            try {
                                if (ContentResolver.getIsSyncable(account, authority) >= 0) return;
                                ContentResolver.setIsSyncable(account, authority, 1);
                            }
                            finally {
                                syncContextClient.onFinished(new SyncResult());
                            }
                            return;
                        }
                        SyncThread syncThread = new SyncThread(this.this$0, "SyncAdapterThread-" + this.this$0.mNumSyncStarts.incrementAndGet(), syncContextClient, authority, account, extras);
                        this.this$0.mSyncThreads.put(threadsKey, syncThread);
                        syncThread.start();
                        alreadyInProgress = false;
                    } else {
                        if (ENABLE_LOG) {
                            Log.d("SyncAdapter", "  alreadyInProgress");
                        }
                        alreadyInProgress = true;
                    }
                }
                if (!alreadyInProgress) return;
                syncContextClient.onFinished(SyncResult.ALREADY_IN_PROGRESS);
                return;
            }
            catch (Error | RuntimeException th) {
                if (!ENABLE_LOG) throw th;
                Log.d("SyncAdapter", "startSync() caught exception", th);
                throw th;
            }
            finally {
                if (ENABLE_LOG) {
                    Log.d("SyncAdapter", "startSync() finishing");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_content_AbstractThreadedSyncAdapter_ISyncAdapterImpl$cancelSync(ISyncContext syncContext) {
            try {
                SyncThread info = null;
                Object object = this.this$0.mSyncThreadLock;
                synchronized (object) {
                    for (SyncThread current : this.this$0.mSyncThreads.values()) {
                        if (current.mSyncContext.getSyncContextBinder() != syncContext.asBinder()) continue;
                        info = current;
                        break;
                    }
                }
                if (info != null) {
                    if (ENABLE_LOG) {
                        Log.d("SyncAdapter", "cancelSync() " + info.mAuthority + " " + info.mAccount);
                    }
                    if (this.this$0.mAllowParallelSyncs) {
                        this.this$0.onSyncCanceled(info);
                    } else {
                        this.this$0.onSyncCanceled();
                    }
                } else if (ENABLE_LOG) {
                    Log.w("SyncAdapter", "cancelSync() unknown context");
                }
            }
            catch (Error | RuntimeException th) {
                if (ENABLE_LOG) {
                    Log.d("SyncAdapter", "cancelSync() caught exception", th);
                }
                throw th;
            }
            finally {
                if (ENABLE_LOG) {
                    Log.d("SyncAdapter", "cancelSync() finishing");
                }
            }
        }

        private /* synthetic */ void $$robo$$android_content_AbstractThreadedSyncAdapter_ISyncAdapterImpl$__constructor__(AbstractThreadedSyncAdapter x0, 1 x1) {
        }

        private void __constructor__(AbstractThreadedSyncAdapter abstractThreadedSyncAdapter) {
            this.$$robo$$android_content_AbstractThreadedSyncAdapter_ISyncAdapterImpl$__constructor__(abstractThreadedSyncAdapter);
        }

        private ISyncAdapterImpl(AbstractThreadedSyncAdapter abstractThreadedSyncAdapter) {
            this.this$0 = abstractThreadedSyncAdapter;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_AbstractThreadedSyncAdapter_ISyncAdapterImpl$__constructor__(android.content.AbstractThreadedSyncAdapter ), 0, this, abstractThreadedSyncAdapter);
        }

        @Override
        public void startSync(ISyncContext iSyncContext, String string2, Account account, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("startSync", $$robo$$android_content_AbstractThreadedSyncAdapter_ISyncAdapterImpl$startSync(android.content.ISyncContext java.lang.String android.accounts.Account android.os.Bundle ), 0, this, iSyncContext, string2, account, bundle);
        }

        @Override
        public void cancelSync(ISyncContext iSyncContext) {
            InvokeDynamicSupport.bootstrap("cancelSync", $$robo$$android_content_AbstractThreadedSyncAdapter_ISyncAdapterImpl$cancelSync(android.content.ISyncContext ), 0, this, iSyncContext);
        }

        private /* synthetic */ void __constructor__(AbstractThreadedSyncAdapter abstractThreadedSyncAdapter, 1 var2_2) {
            this.$$robo$$android_content_AbstractThreadedSyncAdapter_ISyncAdapterImpl$__constructor__(abstractThreadedSyncAdapter, var2_2);
        }

        public /* synthetic */ ISyncAdapterImpl() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ISyncAdapterImpl)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

