/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.UndoOperation;
import android.content.UndoOwner;
import android.os.Parcel;
import android.text.TextUtils;
import android.util.ArrayMap;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class UndoManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private ArrayMap<String, UndoOwner> mOwners;
    private ArrayList<UndoState> mUndos;
    private ArrayList<UndoState> mRedos;
    private int mUpdateCount;
    private int mHistorySize;
    private UndoState mWorking;
    private int mCommitId;
    private boolean mInUndo;
    private boolean mMerged;
    private int mStateSeq;
    private int mNextSavedIdx;
    private UndoOwner[] mStateOwners;
    public static int MERGE_MODE_NONE = 0;
    public static int MERGE_MODE_UNIQUE = 1;
    public static int MERGE_MODE_ANY = 2;

    private void $$robo$$android_content_UndoManager$__constructor__() {
        this.mOwners = new ArrayMap(1);
        this.mUndos = new ArrayList();
        this.mRedos = new ArrayList();
        this.mHistorySize = 20;
        this.mCommitId = 1;
    }

    private final UndoOwner $$robo$$android_content_UndoManager$getOwner(String tag, Object data) {
        if (tag == null) {
            throw new NullPointerException("tag can't be null");
        }
        if (data == null) {
            throw new NullPointerException("data can't be null");
        }
        UndoOwner owner = this.mOwners.get(tag);
        if (owner != null) {
            if (owner.mData != data) {
                if (owner.mData != null) {
                    throw new IllegalStateException("Owner " + owner + " already exists with data " + owner.mData + " but giving different data " + data);
                }
                owner.mData = data;
            }
            return owner;
        }
        owner = new UndoOwner(tag, this);
        owner.mData = data;
        this.mOwners.put(tag, owner);
        return owner;
    }

    private final void $$robo$$android_content_UndoManager$removeOwner(UndoOwner owner) {
    }

    private final void $$robo$$android_content_UndoManager$saveInstanceState(Parcel p) {
        if (this.mUpdateCount > 0) {
            throw new IllegalStateException("Can't save state while updating");
        }
        ++this.mStateSeq;
        if (this.mStateSeq <= 0) {
            this.mStateSeq = 0;
        }
        this.mNextSavedIdx = 0;
        p.writeInt(this.mHistorySize);
        p.writeInt(this.mOwners.size());
        int i = this.mUndos.size();
        while (i > 0) {
            p.writeInt(1);
            this.mUndos.get(--i).writeToParcel(p);
        }
        i = this.mRedos.size();
        while (i > 0) {
            p.writeInt(2);
            this.mRedos.get(--i).writeToParcel(p);
        }
        p.writeInt(0);
    }

    private final void $$robo$$android_content_UndoManager$saveOwner(UndoOwner owner, Parcel out) {
        if (owner.mStateSeq == this.mStateSeq) {
            out.writeInt(owner.mSavedIdx);
        } else {
            owner.mStateSeq = this.mStateSeq;
            owner.mSavedIdx = this.mNextSavedIdx++;
            out.writeInt(owner.mSavedIdx);
            out.writeString(owner.mTag);
            out.writeInt(owner.mOpCount);
        }
    }

    private final void $$robo$$android_content_UndoManager$restoreInstanceState(Parcel p, ClassLoader loader) {
        int stype;
        if (this.mUpdateCount > 0) {
            throw new IllegalStateException("Can't save state while updating");
        }
        this.forgetUndos(null, -1);
        this.forgetRedos(null, -1);
        this.mHistorySize = p.readInt();
        this.mStateOwners = new UndoOwner[p.readInt()];
        while ((stype = p.readInt()) != 0) {
            UndoState ustate = new UndoState(this, p, loader);
            if (stype == 1) {
                this.mUndos.add(0, ustate);
                continue;
            }
            this.mRedos.add(0, ustate);
        }
    }

    private final UndoOwner $$robo$$android_content_UndoManager$restoreOwner(Parcel in) {
        int idx = in.readInt();
        UndoOwner owner = this.mStateOwners[idx];
        if (owner == null) {
            String tag = in.readString();
            int opCount = in.readInt();
            owner = new UndoOwner(tag, this);
            owner.mOpCount = opCount;
            this.mStateOwners[idx] = owner;
            this.mOwners.put(tag, owner);
        }
        return owner;
    }

    private final void $$robo$$android_content_UndoManager$setHistorySize(int size) {
        this.mHistorySize = size;
        if (this.mHistorySize >= 0 && this.countUndos(null) > this.mHistorySize) {
            this.forgetUndos(null, this.countUndos(null) - this.mHistorySize);
        }
    }

    private final int $$robo$$android_content_UndoManager$getHistorySize() {
        return this.mHistorySize;
    }

    private final int $$robo$$android_content_UndoManager$undo(UndoOwner[] owners, int count) {
        if (this.mWorking != null) {
            throw new IllegalStateException("Can't be called during an update");
        }
        int num = 0;
        int i = -1;
        this.mInUndo = true;
        UndoState us = this.getTopUndo(null);
        if (us != null) {
            us.makeExecuted();
        }
        while (count > 0 && (i = this.findPrevState(this.mUndos, owners, i)) >= 0) {
            UndoState state = this.mUndos.remove(i);
            state.undo();
            this.mRedos.add(state);
            --count;
            ++num;
        }
        this.mInUndo = false;
        return num;
    }

    private final int $$robo$$android_content_UndoManager$redo(UndoOwner[] owners, int count) {
        if (this.mWorking != null) {
            throw new IllegalStateException("Can't be called during an update");
        }
        int num = 0;
        int i = -1;
        this.mInUndo = true;
        while (count > 0 && (i = this.findPrevState(this.mRedos, owners, i)) >= 0) {
            UndoState state = this.mRedos.remove(i);
            state.redo();
            this.mUndos.add(state);
            --count;
            ++num;
        }
        this.mInUndo = false;
        return num;
    }

    private final boolean $$robo$$android_content_UndoManager$isInUndo() {
        return this.mInUndo;
    }

    private final int $$robo$$android_content_UndoManager$forgetUndos(UndoOwner[] owners, int count) {
        if (count < 0) {
            count = this.mUndos.size();
        }
        int removed = 0;
        int i = 0;
        while (i < this.mUndos.size() && removed < count) {
            UndoState state = this.mUndos.get(i);
            if (count > 0 && this.matchOwners(state, owners)) {
                state.destroy();
                this.mUndos.remove(i);
                ++removed;
                continue;
            }
            ++i;
        }
        return removed;
    }

    private final int $$robo$$android_content_UndoManager$forgetRedos(UndoOwner[] owners, int count) {
        if (count < 0) {
            count = this.mRedos.size();
        }
        int removed = 0;
        int i = 0;
        while (i < this.mRedos.size() && removed < count) {
            UndoState state = this.mRedos.get(i);
            if (count > 0 && this.matchOwners(state, owners)) {
                state.destroy();
                this.mRedos.remove(i);
                ++removed;
                continue;
            }
            ++i;
        }
        return removed;
    }

    private final int $$robo$$android_content_UndoManager$countUndos(UndoOwner[] owners) {
        if (owners == null) {
            return this.mUndos.size();
        }
        int count = 0;
        int i = 0;
        while ((i = this.findNextState(this.mUndos, owners, i)) >= 0) {
            ++count;
            ++i;
        }
        return count;
    }

    private final int $$robo$$android_content_UndoManager$countRedos(UndoOwner[] owners) {
        if (owners == null) {
            return this.mRedos.size();
        }
        int count = 0;
        int i = 0;
        while ((i = this.findNextState(this.mRedos, owners, i)) >= 0) {
            ++count;
            ++i;
        }
        return count;
    }

    private final CharSequence $$robo$$android_content_UndoManager$getUndoLabel(UndoOwner[] owners) {
        UndoState state = this.getTopUndo(owners);
        return state != null ? state.getLabel() : null;
    }

    private final CharSequence $$robo$$android_content_UndoManager$getRedoLabel(UndoOwner[] owners) {
        UndoState state = this.getTopRedo(owners);
        return state != null ? state.getLabel() : null;
    }

    private final void $$robo$$android_content_UndoManager$beginUpdate(CharSequence label) {
        if (this.mInUndo) {
            throw new IllegalStateException("Can't being update while performing undo/redo");
        }
        if (this.mUpdateCount <= 0) {
            this.createWorkingState();
            this.mMerged = false;
            this.mUpdateCount = 0;
        }
        this.mWorking.updateLabel(label);
        ++this.mUpdateCount;
    }

    private final void $$robo$$android_content_UndoManager$createWorkingState() {
        this.mWorking = new UndoState(this, this.mCommitId++);
        if (this.mCommitId < 0) {
            this.mCommitId = 1;
        }
    }

    private final boolean $$robo$$android_content_UndoManager$isInUpdate() {
        return this.mUpdateCount > 0;
    }

    private final void $$robo$$android_content_UndoManager$setUndoLabel(CharSequence label) {
        if (this.mWorking == null) {
            throw new IllegalStateException("Must be called during an update");
        }
        this.mWorking.setLabel(label);
    }

    private final void $$robo$$android_content_UndoManager$suggestUndoLabel(CharSequence label) {
        if (this.mWorking == null) {
            throw new IllegalStateException("Must be called during an update");
        }
        this.mWorking.updateLabel(label);
    }

    private final int $$robo$$android_content_UndoManager$getUpdateNestingLevel() {
        return this.mUpdateCount;
    }

    private final boolean $$robo$$android_content_UndoManager$hasOperation(UndoOwner owner) {
        if (this.mWorking == null) {
            throw new IllegalStateException("Must be called during an update");
        }
        return this.mWorking.hasOperation(owner);
    }

    private final UndoOperation<?> $$robo$$android_content_UndoManager$getLastOperation(int mergeMode) {
        return this.getLastOperation(null, null, mergeMode);
    }

    private final UndoOperation<?> $$robo$$android_content_UndoManager$getLastOperation(UndoOwner owner, int mergeMode) {
        return this.getLastOperation(null, owner, mergeMode);
    }

    private final <T extends UndoOperation> T $$robo$$android_content_UndoManager$getLastOperation(Class<T> clazz, UndoOwner owner, int mergeMode) {
        T last;
        UndoState state;
        if (this.mWorking == null) {
            throw new IllegalStateException("Must be called during an update");
        }
        if (!(mergeMode == 0 || this.mMerged || this.mWorking.hasData() || (state = this.getTopUndo(null)) == null || mergeMode != 2 && state.hasMultipleOwners() || !state.canMerge() || (last = state.getLastOperation(clazz, owner)) == null || !((UndoOperation)last).allowMerge())) {
            this.mWorking.destroy();
            this.mWorking = state;
            this.mUndos.remove(state);
            this.mMerged = true;
            return last;
        }
        return this.mWorking.getLastOperation(clazz, owner);
    }

    private final void $$robo$$android_content_UndoManager$addOperation(UndoOperation<?> op, int mergeMode) {
        UndoState state;
        if (this.mWorking == null) {
            throw new IllegalStateException("Must be called during an update");
        }
        UndoOwner owner = op.getOwner();
        if (owner.mManager != this) {
            throw new IllegalArgumentException("Given operation's owner is not in this undo manager.");
        }
        if (!(mergeMode == 0 || this.mMerged || this.mWorking.hasData() || (state = this.getTopUndo(null)) == null || mergeMode != 2 && state.hasMultipleOwners() || !state.canMerge() || !state.hasOperation(op.getOwner()))) {
            this.mWorking.destroy();
            this.mWorking = state;
            this.mUndos.remove(state);
            this.mMerged = true;
        }
        this.mWorking.addOperation(op);
    }

    private final void $$robo$$android_content_UndoManager$endUpdate() {
        if (this.mWorking == null) {
            throw new IllegalStateException("Must be called during an update");
        }
        --this.mUpdateCount;
        if (this.mUpdateCount == 0) {
            this.pushWorkingState();
        }
    }

    private final void $$robo$$android_content_UndoManager$pushWorkingState() {
        int N = this.mUndos.size() + 1;
        if (this.mWorking.hasData()) {
            this.mUndos.add(this.mWorking);
            this.forgetRedos(null, -1);
            this.mWorking.commit();
            if (N >= 2) {
                this.mUndos.get(N - 2).makeExecuted();
            }
        } else {
            this.mWorking.destroy();
        }
        this.mWorking = null;
        if (this.mHistorySize >= 0 && N > this.mHistorySize) {
            this.forgetUndos(null, N - this.mHistorySize);
        }
    }

    private final int $$robo$$android_content_UndoManager$commitState(UndoOwner owner) {
        if (this.mWorking != null && this.mWorking.hasData()) {
            if (owner == null || this.mWorking.hasOperation(owner)) {
                this.mWorking.setCanMerge(false);
                int commitId = this.mWorking.getCommitId();
                this.pushWorkingState();
                this.createWorkingState();
                this.mMerged = true;
                return commitId;
            }
        } else {
            UndoState state = this.getTopUndo(null);
            if (state != null && (owner == null || state.hasOperation(owner))) {
                state.setCanMerge(false);
                return state.getCommitId();
            }
        }
        return -1;
    }

    private final boolean $$robo$$android_content_UndoManager$uncommitState(int commitId, UndoOwner owner) {
        if (this.mWorking != null && this.mWorking.getCommitId() == commitId) {
            if (owner == null || this.mWorking.hasOperation(owner)) {
                return this.mWorking.setCanMerge(true);
            }
        } else {
            UndoState state = this.getTopUndo(null);
            if (state != null && (owner == null || state.hasOperation(owner)) && state.getCommitId() == commitId) {
                return state.setCanMerge(true);
            }
        }
        return false;
    }

    private final UndoState $$robo$$android_content_UndoManager$getTopUndo(UndoOwner[] owners) {
        if (this.mUndos.size() <= 0) {
            return null;
        }
        int i = this.findPrevState(this.mUndos, owners, -1);
        return i >= 0 ? this.mUndos.get(i) : null;
    }

    private final UndoState $$robo$$android_content_UndoManager$getTopRedo(UndoOwner[] owners) {
        if (this.mRedos.size() <= 0) {
            return null;
        }
        int i = this.findPrevState(this.mRedos, owners, -1);
        return i >= 0 ? this.mRedos.get(i) : null;
    }

    private final boolean $$robo$$android_content_UndoManager$matchOwners(UndoState state, UndoOwner[] owners) {
        if (owners == null) {
            return true;
        }
        for (int i = 0; i < owners.length; ++i) {
            if (!state.matchOwner(owners[i])) continue;
            return true;
        }
        return false;
    }

    private final int $$robo$$android_content_UndoManager$findPrevState(ArrayList<UndoState> states, UndoOwner[] owners, int from) {
        int N = states.size();
        if (from == -1) {
            from = N - 1;
        }
        if (from >= N) {
            return -1;
        }
        if (owners == null) {
            return from;
        }
        while (from >= 0) {
            UndoState state = states.get(from);
            if (this.matchOwners(state, owners)) {
                return from;
            }
            --from;
        }
        return -1;
    }

    private final int $$robo$$android_content_UndoManager$findNextState(ArrayList<UndoState> states, UndoOwner[] owners, int from) {
        int N = states.size();
        if (from < 0) {
            from = 0;
        }
        if (from >= N) {
            return -1;
        }
        if (owners == null) {
            return from;
        }
        while (from < N) {
            UndoState state = states.get(from);
            if (this.matchOwners(state, owners)) {
                return from;
            }
            ++from;
        }
        return -1;
    }

    private void __constructor__() {
        this.$$robo$$android_content_UndoManager$__constructor__();
    }

    public UndoManager() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_UndoManager$__constructor__(), 0, this);
    }

    public UndoOwner getOwner(String string2, Object object) {
        return InvokeDynamicSupport.bootstrap("getOwner", $$robo$$android_content_UndoManager$getOwner(java.lang.String java.lang.Object ), 0, this, string2, object);
    }

    void removeOwner(UndoOwner undoOwner) {
        InvokeDynamicSupport.bootstrap("removeOwner", $$robo$$android_content_UndoManager$removeOwner(android.content.UndoOwner ), 0, this, undoOwner);
    }

    public void saveInstanceState(Parcel parcel) {
        InvokeDynamicSupport.bootstrap("saveInstanceState", $$robo$$android_content_UndoManager$saveInstanceState(android.os.Parcel ), 0, this, parcel);
    }

    void saveOwner(UndoOwner undoOwner, Parcel parcel) {
        InvokeDynamicSupport.bootstrap("saveOwner", $$robo$$android_content_UndoManager$saveOwner(android.content.UndoOwner android.os.Parcel ), 0, this, undoOwner, parcel);
    }

    public void restoreInstanceState(Parcel parcel, ClassLoader classLoader) {
        InvokeDynamicSupport.bootstrap("restoreInstanceState", $$robo$$android_content_UndoManager$restoreInstanceState(android.os.Parcel java.lang.ClassLoader ), 0, this, parcel, classLoader);
    }

    UndoOwner restoreOwner(Parcel parcel) {
        return InvokeDynamicSupport.bootstrap("restoreOwner", $$robo$$android_content_UndoManager$restoreOwner(android.os.Parcel ), 0, this, parcel);
    }

    public void setHistorySize(int n) {
        InvokeDynamicSupport.bootstrap("setHistorySize", $$robo$$android_content_UndoManager$setHistorySize(int ), 0, this, n);
    }

    public int getHistorySize() {
        return (int)InvokeDynamicSupport.bootstrap("getHistorySize", $$robo$$android_content_UndoManager$getHistorySize(), 0, this);
    }

    public int undo(UndoOwner[] undoOwnerArray, int n) {
        return (int)InvokeDynamicSupport.bootstrap("undo", $$robo$$android_content_UndoManager$undo(android.content.UndoOwner[] int ), 0, this, undoOwnerArray, n);
    }

    public int redo(UndoOwner[] undoOwnerArray, int n) {
        return (int)InvokeDynamicSupport.bootstrap("redo", $$robo$$android_content_UndoManager$redo(android.content.UndoOwner[] int ), 0, this, undoOwnerArray, n);
    }

    public boolean isInUndo() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInUndo", $$robo$$android_content_UndoManager$isInUndo(), 0, this);
    }

    public int forgetUndos(UndoOwner[] undoOwnerArray, int n) {
        return (int)InvokeDynamicSupport.bootstrap("forgetUndos", $$robo$$android_content_UndoManager$forgetUndos(android.content.UndoOwner[] int ), 0, this, undoOwnerArray, n);
    }

    public int forgetRedos(UndoOwner[] undoOwnerArray, int n) {
        return (int)InvokeDynamicSupport.bootstrap("forgetRedos", $$robo$$android_content_UndoManager$forgetRedos(android.content.UndoOwner[] int ), 0, this, undoOwnerArray, n);
    }

    public int countUndos(UndoOwner[] undoOwnerArray) {
        return (int)InvokeDynamicSupport.bootstrap("countUndos", $$robo$$android_content_UndoManager$countUndos(android.content.UndoOwner[] ), 0, this, undoOwnerArray);
    }

    public int countRedos(UndoOwner[] undoOwnerArray) {
        return (int)InvokeDynamicSupport.bootstrap("countRedos", $$robo$$android_content_UndoManager$countRedos(android.content.UndoOwner[] ), 0, this, undoOwnerArray);
    }

    public CharSequence getUndoLabel(UndoOwner[] undoOwnerArray) {
        return InvokeDynamicSupport.bootstrap("getUndoLabel", $$robo$$android_content_UndoManager$getUndoLabel(android.content.UndoOwner[] ), 0, this, undoOwnerArray);
    }

    public CharSequence getRedoLabel(UndoOwner[] undoOwnerArray) {
        return InvokeDynamicSupport.bootstrap("getRedoLabel", $$robo$$android_content_UndoManager$getRedoLabel(android.content.UndoOwner[] ), 0, this, undoOwnerArray);
    }

    public void beginUpdate(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("beginUpdate", $$robo$$android_content_UndoManager$beginUpdate(java.lang.CharSequence ), 0, this, charSequence);
    }

    private void createWorkingState() {
        InvokeDynamicSupport.bootstrap("createWorkingState", $$robo$$android_content_UndoManager$createWorkingState(), 0, this);
    }

    public boolean isInUpdate() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInUpdate", $$robo$$android_content_UndoManager$isInUpdate(), 0, this);
    }

    public void setUndoLabel(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setUndoLabel", $$robo$$android_content_UndoManager$setUndoLabel(java.lang.CharSequence ), 0, this, charSequence);
    }

    public void suggestUndoLabel(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("suggestUndoLabel", $$robo$$android_content_UndoManager$suggestUndoLabel(java.lang.CharSequence ), 0, this, charSequence);
    }

    public int getUpdateNestingLevel() {
        return (int)InvokeDynamicSupport.bootstrap("getUpdateNestingLevel", $$robo$$android_content_UndoManager$getUpdateNestingLevel(), 0, this);
    }

    public boolean hasOperation(UndoOwner undoOwner) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasOperation", $$robo$$android_content_UndoManager$hasOperation(android.content.UndoOwner ), 0, this, undoOwner);
    }

    public UndoOperation<?> getLastOperation(int n) {
        return InvokeDynamicSupport.bootstrap("getLastOperation", $$robo$$android_content_UndoManager$getLastOperation(int ), 0, this, n);
    }

    public UndoOperation<?> getLastOperation(UndoOwner undoOwner, int n) {
        return InvokeDynamicSupport.bootstrap("getLastOperation", $$robo$$android_content_UndoManager$getLastOperation(android.content.UndoOwner int ), 0, this, undoOwner, n);
    }

    public <T extends UndoOperation> T getLastOperation(Class<T> clazz, UndoOwner undoOwner, int n) {
        return (T)InvokeDynamicSupport.bootstrap("getLastOperation", $$robo$$android_content_UndoManager$getLastOperation(java.lang.Class<T> android.content.UndoOwner int ), 0, this, clazz, undoOwner, n);
    }

    public void addOperation(UndoOperation<?> undoOperation, int n) {
        InvokeDynamicSupport.bootstrap("addOperation", $$robo$$android_content_UndoManager$addOperation(android.content.UndoOperation<?> int ), 0, this, undoOperation, n);
    }

    public void endUpdate() {
        InvokeDynamicSupport.bootstrap("endUpdate", $$robo$$android_content_UndoManager$endUpdate(), 0, this);
    }

    private void pushWorkingState() {
        InvokeDynamicSupport.bootstrap("pushWorkingState", $$robo$$android_content_UndoManager$pushWorkingState(), 0, this);
    }

    public int commitState(UndoOwner undoOwner) {
        return (int)InvokeDynamicSupport.bootstrap("commitState", $$robo$$android_content_UndoManager$commitState(android.content.UndoOwner ), 0, this, undoOwner);
    }

    public boolean uncommitState(int n, UndoOwner undoOwner) {
        return (boolean)InvokeDynamicSupport.bootstrap("uncommitState", $$robo$$android_content_UndoManager$uncommitState(int android.content.UndoOwner ), 0, this, n, undoOwner);
    }

    UndoState getTopUndo(UndoOwner[] undoOwnerArray) {
        return InvokeDynamicSupport.bootstrap("getTopUndo", $$robo$$android_content_UndoManager$getTopUndo(android.content.UndoOwner[] ), 0, this, undoOwnerArray);
    }

    UndoState getTopRedo(UndoOwner[] undoOwnerArray) {
        return InvokeDynamicSupport.bootstrap("getTopRedo", $$robo$$android_content_UndoManager$getTopRedo(android.content.UndoOwner[] ), 0, this, undoOwnerArray);
    }

    boolean matchOwners(UndoState undoState, UndoOwner[] undoOwnerArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("matchOwners", $$robo$$android_content_UndoManager$matchOwners(android.content.UndoManager$UndoState android.content.UndoOwner[] ), 0, this, undoState, undoOwnerArray);
    }

    int findPrevState(ArrayList<UndoState> arrayList, UndoOwner[] undoOwnerArray, int n) {
        return (int)InvokeDynamicSupport.bootstrap("findPrevState", $$robo$$android_content_UndoManager$findPrevState(java.util.ArrayList<android.content.UndoManager$UndoState> android.content.UndoOwner[] int ), 0, this, arrayList, undoOwnerArray, n);
    }

    int findNextState(ArrayList<UndoState> arrayList, UndoOwner[] undoOwnerArray, int n) {
        return (int)InvokeDynamicSupport.bootstrap("findNextState", $$robo$$android_content_UndoManager$findNextState(java.util.ArrayList<android.content.UndoManager$UndoState> android.content.UndoOwner[] int ), 0, this, arrayList, undoOwnerArray, n);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UndoManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class UndoState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private UndoManager mManager;
        private int mCommitId;
        private ArrayList<UndoOperation<?>> mOperations;
        private ArrayList<UndoOperation<?>> mRecent;
        private CharSequence mLabel;
        private boolean mCanMerge;
        private boolean mExecuted;

        private void $$robo$$android_content_UndoManager_UndoState$__constructor__(UndoManager manager, int commitId) {
            this.mOperations = new ArrayList();
            this.mCanMerge = true;
            this.mManager = manager;
            this.mCommitId = commitId;
        }

        private void $$robo$$android_content_UndoManager_UndoState$__constructor__(UndoManager manager, Parcel p, ClassLoader loader) {
            this.mOperations = new ArrayList();
            this.mCanMerge = true;
            this.mManager = manager;
            this.mCommitId = p.readInt();
            this.mCanMerge = p.readInt() != 0;
            this.mExecuted = p.readInt() != 0;
            this.mLabel = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(p);
            int N = p.readInt();
            for (int i = 0; i < N; ++i) {
                UndoOwner owner = this.mManager.restoreOwner(p);
                UndoOperation op = (UndoOperation)p.readParcelable(loader);
                op.mOwner = owner;
                this.mOperations.add(op);
            }
        }

        private final void $$robo$$android_content_UndoManager_UndoState$writeToParcel(Parcel p) {
            if (this.mRecent != null) {
                throw new IllegalStateException("Can't save state before committing");
            }
            p.writeInt(this.mCommitId);
            p.writeInt(this.mCanMerge ? 1 : 0);
            p.writeInt(this.mExecuted ? 1 : 0);
            TextUtils.writeToParcel(this.mLabel, p, 0);
            int N = this.mOperations.size();
            p.writeInt(N);
            for (int i = 0; i < N; ++i) {
                UndoOperation<?> op = this.mOperations.get(i);
                this.mManager.saveOwner(op.mOwner, p);
                p.writeParcelable(op, 0);
            }
        }

        private final int $$robo$$android_content_UndoManager_UndoState$getCommitId() {
            return this.mCommitId;
        }

        private final void $$robo$$android_content_UndoManager_UndoState$setLabel(CharSequence label) {
            this.mLabel = label;
        }

        private final void $$robo$$android_content_UndoManager_UndoState$updateLabel(CharSequence label) {
            if (this.mLabel != null) {
                this.mLabel = label;
            }
        }

        private final CharSequence $$robo$$android_content_UndoManager_UndoState$getLabel() {
            return this.mLabel;
        }

        private final boolean $$robo$$android_content_UndoManager_UndoState$setCanMerge(boolean state) {
            if (state && this.mExecuted) {
                return false;
            }
            this.mCanMerge = state;
            return true;
        }

        private final void $$robo$$android_content_UndoManager_UndoState$makeExecuted() {
            this.mExecuted = true;
        }

        private final boolean $$robo$$android_content_UndoManager_UndoState$canMerge() {
            return this.mCanMerge && !this.mExecuted;
        }

        private final int $$robo$$android_content_UndoManager_UndoState$countOperations() {
            return this.mOperations.size();
        }

        private final boolean $$robo$$android_content_UndoManager_UndoState$hasOperation(UndoOwner owner) {
            int N = this.mOperations.size();
            if (owner == null) {
                return N != 0;
            }
            for (int i = 0; i < N; ++i) {
                if (this.mOperations.get(i).getOwner() != owner) continue;
                return true;
            }
            return false;
        }

        private final boolean $$robo$$android_content_UndoManager_UndoState$hasMultipleOwners() {
            int N = this.mOperations.size();
            if (N <= 1) {
                return false;
            }
            UndoOwner owner = this.mOperations.get(0).getOwner();
            for (int i = 1; i < N; ++i) {
                if (this.mOperations.get(i).getOwner() == owner) continue;
                return true;
            }
            return false;
        }

        private final void $$robo$$android_content_UndoManager_UndoState$addOperation(UndoOperation<?> op) {
            if (this.mOperations.contains(op)) {
                throw new IllegalStateException("Already holds " + op);
            }
            this.mOperations.add(op);
            if (this.mRecent == null) {
                this.mRecent = new ArrayList();
                this.mRecent.add(op);
            }
            ++op.mOwner.mOpCount;
        }

        private final <T extends UndoOperation> T $$robo$$android_content_UndoManager_UndoState$getLastOperation(Class<T> clazz, UndoOwner owner) {
            int N = this.mOperations.size();
            if (clazz == null && owner == null) {
                return (T)(N > 0 ? this.mOperations.get(N - 1) : null);
            }
            for (int i = N - 1; i >= 0; --i) {
                UndoOperation<?> op = this.mOperations.get(i);
                if (owner != null && op.getOwner() != owner) continue;
                if (clazz != null && op.getClass() != clazz) {
                    return null;
                }
                return (T)op;
            }
            return null;
        }

        private final boolean $$robo$$android_content_UndoManager_UndoState$matchOwner(UndoOwner owner) {
            for (int i = this.mOperations.size() - 1; i >= 0; --i) {
                if (!this.mOperations.get(i).matchOwner(owner)) continue;
                return true;
            }
            return false;
        }

        private final boolean $$robo$$android_content_UndoManager_UndoState$hasData() {
            for (int i = this.mOperations.size() - 1; i >= 0; --i) {
                if (!this.mOperations.get(i).hasData()) continue;
                return true;
            }
            return false;
        }

        private final void $$robo$$android_content_UndoManager_UndoState$commit() {
            int N = this.mRecent != null ? this.mRecent.size() : 0;
            for (int i = 0; i < N; ++i) {
                this.mRecent.get(i).commit();
            }
            this.mRecent = null;
        }

        private final void $$robo$$android_content_UndoManager_UndoState$undo() {
            for (int i = this.mOperations.size() - 1; i >= 0; --i) {
                this.mOperations.get(i).undo();
            }
        }

        private final void $$robo$$android_content_UndoManager_UndoState$redo() {
            int N = this.mOperations.size();
            for (int i = 0; i < N; ++i) {
                this.mOperations.get(i).redo();
            }
        }

        private final void $$robo$$android_content_UndoManager_UndoState$destroy() {
            for (int i = this.mOperations.size() - 1; i >= 0; --i) {
                UndoOwner owner = this.mOperations.get((int)i).mOwner;
                --owner.mOpCount;
                if (owner.mOpCount > 0) continue;
                if (owner.mOpCount < 0) {
                    throw new IllegalStateException("Underflow of op count on owner " + owner + " in op " + this.mOperations.get(i));
                }
                this.mManager.removeOwner(owner);
            }
        }

        private void __constructor__(UndoManager undoManager, int n) {
            this.$$robo$$android_content_UndoManager_UndoState$__constructor__(undoManager, n);
        }

        UndoState(UndoManager undoManager, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_UndoManager_UndoState$__constructor__(android.content.UndoManager int ), 0, this, undoManager, n);
        }

        private void __constructor__(UndoManager undoManager, Parcel parcel, ClassLoader classLoader) {
            this.$$robo$$android_content_UndoManager_UndoState$__constructor__(undoManager, parcel, classLoader);
        }

        UndoState(UndoManager undoManager, Parcel parcel, ClassLoader classLoader) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_UndoManager_UndoState$__constructor__(android.content.UndoManager android.os.Parcel java.lang.ClassLoader ), 0, this, undoManager, parcel, classLoader);
        }

        void writeToParcel(Parcel parcel) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_content_UndoManager_UndoState$writeToParcel(android.os.Parcel ), 0, this, parcel);
        }

        int getCommitId() {
            return (int)InvokeDynamicSupport.bootstrap("getCommitId", $$robo$$android_content_UndoManager_UndoState$getCommitId(), 0, this);
        }

        void setLabel(CharSequence charSequence) {
            InvokeDynamicSupport.bootstrap("setLabel", $$robo$$android_content_UndoManager_UndoState$setLabel(java.lang.CharSequence ), 0, this, charSequence);
        }

        void updateLabel(CharSequence charSequence) {
            InvokeDynamicSupport.bootstrap("updateLabel", $$robo$$android_content_UndoManager_UndoState$updateLabel(java.lang.CharSequence ), 0, this, charSequence);
        }

        CharSequence getLabel() {
            return InvokeDynamicSupport.bootstrap("getLabel", $$robo$$android_content_UndoManager_UndoState$getLabel(), 0, this);
        }

        boolean setCanMerge(boolean bl) {
            return (boolean)InvokeDynamicSupport.bootstrap("setCanMerge", $$robo$$android_content_UndoManager_UndoState$setCanMerge(boolean ), 0, this, bl);
        }

        void makeExecuted() {
            InvokeDynamicSupport.bootstrap("makeExecuted", $$robo$$android_content_UndoManager_UndoState$makeExecuted(), 0, this);
        }

        boolean canMerge() {
            return (boolean)InvokeDynamicSupport.bootstrap("canMerge", $$robo$$android_content_UndoManager_UndoState$canMerge(), 0, this);
        }

        int countOperations() {
            return (int)InvokeDynamicSupport.bootstrap("countOperations", $$robo$$android_content_UndoManager_UndoState$countOperations(), 0, this);
        }

        boolean hasOperation(UndoOwner undoOwner) {
            return (boolean)InvokeDynamicSupport.bootstrap("hasOperation", $$robo$$android_content_UndoManager_UndoState$hasOperation(android.content.UndoOwner ), 0, this, undoOwner);
        }

        boolean hasMultipleOwners() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasMultipleOwners", $$robo$$android_content_UndoManager_UndoState$hasMultipleOwners(), 0, this);
        }

        void addOperation(UndoOperation<?> undoOperation) {
            InvokeDynamicSupport.bootstrap("addOperation", $$robo$$android_content_UndoManager_UndoState$addOperation(android.content.UndoOperation<?> ), 0, this, undoOperation);
        }

        <T extends UndoOperation> T getLastOperation(Class<T> clazz, UndoOwner undoOwner) {
            return (T)InvokeDynamicSupport.bootstrap("getLastOperation", $$robo$$android_content_UndoManager_UndoState$getLastOperation(java.lang.Class<T> android.content.UndoOwner ), 0, this, clazz, undoOwner);
        }

        boolean matchOwner(UndoOwner undoOwner) {
            return (boolean)InvokeDynamicSupport.bootstrap("matchOwner", $$robo$$android_content_UndoManager_UndoState$matchOwner(android.content.UndoOwner ), 0, this, undoOwner);
        }

        boolean hasData() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasData", $$robo$$android_content_UndoManager_UndoState$hasData(), 0, this);
        }

        void commit() {
            InvokeDynamicSupport.bootstrap("commit", $$robo$$android_content_UndoManager_UndoState$commit(), 0, this);
        }

        void undo() {
            InvokeDynamicSupport.bootstrap("undo", $$robo$$android_content_UndoManager_UndoState$undo(), 0, this);
        }

        void redo() {
            InvokeDynamicSupport.bootstrap("redo", $$robo$$android_content_UndoManager_UndoState$redo(), 0, this);
        }

        void destroy() {
            InvokeDynamicSupport.bootstrap("destroy", $$robo$$android_content_UndoManager_UndoState$destroy(), 0, this);
        }

        public /* synthetic */ UndoState() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UndoState)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

