/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.ArraySet;
import android.util.Log;
import com.android.internal.util.XmlUtils;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class IntentFilterVerificationInfo
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG;
    private static String TAG_DOMAIN = "domain";
    private static String ATTR_DOMAIN_NAME = "name";
    private static String ATTR_PACKAGE_NAME = "packageName";
    private static String ATTR_STATUS = "status";
    private ArraySet<String> mDomains;
    private String mPackageName;
    private int mMainStatus;
    public static Parcelable.Creator<IntentFilterVerificationInfo> CREATOR;

    private void $$robo$$android_content_pm_IntentFilterVerificationInfo$__constructor__() {
        this.mDomains = new ArraySet();
        this.mPackageName = null;
        this.mMainStatus = 0;
    }

    private void $$robo$$android_content_pm_IntentFilterVerificationInfo$__constructor__(String packageName, ArraySet<String> domains) {
        this.mDomains = new ArraySet();
        this.mPackageName = packageName;
        this.mDomains = domains;
        this.mMainStatus = 0;
    }

    private void $$robo$$android_content_pm_IntentFilterVerificationInfo$__constructor__(XmlPullParser parser) throws IOException, XmlPullParserException {
        this.mDomains = new ArraySet();
        this.readFromXml(parser);
    }

    private void $$robo$$android_content_pm_IntentFilterVerificationInfo$__constructor__(Parcel source) {
        this.mDomains = new ArraySet();
        this.readFromParcel(source);
    }

    private final String $$robo$$android_content_pm_IntentFilterVerificationInfo$getPackageName() {
        return this.mPackageName;
    }

    private final int $$robo$$android_content_pm_IntentFilterVerificationInfo$getStatus() {
        return this.mMainStatus;
    }

    private final void $$robo$$android_content_pm_IntentFilterVerificationInfo$setStatus(int s) {
        if (s >= 0 && s <= 3) {
            this.mMainStatus = s;
        } else {
            Log.w(TAG, "Trying to set a non supported status: " + s);
        }
    }

    private final Set<String> $$robo$$android_content_pm_IntentFilterVerificationInfo$getDomains() {
        return this.mDomains;
    }

    private final void $$robo$$android_content_pm_IntentFilterVerificationInfo$setDomains(ArraySet<String> list) {
        this.mDomains = list;
    }

    private final String $$robo$$android_content_pm_IntentFilterVerificationInfo$getDomainsString() {
        StringBuilder sb = new StringBuilder();
        for (String str : this.mDomains) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(str);
        }
        return sb.toString();
    }

    private final String $$robo$$android_content_pm_IntentFilterVerificationInfo$getStringFromXml(XmlPullParser parser, String attribute, String defaultValue) {
        String value = parser.getAttributeValue(null, attribute);
        if (value == null) {
            String msg = "Missing element under " + TAG + ": " + attribute + " at " + parser.getPositionDescription();
            Log.w(TAG, msg);
            return defaultValue;
        }
        return value;
    }

    private final int $$robo$$android_content_pm_IntentFilterVerificationInfo$getIntFromXml(XmlPullParser parser, String attribute, int defaultValue) {
        String value = parser.getAttributeValue(null, attribute);
        if (TextUtils.isEmpty(value)) {
            String msg = "Missing element under " + TAG + ": " + attribute + " at " + parser.getPositionDescription();
            Log.w(TAG, msg);
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    private final void $$robo$$android_content_pm_IntentFilterVerificationInfo$readFromXml(XmlPullParser parser) throws XmlPullParserException, IOException {
        int type;
        int status;
        this.mPackageName = this.getStringFromXml(parser, "packageName", null);
        if (this.mPackageName == null) {
            Log.e(TAG, "Package name cannot be null!");
        }
        if ((status = this.getIntFromXml(parser, "status", -1)) == -1) {
            Log.e(TAG, "Unknown status value: " + status);
        }
        this.mMainStatus = status;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals("domain")) {
                String name = this.getStringFromXml(parser, "name", null);
                if (!TextUtils.isEmpty(name)) {
                    this.mDomains.add(name);
                }
            } else {
                Log.w(TAG, "Unknown tag parsing IntentFilter: " + tagName);
            }
            XmlUtils.skipCurrentTag(parser);
        }
    }

    private final void $$robo$$android_content_pm_IntentFilterVerificationInfo$writeToXml(XmlSerializer serializer) throws IOException {
        serializer.attribute(null, "packageName", this.mPackageName);
        serializer.attribute(null, "status", String.valueOf(this.mMainStatus));
        for (String str : this.mDomains) {
            serializer.startTag(null, "domain");
            serializer.attribute(null, "name", str);
            serializer.endTag(null, "domain");
        }
    }

    private final String $$robo$$android_content_pm_IntentFilterVerificationInfo$getStatusString() {
        return IntentFilterVerificationInfo.getStatusStringFromValue((long)this.mMainStatus << 32);
    }

    private static final String $$robo$$android_content_pm_IntentFilterVerificationInfo$getStatusStringFromValue(long val) {
        StringBuilder sb = new StringBuilder();
        switch ((int)(val >> 32)) {
            case 2: {
                sb.append("always : ");
                sb.append(Long.toHexString(val & 0xFFFFFFFFFFFFFFFFL));
                break;
            }
            case 1: {
                sb.append("ask");
                break;
            }
            case 3: {
                sb.append("never");
                break;
            }
            case 4: {
                sb.append("always-ask");
                break;
            }
            default: {
                sb.append("undefined");
            }
        }
        return sb.toString();
    }

    private final int $$robo$$android_content_pm_IntentFilterVerificationInfo$describeContents() {
        return 0;
    }

    private final void $$robo$$android_content_pm_IntentFilterVerificationInfo$readFromParcel(Parcel source) {
        this.mPackageName = source.readString();
        this.mMainStatus = source.readInt();
        ArrayList<String> list = new ArrayList<String>();
        source.readStringList(list);
        this.mDomains.addAll(list);
    }

    private final void $$robo$$android_content_pm_IntentFilterVerificationInfo$writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mPackageName);
        dest.writeInt(this.mMainStatus);
        dest.writeStringList(new ArrayList<String>(this.mDomains));
    }

    static void __staticInitializer__() {
        TAG = IntentFilterVerificationInfo.class.getName();
        CREATOR = new Parcelable.Creator<IntentFilterVerificationInfo>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_content_pm_IntentFilterVerificationInfo_1$__constructor__() {
            }

            private final IntentFilterVerificationInfo $$robo$$android_content_pm_IntentFilterVerificationInfo_1$createFromParcel(Parcel source) {
                return new IntentFilterVerificationInfo(source);
            }

            private final IntentFilterVerificationInfo[] $$robo$$android_content_pm_IntentFilterVerificationInfo_1$newArray(int size) {
                return new IntentFilterVerificationInfo[size];
            }

            private void __constructor__() {
                this.$$robo$$android_content_pm_IntentFilterVerificationInfo_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_IntentFilterVerificationInfo_1$__constructor__(), 0, this);
            }

            @Override
            public IntentFilterVerificationInfo createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_content_pm_IntentFilterVerificationInfo_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public IntentFilterVerificationInfo[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_content_pm_IntentFilterVerificationInfo_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$android_content_pm_IntentFilterVerificationInfo$__constructor__();
    }

    public IntentFilterVerificationInfo() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_IntentFilterVerificationInfo$__constructor__(), 0, this);
    }

    private void __constructor__(String string2, ArraySet<String> arraySet) {
        this.$$robo$$android_content_pm_IntentFilterVerificationInfo$__constructor__(string2, arraySet);
    }

    public IntentFilterVerificationInfo(String string2, ArraySet<String> arraySet) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_IntentFilterVerificationInfo$__constructor__(java.lang.String android.util.ArraySet<java.lang.String> ), 0, this, string2, arraySet);
    }

    private void __constructor__(XmlPullParser xmlPullParser) throws IOException, XmlPullParserException {
        this.$$robo$$android_content_pm_IntentFilterVerificationInfo$__constructor__(xmlPullParser);
    }

    public IntentFilterVerificationInfo(XmlPullParser xmlPullParser) throws IOException, XmlPullParserException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_IntentFilterVerificationInfo$__constructor__(org.xmlpull.v1.XmlPullParser ), 0, this, xmlPullParser);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_content_pm_IntentFilterVerificationInfo$__constructor__(parcel);
    }

    public IntentFilterVerificationInfo(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_IntentFilterVerificationInfo$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    public String getPackageName() {
        return InvokeDynamicSupport.bootstrap("getPackageName", $$robo$$android_content_pm_IntentFilterVerificationInfo$getPackageName(), 0, this);
    }

    public int getStatus() {
        return (int)InvokeDynamicSupport.bootstrap("getStatus", $$robo$$android_content_pm_IntentFilterVerificationInfo$getStatus(), 0, this);
    }

    public void setStatus(int n) {
        InvokeDynamicSupport.bootstrap("setStatus", $$robo$$android_content_pm_IntentFilterVerificationInfo$setStatus(int ), 0, this, n);
    }

    public Set<String> getDomains() {
        return InvokeDynamicSupport.bootstrap("getDomains", $$robo$$android_content_pm_IntentFilterVerificationInfo$getDomains(), 0, this);
    }

    public void setDomains(ArraySet<String> arraySet) {
        InvokeDynamicSupport.bootstrap("setDomains", $$robo$$android_content_pm_IntentFilterVerificationInfo$setDomains(android.util.ArraySet<java.lang.String> ), 0, this, arraySet);
    }

    public String getDomainsString() {
        return InvokeDynamicSupport.bootstrap("getDomainsString", $$robo$$android_content_pm_IntentFilterVerificationInfo$getDomainsString(), 0, this);
    }

    String getStringFromXml(XmlPullParser xmlPullParser, String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("getStringFromXml", $$robo$$android_content_pm_IntentFilterVerificationInfo$getStringFromXml(org.xmlpull.v1.XmlPullParser java.lang.String java.lang.String ), 0, this, xmlPullParser, string2, string3);
    }

    int getIntFromXml(XmlPullParser xmlPullParser, String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrap("getIntFromXml", $$robo$$android_content_pm_IntentFilterVerificationInfo$getIntFromXml(org.xmlpull.v1.XmlPullParser java.lang.String int ), 0, this, xmlPullParser, string2, n);
    }

    public void readFromXml(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("readFromXml", $$robo$$android_content_pm_IntentFilterVerificationInfo$readFromXml(org.xmlpull.v1.XmlPullParser ), 0, this, xmlPullParser);
    }

    public void writeToXml(XmlSerializer xmlSerializer) throws IOException {
        InvokeDynamicSupport.bootstrap("writeToXml", $$robo$$android_content_pm_IntentFilterVerificationInfo$writeToXml(org.xmlpull.v1.XmlSerializer ), 0, this, xmlSerializer);
    }

    public String getStatusString() {
        return InvokeDynamicSupport.bootstrap("getStatusString", $$robo$$android_content_pm_IntentFilterVerificationInfo$getStatusString(), 0, this);
    }

    public static String getStatusStringFromValue(long l) {
        return InvokeDynamicSupport.bootstrapStatic("getStatusStringFromValue", $$robo$$android_content_pm_IntentFilterVerificationInfo$getStatusStringFromValue(long ), 0, (long)l);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_content_pm_IntentFilterVerificationInfo$describeContents(), 0, this);
    }

    private void readFromParcel(Parcel parcel) {
        InvokeDynamicSupport.bootstrap("readFromParcel", $$robo$$android_content_pm_IntentFilterVerificationInfo$readFromParcel(android.os.Parcel ), 0, this, parcel);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_content_pm_IntentFilterVerificationInfo$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    static {
        RobolectricInternals.classInitializing(IntentFilterVerificationInfo.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IntentFilterVerificationInfo)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

