/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.app.AppGlobals;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.IPackageInstaller;
import android.content.pm.IPackageInstallerCallback;
import android.content.pm.IPackageInstallerSession;
import android.content.pm.PackageManager;
import android.content.pm.VersionedPackage;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.FileBridge;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.ParcelableException;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.system.ErrnoException;
import android.system.Os;
import android.util.ExceptionUtils;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.util.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class PackageInstaller
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "PackageInstaller";
    public static boolean ENABLE_REVOCABLE_FD;
    public static String ACTION_SESSION_DETAILS = "android.content.pm.action.SESSION_DETAILS";
    public static String ACTION_SESSION_COMMITTED = "android.content.pm.action.SESSION_COMMITTED";
    public static String ACTION_CONFIRM_PERMISSIONS = "android.content.pm.action.CONFIRM_PERMISSIONS";
    public static String EXTRA_SESSION_ID = "android.content.pm.extra.SESSION_ID";
    public static String EXTRA_SESSION = "android.content.pm.extra.SESSION";
    public static String EXTRA_PACKAGE_NAME = "android.content.pm.extra.PACKAGE_NAME";
    public static String EXTRA_STATUS = "android.content.pm.extra.STATUS";
    public static String EXTRA_STATUS_MESSAGE = "android.content.pm.extra.STATUS_MESSAGE";
    public static String EXTRA_OTHER_PACKAGE_NAME = "android.content.pm.extra.OTHER_PACKAGE_NAME";
    public static String EXTRA_STORAGE_PATH = "android.content.pm.extra.STORAGE_PATH";
    @Deprecated
    public static String EXTRA_PACKAGE_NAMES = "android.content.pm.extra.PACKAGE_NAMES";
    public static String EXTRA_LEGACY_STATUS = "android.content.pm.extra.LEGACY_STATUS";
    public static String EXTRA_LEGACY_BUNDLE = "android.content.pm.extra.LEGACY_BUNDLE";
    public static String EXTRA_CALLBACK = "android.content.pm.extra.CALLBACK";
    public static int STATUS_PENDING_USER_ACTION = -1;
    public static int STATUS_SUCCESS = 0;
    public static int STATUS_FAILURE = 1;
    public static int STATUS_FAILURE_BLOCKED = 2;
    public static int STATUS_FAILURE_ABORTED = 3;
    public static int STATUS_FAILURE_INVALID = 4;
    public static int STATUS_FAILURE_CONFLICT = 5;
    public static int STATUS_FAILURE_STORAGE = 6;
    public static int STATUS_FAILURE_INCOMPATIBLE = 7;
    private IPackageInstaller mInstaller;
    private int mUserId;
    private String mInstallerPackageName;
    private ArrayList<SessionCallbackDelegate> mDelegates;

    private void $$robo$$android_content_pm_PackageInstaller$__constructor__(IPackageInstaller installer, String installerPackageName, int userId) {
        this.mDelegates = new ArrayList();
        this.mInstaller = installer;
        this.mInstallerPackageName = installerPackageName;
        this.mUserId = userId;
    }

    private final int $$robo$$android_content_pm_PackageInstaller$createSession(SessionParams params) throws IOException {
        try {
            return this.mInstaller.createSession(params, this.mInstallerPackageName, this.mUserId);
        }
        catch (RuntimeException e) {
            ExceptionUtils.maybeUnwrapIOException(e);
            throw e;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final Session $$robo$$android_content_pm_PackageInstaller$openSession(int sessionId) throws IOException {
        try {
            return new Session(this.mInstaller.openSession(sessionId));
        }
        catch (RuntimeException e) {
            ExceptionUtils.maybeUnwrapIOException(e);
            throw e;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_content_pm_PackageInstaller$updateSessionAppIcon(int sessionId, Bitmap appIcon) {
        try {
            this.mInstaller.updateSessionAppIcon(sessionId, appIcon);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_content_pm_PackageInstaller$updateSessionAppLabel(int sessionId, CharSequence appLabel) {
        try {
            String val = appLabel != null ? appLabel.toString() : null;
            this.mInstaller.updateSessionAppLabel(sessionId, val);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_content_pm_PackageInstaller$abandonSession(int sessionId) {
        try {
            this.mInstaller.abandonSession(sessionId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final SessionInfo $$robo$$android_content_pm_PackageInstaller$getSessionInfo(int sessionId) {
        try {
            return this.mInstaller.getSessionInfo(sessionId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final List<SessionInfo> $$robo$$android_content_pm_PackageInstaller$getAllSessions() {
        try {
            return this.mInstaller.getAllSessions(this.mUserId).getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final List<SessionInfo> $$robo$$android_content_pm_PackageInstaller$getMySessions() {
        try {
            return this.mInstaller.getMySessions(this.mInstallerPackageName, this.mUserId).getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_content_pm_PackageInstaller$uninstall(String packageName, IntentSender statusReceiver) {
        this.uninstall(packageName, 0, statusReceiver);
    }

    private final void $$robo$$android_content_pm_PackageInstaller$uninstall(String packageName, int flags, IntentSender statusReceiver) {
        this.uninstall(new VersionedPackage(packageName, -1), flags, statusReceiver);
    }

    private final void $$robo$$android_content_pm_PackageInstaller$uninstall(VersionedPackage versionedPackage, IntentSender statusReceiver) {
        this.uninstall(versionedPackage, 0, statusReceiver);
    }

    private final void $$robo$$android_content_pm_PackageInstaller$uninstall(VersionedPackage versionedPackage, int flags, IntentSender statusReceiver) {
        Preconditions.checkNotNull(versionedPackage, "versionedPackage cannot be null");
        try {
            this.mInstaller.uninstall(versionedPackage, this.mInstallerPackageName, flags, statusReceiver, this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_content_pm_PackageInstaller$setPermissionsResult(int sessionId, boolean accepted) {
        try {
            this.mInstaller.setPermissionsResult(sessionId, accepted);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final void $$robo$$android_content_pm_PackageInstaller$addSessionCallback(SessionCallback callback) {
        this.registerSessionCallback(callback);
    }

    private final void $$robo$$android_content_pm_PackageInstaller$registerSessionCallback(SessionCallback callback) {
        this.registerSessionCallback(callback, new Handler());
    }

    @Deprecated
    private final void $$robo$$android_content_pm_PackageInstaller$addSessionCallback(SessionCallback callback, Handler handler) {
        this.registerSessionCallback(callback, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_content_pm_PackageInstaller$registerSessionCallback(SessionCallback callback, Handler handler) {
        ArrayList<SessionCallbackDelegate> arrayList = this.mDelegates;
        synchronized (arrayList) {
            SessionCallbackDelegate delegate = new SessionCallbackDelegate(callback, handler.getLooper());
            try {
                this.mInstaller.registerCallback(delegate, this.mUserId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            this.mDelegates.add(delegate);
        }
    }

    @Deprecated
    private final void $$robo$$android_content_pm_PackageInstaller$removeSessionCallback(SessionCallback callback) {
        this.unregisterSessionCallback(callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_content_pm_PackageInstaller$unregisterSessionCallback(SessionCallback callback) {
        ArrayList<SessionCallbackDelegate> arrayList = this.mDelegates;
        synchronized (arrayList) {
            Iterator<SessionCallbackDelegate> i = this.mDelegates.iterator();
            while (i.hasNext()) {
                SessionCallbackDelegate delegate = i.next();
                if (delegate.mCallback != callback) continue;
                try {
                    this.mInstaller.unregisterCallback(delegate);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
                i.remove();
            }
        }
    }

    static void __staticInitializer__() {
        ENABLE_REVOCABLE_FD = SystemProperties.getBoolean("fw.revocable_fd", false);
    }

    private void __constructor__(IPackageInstaller iPackageInstaller, String string2, int n) {
        this.$$robo$$android_content_pm_PackageInstaller$__constructor__(iPackageInstaller, string2, n);
    }

    public PackageInstaller(IPackageInstaller iPackageInstaller, String string2, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageInstaller$__constructor__(android.content.pm.IPackageInstaller java.lang.String int ), 0, this, iPackageInstaller, string2, n);
    }

    public int createSession(SessionParams sessionParams) throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("createSession", $$robo$$android_content_pm_PackageInstaller$createSession(android.content.pm.PackageInstaller$SessionParams ), 0, this, sessionParams);
    }

    public Session openSession(int n) throws IOException {
        return InvokeDynamicSupport.bootstrap("openSession", $$robo$$android_content_pm_PackageInstaller$openSession(int ), 0, this, n);
    }

    public void updateSessionAppIcon(int n, Bitmap bitmap) {
        InvokeDynamicSupport.bootstrap("updateSessionAppIcon", $$robo$$android_content_pm_PackageInstaller$updateSessionAppIcon(int android.graphics.Bitmap ), 0, this, n, bitmap);
    }

    public void updateSessionAppLabel(int n, CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("updateSessionAppLabel", $$robo$$android_content_pm_PackageInstaller$updateSessionAppLabel(int java.lang.CharSequence ), 0, this, n, charSequence);
    }

    public void abandonSession(int n) {
        InvokeDynamicSupport.bootstrap("abandonSession", $$robo$$android_content_pm_PackageInstaller$abandonSession(int ), 0, this, n);
    }

    public SessionInfo getSessionInfo(int n) {
        return InvokeDynamicSupport.bootstrap("getSessionInfo", $$robo$$android_content_pm_PackageInstaller$getSessionInfo(int ), 0, this, n);
    }

    public List<SessionInfo> getAllSessions() {
        return InvokeDynamicSupport.bootstrap("getAllSessions", $$robo$$android_content_pm_PackageInstaller$getAllSessions(), 0, this);
    }

    public List<SessionInfo> getMySessions() {
        return InvokeDynamicSupport.bootstrap("getMySessions", $$robo$$android_content_pm_PackageInstaller$getMySessions(), 0, this);
    }

    public void uninstall(String string2, IntentSender intentSender) {
        InvokeDynamicSupport.bootstrap("uninstall", $$robo$$android_content_pm_PackageInstaller$uninstall(java.lang.String android.content.IntentSender ), 0, this, string2, intentSender);
    }

    public void uninstall(String string2, int n, IntentSender intentSender) {
        InvokeDynamicSupport.bootstrap("uninstall", $$robo$$android_content_pm_PackageInstaller$uninstall(java.lang.String int android.content.IntentSender ), 0, this, string2, n, intentSender);
    }

    public void uninstall(VersionedPackage versionedPackage, IntentSender intentSender) {
        InvokeDynamicSupport.bootstrap("uninstall", $$robo$$android_content_pm_PackageInstaller$uninstall(android.content.pm.VersionedPackage android.content.IntentSender ), 0, this, versionedPackage, intentSender);
    }

    public void uninstall(VersionedPackage versionedPackage, int n, IntentSender intentSender) {
        InvokeDynamicSupport.bootstrap("uninstall", $$robo$$android_content_pm_PackageInstaller$uninstall(android.content.pm.VersionedPackage int android.content.IntentSender ), 0, this, versionedPackage, n, intentSender);
    }

    public void setPermissionsResult(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("setPermissionsResult", $$robo$$android_content_pm_PackageInstaller$setPermissionsResult(int boolean ), 0, this, n, bl);
    }

    @Deprecated
    public void addSessionCallback(SessionCallback sessionCallback) {
        InvokeDynamicSupport.bootstrap("addSessionCallback", $$robo$$android_content_pm_PackageInstaller$addSessionCallback(android.content.pm.PackageInstaller$SessionCallback ), 0, this, sessionCallback);
    }

    public void registerSessionCallback(SessionCallback sessionCallback) {
        InvokeDynamicSupport.bootstrap("registerSessionCallback", $$robo$$android_content_pm_PackageInstaller$registerSessionCallback(android.content.pm.PackageInstaller$SessionCallback ), 0, this, sessionCallback);
    }

    @Deprecated
    public void addSessionCallback(SessionCallback sessionCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("addSessionCallback", $$robo$$android_content_pm_PackageInstaller$addSessionCallback(android.content.pm.PackageInstaller$SessionCallback android.os.Handler ), 0, this, sessionCallback, handler);
    }

    public void registerSessionCallback(SessionCallback sessionCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("registerSessionCallback", $$robo$$android_content_pm_PackageInstaller$registerSessionCallback(android.content.pm.PackageInstaller$SessionCallback android.os.Handler ), 0, this, sessionCallback, handler);
    }

    @Deprecated
    public void removeSessionCallback(SessionCallback sessionCallback) {
        InvokeDynamicSupport.bootstrap("removeSessionCallback", $$robo$$android_content_pm_PackageInstaller$removeSessionCallback(android.content.pm.PackageInstaller$SessionCallback ), 0, this, sessionCallback);
    }

    public void unregisterSessionCallback(SessionCallback sessionCallback) {
        InvokeDynamicSupport.bootstrap("unregisterSessionCallback", $$robo$$android_content_pm_PackageInstaller$unregisterSessionCallback(android.content.pm.PackageInstaller$SessionCallback ), 0, this, sessionCallback);
    }

    static {
        RobolectricInternals.classInitializing(PackageInstaller.class);
    }

    public /* synthetic */ PackageInstaller() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PackageInstaller)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class SessionInfo
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int sessionId;
        public String installerPackageName;
        public String resolvedBaseCodePath;
        public float progress;
        public boolean sealed;
        public boolean active;
        public int mode;
        public int installReason;
        public long sizeBytes;
        public String appPackageName;
        public Bitmap appIcon;
        public CharSequence appLabel;
        public int installLocation;
        public Uri originatingUri;
        public int originatingUid;
        public Uri referrerUri;
        public String[] grantedRuntimePermissions;
        public int installFlags;
        public static Parcelable.Creator<SessionInfo> CREATOR;

        private void $$robo$$android_content_pm_PackageInstaller_SessionInfo$__constructor__() {
        }

        private void $$robo$$android_content_pm_PackageInstaller_SessionInfo$__constructor__(Parcel source) {
            this.sessionId = source.readInt();
            this.installerPackageName = source.readString();
            this.resolvedBaseCodePath = source.readString();
            this.progress = source.readFloat();
            this.sealed = source.readInt() != 0;
            this.active = source.readInt() != 0;
            this.mode = source.readInt();
            this.installReason = source.readInt();
            this.sizeBytes = source.readLong();
            this.appPackageName = source.readString();
            this.appIcon = (Bitmap)source.readParcelable(null);
            this.appLabel = source.readString();
            this.installLocation = source.readInt();
            this.originatingUri = (Uri)source.readParcelable(null);
            this.originatingUid = source.readInt();
            this.referrerUri = (Uri)source.readParcelable(null);
            this.grantedRuntimePermissions = source.readStringArray();
            this.installFlags = source.readInt();
        }

        private final int $$robo$$android_content_pm_PackageInstaller_SessionInfo$getSessionId() {
            return this.sessionId;
        }

        private final String $$robo$$android_content_pm_PackageInstaller_SessionInfo$getInstallerPackageName() {
            return this.installerPackageName;
        }

        private final float $$robo$$android_content_pm_PackageInstaller_SessionInfo$getProgress() {
            return this.progress;
        }

        private final boolean $$robo$$android_content_pm_PackageInstaller_SessionInfo$isActive() {
            return this.active;
        }

        private final boolean $$robo$$android_content_pm_PackageInstaller_SessionInfo$isSealed() {
            return this.sealed;
        }

        private final int $$robo$$android_content_pm_PackageInstaller_SessionInfo$getInstallReason() {
            return this.installReason;
        }

        @Deprecated
        private final boolean $$robo$$android_content_pm_PackageInstaller_SessionInfo$isOpen() {
            return this.isActive();
        }

        private final String $$robo$$android_content_pm_PackageInstaller_SessionInfo$getAppPackageName() {
            return this.appPackageName;
        }

        private final Bitmap $$robo$$android_content_pm_PackageInstaller_SessionInfo$getAppIcon() {
            if (this.appIcon == null) {
                try {
                    SessionInfo info = AppGlobals.getPackageManager().getPackageInstaller().getSessionInfo(this.sessionId);
                    this.appIcon = info != null ? info.appIcon : null;
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
            return this.appIcon;
        }

        private final CharSequence $$robo$$android_content_pm_PackageInstaller_SessionInfo$getAppLabel() {
            return this.appLabel;
        }

        private final Intent $$robo$$android_content_pm_PackageInstaller_SessionInfo$createDetailsIntent() {
            Intent intent = new Intent("android.content.pm.action.SESSION_DETAILS");
            intent.putExtra("android.content.pm.extra.SESSION_ID", this.sessionId);
            intent.setPackage(this.installerPackageName);
            intent.setFlags(0x10000000);
            return intent;
        }

        private final int $$robo$$android_content_pm_PackageInstaller_SessionInfo$getMode() {
            return this.mode;
        }

        private final int $$robo$$android_content_pm_PackageInstaller_SessionInfo$getInstallLocation() {
            return this.installLocation;
        }

        private final long $$robo$$android_content_pm_PackageInstaller_SessionInfo$getSize() {
            return this.sizeBytes;
        }

        private final Uri $$robo$$android_content_pm_PackageInstaller_SessionInfo$getOriginatingUri() {
            return this.originatingUri;
        }

        private final int $$robo$$android_content_pm_PackageInstaller_SessionInfo$getOriginatingUid() {
            return this.originatingUid;
        }

        private final Uri $$robo$$android_content_pm_PackageInstaller_SessionInfo$getReferrerUri() {
            return this.referrerUri;
        }

        private final String[] $$robo$$android_content_pm_PackageInstaller_SessionInfo$getGrantedRuntimePermissions() {
            return this.grantedRuntimePermissions;
        }

        private final boolean $$robo$$android_content_pm_PackageInstaller_SessionInfo$getAllowDowngrade() {
            return (this.installFlags & 0x80) != 0;
        }

        private final boolean $$robo$$android_content_pm_PackageInstaller_SessionInfo$getDontKillApp() {
            return (this.installFlags & 0x1000) != 0;
        }

        private final boolean $$robo$$android_content_pm_PackageInstaller_SessionInfo$getInstallAsInstantApp(boolean isInstantApp) {
            return (this.installFlags & 0x800) != 0;
        }

        private final boolean $$robo$$android_content_pm_PackageInstaller_SessionInfo$getInstallAsFullApp(boolean isInstantApp) {
            return (this.installFlags & 0x4000) != 0;
        }

        private final boolean $$robo$$android_content_pm_PackageInstaller_SessionInfo$getInstallAsVirtualPreload() {
            return (this.installFlags & 0x10000) != 0;
        }

        private final boolean $$robo$$android_content_pm_PackageInstaller_SessionInfo$getAllocateAggressive() {
            return (this.installFlags & 0x8000) != 0;
        }

        @Deprecated
        private final Intent $$robo$$android_content_pm_PackageInstaller_SessionInfo$getDetailsIntent() {
            return this.createDetailsIntent();
        }

        private final int $$robo$$android_content_pm_PackageInstaller_SessionInfo$describeContents() {
            return 0;
        }

        private final void $$robo$$android_content_pm_PackageInstaller_SessionInfo$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.sessionId);
            dest.writeString(this.installerPackageName);
            dest.writeString(this.resolvedBaseCodePath);
            dest.writeFloat(this.progress);
            dest.writeInt(this.sealed ? 1 : 0);
            dest.writeInt(this.active ? 1 : 0);
            dest.writeInt(this.mode);
            dest.writeInt(this.installReason);
            dest.writeLong(this.sizeBytes);
            dest.writeString(this.appPackageName);
            dest.writeParcelable(this.appIcon, flags);
            dest.writeString(this.appLabel != null ? this.appLabel.toString() : null);
            dest.writeInt(this.installLocation);
            dest.writeParcelable(this.originatingUri, flags);
            dest.writeInt(this.originatingUid);
            dest.writeParcelable(this.referrerUri, flags);
            dest.writeStringArray(this.grantedRuntimePermissions);
            dest.writeInt(this.installFlags);
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<SessionInfo>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_content_pm_PackageInstaller_SessionInfo_1$__constructor__() {
                }

                private final SessionInfo $$robo$$android_content_pm_PackageInstaller_SessionInfo_1$createFromParcel(Parcel p) {
                    return new SessionInfo(p);
                }

                private final SessionInfo[] $$robo$$android_content_pm_PackageInstaller_SessionInfo_1$newArray(int size) {
                    return new SessionInfo[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_content_pm_PackageInstaller_SessionInfo_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageInstaller_SessionInfo_1$__constructor__(), 0, this);
                }

                @Override
                public SessionInfo createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_content_pm_PackageInstaller_SessionInfo_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public SessionInfo[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_content_pm_PackageInstaller_SessionInfo_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__() {
            this.$$robo$$android_content_pm_PackageInstaller_SessionInfo$__constructor__();
        }

        public SessionInfo() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageInstaller_SessionInfo$__constructor__(), 0, this);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_content_pm_PackageInstaller_SessionInfo$__constructor__(parcel);
        }

        public SessionInfo(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageInstaller_SessionInfo$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        public int getSessionId() {
            return (int)InvokeDynamicSupport.bootstrap("getSessionId", $$robo$$android_content_pm_PackageInstaller_SessionInfo$getSessionId(), 0, this);
        }

        public String getInstallerPackageName() {
            return InvokeDynamicSupport.bootstrap("getInstallerPackageName", $$robo$$android_content_pm_PackageInstaller_SessionInfo$getInstallerPackageName(), 0, this);
        }

        public float getProgress() {
            return (float)InvokeDynamicSupport.bootstrap("getProgress", $$robo$$android_content_pm_PackageInstaller_SessionInfo$getProgress(), 0, this);
        }

        public boolean isActive() {
            return (boolean)InvokeDynamicSupport.bootstrap("isActive", $$robo$$android_content_pm_PackageInstaller_SessionInfo$isActive(), 0, this);
        }

        public boolean isSealed() {
            return (boolean)InvokeDynamicSupport.bootstrap("isSealed", $$robo$$android_content_pm_PackageInstaller_SessionInfo$isSealed(), 0, this);
        }

        public int getInstallReason() {
            return (int)InvokeDynamicSupport.bootstrap("getInstallReason", $$robo$$android_content_pm_PackageInstaller_SessionInfo$getInstallReason(), 0, this);
        }

        @Deprecated
        public boolean isOpen() {
            return (boolean)InvokeDynamicSupport.bootstrap("isOpen", $$robo$$android_content_pm_PackageInstaller_SessionInfo$isOpen(), 0, this);
        }

        public String getAppPackageName() {
            return InvokeDynamicSupport.bootstrap("getAppPackageName", $$robo$$android_content_pm_PackageInstaller_SessionInfo$getAppPackageName(), 0, this);
        }

        public Bitmap getAppIcon() {
            return InvokeDynamicSupport.bootstrap("getAppIcon", $$robo$$android_content_pm_PackageInstaller_SessionInfo$getAppIcon(), 0, this);
        }

        public CharSequence getAppLabel() {
            return InvokeDynamicSupport.bootstrap("getAppLabel", $$robo$$android_content_pm_PackageInstaller_SessionInfo$getAppLabel(), 0, this);
        }

        public Intent createDetailsIntent() {
            return InvokeDynamicSupport.bootstrap("createDetailsIntent", $$robo$$android_content_pm_PackageInstaller_SessionInfo$createDetailsIntent(), 0, this);
        }

        public int getMode() {
            return (int)InvokeDynamicSupport.bootstrap("getMode", $$robo$$android_content_pm_PackageInstaller_SessionInfo$getMode(), 0, this);
        }

        public int getInstallLocation() {
            return (int)InvokeDynamicSupport.bootstrap("getInstallLocation", $$robo$$android_content_pm_PackageInstaller_SessionInfo$getInstallLocation(), 0, this);
        }

        public long getSize() {
            return (long)InvokeDynamicSupport.bootstrap("getSize", $$robo$$android_content_pm_PackageInstaller_SessionInfo$getSize(), 0, this);
        }

        public Uri getOriginatingUri() {
            return InvokeDynamicSupport.bootstrap("getOriginatingUri", $$robo$$android_content_pm_PackageInstaller_SessionInfo$getOriginatingUri(), 0, this);
        }

        public int getOriginatingUid() {
            return (int)InvokeDynamicSupport.bootstrap("getOriginatingUid", $$robo$$android_content_pm_PackageInstaller_SessionInfo$getOriginatingUid(), 0, this);
        }

        public Uri getReferrerUri() {
            return InvokeDynamicSupport.bootstrap("getReferrerUri", $$robo$$android_content_pm_PackageInstaller_SessionInfo$getReferrerUri(), 0, this);
        }

        public String[] getGrantedRuntimePermissions() {
            return InvokeDynamicSupport.bootstrap("getGrantedRuntimePermissions", $$robo$$android_content_pm_PackageInstaller_SessionInfo$getGrantedRuntimePermissions(), 0, this);
        }

        public boolean getAllowDowngrade() {
            return (boolean)InvokeDynamicSupport.bootstrap("getAllowDowngrade", $$robo$$android_content_pm_PackageInstaller_SessionInfo$getAllowDowngrade(), 0, this);
        }

        public boolean getDontKillApp() {
            return (boolean)InvokeDynamicSupport.bootstrap("getDontKillApp", $$robo$$android_content_pm_PackageInstaller_SessionInfo$getDontKillApp(), 0, this);
        }

        public boolean getInstallAsInstantApp(boolean bl) {
            return (boolean)InvokeDynamicSupport.bootstrap("getInstallAsInstantApp", $$robo$$android_content_pm_PackageInstaller_SessionInfo$getInstallAsInstantApp(boolean ), 0, this, bl);
        }

        public boolean getInstallAsFullApp(boolean bl) {
            return (boolean)InvokeDynamicSupport.bootstrap("getInstallAsFullApp", $$robo$$android_content_pm_PackageInstaller_SessionInfo$getInstallAsFullApp(boolean ), 0, this, bl);
        }

        public boolean getInstallAsVirtualPreload() {
            return (boolean)InvokeDynamicSupport.bootstrap("getInstallAsVirtualPreload", $$robo$$android_content_pm_PackageInstaller_SessionInfo$getInstallAsVirtualPreload(), 0, this);
        }

        public boolean getAllocateAggressive() {
            return (boolean)InvokeDynamicSupport.bootstrap("getAllocateAggressive", $$robo$$android_content_pm_PackageInstaller_SessionInfo$getAllocateAggressive(), 0, this);
        }

        @Deprecated
        public Intent getDetailsIntent() {
            return InvokeDynamicSupport.bootstrap("getDetailsIntent", $$robo$$android_content_pm_PackageInstaller_SessionInfo$getDetailsIntent(), 0, this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_content_pm_PackageInstaller_SessionInfo$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_content_pm_PackageInstaller_SessionInfo$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        static {
            RobolectricInternals.classInitializing(SessionInfo.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SessionInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class SessionParams
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int MODE_INVALID = -1;
        public static int MODE_FULL_INSTALL = 1;
        public static int MODE_INHERIT_EXISTING = 2;
        public static int UID_UNKNOWN = -1;
        public int mode;
        public int installFlags;
        public int installLocation;
        public int installReason;
        public long sizeBytes;
        public String appPackageName;
        public Bitmap appIcon;
        public String appLabel;
        public long appIconLastModified;
        public Uri originatingUri;
        public int originatingUid;
        public Uri referrerUri;
        public String abiOverride;
        public String volumeUuid;
        public String[] grantedRuntimePermissions;
        public static Parcelable.Creator<SessionParams> CREATOR;

        private void $$robo$$android_content_pm_PackageInstaller_SessionParams$__constructor__(int mode) {
            this.mode = -1;
            this.installLocation = 1;
            this.installReason = 0;
            this.sizeBytes = -1L;
            this.appIconLastModified = -1L;
            this.originatingUid = -1;
            this.mode = mode;
        }

        private void $$robo$$android_content_pm_PackageInstaller_SessionParams$__constructor__(Parcel source) {
            this.mode = -1;
            this.installLocation = 1;
            this.installReason = 0;
            this.sizeBytes = -1L;
            this.appIconLastModified = -1L;
            this.originatingUid = -1;
            this.mode = source.readInt();
            this.installFlags = source.readInt();
            this.installLocation = source.readInt();
            this.installReason = source.readInt();
            this.sizeBytes = source.readLong();
            this.appPackageName = source.readString();
            this.appIcon = (Bitmap)source.readParcelable(null);
            this.appLabel = source.readString();
            this.originatingUri = (Uri)source.readParcelable(null);
            this.originatingUid = source.readInt();
            this.referrerUri = (Uri)source.readParcelable(null);
            this.abiOverride = source.readString();
            this.volumeUuid = source.readString();
            this.grantedRuntimePermissions = source.readStringArray();
        }

        private final boolean $$robo$$android_content_pm_PackageInstaller_SessionParams$areHiddenOptionsSet() {
            return (this.installFlags & 0x1D880) != this.installFlags || this.abiOverride != null || this.volumeUuid != null;
        }

        private final void $$robo$$android_content_pm_PackageInstaller_SessionParams$setInstallLocation(int installLocation) {
            this.installLocation = installLocation;
        }

        private final void $$robo$$android_content_pm_PackageInstaller_SessionParams$setSize(long sizeBytes) {
            this.sizeBytes = sizeBytes;
        }

        private final void $$robo$$android_content_pm_PackageInstaller_SessionParams$setAppPackageName(String appPackageName) {
            this.appPackageName = appPackageName;
        }

        private final void $$robo$$android_content_pm_PackageInstaller_SessionParams$setAppIcon(Bitmap appIcon) {
            this.appIcon = appIcon;
        }

        private final void $$robo$$android_content_pm_PackageInstaller_SessionParams$setAppLabel(CharSequence appLabel) {
            this.appLabel = appLabel != null ? appLabel.toString() : null;
        }

        private final void $$robo$$android_content_pm_PackageInstaller_SessionParams$setOriginatingUri(Uri originatingUri) {
            this.originatingUri = originatingUri;
        }

        private final void $$robo$$android_content_pm_PackageInstaller_SessionParams$setOriginatingUid(int originatingUid) {
            this.originatingUid = originatingUid;
        }

        private final void $$robo$$android_content_pm_PackageInstaller_SessionParams$setReferrerUri(Uri referrerUri) {
            this.referrerUri = referrerUri;
        }

        private final void $$robo$$android_content_pm_PackageInstaller_SessionParams$setGrantedRuntimePermissions(String[] permissions) {
            this.installFlags |= 0x100;
            this.grantedRuntimePermissions = permissions;
        }

        private final void $$robo$$android_content_pm_PackageInstaller_SessionParams$setInstallFlagsInternal() {
            this.installFlags |= 0x10;
            this.installFlags &= 0xFFFFFFF7;
        }

        private final void $$robo$$android_content_pm_PackageInstaller_SessionParams$setAllowDowngrade(boolean allowDowngrade) {
            this.installFlags = allowDowngrade ? (this.installFlags |= 0x80) : (this.installFlags &= 0xFFFFFF7F);
        }

        private final void $$robo$$android_content_pm_PackageInstaller_SessionParams$setInstallFlagsExternal() {
            this.installFlags |= 8;
            this.installFlags &= 0xFFFFFFEF;
        }

        private final void $$robo$$android_content_pm_PackageInstaller_SessionParams$setInstallFlagsForcePermissionPrompt() {
            this.installFlags |= 0x400;
        }

        private final void $$robo$$android_content_pm_PackageInstaller_SessionParams$setDontKillApp(boolean dontKillApp) {
            this.installFlags = dontKillApp ? (this.installFlags |= 0x1000) : (this.installFlags &= 0xFFFFEFFF);
        }

        private final void $$robo$$android_content_pm_PackageInstaller_SessionParams$setInstallAsInstantApp(boolean isInstantApp) {
            if (isInstantApp) {
                this.installFlags |= 0x800;
                this.installFlags &= 0xFFFFBFFF;
            } else {
                this.installFlags &= 0xFFFFF7FF;
                this.installFlags |= 0x4000;
            }
        }

        private final void $$robo$$android_content_pm_PackageInstaller_SessionParams$setInstallAsVirtualPreload() {
            this.installFlags |= 0x10000;
        }

        private final void $$robo$$android_content_pm_PackageInstaller_SessionParams$setInstallReason(int installReason) {
            this.installReason = installReason;
        }

        private final void $$robo$$android_content_pm_PackageInstaller_SessionParams$setAllocateAggressive(boolean allocateAggressive) {
            this.installFlags = allocateAggressive ? (this.installFlags |= 0x8000) : (this.installFlags &= 0xFFFF7FFF);
        }

        private final void $$robo$$android_content_pm_PackageInstaller_SessionParams$dump(IndentingPrintWriter pw) {
            pw.printPair("mode", this.mode);
            pw.printHexPair("installFlags", this.installFlags);
            pw.printPair("installLocation", this.installLocation);
            pw.printPair("sizeBytes", this.sizeBytes);
            pw.printPair("appPackageName", this.appPackageName);
            pw.printPair("appIcon", this.appIcon != null);
            pw.printPair("appLabel", this.appLabel);
            pw.printPair("originatingUri", this.originatingUri);
            pw.printPair("originatingUid", this.originatingUid);
            pw.printPair("referrerUri", this.referrerUri);
            pw.printPair("abiOverride", this.abiOverride);
            pw.printPair("volumeUuid", this.volumeUuid);
            pw.printPair("grantedRuntimePermissions", this.grantedRuntimePermissions);
            pw.println();
        }

        private final int $$robo$$android_content_pm_PackageInstaller_SessionParams$describeContents() {
            return 0;
        }

        private final void $$robo$$android_content_pm_PackageInstaller_SessionParams$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mode);
            dest.writeInt(this.installFlags);
            dest.writeInt(this.installLocation);
            dest.writeInt(this.installReason);
            dest.writeLong(this.sizeBytes);
            dest.writeString(this.appPackageName);
            dest.writeParcelable(this.appIcon, flags);
            dest.writeString(this.appLabel);
            dest.writeParcelable(this.originatingUri, flags);
            dest.writeInt(this.originatingUid);
            dest.writeParcelable(this.referrerUri, flags);
            dest.writeString(this.abiOverride);
            dest.writeString(this.volumeUuid);
            dest.writeStringArray(this.grantedRuntimePermissions);
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<SessionParams>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_content_pm_PackageInstaller_SessionParams_1$__constructor__() {
                }

                private final SessionParams $$robo$$android_content_pm_PackageInstaller_SessionParams_1$createFromParcel(Parcel p) {
                    return new SessionParams(p);
                }

                private final SessionParams[] $$robo$$android_content_pm_PackageInstaller_SessionParams_1$newArray(int size) {
                    return new SessionParams[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_content_pm_PackageInstaller_SessionParams_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageInstaller_SessionParams_1$__constructor__(), 0, this);
                }

                @Override
                public SessionParams createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_content_pm_PackageInstaller_SessionParams_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public SessionParams[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_content_pm_PackageInstaller_SessionParams_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(int n) {
            this.$$robo$$android_content_pm_PackageInstaller_SessionParams$__constructor__(n);
        }

        public SessionParams(int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageInstaller_SessionParams$__constructor__(int ), 0, this, n);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_content_pm_PackageInstaller_SessionParams$__constructor__(parcel);
        }

        public SessionParams(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageInstaller_SessionParams$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        public boolean areHiddenOptionsSet() {
            return (boolean)InvokeDynamicSupport.bootstrap("areHiddenOptionsSet", $$robo$$android_content_pm_PackageInstaller_SessionParams$areHiddenOptionsSet(), 0, this);
        }

        public void setInstallLocation(int n) {
            InvokeDynamicSupport.bootstrap("setInstallLocation", $$robo$$android_content_pm_PackageInstaller_SessionParams$setInstallLocation(int ), 0, this, n);
        }

        public void setSize(long l) {
            InvokeDynamicSupport.bootstrap("setSize", $$robo$$android_content_pm_PackageInstaller_SessionParams$setSize(long ), 0, this, l);
        }

        public void setAppPackageName(String string2) {
            InvokeDynamicSupport.bootstrap("setAppPackageName", $$robo$$android_content_pm_PackageInstaller_SessionParams$setAppPackageName(java.lang.String ), 0, this, string2);
        }

        public void setAppIcon(Bitmap bitmap) {
            InvokeDynamicSupport.bootstrap("setAppIcon", $$robo$$android_content_pm_PackageInstaller_SessionParams$setAppIcon(android.graphics.Bitmap ), 0, this, bitmap);
        }

        public void setAppLabel(CharSequence charSequence) {
            InvokeDynamicSupport.bootstrap("setAppLabel", $$robo$$android_content_pm_PackageInstaller_SessionParams$setAppLabel(java.lang.CharSequence ), 0, this, charSequence);
        }

        public void setOriginatingUri(Uri uri) {
            InvokeDynamicSupport.bootstrap("setOriginatingUri", $$robo$$android_content_pm_PackageInstaller_SessionParams$setOriginatingUri(android.net.Uri ), 0, this, uri);
        }

        public void setOriginatingUid(int n) {
            InvokeDynamicSupport.bootstrap("setOriginatingUid", $$robo$$android_content_pm_PackageInstaller_SessionParams$setOriginatingUid(int ), 0, this, n);
        }

        public void setReferrerUri(Uri uri) {
            InvokeDynamicSupport.bootstrap("setReferrerUri", $$robo$$android_content_pm_PackageInstaller_SessionParams$setReferrerUri(android.net.Uri ), 0, this, uri);
        }

        public void setGrantedRuntimePermissions(String[] stringArray) {
            InvokeDynamicSupport.bootstrap("setGrantedRuntimePermissions", $$robo$$android_content_pm_PackageInstaller_SessionParams$setGrantedRuntimePermissions(java.lang.String[] ), 0, this, stringArray);
        }

        public void setInstallFlagsInternal() {
            InvokeDynamicSupport.bootstrap("setInstallFlagsInternal", $$robo$$android_content_pm_PackageInstaller_SessionParams$setInstallFlagsInternal(), 0, this);
        }

        public void setAllowDowngrade(boolean bl) {
            InvokeDynamicSupport.bootstrap("setAllowDowngrade", $$robo$$android_content_pm_PackageInstaller_SessionParams$setAllowDowngrade(boolean ), 0, this, bl);
        }

        public void setInstallFlagsExternal() {
            InvokeDynamicSupport.bootstrap("setInstallFlagsExternal", $$robo$$android_content_pm_PackageInstaller_SessionParams$setInstallFlagsExternal(), 0, this);
        }

        public void setInstallFlagsForcePermissionPrompt() {
            InvokeDynamicSupport.bootstrap("setInstallFlagsForcePermissionPrompt", $$robo$$android_content_pm_PackageInstaller_SessionParams$setInstallFlagsForcePermissionPrompt(), 0, this);
        }

        public void setDontKillApp(boolean bl) {
            InvokeDynamicSupport.bootstrap("setDontKillApp", $$robo$$android_content_pm_PackageInstaller_SessionParams$setDontKillApp(boolean ), 0, this, bl);
        }

        public void setInstallAsInstantApp(boolean bl) {
            InvokeDynamicSupport.bootstrap("setInstallAsInstantApp", $$robo$$android_content_pm_PackageInstaller_SessionParams$setInstallAsInstantApp(boolean ), 0, this, bl);
        }

        public void setInstallAsVirtualPreload() {
            InvokeDynamicSupport.bootstrap("setInstallAsVirtualPreload", $$robo$$android_content_pm_PackageInstaller_SessionParams$setInstallAsVirtualPreload(), 0, this);
        }

        public void setInstallReason(int n) {
            InvokeDynamicSupport.bootstrap("setInstallReason", $$robo$$android_content_pm_PackageInstaller_SessionParams$setInstallReason(int ), 0, this, n);
        }

        public void setAllocateAggressive(boolean bl) {
            InvokeDynamicSupport.bootstrap("setAllocateAggressive", $$robo$$android_content_pm_PackageInstaller_SessionParams$setAllocateAggressive(boolean ), 0, this, bl);
        }

        public void dump(IndentingPrintWriter indentingPrintWriter) {
            InvokeDynamicSupport.bootstrap("dump", $$robo$$android_content_pm_PackageInstaller_SessionParams$dump(com.android.internal.util.IndentingPrintWriter ), 0, this, indentingPrintWriter);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_content_pm_PackageInstaller_SessionParams$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_content_pm_PackageInstaller_SessionParams$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        static {
            RobolectricInternals.classInitializing(SessionParams.class);
        }

        public /* synthetic */ SessionParams() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SessionParams)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Session
    implements Closeable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private IPackageInstallerSession mSession;

        private void $$robo$$android_content_pm_PackageInstaller_Session$__constructor__(IPackageInstallerSession session) {
            this.mSession = session;
        }

        @Deprecated
        private final void $$robo$$android_content_pm_PackageInstaller_Session$setProgress(float progress) {
            this.setStagingProgress(progress);
        }

        private final void $$robo$$android_content_pm_PackageInstaller_Session$setStagingProgress(float progress) {
            try {
                this.mSession.setClientProgress(progress);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        private final void $$robo$$android_content_pm_PackageInstaller_Session$addProgress(float progress) {
            try {
                this.mSession.addClientProgress(progress);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        private final OutputStream $$robo$$android_content_pm_PackageInstaller_Session$openWrite(String name, long offsetBytes, long lengthBytes) throws IOException {
            try {
                if (ENABLE_REVOCABLE_FD) {
                    return new ParcelFileDescriptor.AutoCloseOutputStream(this.mSession.openWrite(name, offsetBytes, lengthBytes));
                }
                ParcelFileDescriptor clientSocket = this.mSession.openWrite(name, offsetBytes, lengthBytes);
                return new FileBridge.FileBridgeOutputStream(clientSocket);
            }
            catch (RuntimeException e) {
                ExceptionUtils.maybeUnwrapIOException(e);
                throw e;
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final void $$robo$$android_content_pm_PackageInstaller_Session$fsync(OutputStream out) throws IOException {
            if (ENABLE_REVOCABLE_FD) {
                if (!(out instanceof ParcelFileDescriptor.AutoCloseOutputStream)) throw new IllegalArgumentException("Unrecognized stream");
                try {
                    Os.fsync(((ParcelFileDescriptor.AutoCloseOutputStream)out).getFD());
                    return;
                }
                catch (ErrnoException e) {
                    throw e.rethrowAsIOException();
                }
            } else {
                if (!(out instanceof FileBridge.FileBridgeOutputStream)) throw new IllegalArgumentException("Unrecognized stream");
                ((FileBridge.FileBridgeOutputStream)out).fsync();
            }
        }

        private final String[] $$robo$$android_content_pm_PackageInstaller_Session$getNames() throws IOException {
            try {
                return this.mSession.getNames();
            }
            catch (RuntimeException e) {
                ExceptionUtils.maybeUnwrapIOException(e);
                throw e;
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        private final InputStream $$robo$$android_content_pm_PackageInstaller_Session$openRead(String name) throws IOException {
            try {
                ParcelFileDescriptor pfd = this.mSession.openRead(name);
                return new ParcelFileDescriptor.AutoCloseInputStream(pfd);
            }
            catch (RuntimeException e) {
                ExceptionUtils.maybeUnwrapIOException(e);
                throw e;
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        private final void $$robo$$android_content_pm_PackageInstaller_Session$removeSplit(String splitName) throws IOException {
            try {
                this.mSession.removeSplit(splitName);
            }
            catch (RuntimeException e) {
                ExceptionUtils.maybeUnwrapIOException(e);
                throw e;
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        private final void $$robo$$android_content_pm_PackageInstaller_Session$commit(IntentSender statusReceiver) {
            try {
                this.mSession.commit(statusReceiver, false);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        private final void $$robo$$android_content_pm_PackageInstaller_Session$commitTransferred(IntentSender statusReceiver) {
            try {
                this.mSession.commit(statusReceiver, true);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        private final void $$robo$$android_content_pm_PackageInstaller_Session$transfer(String packageName) throws PackageManager.NameNotFoundException {
            Preconditions.checkNotNull(packageName);
            try {
                this.mSession.transfer(packageName);
            }
            catch (ParcelableException e) {
                e.maybeRethrow(PackageManager.NameNotFoundException.class);
                throw new RuntimeException(e);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        private final void $$robo$$android_content_pm_PackageInstaller_Session$close() {
            try {
                this.mSession.close();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        private final void $$robo$$android_content_pm_PackageInstaller_Session$abandon() {
            try {
                this.mSession.abandon();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        private void __constructor__(IPackageInstallerSession iPackageInstallerSession) {
            this.$$robo$$android_content_pm_PackageInstaller_Session$__constructor__(iPackageInstallerSession);
        }

        public Session(IPackageInstallerSession iPackageInstallerSession) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageInstaller_Session$__constructor__(android.content.pm.IPackageInstallerSession ), 0, this, iPackageInstallerSession);
        }

        @Deprecated
        public void setProgress(float f) {
            InvokeDynamicSupport.bootstrap("setProgress", $$robo$$android_content_pm_PackageInstaller_Session$setProgress(float ), 0, this, f);
        }

        public void setStagingProgress(float f) {
            InvokeDynamicSupport.bootstrap("setStagingProgress", $$robo$$android_content_pm_PackageInstaller_Session$setStagingProgress(float ), 0, this, f);
        }

        public void addProgress(float f) {
            InvokeDynamicSupport.bootstrap("addProgress", $$robo$$android_content_pm_PackageInstaller_Session$addProgress(float ), 0, this, f);
        }

        public OutputStream openWrite(String string2, long l, long l2) throws IOException {
            return InvokeDynamicSupport.bootstrap("openWrite", $$robo$$android_content_pm_PackageInstaller_Session$openWrite(java.lang.String long long ), 0, this, string2, l, l2);
        }

        public void fsync(OutputStream outputStream) throws IOException {
            InvokeDynamicSupport.bootstrap("fsync", $$robo$$android_content_pm_PackageInstaller_Session$fsync(java.io.OutputStream ), 0, this, outputStream);
        }

        public String[] getNames() throws IOException {
            return InvokeDynamicSupport.bootstrap("getNames", $$robo$$android_content_pm_PackageInstaller_Session$getNames(), 0, this);
        }

        public InputStream openRead(String string2) throws IOException {
            return InvokeDynamicSupport.bootstrap("openRead", $$robo$$android_content_pm_PackageInstaller_Session$openRead(java.lang.String ), 0, this, string2);
        }

        public void removeSplit(String string2) throws IOException {
            InvokeDynamicSupport.bootstrap("removeSplit", $$robo$$android_content_pm_PackageInstaller_Session$removeSplit(java.lang.String ), 0, this, string2);
        }

        public void commit(IntentSender intentSender) {
            InvokeDynamicSupport.bootstrap("commit", $$robo$$android_content_pm_PackageInstaller_Session$commit(android.content.IntentSender ), 0, this, intentSender);
        }

        public void commitTransferred(IntentSender intentSender) {
            InvokeDynamicSupport.bootstrap("commitTransferred", $$robo$$android_content_pm_PackageInstaller_Session$commitTransferred(android.content.IntentSender ), 0, this, intentSender);
        }

        public void transfer(String string2) throws PackageManager.NameNotFoundException {
            InvokeDynamicSupport.bootstrap("transfer", $$robo$$android_content_pm_PackageInstaller_Session$transfer(java.lang.String ), 0, this, string2);
        }

        @Override
        public void close() {
            InvokeDynamicSupport.bootstrap("close", $$robo$$android_content_pm_PackageInstaller_Session$close(), 0, this);
        }

        public void abandon() {
            InvokeDynamicSupport.bootstrap("abandon", $$robo$$android_content_pm_PackageInstaller_Session$abandon(), 0, this);
        }

        public /* synthetic */ Session() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Session)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class SessionCallbackDelegate
    extends IPackageInstallerCallback.Stub
    implements Handler.Callback,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int MSG_SESSION_CREATED = 1;
        private static int MSG_SESSION_BADGING_CHANGED = 2;
        private static int MSG_SESSION_ACTIVE_CHANGED = 3;
        private static int MSG_SESSION_PROGRESS_CHANGED = 4;
        private static int MSG_SESSION_FINISHED = 5;
        SessionCallback mCallback;
        Handler mHandler;

        private void $$robo$$android_content_pm_PackageInstaller_SessionCallbackDelegate$__constructor__(SessionCallback callback, Looper looper) {
            this.mCallback = callback;
            this.mHandler = new Handler(looper, this);
        }

        private final boolean $$robo$$android_content_pm_PackageInstaller_SessionCallbackDelegate$handleMessage(Message msg) {
            int sessionId = msg.arg1;
            switch (msg.what) {
                case 1: {
                    this.mCallback.onCreated(sessionId);
                    return true;
                }
                case 2: {
                    this.mCallback.onBadgingChanged(sessionId);
                    return true;
                }
                case 3: {
                    boolean active = msg.arg2 != 0;
                    this.mCallback.onActiveChanged(sessionId, active);
                    return true;
                }
                case 4: {
                    this.mCallback.onProgressChanged(sessionId, ((Float)msg.obj).floatValue());
                    return true;
                }
                case 5: {
                    this.mCallback.onFinished(sessionId, msg.arg2 != 0);
                    return true;
                }
            }
            return false;
        }

        private final void $$robo$$android_content_pm_PackageInstaller_SessionCallbackDelegate$onSessionCreated(int sessionId) {
            this.mHandler.obtainMessage(1, sessionId, 0).sendToTarget();
        }

        private final void $$robo$$android_content_pm_PackageInstaller_SessionCallbackDelegate$onSessionBadgingChanged(int sessionId) {
            this.mHandler.obtainMessage(2, sessionId, 0).sendToTarget();
        }

        private final void $$robo$$android_content_pm_PackageInstaller_SessionCallbackDelegate$onSessionActiveChanged(int sessionId, boolean active) {
            this.mHandler.obtainMessage(3, sessionId, active ? 1 : 0).sendToTarget();
        }

        private final void $$robo$$android_content_pm_PackageInstaller_SessionCallbackDelegate$onSessionProgressChanged(int sessionId, float progress) {
            this.mHandler.obtainMessage(4, sessionId, 0, Float.valueOf(progress)).sendToTarget();
        }

        private final void $$robo$$android_content_pm_PackageInstaller_SessionCallbackDelegate$onSessionFinished(int sessionId, boolean success) {
            this.mHandler.obtainMessage(5, sessionId, success ? 1 : 0).sendToTarget();
        }

        private void __constructor__(SessionCallback sessionCallback, Looper looper) {
            this.$$robo$$android_content_pm_PackageInstaller_SessionCallbackDelegate$__constructor__(sessionCallback, looper);
        }

        public SessionCallbackDelegate(SessionCallback sessionCallback, Looper looper) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageInstaller_SessionCallbackDelegate$__constructor__(android.content.pm.PackageInstaller$SessionCallback android.os.Looper ), 0, this, sessionCallback, looper);
        }

        @Override
        public boolean handleMessage(Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_content_pm_PackageInstaller_SessionCallbackDelegate$handleMessage(android.os.Message ), 0, this, message);
        }

        @Override
        public void onSessionCreated(int n) {
            InvokeDynamicSupport.bootstrap("onSessionCreated", $$robo$$android_content_pm_PackageInstaller_SessionCallbackDelegate$onSessionCreated(int ), 0, this, n);
        }

        @Override
        public void onSessionBadgingChanged(int n) {
            InvokeDynamicSupport.bootstrap("onSessionBadgingChanged", $$robo$$android_content_pm_PackageInstaller_SessionCallbackDelegate$onSessionBadgingChanged(int ), 0, this, n);
        }

        @Override
        public void onSessionActiveChanged(int n, boolean bl) {
            InvokeDynamicSupport.bootstrap("onSessionActiveChanged", $$robo$$android_content_pm_PackageInstaller_SessionCallbackDelegate$onSessionActiveChanged(int boolean ), 0, this, n, bl);
        }

        @Override
        public void onSessionProgressChanged(int n, float f) {
            InvokeDynamicSupport.bootstrap("onSessionProgressChanged", $$robo$$android_content_pm_PackageInstaller_SessionCallbackDelegate$onSessionProgressChanged(int float ), 0, this, n, f);
        }

        @Override
        public void onSessionFinished(int n, boolean bl) {
            InvokeDynamicSupport.bootstrap("onSessionFinished", $$robo$$android_content_pm_PackageInstaller_SessionCallbackDelegate$onSessionFinished(int boolean ), 0, this, n, bl);
        }

        public /* synthetic */ SessionCallbackDelegate() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SessionCallbackDelegate)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class SessionCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_content_pm_PackageInstaller_SessionCallback$__constructor__() {
        }

        public abstract void onCreated(int var1);

        public abstract void onBadgingChanged(int var1);

        public abstract void onActiveChanged(int var1, boolean var2);

        public abstract void onProgressChanged(int var1, float var2);

        public abstract void onFinished(int var1, boolean var2);

        private void __constructor__() {
            this.$$robo$$android_content_pm_PackageInstaller_SessionCallback$__constructor__();
        }

        public SessionCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_PackageInstaller_SessionCallback$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SessionCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

