/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.drawable.Icon;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.ArraySet;
import android.util.Log;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Set;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class ShortcutInfo
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String TAG = "Shortcut";
    private static String RES_TYPE_STRING = "string";
    private static String ANDROID_PACKAGE_NAME = "android";
    private static int IMPLICIT_RANK_MASK = Integer.MAX_VALUE;
    private static int RANK_CHANGED_BIT = Integer.MIN_VALUE;
    public static int RANK_NOT_SET = Integer.MAX_VALUE;
    public static int FLAG_DYNAMIC = 1;
    public static int FLAG_PINNED = 2;
    public static int FLAG_HAS_ICON_RES = 4;
    public static int FLAG_HAS_ICON_FILE = 8;
    public static int FLAG_KEY_FIELDS_ONLY = 16;
    public static int FLAG_MANIFEST = 32;
    public static int FLAG_DISABLED = 64;
    public static int FLAG_STRINGS_RESOLVED = 128;
    public static int FLAG_IMMUTABLE = 256;
    public static int FLAG_ADAPTIVE_BITMAP = 512;
    public static int FLAG_RETURNED_BY_SERVICE = 1024;
    public static int FLAG_ICON_FILE_PENDING_SAVE = 2048;
    private static int CLONE_REMOVE_ICON = 1;
    private static int CLONE_REMOVE_INTENT = 2;
    public static int CLONE_REMOVE_NON_KEY_INFO = 4;
    public static int CLONE_REMOVE_RES_NAMES = 8;
    public static int CLONE_REMOVE_FOR_CREATOR = 9;
    public static int CLONE_REMOVE_FOR_LAUNCHER = 11;
    public static int CLONE_REMOVE_FOR_LAUNCHER_APPROVAL = 10;
    public static String SHORTCUT_CATEGORY_CONVERSATION = "android.shortcut.conversation";
    private String mId;
    private String mPackageName;
    private ComponentName mActivity;
    private Icon mIcon;
    private int mTitleResId;
    private String mTitleResName;
    private CharSequence mTitle;
    private int mTextResId;
    private String mTextResName;
    private CharSequence mText;
    private int mDisabledMessageResId;
    private String mDisabledMessageResName;
    private CharSequence mDisabledMessage;
    private ArraySet<String> mCategories;
    private Intent[] mIntents;
    private PersistableBundle[] mIntentPersistableExtrases;
    private int mRank;
    private int mImplicitRank;
    private PersistableBundle mExtras;
    private long mLastChangedTimestamp;
    private int mFlags;
    private int mIconResId;
    private String mIconResName;
    private String mBitmapPath;
    private int mUserId;
    public static Parcelable.Creator<ShortcutInfo> CREATOR;

    private void $$robo$$android_content_pm_ShortcutInfo$__constructor__(Builder b) {
        this.mUserId = b.mContext.getUserId();
        this.mId = Preconditions.checkStringNotEmpty(b.mId, "Shortcut ID must be provided");
        this.mPackageName = b.mContext.getPackageName();
        this.mActivity = b.mActivity;
        this.mIcon = b.mIcon;
        this.mTitle = b.mTitle;
        this.mTitleResId = b.mTitleResId;
        this.mText = b.mText;
        this.mTextResId = b.mTextResId;
        this.mDisabledMessage = b.mDisabledMessage;
        this.mDisabledMessageResId = b.mDisabledMessageResId;
        this.mCategories = ShortcutInfo.cloneCategories(b.mCategories);
        this.mIntents = ShortcutInfo.cloneIntents(b.mIntents);
        this.fixUpIntentExtras();
        this.mRank = b.mRank;
        this.mExtras = b.mExtras;
        this.updateTimestamp();
    }

    private final void $$robo$$android_content_pm_ShortcutInfo$fixUpIntentExtras() {
        if (this.mIntents == null) {
            this.mIntentPersistableExtrases = null;
            return;
        }
        this.mIntentPersistableExtrases = new PersistableBundle[this.mIntents.length];
        for (int i = 0; i < this.mIntents.length; ++i) {
            Intent intent = this.mIntents[i];
            Bundle extras = intent.getExtras();
            if (extras == null) {
                this.mIntentPersistableExtrases[i] = null;
                continue;
            }
            this.mIntentPersistableExtrases[i] = new PersistableBundle(extras);
            intent.replaceExtras((Bundle)null);
        }
    }

    private static final ArraySet<String> $$robo$$android_content_pm_ShortcutInfo$cloneCategories(Set<String> source) {
        if (source == null) {
            return null;
        }
        ArraySet<String> ret = new ArraySet<String>(source.size());
        for (CharSequence charSequence : source) {
            if (TextUtils.isEmpty(charSequence)) continue;
            ret.add(charSequence.toString().intern());
        }
        return ret;
    }

    private static final Intent[] $$robo$$android_content_pm_ShortcutInfo$cloneIntents(Intent[] intents) {
        if (intents == null) {
            return null;
        }
        Intent[] ret = new Intent[intents.length];
        for (int i = 0; i < ret.length; ++i) {
            if (intents[i] == null) continue;
            ret[i] = new Intent(intents[i]);
        }
        return ret;
    }

    private static final PersistableBundle[] $$robo$$android_content_pm_ShortcutInfo$clonePersistableBundle(PersistableBundle[] bundle) {
        if (bundle == null) {
            return null;
        }
        PersistableBundle[] ret = new PersistableBundle[bundle.length];
        for (int i = 0; i < ret.length; ++i) {
            if (bundle[i] == null) continue;
            ret[i] = new PersistableBundle(bundle[i]);
        }
        return ret;
    }

    private final void $$robo$$android_content_pm_ShortcutInfo$enforceMandatoryFields(boolean forPinned) {
        Preconditions.checkStringNotEmpty(this.mId, "Shortcut ID must be provided");
        if (!forPinned) {
            Preconditions.checkNotNull(this.mActivity, "Activity must be provided");
        }
        if (this.mTitle == null && this.mTitleResId == 0) {
            throw new IllegalArgumentException("Short label must be provided");
        }
        Preconditions.checkNotNull(this.mIntents, "Shortcut Intent must be provided");
        Preconditions.checkArgument(this.mIntents.length > 0, "Shortcut Intent must be provided");
    }

    private void $$robo$$android_content_pm_ShortcutInfo$__constructor__(ShortcutInfo source, int cloneFlags) {
        this.mUserId = source.mUserId;
        this.mId = source.mId;
        this.mPackageName = source.mPackageName;
        this.mActivity = source.mActivity;
        this.mFlags = source.mFlags;
        this.mLastChangedTimestamp = source.mLastChangedTimestamp;
        this.mIconResId = source.mIconResId;
        if ((cloneFlags & 4) == 0) {
            if ((cloneFlags & 1) == 0) {
                this.mIcon = source.mIcon;
                this.mBitmapPath = source.mBitmapPath;
            }
            this.mTitle = source.mTitle;
            this.mTitleResId = source.mTitleResId;
            this.mText = source.mText;
            this.mTextResId = source.mTextResId;
            this.mDisabledMessage = source.mDisabledMessage;
            this.mDisabledMessageResId = source.mDisabledMessageResId;
            this.mCategories = ShortcutInfo.cloneCategories(source.mCategories);
            if ((cloneFlags & 2) == 0) {
                this.mIntents = ShortcutInfo.cloneIntents(source.mIntents);
                this.mIntentPersistableExtrases = ShortcutInfo.clonePersistableBundle(source.mIntentPersistableExtrases);
            }
            this.mRank = source.mRank;
            this.mExtras = source.mExtras;
            if ((cloneFlags & 8) == 0) {
                this.mTitleResName = source.mTitleResName;
                this.mTextResName = source.mTextResName;
                this.mDisabledMessageResName = source.mDisabledMessageResName;
                this.mIconResName = source.mIconResName;
            }
        } else {
            this.mFlags |= 0x10;
        }
    }

    private final CharSequence $$robo$$android_content_pm_ShortcutInfo$getResourceString(Resources res, int resId, CharSequence defValue) {
        try {
            return res.getString(resId);
        }
        catch (Resources.NotFoundException e) {
            Log.e("Shortcut", "Resource for ID=" + resId + " not found in package " + this.mPackageName);
            return defValue;
        }
    }

    private final void $$robo$$android_content_pm_ShortcutInfo$resolveResourceStrings(Resources res) {
        this.mFlags |= 0x80;
        if (this.mTitleResId == 0 && this.mTextResId == 0 && this.mDisabledMessageResId == 0) {
            return;
        }
        if (this.mTitleResId != 0) {
            this.mTitle = this.getResourceString(res, this.mTitleResId, this.mTitle);
        }
        if (this.mTextResId != 0) {
            this.mText = this.getResourceString(res, this.mTextResId, this.mText);
        }
        if (this.mDisabledMessageResId != 0) {
            this.mDisabledMessage = this.getResourceString(res, this.mDisabledMessageResId, this.mDisabledMessage);
        }
    }

    private static final String $$robo$$android_content_pm_ShortcutInfo$lookUpResourceName(Resources res, int resId, boolean withType, String packageName) {
        if (resId == 0) {
            return null;
        }
        try {
            String fullName = res.getResourceName(resId);
            if ("android".equals(ShortcutInfo.getResourcePackageName(fullName))) {
                return String.valueOf(resId);
            }
            return withType ? ShortcutInfo.getResourceTypeAndEntryName(fullName) : ShortcutInfo.getResourceEntryName(fullName);
        }
        catch (Resources.NotFoundException e) {
            Log.e("Shortcut", "Resource name for ID=" + resId + " not found in package " + packageName + ". Resource IDs may change when the application is upgraded, and the system" + " may not be able to find the correct resource.");
            return null;
        }
    }

    private static final String $$robo$$android_content_pm_ShortcutInfo$getResourcePackageName(String fullResourceName) {
        int p1 = fullResourceName.indexOf(58);
        if (p1 < 0) {
            return null;
        }
        return fullResourceName.substring(0, p1);
    }

    private static final String $$robo$$android_content_pm_ShortcutInfo$getResourceTypeName(String fullResourceName) {
        int p1 = fullResourceName.indexOf(58);
        if (p1 < 0) {
            return null;
        }
        int p2 = fullResourceName.indexOf(47, p1 + 1);
        if (p2 < 0) {
            return null;
        }
        return fullResourceName.substring(p1 + 1, p2);
    }

    private static final String $$robo$$android_content_pm_ShortcutInfo$getResourceTypeAndEntryName(String fullResourceName) {
        int p1 = fullResourceName.indexOf(58);
        if (p1 < 0) {
            return null;
        }
        return fullResourceName.substring(p1 + 1);
    }

    private static final String $$robo$$android_content_pm_ShortcutInfo$getResourceEntryName(String fullResourceName) {
        int p1 = fullResourceName.indexOf(47);
        if (p1 < 0) {
            return null;
        }
        return fullResourceName.substring(p1 + 1);
    }

    private static final int $$robo$$android_content_pm_ShortcutInfo$lookUpResourceId(Resources res, String resourceName, String resourceType, String packageName) {
        if (resourceName == null) {
            return 0;
        }
        try {
            try {
                return Integer.parseInt(resourceName);
            }
            catch (NumberFormatException numberFormatException) {
                return res.getIdentifier(resourceName, resourceType, packageName);
            }
        }
        catch (Resources.NotFoundException e) {
            Log.e("Shortcut", "Resource ID for name=" + resourceName + " not found in package " + packageName);
            return 0;
        }
    }

    private final void $$robo$$android_content_pm_ShortcutInfo$lookupAndFillInResourceNames(Resources res) {
        if (this.mTitleResId == 0 && this.mTextResId == 0 && this.mDisabledMessageResId == 0 && this.mIconResId == 0) {
            return;
        }
        this.mTitleResName = ShortcutInfo.lookUpResourceName(res, this.mTitleResId, false, this.mPackageName);
        this.mTextResName = ShortcutInfo.lookUpResourceName(res, this.mTextResId, false, this.mPackageName);
        this.mDisabledMessageResName = ShortcutInfo.lookUpResourceName(res, this.mDisabledMessageResId, false, this.mPackageName);
        this.mIconResName = ShortcutInfo.lookUpResourceName(res, this.mIconResId, true, this.mPackageName);
    }

    private final void $$robo$$android_content_pm_ShortcutInfo$lookupAndFillInResourceIds(Resources res) {
        if (this.mTitleResName == null && this.mTextResName == null && this.mDisabledMessageResName == null && this.mIconResName == null) {
            return;
        }
        this.mTitleResId = ShortcutInfo.lookUpResourceId(res, this.mTitleResName, "string", this.mPackageName);
        this.mTextResId = ShortcutInfo.lookUpResourceId(res, this.mTextResName, "string", this.mPackageName);
        this.mDisabledMessageResId = ShortcutInfo.lookUpResourceId(res, this.mDisabledMessageResName, "string", this.mPackageName);
        this.mIconResId = ShortcutInfo.lookUpResourceId(res, this.mIconResName, null, this.mPackageName);
    }

    private final ShortcutInfo $$robo$$android_content_pm_ShortcutInfo$clone(int cloneFlags) {
        return new ShortcutInfo(this, cloneFlags);
    }

    private final void $$robo$$android_content_pm_ShortcutInfo$ensureUpdatableWith(ShortcutInfo source) {
        Preconditions.checkState(this.mUserId == source.mUserId, "Owner User ID must match");
        Preconditions.checkState(this.mId.equals(source.mId), "ID must match");
        Preconditions.checkState(this.mPackageName.equals(source.mPackageName), "Package name must match");
        Preconditions.checkState(!this.isImmutable(), "Target ShortcutInfo is immutable");
    }

    private final void $$robo$$android_content_pm_ShortcutInfo$copyNonNullFieldsFrom(ShortcutInfo source) {
        this.ensureUpdatableWith(source);
        if (source.mActivity != null) {
            this.mActivity = source.mActivity;
        }
        if (source.mIcon != null) {
            this.mIcon = source.mIcon;
            this.mIconResId = 0;
            this.mIconResName = null;
            this.mBitmapPath = null;
        }
        if (source.mTitle != null) {
            this.mTitle = source.mTitle;
            this.mTitleResId = 0;
            this.mTitleResName = null;
        } else if (source.mTitleResId != 0) {
            this.mTitle = null;
            this.mTitleResId = source.mTitleResId;
            this.mTitleResName = null;
        }
        if (source.mText != null) {
            this.mText = source.mText;
            this.mTextResId = 0;
            this.mTextResName = null;
        } else if (source.mTextResId != 0) {
            this.mText = null;
            this.mTextResId = source.mTextResId;
            this.mTextResName = null;
        }
        if (source.mDisabledMessage != null) {
            this.mDisabledMessage = source.mDisabledMessage;
            this.mDisabledMessageResId = 0;
            this.mDisabledMessageResName = null;
        } else if (source.mDisabledMessageResId != 0) {
            this.mDisabledMessage = null;
            this.mDisabledMessageResId = source.mDisabledMessageResId;
            this.mDisabledMessageResName = null;
        }
        if (source.mCategories != null) {
            this.mCategories = ShortcutInfo.cloneCategories(source.mCategories);
        }
        if (source.mIntents != null) {
            this.mIntents = ShortcutInfo.cloneIntents(source.mIntents);
            this.mIntentPersistableExtrases = ShortcutInfo.clonePersistableBundle(source.mIntentPersistableExtrases);
        }
        if (source.mRank != Integer.MAX_VALUE) {
            this.mRank = source.mRank;
        }
        if (source.mExtras != null) {
            this.mExtras = source.mExtras;
        }
    }

    private static final Icon $$robo$$android_content_pm_ShortcutInfo$validateIcon(Icon icon) {
        switch (icon.getType()) {
            case 1: 
            case 2: 
            case 5: {
                break;
            }
            default: {
                throw ShortcutInfo.getInvalidIconException();
            }
        }
        if (icon.hasTint()) {
            throw new IllegalArgumentException("Icons with tints are not supported");
        }
        return icon;
    }

    private static final IllegalArgumentException $$robo$$android_content_pm_ShortcutInfo$getInvalidIconException() {
        return new IllegalArgumentException("Unsupported icon type: only the bitmap and resource types are supported");
    }

    private final String $$robo$$android_content_pm_ShortcutInfo$getId() {
        return this.mId;
    }

    private final String $$robo$$android_content_pm_ShortcutInfo$getPackage() {
        return this.mPackageName;
    }

    private final ComponentName $$robo$$android_content_pm_ShortcutInfo$getActivity() {
        return this.mActivity;
    }

    private final void $$robo$$android_content_pm_ShortcutInfo$setActivity(ComponentName activity) {
        this.mActivity = activity;
    }

    private final Icon $$robo$$android_content_pm_ShortcutInfo$getIcon() {
        return this.mIcon;
    }

    @Deprecated
    private final CharSequence $$robo$$android_content_pm_ShortcutInfo$getTitle() {
        return this.mTitle;
    }

    @Deprecated
    private final int $$robo$$android_content_pm_ShortcutInfo$getTitleResId() {
        return this.mTitleResId;
    }

    @Deprecated
    private final CharSequence $$robo$$android_content_pm_ShortcutInfo$getText() {
        return this.mText;
    }

    @Deprecated
    private final int $$robo$$android_content_pm_ShortcutInfo$getTextResId() {
        return this.mTextResId;
    }

    private final CharSequence $$robo$$android_content_pm_ShortcutInfo$getShortLabel() {
        return this.mTitle;
    }

    private final int $$robo$$android_content_pm_ShortcutInfo$getShortLabelResourceId() {
        return this.mTitleResId;
    }

    private final CharSequence $$robo$$android_content_pm_ShortcutInfo$getLongLabel() {
        return this.mText;
    }

    private final int $$robo$$android_content_pm_ShortcutInfo$getLongLabelResourceId() {
        return this.mTextResId;
    }

    private final CharSequence $$robo$$android_content_pm_ShortcutInfo$getDisabledMessage() {
        return this.mDisabledMessage;
    }

    private final int $$robo$$android_content_pm_ShortcutInfo$getDisabledMessageResourceId() {
        return this.mDisabledMessageResId;
    }

    private final Set<String> $$robo$$android_content_pm_ShortcutInfo$getCategories() {
        return this.mCategories;
    }

    private final Intent $$robo$$android_content_pm_ShortcutInfo$getIntent() {
        if (this.mIntents == null || this.mIntents.length == 0) {
            return null;
        }
        int last = this.mIntents.length - 1;
        Intent intent = new Intent(this.mIntents[last]);
        return ShortcutInfo.setIntentExtras(intent, this.mIntentPersistableExtrases[last]);
    }

    private final Intent[] $$robo$$android_content_pm_ShortcutInfo$getIntents() {
        Intent[] ret = new Intent[this.mIntents.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new Intent(this.mIntents[i]);
            ShortcutInfo.setIntentExtras(ret[i], this.mIntentPersistableExtrases[i]);
        }
        return ret;
    }

    private final Intent[] $$robo$$android_content_pm_ShortcutInfo$getIntentsNoExtras() {
        return this.mIntents;
    }

    private final PersistableBundle[] $$robo$$android_content_pm_ShortcutInfo$getIntentPersistableExtrases() {
        return this.mIntentPersistableExtrases;
    }

    private final int $$robo$$android_content_pm_ShortcutInfo$getRank() {
        return this.mRank;
    }

    private final boolean $$robo$$android_content_pm_ShortcutInfo$hasRank() {
        return this.mRank != Integer.MAX_VALUE;
    }

    private final void $$robo$$android_content_pm_ShortcutInfo$setRank(int rank) {
        this.mRank = rank;
    }

    private final void $$robo$$android_content_pm_ShortcutInfo$clearImplicitRankAndRankChangedFlag() {
        this.mImplicitRank = 0;
    }

    private final void $$robo$$android_content_pm_ShortcutInfo$setImplicitRank(int rank) {
        this.mImplicitRank = this.mImplicitRank & Integer.MIN_VALUE | rank & Integer.MAX_VALUE;
    }

    private final int $$robo$$android_content_pm_ShortcutInfo$getImplicitRank() {
        return this.mImplicitRank & Integer.MAX_VALUE;
    }

    private final void $$robo$$android_content_pm_ShortcutInfo$setRankChanged() {
        this.mImplicitRank |= Integer.MIN_VALUE;
    }

    private final boolean $$robo$$android_content_pm_ShortcutInfo$isRankChanged() {
        return (this.mImplicitRank & Integer.MIN_VALUE) != 0;
    }

    private final PersistableBundle $$robo$$android_content_pm_ShortcutInfo$getExtras() {
        return this.mExtras;
    }

    private final int $$robo$$android_content_pm_ShortcutInfo$getUserId() {
        return this.mUserId;
    }

    private final UserHandle $$robo$$android_content_pm_ShortcutInfo$getUserHandle() {
        return UserHandle.of(this.mUserId);
    }

    private final long $$robo$$android_content_pm_ShortcutInfo$getLastChangedTimestamp() {
        return this.mLastChangedTimestamp;
    }

    private final int $$robo$$android_content_pm_ShortcutInfo$getFlags() {
        return this.mFlags;
    }

    private final void $$robo$$android_content_pm_ShortcutInfo$replaceFlags(int flags) {
        this.mFlags = flags;
    }

    private final void $$robo$$android_content_pm_ShortcutInfo$addFlags(int flags) {
        this.mFlags |= flags;
    }

    private final void $$robo$$android_content_pm_ShortcutInfo$clearFlags(int flags) {
        this.mFlags &= ~flags;
    }

    private final boolean $$robo$$android_content_pm_ShortcutInfo$hasFlags(int flags) {
        return (this.mFlags & flags) == flags;
    }

    private final boolean $$robo$$android_content_pm_ShortcutInfo$isReturnedByServer() {
        return this.hasFlags(1024);
    }

    private final void $$robo$$android_content_pm_ShortcutInfo$setReturnedByServer() {
        this.addFlags(1024);
    }

    private final boolean $$robo$$android_content_pm_ShortcutInfo$isDynamic() {
        return this.hasFlags(1);
    }

    private final boolean $$robo$$android_content_pm_ShortcutInfo$isPinned() {
        return this.hasFlags(2);
    }

    private final boolean $$robo$$android_content_pm_ShortcutInfo$isDeclaredInManifest() {
        return this.hasFlags(32);
    }

    @Deprecated
    private final boolean $$robo$$android_content_pm_ShortcutInfo$isManifestShortcut() {
        return this.isDeclaredInManifest();
    }

    private final boolean $$robo$$android_content_pm_ShortcutInfo$isFloating() {
        return this.isPinned() && !this.isDynamic() && !this.isManifestShortcut();
    }

    private final boolean $$robo$$android_content_pm_ShortcutInfo$isOriginallyFromManifest() {
        return this.hasFlags(256);
    }

    private final boolean $$robo$$android_content_pm_ShortcutInfo$isImmutable() {
        return this.hasFlags(256);
    }

    private final boolean $$robo$$android_content_pm_ShortcutInfo$isEnabled() {
        return !this.hasFlags(64);
    }

    private final boolean $$robo$$android_content_pm_ShortcutInfo$isAlive() {
        return this.hasFlags(2) || this.hasFlags(1) || this.hasFlags(32);
    }

    private final boolean $$robo$$android_content_pm_ShortcutInfo$usesQuota() {
        return this.hasFlags(1) || this.hasFlags(32);
    }

    private final boolean $$robo$$android_content_pm_ShortcutInfo$hasIconResource() {
        return this.hasFlags(4);
    }

    private final boolean $$robo$$android_content_pm_ShortcutInfo$hasStringResources() {
        return this.mTitleResId != 0 || this.mTextResId != 0 || this.mDisabledMessageResId != 0;
    }

    private final boolean $$robo$$android_content_pm_ShortcutInfo$hasAnyResources() {
        return this.hasIconResource() || this.hasStringResources();
    }

    private final boolean $$robo$$android_content_pm_ShortcutInfo$hasIconFile() {
        return this.hasFlags(8);
    }

    private final boolean $$robo$$android_content_pm_ShortcutInfo$hasAdaptiveBitmap() {
        return this.hasFlags(512);
    }

    private final boolean $$robo$$android_content_pm_ShortcutInfo$isIconPendingSave() {
        return this.hasFlags(2048);
    }

    private final void $$robo$$android_content_pm_ShortcutInfo$setIconPendingSave() {
        this.addFlags(2048);
    }

    private final void $$robo$$android_content_pm_ShortcutInfo$clearIconPendingSave() {
        this.clearFlags(2048);
    }

    private final boolean $$robo$$android_content_pm_ShortcutInfo$hasKeyFieldsOnly() {
        return this.hasFlags(16);
    }

    private final boolean $$robo$$android_content_pm_ShortcutInfo$hasStringResourcesResolved() {
        return this.hasFlags(128);
    }

    private final void $$robo$$android_content_pm_ShortcutInfo$updateTimestamp() {
        this.mLastChangedTimestamp = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
    }

    private final void $$robo$$android_content_pm_ShortcutInfo$setTimestamp(long value) {
        this.mLastChangedTimestamp = value;
    }

    private final void $$robo$$android_content_pm_ShortcutInfo$clearIcon() {
        this.mIcon = null;
    }

    private final void $$robo$$android_content_pm_ShortcutInfo$setIconResourceId(int iconResourceId) {
        if (this.mIconResId != iconResourceId) {
            this.mIconResName = null;
        }
        this.mIconResId = iconResourceId;
    }

    private final int $$robo$$android_content_pm_ShortcutInfo$getIconResourceId() {
        return this.mIconResId;
    }

    private final String $$robo$$android_content_pm_ShortcutInfo$getBitmapPath() {
        return this.mBitmapPath;
    }

    private final void $$robo$$android_content_pm_ShortcutInfo$setBitmapPath(String bitmapPath) {
        this.mBitmapPath = bitmapPath;
    }

    private final void $$robo$$android_content_pm_ShortcutInfo$setDisabledMessageResId(int disabledMessageResId) {
        if (this.mDisabledMessageResId != disabledMessageResId) {
            this.mDisabledMessageResName = null;
        }
        this.mDisabledMessageResId = disabledMessageResId;
        this.mDisabledMessage = null;
    }

    private final void $$robo$$android_content_pm_ShortcutInfo$setDisabledMessage(String disabledMessage) {
        this.mDisabledMessage = disabledMessage;
        this.mDisabledMessageResId = 0;
        this.mDisabledMessageResName = null;
    }

    private final String $$robo$$android_content_pm_ShortcutInfo$getTitleResName() {
        return this.mTitleResName;
    }

    private final void $$robo$$android_content_pm_ShortcutInfo$setTitleResName(String titleResName) {
        this.mTitleResName = titleResName;
    }

    private final String $$robo$$android_content_pm_ShortcutInfo$getTextResName() {
        return this.mTextResName;
    }

    private final void $$robo$$android_content_pm_ShortcutInfo$setTextResName(String textResName) {
        this.mTextResName = textResName;
    }

    private final String $$robo$$android_content_pm_ShortcutInfo$getDisabledMessageResName() {
        return this.mDisabledMessageResName;
    }

    private final void $$robo$$android_content_pm_ShortcutInfo$setDisabledMessageResName(String disabledMessageResName) {
        this.mDisabledMessageResName = disabledMessageResName;
    }

    private final String $$robo$$android_content_pm_ShortcutInfo$getIconResName() {
        return this.mIconResName;
    }

    private final void $$robo$$android_content_pm_ShortcutInfo$setIconResName(String iconResName) {
        this.mIconResName = iconResName;
    }

    private final void $$robo$$android_content_pm_ShortcutInfo$setIntents(Intent[] intents) throws IllegalArgumentException {
        Preconditions.checkNotNull(intents);
        Preconditions.checkArgument(intents.length > 0);
        this.mIntents = ShortcutInfo.cloneIntents(intents);
        this.fixUpIntentExtras();
    }

    private static final Intent $$robo$$android_content_pm_ShortcutInfo$setIntentExtras(Intent intent, PersistableBundle extras) {
        if (extras == null) {
            intent.replaceExtras((Bundle)null);
        } else {
            intent.replaceExtras(new Bundle(extras));
        }
        return intent;
    }

    private final void $$robo$$android_content_pm_ShortcutInfo$setCategories(Set<String> categories) {
        this.mCategories = ShortcutInfo.cloneCategories(categories);
    }

    private void $$robo$$android_content_pm_ShortcutInfo$__constructor__(Parcel source) {
        ClassLoader cl = this.getClass().getClassLoader();
        this.mUserId = source.readInt();
        this.mId = source.readString();
        this.mPackageName = source.readString();
        this.mActivity = (ComponentName)source.readParcelable(cl);
        this.mFlags = source.readInt();
        this.mIconResId = source.readInt();
        this.mLastChangedTimestamp = source.readLong();
        if (source.readInt() == 0) {
            return;
        }
        this.mIcon = (Icon)source.readParcelable(cl);
        this.mTitle = source.readCharSequence();
        this.mTitleResId = source.readInt();
        this.mText = source.readCharSequence();
        this.mTextResId = source.readInt();
        this.mDisabledMessage = source.readCharSequence();
        this.mDisabledMessageResId = source.readInt();
        this.mIntents = (Intent[])source.readParcelableArray(cl, Intent.class);
        this.mIntentPersistableExtrases = (PersistableBundle[])source.readParcelableArray(cl, PersistableBundle.class);
        this.mRank = source.readInt();
        this.mExtras = (PersistableBundle)source.readParcelable(cl);
        this.mBitmapPath = source.readString();
        this.mIconResName = source.readString();
        this.mTitleResName = source.readString();
        this.mTextResName = source.readString();
        this.mDisabledMessageResName = source.readString();
        int N = source.readInt();
        if (N == 0) {
            this.mCategories = null;
        } else {
            this.mCategories = new ArraySet(N);
            for (int i = 0; i < N; ++i) {
                this.mCategories.add(source.readString().intern());
            }
        }
    }

    private final void $$robo$$android_content_pm_ShortcutInfo$writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mUserId);
        dest.writeString(this.mId);
        dest.writeString(this.mPackageName);
        dest.writeParcelable(this.mActivity, flags);
        dest.writeInt(this.mFlags);
        dest.writeInt(this.mIconResId);
        dest.writeLong(this.mLastChangedTimestamp);
        if (this.hasKeyFieldsOnly()) {
            dest.writeInt(0);
            return;
        }
        dest.writeInt(1);
        dest.writeParcelable(this.mIcon, flags);
        dest.writeCharSequence(this.mTitle);
        dest.writeInt(this.mTitleResId);
        dest.writeCharSequence(this.mText);
        dest.writeInt(this.mTextResId);
        dest.writeCharSequence(this.mDisabledMessage);
        dest.writeInt(this.mDisabledMessageResId);
        dest.writeParcelableArray(this.mIntents, flags);
        dest.writeParcelableArray(this.mIntentPersistableExtrases, flags);
        dest.writeInt(this.mRank);
        dest.writeParcelable(this.mExtras, flags);
        dest.writeString(this.mBitmapPath);
        dest.writeString(this.mIconResName);
        dest.writeString(this.mTitleResName);
        dest.writeString(this.mTextResName);
        dest.writeString(this.mDisabledMessageResName);
        if (this.mCategories != null) {
            int N = this.mCategories.size();
            dest.writeInt(N);
            for (int i = 0; i < N; ++i) {
                dest.writeString(this.mCategories.valueAt(i));
            }
        } else {
            dest.writeInt(0);
        }
    }

    private final int $$robo$$android_content_pm_ShortcutInfo$describeContents() {
        return 0;
    }

    private final String $$robo$$android_content_pm_ShortcutInfo$toString() {
        return this.toStringInner(true, false);
    }

    private final String $$robo$$android_content_pm_ShortcutInfo$toInsecureString() {
        return this.toStringInner(false, true);
    }

    private final String $$robo$$android_content_pm_ShortcutInfo$toStringInner(boolean secure, boolean includeInternalData) {
        StringBuilder sb = new StringBuilder();
        sb.append("ShortcutInfo {");
        sb.append("id=");
        sb.append(secure ? "***" : this.mId);
        sb.append(", flags=0x");
        sb.append(Integer.toHexString(this.mFlags));
        sb.append(" [");
        if (!this.isEnabled()) {
            sb.append("X");
        }
        if (this.isImmutable()) {
            sb.append("Im");
        }
        if (this.isManifestShortcut()) {
            sb.append("M");
        }
        if (this.isDynamic()) {
            sb.append("D");
        }
        if (this.isPinned()) {
            sb.append("P");
        }
        if (this.hasIconFile()) {
            sb.append("If");
        }
        if (this.isIconPendingSave()) {
            sb.append("^");
        }
        if (this.hasIconResource()) {
            sb.append("Ir");
        }
        if (this.hasKeyFieldsOnly()) {
            sb.append("K");
        }
        if (this.hasStringResourcesResolved()) {
            sb.append("Sr");
        }
        if (this.isReturnedByServer()) {
            sb.append("V");
        }
        sb.append("]");
        sb.append(", packageName=");
        sb.append(this.mPackageName);
        sb.append(", activity=");
        sb.append(this.mActivity);
        sb.append(", shortLabel=");
        sb.append(secure ? "***" : this.mTitle);
        sb.append(", resId=");
        sb.append(this.mTitleResId);
        sb.append("[");
        sb.append(this.mTitleResName);
        sb.append("]");
        sb.append(", longLabel=");
        sb.append(secure ? "***" : this.mText);
        sb.append(", resId=");
        sb.append(this.mTextResId);
        sb.append("[");
        sb.append(this.mTextResName);
        sb.append("]");
        sb.append(", disabledMessage=");
        sb.append(secure ? "***" : this.mDisabledMessage);
        sb.append(", resId=");
        sb.append(this.mDisabledMessageResId);
        sb.append("[");
        sb.append(this.mDisabledMessageResName);
        sb.append("]");
        sb.append(", categories=");
        sb.append(this.mCategories);
        sb.append(", icon=");
        sb.append(this.mIcon);
        sb.append(", rank=");
        sb.append(this.mRank);
        sb.append(", timestamp=");
        sb.append(this.mLastChangedTimestamp);
        sb.append(", intents=");
        if (this.mIntents == null) {
            sb.append("null");
        } else if (secure) {
            sb.append("size:");
            sb.append(this.mIntents.length);
        } else {
            int size = this.mIntents.length;
            sb.append("[");
            String sep = "";
            for (int i = 0; i < size; ++i) {
                sb.append(sep);
                sep = ", ";
                sb.append(this.mIntents[i]);
                sb.append("/");
                sb.append(this.mIntentPersistableExtrases[i]);
            }
            sb.append("]");
        }
        sb.append(", extras=");
        sb.append(this.mExtras);
        if (includeInternalData) {
            sb.append(", iconRes=");
            sb.append(this.mIconResId);
            sb.append("[");
            sb.append(this.mIconResName);
            sb.append("]");
            sb.append(", bitmapPath=");
            sb.append(this.mBitmapPath);
        }
        sb.append("}");
        return sb.toString();
    }

    private void $$robo$$android_content_pm_ShortcutInfo$__constructor__(int userId, String id2, String packageName, ComponentName activity, Icon icon, CharSequence title, int titleResId, String titleResName, CharSequence text, int textResId, String textResName, CharSequence disabledMessage, int disabledMessageResId, String disabledMessageResName, Set<String> categories, Intent[] intentsWithExtras, int rank, PersistableBundle extras, long lastChangedTimestamp, int flags, int iconResId, String iconResName, String bitmapPath) {
        this.mUserId = userId;
        this.mId = id2;
        this.mPackageName = packageName;
        this.mActivity = activity;
        this.mIcon = icon;
        this.mTitle = title;
        this.mTitleResId = titleResId;
        this.mTitleResName = titleResName;
        this.mText = text;
        this.mTextResId = textResId;
        this.mTextResName = textResName;
        this.mDisabledMessage = disabledMessage;
        this.mDisabledMessageResId = disabledMessageResId;
        this.mDisabledMessageResName = disabledMessageResName;
        this.mCategories = ShortcutInfo.cloneCategories(categories);
        this.mIntents = ShortcutInfo.cloneIntents(intentsWithExtras);
        this.fixUpIntentExtras();
        this.mRank = rank;
        this.mExtras = extras;
        this.mLastChangedTimestamp = lastChangedTimestamp;
        this.mFlags = flags;
        this.mIconResId = iconResId;
        this.mIconResName = iconResName;
        this.mBitmapPath = bitmapPath;
    }

    private /* synthetic */ void $$robo$$android_content_pm_ShortcutInfo$__constructor__(Builder x0, 1 x1) {
    }

    private /* synthetic */ void $$robo$$android_content_pm_ShortcutInfo$__constructor__(Parcel x0, 1 x1) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<ShortcutInfo>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_content_pm_ShortcutInfo_1$__constructor__() {
            }

            private final ShortcutInfo $$robo$$android_content_pm_ShortcutInfo_1$createFromParcel(Parcel source) {
                return new ShortcutInfo(source);
            }

            private final ShortcutInfo[] $$robo$$android_content_pm_ShortcutInfo_1$newArray(int size) {
                return new ShortcutInfo[size];
            }

            private void __constructor__() {
                this.$$robo$$android_content_pm_ShortcutInfo_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_ShortcutInfo_1$__constructor__(), 0, this);
            }

            @Override
            public ShortcutInfo createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_content_pm_ShortcutInfo_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public ShortcutInfo[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_content_pm_ShortcutInfo_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(Builder builder) {
        this.$$robo$$android_content_pm_ShortcutInfo$__constructor__(builder);
    }

    private ShortcutInfo(Builder builder) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_ShortcutInfo$__constructor__(android.content.pm.ShortcutInfo$Builder ), 0, this, builder);
    }

    private void fixUpIntentExtras() {
        InvokeDynamicSupport.bootstrap("fixUpIntentExtras", $$robo$$android_content_pm_ShortcutInfo$fixUpIntentExtras(), 0, this);
    }

    private static ArraySet<String> cloneCategories(Set<String> set) {
        return InvokeDynamicSupport.bootstrapStatic("cloneCategories", $$robo$$android_content_pm_ShortcutInfo$cloneCategories(java.util.Set<java.lang.String> ), 0, set);
    }

    private static Intent[] cloneIntents(Intent[] intentArray) {
        return InvokeDynamicSupport.bootstrapStatic("cloneIntents", $$robo$$android_content_pm_ShortcutInfo$cloneIntents(android.content.Intent[] ), 0, (Intent[])intentArray);
    }

    private static PersistableBundle[] clonePersistableBundle(PersistableBundle[] persistableBundleArray) {
        return InvokeDynamicSupport.bootstrapStatic("clonePersistableBundle", $$robo$$android_content_pm_ShortcutInfo$clonePersistableBundle(android.os.PersistableBundle[] ), 0, (PersistableBundle[])persistableBundleArray);
    }

    public void enforceMandatoryFields(boolean bl) {
        InvokeDynamicSupport.bootstrap("enforceMandatoryFields", $$robo$$android_content_pm_ShortcutInfo$enforceMandatoryFields(boolean ), 0, this, bl);
    }

    private void __constructor__(ShortcutInfo shortcutInfo, int n) {
        this.$$robo$$android_content_pm_ShortcutInfo$__constructor__(shortcutInfo, n);
    }

    private ShortcutInfo(ShortcutInfo shortcutInfo, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_ShortcutInfo$__constructor__(android.content.pm.ShortcutInfo int ), 0, this, shortcutInfo, n);
    }

    private CharSequence getResourceString(Resources resources, int n, CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrap("getResourceString", $$robo$$android_content_pm_ShortcutInfo$getResourceString(android.content.res.Resources int java.lang.CharSequence ), 0, this, resources, n, charSequence);
    }

    public void resolveResourceStrings(Resources resources) {
        InvokeDynamicSupport.bootstrap("resolveResourceStrings", $$robo$$android_content_pm_ShortcutInfo$resolveResourceStrings(android.content.res.Resources ), 0, this, resources);
    }

    public static String lookUpResourceName(Resources resources, int n, boolean bl, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("lookUpResourceName", $$robo$$android_content_pm_ShortcutInfo$lookUpResourceName(android.content.res.Resources int boolean java.lang.String ), 0, (Resources)resources, (int)n, (boolean)bl, (String)string2);
    }

    public static String getResourcePackageName(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getResourcePackageName", $$robo$$android_content_pm_ShortcutInfo$getResourcePackageName(java.lang.String ), 0, (String)string2);
    }

    public static String getResourceTypeName(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getResourceTypeName", $$robo$$android_content_pm_ShortcutInfo$getResourceTypeName(java.lang.String ), 0, (String)string2);
    }

    public static String getResourceTypeAndEntryName(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getResourceTypeAndEntryName", $$robo$$android_content_pm_ShortcutInfo$getResourceTypeAndEntryName(java.lang.String ), 0, (String)string2);
    }

    public static String getResourceEntryName(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getResourceEntryName", $$robo$$android_content_pm_ShortcutInfo$getResourceEntryName(java.lang.String ), 0, (String)string2);
    }

    public static int lookUpResourceId(Resources resources, String string2, String string3, String string4) {
        return (int)InvokeDynamicSupport.bootstrapStatic("lookUpResourceId", $$robo$$android_content_pm_ShortcutInfo$lookUpResourceId(android.content.res.Resources java.lang.String java.lang.String java.lang.String ), 0, (Resources)resources, (String)string2, (String)string3, (String)string4);
    }

    public void lookupAndFillInResourceNames(Resources resources) {
        InvokeDynamicSupport.bootstrap("lookupAndFillInResourceNames", $$robo$$android_content_pm_ShortcutInfo$lookupAndFillInResourceNames(android.content.res.Resources ), 0, this, resources);
    }

    public void lookupAndFillInResourceIds(Resources resources) {
        InvokeDynamicSupport.bootstrap("lookupAndFillInResourceIds", $$robo$$android_content_pm_ShortcutInfo$lookupAndFillInResourceIds(android.content.res.Resources ), 0, this, resources);
    }

    public ShortcutInfo clone(int n) {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_content_pm_ShortcutInfo$clone(int ), 0, this, n);
    }

    public void ensureUpdatableWith(ShortcutInfo shortcutInfo) {
        InvokeDynamicSupport.bootstrap("ensureUpdatableWith", $$robo$$android_content_pm_ShortcutInfo$ensureUpdatableWith(android.content.pm.ShortcutInfo ), 0, this, shortcutInfo);
    }

    public void copyNonNullFieldsFrom(ShortcutInfo shortcutInfo) {
        InvokeDynamicSupport.bootstrap("copyNonNullFieldsFrom", $$robo$$android_content_pm_ShortcutInfo$copyNonNullFieldsFrom(android.content.pm.ShortcutInfo ), 0, this, shortcutInfo);
    }

    public static Icon validateIcon(Icon icon) {
        return InvokeDynamicSupport.bootstrapStatic("validateIcon", $$robo$$android_content_pm_ShortcutInfo$validateIcon(android.graphics.drawable.Icon ), 0, (Icon)icon);
    }

    public static IllegalArgumentException getInvalidIconException() {
        return InvokeDynamicSupport.bootstrapStatic("getInvalidIconException", $$robo$$android_content_pm_ShortcutInfo$getInvalidIconException(), 0);
    }

    public String getId() {
        return InvokeDynamicSupport.bootstrap("getId", $$robo$$android_content_pm_ShortcutInfo$getId(), 0, this);
    }

    public String getPackage() {
        return InvokeDynamicSupport.bootstrap("getPackage", $$robo$$android_content_pm_ShortcutInfo$getPackage(), 0, this);
    }

    public ComponentName getActivity() {
        return InvokeDynamicSupport.bootstrap("getActivity", $$robo$$android_content_pm_ShortcutInfo$getActivity(), 0, this);
    }

    public void setActivity(ComponentName componentName) {
        InvokeDynamicSupport.bootstrap("setActivity", $$robo$$android_content_pm_ShortcutInfo$setActivity(android.content.ComponentName ), 0, this, componentName);
    }

    public Icon getIcon() {
        return InvokeDynamicSupport.bootstrap("getIcon", $$robo$$android_content_pm_ShortcutInfo$getIcon(), 0, this);
    }

    @Deprecated
    public CharSequence getTitle() {
        return InvokeDynamicSupport.bootstrap("getTitle", $$robo$$android_content_pm_ShortcutInfo$getTitle(), 0, this);
    }

    @Deprecated
    public int getTitleResId() {
        return (int)InvokeDynamicSupport.bootstrap("getTitleResId", $$robo$$android_content_pm_ShortcutInfo$getTitleResId(), 0, this);
    }

    @Deprecated
    public CharSequence getText() {
        return InvokeDynamicSupport.bootstrap("getText", $$robo$$android_content_pm_ShortcutInfo$getText(), 0, this);
    }

    @Deprecated
    public int getTextResId() {
        return (int)InvokeDynamicSupport.bootstrap("getTextResId", $$robo$$android_content_pm_ShortcutInfo$getTextResId(), 0, this);
    }

    public CharSequence getShortLabel() {
        return InvokeDynamicSupport.bootstrap("getShortLabel", $$robo$$android_content_pm_ShortcutInfo$getShortLabel(), 0, this);
    }

    public int getShortLabelResourceId() {
        return (int)InvokeDynamicSupport.bootstrap("getShortLabelResourceId", $$robo$$android_content_pm_ShortcutInfo$getShortLabelResourceId(), 0, this);
    }

    public CharSequence getLongLabel() {
        return InvokeDynamicSupport.bootstrap("getLongLabel", $$robo$$android_content_pm_ShortcutInfo$getLongLabel(), 0, this);
    }

    public int getLongLabelResourceId() {
        return (int)InvokeDynamicSupport.bootstrap("getLongLabelResourceId", $$robo$$android_content_pm_ShortcutInfo$getLongLabelResourceId(), 0, this);
    }

    public CharSequence getDisabledMessage() {
        return InvokeDynamicSupport.bootstrap("getDisabledMessage", $$robo$$android_content_pm_ShortcutInfo$getDisabledMessage(), 0, this);
    }

    public int getDisabledMessageResourceId() {
        return (int)InvokeDynamicSupport.bootstrap("getDisabledMessageResourceId", $$robo$$android_content_pm_ShortcutInfo$getDisabledMessageResourceId(), 0, this);
    }

    public Set<String> getCategories() {
        return InvokeDynamicSupport.bootstrap("getCategories", $$robo$$android_content_pm_ShortcutInfo$getCategories(), 0, this);
    }

    public Intent getIntent() {
        return InvokeDynamicSupport.bootstrap("getIntent", $$robo$$android_content_pm_ShortcutInfo$getIntent(), 0, this);
    }

    public Intent[] getIntents() {
        return InvokeDynamicSupport.bootstrap("getIntents", $$robo$$android_content_pm_ShortcutInfo$getIntents(), 0, this);
    }

    public Intent[] getIntentsNoExtras() {
        return InvokeDynamicSupport.bootstrap("getIntentsNoExtras", $$robo$$android_content_pm_ShortcutInfo$getIntentsNoExtras(), 0, this);
    }

    public PersistableBundle[] getIntentPersistableExtrases() {
        return InvokeDynamicSupport.bootstrap("getIntentPersistableExtrases", $$robo$$android_content_pm_ShortcutInfo$getIntentPersistableExtrases(), 0, this);
    }

    public int getRank() {
        return (int)InvokeDynamicSupport.bootstrap("getRank", $$robo$$android_content_pm_ShortcutInfo$getRank(), 0, this);
    }

    public boolean hasRank() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasRank", $$robo$$android_content_pm_ShortcutInfo$hasRank(), 0, this);
    }

    public void setRank(int n) {
        InvokeDynamicSupport.bootstrap("setRank", $$robo$$android_content_pm_ShortcutInfo$setRank(int ), 0, this, n);
    }

    public void clearImplicitRankAndRankChangedFlag() {
        InvokeDynamicSupport.bootstrap("clearImplicitRankAndRankChangedFlag", $$robo$$android_content_pm_ShortcutInfo$clearImplicitRankAndRankChangedFlag(), 0, this);
    }

    public void setImplicitRank(int n) {
        InvokeDynamicSupport.bootstrap("setImplicitRank", $$robo$$android_content_pm_ShortcutInfo$setImplicitRank(int ), 0, this, n);
    }

    public int getImplicitRank() {
        return (int)InvokeDynamicSupport.bootstrap("getImplicitRank", $$robo$$android_content_pm_ShortcutInfo$getImplicitRank(), 0, this);
    }

    public void setRankChanged() {
        InvokeDynamicSupport.bootstrap("setRankChanged", $$robo$$android_content_pm_ShortcutInfo$setRankChanged(), 0, this);
    }

    public boolean isRankChanged() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRankChanged", $$robo$$android_content_pm_ShortcutInfo$isRankChanged(), 0, this);
    }

    public PersistableBundle getExtras() {
        return InvokeDynamicSupport.bootstrap("getExtras", $$robo$$android_content_pm_ShortcutInfo$getExtras(), 0, this);
    }

    public int getUserId() {
        return (int)InvokeDynamicSupport.bootstrap("getUserId", $$robo$$android_content_pm_ShortcutInfo$getUserId(), 0, this);
    }

    public UserHandle getUserHandle() {
        return InvokeDynamicSupport.bootstrap("getUserHandle", $$robo$$android_content_pm_ShortcutInfo$getUserHandle(), 0, this);
    }

    public long getLastChangedTimestamp() {
        return (long)InvokeDynamicSupport.bootstrap("getLastChangedTimestamp", $$robo$$android_content_pm_ShortcutInfo$getLastChangedTimestamp(), 0, this);
    }

    public int getFlags() {
        return (int)InvokeDynamicSupport.bootstrap("getFlags", $$robo$$android_content_pm_ShortcutInfo$getFlags(), 0, this);
    }

    public void replaceFlags(int n) {
        InvokeDynamicSupport.bootstrap("replaceFlags", $$robo$$android_content_pm_ShortcutInfo$replaceFlags(int ), 0, this, n);
    }

    public void addFlags(int n) {
        InvokeDynamicSupport.bootstrap("addFlags", $$robo$$android_content_pm_ShortcutInfo$addFlags(int ), 0, this, n);
    }

    public void clearFlags(int n) {
        InvokeDynamicSupport.bootstrap("clearFlags", $$robo$$android_content_pm_ShortcutInfo$clearFlags(int ), 0, this, n);
    }

    public boolean hasFlags(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasFlags", $$robo$$android_content_pm_ShortcutInfo$hasFlags(int ), 0, this, n);
    }

    public boolean isReturnedByServer() {
        return (boolean)InvokeDynamicSupport.bootstrap("isReturnedByServer", $$robo$$android_content_pm_ShortcutInfo$isReturnedByServer(), 0, this);
    }

    public void setReturnedByServer() {
        InvokeDynamicSupport.bootstrap("setReturnedByServer", $$robo$$android_content_pm_ShortcutInfo$setReturnedByServer(), 0, this);
    }

    public boolean isDynamic() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDynamic", $$robo$$android_content_pm_ShortcutInfo$isDynamic(), 0, this);
    }

    public boolean isPinned() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPinned", $$robo$$android_content_pm_ShortcutInfo$isPinned(), 0, this);
    }

    public boolean isDeclaredInManifest() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDeclaredInManifest", $$robo$$android_content_pm_ShortcutInfo$isDeclaredInManifest(), 0, this);
    }

    @Deprecated
    public boolean isManifestShortcut() {
        return (boolean)InvokeDynamicSupport.bootstrap("isManifestShortcut", $$robo$$android_content_pm_ShortcutInfo$isManifestShortcut(), 0, this);
    }

    public boolean isFloating() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFloating", $$robo$$android_content_pm_ShortcutInfo$isFloating(), 0, this);
    }

    public boolean isOriginallyFromManifest() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOriginallyFromManifest", $$robo$$android_content_pm_ShortcutInfo$isOriginallyFromManifest(), 0, this);
    }

    public boolean isImmutable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isImmutable", $$robo$$android_content_pm_ShortcutInfo$isImmutable(), 0, this);
    }

    public boolean isEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$android_content_pm_ShortcutInfo$isEnabled(), 0, this);
    }

    public boolean isAlive() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAlive", $$robo$$android_content_pm_ShortcutInfo$isAlive(), 0, this);
    }

    public boolean usesQuota() {
        return (boolean)InvokeDynamicSupport.bootstrap("usesQuota", $$robo$$android_content_pm_ShortcutInfo$usesQuota(), 0, this);
    }

    public boolean hasIconResource() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasIconResource", $$robo$$android_content_pm_ShortcutInfo$hasIconResource(), 0, this);
    }

    public boolean hasStringResources() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasStringResources", $$robo$$android_content_pm_ShortcutInfo$hasStringResources(), 0, this);
    }

    public boolean hasAnyResources() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasAnyResources", $$robo$$android_content_pm_ShortcutInfo$hasAnyResources(), 0, this);
    }

    public boolean hasIconFile() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasIconFile", $$robo$$android_content_pm_ShortcutInfo$hasIconFile(), 0, this);
    }

    public boolean hasAdaptiveBitmap() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasAdaptiveBitmap", $$robo$$android_content_pm_ShortcutInfo$hasAdaptiveBitmap(), 0, this);
    }

    public boolean isIconPendingSave() {
        return (boolean)InvokeDynamicSupport.bootstrap("isIconPendingSave", $$robo$$android_content_pm_ShortcutInfo$isIconPendingSave(), 0, this);
    }

    public void setIconPendingSave() {
        InvokeDynamicSupport.bootstrap("setIconPendingSave", $$robo$$android_content_pm_ShortcutInfo$setIconPendingSave(), 0, this);
    }

    public void clearIconPendingSave() {
        InvokeDynamicSupport.bootstrap("clearIconPendingSave", $$robo$$android_content_pm_ShortcutInfo$clearIconPendingSave(), 0, this);
    }

    public boolean hasKeyFieldsOnly() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasKeyFieldsOnly", $$robo$$android_content_pm_ShortcutInfo$hasKeyFieldsOnly(), 0, this);
    }

    public boolean hasStringResourcesResolved() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasStringResourcesResolved", $$robo$$android_content_pm_ShortcutInfo$hasStringResourcesResolved(), 0, this);
    }

    public void updateTimestamp() {
        InvokeDynamicSupport.bootstrap("updateTimestamp", $$robo$$android_content_pm_ShortcutInfo$updateTimestamp(), 0, this);
    }

    public void setTimestamp(long l) {
        InvokeDynamicSupport.bootstrap("setTimestamp", $$robo$$android_content_pm_ShortcutInfo$setTimestamp(long ), 0, this, l);
    }

    public void clearIcon() {
        InvokeDynamicSupport.bootstrap("clearIcon", $$robo$$android_content_pm_ShortcutInfo$clearIcon(), 0, this);
    }

    public void setIconResourceId(int n) {
        InvokeDynamicSupport.bootstrap("setIconResourceId", $$robo$$android_content_pm_ShortcutInfo$setIconResourceId(int ), 0, this, n);
    }

    public int getIconResourceId() {
        return (int)InvokeDynamicSupport.bootstrap("getIconResourceId", $$robo$$android_content_pm_ShortcutInfo$getIconResourceId(), 0, this);
    }

    public String getBitmapPath() {
        return InvokeDynamicSupport.bootstrap("getBitmapPath", $$robo$$android_content_pm_ShortcutInfo$getBitmapPath(), 0, this);
    }

    public void setBitmapPath(String string2) {
        InvokeDynamicSupport.bootstrap("setBitmapPath", $$robo$$android_content_pm_ShortcutInfo$setBitmapPath(java.lang.String ), 0, this, string2);
    }

    public void setDisabledMessageResId(int n) {
        InvokeDynamicSupport.bootstrap("setDisabledMessageResId", $$robo$$android_content_pm_ShortcutInfo$setDisabledMessageResId(int ), 0, this, n);
    }

    public void setDisabledMessage(String string2) {
        InvokeDynamicSupport.bootstrap("setDisabledMessage", $$robo$$android_content_pm_ShortcutInfo$setDisabledMessage(java.lang.String ), 0, this, string2);
    }

    public String getTitleResName() {
        return InvokeDynamicSupport.bootstrap("getTitleResName", $$robo$$android_content_pm_ShortcutInfo$getTitleResName(), 0, this);
    }

    public void setTitleResName(String string2) {
        InvokeDynamicSupport.bootstrap("setTitleResName", $$robo$$android_content_pm_ShortcutInfo$setTitleResName(java.lang.String ), 0, this, string2);
    }

    public String getTextResName() {
        return InvokeDynamicSupport.bootstrap("getTextResName", $$robo$$android_content_pm_ShortcutInfo$getTextResName(), 0, this);
    }

    public void setTextResName(String string2) {
        InvokeDynamicSupport.bootstrap("setTextResName", $$robo$$android_content_pm_ShortcutInfo$setTextResName(java.lang.String ), 0, this, string2);
    }

    public String getDisabledMessageResName() {
        return InvokeDynamicSupport.bootstrap("getDisabledMessageResName", $$robo$$android_content_pm_ShortcutInfo$getDisabledMessageResName(), 0, this);
    }

    public void setDisabledMessageResName(String string2) {
        InvokeDynamicSupport.bootstrap("setDisabledMessageResName", $$robo$$android_content_pm_ShortcutInfo$setDisabledMessageResName(java.lang.String ), 0, this, string2);
    }

    public String getIconResName() {
        return InvokeDynamicSupport.bootstrap("getIconResName", $$robo$$android_content_pm_ShortcutInfo$getIconResName(), 0, this);
    }

    public void setIconResName(String string2) {
        InvokeDynamicSupport.bootstrap("setIconResName", $$robo$$android_content_pm_ShortcutInfo$setIconResName(java.lang.String ), 0, this, string2);
    }

    public void setIntents(Intent[] intentArray) throws IllegalArgumentException {
        InvokeDynamicSupport.bootstrap("setIntents", $$robo$$android_content_pm_ShortcutInfo$setIntents(android.content.Intent[] ), 0, this, intentArray);
    }

    public static Intent setIntentExtras(Intent intent, PersistableBundle persistableBundle) {
        return InvokeDynamicSupport.bootstrapStatic("setIntentExtras", $$robo$$android_content_pm_ShortcutInfo$setIntentExtras(android.content.Intent android.os.PersistableBundle ), 0, (Intent)intent, (PersistableBundle)persistableBundle);
    }

    public void setCategories(Set<String> set) {
        InvokeDynamicSupport.bootstrap("setCategories", $$robo$$android_content_pm_ShortcutInfo$setCategories(java.util.Set<java.lang.String> ), 0, this, set);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_content_pm_ShortcutInfo$__constructor__(parcel);
    }

    private ShortcutInfo(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_ShortcutInfo$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_content_pm_ShortcutInfo$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_content_pm_ShortcutInfo$describeContents(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_content_pm_ShortcutInfo$toString(), 0, this);
    }

    public String toInsecureString() {
        return InvokeDynamicSupport.bootstrap("toInsecureString", $$robo$$android_content_pm_ShortcutInfo$toInsecureString(), 0, this);
    }

    private String toStringInner(boolean bl, boolean bl2) {
        return InvokeDynamicSupport.bootstrap("toStringInner", $$robo$$android_content_pm_ShortcutInfo$toStringInner(boolean boolean ), 0, this, bl, bl2);
    }

    private void __constructor__(int n, String string2, String string3, ComponentName componentName, Icon icon, CharSequence charSequence, int n2, String string4, CharSequence charSequence2, int n3, String string5, CharSequence charSequence3, int n4, String string6, Set<String> set, Intent[] intentArray, int n5, PersistableBundle persistableBundle, long l, int n6, int n7, String string7, String string8) {
        this.$$robo$$android_content_pm_ShortcutInfo$__constructor__(n, string2, string3, componentName, icon, charSequence, n2, string4, charSequence2, n3, string5, charSequence3, n4, string6, set, intentArray, n5, persistableBundle, l, n6, n7, string7, string8);
    }

    public ShortcutInfo(int n, String string2, String string3, ComponentName componentName, Icon icon, CharSequence charSequence, int n2, String string4, CharSequence charSequence2, int n3, String string5, CharSequence charSequence3, int n4, String string6, Set<String> set, Intent[] intentArray, int n5, PersistableBundle persistableBundle, long l, int n6, int n7, String string7, String string8) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_ShortcutInfo$__constructor__(int java.lang.String java.lang.String android.content.ComponentName android.graphics.drawable.Icon java.lang.CharSequence int java.lang.String java.lang.CharSequence int java.lang.String java.lang.CharSequence int java.lang.String java.util.Set<java.lang.String> android.content.Intent[] int android.os.PersistableBundle long int int java.lang.String java.lang.String ), 0, this, n, string2, string3, componentName, icon, charSequence, n2, string4, charSequence2, n3, string5, charSequence3, n4, string6, set, intentArray, n5, persistableBundle, l, n6, n7, string7, string8);
    }

    private /* synthetic */ void __constructor__(Builder builder, 1 var2_2) {
        this.$$robo$$android_content_pm_ShortcutInfo$__constructor__(builder, var2_2);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_content_pm_ShortcutInfo$__constructor__(parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(ShortcutInfo.class);
    }

    public /* synthetic */ ShortcutInfo() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ShortcutInfo)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Builder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Context mContext;
        private String mId;
        private ComponentName mActivity;
        private Icon mIcon;
        private int mTitleResId;
        private CharSequence mTitle;
        private int mTextResId;
        private CharSequence mText;
        private int mDisabledMessageResId;
        private CharSequence mDisabledMessage;
        private Set<String> mCategories;
        private Intent[] mIntents;
        private int mRank;
        private PersistableBundle mExtras;

        @Deprecated
        private void $$robo$$android_content_pm_ShortcutInfo_Builder$__constructor__(Context context) {
            this.mRank = Integer.MAX_VALUE;
            this.mContext = context;
        }

        @Deprecated
        private final Builder $$robo$$android_content_pm_ShortcutInfo_Builder$setId(String id2) {
            this.mId = Preconditions.checkStringNotEmpty(id2, "id cannot be empty");
            return this;
        }

        private void $$robo$$android_content_pm_ShortcutInfo_Builder$__constructor__(Context context, String id2) {
            this.mRank = Integer.MAX_VALUE;
            this.mContext = context;
            this.mId = Preconditions.checkStringNotEmpty(id2, "id cannot be empty");
        }

        private final Builder $$robo$$android_content_pm_ShortcutInfo_Builder$setActivity(ComponentName activity) {
            this.mActivity = Preconditions.checkNotNull(activity, "activity cannot be null");
            return this;
        }

        private final Builder $$robo$$android_content_pm_ShortcutInfo_Builder$setIcon(Icon icon) {
            this.mIcon = ShortcutInfo.validateIcon(icon);
            return this;
        }

        @Deprecated
        private final Builder $$robo$$android_content_pm_ShortcutInfo_Builder$setShortLabelResId(int shortLabelResId) {
            Preconditions.checkState(this.mTitle == null, "shortLabel already set");
            this.mTitleResId = shortLabelResId;
            return this;
        }

        private final Builder $$robo$$android_content_pm_ShortcutInfo_Builder$setShortLabel(CharSequence shortLabel) {
            Preconditions.checkState(this.mTitleResId == 0, "shortLabelResId already set");
            this.mTitle = Preconditions.checkStringNotEmpty(shortLabel, "shortLabel cannot be empty");
            return this;
        }

        @Deprecated
        private final Builder $$robo$$android_content_pm_ShortcutInfo_Builder$setLongLabelResId(int longLabelResId) {
            Preconditions.checkState(this.mText == null, "longLabel already set");
            this.mTextResId = longLabelResId;
            return this;
        }

        private final Builder $$robo$$android_content_pm_ShortcutInfo_Builder$setLongLabel(CharSequence longLabel) {
            Preconditions.checkState(this.mTextResId == 0, "longLabelResId already set");
            this.mText = Preconditions.checkStringNotEmpty(longLabel, "longLabel cannot be empty");
            return this;
        }

        @Deprecated
        private final Builder $$robo$$android_content_pm_ShortcutInfo_Builder$setTitle(CharSequence value) {
            return this.setShortLabel(value);
        }

        @Deprecated
        private final Builder $$robo$$android_content_pm_ShortcutInfo_Builder$setTitleResId(int value) {
            return this.setShortLabelResId(value);
        }

        @Deprecated
        private final Builder $$robo$$android_content_pm_ShortcutInfo_Builder$setText(CharSequence value) {
            return this.setLongLabel(value);
        }

        @Deprecated
        private final Builder $$robo$$android_content_pm_ShortcutInfo_Builder$setTextResId(int value) {
            return this.setLongLabelResId(value);
        }

        @Deprecated
        private final Builder $$robo$$android_content_pm_ShortcutInfo_Builder$setDisabledMessageResId(int disabledMessageResId) {
            Preconditions.checkState(this.mDisabledMessage == null, "disabledMessage already set");
            this.mDisabledMessageResId = disabledMessageResId;
            return this;
        }

        private final Builder $$robo$$android_content_pm_ShortcutInfo_Builder$setDisabledMessage(CharSequence disabledMessage) {
            Preconditions.checkState(this.mDisabledMessageResId == 0, "disabledMessageResId already set");
            this.mDisabledMessage = Preconditions.checkStringNotEmpty(disabledMessage, "disabledMessage cannot be empty");
            return this;
        }

        private final Builder $$robo$$android_content_pm_ShortcutInfo_Builder$setCategories(Set<String> categories) {
            this.mCategories = categories;
            return this;
        }

        private final Builder $$robo$$android_content_pm_ShortcutInfo_Builder$setIntent(Intent intent) {
            return this.setIntents(new Intent[]{intent});
        }

        private final Builder $$robo$$android_content_pm_ShortcutInfo_Builder$setIntents(Intent[] intents) {
            Preconditions.checkNotNull(intents, "intents cannot be null");
            Preconditions.checkNotNull(intents.length, "intents cannot be empty");
            for (Intent intent : intents) {
                Preconditions.checkNotNull(intent, "intents cannot contain null");
                Preconditions.checkNotNull(intent.getAction(), "intent's action must be set");
            }
            this.mIntents = ShortcutInfo.cloneIntents(intents);
            return this;
        }

        private final Builder $$robo$$android_content_pm_ShortcutInfo_Builder$setRank(int rank) {
            Preconditions.checkArgument(0 <= rank, "Rank cannot be negative or bigger than MAX_RANK");
            this.mRank = rank;
            return this;
        }

        private final Builder $$robo$$android_content_pm_ShortcutInfo_Builder$setExtras(PersistableBundle extras) {
            this.mExtras = extras;
            return this;
        }

        private final ShortcutInfo $$robo$$android_content_pm_ShortcutInfo_Builder$build() {
            return new ShortcutInfo(this);
        }

        private void __constructor__(Context context) {
            this.$$robo$$android_content_pm_ShortcutInfo_Builder$__constructor__(context);
        }

        public Builder(Context context) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_ShortcutInfo_Builder$__constructor__(android.content.Context ), 0, this, context);
        }

        @Deprecated
        public Builder setId(String string2) {
            return InvokeDynamicSupport.bootstrap("setId", $$robo$$android_content_pm_ShortcutInfo_Builder$setId(java.lang.String ), 0, this, string2);
        }

        private void __constructor__(Context context, String string2) {
            this.$$robo$$android_content_pm_ShortcutInfo_Builder$__constructor__(context, string2);
        }

        public Builder(Context context, String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_ShortcutInfo_Builder$__constructor__(android.content.Context java.lang.String ), 0, this, context, string2);
        }

        public Builder setActivity(ComponentName componentName) {
            return InvokeDynamicSupport.bootstrap("setActivity", $$robo$$android_content_pm_ShortcutInfo_Builder$setActivity(android.content.ComponentName ), 0, this, componentName);
        }

        public Builder setIcon(Icon icon) {
            return InvokeDynamicSupport.bootstrap("setIcon", $$robo$$android_content_pm_ShortcutInfo_Builder$setIcon(android.graphics.drawable.Icon ), 0, this, icon);
        }

        @Deprecated
        public Builder setShortLabelResId(int n) {
            return InvokeDynamicSupport.bootstrap("setShortLabelResId", $$robo$$android_content_pm_ShortcutInfo_Builder$setShortLabelResId(int ), 0, this, n);
        }

        public Builder setShortLabel(CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrap("setShortLabel", $$robo$$android_content_pm_ShortcutInfo_Builder$setShortLabel(java.lang.CharSequence ), 0, this, charSequence);
        }

        @Deprecated
        public Builder setLongLabelResId(int n) {
            return InvokeDynamicSupport.bootstrap("setLongLabelResId", $$robo$$android_content_pm_ShortcutInfo_Builder$setLongLabelResId(int ), 0, this, n);
        }

        public Builder setLongLabel(CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrap("setLongLabel", $$robo$$android_content_pm_ShortcutInfo_Builder$setLongLabel(java.lang.CharSequence ), 0, this, charSequence);
        }

        @Deprecated
        public Builder setTitle(CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrap("setTitle", $$robo$$android_content_pm_ShortcutInfo_Builder$setTitle(java.lang.CharSequence ), 0, this, charSequence);
        }

        @Deprecated
        public Builder setTitleResId(int n) {
            return InvokeDynamicSupport.bootstrap("setTitleResId", $$robo$$android_content_pm_ShortcutInfo_Builder$setTitleResId(int ), 0, this, n);
        }

        @Deprecated
        public Builder setText(CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrap("setText", $$robo$$android_content_pm_ShortcutInfo_Builder$setText(java.lang.CharSequence ), 0, this, charSequence);
        }

        @Deprecated
        public Builder setTextResId(int n) {
            return InvokeDynamicSupport.bootstrap("setTextResId", $$robo$$android_content_pm_ShortcutInfo_Builder$setTextResId(int ), 0, this, n);
        }

        @Deprecated
        public Builder setDisabledMessageResId(int n) {
            return InvokeDynamicSupport.bootstrap("setDisabledMessageResId", $$robo$$android_content_pm_ShortcutInfo_Builder$setDisabledMessageResId(int ), 0, this, n);
        }

        public Builder setDisabledMessage(CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrap("setDisabledMessage", $$robo$$android_content_pm_ShortcutInfo_Builder$setDisabledMessage(java.lang.CharSequence ), 0, this, charSequence);
        }

        public Builder setCategories(Set<String> set) {
            return InvokeDynamicSupport.bootstrap("setCategories", $$robo$$android_content_pm_ShortcutInfo_Builder$setCategories(java.util.Set<java.lang.String> ), 0, this, set);
        }

        public Builder setIntent(Intent intent) {
            return InvokeDynamicSupport.bootstrap("setIntent", $$robo$$android_content_pm_ShortcutInfo_Builder$setIntent(android.content.Intent ), 0, this, intent);
        }

        public Builder setIntents(Intent[] intentArray) {
            return InvokeDynamicSupport.bootstrap("setIntents", $$robo$$android_content_pm_ShortcutInfo_Builder$setIntents(android.content.Intent[] ), 0, this, intentArray);
        }

        public Builder setRank(int n) {
            return InvokeDynamicSupport.bootstrap("setRank", $$robo$$android_content_pm_ShortcutInfo_Builder$setRank(int ), 0, this, n);
        }

        public Builder setExtras(PersistableBundle persistableBundle) {
            return InvokeDynamicSupport.bootstrap("setExtras", $$robo$$android_content_pm_ShortcutInfo_Builder$setExtras(android.os.PersistableBundle ), 0, this, persistableBundle);
        }

        public ShortcutInfo build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_content_pm_ShortcutInfo_Builder$build(), 0, this);
        }

        public /* synthetic */ Builder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CloneFlags {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ShortcutFlags {
    }
}

