/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.text.TextUtils;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Arrays;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class ResourcesKey
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public String mResDir;
    public String[] mSplitResDirs;
    public String[] mOverlayDirs;
    public String[] mLibDirs;
    public int mDisplayId;
    public Configuration mOverrideConfiguration;
    public CompatibilityInfo mCompatInfo;
    private int mHash;

    private void $$robo$$android_content_res_ResourcesKey$__constructor__(String resDir, String[] splitResDirs, String[] overlayDirs, String[] libDirs, int displayId, Configuration overrideConfig, CompatibilityInfo compatInfo) {
        this.mResDir = resDir;
        this.mSplitResDirs = splitResDirs;
        this.mOverlayDirs = overlayDirs;
        this.mLibDirs = libDirs;
        this.mDisplayId = displayId;
        this.mOverrideConfiguration = new Configuration(overrideConfig != null ? overrideConfig : Configuration.EMPTY);
        this.mCompatInfo = compatInfo != null ? compatInfo : CompatibilityInfo.DEFAULT_COMPATIBILITY_INFO;
        int hash = 17;
        hash = 31 * hash + Objects.hashCode(this.mResDir);
        hash = 31 * hash + Arrays.hashCode(this.mSplitResDirs);
        hash = 31 * hash + Arrays.hashCode(this.mOverlayDirs);
        hash = 31 * hash + Arrays.hashCode(this.mLibDirs);
        hash = 31 * hash + this.mDisplayId;
        hash = 31 * hash + Objects.hashCode(this.mOverrideConfiguration);
        this.mHash = hash = 31 * hash + Objects.hashCode(this.mCompatInfo);
    }

    private final boolean $$robo$$android_content_res_ResourcesKey$hasOverrideConfiguration() {
        return !Configuration.EMPTY.equals(this.mOverrideConfiguration);
    }

    private final boolean $$robo$$android_content_res_ResourcesKey$isPathReferenced(String path) {
        if (this.mResDir != null && this.mResDir.startsWith(path)) {
            return true;
        }
        return ResourcesKey.anyStartsWith(this.mSplitResDirs, path) || ResourcesKey.anyStartsWith(this.mOverlayDirs, path) || ResourcesKey.anyStartsWith(this.mLibDirs, path);
    }

    private static final boolean $$robo$$android_content_res_ResourcesKey$anyStartsWith(String[] list, String prefix) {
        if (list != null) {
            for (String s : list) {
                if (s == null || !s.startsWith(prefix)) continue;
                return true;
            }
        }
        return false;
    }

    private final int $$robo$$android_content_res_ResourcesKey$hashCode() {
        return this.mHash;
    }

    private final boolean $$robo$$android_content_res_ResourcesKey$equals(Object obj) {
        if (!(obj instanceof ResourcesKey)) {
            return false;
        }
        ResourcesKey peer = (ResourcesKey)obj;
        if (this.mHash != peer.mHash) {
            return false;
        }
        if (!Objects.equals(this.mResDir, peer.mResDir)) {
            return false;
        }
        if (!Arrays.equals(this.mSplitResDirs, peer.mSplitResDirs)) {
            return false;
        }
        if (!Arrays.equals(this.mOverlayDirs, peer.mOverlayDirs)) {
            return false;
        }
        if (!Arrays.equals(this.mLibDirs, peer.mLibDirs)) {
            return false;
        }
        if (this.mDisplayId != peer.mDisplayId) {
            return false;
        }
        if (!Objects.equals(this.mOverrideConfiguration, peer.mOverrideConfiguration)) {
            return false;
        }
        return Objects.equals(this.mCompatInfo, peer.mCompatInfo);
    }

    private final String $$robo$$android_content_res_ResourcesKey$toString() {
        StringBuilder builder = new StringBuilder().append("ResourcesKey{");
        builder.append(" mHash=").append(Integer.toHexString(this.mHash));
        builder.append(" mResDir=").append(this.mResDir);
        builder.append(" mSplitDirs=[");
        if (this.mSplitResDirs != null) {
            builder.append(TextUtils.join((CharSequence)",", this.mSplitResDirs));
        }
        builder.append("]");
        builder.append(" mOverlayDirs=[");
        if (this.mOverlayDirs != null) {
            builder.append(TextUtils.join((CharSequence)",", this.mOverlayDirs));
        }
        builder.append("]");
        builder.append(" mLibDirs=[");
        if (this.mLibDirs != null) {
            builder.append(TextUtils.join((CharSequence)",", this.mLibDirs));
        }
        builder.append("]");
        builder.append(" mDisplayId=").append(this.mDisplayId);
        builder.append(" mOverrideConfig=").append(Configuration.resourceQualifierString(this.mOverrideConfiguration));
        builder.append(" mCompatInfo=").append(this.mCompatInfo);
        builder.append("}");
        return builder.toString();
    }

    private void __constructor__(String string2, String[] stringArray, String[] stringArray2, String[] stringArray3, int n, Configuration configuration, CompatibilityInfo compatibilityInfo) {
        this.$$robo$$android_content_res_ResourcesKey$__constructor__(string2, stringArray, stringArray2, stringArray3, n, configuration, compatibilityInfo);
    }

    public ResourcesKey(String string2, String[] stringArray, String[] stringArray2, String[] stringArray3, int n, Configuration configuration, CompatibilityInfo compatibilityInfo) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_ResourcesKey$__constructor__(java.lang.String java.lang.String[] java.lang.String[] java.lang.String[] int android.content.res.Configuration android.content.res.CompatibilityInfo ), 0, this, string2, stringArray, stringArray2, stringArray3, n, configuration, compatibilityInfo);
    }

    public boolean hasOverrideConfiguration() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasOverrideConfiguration", $$robo$$android_content_res_ResourcesKey$hasOverrideConfiguration(), 0, this);
    }

    public boolean isPathReferenced(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isPathReferenced", $$robo$$android_content_res_ResourcesKey$isPathReferenced(java.lang.String ), 0, this, string2);
    }

    private static boolean anyStartsWith(String[] stringArray, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("anyStartsWith", $$robo$$android_content_res_ResourcesKey$anyStartsWith(java.lang.String[] java.lang.String ), 0, (String[])stringArray, (String)string2);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_content_res_ResourcesKey$hashCode(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_content_res_ResourcesKey$equals(java.lang.Object ), 0, this, object);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_content_res_ResourcesKey$toString(), 0, this);
    }

    public /* synthetic */ ResourcesKey() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ResourcesKey)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

