/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.database.CursorWindow;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteBindOrColumnIndexOutOfRangeException;
import android.database.sqlite.SQLiteConnectionPool;
import android.database.sqlite.SQLiteCustomFunction;
import android.database.sqlite.SQLiteDatabaseConfiguration;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.database.sqlite.SQLiteDebug;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteGlobal;
import android.database.sqlite.SQLiteStatementInfo;
import android.os.CancellationSignal;
import android.os.ParcelFileDescriptor;
import android.os.SystemClock;
import android.os.Trace;
import android.util.Log;
import android.util.LruCache;
import android.util.Printer;
import com.google.errorprone.annotations.DoNotMock;
import dalvik.system.BlockGuard;
import dalvik.system.CloseGuard;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class SQLiteConnection
implements CancellationSignal.OnCancelListener,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "SQLiteConnection";
    private static boolean DEBUG = false;
    private static String[] EMPTY_STRING_ARRAY;
    private static byte[] EMPTY_BYTE_ARRAY;
    private CloseGuard mCloseGuard;
    private SQLiteConnectionPool mPool;
    private SQLiteDatabaseConfiguration mConfiguration;
    private int mConnectionId;
    private boolean mIsPrimaryConnection;
    private boolean mIsReadOnlyConnection;
    private PreparedStatementCache mPreparedStatementCache;
    private PreparedStatement mPreparedStatementPool;
    private OperationLog mRecentOperations;
    private long mConnectionPtr;
    private boolean mOnlyAllowReadOnlyOperations;
    private int mCancellationSignalAttachCount;
    static /* synthetic */ boolean $assertionsDisabled;

    private static final long $$robo$$android_database_sqlite_SQLiteConnection$nativeOpen(String string2, int n, String string3, boolean bl, boolean bl2, int n2, int n3) {
        return 0L;
    }

    private static final void $$robo$$android_database_sqlite_SQLiteConnection$nativeClose(long l) {
    }

    private static final void $$robo$$android_database_sqlite_SQLiteConnection$nativeRegisterCustomFunction(long l, SQLiteCustomFunction sQLiteCustomFunction) {
    }

    private static final void $$robo$$android_database_sqlite_SQLiteConnection$nativeRegisterLocalizedCollators(long l, String string2) {
    }

    private static final long $$robo$$android_database_sqlite_SQLiteConnection$nativePrepareStatement(long l, String string2) {
        return 0L;
    }

    private static final void $$robo$$android_database_sqlite_SQLiteConnection$nativeFinalizeStatement(long l, long l2) {
    }

    private static final int $$robo$$android_database_sqlite_SQLiteConnection$nativeGetParameterCount(long l, long l2) {
        return 0;
    }

    private static final boolean $$robo$$android_database_sqlite_SQLiteConnection$nativeIsReadOnly(long l, long l2) {
        return false;
    }

    private static final int $$robo$$android_database_sqlite_SQLiteConnection$nativeGetColumnCount(long l, long l2) {
        return 0;
    }

    private static final String $$robo$$android_database_sqlite_SQLiteConnection$nativeGetColumnName(long l, long l2, int n) {
        return null;
    }

    private static final void $$robo$$android_database_sqlite_SQLiteConnection$nativeBindNull(long l, long l2, int n) {
    }

    private static final void $$robo$$android_database_sqlite_SQLiteConnection$nativeBindLong(long l, long l2, int n, long l3) {
    }

    private static final void $$robo$$android_database_sqlite_SQLiteConnection$nativeBindDouble(long l, long l2, int n, double d) {
    }

    private static final void $$robo$$android_database_sqlite_SQLiteConnection$nativeBindString(long l, long l2, int n, String string2) {
    }

    private static final void $$robo$$android_database_sqlite_SQLiteConnection$nativeBindBlob(long l, long l2, int n, byte[] byArray) {
    }

    private static final void $$robo$$android_database_sqlite_SQLiteConnection$nativeResetStatementAndClearBindings(long l, long l2) {
    }

    private static final void $$robo$$android_database_sqlite_SQLiteConnection$nativeExecute(long l, long l2) {
    }

    private static final long $$robo$$android_database_sqlite_SQLiteConnection$nativeExecuteForLong(long l, long l2) {
        return 0L;
    }

    private static final String $$robo$$android_database_sqlite_SQLiteConnection$nativeExecuteForString(long l, long l2) {
        return null;
    }

    private static final int $$robo$$android_database_sqlite_SQLiteConnection$nativeExecuteForBlobFileDescriptor(long l, long l2) {
        return 0;
    }

    private static final int $$robo$$android_database_sqlite_SQLiteConnection$nativeExecuteForChangedRowCount(long l, long l2) {
        return 0;
    }

    private static final long $$robo$$android_database_sqlite_SQLiteConnection$nativeExecuteForLastInsertedRowId(long l, long l2) {
        return 0L;
    }

    private static final long $$robo$$android_database_sqlite_SQLiteConnection$nativeExecuteForCursorWindow(long l, long l2, long l3, int n, int n2, boolean bl) {
        return 0L;
    }

    private static final int $$robo$$android_database_sqlite_SQLiteConnection$nativeGetDbLookaside(long l) {
        return 0;
    }

    private static final void $$robo$$android_database_sqlite_SQLiteConnection$nativeCancel(long l) {
    }

    private static final void $$robo$$android_database_sqlite_SQLiteConnection$nativeResetCancel(long l, boolean bl) {
    }

    private void $$robo$$android_database_sqlite_SQLiteConnection$__constructor__(SQLiteConnectionPool pool, SQLiteDatabaseConfiguration configuration, int connectionId, boolean primaryConnection) {
        this.mCloseGuard = CloseGuard.get();
        this.mRecentOperations = new OperationLog();
        this.mPool = pool;
        this.mConfiguration = new SQLiteDatabaseConfiguration(configuration);
        this.mConnectionId = connectionId;
        this.mIsPrimaryConnection = primaryConnection;
        this.mIsReadOnlyConnection = (configuration.openFlags & 1) != 0;
        this.mPreparedStatementCache = new PreparedStatementCache(this, this.mConfiguration.maxSqlCacheSize);
        this.mCloseGuard.open("close");
    }

    private final void $$robo$$android_database_sqlite_SQLiteConnection$finalize() throws Throwable {
        try {
            if (this.mPool != null && this.mConnectionPtr != 0L) {
                this.mPool.onConnectionLeaked();
            }
            this.dispose(true);
        }
        finally {
            super.finalize();
        }
    }

    private static final SQLiteConnection $$robo$$android_database_sqlite_SQLiteConnection$open(SQLiteConnectionPool pool, SQLiteDatabaseConfiguration configuration, int connectionId, boolean primaryConnection) {
        SQLiteConnection connection = new SQLiteConnection(pool, configuration, connectionId, primaryConnection);
        try {
            connection.open();
            return connection;
        }
        catch (SQLiteException ex) {
            connection.dispose(false);
            throw ex;
        }
    }

    private final void $$robo$$android_database_sqlite_SQLiteConnection$close() {
        this.dispose(false);
    }

    private final void $$robo$$android_database_sqlite_SQLiteConnection$open() {
        this.mConnectionPtr = SQLiteConnection.nativeOpen(this.mConfiguration.path, this.mConfiguration.openFlags, this.mConfiguration.label, SQLiteDebug.DEBUG_SQL_STATEMENTS, SQLiteDebug.DEBUG_SQL_TIME, this.mConfiguration.lookasideSlotSize, this.mConfiguration.lookasideSlotCount);
        this.setPageSize();
        this.setForeignKeyModeFromConfiguration();
        this.setWalModeFromConfiguration();
        this.setJournalSizeLimit();
        this.setAutoCheckpointInterval();
        this.setLocaleFromConfiguration();
        int functionCount = this.mConfiguration.customFunctions.size();
        for (int i = 0; i < functionCount; ++i) {
            SQLiteCustomFunction function = this.mConfiguration.customFunctions.get(i);
            SQLiteConnection.nativeRegisterCustomFunction(this.mConnectionPtr, function);
        }
    }

    private final void $$robo$$android_database_sqlite_SQLiteConnection$dispose(boolean finalized) {
        if (this.mCloseGuard != null) {
            if (finalized) {
                this.mCloseGuard.warnIfOpen();
            }
            this.mCloseGuard.close();
        }
        if (this.mConnectionPtr != 0L) {
            int cookie = this.mRecentOperations.beginOperation("close", null, null);
            try {
                this.mPreparedStatementCache.evictAll();
                SQLiteConnection.nativeClose(this.mConnectionPtr);
                this.mConnectionPtr = 0L;
            }
            finally {
                this.mRecentOperations.endOperation(cookie);
            }
        }
    }

    private final void $$robo$$android_database_sqlite_SQLiteConnection$setPageSize() {
        if (!this.mConfiguration.isInMemoryDb() && !this.mIsReadOnlyConnection) {
            long newValue = SQLiteGlobal.getDefaultPageSize();
            long value = this.executeForLong("PRAGMA page_size", null, null);
            if (value != newValue) {
                this.execute("PRAGMA page_size=" + newValue, null, null);
            }
        }
    }

    private final void $$robo$$android_database_sqlite_SQLiteConnection$setAutoCheckpointInterval() {
        if (!this.mConfiguration.isInMemoryDb() && !this.mIsReadOnlyConnection) {
            long newValue = SQLiteGlobal.getWALAutoCheckpoint();
            long value = this.executeForLong("PRAGMA wal_autocheckpoint", null, null);
            if (value != newValue) {
                this.executeForLong("PRAGMA wal_autocheckpoint=" + newValue, null, null);
            }
        }
    }

    private final void $$robo$$android_database_sqlite_SQLiteConnection$setJournalSizeLimit() {
        if (!this.mConfiguration.isInMemoryDb() && !this.mIsReadOnlyConnection) {
            long newValue = SQLiteGlobal.getJournalSizeLimit();
            long value = this.executeForLong("PRAGMA journal_size_limit", null, null);
            if (value != newValue) {
                this.executeForLong("PRAGMA journal_size_limit=" + newValue, null, null);
            }
        }
    }

    private final void $$robo$$android_database_sqlite_SQLiteConnection$setForeignKeyModeFromConfiguration() {
        if (!this.mIsReadOnlyConnection) {
            long newValue = this.mConfiguration.foreignKeyConstraintsEnabled ? 1L : 0L;
            long value = this.executeForLong("PRAGMA foreign_keys", null, null);
            if (value != newValue) {
                this.execute("PRAGMA foreign_keys=" + newValue, null, null);
            }
        }
    }

    private final void $$robo$$android_database_sqlite_SQLiteConnection$setWalModeFromConfiguration() {
        if (!this.mConfiguration.isInMemoryDb() && !this.mIsReadOnlyConnection) {
            if ((this.mConfiguration.openFlags & 0x20000000) != 0) {
                this.setJournalMode("WAL");
                this.setSyncMode(SQLiteGlobal.getWALSyncMode());
            } else {
                this.setJournalMode(SQLiteGlobal.getDefaultJournalMode());
                this.setSyncMode(SQLiteGlobal.getDefaultSyncMode());
            }
        }
    }

    private final void $$robo$$android_database_sqlite_SQLiteConnection$setSyncMode(String newValue) {
        String value = this.executeForString("PRAGMA synchronous", null, null);
        if (!SQLiteConnection.canonicalizeSyncMode(value).equalsIgnoreCase(SQLiteConnection.canonicalizeSyncMode(newValue))) {
            this.execute("PRAGMA synchronous=" + newValue, null, null);
        }
    }

    private static final String $$robo$$android_database_sqlite_SQLiteConnection$canonicalizeSyncMode(String value) {
        if (value.equals("0")) {
            return "OFF";
        }
        if (value.equals("1")) {
            return "NORMAL";
        }
        if (value.equals("2")) {
            return "FULL";
        }
        return value;
    }

    private final void $$robo$$android_database_sqlite_SQLiteConnection$setJournalMode(String newValue) {
        String value = this.executeForString("PRAGMA journal_mode", null, null);
        if (!value.equalsIgnoreCase(newValue)) {
            try {
                String result = this.executeForString("PRAGMA journal_mode=" + newValue, null, null);
                if (result.equalsIgnoreCase(newValue)) {
                    return;
                }
            }
            catch (SQLiteDatabaseLockedException sQLiteDatabaseLockedException) {
                // empty catch block
            }
            Log.w("SQLiteConnection", "Could not change the database journal mode of '" + this.mConfiguration.label + "' from '" + value + "' to '" + newValue + "' because the database is locked.  This usually means that " + "there are other open connections to the database which prevents " + "the database from enabling or disabling write-ahead logging mode.  " + "Proceeding without changing the journal mode.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_database_sqlite_SQLiteConnection$setLocaleFromConfiguration() {
        if ((this.mConfiguration.openFlags & 0x10) != 0) {
            return;
        }
        String newLocale = this.mConfiguration.locale.toString();
        SQLiteConnection.nativeRegisterLocalizedCollators(this.mConnectionPtr, newLocale);
        if (this.mIsReadOnlyConnection) {
            return;
        }
        try {
            this.execute("CREATE TABLE IF NOT EXISTS android_metadata (locale TEXT)", null, null);
            String oldLocale = this.executeForString("SELECT locale FROM android_metadata UNION SELECT NULL ORDER BY locale DESC LIMIT 1", null, null);
            if (oldLocale != null && oldLocale.equals(newLocale)) {
                return;
            }
            this.execute("BEGIN", null, null);
            boolean success = false;
            try {
                this.execute("DELETE FROM android_metadata", null, null);
                this.execute("INSERT INTO android_metadata (locale) VALUES(?)", new Object[]{newLocale}, null);
                this.execute("REINDEX LOCALIZED", null, null);
                success = true;
                this.execute(success ? "COMMIT" : "ROLLBACK", null, null);
            }
            catch (Throwable throwable) {
                this.execute(success ? "COMMIT" : "ROLLBACK", null, null);
                throw throwable;
            }
        }
        catch (RuntimeException ex) {
            throw new SQLiteException("Failed to change locale for db '" + this.mConfiguration.label + "' to '" + newLocale + "'.", ex);
        }
    }

    private final void $$robo$$android_database_sqlite_SQLiteConnection$reconfigure(SQLiteDatabaseConfiguration configuration) {
        this.mOnlyAllowReadOnlyOperations = false;
        int functionCount = configuration.customFunctions.size();
        for (int i = 0; i < functionCount; ++i) {
            SQLiteCustomFunction function = configuration.customFunctions.get(i);
            if (this.mConfiguration.customFunctions.contains(function)) continue;
            SQLiteConnection.nativeRegisterCustomFunction(this.mConnectionPtr, function);
        }
        boolean foreignKeyModeChanged = configuration.foreignKeyConstraintsEnabled != this.mConfiguration.foreignKeyConstraintsEnabled;
        boolean walModeChanged = ((configuration.openFlags ^ this.mConfiguration.openFlags) & 0x20000000) != 0;
        boolean localeChanged = !configuration.locale.equals(this.mConfiguration.locale);
        this.mConfiguration.updateParametersFrom(configuration);
        this.mPreparedStatementCache.resize(configuration.maxSqlCacheSize);
        if (foreignKeyModeChanged) {
            this.setForeignKeyModeFromConfiguration();
        }
        if (walModeChanged) {
            this.setWalModeFromConfiguration();
        }
        if (localeChanged) {
            this.setLocaleFromConfiguration();
        }
    }

    private final void $$robo$$android_database_sqlite_SQLiteConnection$setOnlyAllowReadOnlyOperations(boolean readOnly) {
        this.mOnlyAllowReadOnlyOperations = readOnly;
    }

    private final boolean $$robo$$android_database_sqlite_SQLiteConnection$isPreparedStatementInCache(String sql) {
        return this.mPreparedStatementCache.get(sql) != null;
    }

    private final int $$robo$$android_database_sqlite_SQLiteConnection$getConnectionId() {
        return this.mConnectionId;
    }

    private final boolean $$robo$$android_database_sqlite_SQLiteConnection$isPrimaryConnection() {
        return this.mIsPrimaryConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_database_sqlite_SQLiteConnection$prepare(String sql, SQLiteStatementInfo outStatementInfo) {
        if (sql == null) {
            throw new IllegalArgumentException("sql must not be null.");
        }
        int cookie = this.mRecentOperations.beginOperation("prepare", sql, null);
        try {
            PreparedStatement statement = this.acquirePreparedStatement(sql);
            try {
                if (outStatementInfo != null) {
                    outStatementInfo.numParameters = statement.mNumParameters;
                    outStatementInfo.readOnly = statement.mReadOnly;
                    int columnCount = SQLiteConnection.nativeGetColumnCount(this.mConnectionPtr, statement.mStatementPtr);
                    if (columnCount == 0) {
                        outStatementInfo.columnNames = EMPTY_STRING_ARRAY;
                    } else {
                        outStatementInfo.columnNames = new String[columnCount];
                        for (int i = 0; i < columnCount; ++i) {
                            outStatementInfo.columnNames[i] = SQLiteConnection.nativeGetColumnName(this.mConnectionPtr, statement.mStatementPtr, i);
                        }
                    }
                }
            }
            finally {
                this.releasePreparedStatement(statement);
            }
        }
        catch (RuntimeException ex) {
            this.mRecentOperations.failOperation(cookie, ex);
            throw ex;
        }
        finally {
            this.mRecentOperations.endOperation(cookie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_database_sqlite_SQLiteConnection$execute(String sql, Object[] bindArgs, CancellationSignal cancellationSignal) {
        if (sql == null) {
            throw new IllegalArgumentException("sql must not be null.");
        }
        int cookie = this.mRecentOperations.beginOperation("execute", sql, bindArgs);
        try {
            PreparedStatement statement = this.acquirePreparedStatement(sql);
            try {
                this.throwIfStatementForbidden(statement);
                this.bindArguments(statement, bindArgs);
                this.applyBlockGuardPolicy(statement);
                this.attachCancellationSignal(cancellationSignal);
                try {
                    SQLiteConnection.nativeExecute(this.mConnectionPtr, statement.mStatementPtr);
                }
                finally {
                    this.detachCancellationSignal(cancellationSignal);
                }
            }
            finally {
                this.releasePreparedStatement(statement);
            }
        }
        catch (RuntimeException ex) {
            this.mRecentOperations.failOperation(cookie, ex);
            throw ex;
        }
        finally {
            this.mRecentOperations.endOperation(cookie);
        }
    }

    /*
     * Exception decompiling
     */
    private final long $$robo$$android_database_sqlite_SQLiteConnection$executeForLong(String sql, Object[] bindArgs, CancellationSignal cancellationSignal) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private final String $$robo$$android_database_sqlite_SQLiteConnection$executeForString(String sql, Object[] bindArgs, CancellationSignal cancellationSignal) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private final ParcelFileDescriptor $$robo$$android_database_sqlite_SQLiteConnection$executeForBlobFileDescriptor(String sql, Object[] bindArgs, CancellationSignal cancellationSignal) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private final int $$robo$$android_database_sqlite_SQLiteConnection$executeForChangedRowCount(String sql, Object[] bindArgs, CancellationSignal cancellationSignal) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private final long $$robo$$android_database_sqlite_SQLiteConnection$executeForLastInsertedRowId(String sql, Object[] bindArgs, CancellationSignal cancellationSignal) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private final int $$robo$$android_database_sqlite_SQLiteConnection$executeForCursorWindow(String sql, Object[] bindArgs, CursorWindow window, int startPos, int requiredPos, boolean countAllRows, CancellationSignal cancellationSignal) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final PreparedStatement $$robo$$android_database_sqlite_SQLiteConnection$acquirePreparedStatement(String sql) {
        PreparedStatement statement = (PreparedStatement)this.mPreparedStatementCache.get(sql);
        boolean skipCache = false;
        if (statement != null) {
            if (!statement.mInUse) {
                return statement;
            }
            skipCache = true;
        }
        long statementPtr = SQLiteConnection.nativePrepareStatement(this.mConnectionPtr, sql);
        try {
            int numParameters = SQLiteConnection.nativeGetParameterCount(this.mConnectionPtr, statementPtr);
            int type = DatabaseUtils.getSqlStatementType(sql);
            boolean readOnly = SQLiteConnection.nativeIsReadOnly(this.mConnectionPtr, statementPtr);
            statement = this.obtainPreparedStatement(sql, statementPtr, numParameters, type, readOnly);
            if (!skipCache && SQLiteConnection.isCacheable(type)) {
                this.mPreparedStatementCache.put(sql, statement);
                statement.mInCache = true;
            }
        }
        catch (RuntimeException ex) {
            if (statement == null || !statement.mInCache) {
                SQLiteConnection.nativeFinalizeStatement(this.mConnectionPtr, statementPtr);
            }
            throw ex;
        }
        statement.mInUse = true;
        return statement;
    }

    private final void $$robo$$android_database_sqlite_SQLiteConnection$releasePreparedStatement(PreparedStatement statement) {
        statement.mInUse = false;
        if (statement.mInCache) {
            try {
                SQLiteConnection.nativeResetStatementAndClearBindings(this.mConnectionPtr, statement.mStatementPtr);
            }
            catch (SQLiteException ex) {
                this.mPreparedStatementCache.remove(statement.mSql);
            }
        } else {
            this.finalizePreparedStatement(statement);
        }
    }

    private final void $$robo$$android_database_sqlite_SQLiteConnection$finalizePreparedStatement(PreparedStatement statement) {
        SQLiteConnection.nativeFinalizeStatement(this.mConnectionPtr, statement.mStatementPtr);
        this.recyclePreparedStatement(statement);
    }

    private final void $$robo$$android_database_sqlite_SQLiteConnection$attachCancellationSignal(CancellationSignal cancellationSignal) {
        if (cancellationSignal != null) {
            cancellationSignal.throwIfCanceled();
            ++this.mCancellationSignalAttachCount;
            if (this.mCancellationSignalAttachCount == 1) {
                SQLiteConnection.nativeResetCancel(this.mConnectionPtr, true);
                cancellationSignal.setOnCancelListener(this);
            }
        }
    }

    private final void $$robo$$android_database_sqlite_SQLiteConnection$detachCancellationSignal(CancellationSignal cancellationSignal) {
        if (cancellationSignal != null) {
            if (!$assertionsDisabled && this.mCancellationSignalAttachCount <= 0) {
                throw new AssertionError();
            }
            --this.mCancellationSignalAttachCount;
            if (this.mCancellationSignalAttachCount == 0) {
                cancellationSignal.setOnCancelListener(null);
                SQLiteConnection.nativeResetCancel(this.mConnectionPtr, false);
            }
        }
    }

    private final void $$robo$$android_database_sqlite_SQLiteConnection$onCancel() {
        SQLiteConnection.nativeCancel(this.mConnectionPtr);
    }

    private final void $$robo$$android_database_sqlite_SQLiteConnection$bindArguments(PreparedStatement statement, Object[] bindArgs) {
        int count;
        int n = count = bindArgs != null ? bindArgs.length : 0;
        if (count != statement.mNumParameters) {
            throw new SQLiteBindOrColumnIndexOutOfRangeException("Expected " + statement.mNumParameters + " bind arguments but " + count + " were provided.");
        }
        if (count == 0) {
            return;
        }
        long statementPtr = statement.mStatementPtr;
        block6: for (int i = 0; i < count; ++i) {
            Object arg = bindArgs[i];
            switch (DatabaseUtils.getTypeOfObject(arg)) {
                case 0: {
                    SQLiteConnection.nativeBindNull(this.mConnectionPtr, statementPtr, i + 1);
                    continue block6;
                }
                case 1: {
                    SQLiteConnection.nativeBindLong(this.mConnectionPtr, statementPtr, i + 1, ((Number)arg).longValue());
                    continue block6;
                }
                case 2: {
                    SQLiteConnection.nativeBindDouble(this.mConnectionPtr, statementPtr, i + 1, ((Number)arg).doubleValue());
                    continue block6;
                }
                case 4: {
                    SQLiteConnection.nativeBindBlob(this.mConnectionPtr, statementPtr, i + 1, (byte[])arg);
                    continue block6;
                }
                default: {
                    if (arg instanceof Boolean) {
                        SQLiteConnection.nativeBindLong(this.mConnectionPtr, statementPtr, i + 1, (Boolean)arg != false ? 1L : 0L);
                        continue block6;
                    }
                    SQLiteConnection.nativeBindString(this.mConnectionPtr, statementPtr, i + 1, arg.toString());
                }
            }
        }
    }

    private final void $$robo$$android_database_sqlite_SQLiteConnection$throwIfStatementForbidden(PreparedStatement statement) {
        if (this.mOnlyAllowReadOnlyOperations && !statement.mReadOnly) {
            throw new SQLiteException("Cannot execute this statement because it might modify the database but the connection is read-only.");
        }
    }

    private static final boolean $$robo$$android_database_sqlite_SQLiteConnection$isCacheable(int statementType) {
        return statementType == 2 || statementType == 1;
    }

    private final void $$robo$$android_database_sqlite_SQLiteConnection$applyBlockGuardPolicy(PreparedStatement statement) {
        if (!this.mConfiguration.isInMemoryDb()) {
            if (statement.mReadOnly) {
                BlockGuard.getThreadPolicy().onReadFromDisk();
            } else {
                BlockGuard.getThreadPolicy().onWriteToDisk();
            }
        }
    }

    private final void $$robo$$android_database_sqlite_SQLiteConnection$dump(Printer printer, boolean verbose) {
        this.dumpUnsafe(printer, verbose);
    }

    private final void $$robo$$android_database_sqlite_SQLiteConnection$dumpUnsafe(Printer printer, boolean verbose) {
        printer.println("Connection #" + this.mConnectionId + ":");
        if (verbose) {
            printer.println("  connectionPtr: 0x" + Long.toHexString(this.mConnectionPtr));
        }
        printer.println("  isPrimaryConnection: " + this.mIsPrimaryConnection);
        printer.println("  onlyAllowReadOnlyOperations: " + this.mOnlyAllowReadOnlyOperations);
        this.mRecentOperations.dump(printer, verbose);
        if (verbose) {
            this.mPreparedStatementCache.dump(printer);
        }
    }

    private final String $$robo$$android_database_sqlite_SQLiteConnection$describeCurrentOperationUnsafe() {
        return this.mRecentOperations.describeCurrentOperation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_database_sqlite_SQLiteConnection$collectDbStats(ArrayList<SQLiteDebug.DbStats> dbStatsList) {
        int lookaside = SQLiteConnection.nativeGetDbLookaside(this.mConnectionPtr);
        long pageCount = 0L;
        long pageSize = 0L;
        try {
            pageCount = this.executeForLong("PRAGMA page_count;", null, null);
            pageSize = this.executeForLong("PRAGMA page_size;", null, null);
        }
        catch (SQLiteException sQLiteException) {
            // empty catch block
        }
        dbStatsList.add(this.getMainDbStatsUnsafe(lookaside, pageCount, pageSize));
        try (CursorWindow window = new CursorWindow("collectDbStats");){
            this.executeForCursorWindow("PRAGMA database_list;", null, window, 0, 0, false, null);
            for (int i = 1; i < window.getNumRows(); ++i) {
                String name = window.getString(i, 1);
                String path = window.getString(i, 2);
                pageCount = 0L;
                pageSize = 0L;
                try {
                    pageCount = this.executeForLong("PRAGMA " + name + ".page_count;", null, null);
                    pageSize = this.executeForLong("PRAGMA " + name + ".page_size;", null, null);
                }
                catch (SQLiteException sQLiteException) {
                    // empty catch block
                }
                String label = "  (attached) " + name;
                if (!path.isEmpty()) {
                    label = label + ": " + path;
                }
                dbStatsList.add(new SQLiteDebug.DbStats(label, pageCount, pageSize, 0, 0, 0, 0));
            }
        }
    }

    private final void $$robo$$android_database_sqlite_SQLiteConnection$collectDbStatsUnsafe(ArrayList<SQLiteDebug.DbStats> dbStatsList) {
        dbStatsList.add(this.getMainDbStatsUnsafe(0, 0L, 0L));
    }

    private final SQLiteDebug.DbStats $$robo$$android_database_sqlite_SQLiteConnection$getMainDbStatsUnsafe(int lookaside, long pageCount, long pageSize) {
        String label = this.mConfiguration.path;
        if (!this.mIsPrimaryConnection) {
            label = label + " (" + this.mConnectionId + ")";
        }
        return new SQLiteDebug.DbStats(label, pageCount, pageSize, lookaside, this.mPreparedStatementCache.hitCount(), this.mPreparedStatementCache.missCount(), this.mPreparedStatementCache.size());
    }

    private final String $$robo$$android_database_sqlite_SQLiteConnection$toString() {
        return "SQLiteConnection: " + this.mConfiguration.path + " (" + this.mConnectionId + ")";
    }

    private final PreparedStatement $$robo$$android_database_sqlite_SQLiteConnection$obtainPreparedStatement(String sql, long statementPtr, int numParameters, int type, boolean readOnly) {
        PreparedStatement statement = this.mPreparedStatementPool;
        if (statement != null) {
            this.mPreparedStatementPool = statement.mPoolNext;
            statement.mPoolNext = null;
            statement.mInCache = false;
        } else {
            statement = new PreparedStatement();
        }
        statement.mSql = sql;
        statement.mStatementPtr = statementPtr;
        statement.mNumParameters = numParameters;
        statement.mType = type;
        statement.mReadOnly = readOnly;
        return statement;
    }

    private final void $$robo$$android_database_sqlite_SQLiteConnection$recyclePreparedStatement(PreparedStatement statement) {
        statement.mSql = null;
        statement.mPoolNext = this.mPreparedStatementPool;
        this.mPreparedStatementPool = statement;
    }

    private static final String $$robo$$android_database_sqlite_SQLiteConnection$trimSqlForDisplay(String sql) {
        return sql.replaceAll("[\\s]*\\n+[\\s]*", " ");
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !SQLiteConnection.class.desiredAssertionStatus();
        EMPTY_STRING_ARRAY = new String[0];
        EMPTY_BYTE_ARRAY = new byte[0];
    }

    private static final native /* synthetic */ long $$robo$$nativeOpen$nativeBinding(String var0, int var1, String var2, boolean var3, boolean var4, int var5, int var6);

    private static long nativeOpen(String string2, int n, String string3, boolean bl, boolean bl2, int n2, int n3) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeOpen", $$robo$$android_database_sqlite_SQLiteConnection$nativeOpen(java.lang.String int java.lang.String boolean boolean int int ), 1, (String)string2, (int)n, (String)string3, (boolean)bl, (boolean)bl2, (int)n2, (int)n3);
    }

    private static final native /* synthetic */ void $$robo$$nativeClose$nativeBinding(long var0);

    private static void nativeClose(long l) {
        InvokeDynamicSupport.bootstrapStatic("nativeClose", $$robo$$android_database_sqlite_SQLiteConnection$nativeClose(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nativeRegisterCustomFunction$nativeBinding(long var0, SQLiteCustomFunction var2);

    private static void nativeRegisterCustomFunction(long l, SQLiteCustomFunction sQLiteCustomFunction) {
        InvokeDynamicSupport.bootstrapStatic("nativeRegisterCustomFunction", $$robo$$android_database_sqlite_SQLiteConnection$nativeRegisterCustomFunction(long android.database.sqlite.SQLiteCustomFunction ), 1, (long)l, (SQLiteCustomFunction)sQLiteCustomFunction);
    }

    private static final native /* synthetic */ void $$robo$$nativeRegisterLocalizedCollators$nativeBinding(long var0, String var2);

    private static void nativeRegisterLocalizedCollators(long l, String string2) {
        InvokeDynamicSupport.bootstrapStatic("nativeRegisterLocalizedCollators", $$robo$$android_database_sqlite_SQLiteConnection$nativeRegisterLocalizedCollators(long java.lang.String ), 1, (long)l, (String)string2);
    }

    private static final native /* synthetic */ long $$robo$$nativePrepareStatement$nativeBinding(long var0, String var2);

    private static long nativePrepareStatement(long l, String string2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativePrepareStatement", $$robo$$android_database_sqlite_SQLiteConnection$nativePrepareStatement(long java.lang.String ), 1, (long)l, (String)string2);
    }

    private static final native /* synthetic */ void $$robo$$nativeFinalizeStatement$nativeBinding(long var0, long var2);

    private static void nativeFinalizeStatement(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nativeFinalizeStatement", $$robo$$android_database_sqlite_SQLiteConnection$nativeFinalizeStatement(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ int $$robo$$nativeGetParameterCount$nativeBinding(long var0, long var2);

    private static int nativeGetParameterCount(long l, long l2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeGetParameterCount", $$robo$$android_database_sqlite_SQLiteConnection$nativeGetParameterCount(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ boolean $$robo$$nativeIsReadOnly$nativeBinding(long var0, long var2);

    private static boolean nativeIsReadOnly(long l, long l2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeIsReadOnly", $$robo$$android_database_sqlite_SQLiteConnection$nativeIsReadOnly(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ int $$robo$$nativeGetColumnCount$nativeBinding(long var0, long var2);

    private static int nativeGetColumnCount(long l, long l2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeGetColumnCount", $$robo$$android_database_sqlite_SQLiteConnection$nativeGetColumnCount(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ String $$robo$$nativeGetColumnName$nativeBinding(long var0, long var2, int var4);

    private static String nativeGetColumnName(long l, long l2, int n) {
        return InvokeDynamicSupport.bootstrapStatic("nativeGetColumnName", $$robo$$android_database_sqlite_SQLiteConnection$nativeGetColumnName(long long int ), 1, (long)l, (long)l2, (int)n);
    }

    private static final native /* synthetic */ void $$robo$$nativeBindNull$nativeBinding(long var0, long var2, int var4);

    private static void nativeBindNull(long l, long l2, int n) {
        InvokeDynamicSupport.bootstrapStatic("nativeBindNull", $$robo$$android_database_sqlite_SQLiteConnection$nativeBindNull(long long int ), 1, (long)l, (long)l2, (int)n);
    }

    private static final native /* synthetic */ void $$robo$$nativeBindLong$nativeBinding(long var0, long var2, int var4, long var5);

    private static void nativeBindLong(long l, long l2, int n, long l3) {
        InvokeDynamicSupport.bootstrapStatic("nativeBindLong", $$robo$$android_database_sqlite_SQLiteConnection$nativeBindLong(long long int long ), 1, (long)l, (long)l2, (int)n, (long)l3);
    }

    private static final native /* synthetic */ void $$robo$$nativeBindDouble$nativeBinding(long var0, long var2, int var4, double var5);

    private static void nativeBindDouble(long l, long l2, int n, double d) {
        InvokeDynamicSupport.bootstrapStatic("nativeBindDouble", $$robo$$android_database_sqlite_SQLiteConnection$nativeBindDouble(long long int double ), 1, (long)l, (long)l2, (int)n, (double)d);
    }

    private static final native /* synthetic */ void $$robo$$nativeBindString$nativeBinding(long var0, long var2, int var4, String var5);

    private static void nativeBindString(long l, long l2, int n, String string2) {
        InvokeDynamicSupport.bootstrapStatic("nativeBindString", $$robo$$android_database_sqlite_SQLiteConnection$nativeBindString(long long int java.lang.String ), 1, (long)l, (long)l2, (int)n, (String)string2);
    }

    private static final native /* synthetic */ void $$robo$$nativeBindBlob$nativeBinding(long var0, long var2, int var4, byte[] var5);

    private static void nativeBindBlob(long l, long l2, int n, byte[] byArray) {
        InvokeDynamicSupport.bootstrapStatic("nativeBindBlob", $$robo$$android_database_sqlite_SQLiteConnection$nativeBindBlob(long long int byte[] ), 1, (long)l, (long)l2, (int)n, (byte[])byArray);
    }

    private static final native /* synthetic */ void $$robo$$nativeResetStatementAndClearBindings$nativeBinding(long var0, long var2);

    private static void nativeResetStatementAndClearBindings(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nativeResetStatementAndClearBindings", $$robo$$android_database_sqlite_SQLiteConnection$nativeResetStatementAndClearBindings(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ void $$robo$$nativeExecute$nativeBinding(long var0, long var2);

    private static void nativeExecute(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nativeExecute", $$robo$$android_database_sqlite_SQLiteConnection$nativeExecute(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ long $$robo$$nativeExecuteForLong$nativeBinding(long var0, long var2);

    private static long nativeExecuteForLong(long l, long l2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeExecuteForLong", $$robo$$android_database_sqlite_SQLiteConnection$nativeExecuteForLong(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ String $$robo$$nativeExecuteForString$nativeBinding(long var0, long var2);

    private static String nativeExecuteForString(long l, long l2) {
        return InvokeDynamicSupport.bootstrapStatic("nativeExecuteForString", $$robo$$android_database_sqlite_SQLiteConnection$nativeExecuteForString(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ int $$robo$$nativeExecuteForBlobFileDescriptor$nativeBinding(long var0, long var2);

    private static int nativeExecuteForBlobFileDescriptor(long l, long l2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeExecuteForBlobFileDescriptor", $$robo$$android_database_sqlite_SQLiteConnection$nativeExecuteForBlobFileDescriptor(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ int $$robo$$nativeExecuteForChangedRowCount$nativeBinding(long var0, long var2);

    private static int nativeExecuteForChangedRowCount(long l, long l2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeExecuteForChangedRowCount", $$robo$$android_database_sqlite_SQLiteConnection$nativeExecuteForChangedRowCount(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ long $$robo$$nativeExecuteForLastInsertedRowId$nativeBinding(long var0, long var2);

    private static long nativeExecuteForLastInsertedRowId(long l, long l2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeExecuteForLastInsertedRowId", $$robo$$android_database_sqlite_SQLiteConnection$nativeExecuteForLastInsertedRowId(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ long $$robo$$nativeExecuteForCursorWindow$nativeBinding(long var0, long var2, long var4, int var6, int var7, boolean var8);

    private static long nativeExecuteForCursorWindow(long l, long l2, long l3, int n, int n2, boolean bl) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeExecuteForCursorWindow", $$robo$$android_database_sqlite_SQLiteConnection$nativeExecuteForCursorWindow(long long long int int boolean ), 1, (long)l, (long)l2, (long)l3, (int)n, (int)n2, (boolean)bl);
    }

    private static final native /* synthetic */ int $$robo$$nativeGetDbLookaside$nativeBinding(long var0);

    private static int nativeGetDbLookaside(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeGetDbLookaside", $$robo$$android_database_sqlite_SQLiteConnection$nativeGetDbLookaside(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nativeCancel$nativeBinding(long var0);

    private static void nativeCancel(long l) {
        InvokeDynamicSupport.bootstrapStatic("nativeCancel", $$robo$$android_database_sqlite_SQLiteConnection$nativeCancel(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nativeResetCancel$nativeBinding(long var0, boolean var2);

    private static void nativeResetCancel(long l, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("nativeResetCancel", $$robo$$android_database_sqlite_SQLiteConnection$nativeResetCancel(long boolean ), 1, (long)l, (boolean)bl);
    }

    private void __constructor__(SQLiteConnectionPool sQLiteConnectionPool, SQLiteDatabaseConfiguration sQLiteDatabaseConfiguration, int n, boolean bl) {
        this.$$robo$$android_database_sqlite_SQLiteConnection$__constructor__(sQLiteConnectionPool, sQLiteDatabaseConfiguration, n, bl);
    }

    private SQLiteConnection(SQLiteConnectionPool sQLiteConnectionPool, SQLiteDatabaseConfiguration sQLiteDatabaseConfiguration, int n, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_database_sqlite_SQLiteConnection$__constructor__(android.database.sqlite.SQLiteConnectionPool android.database.sqlite.SQLiteDatabaseConfiguration int boolean ), 0, this, sQLiteConnectionPool, sQLiteDatabaseConfiguration, n, bl);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_database_sqlite_SQLiteConnection$finalize(), 0, this);
    }

    static SQLiteConnection open(SQLiteConnectionPool sQLiteConnectionPool, SQLiteDatabaseConfiguration sQLiteDatabaseConfiguration, int n, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("open", $$robo$$android_database_sqlite_SQLiteConnection$open(android.database.sqlite.SQLiteConnectionPool android.database.sqlite.SQLiteDatabaseConfiguration int boolean ), 0, (SQLiteConnectionPool)sQLiteConnectionPool, (SQLiteDatabaseConfiguration)sQLiteDatabaseConfiguration, (int)n, (boolean)bl);
    }

    void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_database_sqlite_SQLiteConnection$close(), 0, this);
    }

    private void open() {
        InvokeDynamicSupport.bootstrap("open", $$robo$$android_database_sqlite_SQLiteConnection$open(), 0, this);
    }

    private void dispose(boolean bl) {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$android_database_sqlite_SQLiteConnection$dispose(boolean ), 0, this, bl);
    }

    private void setPageSize() {
        InvokeDynamicSupport.bootstrap("setPageSize", $$robo$$android_database_sqlite_SQLiteConnection$setPageSize(), 0, this);
    }

    private void setAutoCheckpointInterval() {
        InvokeDynamicSupport.bootstrap("setAutoCheckpointInterval", $$robo$$android_database_sqlite_SQLiteConnection$setAutoCheckpointInterval(), 0, this);
    }

    private void setJournalSizeLimit() {
        InvokeDynamicSupport.bootstrap("setJournalSizeLimit", $$robo$$android_database_sqlite_SQLiteConnection$setJournalSizeLimit(), 0, this);
    }

    private void setForeignKeyModeFromConfiguration() {
        InvokeDynamicSupport.bootstrap("setForeignKeyModeFromConfiguration", $$robo$$android_database_sqlite_SQLiteConnection$setForeignKeyModeFromConfiguration(), 0, this);
    }

    private void setWalModeFromConfiguration() {
        InvokeDynamicSupport.bootstrap("setWalModeFromConfiguration", $$robo$$android_database_sqlite_SQLiteConnection$setWalModeFromConfiguration(), 0, this);
    }

    private void setSyncMode(String string2) {
        InvokeDynamicSupport.bootstrap("setSyncMode", $$robo$$android_database_sqlite_SQLiteConnection$setSyncMode(java.lang.String ), 0, this, string2);
    }

    private static String canonicalizeSyncMode(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("canonicalizeSyncMode", $$robo$$android_database_sqlite_SQLiteConnection$canonicalizeSyncMode(java.lang.String ), 0, (String)string2);
    }

    private void setJournalMode(String string2) {
        InvokeDynamicSupport.bootstrap("setJournalMode", $$robo$$android_database_sqlite_SQLiteConnection$setJournalMode(java.lang.String ), 0, this, string2);
    }

    private void setLocaleFromConfiguration() {
        InvokeDynamicSupport.bootstrap("setLocaleFromConfiguration", $$robo$$android_database_sqlite_SQLiteConnection$setLocaleFromConfiguration(), 0, this);
    }

    void reconfigure(SQLiteDatabaseConfiguration sQLiteDatabaseConfiguration) {
        InvokeDynamicSupport.bootstrap("reconfigure", $$robo$$android_database_sqlite_SQLiteConnection$reconfigure(android.database.sqlite.SQLiteDatabaseConfiguration ), 0, this, sQLiteDatabaseConfiguration);
    }

    void setOnlyAllowReadOnlyOperations(boolean bl) {
        InvokeDynamicSupport.bootstrap("setOnlyAllowReadOnlyOperations", $$robo$$android_database_sqlite_SQLiteConnection$setOnlyAllowReadOnlyOperations(boolean ), 0, this, bl);
    }

    boolean isPreparedStatementInCache(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isPreparedStatementInCache", $$robo$$android_database_sqlite_SQLiteConnection$isPreparedStatementInCache(java.lang.String ), 0, this, string2);
    }

    public int getConnectionId() {
        return (int)InvokeDynamicSupport.bootstrap("getConnectionId", $$robo$$android_database_sqlite_SQLiteConnection$getConnectionId(), 0, this);
    }

    public boolean isPrimaryConnection() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPrimaryConnection", $$robo$$android_database_sqlite_SQLiteConnection$isPrimaryConnection(), 0, this);
    }

    public void prepare(String string2, SQLiteStatementInfo sQLiteStatementInfo) {
        InvokeDynamicSupport.bootstrap("prepare", $$robo$$android_database_sqlite_SQLiteConnection$prepare(java.lang.String android.database.sqlite.SQLiteStatementInfo ), 0, this, string2, sQLiteStatementInfo);
    }

    public void execute(String string2, Object[] objectArray, CancellationSignal cancellationSignal) {
        InvokeDynamicSupport.bootstrap("execute", $$robo$$android_database_sqlite_SQLiteConnection$execute(java.lang.String java.lang.Object[] android.os.CancellationSignal ), 0, this, string2, objectArray, cancellationSignal);
    }

    public long executeForLong(String string2, Object[] objectArray, CancellationSignal cancellationSignal) {
        return (long)InvokeDynamicSupport.bootstrap("executeForLong", $$robo$$android_database_sqlite_SQLiteConnection$executeForLong(java.lang.String java.lang.Object[] android.os.CancellationSignal ), 0, this, string2, objectArray, cancellationSignal);
    }

    public String executeForString(String string2, Object[] objectArray, CancellationSignal cancellationSignal) {
        return InvokeDynamicSupport.bootstrap("executeForString", $$robo$$android_database_sqlite_SQLiteConnection$executeForString(java.lang.String java.lang.Object[] android.os.CancellationSignal ), 0, this, string2, objectArray, cancellationSignal);
    }

    public ParcelFileDescriptor executeForBlobFileDescriptor(String string2, Object[] objectArray, CancellationSignal cancellationSignal) {
        return InvokeDynamicSupport.bootstrap("executeForBlobFileDescriptor", $$robo$$android_database_sqlite_SQLiteConnection$executeForBlobFileDescriptor(java.lang.String java.lang.Object[] android.os.CancellationSignal ), 0, this, string2, objectArray, cancellationSignal);
    }

    public int executeForChangedRowCount(String string2, Object[] objectArray, CancellationSignal cancellationSignal) {
        return (int)InvokeDynamicSupport.bootstrap("executeForChangedRowCount", $$robo$$android_database_sqlite_SQLiteConnection$executeForChangedRowCount(java.lang.String java.lang.Object[] android.os.CancellationSignal ), 0, this, string2, objectArray, cancellationSignal);
    }

    public long executeForLastInsertedRowId(String string2, Object[] objectArray, CancellationSignal cancellationSignal) {
        return (long)InvokeDynamicSupport.bootstrap("executeForLastInsertedRowId", $$robo$$android_database_sqlite_SQLiteConnection$executeForLastInsertedRowId(java.lang.String java.lang.Object[] android.os.CancellationSignal ), 0, this, string2, objectArray, cancellationSignal);
    }

    public int executeForCursorWindow(String string2, Object[] objectArray, CursorWindow cursorWindow, int n, int n2, boolean bl, CancellationSignal cancellationSignal) {
        return (int)InvokeDynamicSupport.bootstrap("executeForCursorWindow", $$robo$$android_database_sqlite_SQLiteConnection$executeForCursorWindow(java.lang.String java.lang.Object[] android.database.CursorWindow int int boolean android.os.CancellationSignal ), 0, this, string2, objectArray, cursorWindow, n, n2, bl, cancellationSignal);
    }

    private PreparedStatement acquirePreparedStatement(String string2) {
        return InvokeDynamicSupport.bootstrap("acquirePreparedStatement", $$robo$$android_database_sqlite_SQLiteConnection$acquirePreparedStatement(java.lang.String ), 0, this, string2);
    }

    private void releasePreparedStatement(PreparedStatement preparedStatement) {
        InvokeDynamicSupport.bootstrap("releasePreparedStatement", $$robo$$android_database_sqlite_SQLiteConnection$releasePreparedStatement(android.database.sqlite.SQLiteConnection$PreparedStatement ), 0, this, preparedStatement);
    }

    private void finalizePreparedStatement(PreparedStatement preparedStatement) {
        InvokeDynamicSupport.bootstrap("finalizePreparedStatement", $$robo$$android_database_sqlite_SQLiteConnection$finalizePreparedStatement(android.database.sqlite.SQLiteConnection$PreparedStatement ), 0, this, preparedStatement);
    }

    private void attachCancellationSignal(CancellationSignal cancellationSignal) {
        InvokeDynamicSupport.bootstrap("attachCancellationSignal", $$robo$$android_database_sqlite_SQLiteConnection$attachCancellationSignal(android.os.CancellationSignal ), 0, this, cancellationSignal);
    }

    private void detachCancellationSignal(CancellationSignal cancellationSignal) {
        InvokeDynamicSupport.bootstrap("detachCancellationSignal", $$robo$$android_database_sqlite_SQLiteConnection$detachCancellationSignal(android.os.CancellationSignal ), 0, this, cancellationSignal);
    }

    @Override
    public void onCancel() {
        InvokeDynamicSupport.bootstrap("onCancel", $$robo$$android_database_sqlite_SQLiteConnection$onCancel(), 0, this);
    }

    private void bindArguments(PreparedStatement preparedStatement, Object[] objectArray) {
        InvokeDynamicSupport.bootstrap("bindArguments", $$robo$$android_database_sqlite_SQLiteConnection$bindArguments(android.database.sqlite.SQLiteConnection$PreparedStatement java.lang.Object[] ), 0, this, preparedStatement, objectArray);
    }

    private void throwIfStatementForbidden(PreparedStatement preparedStatement) {
        InvokeDynamicSupport.bootstrap("throwIfStatementForbidden", $$robo$$android_database_sqlite_SQLiteConnection$throwIfStatementForbidden(android.database.sqlite.SQLiteConnection$PreparedStatement ), 0, this, preparedStatement);
    }

    private static boolean isCacheable(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isCacheable", $$robo$$android_database_sqlite_SQLiteConnection$isCacheable(int ), 0, (int)n);
    }

    private void applyBlockGuardPolicy(PreparedStatement preparedStatement) {
        InvokeDynamicSupport.bootstrap("applyBlockGuardPolicy", $$robo$$android_database_sqlite_SQLiteConnection$applyBlockGuardPolicy(android.database.sqlite.SQLiteConnection$PreparedStatement ), 0, this, preparedStatement);
    }

    public void dump(Printer printer, boolean bl) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_database_sqlite_SQLiteConnection$dump(android.util.Printer boolean ), 0, this, printer, bl);
    }

    void dumpUnsafe(Printer printer, boolean bl) {
        InvokeDynamicSupport.bootstrap("dumpUnsafe", $$robo$$android_database_sqlite_SQLiteConnection$dumpUnsafe(android.util.Printer boolean ), 0, this, printer, bl);
    }

    String describeCurrentOperationUnsafe() {
        return InvokeDynamicSupport.bootstrap("describeCurrentOperationUnsafe", $$robo$$android_database_sqlite_SQLiteConnection$describeCurrentOperationUnsafe(), 0, this);
    }

    void collectDbStats(ArrayList<SQLiteDebug.DbStats> arrayList) {
        InvokeDynamicSupport.bootstrap("collectDbStats", $$robo$$android_database_sqlite_SQLiteConnection$collectDbStats(java.util.ArrayList<android.database.sqlite.SQLiteDebug$DbStats> ), 0, this, arrayList);
    }

    void collectDbStatsUnsafe(ArrayList<SQLiteDebug.DbStats> arrayList) {
        InvokeDynamicSupport.bootstrap("collectDbStatsUnsafe", $$robo$$android_database_sqlite_SQLiteConnection$collectDbStatsUnsafe(java.util.ArrayList<android.database.sqlite.SQLiteDebug$DbStats> ), 0, this, arrayList);
    }

    private SQLiteDebug.DbStats getMainDbStatsUnsafe(int n, long l, long l2) {
        return InvokeDynamicSupport.bootstrap("getMainDbStatsUnsafe", $$robo$$android_database_sqlite_SQLiteConnection$getMainDbStatsUnsafe(int long long ), 0, this, n, l, l2);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_database_sqlite_SQLiteConnection$toString(), 0, this);
    }

    private PreparedStatement obtainPreparedStatement(String string2, long l, int n, int n2, boolean bl) {
        return InvokeDynamicSupport.bootstrap("obtainPreparedStatement", $$robo$$android_database_sqlite_SQLiteConnection$obtainPreparedStatement(java.lang.String long int int boolean ), 0, this, string2, l, n, n2, bl);
    }

    private void recyclePreparedStatement(PreparedStatement preparedStatement) {
        InvokeDynamicSupport.bootstrap("recyclePreparedStatement", $$robo$$android_database_sqlite_SQLiteConnection$recyclePreparedStatement(android.database.sqlite.SQLiteConnection$PreparedStatement ), 0, this, preparedStatement);
    }

    private static String trimSqlForDisplay(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("trimSqlForDisplay", $$robo$$android_database_sqlite_SQLiteConnection$trimSqlForDisplay(java.lang.String ), 0, (String)string2);
    }

    static {
        RobolectricInternals.classInitializing(SQLiteConnection.class);
    }

    public /* synthetic */ SQLiteConnection() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SQLiteConnection)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class Operation
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int MAX_TRACE_METHOD_NAME_LEN = 256;
        public long mStartWallTime;
        public long mStartTime;
        public long mEndTime;
        public String mKind;
        public String mSql;
        public ArrayList<Object> mBindArgs;
        public boolean mFinished;
        public Exception mException;
        public int mCookie;

        private void $$robo$$android_database_sqlite_SQLiteConnection_Operation$__constructor__() {
        }

        private final void $$robo$$android_database_sqlite_SQLiteConnection_Operation$describe(StringBuilder msg, boolean verbose) {
            msg.append(this.mKind);
            if (this.mFinished) {
                msg.append(" took ").append(this.mEndTime - this.mStartTime).append("ms");
            } else {
                msg.append(" started ").append((long)(InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System") - this.mStartWallTime)).append("ms ago");
            }
            msg.append(" - ").append(this.getStatus());
            if (this.mSql != null) {
                msg.append(", sql=\"").append(SQLiteConnection.trimSqlForDisplay(this.mSql)).append("\"");
            }
            if (verbose && this.mBindArgs != null && this.mBindArgs.size() != 0) {
                msg.append(", bindArgs=[");
                int count = this.mBindArgs.size();
                for (int i = 0; i < count; ++i) {
                    Object arg = this.mBindArgs.get(i);
                    if (i != 0) {
                        msg.append(", ");
                    }
                    if (arg == null) {
                        msg.append("null");
                        continue;
                    }
                    if (arg instanceof byte[]) {
                        msg.append("<byte[]>");
                        continue;
                    }
                    if (arg instanceof String) {
                        msg.append("\"").append((String)arg).append("\"");
                        continue;
                    }
                    msg.append(arg);
                }
                msg.append("]");
            }
            if (this.mException != null) {
                msg.append(", exception=\"").append(this.mException.getMessage()).append("\"");
            }
        }

        private final String $$robo$$android_database_sqlite_SQLiteConnection_Operation$getStatus() {
            if (!this.mFinished) {
                return "running";
            }
            return this.mException != null ? "failed" : "succeeded";
        }

        private final String $$robo$$android_database_sqlite_SQLiteConnection_Operation$getTraceMethodName() {
            String methodName = this.mKind + " " + this.mSql;
            if (methodName.length() > 256) {
                return methodName.substring(0, 256);
            }
            return methodName;
        }

        private final String $$robo$$android_database_sqlite_SQLiteConnection_Operation$getFormattedStartTime() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date(this.mStartWallTime));
        }

        private /* synthetic */ void $$robo$$android_database_sqlite_SQLiteConnection_Operation$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_database_sqlite_SQLiteConnection_Operation$__constructor__();
        }

        private Operation() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_database_sqlite_SQLiteConnection_Operation$__constructor__(), 0, this);
        }

        public void describe(StringBuilder stringBuilder, boolean bl) {
            InvokeDynamicSupport.bootstrap("describe", $$robo$$android_database_sqlite_SQLiteConnection_Operation$describe(java.lang.StringBuilder boolean ), 0, this, stringBuilder, bl);
        }

        private String getStatus() {
            return InvokeDynamicSupport.bootstrap("getStatus", $$robo$$android_database_sqlite_SQLiteConnection_Operation$getStatus(), 0, this);
        }

        private String getTraceMethodName() {
            return InvokeDynamicSupport.bootstrap("getTraceMethodName", $$robo$$android_database_sqlite_SQLiteConnection_Operation$getTraceMethodName(), 0, this);
        }

        private String getFormattedStartTime() {
            return InvokeDynamicSupport.bootstrap("getFormattedStartTime", $$robo$$android_database_sqlite_SQLiteConnection_Operation$getFormattedStartTime(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_database_sqlite_SQLiteConnection_Operation$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Operation)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class OperationLog
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int MAX_RECENT_OPERATIONS = 20;
        private static int COOKIE_GENERATION_SHIFT = 8;
        private static int COOKIE_INDEX_MASK = 255;
        private Operation[] mOperations;
        private int mIndex;
        private int mGeneration;

        private void $$robo$$android_database_sqlite_SQLiteConnection_OperationLog$__constructor__() {
            this.mOperations = new Operation[20];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final int $$robo$$android_database_sqlite_SQLiteConnection_OperationLog$beginOperation(String kind, String sql, Object[] bindArgs) {
            Operation[] operationArray = this.mOperations;
            synchronized (this.mOperations) {
                int index = (this.mIndex + 1) % 20;
                Operation operation = this.mOperations[index];
                if (operation == null) {
                    this.mOperations[index] = operation = new Operation();
                } else {
                    operation.mFinished = false;
                    operation.mException = null;
                    if (operation.mBindArgs != null) {
                        operation.mBindArgs.clear();
                    }
                }
                operation.mStartWallTime = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
                operation.mStartTime = SystemClock.uptimeMillis();
                operation.mKind = kind;
                operation.mSql = sql;
                if (bindArgs != null) {
                    if (operation.mBindArgs == null) {
                        operation.mBindArgs = new ArrayList();
                    } else {
                        operation.mBindArgs.clear();
                    }
                    for (int i = 0; i < bindArgs.length; ++i) {
                        Object arg = bindArgs[i];
                        if (arg != null && arg instanceof byte[]) {
                            operation.mBindArgs.add(EMPTY_BYTE_ARRAY);
                            continue;
                        }
                        operation.mBindArgs.add(arg);
                    }
                }
                operation.mCookie = this.newOperationCookieLocked(index);
                if (Trace.isTagEnabled(0x100000L)) {
                    Trace.asyncTraceBegin(0x100000L, operation.getTraceMethodName(), operation.mCookie);
                }
                this.mIndex = index;
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return operation.mCookie;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_database_sqlite_SQLiteConnection_OperationLog$failOperation(int cookie, Exception ex) {
            Operation[] operationArray = this.mOperations;
            synchronized (this.mOperations) {
                Operation operation = this.getOperationLocked(cookie);
                if (operation != null) {
                    operation.mException = ex;
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_database_sqlite_SQLiteConnection_OperationLog$endOperation(int cookie) {
            Operation[] operationArray = this.mOperations;
            synchronized (this.mOperations) {
                if (this.endOperationDeferLogLocked(cookie)) {
                    this.logOperationLocked(cookie, null);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean $$robo$$android_database_sqlite_SQLiteConnection_OperationLog$endOperationDeferLog(int cookie) {
            Operation[] operationArray = this.mOperations;
            synchronized (this.mOperations) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.endOperationDeferLogLocked(cookie);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_database_sqlite_SQLiteConnection_OperationLog$logOperation(int cookie, String detail) {
            Operation[] operationArray = this.mOperations;
            synchronized (this.mOperations) {
                this.logOperationLocked(cookie, detail);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }

        private final boolean $$robo$$android_database_sqlite_SQLiteConnection_OperationLog$endOperationDeferLogLocked(int cookie) {
            Operation operation = this.getOperationLocked(cookie);
            if (operation != null) {
                if (Trace.isTagEnabled(0x100000L)) {
                    Trace.asyncTraceEnd(0x100000L, operation.getTraceMethodName(), operation.mCookie);
                }
                operation.mEndTime = SystemClock.uptimeMillis();
                operation.mFinished = true;
                return SQLiteDebug.DEBUG_LOG_SLOW_QUERIES && SQLiteDebug.shouldLogSlowQuery(operation.mEndTime - operation.mStartTime);
            }
            return false;
        }

        private final void $$robo$$android_database_sqlite_SQLiteConnection_OperationLog$logOperationLocked(int cookie, String detail) {
            Operation operation = this.getOperationLocked(cookie);
            StringBuilder msg = new StringBuilder();
            operation.describe(msg, false);
            if (detail != null) {
                msg.append(", ").append(detail);
            }
            Log.d("SQLiteConnection", msg.toString());
        }

        private final int $$robo$$android_database_sqlite_SQLiteConnection_OperationLog$newOperationCookieLocked(int index) {
            int generation = this.mGeneration++;
            return generation << 8 | index;
        }

        private final Operation $$robo$$android_database_sqlite_SQLiteConnection_OperationLog$getOperationLocked(int cookie) {
            int index = cookie & 0xFF;
            Operation operation = this.mOperations[index];
            return operation.mCookie == cookie ? operation : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final String $$robo$$android_database_sqlite_SQLiteConnection_OperationLog$describeCurrentOperation() {
            Operation[] operationArray = this.mOperations;
            synchronized (this.mOperations) {
                Operation operation = this.mOperations[this.mIndex];
                if (operation != null && !operation.mFinished) {
                    StringBuilder msg = new StringBuilder();
                    operation.describe(msg, false);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return msg.toString();
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_database_sqlite_SQLiteConnection_OperationLog$dump(Printer printer, boolean verbose) {
            Operation[] operationArray = this.mOperations;
            synchronized (this.mOperations) {
                printer.println("  Most recently executed operations:");
                int index = this.mIndex;
                Operation operation = this.mOperations[index];
                if (operation != null) {
                    int n = 0;
                    do {
                        StringBuilder msg = new StringBuilder();
                        msg.append("    ").append(n).append(": [");
                        msg.append(operation.getFormattedStartTime());
                        msg.append("] ");
                        operation.describe(msg, verbose);
                        printer.println(msg.toString());
                        if (index > 0) {
                            --index;
                            continue;
                        }
                        index = 19;
                    } while ((operation = this.mOperations[index]) != null && ++n < 20);
                } else {
                    printer.println("    <none>");
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }

        private /* synthetic */ void $$robo$$android_database_sqlite_SQLiteConnection_OperationLog$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_database_sqlite_SQLiteConnection_OperationLog$__constructor__();
        }

        private OperationLog() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_database_sqlite_SQLiteConnection_OperationLog$__constructor__(), 0, this);
        }

        public int beginOperation(String string2, String string3, Object[] objectArray) {
            return (int)InvokeDynamicSupport.bootstrap("beginOperation", $$robo$$android_database_sqlite_SQLiteConnection_OperationLog$beginOperation(java.lang.String java.lang.String java.lang.Object[] ), 0, this, string2, string3, objectArray);
        }

        public void failOperation(int n, Exception exception) {
            InvokeDynamicSupport.bootstrap("failOperation", $$robo$$android_database_sqlite_SQLiteConnection_OperationLog$failOperation(int java.lang.Exception ), 0, this, n, exception);
        }

        public void endOperation(int n) {
            InvokeDynamicSupport.bootstrap("endOperation", $$robo$$android_database_sqlite_SQLiteConnection_OperationLog$endOperation(int ), 0, this, n);
        }

        public boolean endOperationDeferLog(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("endOperationDeferLog", $$robo$$android_database_sqlite_SQLiteConnection_OperationLog$endOperationDeferLog(int ), 0, this, n);
        }

        public void logOperation(int n, String string2) {
            InvokeDynamicSupport.bootstrap("logOperation", $$robo$$android_database_sqlite_SQLiteConnection_OperationLog$logOperation(int java.lang.String ), 0, this, n, string2);
        }

        private boolean endOperationDeferLogLocked(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("endOperationDeferLogLocked", $$robo$$android_database_sqlite_SQLiteConnection_OperationLog$endOperationDeferLogLocked(int ), 0, this, n);
        }

        private void logOperationLocked(int n, String string2) {
            InvokeDynamicSupport.bootstrap("logOperationLocked", $$robo$$android_database_sqlite_SQLiteConnection_OperationLog$logOperationLocked(int java.lang.String ), 0, this, n, string2);
        }

        private int newOperationCookieLocked(int n) {
            return (int)InvokeDynamicSupport.bootstrap("newOperationCookieLocked", $$robo$$android_database_sqlite_SQLiteConnection_OperationLog$newOperationCookieLocked(int ), 0, this, n);
        }

        private Operation getOperationLocked(int n) {
            return InvokeDynamicSupport.bootstrap("getOperationLocked", $$robo$$android_database_sqlite_SQLiteConnection_OperationLog$getOperationLocked(int ), 0, this, n);
        }

        public String describeCurrentOperation() {
            return InvokeDynamicSupport.bootstrap("describeCurrentOperation", $$robo$$android_database_sqlite_SQLiteConnection_OperationLog$describeCurrentOperation(), 0, this);
        }

        public void dump(Printer printer, boolean bl) {
            InvokeDynamicSupport.bootstrap("dump", $$robo$$android_database_sqlite_SQLiteConnection_OperationLog$dump(android.util.Printer boolean ), 0, this, printer, bl);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_database_sqlite_SQLiteConnection_OperationLog$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OperationLog)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private final class PreparedStatementCache
    extends LruCache<String, PreparedStatement> {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ SQLiteConnection this$0;

        private void $$robo$$android_database_sqlite_SQLiteConnection_PreparedStatementCache$__constructor__(SQLiteConnection sQLiteConnection, int size) {
        }

        private final void $$robo$$android_database_sqlite_SQLiteConnection_PreparedStatementCache$entryRemoved(boolean evicted, String key, PreparedStatement oldValue, PreparedStatement newValue) {
            oldValue.mInCache = false;
            if (!oldValue.mInUse) {
                this.this$0.finalizePreparedStatement(oldValue);
            }
        }

        private final void $$robo$$android_database_sqlite_SQLiteConnection_PreparedStatementCache$dump(Printer printer) {
            printer.println("  Prepared statement cache:");
            Map cache = this.snapshot();
            if (!cache.isEmpty()) {
                int i = 0;
                for (Map.Entry entry : cache.entrySet()) {
                    PreparedStatement statement = (PreparedStatement)entry.getValue();
                    if (statement.mInCache) {
                        String sql = (String)entry.getKey();
                        printer.println("    " + i + ": statementPtr=0x" + Long.toHexString(statement.mStatementPtr) + ", numParameters=" + statement.mNumParameters + ", type=" + statement.mType + ", readOnly=" + statement.mReadOnly + ", sql=\"" + SQLiteConnection.trimSqlForDisplay(sql) + "\"");
                    }
                    ++i;
                }
            } else {
                printer.println("    <none>");
            }
        }

        private void __constructor__(SQLiteConnection sQLiteConnection, int n) {
            this.$$robo$$android_database_sqlite_SQLiteConnection_PreparedStatementCache$__constructor__(sQLiteConnection, n);
        }

        public PreparedStatementCache(SQLiteConnection sQLiteConnection, int n) {
            this.this$0 = sQLiteConnection;
            super(n);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_database_sqlite_SQLiteConnection_PreparedStatementCache$__constructor__(android.database.sqlite.SQLiteConnection int ), 0, this, sQLiteConnection, n);
        }

        @Override
        protected void entryRemoved(boolean bl, String string2, PreparedStatement preparedStatement, PreparedStatement preparedStatement2) {
            InvokeDynamicSupport.bootstrap("entryRemoved", $$robo$$android_database_sqlite_SQLiteConnection_PreparedStatementCache$entryRemoved(boolean java.lang.String android.database.sqlite.SQLiteConnection$PreparedStatement android.database.sqlite.SQLiteConnection$PreparedStatement ), 0, this, bl, string2, preparedStatement, preparedStatement2);
        }

        public void dump(Printer printer) {
            InvokeDynamicSupport.bootstrap("dump", $$robo$$android_database_sqlite_SQLiteConnection_PreparedStatementCache$dump(android.util.Printer ), 0, this, printer);
        }

        public /* synthetic */ PreparedStatementCache() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PreparedStatementCache)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class PreparedStatement
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public PreparedStatement mPoolNext;
        public String mSql;
        public long mStatementPtr;
        public int mNumParameters;
        public int mType;
        public boolean mReadOnly;
        public boolean mInCache;
        public boolean mInUse;

        private void $$robo$$android_database_sqlite_SQLiteConnection_PreparedStatement$__constructor__() {
        }

        private /* synthetic */ void $$robo$$android_database_sqlite_SQLiteConnection_PreparedStatement$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_database_sqlite_SQLiteConnection_PreparedStatement$__constructor__();
        }

        private PreparedStatement() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_database_sqlite_SQLiteConnection_PreparedStatement$__constructor__(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_database_sqlite_SQLiteConnection_PreparedStatement$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PreparedStatement)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

