/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.database.sqlite.SQLiteConnection;
import android.database.sqlite.SQLiteDatabaseConfiguration;
import android.database.sqlite.SQLiteDebug;
import android.database.sqlite.SQLiteGlobal;
import android.os.CancellationSignal;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.OperationCanceledException;
import android.os.SystemClock;
import android.util.Log;
import android.util.PrefixPrinter;
import android.util.Printer;
import com.android.internal.annotations.GuardedBy;
import com.google.errorprone.annotations.DoNotMock;
import dalvik.system.CloseGuard;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class SQLiteConnectionPool
implements Closeable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "SQLiteConnectionPool";
    private static long CONNECTION_POOL_BUSY_MILLIS = 30000L;
    private CloseGuard mCloseGuard;
    private Object mLock;
    private AtomicBoolean mConnectionLeaked;
    private SQLiteDatabaseConfiguration mConfiguration;
    private int mMaxConnectionPoolSize;
    private boolean mIsOpen;
    private int mNextConnectionId;
    private ConnectionWaiter mConnectionWaiterPool;
    private ConnectionWaiter mConnectionWaiterQueue;
    private ArrayList<SQLiteConnection> mAvailableNonPrimaryConnections;
    private SQLiteConnection mAvailablePrimaryConnection;
    @GuardedBy(value="mLock")
    private IdleConnectionHandler mIdleConnectionHandler;
    private WeakHashMap<SQLiteConnection, AcquiredConnectionStatus> mAcquiredConnections;
    public static int CONNECTION_FLAG_READ_ONLY = 1;
    public static int CONNECTION_FLAG_PRIMARY_CONNECTION_AFFINITY = 2;
    public static int CONNECTION_FLAG_INTERACTIVE = 4;
    static /* synthetic */ boolean $assertionsDisabled;

    private void $$robo$$android_database_sqlite_SQLiteConnectionPool$__constructor__(SQLiteDatabaseConfiguration configuration) {
        this.mCloseGuard = CloseGuard.get();
        this.mLock = new Object();
        this.mConnectionLeaked = new AtomicBoolean();
        this.mAvailableNonPrimaryConnections = new ArrayList();
        this.mAcquiredConnections = new WeakHashMap();
        this.mConfiguration = new SQLiteDatabaseConfiguration(configuration);
        this.setMaxConnectionPoolSizeLocked();
        if (this.mConfiguration.idleConnectionTimeoutMs != Long.MAX_VALUE) {
            this.setupIdleConnectionHandler(Looper.getMainLooper(), this.mConfiguration.idleConnectionTimeoutMs);
        }
    }

    private final void $$robo$$android_database_sqlite_SQLiteConnectionPool$finalize() throws Throwable {
        try {
            this.dispose(true);
        }
        finally {
            super.finalize();
        }
    }

    private static final SQLiteConnectionPool $$robo$$android_database_sqlite_SQLiteConnectionPool$open(SQLiteDatabaseConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("configuration must not be null.");
        }
        SQLiteConnectionPool pool = new SQLiteConnectionPool(configuration);
        pool.open();
        return pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_database_sqlite_SQLiteConnectionPool$open() {
        this.mAvailablePrimaryConnection = this.openConnectionLocked(this.mConfiguration, true);
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIdleConnectionHandler != null) {
                this.mIdleConnectionHandler.connectionReleased(this.mAvailablePrimaryConnection);
            }
        }
        this.mIsOpen = true;
        this.mCloseGuard.open("close");
    }

    private final void $$robo$$android_database_sqlite_SQLiteConnectionPool$close() {
        this.dispose(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_database_sqlite_SQLiteConnectionPool$dispose(boolean finalized) {
        if (this.mCloseGuard != null) {
            if (finalized) {
                this.mCloseGuard.warnIfOpen();
            }
            this.mCloseGuard.close();
        }
        if (!finalized) {
            Object object = this.mLock;
            synchronized (object) {
                this.throwIfClosedLocked();
                this.mIsOpen = false;
                this.closeAvailableConnectionsAndLogExceptionsLocked();
                int pendingCount = this.mAcquiredConnections.size();
                if (pendingCount != 0) {
                    Log.i("SQLiteConnectionPool", "The connection pool for " + this.mConfiguration.label + " has been closed but there are still " + pendingCount + " connections in use.  They will be closed " + "as they are released back to the pool.");
                }
                this.wakeConnectionWaitersLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_database_sqlite_SQLiteConnectionPool$reconfigure(SQLiteDatabaseConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("configuration must not be null.");
        }
        Object object = this.mLock;
        synchronized (object) {
            boolean foreignKeyModeChanged;
            boolean walModeChanged;
            this.throwIfClosedLocked();
            boolean bl = walModeChanged = ((configuration.openFlags ^ this.mConfiguration.openFlags) & 0x20000000) != 0;
            if (walModeChanged) {
                if (!this.mAcquiredConnections.isEmpty()) {
                    throw new IllegalStateException("Write Ahead Logging (WAL) mode cannot be enabled or disabled while there are transactions in progress.  Finish all transactions and release all active database connections first.");
                }
                this.closeAvailableNonPrimaryConnectionsAndLogExceptionsLocked();
                if (!$assertionsDisabled && !this.mAvailableNonPrimaryConnections.isEmpty()) {
                    throw new AssertionError();
                }
            }
            boolean bl2 = foreignKeyModeChanged = configuration.foreignKeyConstraintsEnabled != this.mConfiguration.foreignKeyConstraintsEnabled;
            if (foreignKeyModeChanged && !this.mAcquiredConnections.isEmpty()) {
                throw new IllegalStateException("Foreign Key Constraints cannot be enabled or disabled while there are transactions in progress.  Finish all transactions and release all active database connections first.");
            }
            if (this.mConfiguration.openFlags != configuration.openFlags) {
                if (walModeChanged) {
                    this.closeAvailableConnectionsAndLogExceptionsLocked();
                }
                SQLiteConnection newPrimaryConnection = this.openConnectionLocked(configuration, true);
                this.closeAvailableConnectionsAndLogExceptionsLocked();
                this.discardAcquiredConnectionsLocked();
                this.mAvailablePrimaryConnection = newPrimaryConnection;
                this.mConfiguration.updateParametersFrom(configuration);
                this.setMaxConnectionPoolSizeLocked();
            } else {
                this.mConfiguration.updateParametersFrom(configuration);
                this.setMaxConnectionPoolSizeLocked();
                this.closeExcessConnectionsAndLogExceptionsLocked();
                this.reconfigureAllConnectionsLocked();
            }
            this.wakeConnectionWaitersLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SQLiteConnection $$robo$$android_database_sqlite_SQLiteConnectionPool$acquireConnection(String sql, int connectionFlags, CancellationSignal cancellationSignal) {
        SQLiteConnection con = this.waitForConnection(sql, connectionFlags, cancellationSignal);
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIdleConnectionHandler != null) {
                this.mIdleConnectionHandler.connectionAcquired(con);
            }
        }
        return con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_database_sqlite_SQLiteConnectionPool$releaseConnection(SQLiteConnection connection) {
        Object object = this.mLock;
        synchronized (object) {
            AcquiredConnectionStatus status;
            if (this.mIdleConnectionHandler != null) {
                this.mIdleConnectionHandler.connectionReleased(connection);
            }
            if ((status = this.mAcquiredConnections.remove(connection)) == null) {
                throw new IllegalStateException("Cannot perform this operation because the specified connection was not acquired from this pool or has already been released.");
            }
            if (!this.mIsOpen) {
                this.closeConnectionAndLogExceptionsLocked(connection);
            } else if (connection.isPrimaryConnection()) {
                if (this.recycleConnectionLocked(connection, status)) {
                    if (!$assertionsDisabled && this.mAvailablePrimaryConnection != null) {
                        throw new AssertionError();
                    }
                    this.mAvailablePrimaryConnection = connection;
                }
                this.wakeConnectionWaitersLocked();
            } else if (this.mAvailableNonPrimaryConnections.size() >= this.mMaxConnectionPoolSize - 1) {
                this.closeConnectionAndLogExceptionsLocked(connection);
            } else {
                if (this.recycleConnectionLocked(connection, status)) {
                    this.mAvailableNonPrimaryConnections.add(connection);
                }
                this.wakeConnectionWaitersLocked();
            }
        }
    }

    private final boolean $$robo$$android_database_sqlite_SQLiteConnectionPool$recycleConnectionLocked(SQLiteConnection connection, AcquiredConnectionStatus status) {
        if (status == AcquiredConnectionStatus.RECONFIGURE) {
            try {
                connection.reconfigure(this.mConfiguration);
            }
            catch (RuntimeException ex) {
                Log.e("SQLiteConnectionPool", "Failed to reconfigure released connection, closing it: " + connection, ex);
                status = AcquiredConnectionStatus.DISCARD;
            }
        }
        if (status == AcquiredConnectionStatus.DISCARD) {
            this.closeConnectionAndLogExceptionsLocked(connection);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_database_sqlite_SQLiteConnectionPool$shouldYieldConnection(SQLiteConnection connection, int connectionFlags) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mAcquiredConnections.containsKey(connection)) {
                throw new IllegalStateException("Cannot perform this operation because the specified connection was not acquired from this pool or has already been released.");
            }
            if (!this.mIsOpen) {
                return false;
            }
            return this.isSessionBlockingImportantConnectionWaitersLocked(connection.isPrimaryConnection(), connectionFlags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_database_sqlite_SQLiteConnectionPool$collectDbStats(ArrayList<SQLiteDebug.DbStats> dbStatsList) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mAvailablePrimaryConnection != null) {
                this.mAvailablePrimaryConnection.collectDbStats(dbStatsList);
            }
            for (SQLiteConnection connection : this.mAvailableNonPrimaryConnections) {
                connection.collectDbStats(dbStatsList);
            }
            for (SQLiteConnection connection : this.mAcquiredConnections.keySet()) {
                connection.collectDbStatsUnsafe(dbStatsList);
            }
        }
    }

    private final SQLiteConnection $$robo$$android_database_sqlite_SQLiteConnectionPool$openConnectionLocked(SQLiteDatabaseConfiguration configuration, boolean primaryConnection) {
        int connectionId = this.mNextConnectionId++;
        return SQLiteConnection.open(this, configuration, connectionId, primaryConnection);
    }

    private final void $$robo$$android_database_sqlite_SQLiteConnectionPool$onConnectionLeaked() {
        Log.w("SQLiteConnectionPool", "A SQLiteConnection object for database '" + this.mConfiguration.label + "' was leaked!  Please fix your application " + "to end transactions in progress properly and to close the database " + "when it is no longer needed.");
        this.mConnectionLeaked.set(true);
    }

    private final void $$robo$$android_database_sqlite_SQLiteConnectionPool$closeAvailableConnectionsAndLogExceptionsLocked() {
        this.closeAvailableNonPrimaryConnectionsAndLogExceptionsLocked();
        if (this.mAvailablePrimaryConnection != null) {
            this.closeConnectionAndLogExceptionsLocked(this.mAvailablePrimaryConnection);
            this.mAvailablePrimaryConnection = null;
        }
    }

    private final boolean $$robo$$android_database_sqlite_SQLiteConnectionPool$closeAvailableConnectionLocked(int connectionId) {
        int count = this.mAvailableNonPrimaryConnections.size();
        for (int i = count - 1; i >= 0; --i) {
            SQLiteConnection c = this.mAvailableNonPrimaryConnections.get(i);
            if (c.getConnectionId() != connectionId) continue;
            this.closeConnectionAndLogExceptionsLocked(c);
            this.mAvailableNonPrimaryConnections.remove(i);
            return true;
        }
        if (this.mAvailablePrimaryConnection != null && this.mAvailablePrimaryConnection.getConnectionId() == connectionId) {
            this.closeConnectionAndLogExceptionsLocked(this.mAvailablePrimaryConnection);
            this.mAvailablePrimaryConnection = null;
            return true;
        }
        return false;
    }

    private final void $$robo$$android_database_sqlite_SQLiteConnectionPool$closeAvailableNonPrimaryConnectionsAndLogExceptionsLocked() {
        int count = this.mAvailableNonPrimaryConnections.size();
        for (int i = 0; i < count; ++i) {
            this.closeConnectionAndLogExceptionsLocked(this.mAvailableNonPrimaryConnections.get(i));
        }
        this.mAvailableNonPrimaryConnections.clear();
    }

    private final void $$robo$$android_database_sqlite_SQLiteConnectionPool$closeExcessConnectionsAndLogExceptionsLocked() {
        int availableCount = this.mAvailableNonPrimaryConnections.size();
        while (availableCount-- > this.mMaxConnectionPoolSize - 1) {
            SQLiteConnection connection = this.mAvailableNonPrimaryConnections.remove(availableCount);
            this.closeConnectionAndLogExceptionsLocked(connection);
        }
    }

    private final void $$robo$$android_database_sqlite_SQLiteConnectionPool$closeConnectionAndLogExceptionsLocked(SQLiteConnection connection) {
        try {
            connection.close();
            if (this.mIdleConnectionHandler != null) {
                this.mIdleConnectionHandler.connectionClosed(connection);
            }
        }
        catch (RuntimeException ex) {
            Log.e("SQLiteConnectionPool", "Failed to close connection, its fate is now in the hands of the merciful GC: " + connection, ex);
        }
    }

    private final void $$robo$$android_database_sqlite_SQLiteConnectionPool$discardAcquiredConnectionsLocked() {
        this.markAcquiredConnectionsLocked(AcquiredConnectionStatus.DISCARD);
    }

    private final void $$robo$$android_database_sqlite_SQLiteConnectionPool$reconfigureAllConnectionsLocked() {
        if (this.mAvailablePrimaryConnection != null) {
            try {
                this.mAvailablePrimaryConnection.reconfigure(this.mConfiguration);
            }
            catch (RuntimeException ex) {
                Log.e("SQLiteConnectionPool", "Failed to reconfigure available primary connection, closing it: " + this.mAvailablePrimaryConnection, ex);
                this.closeConnectionAndLogExceptionsLocked(this.mAvailablePrimaryConnection);
                this.mAvailablePrimaryConnection = null;
            }
        }
        int count = this.mAvailableNonPrimaryConnections.size();
        for (int i = 0; i < count; ++i) {
            SQLiteConnection connection = this.mAvailableNonPrimaryConnections.get(i);
            try {
                connection.reconfigure(this.mConfiguration);
                continue;
            }
            catch (RuntimeException ex) {
                Log.e("SQLiteConnectionPool", "Failed to reconfigure available non-primary connection, closing it: " + connection, ex);
                this.closeConnectionAndLogExceptionsLocked(connection);
                this.mAvailableNonPrimaryConnections.remove(i--);
                --count;
            }
        }
        this.markAcquiredConnectionsLocked(AcquiredConnectionStatus.RECONFIGURE);
    }

    private final void $$robo$$android_database_sqlite_SQLiteConnectionPool$markAcquiredConnectionsLocked(AcquiredConnectionStatus status) {
        if (!this.mAcquiredConnections.isEmpty()) {
            ArrayList<SQLiteConnection> keysToUpdate = new ArrayList<SQLiteConnection>(this.mAcquiredConnections.size());
            for (Map.Entry<SQLiteConnection, AcquiredConnectionStatus> entry : this.mAcquiredConnections.entrySet()) {
                AcquiredConnectionStatus oldStatus = entry.getValue();
                if (status == oldStatus || oldStatus == AcquiredConnectionStatus.DISCARD) continue;
                keysToUpdate.add(entry.getKey());
            }
            int updateCount = keysToUpdate.size();
            for (int i = 0; i < updateCount; ++i) {
                this.mAcquiredConnections.put((SQLiteConnection)keysToUpdate.get(i), status);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private final SQLiteConnection $$robo$$android_database_sqlite_SQLiteConnectionPool$waitForConnection(String sql, int connectionFlags, CancellationSignal cancellationSignal) {
        boolean wantPrimaryConnection = (connectionFlags & 2) != 0;
        Object object = this.mLock;
        // MONITORENTER : object
        this.throwIfClosedLocked();
        if (cancellationSignal != null) {
            cancellationSignal.throwIfCanceled();
        }
        SQLiteConnection connection = null;
        if (!wantPrimaryConnection) {
            connection = this.tryAcquireNonPrimaryConnectionLocked(sql, connectionFlags);
        }
        if (connection == null) {
            connection = this.tryAcquirePrimaryConnectionLocked(connectionFlags);
        }
        if (connection != null) {
            // MONITOREXIT : object
            return connection;
        }
        int priority = SQLiteConnectionPool.getPriority(connectionFlags);
        long startTime = SystemClock.uptimeMillis();
        ConnectionWaiter waiter = this.obtainConnectionWaiterLocked(Thread.currentThread(), startTime, priority, wantPrimaryConnection, sql, connectionFlags);
        ConnectionWaiter predecessor = null;
        ConnectionWaiter successor = this.mConnectionWaiterQueue;
        while (successor != null) {
            if (priority > successor.mPriority) {
                waiter.mNext = successor;
                break;
            }
            predecessor = successor;
            successor = successor.mNext;
        }
        if (predecessor != null) {
            predecessor.mNext = waiter;
        } else {
            this.mConnectionWaiterQueue = waiter;
        }
        int nonce = waiter.mNonce;
        // MONITOREXIT : object
        if (cancellationSignal != null) {
            cancellationSignal.setOnCancelListener(new CancellationSignal.OnCancelListener(this, waiter, nonce){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ ConnectionWaiter val$waiter;
                /* synthetic */ int val$nonce;
                /* synthetic */ SQLiteConnectionPool this$0;

                private void $$robo$$android_database_sqlite_SQLiteConnectionPool_1$__constructor__(SQLiteConnectionPool this$0, ConnectionWaiter connectionWaiter, int n) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private final void $$robo$$android_database_sqlite_SQLiteConnectionPool_1$onCancel() {
                    Object object = this.this$0.mLock;
                    synchronized (object) {
                        if (this.val$waiter.mNonce == this.val$nonce) {
                            this.this$0.cancelConnectionWaiterLocked(this.val$waiter);
                        }
                    }
                }

                private void __constructor__(SQLiteConnectionPool sQLiteConnectionPool, ConnectionWaiter connectionWaiter, int n) {
                    this.$$robo$$android_database_sqlite_SQLiteConnectionPool_1$__constructor__(sQLiteConnectionPool, connectionWaiter, n);
                }
                {
                    this.this$0 = sQLiteConnectionPool;
                    this.val$waiter = connectionWaiter;
                    this.val$nonce = n;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_database_sqlite_SQLiteConnectionPool_1$__constructor__(android.database.sqlite.SQLiteConnectionPool android.database.sqlite.SQLiteConnectionPool$ConnectionWaiter int ), 0, this, sQLiteConnectionPool, connectionWaiter, n);
                }

                @Override
                public void onCancel() {
                    InvokeDynamicSupport.bootstrap("onCancel", $$robo$$android_database_sqlite_SQLiteConnectionPool_1$onCancel(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
        try {
            long busyTimeoutMillis = 30000L;
            long nextBusyTimeoutTime = waiter.mStartTime + busyTimeoutMillis;
            while (true) {
                Object object2;
                if (this.mConnectionLeaked.compareAndSet(true, false)) {
                    object2 = this.mLock;
                    // MONITORENTER : object2
                    this.wakeConnectionWaitersLocked();
                    // MONITOREXIT : object2
                }
                LockSupport.parkNanos(this, busyTimeoutMillis * 1000000L);
                Thread.interrupted();
                object2 = this.mLock;
                // MONITORENTER : object2
                this.throwIfClosedLocked();
                SQLiteConnection connection2 = waiter.mAssignedConnection;
                RuntimeException ex = waiter.mException;
                if (connection2 != null || ex != null) {
                    this.recycleConnectionWaiterLocked(waiter);
                    if (connection2 == null) throw ex;
                    SQLiteConnection sQLiteConnection = connection2;
                    // MONITOREXIT : object2
                    return sQLiteConnection;
                }
                long now = SystemClock.uptimeMillis();
                if (now < nextBusyTimeoutTime) {
                    busyTimeoutMillis = now - nextBusyTimeoutTime;
                } else {
                    this.logConnectionPoolBusyLocked(now - waiter.mStartTime, connectionFlags);
                    busyTimeoutMillis = 30000L;
                    nextBusyTimeoutTime = now + busyTimeoutMillis;
                }
                // MONITOREXIT : object2
            }
        }
        finally {
            if (cancellationSignal != null) {
                cancellationSignal.setOnCancelListener(null);
            }
        }
    }

    private final void $$robo$$android_database_sqlite_SQLiteConnectionPool$cancelConnectionWaiterLocked(ConnectionWaiter waiter) {
        if (waiter.mAssignedConnection != null || waiter.mException != null) {
            return;
        }
        ConnectionWaiter predecessor = null;
        ConnectionWaiter current = this.mConnectionWaiterQueue;
        while (current != waiter) {
            if (!$assertionsDisabled && current == null) {
                throw new AssertionError();
            }
            predecessor = current;
            current = current.mNext;
        }
        if (predecessor != null) {
            predecessor.mNext = waiter.mNext;
        } else {
            this.mConnectionWaiterQueue = waiter.mNext;
        }
        waiter.mException = new OperationCanceledException();
        LockSupport.unpark(waiter.mThread);
        this.wakeConnectionWaitersLocked();
    }

    private final void $$robo$$android_database_sqlite_SQLiteConnectionPool$logConnectionPoolBusyLocked(long waitMillis, int connectionFlags) {
        Thread thread = Thread.currentThread();
        StringBuilder msg = new StringBuilder();
        msg.append("The connection pool for database '").append(this.mConfiguration.label);
        msg.append("' has been unable to grant a connection to thread ");
        msg.append(thread.getId()).append(" (").append(thread.getName()).append(") ");
        msg.append("with flags 0x").append(Integer.toHexString(connectionFlags));
        msg.append(" for ").append((float)waitMillis * 0.001f).append(" seconds.\n");
        ArrayList<String> requests = new ArrayList<String>();
        int activeConnections = 0;
        int idleConnections = 0;
        if (!this.mAcquiredConnections.isEmpty()) {
            for (SQLiteConnection connection : this.mAcquiredConnections.keySet()) {
                String description = connection.describeCurrentOperationUnsafe();
                if (description != null) {
                    requests.add(description);
                    ++activeConnections;
                    continue;
                }
                ++idleConnections;
            }
        }
        int availableConnections = this.mAvailableNonPrimaryConnections.size();
        if (this.mAvailablePrimaryConnection != null) {
            ++availableConnections;
        }
        msg.append("Connections: ").append(activeConnections).append(" active, ");
        msg.append(idleConnections).append(" idle, ");
        msg.append(availableConnections).append(" available.\n");
        if (!requests.isEmpty()) {
            msg.append("\nRequests in progress:\n");
            for (String request : requests) {
                msg.append("  ").append(request).append("\n");
            }
        }
        Log.w("SQLiteConnectionPool", msg.toString());
    }

    private final void $$robo$$android_database_sqlite_SQLiteConnectionPool$wakeConnectionWaitersLocked() {
        ConnectionWaiter predecessor = null;
        ConnectionWaiter waiter = this.mConnectionWaiterQueue;
        boolean primaryConnectionNotAvailable = false;
        boolean nonPrimaryConnectionNotAvailable = false;
        while (waiter != null) {
            boolean unpark = false;
            if (!this.mIsOpen) {
                unpark = true;
            } else {
                try {
                    SQLiteConnection connection = null;
                    if (!waiter.mWantPrimaryConnection && !nonPrimaryConnectionNotAvailable && (connection = this.tryAcquireNonPrimaryConnectionLocked(waiter.mSql, waiter.mConnectionFlags)) == null) {
                        nonPrimaryConnectionNotAvailable = true;
                    }
                    if (connection == null && !primaryConnectionNotAvailable && (connection = this.tryAcquirePrimaryConnectionLocked(waiter.mConnectionFlags)) == null) {
                        primaryConnectionNotAvailable = true;
                    }
                    if (connection != null) {
                        waiter.mAssignedConnection = connection;
                        unpark = true;
                    } else if (nonPrimaryConnectionNotAvailable && primaryConnectionNotAvailable) {
                        break;
                    }
                }
                catch (RuntimeException ex) {
                    waiter.mException = ex;
                    unpark = true;
                }
            }
            ConnectionWaiter successor = waiter.mNext;
            if (unpark) {
                if (predecessor != null) {
                    predecessor.mNext = successor;
                } else {
                    this.mConnectionWaiterQueue = successor;
                }
                waiter.mNext = null;
                LockSupport.unpark(waiter.mThread);
            } else {
                predecessor = waiter;
            }
            waiter = successor;
        }
    }

    private final SQLiteConnection $$robo$$android_database_sqlite_SQLiteConnectionPool$tryAcquirePrimaryConnectionLocked(int connectionFlags) {
        SQLiteConnection connection = this.mAvailablePrimaryConnection;
        if (connection != null) {
            this.mAvailablePrimaryConnection = null;
            this.finishAcquireConnectionLocked(connection, connectionFlags);
            return connection;
        }
        for (SQLiteConnection acquiredConnection : this.mAcquiredConnections.keySet()) {
            if (!acquiredConnection.isPrimaryConnection()) continue;
            return null;
        }
        connection = this.openConnectionLocked(this.mConfiguration, true);
        this.finishAcquireConnectionLocked(connection, connectionFlags);
        return connection;
    }

    private final SQLiteConnection $$robo$$android_database_sqlite_SQLiteConnectionPool$tryAcquireNonPrimaryConnectionLocked(String sql, int connectionFlags) {
        SQLiteConnection connection;
        int availableCount = this.mAvailableNonPrimaryConnections.size();
        if (availableCount > 1 && sql != null) {
            for (int i = 0; i < availableCount; ++i) {
                connection = this.mAvailableNonPrimaryConnections.get(i);
                if (!connection.isPreparedStatementInCache(sql)) continue;
                this.mAvailableNonPrimaryConnections.remove(i);
                this.finishAcquireConnectionLocked(connection, connectionFlags);
                return connection;
            }
        }
        if (availableCount > 0) {
            connection = this.mAvailableNonPrimaryConnections.remove(availableCount - 1);
            this.finishAcquireConnectionLocked(connection, connectionFlags);
            return connection;
        }
        int openConnections = this.mAcquiredConnections.size();
        if (this.mAvailablePrimaryConnection != null) {
            ++openConnections;
        }
        if (openConnections >= this.mMaxConnectionPoolSize) {
            return null;
        }
        connection = this.openConnectionLocked(this.mConfiguration, false);
        this.finishAcquireConnectionLocked(connection, connectionFlags);
        return connection;
    }

    private final void $$robo$$android_database_sqlite_SQLiteConnectionPool$finishAcquireConnectionLocked(SQLiteConnection connection, int connectionFlags) {
        try {
            boolean readOnly = (connectionFlags & 1) != 0;
            connection.setOnlyAllowReadOnlyOperations(readOnly);
            this.mAcquiredConnections.put(connection, AcquiredConnectionStatus.NORMAL);
        }
        catch (RuntimeException ex) {
            Log.e("SQLiteConnectionPool", "Failed to prepare acquired connection for session, closing it: " + connection + ", connectionFlags=" + connectionFlags);
            this.closeConnectionAndLogExceptionsLocked(connection);
            throw ex;
        }
    }

    private final boolean $$robo$$android_database_sqlite_SQLiteConnectionPool$isSessionBlockingImportantConnectionWaitersLocked(boolean holdingPrimaryConnection, int connectionFlags) {
        ConnectionWaiter waiter = this.mConnectionWaiterQueue;
        if (waiter != null) {
            int priority = SQLiteConnectionPool.getPriority(connectionFlags);
            while (priority <= waiter.mPriority) {
                if (holdingPrimaryConnection || !waiter.mWantPrimaryConnection) {
                    return true;
                }
                waiter = waiter.mNext;
                if (waiter != null) continue;
            }
        }
        return false;
    }

    private static final int $$robo$$android_database_sqlite_SQLiteConnectionPool$getPriority(int connectionFlags) {
        return (connectionFlags & 4) != 0 ? 1 : 0;
    }

    private final void $$robo$$android_database_sqlite_SQLiteConnectionPool$setMaxConnectionPoolSizeLocked() {
        this.mMaxConnectionPoolSize = !this.mConfiguration.isInMemoryDb() && (this.mConfiguration.openFlags & 0x20000000) != 0 ? SQLiteGlobal.getWALConnectionPoolSize() : 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_database_sqlite_SQLiteConnectionPool$setupIdleConnectionHandler(Looper looper, long timeoutMs) {
        Object object = this.mLock;
        synchronized (object) {
            this.mIdleConnectionHandler = new IdleConnectionHandler(this, looper, timeoutMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_database_sqlite_SQLiteConnectionPool$disableIdleConnectionHandler() {
        Object object = this.mLock;
        synchronized (object) {
            this.mIdleConnectionHandler = null;
        }
    }

    private final void $$robo$$android_database_sqlite_SQLiteConnectionPool$throwIfClosedLocked() {
        if (!this.mIsOpen) {
            throw new IllegalStateException("Cannot perform this operation because the connection pool has been closed.");
        }
    }

    private final ConnectionWaiter $$robo$$android_database_sqlite_SQLiteConnectionPool$obtainConnectionWaiterLocked(Thread thread, long startTime, int priority, boolean wantPrimaryConnection, String sql, int connectionFlags) {
        ConnectionWaiter waiter = this.mConnectionWaiterPool;
        if (waiter != null) {
            this.mConnectionWaiterPool = waiter.mNext;
            waiter.mNext = null;
        } else {
            waiter = new ConnectionWaiter();
        }
        waiter.mThread = thread;
        waiter.mStartTime = startTime;
        waiter.mPriority = priority;
        waiter.mWantPrimaryConnection = wantPrimaryConnection;
        waiter.mSql = sql;
        waiter.mConnectionFlags = connectionFlags;
        return waiter;
    }

    private final void $$robo$$android_database_sqlite_SQLiteConnectionPool$recycleConnectionWaiterLocked(ConnectionWaiter waiter) {
        waiter.mNext = this.mConnectionWaiterPool;
        waiter.mThread = null;
        waiter.mSql = null;
        waiter.mAssignedConnection = null;
        waiter.mException = null;
        ++waiter.mNonce;
        this.mConnectionWaiterPool = waiter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_database_sqlite_SQLiteConnectionPool$dump(Printer printer, boolean verbose) {
        Printer indentedPrinter = PrefixPrinter.create(printer, "    ");
        Object object = this.mLock;
        synchronized (object) {
            printer.println("Connection pool for " + this.mConfiguration.path + ":");
            printer.println("  Open: " + this.mIsOpen);
            printer.println("  Max connections: " + this.mMaxConnectionPoolSize);
            if (this.mConfiguration.isLookasideConfigSet()) {
                printer.println("  Lookaside config: sz=" + this.mConfiguration.lookasideSlotSize + " cnt=" + this.mConfiguration.lookasideSlotCount);
            }
            if (this.mConfiguration.idleConnectionTimeoutMs != Long.MAX_VALUE) {
                printer.println("  Idle connection timeout: " + this.mConfiguration.idleConnectionTimeoutMs);
            }
            printer.println("  Available primary connection:");
            if (this.mAvailablePrimaryConnection != null) {
                this.mAvailablePrimaryConnection.dump(indentedPrinter, verbose);
            } else {
                indentedPrinter.println("<none>");
            }
            printer.println("  Available non-primary connections:");
            if (!this.mAvailableNonPrimaryConnections.isEmpty()) {
                int count = this.mAvailableNonPrimaryConnections.size();
                for (int i = 0; i < count; ++i) {
                    this.mAvailableNonPrimaryConnections.get(i).dump(indentedPrinter, verbose);
                }
            } else {
                indentedPrinter.println("<none>");
            }
            printer.println("  Acquired connections:");
            if (!this.mAcquiredConnections.isEmpty()) {
                for (Map.Entry<SQLiteConnection, AcquiredConnectionStatus> entry : this.mAcquiredConnections.entrySet()) {
                    SQLiteConnection connection = entry.getKey();
                    connection.dumpUnsafe(indentedPrinter, verbose);
                    indentedPrinter.println("  Status: " + (Object)((Object)entry.getValue()));
                }
            } else {
                indentedPrinter.println("<none>");
            }
            printer.println("  Connection waiters:");
            if (this.mConnectionWaiterQueue != null) {
                int i = 0;
                long now = SystemClock.uptimeMillis();
                ConnectionWaiter waiter = this.mConnectionWaiterQueue;
                while (waiter != null) {
                    indentedPrinter.println(i + ": waited for " + (float)(now - waiter.mStartTime) * 0.001f + " ms - thread=" + waiter.mThread + ", priority=" + waiter.mPriority + ", sql='" + waiter.mSql + "'");
                    waiter = waiter.mNext;
                    ++i;
                }
            } else {
                indentedPrinter.println("<none>");
            }
        }
    }

    private final String $$robo$$android_database_sqlite_SQLiteConnectionPool$toString() {
        return "SQLiteConnectionPool: " + this.mConfiguration.path;
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !SQLiteConnectionPool.class.desiredAssertionStatus();
    }

    private void __constructor__(SQLiteDatabaseConfiguration sQLiteDatabaseConfiguration) {
        this.$$robo$$android_database_sqlite_SQLiteConnectionPool$__constructor__(sQLiteDatabaseConfiguration);
    }

    private SQLiteConnectionPool(SQLiteDatabaseConfiguration sQLiteDatabaseConfiguration) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_database_sqlite_SQLiteConnectionPool$__constructor__(android.database.sqlite.SQLiteDatabaseConfiguration ), 0, this, sQLiteDatabaseConfiguration);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_database_sqlite_SQLiteConnectionPool$finalize(), 0, this);
    }

    public static SQLiteConnectionPool open(SQLiteDatabaseConfiguration sQLiteDatabaseConfiguration) {
        return InvokeDynamicSupport.bootstrapStatic("open", $$robo$$android_database_sqlite_SQLiteConnectionPool$open(android.database.sqlite.SQLiteDatabaseConfiguration ), 0, (SQLiteDatabaseConfiguration)sQLiteDatabaseConfiguration);
    }

    private void open() {
        InvokeDynamicSupport.bootstrap("open", $$robo$$android_database_sqlite_SQLiteConnectionPool$open(), 0, this);
    }

    @Override
    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_database_sqlite_SQLiteConnectionPool$close(), 0, this);
    }

    private void dispose(boolean bl) {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$android_database_sqlite_SQLiteConnectionPool$dispose(boolean ), 0, this, bl);
    }

    public void reconfigure(SQLiteDatabaseConfiguration sQLiteDatabaseConfiguration) {
        InvokeDynamicSupport.bootstrap("reconfigure", $$robo$$android_database_sqlite_SQLiteConnectionPool$reconfigure(android.database.sqlite.SQLiteDatabaseConfiguration ), 0, this, sQLiteDatabaseConfiguration);
    }

    public SQLiteConnection acquireConnection(String string2, int n, CancellationSignal cancellationSignal) {
        return InvokeDynamicSupport.bootstrap("acquireConnection", $$robo$$android_database_sqlite_SQLiteConnectionPool$acquireConnection(java.lang.String int android.os.CancellationSignal ), 0, this, string2, n, cancellationSignal);
    }

    public void releaseConnection(SQLiteConnection sQLiteConnection) {
        InvokeDynamicSupport.bootstrap("releaseConnection", $$robo$$android_database_sqlite_SQLiteConnectionPool$releaseConnection(android.database.sqlite.SQLiteConnection ), 0, this, sQLiteConnection);
    }

    private boolean recycleConnectionLocked(SQLiteConnection sQLiteConnection, AcquiredConnectionStatus acquiredConnectionStatus) {
        return (boolean)InvokeDynamicSupport.bootstrap("recycleConnectionLocked", $$robo$$android_database_sqlite_SQLiteConnectionPool$recycleConnectionLocked(android.database.sqlite.SQLiteConnection android.database.sqlite.SQLiteConnectionPool$AcquiredConnectionStatus ), 0, this, sQLiteConnection, acquiredConnectionStatus);
    }

    public boolean shouldYieldConnection(SQLiteConnection sQLiteConnection, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldYieldConnection", $$robo$$android_database_sqlite_SQLiteConnectionPool$shouldYieldConnection(android.database.sqlite.SQLiteConnection int ), 0, this, sQLiteConnection, n);
    }

    public void collectDbStats(ArrayList<SQLiteDebug.DbStats> arrayList) {
        InvokeDynamicSupport.bootstrap("collectDbStats", $$robo$$android_database_sqlite_SQLiteConnectionPool$collectDbStats(java.util.ArrayList<android.database.sqlite.SQLiteDebug$DbStats> ), 0, this, arrayList);
    }

    private SQLiteConnection openConnectionLocked(SQLiteDatabaseConfiguration sQLiteDatabaseConfiguration, boolean bl) {
        return InvokeDynamicSupport.bootstrap("openConnectionLocked", $$robo$$android_database_sqlite_SQLiteConnectionPool$openConnectionLocked(android.database.sqlite.SQLiteDatabaseConfiguration boolean ), 0, this, sQLiteDatabaseConfiguration, bl);
    }

    void onConnectionLeaked() {
        InvokeDynamicSupport.bootstrap("onConnectionLeaked", $$robo$$android_database_sqlite_SQLiteConnectionPool$onConnectionLeaked(), 0, this);
    }

    private void closeAvailableConnectionsAndLogExceptionsLocked() {
        InvokeDynamicSupport.bootstrap("closeAvailableConnectionsAndLogExceptionsLocked", $$robo$$android_database_sqlite_SQLiteConnectionPool$closeAvailableConnectionsAndLogExceptionsLocked(), 0, this);
    }

    private boolean closeAvailableConnectionLocked(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("closeAvailableConnectionLocked", $$robo$$android_database_sqlite_SQLiteConnectionPool$closeAvailableConnectionLocked(int ), 0, this, n);
    }

    private void closeAvailableNonPrimaryConnectionsAndLogExceptionsLocked() {
        InvokeDynamicSupport.bootstrap("closeAvailableNonPrimaryConnectionsAndLogExceptionsLocked", $$robo$$android_database_sqlite_SQLiteConnectionPool$closeAvailableNonPrimaryConnectionsAndLogExceptionsLocked(), 0, this);
    }

    private void closeExcessConnectionsAndLogExceptionsLocked() {
        InvokeDynamicSupport.bootstrap("closeExcessConnectionsAndLogExceptionsLocked", $$robo$$android_database_sqlite_SQLiteConnectionPool$closeExcessConnectionsAndLogExceptionsLocked(), 0, this);
    }

    private void closeConnectionAndLogExceptionsLocked(SQLiteConnection sQLiteConnection) {
        InvokeDynamicSupport.bootstrap("closeConnectionAndLogExceptionsLocked", $$robo$$android_database_sqlite_SQLiteConnectionPool$closeConnectionAndLogExceptionsLocked(android.database.sqlite.SQLiteConnection ), 0, this, sQLiteConnection);
    }

    private void discardAcquiredConnectionsLocked() {
        InvokeDynamicSupport.bootstrap("discardAcquiredConnectionsLocked", $$robo$$android_database_sqlite_SQLiteConnectionPool$discardAcquiredConnectionsLocked(), 0, this);
    }

    private void reconfigureAllConnectionsLocked() {
        InvokeDynamicSupport.bootstrap("reconfigureAllConnectionsLocked", $$robo$$android_database_sqlite_SQLiteConnectionPool$reconfigureAllConnectionsLocked(), 0, this);
    }

    private void markAcquiredConnectionsLocked(AcquiredConnectionStatus acquiredConnectionStatus) {
        InvokeDynamicSupport.bootstrap("markAcquiredConnectionsLocked", $$robo$$android_database_sqlite_SQLiteConnectionPool$markAcquiredConnectionsLocked(android.database.sqlite.SQLiteConnectionPool$AcquiredConnectionStatus ), 0, this, acquiredConnectionStatus);
    }

    private SQLiteConnection waitForConnection(String string2, int n, CancellationSignal cancellationSignal) {
        return InvokeDynamicSupport.bootstrap("waitForConnection", $$robo$$android_database_sqlite_SQLiteConnectionPool$waitForConnection(java.lang.String int android.os.CancellationSignal ), 0, this, string2, n, cancellationSignal);
    }

    private void cancelConnectionWaiterLocked(ConnectionWaiter connectionWaiter) {
        InvokeDynamicSupport.bootstrap("cancelConnectionWaiterLocked", $$robo$$android_database_sqlite_SQLiteConnectionPool$cancelConnectionWaiterLocked(android.database.sqlite.SQLiteConnectionPool$ConnectionWaiter ), 0, this, connectionWaiter);
    }

    private void logConnectionPoolBusyLocked(long l, int n) {
        InvokeDynamicSupport.bootstrap("logConnectionPoolBusyLocked", $$robo$$android_database_sqlite_SQLiteConnectionPool$logConnectionPoolBusyLocked(long int ), 0, this, l, n);
    }

    private void wakeConnectionWaitersLocked() {
        InvokeDynamicSupport.bootstrap("wakeConnectionWaitersLocked", $$robo$$android_database_sqlite_SQLiteConnectionPool$wakeConnectionWaitersLocked(), 0, this);
    }

    private SQLiteConnection tryAcquirePrimaryConnectionLocked(int n) {
        return InvokeDynamicSupport.bootstrap("tryAcquirePrimaryConnectionLocked", $$robo$$android_database_sqlite_SQLiteConnectionPool$tryAcquirePrimaryConnectionLocked(int ), 0, this, n);
    }

    private SQLiteConnection tryAcquireNonPrimaryConnectionLocked(String string2, int n) {
        return InvokeDynamicSupport.bootstrap("tryAcquireNonPrimaryConnectionLocked", $$robo$$android_database_sqlite_SQLiteConnectionPool$tryAcquireNonPrimaryConnectionLocked(java.lang.String int ), 0, this, string2, n);
    }

    private void finishAcquireConnectionLocked(SQLiteConnection sQLiteConnection, int n) {
        InvokeDynamicSupport.bootstrap("finishAcquireConnectionLocked", $$robo$$android_database_sqlite_SQLiteConnectionPool$finishAcquireConnectionLocked(android.database.sqlite.SQLiteConnection int ), 0, this, sQLiteConnection, n);
    }

    private boolean isSessionBlockingImportantConnectionWaitersLocked(boolean bl, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isSessionBlockingImportantConnectionWaitersLocked", $$robo$$android_database_sqlite_SQLiteConnectionPool$isSessionBlockingImportantConnectionWaitersLocked(boolean int ), 0, this, bl, n);
    }

    private static int getPriority(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getPriority", $$robo$$android_database_sqlite_SQLiteConnectionPool$getPriority(int ), 0, (int)n);
    }

    private void setMaxConnectionPoolSizeLocked() {
        InvokeDynamicSupport.bootstrap("setMaxConnectionPoolSizeLocked", $$robo$$android_database_sqlite_SQLiteConnectionPool$setMaxConnectionPoolSizeLocked(), 0, this);
    }

    public void setupIdleConnectionHandler(Looper looper, long l) {
        InvokeDynamicSupport.bootstrap("setupIdleConnectionHandler", $$robo$$android_database_sqlite_SQLiteConnectionPool$setupIdleConnectionHandler(android.os.Looper long ), 0, this, looper, l);
    }

    void disableIdleConnectionHandler() {
        InvokeDynamicSupport.bootstrap("disableIdleConnectionHandler", $$robo$$android_database_sqlite_SQLiteConnectionPool$disableIdleConnectionHandler(), 0, this);
    }

    private void throwIfClosedLocked() {
        InvokeDynamicSupport.bootstrap("throwIfClosedLocked", $$robo$$android_database_sqlite_SQLiteConnectionPool$throwIfClosedLocked(), 0, this);
    }

    private ConnectionWaiter obtainConnectionWaiterLocked(Thread thread, long l, int n, boolean bl, String string2, int n2) {
        return InvokeDynamicSupport.bootstrap("obtainConnectionWaiterLocked", $$robo$$android_database_sqlite_SQLiteConnectionPool$obtainConnectionWaiterLocked(java.lang.Thread long int boolean java.lang.String int ), 0, this, thread, l, n, bl, string2, n2);
    }

    private void recycleConnectionWaiterLocked(ConnectionWaiter connectionWaiter) {
        InvokeDynamicSupport.bootstrap("recycleConnectionWaiterLocked", $$robo$$android_database_sqlite_SQLiteConnectionPool$recycleConnectionWaiterLocked(android.database.sqlite.SQLiteConnectionPool$ConnectionWaiter ), 0, this, connectionWaiter);
    }

    public void dump(Printer printer, boolean bl) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_database_sqlite_SQLiteConnectionPool$dump(android.util.Printer boolean ), 0, this, printer, bl);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_database_sqlite_SQLiteConnectionPool$toString(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(SQLiteConnectionPool.class);
    }

    public /* synthetic */ SQLiteConnectionPool() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SQLiteConnectionPool)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class IdleConnectionHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private long mTimeout;
        /* synthetic */ SQLiteConnectionPool this$0;

        private void $$robo$$android_database_sqlite_SQLiteConnectionPool_IdleConnectionHandler$__constructor__(SQLiteConnectionPool sQLiteConnectionPool, Looper looper, long timeout) {
            this.mTimeout = timeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_database_sqlite_SQLiteConnectionPool_IdleConnectionHandler$handleMessage(Message msg) {
            Object object = this.this$0.mLock;
            synchronized (object) {
                if (this != this.this$0.mIdleConnectionHandler) {
                    return;
                }
                if (this.this$0.closeAvailableConnectionLocked(msg.what) && Log.isLoggable("SQLiteConnectionPool", 3)) {
                    Log.d("SQLiteConnectionPool", "Closed idle connection " + ((SQLiteConnectionPool)this.this$0).mConfiguration.label + " " + msg.what + " after " + this.mTimeout);
                }
            }
        }

        private final void $$robo$$android_database_sqlite_SQLiteConnectionPool_IdleConnectionHandler$connectionReleased(SQLiteConnection con) {
            this.sendEmptyMessageDelayed(con.getConnectionId(), this.mTimeout);
        }

        private final void $$robo$$android_database_sqlite_SQLiteConnectionPool_IdleConnectionHandler$connectionAcquired(SQLiteConnection con) {
            this.removeMessages(con.getConnectionId());
        }

        private final void $$robo$$android_database_sqlite_SQLiteConnectionPool_IdleConnectionHandler$connectionClosed(SQLiteConnection con) {
            this.removeMessages(con.getConnectionId());
        }

        private void __constructor__(SQLiteConnectionPool sQLiteConnectionPool, Looper looper, long l) {
            this.$$robo$$android_database_sqlite_SQLiteConnectionPool_IdleConnectionHandler$__constructor__(sQLiteConnectionPool, looper, l);
        }

        IdleConnectionHandler(SQLiteConnectionPool sQLiteConnectionPool, Looper looper, long l) {
            this.this$0 = sQLiteConnectionPool;
            super(looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_database_sqlite_SQLiteConnectionPool_IdleConnectionHandler$__constructor__(android.database.sqlite.SQLiteConnectionPool android.os.Looper long ), 0, this, sQLiteConnectionPool, looper, l);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_database_sqlite_SQLiteConnectionPool_IdleConnectionHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        void connectionReleased(SQLiteConnection sQLiteConnection) {
            InvokeDynamicSupport.bootstrap("connectionReleased", $$robo$$android_database_sqlite_SQLiteConnectionPool_IdleConnectionHandler$connectionReleased(android.database.sqlite.SQLiteConnection ), 0, this, sQLiteConnection);
        }

        void connectionAcquired(SQLiteConnection sQLiteConnection) {
            InvokeDynamicSupport.bootstrap("connectionAcquired", $$robo$$android_database_sqlite_SQLiteConnectionPool_IdleConnectionHandler$connectionAcquired(android.database.sqlite.SQLiteConnection ), 0, this, sQLiteConnection);
        }

        void connectionClosed(SQLiteConnection sQLiteConnection) {
            InvokeDynamicSupport.bootstrap("connectionClosed", $$robo$$android_database_sqlite_SQLiteConnectionPool_IdleConnectionHandler$connectionClosed(android.database.sqlite.SQLiteConnection ), 0, this, sQLiteConnection);
        }

        public /* synthetic */ IdleConnectionHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IdleConnectionHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class ConnectionWaiter
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public ConnectionWaiter mNext;
        public Thread mThread;
        public long mStartTime;
        public int mPriority;
        public boolean mWantPrimaryConnection;
        public String mSql;
        public int mConnectionFlags;
        public SQLiteConnection mAssignedConnection;
        public RuntimeException mException;
        public int mNonce;

        private void $$robo$$android_database_sqlite_SQLiteConnectionPool_ConnectionWaiter$__constructor__() {
        }

        private /* synthetic */ void $$robo$$android_database_sqlite_SQLiteConnectionPool_ConnectionWaiter$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_database_sqlite_SQLiteConnectionPool_ConnectionWaiter$__constructor__();
        }

        private ConnectionWaiter() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_database_sqlite_SQLiteConnectionPool_ConnectionWaiter$__constructor__(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_database_sqlite_SQLiteConnectionPool_ConnectionWaiter$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ConnectionWaiter)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class AcquiredConnectionStatus
    extends Enum<AcquiredConnectionStatus> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ AcquiredConnectionStatus NORMAL;
        public static /* enum */ AcquiredConnectionStatus RECONFIGURE;
        public static /* enum */ AcquiredConnectionStatus DISCARD;
        private static /* synthetic */ AcquiredConnectionStatus[] $VALUES;

        private static final AcquiredConnectionStatus[] $$robo$$android_database_sqlite_SQLiteConnectionPool_AcquiredConnectionStatus$values() {
            return (AcquiredConnectionStatus[])$VALUES.clone();
        }

        private static final AcquiredConnectionStatus $$robo$$android_database_sqlite_SQLiteConnectionPool_AcquiredConnectionStatus$valueOf(String name) {
            return Enum.valueOf(AcquiredConnectionStatus.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_database_sqlite_SQLiteConnectionPool_AcquiredConnectionStatus$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            NORMAL = new AcquiredConnectionStatus();
            RECONFIGURE = new AcquiredConnectionStatus();
            DISCARD = new AcquiredConnectionStatus();
            $VALUES = new AcquiredConnectionStatus[]{NORMAL, RECONFIGURE, DISCARD};
        }

        public static AcquiredConnectionStatus[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_database_sqlite_SQLiteConnectionPool_AcquiredConnectionStatus$values(), 0);
        }

        public static AcquiredConnectionStatus valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_database_sqlite_SQLiteConnectionPool_AcquiredConnectionStatus$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_database_sqlite_SQLiteConnectionPool_AcquiredConnectionStatus$__constructor__(string2, n);
        }

        private AcquiredConnectionStatus() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_database_sqlite_SQLiteConnectionPool_AcquiredConnectionStatus$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(AcquiredConnectionStatus.class);
        }

        public /* synthetic */ AcquiredConnectionStatus() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AcquiredConnectionStatus)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

