/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.FilterContext;
import android.filterfw.core.FilterGraph;
import android.filterfw.core.GraphRunner;
import android.filterfw.core.SimpleScheduler;
import android.filterfw.core.SyncRunner;
import android.os.AsyncTask;
import android.util.Log;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AsyncRunner
extends GraphRunner
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private Class mSchedulerClass;
    private SyncRunner mRunner;
    private AsyncRunnerTask mRunTask;
    private GraphRunner.OnRunnerDoneListener mDoneListener;
    private boolean isProcessing;
    private Exception mException;
    private boolean mLogVerbose;
    private static String TAG = "AsyncRunner";

    private void $$robo$$android_filterfw_core_AsyncRunner$__constructor__(FilterContext context, Class schedulerClass) {
        this.mSchedulerClass = schedulerClass;
        this.mLogVerbose = Log.isLoggable("AsyncRunner", 2);
    }

    private void $$robo$$android_filterfw_core_AsyncRunner$__constructor__(FilterContext context) {
        this.mSchedulerClass = SimpleScheduler.class;
        this.mLogVerbose = Log.isLoggable("AsyncRunner", 2);
    }

    private final void $$robo$$android_filterfw_core_AsyncRunner$setDoneCallback(GraphRunner.OnRunnerDoneListener listener) {
        this.mDoneListener = listener;
    }

    private final synchronized void $$robo$$android_filterfw_core_AsyncRunner$setGraph(FilterGraph graph) {
        if (this.isRunning()) {
            throw new RuntimeException("Graph is already running!");
        }
        this.mRunner = new SyncRunner(this.mFilterContext, graph, this.mSchedulerClass);
    }

    private final FilterGraph $$robo$$android_filterfw_core_AsyncRunner$getGraph() {
        return this.mRunner != null ? this.mRunner.getGraph() : null;
    }

    private final synchronized void $$robo$$android_filterfw_core_AsyncRunner$run() {
        if (this.mLogVerbose) {
            Log.v("AsyncRunner", "Running graph.");
        }
        this.setException(null);
        if (this.isRunning()) {
            throw new RuntimeException("Graph is already running!");
        }
        if (this.mRunner == null) {
            throw new RuntimeException("Cannot run before a graph is set!");
        }
        this.mRunTask = new AsyncRunnerTask(this);
        this.setRunning(true);
        this.mRunTask.execute(this.mRunner);
    }

    private final synchronized void $$robo$$android_filterfw_core_AsyncRunner$stop() {
        if (this.mRunTask != null && !this.mRunTask.isCancelled()) {
            if (this.mLogVerbose) {
                Log.v("AsyncRunner", "Stopping graph.");
            }
            this.mRunTask.cancel(false);
        }
    }

    private final synchronized void $$robo$$android_filterfw_core_AsyncRunner$close() {
        if (this.isRunning()) {
            throw new RuntimeException("Cannot close graph while it is running!");
        }
        if (this.mLogVerbose) {
            Log.v("AsyncRunner", "Closing filters.");
        }
        this.mRunner.close();
    }

    private final synchronized boolean $$robo$$android_filterfw_core_AsyncRunner$isRunning() {
        return this.isProcessing;
    }

    private final synchronized Exception $$robo$$android_filterfw_core_AsyncRunner$getError() {
        return this.mException;
    }

    private final synchronized void $$robo$$android_filterfw_core_AsyncRunner$setRunning(boolean running) {
        this.isProcessing = running;
    }

    private final synchronized void $$robo$$android_filterfw_core_AsyncRunner$setException(Exception exception) {
        this.mException = exception;
    }

    private void __constructor__(FilterContext filterContext, Class clazz) {
        this.$$robo$$android_filterfw_core_AsyncRunner$__constructor__(filterContext, clazz);
    }

    public AsyncRunner(FilterContext filterContext, Class clazz) {
        super(filterContext);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_filterfw_core_AsyncRunner$__constructor__(android.filterfw.core.FilterContext java.lang.Class ), 0, this, filterContext, clazz);
    }

    private void __constructor__(FilterContext filterContext) {
        this.$$robo$$android_filterfw_core_AsyncRunner$__constructor__(filterContext);
    }

    public AsyncRunner(FilterContext filterContext) {
        super(filterContext);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_filterfw_core_AsyncRunner$__constructor__(android.filterfw.core.FilterContext ), 0, this, filterContext);
    }

    @Override
    public void setDoneCallback(GraphRunner.OnRunnerDoneListener onRunnerDoneListener) {
        InvokeDynamicSupport.bootstrap("setDoneCallback", $$robo$$android_filterfw_core_AsyncRunner$setDoneCallback(android.filterfw.core.GraphRunner$OnRunnerDoneListener ), 0, this, onRunnerDoneListener);
    }

    public synchronized void setGraph(FilterGraph filterGraph) {
        InvokeDynamicSupport.bootstrap("setGraph", $$robo$$android_filterfw_core_AsyncRunner$setGraph(android.filterfw.core.FilterGraph ), 0, this, filterGraph);
    }

    @Override
    public FilterGraph getGraph() {
        return InvokeDynamicSupport.bootstrap("getGraph", $$robo$$android_filterfw_core_AsyncRunner$getGraph(), 0, this);
    }

    @Override
    public synchronized void run() {
        InvokeDynamicSupport.bootstrap("run", $$robo$$android_filterfw_core_AsyncRunner$run(), 0, this);
    }

    @Override
    public synchronized void stop() {
        InvokeDynamicSupport.bootstrap("stop", $$robo$$android_filterfw_core_AsyncRunner$stop(), 0, this);
    }

    @Override
    public synchronized void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_filterfw_core_AsyncRunner$close(), 0, this);
    }

    @Override
    public synchronized boolean isRunning() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRunning", $$robo$$android_filterfw_core_AsyncRunner$isRunning(), 0, this);
    }

    @Override
    public synchronized Exception getError() {
        return InvokeDynamicSupport.bootstrap("getError", $$robo$$android_filterfw_core_AsyncRunner$getError(), 0, this);
    }

    private synchronized void setRunning(boolean bl) {
        InvokeDynamicSupport.bootstrap("setRunning", $$robo$$android_filterfw_core_AsyncRunner$setRunning(boolean ), 0, this, bl);
    }

    private synchronized void setException(Exception exception) {
        InvokeDynamicSupport.bootstrap("setException", $$robo$$android_filterfw_core_AsyncRunner$setException(java.lang.Exception ), 0, this, exception);
    }

    public /* synthetic */ AsyncRunner() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AsyncRunner)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class AsyncRunnerTask
    extends AsyncTask<SyncRunner, Void, RunnerResult> {
        public transient /* synthetic */ Object __robo_data__;
        private static String TAG = "AsyncRunnerTask";
        /* synthetic */ AsyncRunner this$0;

        private void $$robo$$android_filterfw_core_AsyncRunner_AsyncRunnerTask$__constructor__(AsyncRunner asyncRunner) {
        }

        private final RunnerResult $$robo$$android_filterfw_core_AsyncRunner_AsyncRunnerTask$doInBackground(SyncRunner ... runner) {
            RunnerResult result = new RunnerResult(this.this$0);
            try {
                if (runner.length > 1) {
                    throw new RuntimeException("More than one runner received!");
                }
                runner[0].assertReadyToStep();
                if (this.this$0.mLogVerbose) {
                    Log.v("AsyncRunnerTask", "Starting background graph processing.");
                }
                this.this$0.activateGlContext();
                if (this.this$0.mLogVerbose) {
                    Log.v("AsyncRunnerTask", "Preparing filter graph for processing.");
                }
                runner[0].beginProcessing();
                if (this.this$0.mLogVerbose) {
                    Log.v("AsyncRunnerTask", "Running graph.");
                }
                result.status = 1;
                while (!this.isCancelled() && result.status == 1) {
                    if (runner[0].performStep()) continue;
                    result.status = runner[0].determinePostRunState();
                    if (result.status != 3) continue;
                    runner[0].waitUntilWake();
                    result.status = 1;
                }
                if (this.isCancelled()) {
                    result.status = 5;
                }
            }
            catch (Exception exception) {
                result.exception = exception;
                result.status = 6;
            }
            try {
                this.this$0.deactivateGlContext();
            }
            catch (Exception exception) {
                result.exception = exception;
                result.status = 6;
            }
            if (this.this$0.mLogVerbose) {
                Log.v("AsyncRunnerTask", "Done with background graph processing.");
            }
            return result;
        }

        private final void $$robo$$android_filterfw_core_AsyncRunner_AsyncRunnerTask$onCancelled(RunnerResult result) {
            this.onPostExecute(result);
        }

        private final void $$robo$$android_filterfw_core_AsyncRunner_AsyncRunnerTask$onPostExecute(RunnerResult result) {
            if (this.this$0.mLogVerbose) {
                Log.v("AsyncRunnerTask", "Starting post-execute.");
            }
            this.this$0.setRunning(false);
            if (result == null) {
                result = new RunnerResult(this.this$0);
                result.status = 5;
            }
            this.this$0.setException(result.exception);
            if (result.status == 5 || result.status == 6) {
                if (this.this$0.mLogVerbose) {
                    Log.v("AsyncRunnerTask", "Closing filters.");
                }
                try {
                    this.this$0.mRunner.close();
                }
                catch (Exception exception) {
                    result.status = 6;
                    this.this$0.setException(exception);
                }
            }
            if (this.this$0.mDoneListener != null) {
                if (this.this$0.mLogVerbose) {
                    Log.v("AsyncRunnerTask", "Calling graph done callback.");
                }
                this.this$0.mDoneListener.onRunnerDone(result.status);
            }
            if (this.this$0.mLogVerbose) {
                Log.v("AsyncRunnerTask", "Completed post-execute.");
            }
        }

        private /* synthetic */ void $$robo$$android_filterfw_core_AsyncRunner_AsyncRunnerTask$__constructor__(AsyncRunner x0, 1 x1) {
        }

        private void __constructor__(AsyncRunner asyncRunner) {
            this.$$robo$$android_filterfw_core_AsyncRunner_AsyncRunnerTask$__constructor__(asyncRunner);
        }

        private AsyncRunnerTask(AsyncRunner asyncRunner) {
            this.this$0 = asyncRunner;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_filterfw_core_AsyncRunner_AsyncRunnerTask$__constructor__(android.filterfw.core.AsyncRunner ), 0, this, asyncRunner);
        }

        protected RunnerResult doInBackground(SyncRunner ... syncRunnerArray) {
            return InvokeDynamicSupport.bootstrap("doInBackground", $$robo$$android_filterfw_core_AsyncRunner_AsyncRunnerTask$doInBackground(android.filterfw.core.SyncRunner[] ), 0, this, syncRunnerArray);
        }

        @Override
        protected void onCancelled(RunnerResult runnerResult) {
            InvokeDynamicSupport.bootstrap("onCancelled", $$robo$$android_filterfw_core_AsyncRunner_AsyncRunnerTask$onCancelled(android.filterfw.core.AsyncRunner$RunnerResult ), 0, this, runnerResult);
        }

        @Override
        protected void onPostExecute(RunnerResult runnerResult) {
            InvokeDynamicSupport.bootstrap("onPostExecute", $$robo$$android_filterfw_core_AsyncRunner_AsyncRunnerTask$onPostExecute(android.filterfw.core.AsyncRunner$RunnerResult ), 0, this, runnerResult);
        }

        private /* synthetic */ void __constructor__(AsyncRunner asyncRunner, 1 var2_2) {
            this.$$robo$$android_filterfw_core_AsyncRunner_AsyncRunnerTask$__constructor__(asyncRunner, var2_2);
        }

        public /* synthetic */ AsyncRunnerTask() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AsyncRunnerTask)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class RunnerResult
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int status;
        public Exception exception;
        /* synthetic */ AsyncRunner this$0;

        private void $$robo$$android_filterfw_core_AsyncRunner_RunnerResult$__constructor__(AsyncRunner asyncRunner) {
            this.status = 0;
        }

        private /* synthetic */ void $$robo$$android_filterfw_core_AsyncRunner_RunnerResult$__constructor__(AsyncRunner x0, 1 x1) {
        }

        private void __constructor__(AsyncRunner asyncRunner) {
            this.$$robo$$android_filterfw_core_AsyncRunner_RunnerResult$__constructor__(asyncRunner);
        }

        private RunnerResult(AsyncRunner asyncRunner) {
            this.this$0 = asyncRunner;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_filterfw_core_AsyncRunner_RunnerResult$__constructor__(android.filterfw.core.AsyncRunner ), 0, this, asyncRunner);
        }

        private /* synthetic */ void __constructor__(AsyncRunner asyncRunner, 1 var2_2) {
            this.$$robo$$android_filterfw_core_AsyncRunner_RunnerResult$__constructor__(asyncRunner, var2_2);
        }

        public /* synthetic */ RunnerResult() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RunnerResult)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

