/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.InputPort;
import android.filterfw.core.KeyValueMap;
import android.filterfw.core.OutputPort;
import android.filterpacks.base.FrameBranch;
import android.filterpacks.base.NullFilter;
import android.util.Log;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class FilterGraph
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private HashSet<Filter> mFilters;
    private HashMap<String, Filter> mNameMap;
    private HashMap<OutputPort, LinkedList<InputPort>> mPreconnections;
    public static int AUTOBRANCH_OFF = 0;
    public static int AUTOBRANCH_SYNCED = 1;
    public static int AUTOBRANCH_UNSYNCED = 2;
    public static int TYPECHECK_OFF = 0;
    public static int TYPECHECK_DYNAMIC = 1;
    public static int TYPECHECK_STRICT = 2;
    private boolean mIsReady;
    private int mAutoBranchMode;
    private int mTypeCheckMode;
    private boolean mDiscardUnconnectedOutputs;
    private boolean mLogVerbose;
    private String TAG;

    private void $$robo$$android_filterfw_core_FilterGraph$__constructor__() {
        this.mFilters = new HashSet();
        this.mNameMap = new HashMap();
        this.mPreconnections = new HashMap();
        this.mIsReady = false;
        this.mAutoBranchMode = 0;
        this.mTypeCheckMode = 2;
        this.mDiscardUnconnectedOutputs = false;
        this.TAG = "FilterGraph";
        this.mLogVerbose = Log.isLoggable(this.TAG, 2);
    }

    private final boolean $$robo$$android_filterfw_core_FilterGraph$addFilter(Filter filter) {
        if (!this.containsFilter(filter)) {
            this.mFilters.add(filter);
            this.mNameMap.put(filter.getName(), filter);
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_filterfw_core_FilterGraph$containsFilter(Filter filter) {
        return this.mFilters.contains(filter);
    }

    private final Filter $$robo$$android_filterfw_core_FilterGraph$getFilter(String name) {
        return this.mNameMap.get(name);
    }

    private final void $$robo$$android_filterfw_core_FilterGraph$connect(Filter source, String outputName, Filter target, String inputName) {
        if (source == null || target == null) {
            throw new IllegalArgumentException("Passing null Filter in connect()!");
        }
        if (!this.containsFilter(source) || !this.containsFilter(target)) {
            throw new RuntimeException("Attempting to connect filter not in graph!");
        }
        OutputPort outPort = source.getOutputPort(outputName);
        InputPort inPort = target.getInputPort(inputName);
        if (outPort == null) {
            throw new RuntimeException("Unknown output port '" + outputName + "' on Filter " + source + "!");
        }
        if (inPort == null) {
            throw new RuntimeException("Unknown input port '" + inputName + "' on Filter " + target + "!");
        }
        this.preconnect(outPort, inPort);
    }

    private final void $$robo$$android_filterfw_core_FilterGraph$connect(String sourceName, String outputName, String targetName, String inputName) {
        Filter source = this.getFilter(sourceName);
        Filter target = this.getFilter(targetName);
        if (source == null) {
            throw new RuntimeException("Attempting to connect unknown source filter '" + sourceName + "'!");
        }
        if (target == null) {
            throw new RuntimeException("Attempting to connect unknown target filter '" + targetName + "'!");
        }
        this.connect(source, outputName, target, inputName);
    }

    private final Set<Filter> $$robo$$android_filterfw_core_FilterGraph$getFilters() {
        return this.mFilters;
    }

    private final void $$robo$$android_filterfw_core_FilterGraph$beginProcessing() {
        if (this.mLogVerbose) {
            Log.v(this.TAG, "Opening all filter connections...");
        }
        for (Filter filter : this.mFilters) {
            filter.openOutputs();
        }
        this.mIsReady = true;
    }

    private final void $$robo$$android_filterfw_core_FilterGraph$flushFrames() {
        for (Filter filter : this.mFilters) {
            filter.clearOutputs();
        }
    }

    private final void $$robo$$android_filterfw_core_FilterGraph$closeFilters(FilterContext context) {
        if (this.mLogVerbose) {
            Log.v(this.TAG, "Closing all filters...");
        }
        for (Filter filter : this.mFilters) {
            filter.performClose(context);
        }
        this.mIsReady = false;
    }

    private final boolean $$robo$$android_filterfw_core_FilterGraph$isReady() {
        return this.mIsReady;
    }

    private final void $$robo$$android_filterfw_core_FilterGraph$setAutoBranchMode(int autoBranchMode) {
        this.mAutoBranchMode = autoBranchMode;
    }

    private final void $$robo$$android_filterfw_core_FilterGraph$setDiscardUnconnectedOutputs(boolean discard) {
        this.mDiscardUnconnectedOutputs = discard;
    }

    private final void $$robo$$android_filterfw_core_FilterGraph$setTypeCheckMode(int typeCheckMode) {
        this.mTypeCheckMode = typeCheckMode;
    }

    private final void $$robo$$android_filterfw_core_FilterGraph$tearDown(FilterContext context) {
        if (!this.mFilters.isEmpty()) {
            this.flushFrames();
            for (Filter filter : this.mFilters) {
                filter.performTearDown(context);
            }
            this.mFilters.clear();
            this.mNameMap.clear();
            this.mIsReady = false;
        }
    }

    private final boolean $$robo$$android_filterfw_core_FilterGraph$readyForProcessing(Filter filter, Set<Filter> processed) {
        if (processed.contains(filter)) {
            return false;
        }
        for (InputPort port : filter.getInputPorts()) {
            Filter dependency = port.getSourceFilter();
            if (dependency == null || processed.contains(dependency)) continue;
            return false;
        }
        return true;
    }

    private final void $$robo$$android_filterfw_core_FilterGraph$runTypeCheck() {
        Stack<Filter> filterStack = new Stack<Filter>();
        HashSet<Filter> processedFilters = new HashSet<Filter>();
        filterStack.addAll(this.getSourceFilters());
        while (!filterStack.empty()) {
            Filter filter = (Filter)filterStack.pop();
            processedFilters.add(filter);
            this.updateOutputs(filter);
            if (this.mLogVerbose) {
                Log.v(this.TAG, "Running type check on " + filter + "...");
            }
            this.runTypeCheckOn(filter);
            for (OutputPort port : filter.getOutputPorts()) {
                Filter target = port.getTargetFilter();
                if (target == null || !this.readyForProcessing(target, processedFilters)) continue;
                filterStack.push(target);
            }
        }
        if (processedFilters.size() != this.getFilters().size()) {
            throw new RuntimeException("Could not schedule all filters! Is your graph malformed?");
        }
    }

    private final void $$robo$$android_filterfw_core_FilterGraph$updateOutputs(Filter filter) {
        for (OutputPort outputPort : filter.getOutputPorts()) {
            InputPort inputPort = outputPort.getBasePort();
            if (inputPort == null) continue;
            FrameFormat inputFormat = inputPort.getSourceFormat();
            FrameFormat outputFormat = filter.getOutputFormat(outputPort.getName(), inputFormat);
            if (outputFormat == null) {
                throw new RuntimeException("Filter did not return an output format for " + outputPort + "!");
            }
            outputPort.setPortFormat(outputFormat);
        }
    }

    private final void $$robo$$android_filterfw_core_FilterGraph$runTypeCheckOn(Filter filter) {
        for (InputPort inputPort : filter.getInputPorts()) {
            if (this.mLogVerbose) {
                Log.v(this.TAG, "Type checking port " + inputPort);
            }
            FrameFormat sourceFormat = inputPort.getSourceFormat();
            FrameFormat targetFormat = inputPort.getPortFormat();
            if (sourceFormat == null || targetFormat == null) continue;
            if (this.mLogVerbose) {
                Log.v(this.TAG, "Checking " + sourceFormat + " against " + targetFormat + ".");
            }
            boolean compatible = true;
            switch (this.mTypeCheckMode) {
                case 0: {
                    inputPort.setChecksType(false);
                    break;
                }
                case 1: {
                    compatible = sourceFormat.mayBeCompatibleWith(targetFormat);
                    inputPort.setChecksType(true);
                    break;
                }
                case 2: {
                    compatible = sourceFormat.isCompatibleWith(targetFormat);
                    inputPort.setChecksType(false);
                }
            }
            if (compatible) continue;
            throw new RuntimeException("Type mismatch: Filter " + filter + " expects a " + "format of type " + targetFormat + " but got a format of type " + sourceFormat + "!");
        }
    }

    private final void $$robo$$android_filterfw_core_FilterGraph$checkConnections() {
    }

    private final void $$robo$$android_filterfw_core_FilterGraph$discardUnconnectedOutputs() {
        LinkedList<NullFilter> addedFilters = new LinkedList<NullFilter>();
        for (Filter filter : this.mFilters) {
            int id2 = 0;
            for (OutputPort port : filter.getOutputPorts()) {
                if (port.isConnected()) continue;
                if (this.mLogVerbose) {
                    Log.v(this.TAG, "Autoconnecting unconnected " + port + " to Null filter.");
                }
                NullFilter nullFilter = new NullFilter(filter.getName() + "ToNull" + id2);
                nullFilter.init();
                addedFilters.add(nullFilter);
                port.connectTo(nullFilter.getInputPort("frame"));
                ++id2;
            }
        }
        for (Filter filter : addedFilters) {
            this.addFilter(filter);
        }
    }

    private final void $$robo$$android_filterfw_core_FilterGraph$removeFilter(Filter filter) {
        this.mFilters.remove(filter);
        this.mNameMap.remove(filter.getName());
    }

    private final void $$robo$$android_filterfw_core_FilterGraph$preconnect(OutputPort outPort, InputPort inPort) {
        LinkedList<InputPort> targets = this.mPreconnections.get(outPort);
        if (targets == null) {
            targets = new LinkedList();
            this.mPreconnections.put(outPort, targets);
        }
        targets.add(inPort);
    }

    private final void $$robo$$android_filterfw_core_FilterGraph$connectPorts() {
        int branchId = 1;
        for (Map.Entry<OutputPort, LinkedList<InputPort>> connection : this.mPreconnections.entrySet()) {
            OutputPort outputPort = connection.getKey();
            LinkedList<InputPort> inputPorts = connection.getValue();
            if (inputPorts.size() == 1) {
                outputPort.connectTo(inputPorts.get(0));
                continue;
            }
            if (this.mAutoBranchMode == 0) {
                throw new RuntimeException("Attempting to connect " + outputPort + " to multiple " + "filter ports! Enable auto-branching to allow this.");
            }
            if (this.mLogVerbose) {
                Log.v(this.TAG, "Creating branch for " + outputPort + "!");
            }
            FrameBranch branch = null;
            if (this.mAutoBranchMode != 1) {
                throw new RuntimeException("TODO: Unsynced branches not implemented yet!");
            }
            branch = new FrameBranch("branch" + branchId++);
            KeyValueMap branchParams = new KeyValueMap();
            branch.initWithAssignmentList("outputs", inputPorts.size());
            this.addFilter(branch);
            outputPort.connectTo(branch.getInputPort("in"));
            Iterator inputPortIter = inputPorts.iterator();
            for (OutputPort branchOutPort : branch.getOutputPorts()) {
                branchOutPort.connectTo((InputPort)inputPortIter.next());
            }
        }
        this.mPreconnections.clear();
    }

    private final HashSet<Filter> $$robo$$android_filterfw_core_FilterGraph$getSourceFilters() {
        HashSet<Filter> sourceFilters = new HashSet<Filter>();
        for (Filter filter : this.getFilters()) {
            if (filter.getNumberOfConnectedInputs() != 0) continue;
            if (this.mLogVerbose) {
                Log.v(this.TAG, "Found source filter: " + filter);
            }
            sourceFilters.add(filter);
        }
        return sourceFilters;
    }

    private final void $$robo$$android_filterfw_core_FilterGraph$setupFilters() {
        if (this.mDiscardUnconnectedOutputs) {
            this.discardUnconnectedOutputs();
        }
        this.connectPorts();
        this.checkConnections();
        this.runTypeCheck();
    }

    private void __constructor__() {
        this.$$robo$$android_filterfw_core_FilterGraph$__constructor__();
    }

    public FilterGraph() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_filterfw_core_FilterGraph$__constructor__(), 0, this);
    }

    public boolean addFilter(Filter filter) {
        return (boolean)InvokeDynamicSupport.bootstrap("addFilter", $$robo$$android_filterfw_core_FilterGraph$addFilter(android.filterfw.core.Filter ), 0, this, filter);
    }

    public boolean containsFilter(Filter filter) {
        return (boolean)InvokeDynamicSupport.bootstrap("containsFilter", $$robo$$android_filterfw_core_FilterGraph$containsFilter(android.filterfw.core.Filter ), 0, this, filter);
    }

    public Filter getFilter(String string2) {
        return InvokeDynamicSupport.bootstrap("getFilter", $$robo$$android_filterfw_core_FilterGraph$getFilter(java.lang.String ), 0, this, string2);
    }

    public void connect(Filter filter, String string2, Filter filter2, String string3) {
        InvokeDynamicSupport.bootstrap("connect", $$robo$$android_filterfw_core_FilterGraph$connect(android.filterfw.core.Filter java.lang.String android.filterfw.core.Filter java.lang.String ), 0, this, filter, string2, filter2, string3);
    }

    public void connect(String string2, String string3, String string4, String string5) {
        InvokeDynamicSupport.bootstrap("connect", $$robo$$android_filterfw_core_FilterGraph$connect(java.lang.String java.lang.String java.lang.String java.lang.String ), 0, this, string2, string3, string4, string5);
    }

    public Set<Filter> getFilters() {
        return InvokeDynamicSupport.bootstrap("getFilters", $$robo$$android_filterfw_core_FilterGraph$getFilters(), 0, this);
    }

    public void beginProcessing() {
        InvokeDynamicSupport.bootstrap("beginProcessing", $$robo$$android_filterfw_core_FilterGraph$beginProcessing(), 0, this);
    }

    public void flushFrames() {
        InvokeDynamicSupport.bootstrap("flushFrames", $$robo$$android_filterfw_core_FilterGraph$flushFrames(), 0, this);
    }

    public void closeFilters(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("closeFilters", $$robo$$android_filterfw_core_FilterGraph$closeFilters(android.filterfw.core.FilterContext ), 0, this, filterContext);
    }

    public boolean isReady() {
        return (boolean)InvokeDynamicSupport.bootstrap("isReady", $$robo$$android_filterfw_core_FilterGraph$isReady(), 0, this);
    }

    public void setAutoBranchMode(int n) {
        InvokeDynamicSupport.bootstrap("setAutoBranchMode", $$robo$$android_filterfw_core_FilterGraph$setAutoBranchMode(int ), 0, this, n);
    }

    public void setDiscardUnconnectedOutputs(boolean bl) {
        InvokeDynamicSupport.bootstrap("setDiscardUnconnectedOutputs", $$robo$$android_filterfw_core_FilterGraph$setDiscardUnconnectedOutputs(boolean ), 0, this, bl);
    }

    public void setTypeCheckMode(int n) {
        InvokeDynamicSupport.bootstrap("setTypeCheckMode", $$robo$$android_filterfw_core_FilterGraph$setTypeCheckMode(int ), 0, this, n);
    }

    public void tearDown(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("tearDown", $$robo$$android_filterfw_core_FilterGraph$tearDown(android.filterfw.core.FilterContext ), 0, this, filterContext);
    }

    private boolean readyForProcessing(Filter filter, Set<Filter> set) {
        return (boolean)InvokeDynamicSupport.bootstrap("readyForProcessing", $$robo$$android_filterfw_core_FilterGraph$readyForProcessing(android.filterfw.core.Filter java.util.Set<android.filterfw.core.Filter> ), 0, this, filter, set);
    }

    private void runTypeCheck() {
        InvokeDynamicSupport.bootstrap("runTypeCheck", $$robo$$android_filterfw_core_FilterGraph$runTypeCheck(), 0, this);
    }

    private void updateOutputs(Filter filter) {
        InvokeDynamicSupport.bootstrap("updateOutputs", $$robo$$android_filterfw_core_FilterGraph$updateOutputs(android.filterfw.core.Filter ), 0, this, filter);
    }

    private void runTypeCheckOn(Filter filter) {
        InvokeDynamicSupport.bootstrap("runTypeCheckOn", $$robo$$android_filterfw_core_FilterGraph$runTypeCheckOn(android.filterfw.core.Filter ), 0, this, filter);
    }

    private void checkConnections() {
        InvokeDynamicSupport.bootstrap("checkConnections", $$robo$$android_filterfw_core_FilterGraph$checkConnections(), 0, this);
    }

    private void discardUnconnectedOutputs() {
        InvokeDynamicSupport.bootstrap("discardUnconnectedOutputs", $$robo$$android_filterfw_core_FilterGraph$discardUnconnectedOutputs(), 0, this);
    }

    private void removeFilter(Filter filter) {
        InvokeDynamicSupport.bootstrap("removeFilter", $$robo$$android_filterfw_core_FilterGraph$removeFilter(android.filterfw.core.Filter ), 0, this, filter);
    }

    private void preconnect(OutputPort outputPort, InputPort inputPort) {
        InvokeDynamicSupport.bootstrap("preconnect", $$robo$$android_filterfw_core_FilterGraph$preconnect(android.filterfw.core.OutputPort android.filterfw.core.InputPort ), 0, this, outputPort, inputPort);
    }

    private void connectPorts() {
        InvokeDynamicSupport.bootstrap("connectPorts", $$robo$$android_filterfw_core_FilterGraph$connectPorts(), 0, this);
    }

    private HashSet<Filter> getSourceFilters() {
        return InvokeDynamicSupport.bootstrap("getSourceFilters", $$robo$$android_filterfw_core_FilterGraph$getSourceFilters(), 0, this);
    }

    void setupFilters() {
        InvokeDynamicSupport.bootstrap("setupFilters", $$robo$$android_filterfw_core_FilterGraph$setupFilters(), 0, this);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FilterGraph)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

