/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.BaseCanvas;
import android.graphics.Bitmap;
import android.graphics.DrawFilter;
import android.graphics.Matrix;
import android.graphics.NinePatch;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Picture;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import com.google.errorprone.annotations.DoNotMock;
import dalvik.annotation.optimization.CriticalNative;
import dalvik.annotation.optimization.FastNative;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import javax.microedition.khronos.opengles.GL;
import libcore.util.NativeAllocationRegistry;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Canvas
extends BaseCanvas
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static boolean sCompatibilityRestore;
    public static boolean sCompatibilitySetBitmap;
    private Bitmap mBitmap;
    private DrawFilter mDrawFilter;
    private static int MAXMIMUM_BITMAP_SIZE = 32766;
    private static long NATIVE_ALLOCATION_SIZE = 525L;
    private Runnable mFinalizer;
    public static int MATRIX_SAVE_FLAG = 1;
    public static int CLIP_SAVE_FLAG = 2;
    public static int HAS_ALPHA_LAYER_SAVE_FLAG = 4;
    public static int FULL_COLOR_LAYER_SAVE_FLAG = 8;
    public static int CLIP_TO_LAYER_SAVE_FLAG = 16;
    public static int ALL_SAVE_FLAG = 31;

    private final long $$robo$$android_graphics_Canvas$getNativeCanvasWrapper() {
        return this.mNativeCanvasWrapper;
    }

    private final boolean $$robo$$android_graphics_Canvas$isRecordingFor(Object o) {
        return false;
    }

    private void $$robo$$android_graphics_Canvas$__constructor__() {
        if (!this.isHardwareAccelerated()) {
            this.mNativeCanvasWrapper = Canvas.nInitRaster(null);
            this.mFinalizer = NoImagePreloadHolder.sRegistry.registerNativeAllocation((Object)this, this.mNativeCanvasWrapper);
        } else {
            this.mFinalizer = null;
        }
    }

    private void $$robo$$android_graphics_Canvas$__constructor__(Bitmap bitmap) {
        if (!bitmap.isMutable()) {
            throw new IllegalStateException("Immutable bitmap passed to Canvas constructor");
        }
        this.throwIfCannotDraw(bitmap);
        this.mNativeCanvasWrapper = Canvas.nInitRaster(bitmap);
        this.mFinalizer = NoImagePreloadHolder.sRegistry.registerNativeAllocation((Object)this, this.mNativeCanvasWrapper);
        this.mBitmap = bitmap;
        this.mDensity = bitmap.mDensity;
    }

    private void $$robo$$android_graphics_Canvas$__constructor__(long nativeCanvas) {
        if (nativeCanvas == 0L) {
            throw new IllegalStateException();
        }
        this.mNativeCanvasWrapper = nativeCanvas;
        this.mFinalizer = NoImagePreloadHolder.sRegistry.registerNativeAllocation((Object)this, this.mNativeCanvasWrapper);
        this.mDensity = Bitmap.getDefaultDensity();
    }

    @Deprecated
    private final GL $$robo$$android_graphics_Canvas$getGL() {
        return null;
    }

    private final boolean $$robo$$android_graphics_Canvas$isHardwareAccelerated() {
        return false;
    }

    private final void $$robo$$android_graphics_Canvas$setBitmap(Bitmap bitmap) {
        if (this.isHardwareAccelerated()) {
            throw new RuntimeException("Can't set a bitmap device on a HW accelerated canvas");
        }
        Matrix preservedMatrix = null;
        if (bitmap != null && sCompatibilitySetBitmap) {
            preservedMatrix = this.getMatrix();
        }
        if (bitmap == null) {
            Canvas.nSetBitmap(this.mNativeCanvasWrapper, null);
            this.mDensity = 0;
        } else {
            if (!bitmap.isMutable()) {
                throw new IllegalStateException();
            }
            this.throwIfCannotDraw(bitmap);
            Canvas.nSetBitmap(this.mNativeCanvasWrapper, bitmap);
            this.mDensity = bitmap.mDensity;
        }
        if (preservedMatrix != null) {
            this.setMatrix(preservedMatrix);
        }
        this.mBitmap = bitmap;
    }

    private final void $$robo$$android_graphics_Canvas$setHighContrastText(boolean highContrastText) {
        Canvas.nSetHighContrastText(this.mNativeCanvasWrapper, highContrastText);
    }

    private final void $$robo$$android_graphics_Canvas$insertReorderBarrier() {
    }

    private final void $$robo$$android_graphics_Canvas$insertInorderBarrier() {
    }

    private final boolean $$robo$$android_graphics_Canvas$isOpaque() {
        return Canvas.nIsOpaque(this.mNativeCanvasWrapper);
    }

    private final int $$robo$$android_graphics_Canvas$getWidth() {
        return Canvas.nGetWidth(this.mNativeCanvasWrapper);
    }

    private final int $$robo$$android_graphics_Canvas$getHeight() {
        return Canvas.nGetHeight(this.mNativeCanvasWrapper);
    }

    private final int $$robo$$android_graphics_Canvas$getDensity() {
        return this.mDensity;
    }

    private final void $$robo$$android_graphics_Canvas$setDensity(int density) {
        if (this.mBitmap != null) {
            this.mBitmap.setDensity(density);
        }
        this.mDensity = density;
    }

    private final void $$robo$$android_graphics_Canvas$setScreenDensity(int density) {
        this.mScreenDensity = density;
    }

    private final int $$robo$$android_graphics_Canvas$getMaximumBitmapWidth() {
        return 32766;
    }

    private final int $$robo$$android_graphics_Canvas$getMaximumBitmapHeight() {
        return 32766;
    }

    private final int $$robo$$android_graphics_Canvas$save() {
        return Canvas.nSave(this.mNativeCanvasWrapper, 3);
    }

    private final int $$robo$$android_graphics_Canvas$save(int saveFlags) {
        return Canvas.nSave(this.mNativeCanvasWrapper, saveFlags);
    }

    private final int $$robo$$android_graphics_Canvas$saveLayer(RectF bounds, Paint paint, int saveFlags) {
        if (bounds == null) {
            bounds = new RectF(this.getClipBounds());
        }
        return this.saveLayer(bounds.left, bounds.top, bounds.right, bounds.bottom, paint, saveFlags);
    }

    private final int $$robo$$android_graphics_Canvas$saveLayer(RectF bounds, Paint paint) {
        return this.saveLayer(bounds, paint, 31);
    }

    private final int $$robo$$android_graphics_Canvas$saveLayer(float left, float top, float right, float bottom, Paint paint, int saveFlags) {
        return Canvas.nSaveLayer(this.mNativeCanvasWrapper, left, top, right, bottom, paint != null ? paint.getNativeInstance() : 0L, saveFlags);
    }

    private final int $$robo$$android_graphics_Canvas$saveLayer(float left, float top, float right, float bottom, Paint paint) {
        return this.saveLayer(left, top, right, bottom, paint, 31);
    }

    private final int $$robo$$android_graphics_Canvas$saveLayerAlpha(RectF bounds, int alpha, int saveFlags) {
        if (bounds == null) {
            bounds = new RectF(this.getClipBounds());
        }
        return this.saveLayerAlpha(bounds.left, bounds.top, bounds.right, bounds.bottom, alpha, saveFlags);
    }

    private final int $$robo$$android_graphics_Canvas$saveLayerAlpha(RectF bounds, int alpha) {
        return this.saveLayerAlpha(bounds, alpha, 31);
    }

    private final int $$robo$$android_graphics_Canvas$saveLayerAlpha(float left, float top, float right, float bottom, int alpha, int saveFlags) {
        alpha = Math.min(255, Math.max(0, alpha));
        return Canvas.nSaveLayerAlpha(this.mNativeCanvasWrapper, left, top, right, bottom, alpha, saveFlags);
    }

    private final int $$robo$$android_graphics_Canvas$saveLayerAlpha(float left, float top, float right, float bottom, int alpha) {
        return this.saveLayerAlpha(left, top, right, bottom, alpha, 31);
    }

    private final void $$robo$$android_graphics_Canvas$restore() {
        if (!(Canvas.nRestore(this.mNativeCanvasWrapper) || sCompatibilityRestore && this.isHardwareAccelerated())) {
            throw new IllegalStateException("Underflow in restore - more restores than saves");
        }
    }

    private final int $$robo$$android_graphics_Canvas$getSaveCount() {
        return Canvas.nGetSaveCount(this.mNativeCanvasWrapper);
    }

    private final void $$robo$$android_graphics_Canvas$restoreToCount(int saveCount) {
        if (saveCount < 1) {
            if (!sCompatibilityRestore || !this.isHardwareAccelerated()) {
                throw new IllegalArgumentException("Underflow in restoreToCount - more restores than saves");
            }
            saveCount = 1;
        }
        Canvas.nRestoreToCount(this.mNativeCanvasWrapper, saveCount);
    }

    private final void $$robo$$android_graphics_Canvas$translate(float dx, float dy) {
        if (dx == 0.0f && dy == 0.0f) {
            return;
        }
        Canvas.nTranslate(this.mNativeCanvasWrapper, dx, dy);
    }

    private final void $$robo$$android_graphics_Canvas$scale(float sx, float sy) {
        if (sx == 1.0f && sy == 1.0f) {
            return;
        }
        Canvas.nScale(this.mNativeCanvasWrapper, sx, sy);
    }

    private final void $$robo$$android_graphics_Canvas$scale(float sx, float sy, float px, float py) {
        if (sx == 1.0f && sy == 1.0f) {
            return;
        }
        this.translate(px, py);
        this.scale(sx, sy);
        this.translate(-px, -py);
    }

    private final void $$robo$$android_graphics_Canvas$rotate(float degrees) {
        if (degrees == 0.0f) {
            return;
        }
        Canvas.nRotate(this.mNativeCanvasWrapper, degrees);
    }

    private final void $$robo$$android_graphics_Canvas$rotate(float degrees, float px, float py) {
        if (degrees == 0.0f) {
            return;
        }
        this.translate(px, py);
        this.rotate(degrees);
        this.translate(-px, -py);
    }

    private final void $$robo$$android_graphics_Canvas$skew(float sx, float sy) {
        if (sx == 0.0f && sy == 0.0f) {
            return;
        }
        Canvas.nSkew(this.mNativeCanvasWrapper, sx, sy);
    }

    private final void $$robo$$android_graphics_Canvas$concat(Matrix matrix) {
        if (matrix != null) {
            Canvas.nConcat(this.mNativeCanvasWrapper, matrix.native_instance);
        }
    }

    private final void $$robo$$android_graphics_Canvas$setMatrix(Matrix matrix) {
        Canvas.nSetMatrix(this.mNativeCanvasWrapper, matrix == null ? 0L : matrix.native_instance);
    }

    @Deprecated
    private final void $$robo$$android_graphics_Canvas$getMatrix(Matrix ctm) {
        Canvas.nGetMatrix(this.mNativeCanvasWrapper, ctm.native_instance);
    }

    @Deprecated
    private final Matrix $$robo$$android_graphics_Canvas$getMatrix() {
        Matrix m = new Matrix();
        this.getMatrix(m);
        return m;
    }

    @Deprecated
    private final boolean $$robo$$android_graphics_Canvas$clipRect(RectF rect, Region.Op op) {
        return Canvas.nClipRect(this.mNativeCanvasWrapper, rect.left, rect.top, rect.right, rect.bottom, op.nativeInt);
    }

    @Deprecated
    private final boolean $$robo$$android_graphics_Canvas$clipRect(Rect rect, Region.Op op) {
        return Canvas.nClipRect(this.mNativeCanvasWrapper, rect.left, rect.top, rect.right, rect.bottom, op.nativeInt);
    }

    private final boolean $$robo$$android_graphics_Canvas$clipRect(RectF rect) {
        return Canvas.nClipRect(this.mNativeCanvasWrapper, rect.left, rect.top, rect.right, rect.bottom, Region.Op.INTERSECT.nativeInt);
    }

    private final boolean $$robo$$android_graphics_Canvas$clipOutRect(RectF rect) {
        return Canvas.nClipRect(this.mNativeCanvasWrapper, rect.left, rect.top, rect.right, rect.bottom, Region.Op.DIFFERENCE.nativeInt);
    }

    private final boolean $$robo$$android_graphics_Canvas$clipRect(Rect rect) {
        return Canvas.nClipRect(this.mNativeCanvasWrapper, rect.left, rect.top, rect.right, rect.bottom, Region.Op.INTERSECT.nativeInt);
    }

    private final boolean $$robo$$android_graphics_Canvas$clipOutRect(Rect rect) {
        return Canvas.nClipRect(this.mNativeCanvasWrapper, rect.left, rect.top, rect.right, rect.bottom, Region.Op.DIFFERENCE.nativeInt);
    }

    @Deprecated
    private final boolean $$robo$$android_graphics_Canvas$clipRect(float left, float top, float right, float bottom, Region.Op op) {
        return Canvas.nClipRect(this.mNativeCanvasWrapper, left, top, right, bottom, op.nativeInt);
    }

    private final boolean $$robo$$android_graphics_Canvas$clipRect(float left, float top, float right, float bottom) {
        return Canvas.nClipRect(this.mNativeCanvasWrapper, left, top, right, bottom, Region.Op.INTERSECT.nativeInt);
    }

    private final boolean $$robo$$android_graphics_Canvas$clipOutRect(float left, float top, float right, float bottom) {
        return Canvas.nClipRect(this.mNativeCanvasWrapper, left, top, right, bottom, Region.Op.DIFFERENCE.nativeInt);
    }

    private final boolean $$robo$$android_graphics_Canvas$clipRect(int left, int top, int right, int bottom) {
        return Canvas.nClipRect(this.mNativeCanvasWrapper, left, top, right, bottom, Region.Op.INTERSECT.nativeInt);
    }

    private final boolean $$robo$$android_graphics_Canvas$clipOutRect(int left, int top, int right, int bottom) {
        return Canvas.nClipRect(this.mNativeCanvasWrapper, left, top, right, bottom, Region.Op.DIFFERENCE.nativeInt);
    }

    @Deprecated
    private final boolean $$robo$$android_graphics_Canvas$clipPath(Path path, Region.Op op) {
        return Canvas.nClipPath(this.mNativeCanvasWrapper, path.readOnlyNI(), op.nativeInt);
    }

    private final boolean $$robo$$android_graphics_Canvas$clipPath(Path path) {
        return this.clipPath(path, Region.Op.INTERSECT);
    }

    private final boolean $$robo$$android_graphics_Canvas$clipOutPath(Path path) {
        return this.clipPath(path, Region.Op.DIFFERENCE);
    }

    @Deprecated
    private final boolean $$robo$$android_graphics_Canvas$clipRegion(Region region, Region.Op op) {
        return false;
    }

    @Deprecated
    private final boolean $$robo$$android_graphics_Canvas$clipRegion(Region region) {
        return false;
    }

    private final DrawFilter $$robo$$android_graphics_Canvas$getDrawFilter() {
        return this.mDrawFilter;
    }

    private final void $$robo$$android_graphics_Canvas$setDrawFilter(DrawFilter filter) {
        long nativeFilter = 0L;
        if (filter != null) {
            nativeFilter = filter.mNativeInt;
        }
        this.mDrawFilter = filter;
        Canvas.nSetDrawFilter(this.mNativeCanvasWrapper, nativeFilter);
    }

    private final boolean $$robo$$android_graphics_Canvas$quickReject(RectF rect, EdgeType type) {
        return Canvas.nQuickReject(this.mNativeCanvasWrapper, rect.left, rect.top, rect.right, rect.bottom);
    }

    private final boolean $$robo$$android_graphics_Canvas$quickReject(Path path, EdgeType type) {
        return Canvas.nQuickReject(this.mNativeCanvasWrapper, path.readOnlyNI());
    }

    private final boolean $$robo$$android_graphics_Canvas$quickReject(float left, float top, float right, float bottom, EdgeType type) {
        return Canvas.nQuickReject(this.mNativeCanvasWrapper, left, top, right, bottom);
    }

    private final boolean $$robo$$android_graphics_Canvas$getClipBounds(Rect bounds) {
        return Canvas.nGetClipBounds(this.mNativeCanvasWrapper, bounds);
    }

    private final Rect $$robo$$android_graphics_Canvas$getClipBounds() {
        Rect r = new Rect();
        this.getClipBounds(r);
        return r;
    }

    private final void $$robo$$android_graphics_Canvas$drawPicture(Picture picture) {
        picture.endRecording();
        int restoreCount = this.save();
        picture.draw(this);
        this.restoreToCount(restoreCount);
    }

    private final void $$robo$$android_graphics_Canvas$drawPicture(Picture picture, RectF dst) {
        this.save();
        this.translate(dst.left, dst.top);
        if (picture.getWidth() > 0 && picture.getHeight() > 0) {
            this.scale(dst.width() / (float)picture.getWidth(), dst.height() / (float)picture.getHeight());
        }
        this.drawPicture(picture);
        this.restore();
    }

    private final void $$robo$$android_graphics_Canvas$drawPicture(Picture picture, Rect dst) {
        this.save();
        this.translate(dst.left, dst.top);
        if (picture.getWidth() > 0 && picture.getHeight() > 0) {
            this.scale((float)dst.width() / (float)picture.getWidth(), (float)dst.height() / (float)picture.getHeight());
        }
        this.drawPicture(picture);
        this.restore();
    }

    private final void $$robo$$android_graphics_Canvas$release() {
        this.mNativeCanvasWrapper = 0L;
        if (this.mFinalizer != null) {
            this.mFinalizer.run();
            this.mFinalizer = null;
        }
    }

    private static final void $$robo$$android_graphics_Canvas$freeCaches() {
        Canvas.nFreeCaches();
    }

    private static final void $$robo$$android_graphics_Canvas$freeTextLayoutCaches() {
        Canvas.nFreeTextLayoutCaches();
    }

    private static final void $$robo$$android_graphics_Canvas$nFreeCaches() {
    }

    private static final void $$robo$$android_graphics_Canvas$nFreeTextLayoutCaches() {
    }

    private static final long $$robo$$android_graphics_Canvas$nInitRaster(Bitmap bitmap) {
        return 0L;
    }

    private static final long $$robo$$android_graphics_Canvas$nGetNativeFinalizer() {
        return 0L;
    }

    @FastNative
    private static final void $$robo$$android_graphics_Canvas$nSetBitmap(long l, Bitmap bitmap) {
    }

    @FastNative
    private static final boolean $$robo$$android_graphics_Canvas$nGetClipBounds(long l, Rect rect) {
        return false;
    }

    @CriticalNative
    private static final boolean $$robo$$android_graphics_Canvas$nIsOpaque(long l) {
        return false;
    }

    @CriticalNative
    private static final void $$robo$$android_graphics_Canvas$nSetHighContrastText(long l, boolean bl) {
    }

    @CriticalNative
    private static final int $$robo$$android_graphics_Canvas$nGetWidth(long l) {
        return 0;
    }

    @CriticalNative
    private static final int $$robo$$android_graphics_Canvas$nGetHeight(long l) {
        return 0;
    }

    @CriticalNative
    private static final int $$robo$$android_graphics_Canvas$nSave(long l, int n) {
        return 0;
    }

    @CriticalNative
    private static final int $$robo$$android_graphics_Canvas$nSaveLayer(long l, float f, float f2, float f3, float f4, long l2, int n) {
        return 0;
    }

    @CriticalNative
    private static final int $$robo$$android_graphics_Canvas$nSaveLayerAlpha(long l, float f, float f2, float f3, float f4, int n, int n2) {
        return 0;
    }

    @CriticalNative
    private static final boolean $$robo$$android_graphics_Canvas$nRestore(long l) {
        return false;
    }

    @CriticalNative
    private static final void $$robo$$android_graphics_Canvas$nRestoreToCount(long l, int n) {
    }

    @CriticalNative
    private static final int $$robo$$android_graphics_Canvas$nGetSaveCount(long l) {
        return 0;
    }

    @CriticalNative
    private static final void $$robo$$android_graphics_Canvas$nTranslate(long l, float f, float f2) {
    }

    @CriticalNative
    private static final void $$robo$$android_graphics_Canvas$nScale(long l, float f, float f2) {
    }

    @CriticalNative
    private static final void $$robo$$android_graphics_Canvas$nRotate(long l, float f) {
    }

    @CriticalNative
    private static final void $$robo$$android_graphics_Canvas$nSkew(long l, float f, float f2) {
    }

    @CriticalNative
    private static final void $$robo$$android_graphics_Canvas$nConcat(long l, long l2) {
    }

    @CriticalNative
    private static final void $$robo$$android_graphics_Canvas$nSetMatrix(long l, long l2) {
    }

    @CriticalNative
    private static final boolean $$robo$$android_graphics_Canvas$nClipRect(long l, float f, float f2, float f3, float f4, int n) {
        return false;
    }

    @CriticalNative
    private static final boolean $$robo$$android_graphics_Canvas$nClipPath(long l, long l2, int n) {
        return false;
    }

    @CriticalNative
    private static final void $$robo$$android_graphics_Canvas$nSetDrawFilter(long l, long l2) {
    }

    @CriticalNative
    private static final void $$robo$$android_graphics_Canvas$nGetMatrix(long l, long l2) {
    }

    @CriticalNative
    private static final boolean $$robo$$android_graphics_Canvas$nQuickReject(long l, long l2) {
        return false;
    }

    @CriticalNative
    private static final boolean $$robo$$android_graphics_Canvas$nQuickReject(long l, float f, float f2, float f3, float f4) {
        return false;
    }

    private final void $$robo$$android_graphics_Canvas$drawArc(RectF oval, float startAngle, float sweepAngle, boolean useCenter, Paint paint) {
        super.drawArc(oval, startAngle, sweepAngle, useCenter, paint);
    }

    private final void $$robo$$android_graphics_Canvas$drawArc(float left, float top, float right, float bottom, float startAngle, float sweepAngle, boolean useCenter, Paint paint) {
        super.drawArc(left, top, right, bottom, startAngle, sweepAngle, useCenter, paint);
    }

    private final void $$robo$$android_graphics_Canvas$drawARGB(int a, int r, int g, int b) {
        super.drawARGB(a, r, g, b);
    }

    private final void $$robo$$android_graphics_Canvas$drawBitmap(Bitmap bitmap, float left, float top, Paint paint) {
        super.drawBitmap(bitmap, left, top, paint);
    }

    private final void $$robo$$android_graphics_Canvas$drawBitmap(Bitmap bitmap, Rect src, RectF dst, Paint paint) {
        super.drawBitmap(bitmap, src, dst, paint);
    }

    private final void $$robo$$android_graphics_Canvas$drawBitmap(Bitmap bitmap, Rect src, Rect dst, Paint paint) {
        super.drawBitmap(bitmap, src, dst, paint);
    }

    @Deprecated
    private final void $$robo$$android_graphics_Canvas$drawBitmap(int[] colors, int offset, int stride, float x, float y, int width, int height, boolean hasAlpha, Paint paint) {
        super.drawBitmap(colors, offset, stride, x, y, width, height, hasAlpha, paint);
    }

    @Deprecated
    private final void $$robo$$android_graphics_Canvas$drawBitmap(int[] colors, int offset, int stride, int x, int y, int width, int height, boolean hasAlpha, Paint paint) {
        super.drawBitmap(colors, offset, stride, x, y, width, height, hasAlpha, paint);
    }

    private final void $$robo$$android_graphics_Canvas$drawBitmap(Bitmap bitmap, Matrix matrix, Paint paint) {
        super.drawBitmap(bitmap, matrix, paint);
    }

    private final void $$robo$$android_graphics_Canvas$drawBitmapMesh(Bitmap bitmap, int meshWidth, int meshHeight, float[] verts, int vertOffset, int[] colors, int colorOffset, Paint paint) {
        super.drawBitmapMesh(bitmap, meshWidth, meshHeight, verts, vertOffset, colors, colorOffset, paint);
    }

    private final void $$robo$$android_graphics_Canvas$drawCircle(float cx, float cy, float radius, Paint paint) {
        super.drawCircle(cx, cy, radius, paint);
    }

    private final void $$robo$$android_graphics_Canvas$drawColor(int color2) {
        super.drawColor(color2);
    }

    private final void $$robo$$android_graphics_Canvas$drawColor(int color2, PorterDuff.Mode mode) {
        super.drawColor(color2, mode);
    }

    private final void $$robo$$android_graphics_Canvas$drawLine(float startX, float startY, float stopX, float stopY, Paint paint) {
        super.drawLine(startX, startY, stopX, stopY, paint);
    }

    private final void $$robo$$android_graphics_Canvas$drawLines(float[] pts, int offset, int count, Paint paint) {
        super.drawLines(pts, offset, count, paint);
    }

    private final void $$robo$$android_graphics_Canvas$drawLines(float[] pts, Paint paint) {
        super.drawLines(pts, paint);
    }

    private final void $$robo$$android_graphics_Canvas$drawOval(RectF oval, Paint paint) {
        super.drawOval(oval, paint);
    }

    private final void $$robo$$android_graphics_Canvas$drawOval(float left, float top, float right, float bottom, Paint paint) {
        super.drawOval(left, top, right, bottom, paint);
    }

    private final void $$robo$$android_graphics_Canvas$drawPaint(Paint paint) {
        super.drawPaint(paint);
    }

    private final void $$robo$$android_graphics_Canvas$drawPatch(NinePatch patch, Rect dst, Paint paint) {
        super.drawPatch(patch, dst, paint);
    }

    private final void $$robo$$android_graphics_Canvas$drawPatch(NinePatch patch, RectF dst, Paint paint) {
        super.drawPatch(patch, dst, paint);
    }

    private final void $$robo$$android_graphics_Canvas$drawPath(Path path, Paint paint) {
        super.drawPath(path, paint);
    }

    private final void $$robo$$android_graphics_Canvas$drawPoint(float x, float y, Paint paint) {
        super.drawPoint(x, y, paint);
    }

    private final void $$robo$$android_graphics_Canvas$drawPoints(float[] pts, int offset, int count, Paint paint) {
        super.drawPoints(pts, offset, count, paint);
    }

    private final void $$robo$$android_graphics_Canvas$drawPoints(float[] pts, Paint paint) {
        super.drawPoints(pts, paint);
    }

    @Deprecated
    private final void $$robo$$android_graphics_Canvas$drawPosText(char[] text, int index, int count, float[] pos, Paint paint) {
        super.drawPosText(text, index, count, pos, paint);
    }

    @Deprecated
    private final void $$robo$$android_graphics_Canvas$drawPosText(String text, float[] pos, Paint paint) {
        super.drawPosText(text, pos, paint);
    }

    private final void $$robo$$android_graphics_Canvas$drawRect(RectF rect, Paint paint) {
        super.drawRect(rect, paint);
    }

    private final void $$robo$$android_graphics_Canvas$drawRect(Rect r, Paint paint) {
        super.drawRect(r, paint);
    }

    private final void $$robo$$android_graphics_Canvas$drawRect(float left, float top, float right, float bottom, Paint paint) {
        super.drawRect(left, top, right, bottom, paint);
    }

    private final void $$robo$$android_graphics_Canvas$drawRGB(int r, int g, int b) {
        super.drawRGB(r, g, b);
    }

    private final void $$robo$$android_graphics_Canvas$drawRoundRect(RectF rect, float rx, float ry, Paint paint) {
        super.drawRoundRect(rect, rx, ry, paint);
    }

    private final void $$robo$$android_graphics_Canvas$drawRoundRect(float left, float top, float right, float bottom, float rx, float ry, Paint paint) {
        super.drawRoundRect(left, top, right, bottom, rx, ry, paint);
    }

    private final void $$robo$$android_graphics_Canvas$drawText(char[] text, int index, int count, float x, float y, Paint paint) {
        super.drawText(text, index, count, x, y, paint);
    }

    private final void $$robo$$android_graphics_Canvas$drawText(String text, float x, float y, Paint paint) {
        super.drawText(text, x, y, paint);
    }

    private final void $$robo$$android_graphics_Canvas$drawText(String text, int start, int end, float x, float y, Paint paint) {
        super.drawText(text, start, end, x, y, paint);
    }

    private final void $$robo$$android_graphics_Canvas$drawText(CharSequence text, int start, int end, float x, float y, Paint paint) {
        super.drawText(text, start, end, x, y, paint);
    }

    private final void $$robo$$android_graphics_Canvas$drawTextOnPath(char[] text, int index, int count, Path path, float hOffset, float vOffset, Paint paint) {
        super.drawTextOnPath(text, index, count, path, hOffset, vOffset, paint);
    }

    private final void $$robo$$android_graphics_Canvas$drawTextOnPath(String text, Path path, float hOffset, float vOffset, Paint paint) {
        super.drawTextOnPath(text, path, hOffset, vOffset, paint);
    }

    private final void $$robo$$android_graphics_Canvas$drawTextRun(char[] text, int index, int count, int contextIndex, int contextCount, float x, float y, boolean isRtl, Paint paint) {
        super.drawTextRun(text, index, count, contextIndex, contextCount, x, y, isRtl, paint);
    }

    private final void $$robo$$android_graphics_Canvas$drawTextRun(CharSequence text, int start, int end, int contextStart, int contextEnd, float x, float y, boolean isRtl, Paint paint) {
        super.drawTextRun(text, start, end, contextStart, contextEnd, x, y, isRtl, paint);
    }

    private final void $$robo$$android_graphics_Canvas$drawVertices(VertexMode mode, int vertexCount, float[] verts, int vertOffset, float[] texs, int texOffset, int[] colors, int colorOffset, short[] indices, int indexOffset, int indexCount, Paint paint) {
        super.drawVertices(mode, vertexCount, verts, vertOffset, texs, texOffset, colors, colorOffset, indices, indexOffset, indexCount, paint);
    }

    static void __staticInitializer__() {
        sCompatibilityRestore = false;
        sCompatibilitySetBitmap = false;
    }

    public long getNativeCanvasWrapper() {
        return (long)InvokeDynamicSupport.bootstrap("getNativeCanvasWrapper", $$robo$$android_graphics_Canvas$getNativeCanvasWrapper(), 0, this);
    }

    public boolean isRecordingFor(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("isRecordingFor", $$robo$$android_graphics_Canvas$isRecordingFor(java.lang.Object ), 0, this, object);
    }

    private void __constructor__() {
        this.$$robo$$android_graphics_Canvas$__constructor__();
    }

    public Canvas() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Canvas$__constructor__(), 0, this);
    }

    private void __constructor__(Bitmap bitmap) {
        this.$$robo$$android_graphics_Canvas$__constructor__(bitmap);
    }

    public Canvas(Bitmap bitmap) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Canvas$__constructor__(android.graphics.Bitmap ), 0, this, bitmap);
    }

    private void __constructor__(long l) {
        this.$$robo$$android_graphics_Canvas$__constructor__(l);
    }

    public Canvas(long l) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Canvas$__constructor__(long ), 0, this, l);
    }

    @Deprecated
    protected GL getGL() {
        return InvokeDynamicSupport.bootstrap("getGL", $$robo$$android_graphics_Canvas$getGL(), 0, this);
    }

    @Override
    public boolean isHardwareAccelerated() {
        return (boolean)InvokeDynamicSupport.bootstrap("isHardwareAccelerated", $$robo$$android_graphics_Canvas$isHardwareAccelerated(), 0, this);
    }

    public void setBitmap(Bitmap bitmap) {
        InvokeDynamicSupport.bootstrap("setBitmap", $$robo$$android_graphics_Canvas$setBitmap(android.graphics.Bitmap ), 0, this, bitmap);
    }

    public void setHighContrastText(boolean bl) {
        InvokeDynamicSupport.bootstrap("setHighContrastText", $$robo$$android_graphics_Canvas$setHighContrastText(boolean ), 0, this, bl);
    }

    public void insertReorderBarrier() {
        InvokeDynamicSupport.bootstrap("insertReorderBarrier", $$robo$$android_graphics_Canvas$insertReorderBarrier(), 0, this);
    }

    public void insertInorderBarrier() {
        InvokeDynamicSupport.bootstrap("insertInorderBarrier", $$robo$$android_graphics_Canvas$insertInorderBarrier(), 0, this);
    }

    public boolean isOpaque() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOpaque", $$robo$$android_graphics_Canvas$isOpaque(), 0, this);
    }

    public int getWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getWidth", $$robo$$android_graphics_Canvas$getWidth(), 0, this);
    }

    public int getHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getHeight", $$robo$$android_graphics_Canvas$getHeight(), 0, this);
    }

    public int getDensity() {
        return (int)InvokeDynamicSupport.bootstrap("getDensity", $$robo$$android_graphics_Canvas$getDensity(), 0, this);
    }

    public void setDensity(int n) {
        InvokeDynamicSupport.bootstrap("setDensity", $$robo$$android_graphics_Canvas$setDensity(int ), 0, this, n);
    }

    public void setScreenDensity(int n) {
        InvokeDynamicSupport.bootstrap("setScreenDensity", $$robo$$android_graphics_Canvas$setScreenDensity(int ), 0, this, n);
    }

    public int getMaximumBitmapWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getMaximumBitmapWidth", $$robo$$android_graphics_Canvas$getMaximumBitmapWidth(), 0, this);
    }

    public int getMaximumBitmapHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getMaximumBitmapHeight", $$robo$$android_graphics_Canvas$getMaximumBitmapHeight(), 0, this);
    }

    public int save() {
        return (int)InvokeDynamicSupport.bootstrap("save", $$robo$$android_graphics_Canvas$save(), 0, this);
    }

    public int save(int n) {
        return (int)InvokeDynamicSupport.bootstrap("save", $$robo$$android_graphics_Canvas$save(int ), 0, this, n);
    }

    public int saveLayer(RectF rectF, Paint paint, int n) {
        return (int)InvokeDynamicSupport.bootstrap("saveLayer", $$robo$$android_graphics_Canvas$saveLayer(android.graphics.RectF android.graphics.Paint int ), 0, this, rectF, paint, n);
    }

    public int saveLayer(RectF rectF, Paint paint) {
        return (int)InvokeDynamicSupport.bootstrap("saveLayer", $$robo$$android_graphics_Canvas$saveLayer(android.graphics.RectF android.graphics.Paint ), 0, this, rectF, paint);
    }

    public int saveLayer(float f, float f2, float f3, float f4, Paint paint, int n) {
        return (int)InvokeDynamicSupport.bootstrap("saveLayer", $$robo$$android_graphics_Canvas$saveLayer(float float float float android.graphics.Paint int ), 0, this, f, f2, f3, f4, paint, n);
    }

    public int saveLayer(float f, float f2, float f3, float f4, Paint paint) {
        return (int)InvokeDynamicSupport.bootstrap("saveLayer", $$robo$$android_graphics_Canvas$saveLayer(float float float float android.graphics.Paint ), 0, this, f, f2, f3, f4, paint);
    }

    public int saveLayerAlpha(RectF rectF, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("saveLayerAlpha", $$robo$$android_graphics_Canvas$saveLayerAlpha(android.graphics.RectF int int ), 0, this, rectF, n, n2);
    }

    public int saveLayerAlpha(RectF rectF, int n) {
        return (int)InvokeDynamicSupport.bootstrap("saveLayerAlpha", $$robo$$android_graphics_Canvas$saveLayerAlpha(android.graphics.RectF int ), 0, this, rectF, n);
    }

    public int saveLayerAlpha(float f, float f2, float f3, float f4, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("saveLayerAlpha", $$robo$$android_graphics_Canvas$saveLayerAlpha(float float float float int int ), 0, this, f, f2, f3, f4, n, n2);
    }

    public int saveLayerAlpha(float f, float f2, float f3, float f4, int n) {
        return (int)InvokeDynamicSupport.bootstrap("saveLayerAlpha", $$robo$$android_graphics_Canvas$saveLayerAlpha(float float float float int ), 0, this, f, f2, f3, f4, n);
    }

    public void restore() {
        InvokeDynamicSupport.bootstrap("restore", $$robo$$android_graphics_Canvas$restore(), 0, this);
    }

    public int getSaveCount() {
        return (int)InvokeDynamicSupport.bootstrap("getSaveCount", $$robo$$android_graphics_Canvas$getSaveCount(), 0, this);
    }

    public void restoreToCount(int n) {
        InvokeDynamicSupport.bootstrap("restoreToCount", $$robo$$android_graphics_Canvas$restoreToCount(int ), 0, this, n);
    }

    public void translate(float f, float f2) {
        InvokeDynamicSupport.bootstrap("translate", $$robo$$android_graphics_Canvas$translate(float float ), 0, this, f, f2);
    }

    public void scale(float f, float f2) {
        InvokeDynamicSupport.bootstrap("scale", $$robo$$android_graphics_Canvas$scale(float float ), 0, this, f, f2);
    }

    public void scale(float f, float f2, float f3, float f4) {
        InvokeDynamicSupport.bootstrap("scale", $$robo$$android_graphics_Canvas$scale(float float float float ), 0, this, f, f2, f3, f4);
    }

    public void rotate(float f) {
        InvokeDynamicSupport.bootstrap("rotate", $$robo$$android_graphics_Canvas$rotate(float ), 0, this, f);
    }

    public void rotate(float f, float f2, float f3) {
        InvokeDynamicSupport.bootstrap("rotate", $$robo$$android_graphics_Canvas$rotate(float float float ), 0, this, f, f2, f3);
    }

    public void skew(float f, float f2) {
        InvokeDynamicSupport.bootstrap("skew", $$robo$$android_graphics_Canvas$skew(float float ), 0, this, f, f2);
    }

    public void concat(Matrix matrix) {
        InvokeDynamicSupport.bootstrap("concat", $$robo$$android_graphics_Canvas$concat(android.graphics.Matrix ), 0, this, matrix);
    }

    public void setMatrix(Matrix matrix) {
        InvokeDynamicSupport.bootstrap("setMatrix", $$robo$$android_graphics_Canvas$setMatrix(android.graphics.Matrix ), 0, this, matrix);
    }

    @Deprecated
    public void getMatrix(Matrix matrix) {
        InvokeDynamicSupport.bootstrap("getMatrix", $$robo$$android_graphics_Canvas$getMatrix(android.graphics.Matrix ), 0, this, matrix);
    }

    @Deprecated
    public Matrix getMatrix() {
        return InvokeDynamicSupport.bootstrap("getMatrix", $$robo$$android_graphics_Canvas$getMatrix(), 0, this);
    }

    @Deprecated
    public boolean clipRect(RectF rectF, Region.Op op) {
        return (boolean)InvokeDynamicSupport.bootstrap("clipRect", $$robo$$android_graphics_Canvas$clipRect(android.graphics.RectF android.graphics.Region$Op ), 0, this, rectF, op);
    }

    @Deprecated
    public boolean clipRect(Rect rect, Region.Op op) {
        return (boolean)InvokeDynamicSupport.bootstrap("clipRect", $$robo$$android_graphics_Canvas$clipRect(android.graphics.Rect android.graphics.Region$Op ), 0, this, rect, op);
    }

    public boolean clipRect(RectF rectF) {
        return (boolean)InvokeDynamicSupport.bootstrap("clipRect", $$robo$$android_graphics_Canvas$clipRect(android.graphics.RectF ), 0, this, rectF);
    }

    public boolean clipOutRect(RectF rectF) {
        return (boolean)InvokeDynamicSupport.bootstrap("clipOutRect", $$robo$$android_graphics_Canvas$clipOutRect(android.graphics.RectF ), 0, this, rectF);
    }

    public boolean clipRect(Rect rect) {
        return (boolean)InvokeDynamicSupport.bootstrap("clipRect", $$robo$$android_graphics_Canvas$clipRect(android.graphics.Rect ), 0, this, rect);
    }

    public boolean clipOutRect(Rect rect) {
        return (boolean)InvokeDynamicSupport.bootstrap("clipOutRect", $$robo$$android_graphics_Canvas$clipOutRect(android.graphics.Rect ), 0, this, rect);
    }

    @Deprecated
    public boolean clipRect(float f, float f2, float f3, float f4, Region.Op op) {
        return (boolean)InvokeDynamicSupport.bootstrap("clipRect", $$robo$$android_graphics_Canvas$clipRect(float float float float android.graphics.Region$Op ), 0, this, f, f2, f3, f4, op);
    }

    public boolean clipRect(float f, float f2, float f3, float f4) {
        return (boolean)InvokeDynamicSupport.bootstrap("clipRect", $$robo$$android_graphics_Canvas$clipRect(float float float float ), 0, this, f, f2, f3, f4);
    }

    public boolean clipOutRect(float f, float f2, float f3, float f4) {
        return (boolean)InvokeDynamicSupport.bootstrap("clipOutRect", $$robo$$android_graphics_Canvas$clipOutRect(float float float float ), 0, this, f, f2, f3, f4);
    }

    public boolean clipRect(int n, int n2, int n3, int n4) {
        return (boolean)InvokeDynamicSupport.bootstrap("clipRect", $$robo$$android_graphics_Canvas$clipRect(int int int int ), 0, this, n, n2, n3, n4);
    }

    public boolean clipOutRect(int n, int n2, int n3, int n4) {
        return (boolean)InvokeDynamicSupport.bootstrap("clipOutRect", $$robo$$android_graphics_Canvas$clipOutRect(int int int int ), 0, this, n, n2, n3, n4);
    }

    @Deprecated
    public boolean clipPath(Path path, Region.Op op) {
        return (boolean)InvokeDynamicSupport.bootstrap("clipPath", $$robo$$android_graphics_Canvas$clipPath(android.graphics.Path android.graphics.Region$Op ), 0, this, path, op);
    }

    public boolean clipPath(Path path) {
        return (boolean)InvokeDynamicSupport.bootstrap("clipPath", $$robo$$android_graphics_Canvas$clipPath(android.graphics.Path ), 0, this, path);
    }

    public boolean clipOutPath(Path path) {
        return (boolean)InvokeDynamicSupport.bootstrap("clipOutPath", $$robo$$android_graphics_Canvas$clipOutPath(android.graphics.Path ), 0, this, path);
    }

    @Deprecated
    public boolean clipRegion(Region region, Region.Op op) {
        return (boolean)InvokeDynamicSupport.bootstrap("clipRegion", $$robo$$android_graphics_Canvas$clipRegion(android.graphics.Region android.graphics.Region$Op ), 0, this, region, op);
    }

    @Deprecated
    public boolean clipRegion(Region region) {
        return (boolean)InvokeDynamicSupport.bootstrap("clipRegion", $$robo$$android_graphics_Canvas$clipRegion(android.graphics.Region ), 0, this, region);
    }

    public DrawFilter getDrawFilter() {
        return InvokeDynamicSupport.bootstrap("getDrawFilter", $$robo$$android_graphics_Canvas$getDrawFilter(), 0, this);
    }

    public void setDrawFilter(DrawFilter drawFilter) {
        InvokeDynamicSupport.bootstrap("setDrawFilter", $$robo$$android_graphics_Canvas$setDrawFilter(android.graphics.DrawFilter ), 0, this, drawFilter);
    }

    public boolean quickReject(RectF rectF, EdgeType edgeType) {
        return (boolean)InvokeDynamicSupport.bootstrap("quickReject", $$robo$$android_graphics_Canvas$quickReject(android.graphics.RectF android.graphics.Canvas$EdgeType ), 0, this, rectF, edgeType);
    }

    public boolean quickReject(Path path, EdgeType edgeType) {
        return (boolean)InvokeDynamicSupport.bootstrap("quickReject", $$robo$$android_graphics_Canvas$quickReject(android.graphics.Path android.graphics.Canvas$EdgeType ), 0, this, path, edgeType);
    }

    public boolean quickReject(float f, float f2, float f3, float f4, EdgeType edgeType) {
        return (boolean)InvokeDynamicSupport.bootstrap("quickReject", $$robo$$android_graphics_Canvas$quickReject(float float float float android.graphics.Canvas$EdgeType ), 0, this, f, f2, f3, f4, edgeType);
    }

    public boolean getClipBounds(Rect rect) {
        return (boolean)InvokeDynamicSupport.bootstrap("getClipBounds", $$robo$$android_graphics_Canvas$getClipBounds(android.graphics.Rect ), 0, this, rect);
    }

    public Rect getClipBounds() {
        return InvokeDynamicSupport.bootstrap("getClipBounds", $$robo$$android_graphics_Canvas$getClipBounds(), 0, this);
    }

    public void drawPicture(Picture picture) {
        InvokeDynamicSupport.bootstrap("drawPicture", $$robo$$android_graphics_Canvas$drawPicture(android.graphics.Picture ), 0, this, picture);
    }

    public void drawPicture(Picture picture, RectF rectF) {
        InvokeDynamicSupport.bootstrap("drawPicture", $$robo$$android_graphics_Canvas$drawPicture(android.graphics.Picture android.graphics.RectF ), 0, this, picture, rectF);
    }

    public void drawPicture(Picture picture, Rect rect) {
        InvokeDynamicSupport.bootstrap("drawPicture", $$robo$$android_graphics_Canvas$drawPicture(android.graphics.Picture android.graphics.Rect ), 0, this, picture, rect);
    }

    public void release() {
        InvokeDynamicSupport.bootstrap("release", $$robo$$android_graphics_Canvas$release(), 0, this);
    }

    public static void freeCaches() {
        InvokeDynamicSupport.bootstrapStatic("freeCaches", $$robo$$android_graphics_Canvas$freeCaches(), 0);
    }

    public static void freeTextLayoutCaches() {
        InvokeDynamicSupport.bootstrapStatic("freeTextLayoutCaches", $$robo$$android_graphics_Canvas$freeTextLayoutCaches(), 0);
    }

    private static final native /* synthetic */ void $$robo$$nFreeCaches$nativeBinding();

    private static void nFreeCaches() {
        InvokeDynamicSupport.bootstrapStatic("nFreeCaches", $$robo$$android_graphics_Canvas$nFreeCaches(), 1);
    }

    private static final native /* synthetic */ void $$robo$$nFreeTextLayoutCaches$nativeBinding();

    private static void nFreeTextLayoutCaches() {
        InvokeDynamicSupport.bootstrapStatic("nFreeTextLayoutCaches", $$robo$$android_graphics_Canvas$nFreeTextLayoutCaches(), 1);
    }

    private static final native /* synthetic */ long $$robo$$nInitRaster$nativeBinding(Bitmap var0);

    private static long nInitRaster(Bitmap bitmap) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nInitRaster", $$robo$$android_graphics_Canvas$nInitRaster(android.graphics.Bitmap ), 1, (Bitmap)bitmap);
    }

    private static final native /* synthetic */ long $$robo$$nGetNativeFinalizer$nativeBinding();

    private static long nGetNativeFinalizer() {
        return (long)InvokeDynamicSupport.bootstrapStatic("nGetNativeFinalizer", $$robo$$android_graphics_Canvas$nGetNativeFinalizer(), 1);
    }

    private static final native /* synthetic */ void $$robo$$nSetBitmap$nativeBinding(long var0, Bitmap var2);

    private static void nSetBitmap(long l, Bitmap bitmap) {
        InvokeDynamicSupport.bootstrapStatic("nSetBitmap", $$robo$$android_graphics_Canvas$nSetBitmap(long android.graphics.Bitmap ), 1, (long)l, (Bitmap)bitmap);
    }

    private static final native /* synthetic */ boolean $$robo$$nGetClipBounds$nativeBinding(long var0, Rect var2);

    private static boolean nGetClipBounds(long l, Rect rect) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nGetClipBounds", $$robo$$android_graphics_Canvas$nGetClipBounds(long android.graphics.Rect ), 1, (long)l, (Rect)rect);
    }

    private static final native /* synthetic */ boolean $$robo$$nIsOpaque$nativeBinding(long var0);

    private static boolean nIsOpaque(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nIsOpaque", $$robo$$android_graphics_Canvas$nIsOpaque(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nSetHighContrastText$nativeBinding(long var0, boolean var2);

    private static void nSetHighContrastText(long l, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("nSetHighContrastText", $$robo$$android_graphics_Canvas$nSetHighContrastText(long boolean ), 1, (long)l, (boolean)bl);
    }

    private static final native /* synthetic */ int $$robo$$nGetWidth$nativeBinding(long var0);

    private static int nGetWidth(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nGetWidth", $$robo$$android_graphics_Canvas$nGetWidth(long ), 1, (long)l);
    }

    private static final native /* synthetic */ int $$robo$$nGetHeight$nativeBinding(long var0);

    private static int nGetHeight(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nGetHeight", $$robo$$android_graphics_Canvas$nGetHeight(long ), 1, (long)l);
    }

    private static final native /* synthetic */ int $$robo$$nSave$nativeBinding(long var0, int var2);

    private static int nSave(long l, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nSave", $$robo$$android_graphics_Canvas$nSave(long int ), 1, (long)l, (int)n);
    }

    private static final native /* synthetic */ int $$robo$$nSaveLayer$nativeBinding(long var0, float var2, float var3, float var4, float var5, long var6, int var8);

    private static int nSaveLayer(long l, float f, float f2, float f3, float f4, long l2, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nSaveLayer", $$robo$$android_graphics_Canvas$nSaveLayer(long float float float float long int ), 1, (long)l, (float)f, (float)f2, (float)f3, (float)f4, (long)l2, (int)n);
    }

    private static final native /* synthetic */ int $$robo$$nSaveLayerAlpha$nativeBinding(long var0, float var2, float var3, float var4, float var5, int var6, int var7);

    private static int nSaveLayerAlpha(long l, float f, float f2, float f3, float f4, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nSaveLayerAlpha", $$robo$$android_graphics_Canvas$nSaveLayerAlpha(long float float float float int int ), 1, (long)l, (float)f, (float)f2, (float)f3, (float)f4, (int)n, (int)n2);
    }

    private static final native /* synthetic */ boolean $$robo$$nRestore$nativeBinding(long var0);

    private static boolean nRestore(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nRestore", $$robo$$android_graphics_Canvas$nRestore(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nRestoreToCount$nativeBinding(long var0, int var2);

    private static void nRestoreToCount(long l, int n) {
        InvokeDynamicSupport.bootstrapStatic("nRestoreToCount", $$robo$$android_graphics_Canvas$nRestoreToCount(long int ), 1, (long)l, (int)n);
    }

    private static final native /* synthetic */ int $$robo$$nGetSaveCount$nativeBinding(long var0);

    private static int nGetSaveCount(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nGetSaveCount", $$robo$$android_graphics_Canvas$nGetSaveCount(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nTranslate$nativeBinding(long var0, float var2, float var3);

    private static void nTranslate(long l, float f, float f2) {
        InvokeDynamicSupport.bootstrapStatic("nTranslate", $$robo$$android_graphics_Canvas$nTranslate(long float float ), 1, (long)l, (float)f, (float)f2);
    }

    private static final native /* synthetic */ void $$robo$$nScale$nativeBinding(long var0, float var2, float var3);

    private static void nScale(long l, float f, float f2) {
        InvokeDynamicSupport.bootstrapStatic("nScale", $$robo$$android_graphics_Canvas$nScale(long float float ), 1, (long)l, (float)f, (float)f2);
    }

    private static final native /* synthetic */ void $$robo$$nRotate$nativeBinding(long var0, float var2);

    private static void nRotate(long l, float f) {
        InvokeDynamicSupport.bootstrapStatic("nRotate", $$robo$$android_graphics_Canvas$nRotate(long float ), 1, (long)l, (float)f);
    }

    private static final native /* synthetic */ void $$robo$$nSkew$nativeBinding(long var0, float var2, float var3);

    private static void nSkew(long l, float f, float f2) {
        InvokeDynamicSupport.bootstrapStatic("nSkew", $$robo$$android_graphics_Canvas$nSkew(long float float ), 1, (long)l, (float)f, (float)f2);
    }

    private static final native /* synthetic */ void $$robo$$nConcat$nativeBinding(long var0, long var2);

    private static void nConcat(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nConcat", $$robo$$android_graphics_Canvas$nConcat(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ void $$robo$$nSetMatrix$nativeBinding(long var0, long var2);

    private static void nSetMatrix(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nSetMatrix", $$robo$$android_graphics_Canvas$nSetMatrix(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ boolean $$robo$$nClipRect$nativeBinding(long var0, float var2, float var3, float var4, float var5, int var6);

    private static boolean nClipRect(long l, float f, float f2, float f3, float f4, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nClipRect", $$robo$$android_graphics_Canvas$nClipRect(long float float float float int ), 1, (long)l, (float)f, (float)f2, (float)f3, (float)f4, (int)n);
    }

    private static final native /* synthetic */ boolean $$robo$$nClipPath$nativeBinding(long var0, long var2, int var4);

    private static boolean nClipPath(long l, long l2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nClipPath", $$robo$$android_graphics_Canvas$nClipPath(long long int ), 1, (long)l, (long)l2, (int)n);
    }

    private static final native /* synthetic */ void $$robo$$nSetDrawFilter$nativeBinding(long var0, long var2);

    private static void nSetDrawFilter(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nSetDrawFilter", $$robo$$android_graphics_Canvas$nSetDrawFilter(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ void $$robo$$nGetMatrix$nativeBinding(long var0, long var2);

    private static void nGetMatrix(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nGetMatrix", $$robo$$android_graphics_Canvas$nGetMatrix(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ boolean $$robo$$nQuickReject$nativeBinding(long var0, long var2);

    private static boolean nQuickReject(long l, long l2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nQuickReject", $$robo$$android_graphics_Canvas$nQuickReject(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ boolean $$robo$$nQuickReject$nativeBinding(long var0, float var2, float var3, float var4, float var5);

    private static boolean nQuickReject(long l, float f, float f2, float f3, float f4) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nQuickReject", $$robo$$android_graphics_Canvas$nQuickReject(long float float float float ), 1, (long)l, (float)f, (float)f2, (float)f3, (float)f4);
    }

    @Override
    public void drawArc(RectF rectF, float f, float f2, boolean bl, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawArc", $$robo$$android_graphics_Canvas$drawArc(android.graphics.RectF float float boolean android.graphics.Paint ), 0, this, rectF, f, f2, bl, paint);
    }

    @Override
    public void drawArc(float f, float f2, float f3, float f4, float f5, float f6, boolean bl, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawArc", $$robo$$android_graphics_Canvas$drawArc(float float float float float float boolean android.graphics.Paint ), 0, this, f, f2, f3, f4, f5, f6, bl, paint);
    }

    @Override
    public void drawARGB(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("drawARGB", $$robo$$android_graphics_Canvas$drawARGB(int int int int ), 0, this, n, n2, n3, n4);
    }

    @Override
    public void drawBitmap(Bitmap bitmap, float f, float f2, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawBitmap", $$robo$$android_graphics_Canvas$drawBitmap(android.graphics.Bitmap float float android.graphics.Paint ), 0, this, bitmap, f, f2, paint);
    }

    @Override
    public void drawBitmap(Bitmap bitmap, Rect rect, RectF rectF, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawBitmap", $$robo$$android_graphics_Canvas$drawBitmap(android.graphics.Bitmap android.graphics.Rect android.graphics.RectF android.graphics.Paint ), 0, this, bitmap, rect, rectF, paint);
    }

    @Override
    public void drawBitmap(Bitmap bitmap, Rect rect, Rect rect2, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawBitmap", $$robo$$android_graphics_Canvas$drawBitmap(android.graphics.Bitmap android.graphics.Rect android.graphics.Rect android.graphics.Paint ), 0, this, bitmap, rect, rect2, paint);
    }

    @Override
    @Deprecated
    public void drawBitmap(int[] nArray, int n, int n2, float f, float f2, int n3, int n4, boolean bl, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawBitmap", $$robo$$android_graphics_Canvas$drawBitmap(int[] int int float float int int boolean android.graphics.Paint ), 0, this, nArray, n, n2, f, f2, n3, n4, bl, paint);
    }

    @Override
    @Deprecated
    public void drawBitmap(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawBitmap", $$robo$$android_graphics_Canvas$drawBitmap(int[] int int int int int int boolean android.graphics.Paint ), 0, this, nArray, n, n2, n3, n4, n5, n6, bl, paint);
    }

    @Override
    public void drawBitmap(Bitmap bitmap, Matrix matrix, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawBitmap", $$robo$$android_graphics_Canvas$drawBitmap(android.graphics.Bitmap android.graphics.Matrix android.graphics.Paint ), 0, this, bitmap, matrix, paint);
    }

    @Override
    public void drawBitmapMesh(Bitmap bitmap, int n, int n2, float[] fArray, int n3, int[] nArray, int n4, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawBitmapMesh", $$robo$$android_graphics_Canvas$drawBitmapMesh(android.graphics.Bitmap int int float[] int int[] int android.graphics.Paint ), 0, this, bitmap, n, n2, fArray, n3, nArray, n4, paint);
    }

    @Override
    public void drawCircle(float f, float f2, float f3, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawCircle", $$robo$$android_graphics_Canvas$drawCircle(float float float android.graphics.Paint ), 0, this, f, f2, f3, paint);
    }

    @Override
    public void drawColor(int n) {
        InvokeDynamicSupport.bootstrap("drawColor", $$robo$$android_graphics_Canvas$drawColor(int ), 0, this, n);
    }

    @Override
    public void drawColor(int n, PorterDuff.Mode mode) {
        InvokeDynamicSupport.bootstrap("drawColor", $$robo$$android_graphics_Canvas$drawColor(int android.graphics.PorterDuff$Mode ), 0, this, n, mode);
    }

    @Override
    public void drawLine(float f, float f2, float f3, float f4, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawLine", $$robo$$android_graphics_Canvas$drawLine(float float float float android.graphics.Paint ), 0, this, f, f2, f3, f4, paint);
    }

    @Override
    public void drawLines(float[] fArray, int n, int n2, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawLines", $$robo$$android_graphics_Canvas$drawLines(float[] int int android.graphics.Paint ), 0, this, fArray, n, n2, paint);
    }

    @Override
    public void drawLines(float[] fArray, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawLines", $$robo$$android_graphics_Canvas$drawLines(float[] android.graphics.Paint ), 0, this, fArray, paint);
    }

    @Override
    public void drawOval(RectF rectF, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawOval", $$robo$$android_graphics_Canvas$drawOval(android.graphics.RectF android.graphics.Paint ), 0, this, rectF, paint);
    }

    @Override
    public void drawOval(float f, float f2, float f3, float f4, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawOval", $$robo$$android_graphics_Canvas$drawOval(float float float float android.graphics.Paint ), 0, this, f, f2, f3, f4, paint);
    }

    @Override
    public void drawPaint(Paint paint) {
        InvokeDynamicSupport.bootstrap("drawPaint", $$robo$$android_graphics_Canvas$drawPaint(android.graphics.Paint ), 0, this, paint);
    }

    @Override
    public void drawPatch(NinePatch ninePatch, Rect rect, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawPatch", $$robo$$android_graphics_Canvas$drawPatch(android.graphics.NinePatch android.graphics.Rect android.graphics.Paint ), 0, this, ninePatch, rect, paint);
    }

    @Override
    public void drawPatch(NinePatch ninePatch, RectF rectF, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawPatch", $$robo$$android_graphics_Canvas$drawPatch(android.graphics.NinePatch android.graphics.RectF android.graphics.Paint ), 0, this, ninePatch, rectF, paint);
    }

    @Override
    public void drawPath(Path path, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawPath", $$robo$$android_graphics_Canvas$drawPath(android.graphics.Path android.graphics.Paint ), 0, this, path, paint);
    }

    @Override
    public void drawPoint(float f, float f2, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawPoint", $$robo$$android_graphics_Canvas$drawPoint(float float android.graphics.Paint ), 0, this, f, f2, paint);
    }

    @Override
    public void drawPoints(float[] fArray, int n, int n2, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawPoints", $$robo$$android_graphics_Canvas$drawPoints(float[] int int android.graphics.Paint ), 0, this, fArray, n, n2, paint);
    }

    @Override
    public void drawPoints(float[] fArray, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawPoints", $$robo$$android_graphics_Canvas$drawPoints(float[] android.graphics.Paint ), 0, this, fArray, paint);
    }

    @Override
    @Deprecated
    public void drawPosText(char[] cArray, int n, int n2, float[] fArray, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawPosText", $$robo$$android_graphics_Canvas$drawPosText(char[] int int float[] android.graphics.Paint ), 0, this, cArray, n, n2, fArray, paint);
    }

    @Override
    @Deprecated
    public void drawPosText(String string2, float[] fArray, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawPosText", $$robo$$android_graphics_Canvas$drawPosText(java.lang.String float[] android.graphics.Paint ), 0, this, string2, fArray, paint);
    }

    @Override
    public void drawRect(RectF rectF, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawRect", $$robo$$android_graphics_Canvas$drawRect(android.graphics.RectF android.graphics.Paint ), 0, this, rectF, paint);
    }

    @Override
    public void drawRect(Rect rect, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawRect", $$robo$$android_graphics_Canvas$drawRect(android.graphics.Rect android.graphics.Paint ), 0, this, rect, paint);
    }

    @Override
    public void drawRect(float f, float f2, float f3, float f4, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawRect", $$robo$$android_graphics_Canvas$drawRect(float float float float android.graphics.Paint ), 0, this, f, f2, f3, f4, paint);
    }

    @Override
    public void drawRGB(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("drawRGB", $$robo$$android_graphics_Canvas$drawRGB(int int int ), 0, this, n, n2, n3);
    }

    @Override
    public void drawRoundRect(RectF rectF, float f, float f2, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawRoundRect", $$robo$$android_graphics_Canvas$drawRoundRect(android.graphics.RectF float float android.graphics.Paint ), 0, this, rectF, f, f2, paint);
    }

    @Override
    public void drawRoundRect(float f, float f2, float f3, float f4, float f5, float f6, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawRoundRect", $$robo$$android_graphics_Canvas$drawRoundRect(float float float float float float android.graphics.Paint ), 0, this, f, f2, f3, f4, f5, f6, paint);
    }

    @Override
    public void drawText(char[] cArray, int n, int n2, float f, float f2, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawText", $$robo$$android_graphics_Canvas$drawText(char[] int int float float android.graphics.Paint ), 0, this, cArray, n, n2, f, f2, paint);
    }

    @Override
    public void drawText(String string2, float f, float f2, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawText", $$robo$$android_graphics_Canvas$drawText(java.lang.String float float android.graphics.Paint ), 0, this, string2, f, f2, paint);
    }

    @Override
    public void drawText(String string2, int n, int n2, float f, float f2, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawText", $$robo$$android_graphics_Canvas$drawText(java.lang.String int int float float android.graphics.Paint ), 0, this, string2, n, n2, f, f2, paint);
    }

    @Override
    public void drawText(CharSequence charSequence, int n, int n2, float f, float f2, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawText", $$robo$$android_graphics_Canvas$drawText(java.lang.CharSequence int int float float android.graphics.Paint ), 0, this, charSequence, n, n2, f, f2, paint);
    }

    @Override
    public void drawTextOnPath(char[] cArray, int n, int n2, Path path, float f, float f2, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawTextOnPath", $$robo$$android_graphics_Canvas$drawTextOnPath(char[] int int android.graphics.Path float float android.graphics.Paint ), 0, this, cArray, n, n2, path, f, f2, paint);
    }

    @Override
    public void drawTextOnPath(String string2, Path path, float f, float f2, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawTextOnPath", $$robo$$android_graphics_Canvas$drawTextOnPath(java.lang.String android.graphics.Path float float android.graphics.Paint ), 0, this, string2, path, f, f2, paint);
    }

    @Override
    public void drawTextRun(char[] cArray, int n, int n2, int n3, int n4, float f, float f2, boolean bl, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawTextRun", $$robo$$android_graphics_Canvas$drawTextRun(char[] int int int int float float boolean android.graphics.Paint ), 0, this, cArray, n, n2, n3, n4, f, f2, bl, paint);
    }

    @Override
    public void drawTextRun(CharSequence charSequence, int n, int n2, int n3, int n4, float f, float f2, boolean bl, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawTextRun", $$robo$$android_graphics_Canvas$drawTextRun(java.lang.CharSequence int int int int float float boolean android.graphics.Paint ), 0, this, charSequence, n, n2, n3, n4, f, f2, bl, paint);
    }

    @Override
    public void drawVertices(VertexMode vertexMode, int n, float[] fArray, int n2, float[] fArray2, int n3, int[] nArray, int n4, short[] sArray, int n5, int n6, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawVertices", $$robo$$android_graphics_Canvas$drawVertices(android.graphics.Canvas$VertexMode int float[] int float[] int int[] int short[] int int android.graphics.Paint ), 0, this, vertexMode, n, fArray, n2, fArray2, n3, nArray, n4, sArray, n5, n6, paint);
    }

    static {
        RobolectricInternals.classInitializing(Canvas.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Canvas)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class VertexMode
    extends Enum<VertexMode> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ VertexMode TRIANGLES;
        public static /* enum */ VertexMode TRIANGLE_STRIP;
        public static /* enum */ VertexMode TRIANGLE_FAN;
        public int nativeInt;
        private static /* synthetic */ VertexMode[] $VALUES;

        private static final VertexMode[] $$robo$$android_graphics_Canvas_VertexMode$values() {
            return (VertexMode[])$VALUES.clone();
        }

        private static final VertexMode $$robo$$android_graphics_Canvas_VertexMode$valueOf(String name) {
            return Enum.valueOf(VertexMode.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_graphics_Canvas_VertexMode$__constructor__(String string2, int n, int nativeInt) {
            this.nativeInt = nativeInt;
        }

        static void __staticInitializer__() {
            TRIANGLES = new VertexMode(0);
            TRIANGLE_STRIP = new VertexMode(1);
            TRIANGLE_FAN = new VertexMode(2);
            $VALUES = new VertexMode[]{TRIANGLES, TRIANGLE_STRIP, TRIANGLE_FAN};
        }

        public static VertexMode[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_graphics_Canvas_VertexMode$values(), 0);
        }

        public static VertexMode valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_graphics_Canvas_VertexMode$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n, int n2) {
            this.$$robo$$android_graphics_Canvas_VertexMode$__constructor__(string2, n, n2);
        }

        private VertexMode(int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Canvas_VertexMode$__constructor__(java.lang.String int int ), 0, this, string2, n, n2);
        }

        static {
            RobolectricInternals.classInitializing(VertexMode.class);
        }

        public /* synthetic */ VertexMode() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VertexMode)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class EdgeType
    extends Enum<EdgeType> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ EdgeType BW;
        public static /* enum */ EdgeType AA;
        public int nativeInt;
        private static /* synthetic */ EdgeType[] $VALUES;

        private static final EdgeType[] $$robo$$android_graphics_Canvas_EdgeType$values() {
            return (EdgeType[])$VALUES.clone();
        }

        private static final EdgeType $$robo$$android_graphics_Canvas_EdgeType$valueOf(String name) {
            return Enum.valueOf(EdgeType.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_graphics_Canvas_EdgeType$__constructor__(String string2, int n, int nativeInt) {
            this.nativeInt = nativeInt;
        }

        static void __staticInitializer__() {
            BW = new EdgeType(0);
            AA = new EdgeType(1);
            $VALUES = new EdgeType[]{BW, AA};
        }

        public static EdgeType[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_graphics_Canvas_EdgeType$values(), 0);
        }

        public static EdgeType valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_graphics_Canvas_EdgeType$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n, int n2) {
            this.$$robo$$android_graphics_Canvas_EdgeType$__constructor__(string2, n, n2);
        }

        private EdgeType(int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Canvas_EdgeType$__constructor__(java.lang.String int int ), 0, this, string2, n, n2);
        }

        static {
            RobolectricInternals.classInitializing(EdgeType.class);
        }

        public /* synthetic */ EdgeType() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EdgeType)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Saveflags {
    }

    private static class NoImagePreloadHolder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static NativeAllocationRegistry sRegistry;

        private void $$robo$$android_graphics_Canvas_NoImagePreloadHolder$__constructor__() {
        }

        static void __staticInitializer__() {
            sRegistry = new NativeAllocationRegistry(Canvas.class.getClassLoader(), Canvas.nGetNativeFinalizer(), 525L);
        }

        private void __constructor__() {
            this.$$robo$$android_graphics_Canvas_NoImagePreloadHolder$__constructor__();
        }

        private NoImagePreloadHolder() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_Canvas_NoImagePreloadHolder$__constructor__(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(NoImagePreloadHolder.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NoImagePreloadHolder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

