/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.util.Pair;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.DoubleUnaryOperator;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class ColorSpace
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static float[] ILLUMINANT_A;
    public static float[] ILLUMINANT_B;
    public static float[] ILLUMINANT_C;
    public static float[] ILLUMINANT_D50;
    public static float[] ILLUMINANT_D55;
    public static float[] ILLUMINANT_D60;
    public static float[] ILLUMINANT_D65;
    public static float[] ILLUMINANT_D75;
    public static float[] ILLUMINANT_E;
    public static int MIN_ID = -1;
    public static int MAX_ID = 63;
    private static float[] SRGB_PRIMARIES;
    private static float[] NTSC_1953_PRIMARIES;
    private static float[] ILLUMINANT_D50_XYZ;
    private static ColorSpace[] sNamedColorSpaces;
    private String mName;
    private Model mModel;
    private int mId;

    private void $$robo$$android_graphics_ColorSpace$__constructor__(String name, Model model, int id2) {
        if (name == null || name.length() < 1) {
            throw new IllegalArgumentException("The name of a color space cannot be null and must contain at least 1 character");
        }
        if (model == null) {
            throw new IllegalArgumentException("A color space must have a model");
        }
        if (id2 < -1 || id2 > 63) {
            throw new IllegalArgumentException("The id must be between -1 and 63");
        }
        this.mName = name;
        this.mModel = model;
        this.mId = id2;
    }

    private final String $$robo$$android_graphics_ColorSpace$getName() {
        return this.mName;
    }

    private final int $$robo$$android_graphics_ColorSpace$getId() {
        return this.mId;
    }

    private final Model $$robo$$android_graphics_ColorSpace$getModel() {
        return this.mModel;
    }

    private final int $$robo$$android_graphics_ColorSpace$getComponentCount() {
        return this.mModel.getComponentCount();
    }

    public abstract boolean isWideGamut();

    private final boolean $$robo$$android_graphics_ColorSpace$isSrgb() {
        return false;
    }

    public abstract float getMinValue(int var1);

    public abstract float getMaxValue(int var1);

    private final float[] $$robo$$android_graphics_ColorSpace$toXyz(float r, float g, float b) {
        return this.toXyz(new float[]{r, g, b});
    }

    public abstract float[] toXyz(float[] var1);

    private final float[] $$robo$$android_graphics_ColorSpace$fromXyz(float x, float y, float z) {
        float[] xyz = new float[this.mModel.getComponentCount()];
        xyz[0] = x;
        xyz[1] = y;
        xyz[2] = z;
        return this.fromXyz(xyz);
    }

    public abstract float[] fromXyz(float[] var1);

    private final String $$robo$$android_graphics_ColorSpace$toString() {
        return this.mName + " (id=" + this.mId + ", model=" + (Object)((Object)this.mModel) + ")";
    }

    private final boolean $$robo$$android_graphics_ColorSpace$equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColorSpace that = (ColorSpace)o;
        if (this.mId != that.mId) {
            return false;
        }
        if (!this.mName.equals(that.mName)) {
            return false;
        }
        return this.mModel == that.mModel;
    }

    private final int $$robo$$android_graphics_ColorSpace$hashCode() {
        int result = this.mName.hashCode();
        result = 31 * result + this.mModel.hashCode();
        result = 31 * result + this.mId;
        return result;
    }

    private static final Connector $$robo$$android_graphics_ColorSpace$connect(ColorSpace source, ColorSpace destination) {
        return ColorSpace.connect(source, destination, RenderIntent.PERCEPTUAL);
    }

    private static final Connector $$robo$$android_graphics_ColorSpace$connect(ColorSpace source, ColorSpace destination, RenderIntent intent) {
        if (source.equals(destination)) {
            return Connector.identity(source);
        }
        if (source.getModel() == Model.RGB && destination.getModel() == Model.RGB) {
            return new Connector.Rgb((Rgb)source, (Rgb)destination, intent);
        }
        return new Connector(source, destination, intent);
    }

    private static final Connector $$robo$$android_graphics_ColorSpace$connect(ColorSpace source) {
        return ColorSpace.connect(source, RenderIntent.PERCEPTUAL);
    }

    private static final Connector $$robo$$android_graphics_ColorSpace$connect(ColorSpace source, RenderIntent intent) {
        if (source.isSrgb()) {
            return Connector.identity(source);
        }
        if (source.getModel() == Model.RGB) {
            return new Connector.Rgb((Rgb)source, (Rgb)ColorSpace.get(Named.SRGB), intent);
        }
        return new Connector(source, ColorSpace.get(Named.SRGB), intent);
    }

    private static final ColorSpace $$robo$$android_graphics_ColorSpace$adapt(ColorSpace colorSpace, float[] whitePoint) {
        return ColorSpace.adapt(colorSpace, whitePoint, Adaptation.BRADFORD);
    }

    private static final ColorSpace $$robo$$android_graphics_ColorSpace$adapt(ColorSpace colorSpace, float[] whitePoint, Adaptation adaptation) {
        if (colorSpace.getModel() == Model.RGB) {
            Rgb rgb = (Rgb)colorSpace;
            if (ColorSpace.compare(rgb.mWhitePoint, whitePoint)) {
                return colorSpace;
            }
            float[] xyz = whitePoint.length == 3 ? Arrays.copyOf(whitePoint, 3) : ColorSpace.xyYToXyz(whitePoint);
            float[] adaptationTransform = ColorSpace.chromaticAdaptation(adaptation.mTransform, ColorSpace.xyYToXyz(rgb.getWhitePoint()), xyz);
            float[] transform = ColorSpace.mul3x3(adaptationTransform, rgb.mTransform);
            return new Rgb(rgb, transform, whitePoint);
        }
        return colorSpace;
    }

    private static final ColorSpace $$robo$$android_graphics_ColorSpace$get(int index) {
        if (index < 0 || index > Named.values().length) {
            throw new IllegalArgumentException("Invalid ID, must be in the range [0.." + Named.values().length + "]");
        }
        return sNamedColorSpaces[index];
    }

    private static final ColorSpace $$robo$$android_graphics_ColorSpace$get(Named name) {
        return sNamedColorSpaces[name.ordinal()];
    }

    private static final ColorSpace $$robo$$android_graphics_ColorSpace$match(float[] toXYZD50, Rgb.TransferParameters function) {
        for (ColorSpace colorSpace : sNamedColorSpaces) {
            Rgb rgb;
            if (colorSpace.getModel() != Model.RGB || !ColorSpace.compare(toXYZD50, (rgb = (Rgb)ColorSpace.adapt(colorSpace, ILLUMINANT_D50_XYZ)).mTransform) || !ColorSpace.compare(function, rgb.mTransferParameters)) continue;
            return colorSpace;
        }
        return null;
    }

    private static final Renderer $$robo$$android_graphics_ColorSpace$createRenderer() {
        return new Renderer();
    }

    private static final double $$robo$$android_graphics_ColorSpace$rcpResponse(double x, double a, double b, double c, double d, double g) {
        return x >= d * c ? (Math.pow(x, 1.0 / g) - b) / a : x / c;
    }

    private static final double $$robo$$android_graphics_ColorSpace$response(double x, double a, double b, double c, double d, double g) {
        return x >= d ? Math.pow(a * x + b, g) : c * x;
    }

    private static final double $$robo$$android_graphics_ColorSpace$rcpResponse(double x, double a, double b, double c, double d, double e, double f, double g) {
        return x >= d * c ? (Math.pow(x - e, 1.0 / g) - b) / a : (x - f) / c;
    }

    private static final double $$robo$$android_graphics_ColorSpace$response(double x, double a, double b, double c, double d, double e, double f, double g) {
        return x >= d ? Math.pow(a * x + b, g) + e : c * x + f;
    }

    private static final double $$robo$$android_graphics_ColorSpace$absRcpResponse(double x, double a, double b, double c, double d, double g) {
        return Math.copySign(ColorSpace.rcpResponse(x < 0.0 ? -x : x, a, b, c, d, g), x);
    }

    private static final double $$robo$$android_graphics_ColorSpace$absResponse(double x, double a, double b, double c, double d, double g) {
        return Math.copySign(ColorSpace.response(x < 0.0 ? -x : x, a, b, c, d, g), x);
    }

    private static final boolean $$robo$$android_graphics_ColorSpace$compare(Rgb.TransferParameters a, Rgb.TransferParameters b) {
        if (a == null && b == null) {
            return true;
        }
        return a != null && b != null && Math.abs(a.a - b.a) < 0.001 && Math.abs(a.b - b.b) < 0.001 && Math.abs(a.c - b.c) < 0.001 && Math.abs(a.d - b.d) < 0.002 && Math.abs(a.e - b.e) < 0.001 && Math.abs(a.f - b.f) < 0.001 && Math.abs(a.g - b.g) < 0.001;
    }

    private static final boolean $$robo$$android_graphics_ColorSpace$compare(float[] a, float[] b) {
        if (a == b) {
            return true;
        }
        for (int i = 0; i < a.length; ++i) {
            if (Float.compare(a[i], b[i]) == 0 || !(Math.abs(a[i] - b[i]) > 0.001f)) continue;
            return false;
        }
        return true;
    }

    private static final float[] $$robo$$android_graphics_ColorSpace$inverse3x3(float[] m) {
        float a = m[0];
        float b = m[3];
        float c = m[6];
        float d = m[1];
        float e = m[4];
        float f = m[7];
        float g = m[2];
        float h = m[5];
        float i = m[8];
        float A = e * i - f * h;
        float B = f * g - d * i;
        float C = d * h - e * g;
        float det = a * A + b * B + c * C;
        float[] inverted = new float[m.length];
        inverted[0] = A / det;
        inverted[1] = B / det;
        inverted[2] = C / det;
        inverted[3] = (c * h - b * i) / det;
        inverted[4] = (a * i - c * g) / det;
        inverted[5] = (b * g - a * h) / det;
        inverted[6] = (b * f - c * e) / det;
        inverted[7] = (c * d - a * f) / det;
        inverted[8] = (a * e - b * d) / det;
        return inverted;
    }

    private static final float[] $$robo$$android_graphics_ColorSpace$mul3x3(float[] lhs, float[] rhs) {
        float[] r = new float[]{lhs[0] * rhs[0] + lhs[3] * rhs[1] + lhs[6] * rhs[2], lhs[1] * rhs[0] + lhs[4] * rhs[1] + lhs[7] * rhs[2], lhs[2] * rhs[0] + lhs[5] * rhs[1] + lhs[8] * rhs[2], lhs[0] * rhs[3] + lhs[3] * rhs[4] + lhs[6] * rhs[5], lhs[1] * rhs[3] + lhs[4] * rhs[4] + lhs[7] * rhs[5], lhs[2] * rhs[3] + lhs[5] * rhs[4] + lhs[8] * rhs[5], lhs[0] * rhs[6] + lhs[3] * rhs[7] + lhs[6] * rhs[8], lhs[1] * rhs[6] + lhs[4] * rhs[7] + lhs[7] * rhs[8], lhs[2] * rhs[6] + lhs[5] * rhs[7] + lhs[8] * rhs[8]};
        return r;
    }

    private static final float[] $$robo$$android_graphics_ColorSpace$mul3x3Float3(float[] lhs, float[] rhs) {
        float r0 = rhs[0];
        float r1 = rhs[1];
        float r2 = rhs[2];
        rhs[0] = lhs[0] * r0 + lhs[3] * r1 + lhs[6] * r2;
        rhs[1] = lhs[1] * r0 + lhs[4] * r1 + lhs[7] * r2;
        rhs[2] = lhs[2] * r0 + lhs[5] * r1 + lhs[8] * r2;
        return rhs;
    }

    private static final float[] $$robo$$android_graphics_ColorSpace$mul3x3Diag(float[] lhs, float[] rhs) {
        return new float[]{lhs[0] * rhs[0], lhs[1] * rhs[1], lhs[2] * rhs[2], lhs[0] * rhs[3], lhs[1] * rhs[4], lhs[2] * rhs[5], lhs[0] * rhs[6], lhs[1] * rhs[7], lhs[2] * rhs[8]};
    }

    private static final float[] $$robo$$android_graphics_ColorSpace$xyYToXyz(float[] xyY) {
        return new float[]{xyY[0] / xyY[1], 1.0f, (1.0f - xyY[0] - xyY[1]) / xyY[1]};
    }

    private static final void $$robo$$android_graphics_ColorSpace$xyYToUv(float[] xyY) {
        for (int i = 0; i < xyY.length; i += 2) {
            float x = xyY[i];
            float y = xyY[i + 1];
            float d = -2.0f * x + 12.0f * y + 3.0f;
            float u = 4.0f * x / d;
            float v = 9.0f * y / d;
            xyY[i] = u;
            xyY[i + 1] = v;
        }
    }

    private static final float[] $$robo$$android_graphics_ColorSpace$chromaticAdaptation(float[] matrix, float[] srcWhitePoint, float[] dstWhitePoint) {
        float[] srcLMS = ColorSpace.mul3x3Float3(matrix, srcWhitePoint);
        float[] dstLMS = ColorSpace.mul3x3Float3(matrix, dstWhitePoint);
        float[] LMS = new float[]{dstLMS[0] / srcLMS[0], dstLMS[1] / srcLMS[1], dstLMS[2] / srcLMS[2]};
        return ColorSpace.mul3x3(ColorSpace.inverse3x3(matrix), ColorSpace.mul3x3Diag(LMS, matrix));
    }

    private /* synthetic */ void $$robo$$android_graphics_ColorSpace$__constructor__(String x0, Model x1, int x2, 1 x3) {
    }

    static void __staticInitializer__() {
        ILLUMINANT_A = new float[]{0.44757f, 0.40745f};
        ILLUMINANT_B = new float[]{0.34842f, 0.35161f};
        ILLUMINANT_C = new float[]{0.31006f, 0.31616f};
        ILLUMINANT_D50 = new float[]{0.34567f, 0.3585f};
        ILLUMINANT_D55 = new float[]{0.33242f, 0.34743f};
        ILLUMINANT_D60 = new float[]{0.32168f, 0.33767f};
        ILLUMINANT_D65 = new float[]{0.31271f, 0.32902f};
        ILLUMINANT_D75 = new float[]{0.29902f, 0.31485f};
        ILLUMINANT_E = new float[]{0.33333f, 0.33333f};
        SRGB_PRIMARIES = new float[]{0.64f, 0.33f, 0.3f, 0.6f, 0.15f, 0.06f};
        NTSC_1953_PRIMARIES = new float[]{0.67f, 0.33f, 0.21f, 0.71f, 0.14f, 0.08f};
        ILLUMINANT_D50_XYZ = new float[]{0.964212f, 1.0f, 0.825188f};
        sNamedColorSpaces = new ColorSpace[Named.values().length];
        ColorSpace.sNamedColorSpaces[Named.SRGB.ordinal()] = new Rgb("sRGB IEC61966-2.1", SRGB_PRIMARIES, ILLUMINANT_D65, new Rgb.TransferParameters(0.9478672985781991, 0.05213270142180095, 0.07739938080495357, 0.04045, 2.4), Named.SRGB.ordinal());
        ColorSpace.sNamedColorSpaces[Named.LINEAR_SRGB.ordinal()] = new Rgb("sRGB IEC61966-2.1 (Linear)", SRGB_PRIMARIES, ILLUMINANT_D65, 1.0, 0.0f, 1.0f, Named.LINEAR_SRGB.ordinal());
        ColorSpace.sNamedColorSpaces[Named.EXTENDED_SRGB.ordinal()] = new Rgb("scRGB-nl IEC 61966-2-2:2003", SRGB_PRIMARIES, ILLUMINANT_D65, x -> ColorSpace.absRcpResponse(x, 0.9478672985781991, 0.05213270142180095, 0.07739938080495357, 0.04045, 2.4), x -> ColorSpace.absResponse(x, 0.9478672985781991, 0.05213270142180095, 0.07739938080495357, 0.04045, 2.4), -0.799f, 2.399f, Named.EXTENDED_SRGB.ordinal());
        ColorSpace.sNamedColorSpaces[Named.LINEAR_EXTENDED_SRGB.ordinal()] = new Rgb("scRGB IEC 61966-2-2:2003", SRGB_PRIMARIES, ILLUMINANT_D65, 1.0, -0.5f, 7.499f, Named.LINEAR_EXTENDED_SRGB.ordinal());
        ColorSpace.sNamedColorSpaces[Named.BT709.ordinal()] = new Rgb("Rec. ITU-R BT.709-5", new float[]{0.64f, 0.33f, 0.3f, 0.6f, 0.15f, 0.06f}, ILLUMINANT_D65, new Rgb.TransferParameters(0.9099181073703367, 0.09008189262966333, 0.2222222222222222, 0.081, 2.2222222222222223), Named.BT709.ordinal());
        ColorSpace.sNamedColorSpaces[Named.BT2020.ordinal()] = new Rgb("Rec. ITU-R BT.2020-1", new float[]{0.708f, 0.292f, 0.17f, 0.797f, 0.131f, 0.046f}, ILLUMINANT_D65, new Rgb.TransferParameters(0.9096697898662786, 0.09033021013372146, 0.2222222222222222, 0.08145, 2.2222222222222223), Named.BT2020.ordinal());
        ColorSpace.sNamedColorSpaces[Named.DCI_P3.ordinal()] = new Rgb("SMPTE RP 431-2-2007 DCI (P3)", new float[]{0.68f, 0.32f, 0.265f, 0.69f, 0.15f, 0.06f}, new float[]{0.314f, 0.351f}, 2.6, 0.0f, 1.0f, Named.DCI_P3.ordinal());
        ColorSpace.sNamedColorSpaces[Named.DISPLAY_P3.ordinal()] = new Rgb("Display P3", new float[]{0.68f, 0.32f, 0.265f, 0.69f, 0.15f, 0.06f}, ILLUMINANT_D65, new Rgb.TransferParameters(0.9478672985781991, 0.05213270142180095, 0.07739938080495357, 0.039, 2.4), Named.DISPLAY_P3.ordinal());
        ColorSpace.sNamedColorSpaces[Named.NTSC_1953.ordinal()] = new Rgb("NTSC (1953)", NTSC_1953_PRIMARIES, ILLUMINANT_C, new Rgb.TransferParameters(0.9099181073703367, 0.09008189262966333, 0.2222222222222222, 0.081, 2.2222222222222223), Named.NTSC_1953.ordinal());
        ColorSpace.sNamedColorSpaces[Named.SMPTE_C.ordinal()] = new Rgb("SMPTE-C RGB", new float[]{0.63f, 0.34f, 0.31f, 0.595f, 0.155f, 0.07f}, ILLUMINANT_D65, new Rgb.TransferParameters(0.9099181073703367, 0.09008189262966333, 0.2222222222222222, 0.081, 2.2222222222222223), Named.SMPTE_C.ordinal());
        ColorSpace.sNamedColorSpaces[Named.ADOBE_RGB.ordinal()] = new Rgb("Adobe RGB (1998)", new float[]{0.64f, 0.33f, 0.21f, 0.71f, 0.15f, 0.06f}, ILLUMINANT_D65, 2.2, 0.0f, 1.0f, Named.ADOBE_RGB.ordinal());
        ColorSpace.sNamedColorSpaces[Named.PRO_PHOTO_RGB.ordinal()] = new Rgb("ROMM RGB ISO 22028-2:2013", new float[]{0.7347f, 0.2653f, 0.1596f, 0.8404f, 0.0366f, 1.0E-4f}, ILLUMINANT_D50, new Rgb.TransferParameters(1.0, 0.0, 0.0625, 0.031248, 1.8), Named.PRO_PHOTO_RGB.ordinal());
        ColorSpace.sNamedColorSpaces[Named.ACES.ordinal()] = new Rgb("SMPTE ST 2065-1:2012 ACES", new float[]{0.7347f, 0.2653f, 0.0f, 1.0f, 1.0E-4f, -0.077f}, ILLUMINANT_D60, 1.0, -65504.0f, 65504.0f, Named.ACES.ordinal());
        ColorSpace.sNamedColorSpaces[Named.ACESCG.ordinal()] = new Rgb("Academy S-2014-004 ACEScg", new float[]{0.713f, 0.293f, 0.165f, 0.83f, 0.128f, 0.044f}, ILLUMINANT_D60, 1.0, -65504.0f, 65504.0f, Named.ACESCG.ordinal());
        ColorSpace.sNamedColorSpaces[Named.CIE_XYZ.ordinal()] = new Xyz("Generic XYZ", Named.CIE_XYZ.ordinal());
        ColorSpace.sNamedColorSpaces[Named.CIE_LAB.ordinal()] = new Lab("Generic L*a*b*", Named.CIE_LAB.ordinal());
    }

    private void __constructor__(String string2, Model model, int n) {
        this.$$robo$$android_graphics_ColorSpace$__constructor__(string2, model, n);
    }

    private ColorSpace(String string2, Model model, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_ColorSpace$__constructor__(java.lang.String android.graphics.ColorSpace$Model int ), 0, this, string2, model, n);
    }

    public String getName() {
        return InvokeDynamicSupport.bootstrap("getName", $$robo$$android_graphics_ColorSpace$getName(), 0, this);
    }

    public int getId() {
        return (int)InvokeDynamicSupport.bootstrap("getId", $$robo$$android_graphics_ColorSpace$getId(), 0, this);
    }

    public Model getModel() {
        return InvokeDynamicSupport.bootstrap("getModel", $$robo$$android_graphics_ColorSpace$getModel(), 0, this);
    }

    public int getComponentCount() {
        return (int)InvokeDynamicSupport.bootstrap("getComponentCount", $$robo$$android_graphics_ColorSpace$getComponentCount(), 0, this);
    }

    public boolean isSrgb() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSrgb", $$robo$$android_graphics_ColorSpace$isSrgb(), 0, this);
    }

    public float[] toXyz(float f, float f2, float f3) {
        return InvokeDynamicSupport.bootstrap("toXyz", $$robo$$android_graphics_ColorSpace$toXyz(float float float ), 0, this, f, f2, f3);
    }

    public float[] fromXyz(float f, float f2, float f3) {
        return InvokeDynamicSupport.bootstrap("fromXyz", $$robo$$android_graphics_ColorSpace$fromXyz(float float float ), 0, this, f, f2, f3);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_graphics_ColorSpace$toString(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_graphics_ColorSpace$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_graphics_ColorSpace$hashCode(), 0, this);
    }

    public static Connector connect(ColorSpace colorSpace, ColorSpace colorSpace2) {
        return InvokeDynamicSupport.bootstrapStatic("connect", $$robo$$android_graphics_ColorSpace$connect(android.graphics.ColorSpace android.graphics.ColorSpace ), 0, (ColorSpace)colorSpace, (ColorSpace)colorSpace2);
    }

    public static Connector connect(ColorSpace colorSpace, ColorSpace colorSpace2, RenderIntent renderIntent) {
        return InvokeDynamicSupport.bootstrapStatic("connect", $$robo$$android_graphics_ColorSpace$connect(android.graphics.ColorSpace android.graphics.ColorSpace android.graphics.ColorSpace$RenderIntent ), 0, (ColorSpace)colorSpace, (ColorSpace)colorSpace2, (RenderIntent)renderIntent);
    }

    public static Connector connect(ColorSpace colorSpace) {
        return InvokeDynamicSupport.bootstrapStatic("connect", $$robo$$android_graphics_ColorSpace$connect(android.graphics.ColorSpace ), 0, (ColorSpace)colorSpace);
    }

    public static Connector connect(ColorSpace colorSpace, RenderIntent renderIntent) {
        return InvokeDynamicSupport.bootstrapStatic("connect", $$robo$$android_graphics_ColorSpace$connect(android.graphics.ColorSpace android.graphics.ColorSpace$RenderIntent ), 0, (ColorSpace)colorSpace, (RenderIntent)renderIntent);
    }

    public static ColorSpace adapt(ColorSpace colorSpace, float[] fArray) {
        return InvokeDynamicSupport.bootstrapStatic("adapt", $$robo$$android_graphics_ColorSpace$adapt(android.graphics.ColorSpace float[] ), 0, (ColorSpace)colorSpace, (float[])fArray);
    }

    public static ColorSpace adapt(ColorSpace colorSpace, float[] fArray, Adaptation adaptation) {
        return InvokeDynamicSupport.bootstrapStatic("adapt", $$robo$$android_graphics_ColorSpace$adapt(android.graphics.ColorSpace float[] android.graphics.ColorSpace$Adaptation ), 0, (ColorSpace)colorSpace, (float[])fArray, (Adaptation)adaptation);
    }

    static ColorSpace get(int n) {
        return InvokeDynamicSupport.bootstrapStatic("get", $$robo$$android_graphics_ColorSpace$get(int ), 0, (int)n);
    }

    public static ColorSpace get(Named named) {
        return InvokeDynamicSupport.bootstrapStatic("get", $$robo$$android_graphics_ColorSpace$get(android.graphics.ColorSpace$Named ), 0, (Named)named);
    }

    public static ColorSpace match(float[] fArray, Rgb.TransferParameters transferParameters) {
        return InvokeDynamicSupport.bootstrapStatic("match", $$robo$$android_graphics_ColorSpace$match(float[] android.graphics.ColorSpace$Rgb$TransferParameters ), 0, (float[])fArray, (Rgb.TransferParameters)transferParameters);
    }

    public static Renderer createRenderer() {
        return InvokeDynamicSupport.bootstrapStatic("createRenderer", $$robo$$android_graphics_ColorSpace$createRenderer(), 0);
    }

    private static double rcpResponse(double d, double d2, double d3, double d4, double d5, double d6) {
        return (double)InvokeDynamicSupport.bootstrapStatic("rcpResponse", $$robo$$android_graphics_ColorSpace$rcpResponse(double double double double double double ), 0, (double)d, (double)d2, (double)d3, (double)d4, (double)d5, (double)d6);
    }

    private static double response(double d, double d2, double d3, double d4, double d5, double d6) {
        return (double)InvokeDynamicSupport.bootstrapStatic("response", $$robo$$android_graphics_ColorSpace$response(double double double double double double ), 0, (double)d, (double)d2, (double)d3, (double)d4, (double)d5, (double)d6);
    }

    private static double rcpResponse(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        return (double)InvokeDynamicSupport.bootstrapStatic("rcpResponse", $$robo$$android_graphics_ColorSpace$rcpResponse(double double double double double double double double ), 0, (double)d, (double)d2, (double)d3, (double)d4, (double)d5, (double)d6, (double)d7, (double)d8);
    }

    private static double response(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        return (double)InvokeDynamicSupport.bootstrapStatic("response", $$robo$$android_graphics_ColorSpace$response(double double double double double double double double ), 0, (double)d, (double)d2, (double)d3, (double)d4, (double)d5, (double)d6, (double)d7, (double)d8);
    }

    private static double absRcpResponse(double d, double d2, double d3, double d4, double d5, double d6) {
        return (double)InvokeDynamicSupport.bootstrapStatic("absRcpResponse", $$robo$$android_graphics_ColorSpace$absRcpResponse(double double double double double double ), 0, (double)d, (double)d2, (double)d3, (double)d4, (double)d5, (double)d6);
    }

    private static double absResponse(double d, double d2, double d3, double d4, double d5, double d6) {
        return (double)InvokeDynamicSupport.bootstrapStatic("absResponse", $$robo$$android_graphics_ColorSpace$absResponse(double double double double double double ), 0, (double)d, (double)d2, (double)d3, (double)d4, (double)d5, (double)d6);
    }

    private static boolean compare(Rgb.TransferParameters transferParameters, Rgb.TransferParameters transferParameters2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("compare", $$robo$$android_graphics_ColorSpace$compare(android.graphics.ColorSpace$Rgb$TransferParameters android.graphics.ColorSpace$Rgb$TransferParameters ), 0, (Rgb.TransferParameters)transferParameters, (Rgb.TransferParameters)transferParameters2);
    }

    private static boolean compare(float[] fArray, float[] fArray2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("compare", $$robo$$android_graphics_ColorSpace$compare(float[] float[] ), 0, (float[])fArray, (float[])fArray2);
    }

    private static float[] inverse3x3(float[] fArray) {
        return InvokeDynamicSupport.bootstrapStatic("inverse3x3", $$robo$$android_graphics_ColorSpace$inverse3x3(float[] ), 0, (float[])fArray);
    }

    private static float[] mul3x3(float[] fArray, float[] fArray2) {
        return InvokeDynamicSupport.bootstrapStatic("mul3x3", $$robo$$android_graphics_ColorSpace$mul3x3(float[] float[] ), 0, (float[])fArray, (float[])fArray2);
    }

    private static float[] mul3x3Float3(float[] fArray, float[] fArray2) {
        return InvokeDynamicSupport.bootstrapStatic("mul3x3Float3", $$robo$$android_graphics_ColorSpace$mul3x3Float3(float[] float[] ), 0, (float[])fArray, (float[])fArray2);
    }

    private static float[] mul3x3Diag(float[] fArray, float[] fArray2) {
        return InvokeDynamicSupport.bootstrapStatic("mul3x3Diag", $$robo$$android_graphics_ColorSpace$mul3x3Diag(float[] float[] ), 0, (float[])fArray, (float[])fArray2);
    }

    private static float[] xyYToXyz(float[] fArray) {
        return InvokeDynamicSupport.bootstrapStatic("xyYToXyz", $$robo$$android_graphics_ColorSpace$xyYToXyz(float[] ), 0, (float[])fArray);
    }

    private static void xyYToUv(float[] fArray) {
        InvokeDynamicSupport.bootstrapStatic("xyYToUv", $$robo$$android_graphics_ColorSpace$xyYToUv(float[] ), 0, (float[])fArray);
    }

    private static float[] chromaticAdaptation(float[] fArray, float[] fArray2, float[] fArray3) {
        return InvokeDynamicSupport.bootstrapStatic("chromaticAdaptation", $$robo$$android_graphics_ColorSpace$chromaticAdaptation(float[] float[] float[] ), 0, (float[])fArray, (float[])fArray2, (float[])fArray3);
    }

    private /* synthetic */ void __constructor__(String string2, Model model, int n, 1 var4_4) {
        this.$$robo$$android_graphics_ColorSpace$__constructor__(string2, model, n, var4_4);
    }

    static {
        RobolectricInternals.classInitializing(ColorSpace.class);
    }

    public /* synthetic */ ColorSpace() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ColorSpace)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Renderer
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int NATIVE_SIZE = 1440;
        private static float UCS_SCALE = 1.5f;
        private static int CHROMATICITY_RESOLUTION = 32;
        private static double ONE_THIRD = 0.3333333333333333;
        private int mSize;
        private boolean mShowWhitePoint;
        private boolean mClip;
        private boolean mUcs;
        private List<Pair<ColorSpace, Integer>> mColorSpaces;
        private List<Point> mPoints;
        private static float[] SPECTRUM_LOCUS_X;
        private static float[] SPECTRUM_LOCUS_Y;

        private void $$robo$$android_graphics_ColorSpace_Renderer$__constructor__() {
            this.mSize = 1024;
            this.mShowWhitePoint = true;
            this.mClip = false;
            this.mUcs = false;
            this.mColorSpaces = new ArrayList<Pair<ColorSpace, Integer>>(2);
            this.mPoints = new ArrayList<Point>(0);
        }

        private final Renderer $$robo$$android_graphics_ColorSpace_Renderer$clip(boolean clip) {
            this.mClip = clip;
            return this;
        }

        private final Renderer $$robo$$android_graphics_ColorSpace_Renderer$uniformChromaticityScale(boolean ucs) {
            this.mUcs = ucs;
            return this;
        }

        private final Renderer $$robo$$android_graphics_ColorSpace_Renderer$size(int size) {
            this.mSize = Math.max(128, size);
            return this;
        }

        private final Renderer $$robo$$android_graphics_ColorSpace_Renderer$showWhitePoint(boolean show) {
            this.mShowWhitePoint = show;
            return this;
        }

        private final Renderer $$robo$$android_graphics_ColorSpace_Renderer$add(ColorSpace colorSpace, int color2) {
            this.mColorSpaces.add(new Pair<ColorSpace, Integer>(colorSpace, color2));
            return this;
        }

        private final Renderer $$robo$$android_graphics_ColorSpace_Renderer$add(ColorSpace colorSpace, float r, float g, float b, int pointColor) {
            this.mPoints.add(new Point(colorSpace, new float[]{r, g, b}, pointColor));
            return this;
        }

        private final Bitmap $$robo$$android_graphics_ColorSpace_Renderer$render() {
            Paint paint = new Paint(1);
            Bitmap bitmap = Bitmap.createBitmap(this.mSize, this.mSize, Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            float[] primaries = new float[6];
            float[] whitePoint = new float[2];
            int width = 1440;
            int height = 1440;
            Path path = new Path();
            this.setTransform(canvas, width, height, primaries);
            this.drawBox(canvas, width, height, paint, path);
            this.setUcsTransform(canvas, height);
            this.drawLocus(canvas, width, height, paint, path, primaries);
            this.drawGamuts(canvas, width, height, paint, path, primaries, whitePoint);
            this.drawPoints(canvas, width, height, paint);
            return bitmap;
        }

        private final void $$robo$$android_graphics_ColorSpace_Renderer$drawPoints(Canvas canvas, int width, int height, Paint paint) {
            paint.setStyle(Paint.Style.FILL);
            float radius = 4.0f / (this.mUcs ? 1.5f : 1.0f);
            float[] v = new float[3];
            float[] xy = new float[2];
            for (Point point : this.mPoints) {
                v[0] = point.mRgb[0];
                v[1] = point.mRgb[1];
                v[2] = point.mRgb[2];
                point.mColorSpace.toXyz(v);
                paint.setColor(point.mColor);
                float sum = v[0] + v[1] + v[2];
                xy[0] = v[0] / sum;
                xy[1] = v[1] / sum;
                if (this.mUcs) {
                    ColorSpace.xyYToUv(xy);
                }
                canvas.drawCircle((float)width * xy[0], (float)height - (float)height * xy[1], radius, paint);
            }
        }

        private final void $$robo$$android_graphics_ColorSpace_Renderer$drawGamuts(Canvas canvas, int width, int height, Paint paint, Path path, float[] primaries, float[] whitePoint) {
            float radius = 4.0f / (this.mUcs ? 1.5f : 1.0f);
            for (Pair<ColorSpace, Integer> item : this.mColorSpaces) {
                ColorSpace colorSpace = (ColorSpace)item.first;
                int color2 = (Integer)item.second;
                if (colorSpace.getModel() != Model.RGB) continue;
                Rgb rgb = (Rgb)colorSpace;
                Renderer.getPrimaries(rgb, primaries, this.mUcs);
                path.rewind();
                path.moveTo((float)width * primaries[0], (float)height - (float)height * primaries[1]);
                path.lineTo((float)width * primaries[2], (float)height - (float)height * primaries[3]);
                path.lineTo((float)width * primaries[4], (float)height - (float)height * primaries[5]);
                path.close();
                paint.setStyle(Paint.Style.STROKE);
                paint.setColor(color2);
                canvas.drawPath(path, paint);
                if (!this.mShowWhitePoint) continue;
                rgb.getWhitePoint(whitePoint);
                if (this.mUcs) {
                    ColorSpace.xyYToUv(whitePoint);
                }
                paint.setStyle(Paint.Style.FILL);
                paint.setColor(color2);
                canvas.drawCircle((float)width * whitePoint[0], (float)height - (float)height * whitePoint[1], radius, paint);
            }
        }

        private static final void $$robo$$android_graphics_ColorSpace_Renderer$getPrimaries(Rgb rgb, float[] primaries, boolean asUcs) {
            if (rgb.equals(ColorSpace.get(Named.EXTENDED_SRGB)) || rgb.equals(ColorSpace.get(Named.LINEAR_EXTENDED_SRGB))) {
                primaries[0] = 1.41f;
                primaries[1] = 0.33f;
                primaries[2] = 0.27f;
                primaries[3] = 1.24f;
                primaries[4] = -0.23f;
                primaries[5] = -0.57f;
            } else {
                rgb.getPrimaries(primaries);
            }
            if (asUcs) {
                ColorSpace.xyYToUv(primaries);
            }
        }

        private final void $$robo$$android_graphics_ColorSpace_Renderer$drawLocus(Canvas canvas, int width, int height, Paint paint, Path path, float[] primaries) {
            int vertexCount = SPECTRUM_LOCUS_X.length * 32 * 6;
            float[] vertices = new float[vertexCount * 2];
            int[] colors = new int[vertices.length];
            Renderer.computeChromaticityMesh(vertices, colors);
            if (this.mUcs) {
                ColorSpace.xyYToUv(vertices);
            }
            for (int i = 0; i < vertices.length; i += 2) {
                int n = i;
                vertices[n] = vertices[n] * (float)width;
                vertices[i + 1] = (float)height - vertices[i + 1] * (float)height;
            }
            if (this.mClip && this.mColorSpaces.size() > 0) {
                for (Pair<ColorSpace, Integer> item : this.mColorSpaces) {
                    ColorSpace colorSpace = (ColorSpace)item.first;
                    if (colorSpace.getModel() != Model.RGB) continue;
                    Rgb rgb = (Rgb)colorSpace;
                    Renderer.getPrimaries(rgb, primaries, this.mUcs);
                    break;
                }
                path.rewind();
                path.moveTo((float)width * primaries[0], (float)height - (float)height * primaries[1]);
                path.lineTo((float)width * primaries[2], (float)height - (float)height * primaries[3]);
                path.lineTo((float)width * primaries[4], (float)height - (float)height * primaries[5]);
                path.close();
                int[] solid = new int[colors.length];
                Arrays.fill(solid, -9671572);
                canvas.drawVertices(Canvas.VertexMode.TRIANGLES, vertices.length, vertices, 0, null, 0, solid, 0, null, 0, 0, paint);
                canvas.save();
                canvas.clipPath(path);
                canvas.drawVertices(Canvas.VertexMode.TRIANGLES, vertices.length, vertices, 0, null, 0, colors, 0, null, 0, 0, paint);
                canvas.restore();
            } else {
                canvas.drawVertices(Canvas.VertexMode.TRIANGLES, vertices.length, vertices, 0, null, 0, colors, 0, null, 0, 0, paint);
            }
            int index = 372;
            path.reset();
            path.moveTo(vertices[index], vertices[index + 1]);
            for (int x = 2; x < SPECTRUM_LOCUS_X.length; ++x) {
                path.lineTo(vertices[index += 384], vertices[index + 1]);
            }
            path.close();
            paint.setStrokeWidth(4.0f / (this.mUcs ? 1.5f : 1.0f));
            paint.setStyle(Paint.Style.STROKE);
            paint.setColor(-16777216);
            canvas.drawPath(path, paint);
        }

        private final void $$robo$$android_graphics_ColorSpace_Renderer$drawBox(Canvas canvas, int width, int height, Paint paint, Path path) {
            float y;
            float x;
            float v;
            int i;
            int lineCount = 10;
            float scale = 1.0f;
            if (this.mUcs) {
                lineCount = 7;
                scale = 1.5f;
            }
            paint.setStyle(Paint.Style.STROKE);
            paint.setStrokeWidth(2.0f);
            paint.setColor(-4144960);
            for (i = 1; i < lineCount - 1; ++i) {
                v = (float)i / 10.0f;
                x = (float)width * v * scale;
                y = (float)height - (float)height * v * scale;
                canvas.drawLine(0.0f, y, 0.9f * (float)width, y, paint);
                canvas.drawLine(x, height, x, 0.1f * (float)height, paint);
            }
            paint.setStrokeWidth(4.0f);
            paint.setColor(-16777216);
            for (i = 1; i < lineCount - 1; ++i) {
                v = (float)i / 10.0f;
                x = (float)width * v * scale;
                y = (float)height - (float)height * v * scale;
                canvas.drawLine(0.0f, y, (float)width / 100.0f, y, paint);
                canvas.drawLine(x, height, x, (float)height - (float)height / 100.0f, paint);
            }
            paint.setStyle(Paint.Style.FILL);
            paint.setTextSize(36.0f);
            paint.setTypeface(Typeface.create("sans-serif-light", 0));
            Rect bounds = new Rect();
            for (int i2 = 1; i2 < lineCount - 1; ++i2) {
                String text = "0." + i2;
                paint.getTextBounds(text, 0, text.length(), bounds);
                float v2 = (float)i2 / 10.0f;
                float x2 = (float)width * v2 * scale;
                float y2 = (float)height - (float)height * v2 * scale;
                canvas.drawText(text, -0.05f * (float)width + 10.0f, y2 + (float)bounds.height() / 2.0f, paint);
                canvas.drawText(text, x2 - (float)bounds.width() / 2.0f, height + bounds.height() + 16, paint);
            }
            paint.setStyle(Paint.Style.STROKE);
            path.moveTo(0.0f, height);
            path.lineTo(0.9f * (float)width, height);
            path.lineTo(0.9f * (float)width, 0.1f * (float)height);
            path.lineTo(0.0f, 0.1f * (float)height);
            path.close();
            canvas.drawPath(path, paint);
        }

        private final void $$robo$$android_graphics_ColorSpace_Renderer$setTransform(Canvas canvas, int width, int height, float[] primaries) {
            RectF primariesBounds = new RectF();
            for (Pair<ColorSpace, Integer> item : this.mColorSpaces) {
                ColorSpace colorSpace = (ColorSpace)item.first;
                if (colorSpace.getModel() != Model.RGB) continue;
                Rgb rgb = (Rgb)colorSpace;
                Renderer.getPrimaries(rgb, primaries, this.mUcs);
                primariesBounds.left = Math.min(primariesBounds.left, primaries[4]);
                primariesBounds.top = Math.min(primariesBounds.top, primaries[5]);
                primariesBounds.right = Math.max(primariesBounds.right, primaries[0]);
                primariesBounds.bottom = Math.max(primariesBounds.bottom, primaries[3]);
            }
            float max = this.mUcs ? 0.6f : 0.9f;
            primariesBounds.left = Math.min(0.0f, primariesBounds.left);
            primariesBounds.top = Math.min(0.0f, primariesBounds.top);
            primariesBounds.right = Math.max(max, primariesBounds.right);
            primariesBounds.bottom = Math.max(max, primariesBounds.bottom);
            float scaleX = max / primariesBounds.width();
            float scaleY = max / primariesBounds.height();
            float scale = Math.min(scaleX, scaleY);
            canvas.scale((float)this.mSize / 1440.0f, (float)this.mSize / 1440.0f);
            canvas.scale(scale, scale);
            canvas.translate((primariesBounds.width() - max) * (float)width / 2.0f, (primariesBounds.height() - max) * (float)height / 2.0f);
            canvas.translate(0.05f * (float)width, -0.05f * (float)height);
        }

        private final void $$robo$$android_graphics_ColorSpace_Renderer$setUcsTransform(Canvas canvas, int height) {
            if (this.mUcs) {
                canvas.translate(0.0f, (float)height - (float)height * 1.5f);
                canvas.scale(1.5f, 1.5f);
            }
        }

        private static final void $$robo$$android_graphics_ColorSpace_Renderer$computeChromaticityMesh(float[] vertices, int[] colors) {
            ColorSpace colorSpace = ColorSpace.get(Named.SRGB);
            float[] color2 = new float[3];
            int vertexIndex = 0;
            int colorIndex = 0;
            for (int x = 0; x < SPECTRUM_LOCUS_X.length; ++x) {
                int nextX = x % (SPECTRUM_LOCUS_X.length - 1) + 1;
                float a1 = (float)Math.atan2((double)SPECTRUM_LOCUS_Y[x] - 0.3333333333333333, (double)SPECTRUM_LOCUS_X[x] - 0.3333333333333333);
                float a2 = (float)Math.atan2((double)SPECTRUM_LOCUS_Y[nextX] - 0.3333333333333333, (double)SPECTRUM_LOCUS_X[nextX] - 0.3333333333333333);
                float radius1 = (float)Math.pow(Renderer.sqr((double)SPECTRUM_LOCUS_X[x] - 0.3333333333333333) + Renderer.sqr((double)SPECTRUM_LOCUS_Y[x] - 0.3333333333333333), 0.5);
                float radius2 = (float)Math.pow(Renderer.sqr((double)SPECTRUM_LOCUS_X[nextX] - 0.3333333333333333) + Renderer.sqr((double)SPECTRUM_LOCUS_Y[nextX] - 0.3333333333333333), 0.5);
                for (int c = 1; c <= 32; ++c) {
                    float f1 = (float)c / 32.0f;
                    float f2 = (float)(c - 1) / 32.0f;
                    double cr1 = (double)radius1 * Math.cos(a1);
                    double sr1 = (double)radius1 * Math.sin(a1);
                    double cr2 = (double)radius2 * Math.cos(a2);
                    double sr2 = (double)radius2 * Math.sin(a2);
                    float v1x = (float)(0.3333333333333333 + cr1 * (double)f1);
                    float v1y = (float)(0.3333333333333333 + sr1 * (double)f1);
                    float v1z = 1.0f - v1x - v1y;
                    float v2x = (float)(0.3333333333333333 + cr1 * (double)f2);
                    float v2y = (float)(0.3333333333333333 + sr1 * (double)f2);
                    float v2z = 1.0f - v2x - v2y;
                    float v3x = (float)(0.3333333333333333 + cr2 * (double)f2);
                    float v3y = (float)(0.3333333333333333 + sr2 * (double)f2);
                    float v3z = 1.0f - v3x - v3y;
                    float v4x = (float)(0.3333333333333333 + cr2 * (double)f1);
                    float v4y = (float)(0.3333333333333333 + sr2 * (double)f1);
                    float v4z = 1.0f - v4x - v4y;
                    colors[colorIndex] = Renderer.computeColor(color2, v1x, v1y, v1z, colorSpace);
                    colors[colorIndex + 1] = Renderer.computeColor(color2, v2x, v2y, v2z, colorSpace);
                    colors[colorIndex + 2] = Renderer.computeColor(color2, v3x, v3y, v3z, colorSpace);
                    colors[colorIndex + 3] = colors[colorIndex];
                    colors[colorIndex + 4] = colors[colorIndex + 2];
                    colors[colorIndex + 5] = Renderer.computeColor(color2, v4x, v4y, v4z, colorSpace);
                    colorIndex += 6;
                    vertices[vertexIndex++] = v1x;
                    vertices[vertexIndex++] = v1y;
                    vertices[vertexIndex++] = v2x;
                    vertices[vertexIndex++] = v2y;
                    vertices[vertexIndex++] = v3x;
                    vertices[vertexIndex++] = v3y;
                    vertices[vertexIndex++] = v1x;
                    vertices[vertexIndex++] = v1y;
                    vertices[vertexIndex++] = v3x;
                    vertices[vertexIndex++] = v3y;
                    vertices[vertexIndex++] = v4x;
                    vertices[vertexIndex++] = v4y;
                }
            }
        }

        private static final int $$robo$$android_graphics_ColorSpace_Renderer$computeColor(float[] color2, float x, float y, float z, ColorSpace cs) {
            color2[0] = x;
            color2[1] = y;
            color2[2] = z;
            cs.fromXyz(color2);
            return 0xFF000000 | ((int)(color2[0] * 255.0f) & 0xFF) << 16 | ((int)(color2[1] * 255.0f) & 0xFF) << 8 | (int)(color2[2] * 255.0f) & 0xFF;
        }

        private static final double $$robo$$android_graphics_ColorSpace_Renderer$sqr(double v) {
            return v * v;
        }

        private /* synthetic */ void $$robo$$android_graphics_ColorSpace_Renderer$__constructor__(1 x0) {
        }

        static void __staticInitializer__() {
            SPECTRUM_LOCUS_X = new float[]{0.175596f, 0.172787f, 0.170806f, 0.170085f, 0.160343f, 0.146958f, 0.139149f, 0.133536f, 0.126688f, 0.11583f, 0.109616f, 0.099146f, 0.09131f, 0.07813f, 0.068717f, 0.054675f, 0.040763f, 0.027497f, 0.01627f, 0.008169f, 0.004876f, 0.003983f, 0.003859f, 0.004646f, 0.007988f, 0.01387f, 0.022244f, 0.027273f, 0.03282f, 0.038851f, 0.045327f, 0.052175f, 0.059323f, 0.066713f, 0.074299f, 0.089937f, 0.114155f, 0.138695f, 0.154714f, 0.192865f, 0.229607f, 0.26576f, 0.301588f, 0.337346f, 0.373083f, 0.408717f, 0.444043f, 0.478755f, 0.512467f, 0.544767f, 0.575132f, 0.602914f, 0.627018f, 0.648215f, 0.665746f, 0.680061f, 0.691487f, 0.700589f, 0.707901f, 0.714015f, 0.719017f, 0.723016f, 0.734674f, 0.717203f, 0.699732f, 0.68226f, 0.664789f, 0.647318f, 0.629847f, 0.612376f, 0.594905f, 0.577433f, 0.559962f, 0.542491f, 0.52502f, 0.507549f, 0.490077f, 0.472606f, 0.455135f, 0.437664f, 0.420193f, 0.402721f, 0.38525f, 0.367779f, 0.350308f, 0.332837f, 0.315366f, 0.297894f, 0.280423f, 0.262952f, 0.245481f, 0.22801f, 0.210538f, 0.193067f, 0.175596f};
            SPECTRUM_LOCUS_Y = new float[]{0.005295f, 0.0048f, 0.005472f, 0.005976f, 0.014496f, 0.026643f, 0.035211f, 0.042704f, 0.053441f, 0.073601f, 0.086866f, 0.112037f, 0.132737f, 0.170464f, 0.200773f, 0.254155f, 0.317049f, 0.387997f, 0.463035f, 0.538504f, 0.587196f, 0.610526f, 0.654897f, 0.67597f, 0.715407f, 0.750246f, 0.779682f, 0.792153f, 0.802971f, 0.812059f, 0.81943f, 0.8252f, 0.82946f, 0.832306f, 0.833833f, 0.833316f, 0.826231f, 0.814796f, 0.805884f, 0.781648f, 0.754347f, 0.724342f, 0.692326f, 0.658867f, 0.62447f, 0.589626f, 0.554734f, 0.520222f, 0.486611f, 0.454454f, 0.424252f, 0.396516f, 0.37251f, 0.351413f, 0.334028f, 0.319765f, 0.308359f, 0.299317f, 0.292044f, 0.285945f, 0.280951f, 0.276964f, 0.265326f, 0.2572f, 0.249074f, 0.240948f, 0.232822f, 0.224696f, 0.21657f, 0.208444f, 0.200318f, 0.192192f, 0.184066f, 0.17594f, 0.167814f, 0.159688f, 0.151562f, 0.143436f, 0.135311f, 0.127185f, 0.119059f, 0.110933f, 0.102807f, 0.094681f, 0.086555f, 0.078429f, 0.070303f, 0.062177f, 0.054051f, 0.045925f, 0.037799f, 0.029673f, 0.021547f, 0.013421f, 0.005295f};
        }

        private void __constructor__() {
            this.$$robo$$android_graphics_ColorSpace_Renderer$__constructor__();
        }

        private Renderer() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_ColorSpace_Renderer$__constructor__(), 0, this);
        }

        public Renderer clip(boolean bl) {
            return InvokeDynamicSupport.bootstrap("clip", $$robo$$android_graphics_ColorSpace_Renderer$clip(boolean ), 0, this, bl);
        }

        public Renderer uniformChromaticityScale(boolean bl) {
            return InvokeDynamicSupport.bootstrap("uniformChromaticityScale", $$robo$$android_graphics_ColorSpace_Renderer$uniformChromaticityScale(boolean ), 0, this, bl);
        }

        public Renderer size(int n) {
            return InvokeDynamicSupport.bootstrap("size", $$robo$$android_graphics_ColorSpace_Renderer$size(int ), 0, this, n);
        }

        public Renderer showWhitePoint(boolean bl) {
            return InvokeDynamicSupport.bootstrap("showWhitePoint", $$robo$$android_graphics_ColorSpace_Renderer$showWhitePoint(boolean ), 0, this, bl);
        }

        public Renderer add(ColorSpace colorSpace, int n) {
            return InvokeDynamicSupport.bootstrap("add", $$robo$$android_graphics_ColorSpace_Renderer$add(android.graphics.ColorSpace int ), 0, this, colorSpace, n);
        }

        public Renderer add(ColorSpace colorSpace, float f, float f2, float f3, int n) {
            return InvokeDynamicSupport.bootstrap("add", $$robo$$android_graphics_ColorSpace_Renderer$add(android.graphics.ColorSpace float float float int ), 0, this, colorSpace, f, f2, f3, n);
        }

        public Bitmap render() {
            return InvokeDynamicSupport.bootstrap("render", $$robo$$android_graphics_ColorSpace_Renderer$render(), 0, this);
        }

        private void drawPoints(Canvas canvas, int n, int n2, Paint paint) {
            InvokeDynamicSupport.bootstrap("drawPoints", $$robo$$android_graphics_ColorSpace_Renderer$drawPoints(android.graphics.Canvas int int android.graphics.Paint ), 0, this, canvas, n, n2, paint);
        }

        private void drawGamuts(Canvas canvas, int n, int n2, Paint paint, Path path, float[] fArray, float[] fArray2) {
            InvokeDynamicSupport.bootstrap("drawGamuts", $$robo$$android_graphics_ColorSpace_Renderer$drawGamuts(android.graphics.Canvas int int android.graphics.Paint android.graphics.Path float[] float[] ), 0, this, canvas, n, n2, paint, path, fArray, fArray2);
        }

        private static void getPrimaries(Rgb rgb, float[] fArray, boolean bl) {
            InvokeDynamicSupport.bootstrapStatic("getPrimaries", $$robo$$android_graphics_ColorSpace_Renderer$getPrimaries(android.graphics.ColorSpace$Rgb float[] boolean ), 0, (Rgb)rgb, (float[])fArray, (boolean)bl);
        }

        private void drawLocus(Canvas canvas, int n, int n2, Paint paint, Path path, float[] fArray) {
            InvokeDynamicSupport.bootstrap("drawLocus", $$robo$$android_graphics_ColorSpace_Renderer$drawLocus(android.graphics.Canvas int int android.graphics.Paint android.graphics.Path float[] ), 0, this, canvas, n, n2, paint, path, fArray);
        }

        private void drawBox(Canvas canvas, int n, int n2, Paint paint, Path path) {
            InvokeDynamicSupport.bootstrap("drawBox", $$robo$$android_graphics_ColorSpace_Renderer$drawBox(android.graphics.Canvas int int android.graphics.Paint android.graphics.Path ), 0, this, canvas, n, n2, paint, path);
        }

        private void setTransform(Canvas canvas, int n, int n2, float[] fArray) {
            InvokeDynamicSupport.bootstrap("setTransform", $$robo$$android_graphics_ColorSpace_Renderer$setTransform(android.graphics.Canvas int int float[] ), 0, this, canvas, n, n2, fArray);
        }

        private void setUcsTransform(Canvas canvas, int n) {
            InvokeDynamicSupport.bootstrap("setUcsTransform", $$robo$$android_graphics_ColorSpace_Renderer$setUcsTransform(android.graphics.Canvas int ), 0, this, canvas, n);
        }

        private static void computeChromaticityMesh(float[] fArray, int[] nArray) {
            InvokeDynamicSupport.bootstrapStatic("computeChromaticityMesh", $$robo$$android_graphics_ColorSpace_Renderer$computeChromaticityMesh(float[] int[] ), 0, (float[])fArray, (int[])nArray);
        }

        private static int computeColor(float[] fArray, float f, float f2, float f3, ColorSpace colorSpace) {
            return (int)InvokeDynamicSupport.bootstrapStatic("computeColor", $$robo$$android_graphics_ColorSpace_Renderer$computeColor(float[] float float float android.graphics.ColorSpace ), 0, (float[])fArray, (float)f, (float)f2, (float)f3, (ColorSpace)colorSpace);
        }

        private static double sqr(double d) {
            return (double)InvokeDynamicSupport.bootstrapStatic("sqr", $$robo$$android_graphics_ColorSpace_Renderer$sqr(double ), 0, (double)d);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_graphics_ColorSpace_Renderer$__constructor__(var1_1);
        }

        static {
            RobolectricInternals.classInitializing(Renderer.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Renderer)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        private static class Point
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            ColorSpace mColorSpace;
            float[] mRgb;
            int mColor;

            private void $$robo$$android_graphics_ColorSpace_Renderer_Point$__constructor__(ColorSpace colorSpace, float[] rgb, int color2) {
                this.mColorSpace = colorSpace;
                this.mRgb = rgb;
                this.mColor = color2;
            }

            private void __constructor__(ColorSpace colorSpace, float[] fArray, int n) {
                this.$$robo$$android_graphics_ColorSpace_Renderer_Point$__constructor__(colorSpace, fArray, n);
            }

            Point(ColorSpace colorSpace, float[] fArray, int n) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_ColorSpace_Renderer_Point$__constructor__(android.graphics.ColorSpace float[] int ), 0, this, colorSpace, fArray, n);
            }

            public /* synthetic */ Point() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Point)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    public static class Connector
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private ColorSpace mSource;
        private ColorSpace mDestination;
        private ColorSpace mTransformSource;
        private ColorSpace mTransformDestination;
        private RenderIntent mIntent;
        private float[] mTransform;

        private void $$robo$$android_graphics_ColorSpace_Connector$__constructor__(ColorSpace source, ColorSpace destination, RenderIntent intent) {
        }

        private void $$robo$$android_graphics_ColorSpace_Connector$__constructor__(ColorSpace source, ColorSpace destination, ColorSpace transformSource, ColorSpace transformDestination, RenderIntent intent, float[] transform) {
            this.mSource = source;
            this.mDestination = destination;
            this.mTransformSource = transformSource;
            this.mTransformDestination = transformDestination;
            this.mIntent = intent;
            this.mTransform = transform;
        }

        private static final float[] $$robo$$android_graphics_ColorSpace_Connector$computeTransform(ColorSpace source, ColorSpace destination, RenderIntent intent) {
            boolean dstRGB;
            if (intent != RenderIntent.ABSOLUTE) {
                return null;
            }
            boolean srcRGB = source.getModel() == Model.RGB;
            boolean bl = dstRGB = destination.getModel() == Model.RGB;
            if (srcRGB && dstRGB) {
                return null;
            }
            if (srcRGB || dstRGB) {
                android.graphics.ColorSpace$Rgb rgb = (android.graphics.ColorSpace$Rgb)(srcRGB ? source : destination);
                float[] srcXYZ = srcRGB ? ColorSpace.xyYToXyz(rgb.mWhitePoint) : ILLUMINANT_D50_XYZ;
                float[] dstXYZ = dstRGB ? ColorSpace.xyYToXyz(rgb.mWhitePoint) : ILLUMINANT_D50_XYZ;
                return new float[]{srcXYZ[0] / dstXYZ[0], srcXYZ[1] / dstXYZ[1], srcXYZ[2] / dstXYZ[2]};
            }
            return null;
        }

        private final ColorSpace $$robo$$android_graphics_ColorSpace_Connector$getSource() {
            return this.mSource;
        }

        private final ColorSpace $$robo$$android_graphics_ColorSpace_Connector$getDestination() {
            return this.mDestination;
        }

        private final RenderIntent $$robo$$android_graphics_ColorSpace_Connector$getRenderIntent() {
            return this.mIntent;
        }

        private final float[] $$robo$$android_graphics_ColorSpace_Connector$transform(float r, float g, float b) {
            return this.transform(new float[]{r, g, b});
        }

        private final float[] $$robo$$android_graphics_ColorSpace_Connector$transform(float[] v) {
            float[] xyz = this.mTransformSource.toXyz(v);
            if (this.mTransform != null) {
                xyz[0] = xyz[0] * this.mTransform[0];
                xyz[1] = xyz[1] * this.mTransform[1];
                xyz[2] = xyz[2] * this.mTransform[2];
            }
            return this.mTransformDestination.fromXyz(xyz);
        }

        private static final Connector $$robo$$android_graphics_ColorSpace_Connector$identity(ColorSpace source) {
            return new ShadowedObject(source, source, RenderIntent.RELATIVE){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_graphics_ColorSpace_Connector_1$__constructor__(ColorSpace source, ColorSpace destination, RenderIntent intent) {
                }

                private final float[] $$robo$$android_graphics_ColorSpace_Connector_1$transform(float[] v) {
                    return v;
                }

                @Override
                private void __constructor__(ColorSpace colorSpace, ColorSpace colorSpace2, RenderIntent renderIntent) {
                    this.$$robo$$android_graphics_ColorSpace_Connector_1$__constructor__(colorSpace, colorSpace2, renderIntent);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_ColorSpace_Connector_1$__constructor__(android.graphics.ColorSpace android.graphics.ColorSpace android.graphics.ColorSpace$RenderIntent ), 0, this, colorSpace, colorSpace2, renderIntent);
                }

                @Override
                public float[] transform(float[] fArray) {
                    return InvokeDynamicSupport.bootstrap("transform", $$robo$$android_graphics_ColorSpace_Connector_1$transform(float[] ), 0, this, fArray);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private /* synthetic */ void $$robo$$android_graphics_ColorSpace_Connector$__constructor__(ColorSpace x0, ColorSpace x1, ColorSpace x2, ColorSpace x3, RenderIntent x4, float[] x5, 1 x6) {
        }

        private void __constructor__(ColorSpace colorSpace, ColorSpace colorSpace2, RenderIntent renderIntent) {
            this.$$robo$$android_graphics_ColorSpace_Connector$__constructor__(colorSpace, colorSpace2, renderIntent);
        }

        Connector(ColorSpace colorSpace, ColorSpace colorSpace2, RenderIntent renderIntent) {
            this(colorSpace, colorSpace2, colorSpace.getModel() == Model.RGB ? ColorSpace.adapt(colorSpace, ILLUMINANT_D50_XYZ) : colorSpace, colorSpace2.getModel() == Model.RGB ? ColorSpace.adapt(colorSpace2, ILLUMINANT_D50_XYZ) : colorSpace2, renderIntent, Connector.computeTransform(colorSpace, colorSpace2, renderIntent));
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_ColorSpace_Connector$__constructor__(android.graphics.ColorSpace android.graphics.ColorSpace android.graphics.ColorSpace$RenderIntent ), 0, this, colorSpace, colorSpace2, renderIntent);
        }

        private void __constructor__(ColorSpace colorSpace, ColorSpace colorSpace2, ColorSpace colorSpace3, ColorSpace colorSpace4, RenderIntent renderIntent, float[] fArray) {
            this.$$robo$$android_graphics_ColorSpace_Connector$__constructor__(colorSpace, colorSpace2, colorSpace3, colorSpace4, renderIntent, fArray);
        }

        private Connector(ColorSpace colorSpace, ColorSpace colorSpace2, ColorSpace colorSpace3, ColorSpace colorSpace4, RenderIntent renderIntent, float[] fArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_ColorSpace_Connector$__constructor__(android.graphics.ColorSpace android.graphics.ColorSpace android.graphics.ColorSpace android.graphics.ColorSpace android.graphics.ColorSpace$RenderIntent float[] ), 0, this, colorSpace, colorSpace2, colorSpace3, colorSpace4, renderIntent, fArray);
        }

        private static float[] computeTransform(ColorSpace colorSpace, ColorSpace colorSpace2, RenderIntent renderIntent) {
            return InvokeDynamicSupport.bootstrapStatic("computeTransform", $$robo$$android_graphics_ColorSpace_Connector$computeTransform(android.graphics.ColorSpace android.graphics.ColorSpace android.graphics.ColorSpace$RenderIntent ), 0, (ColorSpace)colorSpace, (ColorSpace)colorSpace2, (RenderIntent)renderIntent);
        }

        public ColorSpace getSource() {
            return InvokeDynamicSupport.bootstrap("getSource", $$robo$$android_graphics_ColorSpace_Connector$getSource(), 0, this);
        }

        public ColorSpace getDestination() {
            return InvokeDynamicSupport.bootstrap("getDestination", $$robo$$android_graphics_ColorSpace_Connector$getDestination(), 0, this);
        }

        public RenderIntent getRenderIntent() {
            return InvokeDynamicSupport.bootstrap("getRenderIntent", $$robo$$android_graphics_ColorSpace_Connector$getRenderIntent(), 0, this);
        }

        public float[] transform(float f, float f2, float f3) {
            return InvokeDynamicSupport.bootstrap("transform", $$robo$$android_graphics_ColorSpace_Connector$transform(float float float ), 0, this, f, f2, f3);
        }

        public float[] transform(float[] fArray) {
            return InvokeDynamicSupport.bootstrap("transform", $$robo$$android_graphics_ColorSpace_Connector$transform(float[] ), 0, this, fArray);
        }

        static Connector identity(ColorSpace colorSpace) {
            return InvokeDynamicSupport.bootstrapStatic("identity", $$robo$$android_graphics_ColorSpace_Connector$identity(android.graphics.ColorSpace ), 0, (ColorSpace)colorSpace);
        }

        private /* synthetic */ void __constructor__(ColorSpace colorSpace, ColorSpace colorSpace2, ColorSpace colorSpace3, ColorSpace colorSpace4, RenderIntent renderIntent, float[] fArray, 1 var7_7) {
            this.$$robo$$android_graphics_ColorSpace_Connector$__constructor__(colorSpace, colorSpace2, colorSpace3, colorSpace4, renderIntent, fArray, var7_7);
        }

        public /* synthetic */ Connector() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Connector)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        private static class Rgb
        extends Connector
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            private android.graphics.ColorSpace$Rgb mSource;
            private android.graphics.ColorSpace$Rgb mDestination;
            private float[] mTransform;

            private void $$robo$$android_graphics_ColorSpace_Connector_Rgb$__constructor__(android.graphics.ColorSpace$Rgb source, android.graphics.ColorSpace$Rgb destination, RenderIntent intent) {
                this.mSource = source;
                this.mDestination = destination;
                this.mTransform = Rgb.computeTransform(source, destination, intent);
            }

            private final float[] $$robo$$android_graphics_ColorSpace_Connector_Rgb$transform(float[] rgb) {
                rgb[0] = (float)this.mSource.mClampedEotf.applyAsDouble(rgb[0]);
                rgb[1] = (float)this.mSource.mClampedEotf.applyAsDouble(rgb[1]);
                rgb[2] = (float)this.mSource.mClampedEotf.applyAsDouble(rgb[2]);
                ColorSpace.mul3x3Float3(this.mTransform, rgb);
                rgb[0] = (float)this.mDestination.mClampedOetf.applyAsDouble(rgb[0]);
                rgb[1] = (float)this.mDestination.mClampedOetf.applyAsDouble(rgb[1]);
                rgb[2] = (float)this.mDestination.mClampedOetf.applyAsDouble(rgb[2]);
                return rgb;
            }

            private static final float[] $$robo$$android_graphics_ColorSpace_Connector_Rgb$computeTransform(android.graphics.ColorSpace$Rgb source, android.graphics.ColorSpace$Rgb destination, RenderIntent intent) {
                if (ColorSpace.compare(source.mWhitePoint, destination.mWhitePoint)) {
                    return ColorSpace.mul3x3(destination.mInverseTransform, source.mTransform);
                }
                float[] transform = source.mTransform;
                float[] inverseTransform = destination.mInverseTransform;
                float[] srcXYZ = ColorSpace.xyYToXyz(source.mWhitePoint);
                float[] dstXYZ = ColorSpace.xyYToXyz(destination.mWhitePoint);
                if (!ColorSpace.compare(source.mWhitePoint, ILLUMINANT_D50)) {
                    float[] srcAdaptation = ColorSpace.chromaticAdaptation(Adaptation.BRADFORD.mTransform, srcXYZ, Arrays.copyOf(ILLUMINANT_D50_XYZ, 3));
                    transform = ColorSpace.mul3x3(srcAdaptation, source.mTransform);
                }
                if (!ColorSpace.compare(destination.mWhitePoint, ILLUMINANT_D50)) {
                    float[] dstAdaptation = ColorSpace.chromaticAdaptation(Adaptation.BRADFORD.mTransform, dstXYZ, Arrays.copyOf(ILLUMINANT_D50_XYZ, 3));
                    inverseTransform = ColorSpace.inverse3x3(ColorSpace.mul3x3(dstAdaptation, destination.mTransform));
                }
                if (intent == RenderIntent.ABSOLUTE) {
                    transform = ColorSpace.mul3x3Diag(new float[]{srcXYZ[0] / dstXYZ[0], srcXYZ[1] / dstXYZ[1], srcXYZ[2] / dstXYZ[2]}, transform);
                }
                return ColorSpace.mul3x3(inverseTransform, transform);
            }

            private void __constructor__(android.graphics.ColorSpace$Rgb rgb, android.graphics.ColorSpace$Rgb rgb2, RenderIntent renderIntent) {
                this.$$robo$$android_graphics_ColorSpace_Connector_Rgb$__constructor__(rgb, rgb2, renderIntent);
            }

            Rgb(android.graphics.ColorSpace$Rgb rgb, android.graphics.ColorSpace$Rgb rgb2, RenderIntent renderIntent) {
                super(rgb, rgb2, rgb, rgb2, renderIntent, null);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_ColorSpace_Connector_Rgb$__constructor__(android.graphics.ColorSpace$Rgb android.graphics.ColorSpace$Rgb android.graphics.ColorSpace$RenderIntent ), 0, this, rgb, rgb2, renderIntent);
            }

            @Override
            public float[] transform(float[] fArray) {
                return InvokeDynamicSupport.bootstrap("transform", $$robo$$android_graphics_ColorSpace_Connector_Rgb$transform(float[] ), 0, this, fArray);
            }

            private static float[] computeTransform(android.graphics.ColorSpace$Rgb rgb, android.graphics.ColorSpace$Rgb rgb2, RenderIntent renderIntent) {
                return InvokeDynamicSupport.bootstrapStatic("computeTransform", $$robo$$android_graphics_ColorSpace_Connector_Rgb$computeTransform(android.graphics.ColorSpace$Rgb android.graphics.ColorSpace$Rgb android.graphics.ColorSpace$RenderIntent ), 0, (android.graphics.ColorSpace$Rgb)rgb, (android.graphics.ColorSpace$Rgb)rgb2, (RenderIntent)renderIntent);
            }

            public /* synthetic */ Rgb() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Rgb)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    public static class Rgb
    extends ColorSpace
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private float[] mWhitePoint;
        private float[] mPrimaries;
        private float[] mTransform;
        private float[] mInverseTransform;
        private DoubleUnaryOperator mOetf;
        private DoubleUnaryOperator mEotf;
        private DoubleUnaryOperator mClampedOetf;
        private DoubleUnaryOperator mClampedEotf;
        private float mMin;
        private float mMax;
        private boolean mIsWideGamut;
        private boolean mIsSrgb;
        private TransferParameters mTransferParameters;

        private void $$robo$$android_graphics_ColorSpace_Rgb$__constructor__(String name, float[] toXYZ, DoubleUnaryOperator oetf, DoubleUnaryOperator eotf) {
        }

        private void $$robo$$android_graphics_ColorSpace_Rgb$__constructor__(String name, float[] primaries, float[] whitePoint, DoubleUnaryOperator oetf, DoubleUnaryOperator eotf, float min, float max) {
        }

        private void $$robo$$android_graphics_ColorSpace_Rgb$__constructor__(String name, float[] toXYZ, TransferParameters function) {
        }

        private void $$robo$$android_graphics_ColorSpace_Rgb$__constructor__(String name, float[] primaries, float[] whitePoint, TransferParameters function) {
        }

        private void $$robo$$android_graphics_ColorSpace_Rgb$__constructor__(String name, float[] primaries, float[] whitePoint, TransferParameters function, int id2) {
            this.mTransferParameters = function;
        }

        private void $$robo$$android_graphics_ColorSpace_Rgb$__constructor__(String name, float[] toXYZ, double gamma) {
        }

        private void $$robo$$android_graphics_ColorSpace_Rgb$__constructor__(String name, float[] primaries, float[] whitePoint, double gamma) {
        }

        private void $$robo$$android_graphics_ColorSpace_Rgb$__constructor__(String name, float[] primaries, float[] whitePoint, double gamma, float min, float max, int id2) {
            this.mTransferParameters = gamma == 1.0 ? new TransferParameters(0.0, 0.0, 1.0, 1.0 + (double)Math.ulp(1.0f), gamma) : new TransferParameters(1.0, 0.0, 0.0, 0.0, gamma);
        }

        private void $$robo$$android_graphics_ColorSpace_Rgb$__constructor__(String name, float[] primaries, float[] whitePoint, DoubleUnaryOperator oetf, DoubleUnaryOperator eotf, float min, float max, int id2) {
            if (primaries == null || primaries.length != 6 && primaries.length != 9) {
                throw new IllegalArgumentException("The color space's primaries must be defined as an array of 6 floats in xyY or 9 floats in XYZ");
            }
            if (whitePoint == null || whitePoint.length != 2 && whitePoint.length != 3) {
                throw new IllegalArgumentException("The color space's white point must be defined as an array of 2 floats in xyY or 3 float in XYZ");
            }
            if (oetf == null || eotf == null) {
                throw new IllegalArgumentException("The transfer functions of a color space cannot be null");
            }
            if (min >= max) {
                throw new IllegalArgumentException("Invalid range: min=" + min + ", max=" + max + "; min must be strictly < max");
            }
            this.mWhitePoint = Rgb.xyWhitePoint(whitePoint);
            this.mPrimaries = Rgb.xyPrimaries(primaries);
            this.mTransform = Rgb.computeXYZMatrix(this.mPrimaries, this.mWhitePoint);
            this.mInverseTransform = ColorSpace.inverse3x3(this.mTransform);
            this.mOetf = oetf;
            this.mEotf = eotf;
            this.mMin = min;
            this.mMax = max;
            DoubleUnaryOperator clamp = this::clamp;
            this.mClampedOetf = oetf.andThen(clamp);
            this.mClampedEotf = clamp.andThen(eotf);
            this.mIsWideGamut = Rgb.isWideGamut(this.mPrimaries, min, max);
            this.mIsSrgb = Rgb.isSrgb(this.mPrimaries, this.mWhitePoint, oetf, eotf, min, max, id2);
        }

        private void $$robo$$android_graphics_ColorSpace_Rgb$__constructor__(Rgb colorSpace, float[] transform, float[] whitePoint) {
            this.mWhitePoint = Rgb.xyWhitePoint(whitePoint);
            this.mPrimaries = colorSpace.mPrimaries;
            this.mTransform = transform;
            this.mInverseTransform = ColorSpace.inverse3x3(transform);
            this.mMin = colorSpace.mMin;
            this.mMax = colorSpace.mMax;
            this.mOetf = colorSpace.mOetf;
            this.mEotf = colorSpace.mEotf;
            this.mClampedOetf = colorSpace.mClampedOetf;
            this.mClampedEotf = colorSpace.mClampedEotf;
            this.mIsWideGamut = colorSpace.mIsWideGamut;
            this.mIsSrgb = colorSpace.mIsSrgb;
            this.mTransferParameters = colorSpace.mTransferParameters;
        }

        private final float[] $$robo$$android_graphics_ColorSpace_Rgb$getWhitePoint(float[] whitePoint) {
            whitePoint[0] = this.mWhitePoint[0];
            whitePoint[1] = this.mWhitePoint[1];
            return whitePoint;
        }

        private final float[] $$robo$$android_graphics_ColorSpace_Rgb$getWhitePoint() {
            return Arrays.copyOf(this.mWhitePoint, this.mWhitePoint.length);
        }

        private final float[] $$robo$$android_graphics_ColorSpace_Rgb$getPrimaries(float[] primaries) {
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (float[])this.mPrimaries, (int)0, (float[])primaries, (int)0, (int)this.mPrimaries.length);
            return primaries;
        }

        private final float[] $$robo$$android_graphics_ColorSpace_Rgb$getPrimaries() {
            return Arrays.copyOf(this.mPrimaries, this.mPrimaries.length);
        }

        private final float[] $$robo$$android_graphics_ColorSpace_Rgb$getTransform(float[] transform) {
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (float[])this.mTransform, (int)0, (float[])transform, (int)0, (int)this.mTransform.length);
            return transform;
        }

        private final float[] $$robo$$android_graphics_ColorSpace_Rgb$getTransform() {
            return Arrays.copyOf(this.mTransform, this.mTransform.length);
        }

        private final float[] $$robo$$android_graphics_ColorSpace_Rgb$getInverseTransform(float[] inverseTransform) {
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (float[])this.mInverseTransform, (int)0, (float[])inverseTransform, (int)0, (int)this.mInverseTransform.length);
            return inverseTransform;
        }

        private final float[] $$robo$$android_graphics_ColorSpace_Rgb$getInverseTransform() {
            return Arrays.copyOf(this.mInverseTransform, this.mInverseTransform.length);
        }

        private final DoubleUnaryOperator $$robo$$android_graphics_ColorSpace_Rgb$getOetf() {
            return this.mClampedOetf;
        }

        private final DoubleUnaryOperator $$robo$$android_graphics_ColorSpace_Rgb$getEotf() {
            return this.mClampedEotf;
        }

        private final TransferParameters $$robo$$android_graphics_ColorSpace_Rgb$getTransferParameters() {
            return this.mTransferParameters;
        }

        private final boolean $$robo$$android_graphics_ColorSpace_Rgb$isSrgb() {
            return this.mIsSrgb;
        }

        private final boolean $$robo$$android_graphics_ColorSpace_Rgb$isWideGamut() {
            return this.mIsWideGamut;
        }

        private final float $$robo$$android_graphics_ColorSpace_Rgb$getMinValue(int component) {
            return this.mMin;
        }

        private final float $$robo$$android_graphics_ColorSpace_Rgb$getMaxValue(int component) {
            return this.mMax;
        }

        private final float[] $$robo$$android_graphics_ColorSpace_Rgb$toLinear(float r, float g, float b) {
            return this.toLinear(new float[]{r, g, b});
        }

        private final float[] $$robo$$android_graphics_ColorSpace_Rgb$toLinear(float[] v) {
            v[0] = (float)this.mClampedEotf.applyAsDouble(v[0]);
            v[1] = (float)this.mClampedEotf.applyAsDouble(v[1]);
            v[2] = (float)this.mClampedEotf.applyAsDouble(v[2]);
            return v;
        }

        private final float[] $$robo$$android_graphics_ColorSpace_Rgb$fromLinear(float r, float g, float b) {
            return this.fromLinear(new float[]{r, g, b});
        }

        private final float[] $$robo$$android_graphics_ColorSpace_Rgb$fromLinear(float[] v) {
            v[0] = (float)this.mClampedOetf.applyAsDouble(v[0]);
            v[1] = (float)this.mClampedOetf.applyAsDouble(v[1]);
            v[2] = (float)this.mClampedOetf.applyAsDouble(v[2]);
            return v;
        }

        private final float[] $$robo$$android_graphics_ColorSpace_Rgb$toXyz(float[] v) {
            v[0] = (float)this.mClampedEotf.applyAsDouble(v[0]);
            v[1] = (float)this.mClampedEotf.applyAsDouble(v[1]);
            v[2] = (float)this.mClampedEotf.applyAsDouble(v[2]);
            return ColorSpace.mul3x3Float3(this.mTransform, v);
        }

        private final float[] $$robo$$android_graphics_ColorSpace_Rgb$fromXyz(float[] v) {
            ColorSpace.mul3x3Float3(this.mInverseTransform, v);
            v[0] = (float)this.mClampedOetf.applyAsDouble(v[0]);
            v[1] = (float)this.mClampedOetf.applyAsDouble(v[1]);
            v[2] = (float)this.mClampedOetf.applyAsDouble(v[2]);
            return v;
        }

        private final double $$robo$$android_graphics_ColorSpace_Rgb$clamp(double x) {
            return x < (double)this.mMin ? (double)this.mMin : (x > (double)this.mMax ? (double)this.mMax : x);
        }

        private final boolean $$robo$$android_graphics_ColorSpace_Rgb$equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Rgb rgb = (Rgb)o;
            if (Float.compare(rgb.mMin, this.mMin) != 0) {
                return false;
            }
            if (Float.compare(rgb.mMax, this.mMax) != 0) {
                return false;
            }
            if (!Arrays.equals(this.mWhitePoint, rgb.mWhitePoint)) {
                return false;
            }
            if (!Arrays.equals(this.mPrimaries, rgb.mPrimaries)) {
                return false;
            }
            if (this.mTransferParameters != null) {
                return this.mTransferParameters.equals(rgb.mTransferParameters);
            }
            if (rgb.mTransferParameters == null) {
                return true;
            }
            if (!this.mOetf.equals(rgb.mOetf)) {
                return false;
            }
            return this.mEotf.equals(rgb.mEotf);
        }

        private final int $$robo$$android_graphics_ColorSpace_Rgb$hashCode() {
            int result = super.hashCode();
            result = 31 * result + Arrays.hashCode(this.mWhitePoint);
            result = 31 * result + Arrays.hashCode(this.mPrimaries);
            result = 31 * result + (this.mMin != 0.0f ? Float.floatToIntBits(this.mMin) : 0);
            result = 31 * result + (this.mMax != 0.0f ? Float.floatToIntBits(this.mMax) : 0);
            result = 31 * result + (this.mTransferParameters != null ? this.mTransferParameters.hashCode() : 0);
            if (this.mTransferParameters == null) {
                result = 31 * result + this.mOetf.hashCode();
                result = 31 * result + this.mEotf.hashCode();
            }
            return result;
        }

        private static final boolean $$robo$$android_graphics_ColorSpace_Rgb$isSrgb(float[] primaries, float[] whitePoint, DoubleUnaryOperator OETF, DoubleUnaryOperator EOTF, float min, float max, int id2) {
            if (id2 == 0) {
                return true;
            }
            if (!ColorSpace.compare(primaries, SRGB_PRIMARIES)) {
                return false;
            }
            if (!ColorSpace.compare(whitePoint, Rgb.ILLUMINANT_D65)) {
                return false;
            }
            if (OETF.applyAsDouble(0.5) < 0.5001) {
                return false;
            }
            if (EOTF.applyAsDouble(0.5) > 0.5001) {
                return false;
            }
            if (min != 0.0f) {
                return false;
            }
            return max == 1.0f;
        }

        private static final boolean $$robo$$android_graphics_ColorSpace_Rgb$isWideGamut(float[] primaries, float min, float max) {
            return Rgb.area(primaries) / Rgb.area(NTSC_1953_PRIMARIES) > 0.9f && Rgb.contains(primaries, SRGB_PRIMARIES) || min < 0.0f && max > 1.0f;
        }

        private static final float $$robo$$android_graphics_ColorSpace_Rgb$area(float[] primaries) {
            float Rx = primaries[0];
            float Gy = primaries[3];
            float Ry = primaries[1];
            float Bx = primaries[4];
            float Gx = primaries[2];
            float By = primaries[5];
            float det = Rx * Gy + Ry * Bx + Gx * By - Gy * Bx - Ry * Gx - Rx * By;
            float r = 0.5f * det;
            return r < 0.0f ? -r : r;
        }

        private static final float $$robo$$android_graphics_ColorSpace_Rgb$cross(float ax, float ay, float bx, float by) {
            return ax * by - ay * bx;
        }

        private static final boolean $$robo$$android_graphics_ColorSpace_Rgb$contains(float[] p1, float[] p2) {
            float[] p0 = new float[]{p1[0] - p2[0], p1[1] - p2[1], p1[2] - p2[2], p1[3] - p2[3], p1[4] - p2[4], p1[5] - p2[5]};
            if (Rgb.cross(p0[0], p0[1], p2[0] - p2[4], p2[1] - p2[5]) < 0.0f || Rgb.cross(p2[0] - p2[2], p2[1] - p2[3], p0[0], p0[1]) < 0.0f) {
                return false;
            }
            if (Rgb.cross(p0[2], p0[3], p2[2] - p2[0], p2[3] - p2[1]) < 0.0f || Rgb.cross(p2[2] - p2[4], p2[3] - p2[5], p0[2], p0[3]) < 0.0f) {
                return false;
            }
            return !(Rgb.cross(p0[4], p0[5], p2[4] - p2[2], p2[5] - p2[3]) < 0.0f) && !(Rgb.cross(p2[4] - p2[0], p2[5] - p2[1], p0[4], p0[5]) < 0.0f);
        }

        private static final float[] $$robo$$android_graphics_ColorSpace_Rgb$computePrimaries(float[] toXYZ) {
            float[] r = ColorSpace.mul3x3Float3(toXYZ, new float[]{1.0f, 0.0f, 0.0f});
            float[] g = ColorSpace.mul3x3Float3(toXYZ, new float[]{0.0f, 1.0f, 0.0f});
            float[] b = ColorSpace.mul3x3Float3(toXYZ, new float[]{0.0f, 0.0f, 1.0f});
            float rSum = r[0] + r[1] + r[2];
            float gSum = g[0] + g[1] + g[2];
            float bSum = b[0] + b[1] + b[2];
            return new float[]{r[0] / rSum, r[1] / rSum, g[0] / gSum, g[1] / gSum, b[0] / bSum, b[1] / bSum};
        }

        private static final float[] $$robo$$android_graphics_ColorSpace_Rgb$computeWhitePoint(float[] toXYZ) {
            float[] w = ColorSpace.mul3x3Float3(toXYZ, new float[]{1.0f, 1.0f, 1.0f});
            float sum = w[0] + w[1] + w[2];
            return new float[]{w[0] / sum, w[1] / sum};
        }

        private static final float[] $$robo$$android_graphics_ColorSpace_Rgb$xyPrimaries(float[] primaries) {
            float[] xyPrimaries = new float[6];
            if (primaries.length == 9) {
                float sum = primaries[0] + primaries[1] + primaries[2];
                xyPrimaries[0] = primaries[0] / sum;
                xyPrimaries[1] = primaries[1] / sum;
                sum = primaries[3] + primaries[4] + primaries[5];
                xyPrimaries[2] = primaries[3] / sum;
                xyPrimaries[3] = primaries[4] / sum;
                sum = primaries[6] + primaries[7] + primaries[8];
                xyPrimaries[4] = primaries[6] / sum;
                xyPrimaries[5] = primaries[7] / sum;
            } else {
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (float[])primaries, (int)0, (float[])xyPrimaries, (int)0, (int)6);
            }
            return xyPrimaries;
        }

        private static final float[] $$robo$$android_graphics_ColorSpace_Rgb$xyWhitePoint(float[] whitePoint) {
            float[] xyWhitePoint = new float[2];
            if (whitePoint.length == 3) {
                float sum = whitePoint[0] + whitePoint[1] + whitePoint[2];
                xyWhitePoint[0] = whitePoint[0] / sum;
                xyWhitePoint[1] = whitePoint[1] / sum;
            } else {
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (float[])whitePoint, (int)0, (float[])xyWhitePoint, (int)0, (int)2);
            }
            return xyWhitePoint;
        }

        private static final float[] $$robo$$android_graphics_ColorSpace_Rgb$computeXYZMatrix(float[] primaries, float[] whitePoint) {
            float Rx = primaries[0];
            float Ry = primaries[1];
            float Gx = primaries[2];
            float Gy = primaries[3];
            float Bx = primaries[4];
            float By = primaries[5];
            float Wx = whitePoint[0];
            float Wy = whitePoint[1];
            float oneRxRy = (1.0f - Rx) / Ry;
            float oneGxGy = (1.0f - Gx) / Gy;
            float oneBxBy = (1.0f - Bx) / By;
            float oneWxWy = (1.0f - Wx) / Wy;
            float RxRy = Rx / Ry;
            float GxGy = Gx / Gy;
            float BxBy = Bx / By;
            float WxWy = Wx / Wy;
            float BY = ((oneWxWy - oneRxRy) * (GxGy - RxRy) - (WxWy - RxRy) * (oneGxGy - oneRxRy)) / ((oneBxBy - oneRxRy) * (GxGy - RxRy) - (BxBy - RxRy) * (oneGxGy - oneRxRy));
            float GY = (WxWy - RxRy - BY * (BxBy - RxRy)) / (GxGy - RxRy);
            float RY = 1.0f - GY - BY;
            float RYRy = RY / Ry;
            float GYGy = GY / Gy;
            float BYBy = BY / By;
            return new float[]{RYRy * Rx, RY, RYRy * (1.0f - Rx - Ry), GYGy * Gx, GY, GYGy * (1.0f - Gx - Gy), BYBy * Bx, BY, BYBy * (1.0f - Bx - By)};
        }

        private /* synthetic */ void $$robo$$android_graphics_ColorSpace_Rgb$__constructor__(Rgb x0, float[] x1, float[] x2, 1 x3) {
        }

        private /* synthetic */ void $$robo$$android_graphics_ColorSpace_Rgb$__constructor__(String x0, float[] x1, float[] x2, TransferParameters x3, int x4, 1 x5) {
        }

        private /* synthetic */ void $$robo$$android_graphics_ColorSpace_Rgb$__constructor__(String x0, float[] x1, float[] x2, double x3, float x4, float x5, int x6, 1 x7) {
        }

        private /* synthetic */ void $$robo$$android_graphics_ColorSpace_Rgb$__constructor__(String x0, float[] x1, float[] x2, DoubleUnaryOperator x3, DoubleUnaryOperator x4, float x5, float x6, int x7, 1 x8) {
        }

        private void __constructor__(String string2, float[] fArray, DoubleUnaryOperator doubleUnaryOperator, DoubleUnaryOperator doubleUnaryOperator2) {
            this.$$robo$$android_graphics_ColorSpace_Rgb$__constructor__(string2, fArray, doubleUnaryOperator, doubleUnaryOperator2);
        }

        public Rgb(String string2, float[] fArray, DoubleUnaryOperator doubleUnaryOperator, DoubleUnaryOperator doubleUnaryOperator2) {
            this(string2, Rgb.computePrimaries(fArray), Rgb.computeWhitePoint(fArray), doubleUnaryOperator, doubleUnaryOperator2, 0.0f, 1.0f, -1);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_ColorSpace_Rgb$__constructor__(java.lang.String float[] java.util.function.DoubleUnaryOperator java.util.function.DoubleUnaryOperator ), 0, this, string2, fArray, doubleUnaryOperator, doubleUnaryOperator2);
        }

        private void __constructor__(String string2, float[] fArray, float[] fArray2, DoubleUnaryOperator doubleUnaryOperator, DoubleUnaryOperator doubleUnaryOperator2, float f, float f2) {
            this.$$robo$$android_graphics_ColorSpace_Rgb$__constructor__(string2, fArray, fArray2, doubleUnaryOperator, doubleUnaryOperator2, f, f2);
        }

        public Rgb(String string2, float[] fArray, float[] fArray2, DoubleUnaryOperator doubleUnaryOperator, DoubleUnaryOperator doubleUnaryOperator2, float f, float f2) {
            this(string2, fArray, fArray2, doubleUnaryOperator, doubleUnaryOperator2, f, f2, -1);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_ColorSpace_Rgb$__constructor__(java.lang.String float[] float[] java.util.function.DoubleUnaryOperator java.util.function.DoubleUnaryOperator float float ), 0, this, string2, fArray, fArray2, doubleUnaryOperator, doubleUnaryOperator2, f, f2);
        }

        private void __constructor__(String string2, float[] fArray, TransferParameters transferParameters) {
            this.$$robo$$android_graphics_ColorSpace_Rgb$__constructor__(string2, fArray, transferParameters);
        }

        public Rgb(String string2, float[] fArray, TransferParameters transferParameters) {
            this(string2, Rgb.computePrimaries(fArray), Rgb.computeWhitePoint(fArray), transferParameters, -1);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_ColorSpace_Rgb$__constructor__(java.lang.String float[] android.graphics.ColorSpace$Rgb$TransferParameters ), 0, this, string2, fArray, transferParameters);
        }

        private void __constructor__(String string2, float[] fArray, float[] fArray2, TransferParameters transferParameters) {
            this.$$robo$$android_graphics_ColorSpace_Rgb$__constructor__(string2, fArray, fArray2, transferParameters);
        }

        public Rgb(String string2, float[] fArray, float[] fArray2, TransferParameters transferParameters) {
            this(string2, fArray, fArray2, transferParameters, -1);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_ColorSpace_Rgb$__constructor__(java.lang.String float[] float[] android.graphics.ColorSpace$Rgb$TransferParameters ), 0, this, string2, fArray, fArray2, transferParameters);
        }

        private void __constructor__(String string2, float[] fArray, float[] fArray2, TransferParameters transferParameters, int n) {
            this.$$robo$$android_graphics_ColorSpace_Rgb$__constructor__(string2, fArray, fArray2, transferParameters, n);
        }

        private Rgb(String string2, float[] fArray, float[] fArray2, TransferParameters transferParameters, int n) {
            this(string2, fArray, fArray2, transferParameters.e == 0.0 && transferParameters.f == 0.0 ? x -> ColorSpace.rcpResponse(x, transferParameters.a, transferParameters.b, transferParameters.c, transferParameters.d, transferParameters.g) : x -> ColorSpace.rcpResponse(x, transferParameters.a, transferParameters.b, transferParameters.c, transferParameters.d, transferParameters.e, transferParameters.f, transferParameters.g), transferParameters.e == 0.0 && transferParameters.f == 0.0 ? x -> ColorSpace.response(x, transferParameters.a, transferParameters.b, transferParameters.c, transferParameters.d, transferParameters.g) : x -> ColorSpace.response(x, transferParameters.a, transferParameters.b, transferParameters.c, transferParameters.d, transferParameters.e, transferParameters.f, transferParameters.g), 0.0f, 1.0f, n);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_ColorSpace_Rgb$__constructor__(java.lang.String float[] float[] android.graphics.ColorSpace$Rgb$TransferParameters int ), 0, this, string2, fArray, fArray2, transferParameters, n);
        }

        private void __constructor__(String string2, float[] fArray, double d) {
            this.$$robo$$android_graphics_ColorSpace_Rgb$__constructor__(string2, fArray, d);
        }

        public Rgb(String string2, float[] fArray, double d) {
            this(string2, Rgb.computePrimaries(fArray), Rgb.computeWhitePoint(fArray), d, 0.0f, 1.0f, -1);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_ColorSpace_Rgb$__constructor__(java.lang.String float[] double ), 0, this, string2, fArray, d);
        }

        private void __constructor__(String string2, float[] fArray, float[] fArray2, double d) {
            this.$$robo$$android_graphics_ColorSpace_Rgb$__constructor__(string2, fArray, fArray2, d);
        }

        public Rgb(String string2, float[] fArray, float[] fArray2, double d) {
            this(string2, fArray, fArray2, d, 0.0f, 1.0f, -1);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_ColorSpace_Rgb$__constructor__(java.lang.String float[] float[] double ), 0, this, string2, fArray, fArray2, d);
        }

        private void __constructor__(String string2, float[] fArray, float[] fArray2, double d, float f, float f2, int n) {
            this.$$robo$$android_graphics_ColorSpace_Rgb$__constructor__(string2, fArray, fArray2, d, f, f2, n);
        }

        private Rgb(String string2, float[] fArray, float[] fArray2, double d, float f, float f2, int n) {
            this(string2, fArray, fArray2, d == 1.0 ? DoubleUnaryOperator.identity() : x -> Math.pow(x < 0.0 ? 0.0 : x, 1.0 / d), d == 1.0 ? DoubleUnaryOperator.identity() : x -> Math.pow(x < 0.0 ? 0.0 : x, d), f, f2, n);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_ColorSpace_Rgb$__constructor__(java.lang.String float[] float[] double float float int ), 0, this, string2, fArray, fArray2, d, f, f2, n);
        }

        private void __constructor__(String string2, float[] fArray, float[] fArray2, DoubleUnaryOperator doubleUnaryOperator, DoubleUnaryOperator doubleUnaryOperator2, float f, float f2, int n) {
            this.$$robo$$android_graphics_ColorSpace_Rgb$__constructor__(string2, fArray, fArray2, doubleUnaryOperator, doubleUnaryOperator2, f, f2, n);
        }

        private Rgb(String string2, float[] fArray, float[] fArray2, DoubleUnaryOperator doubleUnaryOperator, DoubleUnaryOperator doubleUnaryOperator2, float f, float f2, int n) {
            super(string2, Model.RGB, n);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_ColorSpace_Rgb$__constructor__(java.lang.String float[] float[] java.util.function.DoubleUnaryOperator java.util.function.DoubleUnaryOperator float float int ), 0, this, string2, fArray, fArray2, doubleUnaryOperator, doubleUnaryOperator2, f, f2, n);
        }

        private void __constructor__(Rgb rgb, float[] fArray, float[] fArray2) {
            this.$$robo$$android_graphics_ColorSpace_Rgb$__constructor__(rgb, fArray, fArray2);
        }

        private Rgb(Rgb rgb, float[] fArray, float[] fArray2) {
            super(rgb.getName(), Model.RGB, -1);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_ColorSpace_Rgb$__constructor__(android.graphics.ColorSpace$Rgb float[] float[] ), 0, this, rgb, fArray, fArray2);
        }

        public float[] getWhitePoint(float[] fArray) {
            return InvokeDynamicSupport.bootstrap("getWhitePoint", $$robo$$android_graphics_ColorSpace_Rgb$getWhitePoint(float[] ), 0, this, fArray);
        }

        public float[] getWhitePoint() {
            return InvokeDynamicSupport.bootstrap("getWhitePoint", $$robo$$android_graphics_ColorSpace_Rgb$getWhitePoint(), 0, this);
        }

        public float[] getPrimaries(float[] fArray) {
            return InvokeDynamicSupport.bootstrap("getPrimaries", $$robo$$android_graphics_ColorSpace_Rgb$getPrimaries(float[] ), 0, this, fArray);
        }

        public float[] getPrimaries() {
            return InvokeDynamicSupport.bootstrap("getPrimaries", $$robo$$android_graphics_ColorSpace_Rgb$getPrimaries(), 0, this);
        }

        public float[] getTransform(float[] fArray) {
            return InvokeDynamicSupport.bootstrap("getTransform", $$robo$$android_graphics_ColorSpace_Rgb$getTransform(float[] ), 0, this, fArray);
        }

        public float[] getTransform() {
            return InvokeDynamicSupport.bootstrap("getTransform", $$robo$$android_graphics_ColorSpace_Rgb$getTransform(), 0, this);
        }

        public float[] getInverseTransform(float[] fArray) {
            return InvokeDynamicSupport.bootstrap("getInverseTransform", $$robo$$android_graphics_ColorSpace_Rgb$getInverseTransform(float[] ), 0, this, fArray);
        }

        public float[] getInverseTransform() {
            return InvokeDynamicSupport.bootstrap("getInverseTransform", $$robo$$android_graphics_ColorSpace_Rgb$getInverseTransform(), 0, this);
        }

        public DoubleUnaryOperator getOetf() {
            return InvokeDynamicSupport.bootstrap("getOetf", $$robo$$android_graphics_ColorSpace_Rgb$getOetf(), 0, this);
        }

        public DoubleUnaryOperator getEotf() {
            return InvokeDynamicSupport.bootstrap("getEotf", $$robo$$android_graphics_ColorSpace_Rgb$getEotf(), 0, this);
        }

        public TransferParameters getTransferParameters() {
            return InvokeDynamicSupport.bootstrap("getTransferParameters", $$robo$$android_graphics_ColorSpace_Rgb$getTransferParameters(), 0, this);
        }

        @Override
        public boolean isSrgb() {
            return (boolean)InvokeDynamicSupport.bootstrap("isSrgb", $$robo$$android_graphics_ColorSpace_Rgb$isSrgb(), 0, this);
        }

        @Override
        public boolean isWideGamut() {
            return (boolean)InvokeDynamicSupport.bootstrap("isWideGamut", $$robo$$android_graphics_ColorSpace_Rgb$isWideGamut(), 0, this);
        }

        @Override
        public float getMinValue(int n) {
            return (float)InvokeDynamicSupport.bootstrap("getMinValue", $$robo$$android_graphics_ColorSpace_Rgb$getMinValue(int ), 0, this, n);
        }

        @Override
        public float getMaxValue(int n) {
            return (float)InvokeDynamicSupport.bootstrap("getMaxValue", $$robo$$android_graphics_ColorSpace_Rgb$getMaxValue(int ), 0, this, n);
        }

        public float[] toLinear(float f, float f2, float f3) {
            return InvokeDynamicSupport.bootstrap("toLinear", $$robo$$android_graphics_ColorSpace_Rgb$toLinear(float float float ), 0, this, f, f2, f3);
        }

        public float[] toLinear(float[] fArray) {
            return InvokeDynamicSupport.bootstrap("toLinear", $$robo$$android_graphics_ColorSpace_Rgb$toLinear(float[] ), 0, this, fArray);
        }

        public float[] fromLinear(float f, float f2, float f3) {
            return InvokeDynamicSupport.bootstrap("fromLinear", $$robo$$android_graphics_ColorSpace_Rgb$fromLinear(float float float ), 0, this, f, f2, f3);
        }

        public float[] fromLinear(float[] fArray) {
            return InvokeDynamicSupport.bootstrap("fromLinear", $$robo$$android_graphics_ColorSpace_Rgb$fromLinear(float[] ), 0, this, fArray);
        }

        @Override
        public float[] toXyz(float[] fArray) {
            return InvokeDynamicSupport.bootstrap("toXyz", $$robo$$android_graphics_ColorSpace_Rgb$toXyz(float[] ), 0, this, fArray);
        }

        @Override
        public float[] fromXyz(float[] fArray) {
            return InvokeDynamicSupport.bootstrap("fromXyz", $$robo$$android_graphics_ColorSpace_Rgb$fromXyz(float[] ), 0, this, fArray);
        }

        private double clamp(double d) {
            return (double)InvokeDynamicSupport.bootstrap("clamp", $$robo$$android_graphics_ColorSpace_Rgb$clamp(double ), 0, this, d);
        }

        @Override
        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_graphics_ColorSpace_Rgb$equals(java.lang.Object ), 0, this, object);
        }

        @Override
        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_graphics_ColorSpace_Rgb$hashCode(), 0, this);
        }

        private static boolean isSrgb(float[] fArray, float[] fArray2, DoubleUnaryOperator doubleUnaryOperator, DoubleUnaryOperator doubleUnaryOperator2, float f, float f2, int n) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("isSrgb", $$robo$$android_graphics_ColorSpace_Rgb$isSrgb(float[] float[] java.util.function.DoubleUnaryOperator java.util.function.DoubleUnaryOperator float float int ), 0, (float[])fArray, (float[])fArray2, (DoubleUnaryOperator)doubleUnaryOperator, (DoubleUnaryOperator)doubleUnaryOperator2, (float)f, (float)f2, (int)n);
        }

        private static boolean isWideGamut(float[] fArray, float f, float f2) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("isWideGamut", $$robo$$android_graphics_ColorSpace_Rgb$isWideGamut(float[] float float ), 0, (float[])fArray, (float)f, (float)f2);
        }

        private static float area(float[] fArray) {
            return (float)InvokeDynamicSupport.bootstrapStatic("area", $$robo$$android_graphics_ColorSpace_Rgb$area(float[] ), 0, (float[])fArray);
        }

        private static float cross(float f, float f2, float f3, float f4) {
            return (float)InvokeDynamicSupport.bootstrapStatic("cross", $$robo$$android_graphics_ColorSpace_Rgb$cross(float float float float ), 0, (float)f, (float)f2, (float)f3, (float)f4);
        }

        private static boolean contains(float[] fArray, float[] fArray2) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("contains", $$robo$$android_graphics_ColorSpace_Rgb$contains(float[] float[] ), 0, (float[])fArray, (float[])fArray2);
        }

        private static float[] computePrimaries(float[] fArray) {
            return InvokeDynamicSupport.bootstrapStatic("computePrimaries", $$robo$$android_graphics_ColorSpace_Rgb$computePrimaries(float[] ), 0, (float[])fArray);
        }

        private static float[] computeWhitePoint(float[] fArray) {
            return InvokeDynamicSupport.bootstrapStatic("computeWhitePoint", $$robo$$android_graphics_ColorSpace_Rgb$computeWhitePoint(float[] ), 0, (float[])fArray);
        }

        private static float[] xyPrimaries(float[] fArray) {
            return InvokeDynamicSupport.bootstrapStatic("xyPrimaries", $$robo$$android_graphics_ColorSpace_Rgb$xyPrimaries(float[] ), 0, (float[])fArray);
        }

        private static float[] xyWhitePoint(float[] fArray) {
            return InvokeDynamicSupport.bootstrapStatic("xyWhitePoint", $$robo$$android_graphics_ColorSpace_Rgb$xyWhitePoint(float[] ), 0, (float[])fArray);
        }

        private static float[] computeXYZMatrix(float[] fArray, float[] fArray2) {
            return InvokeDynamicSupport.bootstrapStatic("computeXYZMatrix", $$robo$$android_graphics_ColorSpace_Rgb$computeXYZMatrix(float[] float[] ), 0, (float[])fArray, (float[])fArray2);
        }

        private /* synthetic */ void __constructor__(Rgb rgb, float[] fArray, float[] fArray2, 1 var4_4) {
            this.$$robo$$android_graphics_ColorSpace_Rgb$__constructor__(rgb, fArray, fArray2, var4_4);
        }

        private /* synthetic */ void __constructor__(String string2, float[] fArray, float[] fArray2, TransferParameters transferParameters, int n, 1 var6_6) {
            this.$$robo$$android_graphics_ColorSpace_Rgb$__constructor__(string2, fArray, fArray2, transferParameters, n, var6_6);
        }

        private /* synthetic */ void __constructor__(String string2, float[] fArray, float[] fArray2, double d, float f, float f2, int n, 1 var9_8) {
            this.$$robo$$android_graphics_ColorSpace_Rgb$__constructor__(string2, fArray, fArray2, d, f, f2, n, var9_8);
        }

        private /* synthetic */ void __constructor__(String string2, float[] fArray, float[] fArray2, DoubleUnaryOperator doubleUnaryOperator, DoubleUnaryOperator doubleUnaryOperator2, float f, float f2, int n, 1 var9_9) {
            this.$$robo$$android_graphics_ColorSpace_Rgb$__constructor__(string2, fArray, fArray2, doubleUnaryOperator, doubleUnaryOperator2, f, f2, n, var9_9);
        }

        public /* synthetic */ Rgb() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Rgb)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        public static class TransferParameters
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            public double a;
            public double b;
            public double c;
            public double d;
            public double e;
            public double f;
            public double g;

            private void $$robo$$android_graphics_ColorSpace_Rgb_TransferParameters$__constructor__(double a, double b, double c, double d, double g) {
            }

            private void $$robo$$android_graphics_ColorSpace_Rgb_TransferParameters$__constructor__(double a, double b, double c, double d, double e, double f, double g) {
                if (Double.isNaN(a) || Double.isNaN(b) || Double.isNaN(c) || Double.isNaN(d) || Double.isNaN(e) || Double.isNaN(f) || Double.isNaN(g)) {
                    throw new IllegalArgumentException("Parameters cannot be NaN");
                }
                if (!(d >= 0.0) || !(d <= (double)(1.0f + Math.ulp(1.0f)))) {
                    throw new IllegalArgumentException("Parameter d must be in the range [0..1], was " + d);
                }
                if (d == 0.0 && (a == 0.0 || g == 0.0)) {
                    throw new IllegalArgumentException("Parameter a or g is zero, the transfer function is constant");
                }
                if (d >= 1.0 && c == 0.0) {
                    throw new IllegalArgumentException("Parameter c is zero, the transfer function is constant");
                }
                if ((a == 0.0 || g == 0.0) && c == 0.0) {
                    throw new IllegalArgumentException("Parameter a or g is zero, and c is zero, the transfer function is constant");
                }
                if (c < 0.0) {
                    throw new IllegalArgumentException("The transfer function must be increasing");
                }
                if (a < 0.0 || g < 0.0) {
                    throw new IllegalArgumentException("The transfer function must be positive or increasing");
                }
                this.a = a;
                this.b = b;
                this.c = c;
                this.d = d;
                this.e = e;
                this.f = f;
                this.g = g;
            }

            private final boolean $$robo$$android_graphics_ColorSpace_Rgb_TransferParameters$equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                TransferParameters that = (TransferParameters)o;
                if (Double.compare(that.a, this.a) != 0) {
                    return false;
                }
                if (Double.compare(that.b, this.b) != 0) {
                    return false;
                }
                if (Double.compare(that.c, this.c) != 0) {
                    return false;
                }
                if (Double.compare(that.d, this.d) != 0) {
                    return false;
                }
                if (Double.compare(that.e, this.e) != 0) {
                    return false;
                }
                if (Double.compare(that.f, this.f) != 0) {
                    return false;
                }
                return Double.compare(that.g, this.g) == 0;
            }

            private final int $$robo$$android_graphics_ColorSpace_Rgb_TransferParameters$hashCode() {
                long temp = Double.doubleToLongBits(this.a);
                int result = (int)(temp ^ temp >>> 32);
                temp = Double.doubleToLongBits(this.b);
                result = 31 * result + (int)(temp ^ temp >>> 32);
                temp = Double.doubleToLongBits(this.c);
                result = 31 * result + (int)(temp ^ temp >>> 32);
                temp = Double.doubleToLongBits(this.d);
                result = 31 * result + (int)(temp ^ temp >>> 32);
                temp = Double.doubleToLongBits(this.e);
                result = 31 * result + (int)(temp ^ temp >>> 32);
                temp = Double.doubleToLongBits(this.f);
                result = 31 * result + (int)(temp ^ temp >>> 32);
                temp = Double.doubleToLongBits(this.g);
                result = 31 * result + (int)(temp ^ temp >>> 32);
                return result;
            }

            private void __constructor__(double d, double d2, double d3, double d4, double d5) {
                this.$$robo$$android_graphics_ColorSpace_Rgb_TransferParameters$__constructor__(d, d2, d3, d4, d5);
            }

            public TransferParameters(double d, double d2, double d3, double d4, double d5) {
                this(d, d2, d3, d4, 0.0, 0.0, d5);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_ColorSpace_Rgb_TransferParameters$__constructor__(double double double double double ), 0, this, d, d2, d3, d4, d5);
            }

            private void __constructor__(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
                this.$$robo$$android_graphics_ColorSpace_Rgb_TransferParameters$__constructor__(d, d2, d3, d4, d5, d6, d7);
            }

            public TransferParameters(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_ColorSpace_Rgb_TransferParameters$__constructor__(double double double double double double double ), 0, this, d, d2, d3, d4, d5, d6, d7);
            }

            public boolean equals(Object object) {
                return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_graphics_ColorSpace_Rgb_TransferParameters$equals(java.lang.Object ), 0, this, object);
            }

            public int hashCode() {
                return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_graphics_ColorSpace_Rgb_TransferParameters$hashCode(), 0, this);
            }

            public /* synthetic */ TransferParameters() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TransferParameters)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class Lab
    extends ColorSpace
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static float A = 0.008856452f;
        private static float B = 7.787037f;
        private static float C = 0.13793103f;
        private static float D = 0.20689656f;

        private void $$robo$$android_graphics_ColorSpace_Lab$__constructor__(String name, int id2) {
        }

        private final boolean $$robo$$android_graphics_ColorSpace_Lab$isWideGamut() {
            return true;
        }

        private final float $$robo$$android_graphics_ColorSpace_Lab$getMinValue(int component) {
            return component == 0 ? 0.0f : -128.0f;
        }

        private final float $$robo$$android_graphics_ColorSpace_Lab$getMaxValue(int component) {
            return component == 0 ? 100.0f : 128.0f;
        }

        private final float[] $$robo$$android_graphics_ColorSpace_Lab$toXyz(float[] v) {
            v[0] = Lab.clamp(v[0], 0.0f, 100.0f);
            v[1] = Lab.clamp(v[1], -128.0f, 128.0f);
            v[2] = Lab.clamp(v[2], -128.0f, 128.0f);
            float fy = (v[0] + 16.0f) / 116.0f;
            float fx = fy + v[1] * 0.002f;
            float fz = fy - v[2] * 0.005f;
            float X = fx > 0.20689656f ? fx * fx * fx : 0.12841855f * (fx - 0.13793103f);
            float Y = fy > 0.20689656f ? fy * fy * fy : 0.12841855f * (fy - 0.13793103f);
            float Z = fz > 0.20689656f ? fz * fz * fz : 0.12841855f * (fz - 0.13793103f);
            v[0] = X * ILLUMINANT_D50_XYZ[0];
            v[1] = Y * ILLUMINANT_D50_XYZ[1];
            v[2] = Z * ILLUMINANT_D50_XYZ[2];
            return v;
        }

        private final float[] $$robo$$android_graphics_ColorSpace_Lab$fromXyz(float[] v) {
            float X = v[0] / ILLUMINANT_D50_XYZ[0];
            float Y = v[1] / ILLUMINANT_D50_XYZ[1];
            float Z = v[2] / ILLUMINANT_D50_XYZ[2];
            float fx = X > 0.008856452f ? (float)Math.pow(X, 0.3333333333333333) : 7.787037f * X + 0.13793103f;
            float fy = Y > 0.008856452f ? (float)Math.pow(Y, 0.3333333333333333) : 7.787037f * Y + 0.13793103f;
            float fz = Z > 0.008856452f ? (float)Math.pow(Z, 0.3333333333333333) : 7.787037f * Z + 0.13793103f;
            float L = 116.0f * fy - 16.0f;
            float a = 500.0f * (fx - fy);
            float b = 200.0f * (fy - fz);
            v[0] = Lab.clamp(L, 0.0f, 100.0f);
            v[1] = Lab.clamp(a, -128.0f, 128.0f);
            v[2] = Lab.clamp(b, -128.0f, 128.0f);
            return v;
        }

        private static final float $$robo$$android_graphics_ColorSpace_Lab$clamp(float x, float min, float max) {
            return x < min ? min : (x > max ? max : x);
        }

        private /* synthetic */ void $$robo$$android_graphics_ColorSpace_Lab$__constructor__(String x0, int x1, 1 x2) {
        }

        private void __constructor__(String string2, int n) {
            this.$$robo$$android_graphics_ColorSpace_Lab$__constructor__(string2, n);
        }

        private Lab(String string2, int n) {
            super(string2, Model.LAB, n);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_ColorSpace_Lab$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        @Override
        public boolean isWideGamut() {
            return (boolean)InvokeDynamicSupport.bootstrap("isWideGamut", $$robo$$android_graphics_ColorSpace_Lab$isWideGamut(), 0, this);
        }

        @Override
        public float getMinValue(int n) {
            return (float)InvokeDynamicSupport.bootstrap("getMinValue", $$robo$$android_graphics_ColorSpace_Lab$getMinValue(int ), 0, this, n);
        }

        @Override
        public float getMaxValue(int n) {
            return (float)InvokeDynamicSupport.bootstrap("getMaxValue", $$robo$$android_graphics_ColorSpace_Lab$getMaxValue(int ), 0, this, n);
        }

        @Override
        public float[] toXyz(float[] fArray) {
            return InvokeDynamicSupport.bootstrap("toXyz", $$robo$$android_graphics_ColorSpace_Lab$toXyz(float[] ), 0, this, fArray);
        }

        @Override
        public float[] fromXyz(float[] fArray) {
            return InvokeDynamicSupport.bootstrap("fromXyz", $$robo$$android_graphics_ColorSpace_Lab$fromXyz(float[] ), 0, this, fArray);
        }

        private static float clamp(float f, float f2, float f3) {
            return (float)InvokeDynamicSupport.bootstrapStatic("clamp", $$robo$$android_graphics_ColorSpace_Lab$clamp(float float float ), 0, (float)f, (float)f2, (float)f3);
        }

        private /* synthetic */ void __constructor__(String string2, int n, 1 var3_3) {
            this.$$robo$$android_graphics_ColorSpace_Lab$__constructor__(string2, n, var3_3);
        }

        public /* synthetic */ Lab() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Lab)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class Xyz
    extends ColorSpace
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_graphics_ColorSpace_Xyz$__constructor__(String name, int id2) {
        }

        private final boolean $$robo$$android_graphics_ColorSpace_Xyz$isWideGamut() {
            return true;
        }

        private final float $$robo$$android_graphics_ColorSpace_Xyz$getMinValue(int component) {
            return -2.0f;
        }

        private final float $$robo$$android_graphics_ColorSpace_Xyz$getMaxValue(int component) {
            return 2.0f;
        }

        private final float[] $$robo$$android_graphics_ColorSpace_Xyz$toXyz(float[] v) {
            v[0] = Xyz.clamp(v[0]);
            v[1] = Xyz.clamp(v[1]);
            v[2] = Xyz.clamp(v[2]);
            return v;
        }

        private final float[] $$robo$$android_graphics_ColorSpace_Xyz$fromXyz(float[] v) {
            v[0] = Xyz.clamp(v[0]);
            v[1] = Xyz.clamp(v[1]);
            v[2] = Xyz.clamp(v[2]);
            return v;
        }

        private static final float $$robo$$android_graphics_ColorSpace_Xyz$clamp(float x) {
            return x < -2.0f ? -2.0f : (x > 2.0f ? 2.0f : x);
        }

        private /* synthetic */ void $$robo$$android_graphics_ColorSpace_Xyz$__constructor__(String x0, int x1, 1 x2) {
        }

        private void __constructor__(String string2, int n) {
            this.$$robo$$android_graphics_ColorSpace_Xyz$__constructor__(string2, n);
        }

        private Xyz(String string2, int n) {
            super(string2, Model.XYZ, n);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_ColorSpace_Xyz$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        @Override
        public boolean isWideGamut() {
            return (boolean)InvokeDynamicSupport.bootstrap("isWideGamut", $$robo$$android_graphics_ColorSpace_Xyz$isWideGamut(), 0, this);
        }

        @Override
        public float getMinValue(int n) {
            return (float)InvokeDynamicSupport.bootstrap("getMinValue", $$robo$$android_graphics_ColorSpace_Xyz$getMinValue(int ), 0, this, n);
        }

        @Override
        public float getMaxValue(int n) {
            return (float)InvokeDynamicSupport.bootstrap("getMaxValue", $$robo$$android_graphics_ColorSpace_Xyz$getMaxValue(int ), 0, this, n);
        }

        @Override
        public float[] toXyz(float[] fArray) {
            return InvokeDynamicSupport.bootstrap("toXyz", $$robo$$android_graphics_ColorSpace_Xyz$toXyz(float[] ), 0, this, fArray);
        }

        @Override
        public float[] fromXyz(float[] fArray) {
            return InvokeDynamicSupport.bootstrap("fromXyz", $$robo$$android_graphics_ColorSpace_Xyz$fromXyz(float[] ), 0, this, fArray);
        }

        private static float clamp(float f) {
            return (float)InvokeDynamicSupport.bootstrapStatic("clamp", $$robo$$android_graphics_ColorSpace_Xyz$clamp(float ), 0, (float)f);
        }

        private /* synthetic */ void __constructor__(String string2, int n, 1 var3_3) {
            this.$$robo$$android_graphics_ColorSpace_Xyz$__constructor__(string2, n, var3_3);
        }

        public /* synthetic */ Xyz() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Xyz)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class Model
    extends Enum<Model> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ Model RGB;
        public static /* enum */ Model XYZ;
        public static /* enum */ Model LAB;
        public static /* enum */ Model CMYK;
        private int mComponentCount;
        private static /* synthetic */ Model[] $VALUES;

        private static final Model[] $$robo$$android_graphics_ColorSpace_Model$values() {
            return (Model[])$VALUES.clone();
        }

        private static final Model $$robo$$android_graphics_ColorSpace_Model$valueOf(String name) {
            return Enum.valueOf(Model.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_graphics_ColorSpace_Model$__constructor__(String string2, int n, int componentCount) {
            this.mComponentCount = componentCount;
        }

        private final int $$robo$$android_graphics_ColorSpace_Model$getComponentCount() {
            return this.mComponentCount;
        }

        static void __staticInitializer__() {
            RGB = new Model(3);
            XYZ = new Model(3);
            LAB = new Model(3);
            CMYK = new Model(4);
            $VALUES = new Model[]{RGB, XYZ, LAB, CMYK};
        }

        public static Model[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_graphics_ColorSpace_Model$values(), 0);
        }

        public static Model valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_graphics_ColorSpace_Model$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n, int n2) {
            this.$$robo$$android_graphics_ColorSpace_Model$__constructor__(string2, n, n2);
        }

        private Model(int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_ColorSpace_Model$__constructor__(java.lang.String int int ), 0, this, string2, n, n2);
        }

        public int getComponentCount() {
            return (int)InvokeDynamicSupport.bootstrap("getComponentCount", $$robo$$android_graphics_ColorSpace_Model$getComponentCount(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(Model.class);
        }

        public /* synthetic */ Model() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Model)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class Adaptation
    extends Enum<Adaptation> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ Adaptation BRADFORD;
        public static /* enum */ Adaptation VON_KRIES;
        public static /* enum */ Adaptation CIECAT02;
        float[] mTransform;
        private static /* synthetic */ Adaptation[] $VALUES;

        private static final Adaptation[] $$robo$$android_graphics_ColorSpace_Adaptation$values() {
            return (Adaptation[])$VALUES.clone();
        }

        private static final Adaptation $$robo$$android_graphics_ColorSpace_Adaptation$valueOf(String name) {
            return Enum.valueOf(Adaptation.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_graphics_ColorSpace_Adaptation$__constructor__(String string2, int n, float[] transform) {
            this.mTransform = transform;
        }

        static void __staticInitializer__() {
            BRADFORD = new Adaptation(new float[]{0.8951f, -0.7502f, 0.0389f, 0.2664f, 1.7135f, -0.0685f, -0.1614f, 0.0367f, 1.0296f});
            VON_KRIES = new Adaptation(new float[]{0.40024f, -0.2263f, 0.0f, 0.7076f, 1.16532f, 0.0f, -0.08081f, 0.0457f, 0.91822f});
            CIECAT02 = new Adaptation(new float[]{0.7328f, -0.7036f, 0.003f, 0.4296f, 1.6975f, 0.0136f, -0.1624f, 0.0061f, 0.9834f});
            $VALUES = new Adaptation[]{BRADFORD, VON_KRIES, CIECAT02};
        }

        public static Adaptation[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_graphics_ColorSpace_Adaptation$values(), 0);
        }

        public static Adaptation valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_graphics_ColorSpace_Adaptation$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n, float[] fArray) {
            this.$$robo$$android_graphics_ColorSpace_Adaptation$__constructor__(string2, n, fArray);
        }

        private Adaptation(float[] fArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_ColorSpace_Adaptation$__constructor__(java.lang.String int float[] ), 0, this, string2, n, fArray);
        }

        static {
            RobolectricInternals.classInitializing(Adaptation.class);
        }

        public /* synthetic */ Adaptation() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Adaptation)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class RenderIntent
    extends Enum<RenderIntent> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ RenderIntent PERCEPTUAL;
        public static /* enum */ RenderIntent RELATIVE;
        public static /* enum */ RenderIntent SATURATION;
        public static /* enum */ RenderIntent ABSOLUTE;
        private static /* synthetic */ RenderIntent[] $VALUES;

        private static final RenderIntent[] $$robo$$android_graphics_ColorSpace_RenderIntent$values() {
            return (RenderIntent[])$VALUES.clone();
        }

        private static final RenderIntent $$robo$$android_graphics_ColorSpace_RenderIntent$valueOf(String name) {
            return Enum.valueOf(RenderIntent.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_graphics_ColorSpace_RenderIntent$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            PERCEPTUAL = new RenderIntent();
            RELATIVE = new RenderIntent();
            SATURATION = new RenderIntent();
            ABSOLUTE = new RenderIntent();
            $VALUES = new RenderIntent[]{PERCEPTUAL, RELATIVE, SATURATION, ABSOLUTE};
        }

        public static RenderIntent[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_graphics_ColorSpace_RenderIntent$values(), 0);
        }

        public static RenderIntent valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_graphics_ColorSpace_RenderIntent$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_graphics_ColorSpace_RenderIntent$__constructor__(string2, n);
        }

        private RenderIntent() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_ColorSpace_RenderIntent$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(RenderIntent.class);
        }

        public /* synthetic */ RenderIntent() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RenderIntent)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class Named
    extends Enum<Named> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ Named SRGB;
        public static /* enum */ Named LINEAR_SRGB;
        public static /* enum */ Named EXTENDED_SRGB;
        public static /* enum */ Named LINEAR_EXTENDED_SRGB;
        public static /* enum */ Named BT709;
        public static /* enum */ Named BT2020;
        public static /* enum */ Named DCI_P3;
        public static /* enum */ Named DISPLAY_P3;
        public static /* enum */ Named NTSC_1953;
        public static /* enum */ Named SMPTE_C;
        public static /* enum */ Named ADOBE_RGB;
        public static /* enum */ Named PRO_PHOTO_RGB;
        public static /* enum */ Named ACES;
        public static /* enum */ Named ACESCG;
        public static /* enum */ Named CIE_XYZ;
        public static /* enum */ Named CIE_LAB;
        private static /* synthetic */ Named[] $VALUES;

        private static final Named[] $$robo$$android_graphics_ColorSpace_Named$values() {
            return (Named[])$VALUES.clone();
        }

        private static final Named $$robo$$android_graphics_ColorSpace_Named$valueOf(String name) {
            return Enum.valueOf(Named.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_graphics_ColorSpace_Named$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            SRGB = new Named();
            LINEAR_SRGB = new Named();
            EXTENDED_SRGB = new Named();
            LINEAR_EXTENDED_SRGB = new Named();
            BT709 = new Named();
            BT2020 = new Named();
            DCI_P3 = new Named();
            DISPLAY_P3 = new Named();
            NTSC_1953 = new Named();
            SMPTE_C = new Named();
            ADOBE_RGB = new Named();
            PRO_PHOTO_RGB = new Named();
            ACES = new Named();
            ACESCG = new Named();
            CIE_XYZ = new Named();
            CIE_LAB = new Named();
            $VALUES = new Named[]{SRGB, LINEAR_SRGB, EXTENDED_SRGB, LINEAR_EXTENDED_SRGB, BT709, BT2020, DCI_P3, DISPLAY_P3, NTSC_1953, SMPTE_C, ADOBE_RGB, PRO_PHOTO_RGB, ACES, ACESCG, CIE_XYZ, CIE_LAB};
        }

        public static Named[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_graphics_ColorSpace_Named$values(), 0);
        }

        public static Named valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_graphics_ColorSpace_Named$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_graphics_ColorSpace_Named$__constructor__(string2, n);
        }

        private Named() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_ColorSpace_Named$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(Named.class);
        }

        public /* synthetic */ Named() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Named)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

