/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableContainer;
import android.util.AttributeSet;
import android.util.StateSet;
import com.android.internal.R;
import java.io.IOException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class StateListDrawable
extends DrawableContainer
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "StateListDrawable";
    private static boolean DEBUG = false;
    private StateListState mStateListState;
    private boolean mMutated;

    private void $$robo$$android_graphics_drawable_StateListDrawable$__constructor__() {
    }

    private final void $$robo$$android_graphics_drawable_StateListDrawable$addState(int[] stateSet, Drawable drawable2) {
        if (drawable2 != null) {
            this.mStateListState.addStateSet(stateSet, drawable2);
            this.onStateChange(this.getState());
        }
    }

    private final boolean $$robo$$android_graphics_drawable_StateListDrawable$isStateful() {
        return true;
    }

    private final boolean $$robo$$android_graphics_drawable_StateListDrawable$hasFocusStateSpecified() {
        return this.mStateListState.hasFocusStateSpecified();
    }

    private final boolean $$robo$$android_graphics_drawable_StateListDrawable$onStateChange(int[] stateSet) {
        boolean changed = super.onStateChange(stateSet);
        int idx = this.mStateListState.indexOfStateSet(stateSet);
        if (idx < 0) {
            idx = this.mStateListState.indexOfStateSet(StateSet.WILD_CARD);
        }
        return this.selectDrawable(idx) || changed;
    }

    private final void $$robo$$android_graphics_drawable_StateListDrawable$inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        TypedArray a = StateListDrawable.obtainAttributes(r, theme, attrs, R.styleable.StateListDrawable);
        super.inflateWithAttributes(r, parser, a, 1);
        this.updateStateFromTypedArray(a);
        this.updateDensity(r);
        a.recycle();
        this.inflateChildElements(r, parser, attrs, theme);
        this.onStateChange(this.getState());
    }

    private final void $$robo$$android_graphics_drawable_StateListDrawable$updateStateFromTypedArray(TypedArray a) {
        StateListState state = this.mStateListState;
        state.mChangingConfigurations |= a.getChangingConfigurations();
        state.mThemeAttrs = a.extractThemeAttrs();
        state.mVariablePadding = a.getBoolean(2, state.mVariablePadding);
        state.mConstantSize = a.getBoolean(3, state.mConstantSize);
        state.mEnterFadeDuration = a.getInt(4, state.mEnterFadeDuration);
        state.mExitFadeDuration = a.getInt(5, state.mExitFadeDuration);
        state.mDither = a.getBoolean(0, state.mDither);
        state.mAutoMirrored = a.getBoolean(6, state.mAutoMirrored);
    }

    private final void $$robo$$android_graphics_drawable_StateListDrawable$inflateChildElements(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        int depth;
        int type;
        StateListState state = this.mStateListState;
        int innerDepth = parser.getDepth() + 1;
        while ((type = parser.next()) != 1 && ((depth = parser.getDepth()) >= innerDepth || type != 3)) {
            if (type != 2 || depth > innerDepth || !parser.getName().equals("item")) continue;
            TypedArray a = StateListDrawable.obtainAttributes(r, theme, attrs, R.styleable.StateListDrawableItem);
            Drawable dr = a.getDrawable(0);
            a.recycle();
            int[] states = this.extractStateSet(attrs);
            if (dr == null) {
                while ((type = parser.next()) == 4) {
                }
                if (type != 2) {
                    throw new XmlPullParserException(parser.getPositionDescription() + ": <item> tag requires a 'drawable' attribute or " + "child tag defining a drawable");
                }
                dr = Drawable.createFromXmlInner(r, parser, attrs, theme);
            }
            state.addStateSet(states, dr);
        }
    }

    private final int[] $$robo$$android_graphics_drawable_StateListDrawable$extractStateSet(AttributeSet attrs) {
        int j = 0;
        int numAttrs = attrs.getAttributeCount();
        int[] states = new int[numAttrs];
        block4: for (int i = 0; i < numAttrs; ++i) {
            int stateResId = attrs.getAttributeNameResource(i);
            switch (stateResId) {
                case 0: {
                    continue block4;
                }
                case 0x10100D0: 
                case 0x1010199: {
                    continue block4;
                }
                default: {
                    states[j++] = attrs.getAttributeBooleanValue(i, false) ? stateResId : -stateResId;
                }
            }
        }
        states = StateSet.trimStateSet(states, j);
        return states;
    }

    private final StateListState $$robo$$android_graphics_drawable_StateListDrawable$getStateListState() {
        return this.mStateListState;
    }

    private final int $$robo$$android_graphics_drawable_StateListDrawable$getStateCount() {
        return this.mStateListState.getChildCount();
    }

    private final int[] $$robo$$android_graphics_drawable_StateListDrawable$getStateSet(int index) {
        return this.mStateListState.mStateSets[index];
    }

    private final Drawable $$robo$$android_graphics_drawable_StateListDrawable$getStateDrawable(int index) {
        return this.mStateListState.getChild(index);
    }

    private final int $$robo$$android_graphics_drawable_StateListDrawable$getStateDrawableIndex(int[] stateSet) {
        return this.mStateListState.indexOfStateSet(stateSet);
    }

    private final Drawable $$robo$$android_graphics_drawable_StateListDrawable$mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mStateListState.mutate();
            this.mMutated = true;
        }
        return this;
    }

    private final StateListState $$robo$$android_graphics_drawable_StateListDrawable$cloneConstantState() {
        return new StateListState(this.mStateListState, this, null);
    }

    private final void $$robo$$android_graphics_drawable_StateListDrawable$clearMutated() {
        super.clearMutated();
        this.mMutated = false;
    }

    private final void $$robo$$android_graphics_drawable_StateListDrawable$applyTheme(Resources.Theme theme) {
        super.applyTheme(theme);
        this.onStateChange(this.getState());
    }

    private final void $$robo$$android_graphics_drawable_StateListDrawable$setConstantState(DrawableContainer.DrawableContainerState state) {
        super.setConstantState(state);
        if (state instanceof StateListState) {
            this.mStateListState = (StateListState)state;
        }
    }

    private void $$robo$$android_graphics_drawable_StateListDrawable$__constructor__(StateListState state, Resources res) {
        StateListState newState = new StateListState(state, this, res);
        this.setConstantState(newState);
        this.onStateChange(this.getState());
    }

    private void $$robo$$android_graphics_drawable_StateListDrawable$__constructor__(StateListState state) {
        if (state != null) {
            this.setConstantState(state);
        }
    }

    private /* synthetic */ void $$robo$$android_graphics_drawable_StateListDrawable$__constructor__(StateListState x0, Resources x1, 1 x2) {
    }

    private void __constructor__() {
        this.$$robo$$android_graphics_drawable_StateListDrawable$__constructor__();
    }

    public StateListDrawable() {
        this(null, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_StateListDrawable$__constructor__(), 0, this);
    }

    public void addState(int[] nArray, Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("addState", $$robo$$android_graphics_drawable_StateListDrawable$addState(int[] android.graphics.drawable.Drawable ), 0, this, nArray, drawable2);
    }

    @Override
    public boolean isStateful() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStateful", $$robo$$android_graphics_drawable_StateListDrawable$isStateful(), 0, this);
    }

    @Override
    public boolean hasFocusStateSpecified() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasFocusStateSpecified", $$robo$$android_graphics_drawable_StateListDrawable$hasFocusStateSpecified(), 0, this);
    }

    @Override
    protected boolean onStateChange(int[] nArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("onStateChange", $$robo$$android_graphics_drawable_StateListDrawable$onStateChange(int[] ), 0, this, nArray);
    }

    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("inflate", $$robo$$android_graphics_drawable_StateListDrawable$inflate(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), 0, this, resources, xmlPullParser, attributeSet, theme);
    }

    private void updateStateFromTypedArray(TypedArray typedArray) {
        InvokeDynamicSupport.bootstrap("updateStateFromTypedArray", $$robo$$android_graphics_drawable_StateListDrawable$updateStateFromTypedArray(android.content.res.TypedArray ), 0, this, typedArray);
    }

    private void inflateChildElements(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("inflateChildElements", $$robo$$android_graphics_drawable_StateListDrawable$inflateChildElements(android.content.res.Resources org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.content.res.Resources$Theme ), 0, this, resources, xmlPullParser, attributeSet, theme);
    }

    int[] extractStateSet(AttributeSet attributeSet) {
        return InvokeDynamicSupport.bootstrap("extractStateSet", $$robo$$android_graphics_drawable_StateListDrawable$extractStateSet(android.util.AttributeSet ), 0, this, attributeSet);
    }

    StateListState getStateListState() {
        return InvokeDynamicSupport.bootstrap("getStateListState", $$robo$$android_graphics_drawable_StateListDrawable$getStateListState(), 0, this);
    }

    public int getStateCount() {
        return (int)InvokeDynamicSupport.bootstrap("getStateCount", $$robo$$android_graphics_drawable_StateListDrawable$getStateCount(), 0, this);
    }

    public int[] getStateSet(int n) {
        return InvokeDynamicSupport.bootstrap("getStateSet", $$robo$$android_graphics_drawable_StateListDrawable$getStateSet(int ), 0, this, n);
    }

    public Drawable getStateDrawable(int n) {
        return InvokeDynamicSupport.bootstrap("getStateDrawable", $$robo$$android_graphics_drawable_StateListDrawable$getStateDrawable(int ), 0, this, n);
    }

    public int getStateDrawableIndex(int[] nArray) {
        return (int)InvokeDynamicSupport.bootstrap("getStateDrawableIndex", $$robo$$android_graphics_drawable_StateListDrawable$getStateDrawableIndex(int[] ), 0, this, nArray);
    }

    @Override
    public Drawable mutate() {
        return InvokeDynamicSupport.bootstrap("mutate", $$robo$$android_graphics_drawable_StateListDrawable$mutate(), 0, this);
    }

    @Override
    StateListState cloneConstantState() {
        return InvokeDynamicSupport.bootstrap("cloneConstantState", $$robo$$android_graphics_drawable_StateListDrawable$cloneConstantState(), 0, this);
    }

    @Override
    public void clearMutated() {
        InvokeDynamicSupport.bootstrap("clearMutated", $$robo$$android_graphics_drawable_StateListDrawable$clearMutated(), 0, this);
    }

    @Override
    public void applyTheme(Resources.Theme theme) {
        InvokeDynamicSupport.bootstrap("applyTheme", $$robo$$android_graphics_drawable_StateListDrawable$applyTheme(android.content.res.Resources$Theme ), 0, this, theme);
    }

    @Override
    protected void setConstantState(DrawableContainer.DrawableContainerState drawableContainerState) {
        InvokeDynamicSupport.bootstrap("setConstantState", $$robo$$android_graphics_drawable_StateListDrawable$setConstantState(android.graphics.drawable.DrawableContainer$DrawableContainerState ), 0, this, drawableContainerState);
    }

    private void __constructor__(StateListState stateListState, Resources resources) {
        this.$$robo$$android_graphics_drawable_StateListDrawable$__constructor__(stateListState, resources);
    }

    private StateListDrawable(StateListState stateListState, Resources resources) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_StateListDrawable$__constructor__(android.graphics.drawable.StateListDrawable$StateListState android.content.res.Resources ), 0, this, stateListState, resources);
    }

    private void __constructor__(StateListState stateListState) {
        this.$$robo$$android_graphics_drawable_StateListDrawable$__constructor__(stateListState);
    }

    StateListDrawable(StateListState stateListState) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_StateListDrawable$__constructor__(android.graphics.drawable.StateListDrawable$StateListState ), 0, this, stateListState);
    }

    private /* synthetic */ void __constructor__(StateListState stateListState, Resources resources, 1 var3_3) {
        this.$$robo$$android_graphics_drawable_StateListDrawable$__constructor__(stateListState, resources, var3_3);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StateListDrawable)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class StateListState
    extends DrawableContainer.DrawableContainerState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int[] mThemeAttrs;
        int[][] mStateSets;

        private void $$robo$$android_graphics_drawable_StateListDrawable_StateListState$__constructor__(StateListState orig, StateListDrawable owner, Resources res) {
            if (orig != null) {
                this.mThemeAttrs = orig.mThemeAttrs;
                this.mStateSets = orig.mStateSets;
            } else {
                this.mThemeAttrs = null;
                this.mStateSets = new int[this.getCapacity()][];
            }
        }

        private final void $$robo$$android_graphics_drawable_StateListDrawable_StateListState$mutate() {
            this.mThemeAttrs = this.mThemeAttrs != null ? (int[])this.mThemeAttrs.clone() : null;
            int[][] stateSets = new int[this.mStateSets.length][];
            for (int i = this.mStateSets.length - 1; i >= 0; --i) {
                stateSets[i] = this.mStateSets[i] != null ? (int[])this.mStateSets[i].clone() : null;
            }
            this.mStateSets = stateSets;
        }

        private final int $$robo$$android_graphics_drawable_StateListDrawable_StateListState$addStateSet(int[] stateSet, Drawable drawable2) {
            int pos = this.addChild(drawable2);
            this.mStateSets[pos] = stateSet;
            return pos;
        }

        private final int $$robo$$android_graphics_drawable_StateListDrawable_StateListState$indexOfStateSet(int[] stateSet) {
            int[][] stateSets = this.mStateSets;
            int N = this.getChildCount();
            for (int i = 0; i < N; ++i) {
                if (!StateSet.stateSetMatches(stateSets[i], stateSet)) continue;
                return i;
            }
            return -1;
        }

        private final boolean $$robo$$android_graphics_drawable_StateListDrawable_StateListState$hasFocusStateSpecified() {
            return StateSet.containsAttribute(this.mStateSets, 16842908);
        }

        private final Drawable $$robo$$android_graphics_drawable_StateListDrawable_StateListState$newDrawable() {
            return new StateListDrawable(this, null);
        }

        private final Drawable $$robo$$android_graphics_drawable_StateListDrawable_StateListState$newDrawable(Resources res) {
            return new StateListDrawable(this, res);
        }

        private final boolean $$robo$$android_graphics_drawable_StateListDrawable_StateListState$canApplyTheme() {
            return this.mThemeAttrs != null || super.canApplyTheme();
        }

        private final void $$robo$$android_graphics_drawable_StateListDrawable_StateListState$growArray(int oldSize, int newSize) {
            super.growArray(oldSize, newSize);
            int[][] newStateSets = new int[newSize][];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mStateSets, (int)0, (Object)newStateSets, (int)0, (int)oldSize);
            this.mStateSets = newStateSets;
        }

        private void __constructor__(StateListState stateListState, StateListDrawable stateListDrawable, Resources resources) {
            this.$$robo$$android_graphics_drawable_StateListDrawable_StateListState$__constructor__(stateListState, stateListDrawable, resources);
        }

        StateListState(StateListState stateListState, StateListDrawable stateListDrawable, Resources resources) {
            super(stateListState, stateListDrawable, resources);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_drawable_StateListDrawable_StateListState$__constructor__(android.graphics.drawable.StateListDrawable$StateListState android.graphics.drawable.StateListDrawable android.content.res.Resources ), 0, this, stateListState, stateListDrawable, resources);
        }

        void mutate() {
            InvokeDynamicSupport.bootstrap("mutate", $$robo$$android_graphics_drawable_StateListDrawable_StateListState$mutate(), 0, this);
        }

        int addStateSet(int[] nArray, Drawable drawable2) {
            return (int)InvokeDynamicSupport.bootstrap("addStateSet", $$robo$$android_graphics_drawable_StateListDrawable_StateListState$addStateSet(int[] android.graphics.drawable.Drawable ), 0, this, nArray, drawable2);
        }

        int indexOfStateSet(int[] nArray) {
            return (int)InvokeDynamicSupport.bootstrap("indexOfStateSet", $$robo$$android_graphics_drawable_StateListDrawable_StateListState$indexOfStateSet(int[] ), 0, this, nArray);
        }

        boolean hasFocusStateSpecified() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasFocusStateSpecified", $$robo$$android_graphics_drawable_StateListDrawable_StateListState$hasFocusStateSpecified(), 0, this);
        }

        @Override
        public Drawable newDrawable() {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_StateListDrawable_StateListState$newDrawable(), 0, this);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_graphics_drawable_StateListDrawable_StateListState$newDrawable(android.content.res.Resources ), 0, this, resources);
        }

        @Override
        public boolean canApplyTheme() {
            return (boolean)InvokeDynamicSupport.bootstrap("canApplyTheme", $$robo$$android_graphics_drawable_StateListDrawable_StateListState$canApplyTheme(), 0, this);
        }

        @Override
        public void growArray(int n, int n2) {
            InvokeDynamicSupport.bootstrap("growArray", $$robo$$android_graphics_drawable_StateListDrawable_StateListState$growArray(int int ), 0, this, n, n2);
        }

        public /* synthetic */ StateListState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StateListState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

