/*
 * Decompiled with CFR 0.152.
 */
package android.hardware;

import android.content.Context;
import android.hardware.IConsumerIrService;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class ConsumerIrManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "ConsumerIr";
    private String mPackageName;
    private IConsumerIrService mService;

    private void $$robo$$android_hardware_ConsumerIrManager$__constructor__(Context context) throws ServiceManager.ServiceNotFoundException {
        this.mPackageName = context.getPackageName();
        this.mService = IConsumerIrService.Stub.asInterface(ServiceManager.getServiceOrThrow("consumer_ir"));
    }

    private final boolean $$robo$$android_hardware_ConsumerIrManager$hasIrEmitter() {
        if (this.mService == null) {
            Log.w("ConsumerIr", "no consumer ir service.");
            return false;
        }
        try {
            return this.mService.hasIrEmitter();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_hardware_ConsumerIrManager$transmit(int carrierFrequency, int[] pattern) {
        if (this.mService == null) {
            Log.w("ConsumerIr", "failed to transmit; no consumer ir service.");
            return;
        }
        try {
            this.mService.transmit(this.mPackageName, carrierFrequency, pattern);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final CarrierFrequencyRange[] $$robo$$android_hardware_ConsumerIrManager$getCarrierFrequencies() {
        if (this.mService == null) {
            Log.w("ConsumerIr", "no consumer ir service.");
            return null;
        }
        try {
            int[] freqs = this.mService.getCarrierFrequencies();
            if (freqs.length % 2 != 0) {
                Log.w("ConsumerIr", "consumer ir service returned an uneven number of frequencies.");
                return null;
            }
            CarrierFrequencyRange[] range = new CarrierFrequencyRange[freqs.length / 2];
            for (int i = 0; i < freqs.length; i += 2) {
                range[i / 2] = new CarrierFrequencyRange(this, freqs[i], freqs[i + 1]);
            }
            return range;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private void __constructor__(Context context) throws ServiceManager.ServiceNotFoundException {
        this.$$robo$$android_hardware_ConsumerIrManager$__constructor__(context);
    }

    public ConsumerIrManager(Context context) throws ServiceManager.ServiceNotFoundException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_ConsumerIrManager$__constructor__(android.content.Context ), 0, this, context);
    }

    public boolean hasIrEmitter() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasIrEmitter", $$robo$$android_hardware_ConsumerIrManager$hasIrEmitter(), 0, this);
    }

    public void transmit(int n, int[] nArray) {
        InvokeDynamicSupport.bootstrap("transmit", $$robo$$android_hardware_ConsumerIrManager$transmit(int int[] ), 0, this, n, nArray);
    }

    public CarrierFrequencyRange[] getCarrierFrequencies() {
        return InvokeDynamicSupport.bootstrap("getCarrierFrequencies", $$robo$$android_hardware_ConsumerIrManager$getCarrierFrequencies(), 0, this);
    }

    public /* synthetic */ ConsumerIrManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ConsumerIrManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public final class CarrierFrequencyRange
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mMinFrequency;
        private int mMaxFrequency;
        /* synthetic */ ConsumerIrManager this$0;

        private void $$robo$$android_hardware_ConsumerIrManager_CarrierFrequencyRange$__constructor__(ConsumerIrManager this$0, int min, int max) {
            this.mMinFrequency = min;
            this.mMaxFrequency = max;
        }

        private final int $$robo$$android_hardware_ConsumerIrManager_CarrierFrequencyRange$getMinFrequency() {
            return this.mMinFrequency;
        }

        private final int $$robo$$android_hardware_ConsumerIrManager_CarrierFrequencyRange$getMaxFrequency() {
            return this.mMaxFrequency;
        }

        private void __constructor__(ConsumerIrManager consumerIrManager, int n, int n2) {
            this.$$robo$$android_hardware_ConsumerIrManager_CarrierFrequencyRange$__constructor__(consumerIrManager, n, n2);
        }

        public CarrierFrequencyRange(ConsumerIrManager consumerIrManager, int n, int n2) {
            this.this$0 = consumerIrManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_ConsumerIrManager_CarrierFrequencyRange$__constructor__(android.hardware.ConsumerIrManager int int ), 0, this, consumerIrManager, n, n2);
        }

        public int getMinFrequency() {
            return (int)InvokeDynamicSupport.bootstrap("getMinFrequency", $$robo$$android_hardware_ConsumerIrManager_CarrierFrequencyRange$getMinFrequency(), 0, this);
        }

        public int getMaxFrequency() {
            return (int)InvokeDynamicSupport.bootstrap("getMaxFrequency", $$robo$$android_hardware_ConsumerIrManager_CarrierFrequencyRange$getMaxFrequency(), 0, this);
        }

        public /* synthetic */ CarrierFrequencyRange() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CarrierFrequencyRange)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

