/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.impl;

import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CaptureFailure;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.ICameraDeviceCallbacks;
import android.hardware.camera2.ICameraDeviceUser;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.impl.CameraCaptureSessionCore;
import android.hardware.camera2.impl.CameraCaptureSessionImpl;
import android.hardware.camera2.impl.CameraConstrainedHighSpeedCaptureSessionImpl;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.impl.CaptureResultExtras;
import android.hardware.camera2.impl.ICameraDeviceUserWrapper;
import android.hardware.camera2.params.InputConfiguration;
import android.hardware.camera2.params.OutputConfiguration;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.hardware.camera2.utils.SubmitInfo;
import android.hardware.camera2.utils.SurfaceUtils;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.os.ServiceSpecificException;
import android.util.Log;
import android.util.Range;
import android.util.Size;
import android.util.SparseArray;
import android.view.Surface;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CameraDeviceImpl
extends CameraDevice
implements IBinder.DeathRecipient,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private String TAG;
    private boolean DEBUG = false;
    private static int REQUEST_ID_NONE = -1;
    private ICameraDeviceUserWrapper mRemoteDevice;
    Object mInterfaceLock;
    private CameraDeviceCallbacks mCallbacks;
    private CameraDevice.StateCallback mDeviceCallback;
    private volatile StateCallbackKK mSessionStateCallback;
    private Handler mDeviceHandler;
    private AtomicBoolean mClosing;
    private boolean mInError;
    private boolean mIdle;
    private SparseArray<CaptureCallbackHolder> mCaptureCallbackMap;
    private int mRepeatingRequestId;
    private AbstractMap.SimpleEntry<Integer, InputConfiguration> mConfiguredInput;
    private SparseArray<OutputConfiguration> mConfiguredOutputs;
    private String mCameraId;
    private CameraCharacteristics mCharacteristics;
    private int mTotalPartialCount;
    private static long NANO_PER_SECOND = 1000000000L;
    private List<RequestLastFrameNumbersHolder> mRequestLastFrameNumbersList;
    private FrameNumberTracker mFrameNumberTracker;
    private CameraCaptureSessionCore mCurrentSession;
    private int mNextSessionId;
    private int mAppTargetSdkVersion;
    private Runnable mCallOnOpened;
    private Runnable mCallOnUnconfigured;
    private Runnable mCallOnActive;
    private Runnable mCallOnBusy;
    private Runnable mCallOnClosed;
    private Runnable mCallOnIdle;
    private Runnable mCallOnDisconnected;

    private void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$__constructor__(String cameraId, CameraDevice.StateCallback callback, Handler handler, CameraCharacteristics characteristics, int appTargetSdkVersion) {
        this.DEBUG = false;
        this.mInterfaceLock = new Object();
        this.mCallbacks = new CameraDeviceCallbacks(this);
        this.mClosing = new AtomicBoolean();
        this.mInError = false;
        this.mIdle = true;
        this.mCaptureCallbackMap = new SparseArray();
        this.mRepeatingRequestId = -1;
        this.mConfiguredInput = new AbstractMap.SimpleEntry<Integer, Object>(-1, null);
        this.mConfiguredOutputs = new SparseArray();
        this.mRequestLastFrameNumbersList = new ArrayList<RequestLastFrameNumbersHolder>();
        this.mFrameNumberTracker = new FrameNumberTracker(this);
        this.mNextSessionId = 0;
        this.mCallOnOpened = new Runnable(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ CameraDeviceImpl this$0;

            private void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_1$__constructor__(CameraDeviceImpl this$0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_1$run() {
                StateCallbackKK sessionCallback = null;
                Object object = this.this$0.mInterfaceLock;
                synchronized (object) {
                    if (this.this$0.mRemoteDevice == null) {
                        return;
                    }
                    sessionCallback = this.this$0.mSessionStateCallback;
                }
                if (sessionCallback != null) {
                    sessionCallback.onOpened(this.this$0);
                }
                this.this$0.mDeviceCallback.onOpened(this.this$0);
            }

            private void __constructor__(CameraDeviceImpl cameraDeviceImpl) {
                this.$$robo$$android_hardware_camera2_impl_CameraDeviceImpl_1$__constructor__(cameraDeviceImpl);
            }
            {
                this.this$0 = cameraDeviceImpl;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_1$__constructor__(android.hardware.camera2.impl.CameraDeviceImpl ), 0, this, cameraDeviceImpl);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_1$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mCallOnUnconfigured = new Runnable(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ CameraDeviceImpl this$0;

            private void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_2$__constructor__(CameraDeviceImpl this$0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_2$run() {
                StateCallbackKK sessionCallback = null;
                Object object = this.this$0.mInterfaceLock;
                synchronized (object) {
                    if (this.this$0.mRemoteDevice == null) {
                        return;
                    }
                    sessionCallback = this.this$0.mSessionStateCallback;
                }
                if (sessionCallback != null) {
                    sessionCallback.onUnconfigured(this.this$0);
                }
            }

            private void __constructor__(CameraDeviceImpl cameraDeviceImpl) {
                this.$$robo$$android_hardware_camera2_impl_CameraDeviceImpl_2$__constructor__(cameraDeviceImpl);
            }
            {
                this.this$0 = cameraDeviceImpl;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_2$__constructor__(android.hardware.camera2.impl.CameraDeviceImpl ), 0, this, cameraDeviceImpl);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_2$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mCallOnActive = new Runnable(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ CameraDeviceImpl this$0;

            private void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_3$__constructor__(CameraDeviceImpl this$0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_3$run() {
                StateCallbackKK sessionCallback = null;
                Object object = this.this$0.mInterfaceLock;
                synchronized (object) {
                    if (this.this$0.mRemoteDevice == null) {
                        return;
                    }
                    sessionCallback = this.this$0.mSessionStateCallback;
                }
                if (sessionCallback != null) {
                    sessionCallback.onActive(this.this$0);
                }
            }

            private void __constructor__(CameraDeviceImpl cameraDeviceImpl) {
                this.$$robo$$android_hardware_camera2_impl_CameraDeviceImpl_3$__constructor__(cameraDeviceImpl);
            }
            {
                this.this$0 = cameraDeviceImpl;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_3$__constructor__(android.hardware.camera2.impl.CameraDeviceImpl ), 0, this, cameraDeviceImpl);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_3$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mCallOnBusy = new Runnable(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ CameraDeviceImpl this$0;

            private void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_4$__constructor__(CameraDeviceImpl this$0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_4$run() {
                StateCallbackKK sessionCallback = null;
                Object object = this.this$0.mInterfaceLock;
                synchronized (object) {
                    if (this.this$0.mRemoteDevice == null) {
                        return;
                    }
                    sessionCallback = this.this$0.mSessionStateCallback;
                }
                if (sessionCallback != null) {
                    sessionCallback.onBusy(this.this$0);
                }
            }

            private void __constructor__(CameraDeviceImpl cameraDeviceImpl) {
                this.$$robo$$android_hardware_camera2_impl_CameraDeviceImpl_4$__constructor__(cameraDeviceImpl);
            }
            {
                this.this$0 = cameraDeviceImpl;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_4$__constructor__(android.hardware.camera2.impl.CameraDeviceImpl ), 0, this, cameraDeviceImpl);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_4$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mCallOnClosed = new Runnable(this){
            public transient /* synthetic */ Object __robo_data__;
            private boolean mClosedOnce;
            /* synthetic */ CameraDeviceImpl this$0;

            private void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_5$__constructor__(CameraDeviceImpl this$0) {
                this.mClosedOnce = false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_5$run() {
                if (this.mClosedOnce) {
                    throw new AssertionError((Object)"Don't post #onClosed more than once");
                }
                StateCallbackKK sessionCallback = null;
                Object object = this.this$0.mInterfaceLock;
                synchronized (object) {
                    sessionCallback = this.this$0.mSessionStateCallback;
                }
                if (sessionCallback != null) {
                    sessionCallback.onClosed(this.this$0);
                }
                this.this$0.mDeviceCallback.onClosed(this.this$0);
                this.mClosedOnce = true;
            }

            private void __constructor__(CameraDeviceImpl cameraDeviceImpl) {
                this.$$robo$$android_hardware_camera2_impl_CameraDeviceImpl_5$__constructor__(cameraDeviceImpl);
            }
            {
                this.this$0 = cameraDeviceImpl;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_5$__constructor__(android.hardware.camera2.impl.CameraDeviceImpl ), 0, this, cameraDeviceImpl);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_5$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mCallOnIdle = new Runnable(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ CameraDeviceImpl this$0;

            private void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_6$__constructor__(CameraDeviceImpl this$0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_6$run() {
                StateCallbackKK sessionCallback = null;
                Object object = this.this$0.mInterfaceLock;
                synchronized (object) {
                    if (this.this$0.mRemoteDevice == null) {
                        return;
                    }
                    sessionCallback = this.this$0.mSessionStateCallback;
                }
                if (sessionCallback != null) {
                    sessionCallback.onIdle(this.this$0);
                }
            }

            private void __constructor__(CameraDeviceImpl cameraDeviceImpl) {
                this.$$robo$$android_hardware_camera2_impl_CameraDeviceImpl_6$__constructor__(cameraDeviceImpl);
            }
            {
                this.this$0 = cameraDeviceImpl;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_6$__constructor__(android.hardware.camera2.impl.CameraDeviceImpl ), 0, this, cameraDeviceImpl);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_6$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mCallOnDisconnected = new Runnable(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ CameraDeviceImpl this$0;

            private void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_7$__constructor__(CameraDeviceImpl this$0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_7$run() {
                StateCallbackKK sessionCallback = null;
                Object object = this.this$0.mInterfaceLock;
                synchronized (object) {
                    if (this.this$0.mRemoteDevice == null) {
                        return;
                    }
                    sessionCallback = this.this$0.mSessionStateCallback;
                }
                if (sessionCallback != null) {
                    sessionCallback.onDisconnected(this.this$0);
                }
                this.this$0.mDeviceCallback.onDisconnected(this.this$0);
            }

            private void __constructor__(CameraDeviceImpl cameraDeviceImpl) {
                this.$$robo$$android_hardware_camera2_impl_CameraDeviceImpl_7$__constructor__(cameraDeviceImpl);
            }
            {
                this.this$0 = cameraDeviceImpl;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_7$__constructor__(android.hardware.camera2.impl.CameraDeviceImpl ), 0, this, cameraDeviceImpl);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_7$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        if (cameraId == null || callback == null || handler == null || characteristics == null) {
            throw new IllegalArgumentException("Null argument given");
        }
        this.mCameraId = cameraId;
        this.mDeviceCallback = callback;
        this.mDeviceHandler = handler;
        this.mCharacteristics = characteristics;
        this.mAppTargetSdkVersion = appTargetSdkVersion;
        int MAX_TAG_LEN = 23;
        String tag = String.format("CameraDevice-JV-%s", this.mCameraId);
        if (tag.length() > 23) {
            tag = tag.substring(0, 23);
        }
        this.TAG = tag;
        Integer partialCount = this.mCharacteristics.get(CameraCharacteristics.REQUEST_PARTIAL_RESULT_COUNT);
        this.mTotalPartialCount = partialCount == null ? 1 : partialCount;
    }

    private final CameraDeviceCallbacks $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$getCallbacks() {
        return this.mCallbacks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$setRemoteDevice(ICameraDeviceUser remoteDevice) throws CameraAccessException {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            if (this.mInError) {
                return;
            }
            this.mRemoteDevice = new ICameraDeviceUserWrapper(remoteDevice);
            IBinder remoteDeviceBinder = remoteDevice.asBinder();
            if (remoteDeviceBinder != null) {
                try {
                    remoteDeviceBinder.linkToDeath(this, 0);
                }
                catch (RemoteException e) {
                    this.mDeviceHandler.post(this.mCallOnDisconnected);
                    throw new CameraAccessException(2, "The camera device has encountered a serious error");
                }
            }
            this.mDeviceHandler.post(this.mCallOnOpened);
            this.mDeviceHandler.post(this.mCallOnUnconfigured);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$setRemoteFailure(ServiceSpecificException failure) {
        int failureCode = 4;
        boolean failureIsError = true;
        switch (failure.errorCode) {
            case 7: {
                failureCode = 1;
                break;
            }
            case 8: {
                failureCode = 2;
                break;
            }
            case 6: {
                failureCode = 3;
                break;
            }
            case 4: {
                failureIsError = false;
                break;
            }
            case 10: {
                failureCode = 4;
                break;
            }
            default: {
                Log.e(this.TAG, "Unexpected failure in opening camera device: " + failure.errorCode + failure.getMessage());
            }
        }
        int code = failureCode;
        boolean isError = failureIsError;
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.mInError = true;
            this.mDeviceHandler.post(new Runnable(this, isError, code){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ boolean val$isError;
                /* synthetic */ int val$code;
                /* synthetic */ CameraDeviceImpl this$0;

                private void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_8$__constructor__(CameraDeviceImpl this$0, boolean bl, int n) {
                }

                private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_8$run() {
                    if (this.val$isError) {
                        this.this$0.mDeviceCallback.onError(this.this$0, this.val$code);
                    } else {
                        this.this$0.mDeviceCallback.onDisconnected(this.this$0);
                    }
                }

                private void __constructor__(CameraDeviceImpl cameraDeviceImpl, boolean bl, int n) {
                    this.$$robo$$android_hardware_camera2_impl_CameraDeviceImpl_8$__constructor__(cameraDeviceImpl, bl, n);
                }
                {
                    this.this$0 = cameraDeviceImpl;
                    this.val$isError = bl;
                    this.val$code = n;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_8$__constructor__(android.hardware.camera2.impl.CameraDeviceImpl boolean int ), 0, this, cameraDeviceImpl, bl, n);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_8$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
    }

    private final String $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$getId() {
        return this.mCameraId;
    }

    private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$configureOutputs(List<Surface> outputs) throws CameraAccessException {
        ArrayList<OutputConfiguration> outputConfigs = new ArrayList<OutputConfiguration>(outputs.size());
        for (Surface s : outputs) {
            outputConfigs.add(new OutputConfiguration(s));
        }
        this.configureStreamsChecked(null, outputConfigs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$configureStreamsChecked(InputConfiguration inputConfig, List<OutputConfiguration> outputs, int operatingMode) throws CameraAccessException {
        if (outputs == null) {
            outputs = new ArrayList<OutputConfiguration>();
        }
        if (outputs.size() == 0 && inputConfig != null) {
            throw new IllegalArgumentException("cannot configure an input stream without any output streams");
        }
        this.checkInputConfiguration(inputConfig);
        boolean success = false;
        Object object = this.mInterfaceLock;
        synchronized (object) {
            int streamId;
            this.checkIfCameraClosedOrInError();
            HashSet<OutputConfiguration> addSet = new HashSet<OutputConfiguration>(outputs);
            ArrayList<Integer> deleteList = new ArrayList<Integer>();
            for (int i = 0; i < this.mConfiguredOutputs.size(); ++i) {
                streamId = this.mConfiguredOutputs.keyAt(i);
                OutputConfiguration outConfig = this.mConfiguredOutputs.valueAt(i);
                if (!outputs.contains(outConfig) || outConfig.isDeferredConfiguration()) {
                    deleteList.add(streamId);
                    continue;
                }
                addSet.remove(outConfig);
            }
            this.mDeviceHandler.post(this.mCallOnBusy);
            this.stopRepeating();
            try {
                this.waitUntilIdle();
                this.mRemoteDevice.beginConfigure();
                InputConfiguration currentInputConfig = this.mConfiguredInput.getValue();
                if (!(inputConfig == currentInputConfig || inputConfig != null && inputConfig.equals(currentInputConfig))) {
                    if (currentInputConfig != null) {
                        this.mRemoteDevice.deleteStream(this.mConfiguredInput.getKey());
                        this.mConfiguredInput = new AbstractMap.SimpleEntry<Integer, Object>(-1, null);
                    }
                    if (inputConfig != null) {
                        streamId = this.mRemoteDevice.createInputStream(inputConfig.getWidth(), inputConfig.getHeight(), inputConfig.getFormat());
                        this.mConfiguredInput = new AbstractMap.SimpleEntry<Integer, InputConfiguration>(streamId, inputConfig);
                    }
                }
                for (Integer streamId2 : deleteList) {
                    this.mRemoteDevice.deleteStream(streamId2);
                    this.mConfiguredOutputs.delete(streamId2);
                }
                for (OutputConfiguration outConfig : outputs) {
                    if (!addSet.contains(outConfig)) continue;
                    int streamId3 = this.mRemoteDevice.createStream(outConfig);
                    this.mConfiguredOutputs.put(streamId3, outConfig);
                }
                this.mRemoteDevice.endConfigure(operatingMode);
                success = true;
            }
            catch (IllegalArgumentException e) {
                Log.w(this.TAG, "Stream configuration failed due to: " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            catch (CameraAccessException e) {
                if (e.getReason() != 4) throw e;
                throw new IllegalStateException("The camera is currently busy. You must wait until the previous operation completes.", e);
            }
            finally {
                if (success && outputs.size() > 0) {
                    this.mDeviceHandler.post(this.mCallOnIdle);
                } else {
                    this.mDeviceHandler.post(this.mCallOnUnconfigured);
                }
            }
            return success;
        }
    }

    private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$createCaptureSession(List<Surface> outputs, CameraCaptureSession.StateCallback callback, Handler handler) throws CameraAccessException {
        ArrayList<OutputConfiguration> outConfigurations = new ArrayList<OutputConfiguration>(outputs.size());
        for (Surface surface : outputs) {
            outConfigurations.add(new OutputConfiguration(surface));
        }
        this.createCaptureSessionInternal(null, outConfigurations, callback, handler, 0);
    }

    private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$createCaptureSessionByOutputConfigurations(List<OutputConfiguration> outputConfigurations, CameraCaptureSession.StateCallback callback, Handler handler) throws CameraAccessException {
        ArrayList<OutputConfiguration> currentOutputs = new ArrayList<OutputConfiguration>(outputConfigurations);
        this.createCaptureSessionInternal(null, currentOutputs, callback, handler, 0);
    }

    private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$createReprocessableCaptureSession(InputConfiguration inputConfig, List<Surface> outputs, CameraCaptureSession.StateCallback callback, Handler handler) throws CameraAccessException {
        if (inputConfig == null) {
            throw new IllegalArgumentException("inputConfig cannot be null when creating a reprocessable capture session");
        }
        ArrayList<OutputConfiguration> outConfigurations = new ArrayList<OutputConfiguration>(outputs.size());
        for (Surface surface : outputs) {
            outConfigurations.add(new OutputConfiguration(surface));
        }
        this.createCaptureSessionInternal(inputConfig, outConfigurations, callback, handler, 0);
    }

    private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$createReprocessableCaptureSessionByConfigurations(InputConfiguration inputConfig, List<OutputConfiguration> outputs, CameraCaptureSession.StateCallback callback, Handler handler) throws CameraAccessException {
        if (inputConfig == null) {
            throw new IllegalArgumentException("inputConfig cannot be null when creating a reprocessable capture session");
        }
        if (outputs == null) {
            throw new IllegalArgumentException("Output configurations cannot be null when creating a reprocessable capture session");
        }
        ArrayList<OutputConfiguration> currentOutputs = new ArrayList<OutputConfiguration>();
        for (OutputConfiguration output : outputs) {
            currentOutputs.add(new OutputConfiguration(output));
        }
        this.createCaptureSessionInternal(inputConfig, currentOutputs, callback, handler, 0);
    }

    private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$createConstrainedHighSpeedCaptureSession(List<Surface> outputs, CameraCaptureSession.StateCallback callback, Handler handler) throws CameraAccessException {
        if (outputs == null || outputs.size() == 0 || outputs.size() > 2) {
            throw new IllegalArgumentException("Output surface list must not be null and the size must be no more than 2");
        }
        StreamConfigurationMap config = this.getCharacteristics().get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        SurfaceUtils.checkConstrainedHighSpeedSurfaces(outputs, null, config);
        ArrayList<OutputConfiguration> outConfigurations = new ArrayList<OutputConfiguration>(outputs.size());
        for (Surface surface : outputs) {
            outConfigurations.add(new OutputConfiguration(surface));
        }
        this.createCaptureSessionInternal(null, outConfigurations, callback, handler, 1);
    }

    private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$createCustomCaptureSession(InputConfiguration inputConfig, List<OutputConfiguration> outputs, int operatingMode, CameraCaptureSession.StateCallback callback, Handler handler) throws CameraAccessException {
        ArrayList<OutputConfiguration> currentOutputs = new ArrayList<OutputConfiguration>();
        for (OutputConfiguration output : outputs) {
            currentOutputs.add(new OutputConfiguration(output));
        }
        this.createCaptureSessionInternal(inputConfig, currentOutputs, callback, handler, operatingMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$createCaptureSessionInternal(InputConfiguration inputConfig, List<OutputConfiguration> outputConfigurations, CameraCaptureSession.StateCallback callback, Handler handler, int operatingMode) throws CameraAccessException {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            boolean isConstrainedHighSpeed;
            this.checkIfCameraClosedOrInError();
            boolean bl = isConstrainedHighSpeed = operatingMode == 1;
            if (isConstrainedHighSpeed && inputConfig != null) {
                throw new IllegalArgumentException("Constrained high speed session doesn't support input configuration yet.");
            }
            if (this.mCurrentSession != null) {
                this.mCurrentSession.replaceSessionClose();
            }
            boolean configureSuccess = true;
            CameraAccessException pendingException = null;
            Surface input = null;
            try {
                configureSuccess = this.configureStreamsChecked(inputConfig, outputConfigurations, operatingMode);
                if (configureSuccess && inputConfig != null) {
                    input = this.mRemoteDevice.getInputSurface();
                }
            }
            catch (CameraAccessException e) {
                configureSuccess = false;
                pendingException = e;
                input = null;
            }
            CameraCaptureSession newSession = null;
            newSession = isConstrainedHighSpeed ? new CameraConstrainedHighSpeedCaptureSessionImpl(this.mNextSessionId++, callback, handler, this, this.mDeviceHandler, configureSuccess, this.mCharacteristics) : new CameraCaptureSessionImpl(this.mNextSessionId++, input, callback, handler, this, this.mDeviceHandler, configureSuccess);
            this.mCurrentSession = newSession;
            if (pendingException != null) {
                throw pendingException;
            }
            this.mSessionStateCallback = this.mCurrentSession.getDeviceStateCallback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$setSessionListener(StateCallbackKK sessionCallback) {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.mSessionStateCallback = sessionCallback;
        }
    }

    private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$overrideEnableZsl(CameraMetadataNative request, boolean newValue) {
        Boolean enableZsl = request.get(CaptureRequest.CONTROL_ENABLE_ZSL);
        if (enableZsl == null) {
            return;
        }
        request.set(CaptureRequest.CONTROL_ENABLE_ZSL, Boolean.valueOf(newValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final CaptureRequest.Builder $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$createCaptureRequest(int templateType) throws CameraAccessException {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.checkIfCameraClosedOrInError();
            CameraMetadataNative templatedRequest = null;
            templatedRequest = this.mRemoteDevice.createDefaultRequest(templateType);
            if (this.mAppTargetSdkVersion < 26 || templateType != 2) {
                this.overrideEnableZsl(templatedRequest, false);
            }
            CaptureRequest.Builder builder = new CaptureRequest.Builder(templatedRequest, false, -1);
            return builder;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final CaptureRequest.Builder $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$createReprocessCaptureRequest(TotalCaptureResult inputResult) throws CameraAccessException {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.checkIfCameraClosedOrInError();
            CameraMetadataNative resultMetadata = new CameraMetadataNative(inputResult.getNativeCopy());
            return new CaptureRequest.Builder(resultMetadata, true, inputResult.getSessionId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$prepare(Surface surface) throws CameraAccessException {
        if (surface == null) {
            throw new IllegalArgumentException("Surface is null");
        }
        Object object = this.mInterfaceLock;
        synchronized (object) {
            int streamId = -1;
            for (int i = 0; i < this.mConfiguredOutputs.size(); ++i) {
                List<Surface> surfaces = this.mConfiguredOutputs.valueAt(i).getSurfaces();
                if (!surfaces.contains(surface)) continue;
                streamId = this.mConfiguredOutputs.keyAt(i);
                break;
            }
            if (streamId == -1) {
                throw new IllegalArgumentException("Surface is not part of this session");
            }
            this.mRemoteDevice.prepare(streamId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$prepare(int maxCount, Surface surface) throws CameraAccessException {
        if (surface == null) {
            throw new IllegalArgumentException("Surface is null");
        }
        if (maxCount <= 0) {
            throw new IllegalArgumentException("Invalid maxCount given: " + maxCount);
        }
        Object object = this.mInterfaceLock;
        synchronized (object) {
            int streamId = -1;
            for (int i = 0; i < this.mConfiguredOutputs.size(); ++i) {
                if (surface != this.mConfiguredOutputs.valueAt(i).getSurface()) continue;
                streamId = this.mConfiguredOutputs.keyAt(i);
                break;
            }
            if (streamId == -1) {
                throw new IllegalArgumentException("Surface is not part of this session");
            }
            this.mRemoteDevice.prepare2(maxCount, streamId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$tearDown(Surface surface) throws CameraAccessException {
        if (surface == null) {
            throw new IllegalArgumentException("Surface is null");
        }
        Object object = this.mInterfaceLock;
        synchronized (object) {
            int streamId = -1;
            for (int i = 0; i < this.mConfiguredOutputs.size(); ++i) {
                if (surface != this.mConfiguredOutputs.valueAt(i).getSurface()) continue;
                streamId = this.mConfiguredOutputs.keyAt(i);
                break;
            }
            if (streamId == -1) {
                throw new IllegalArgumentException("Surface is not part of this session");
            }
            this.mRemoteDevice.tearDown(streamId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$finalizeOutputConfigs(List<OutputConfiguration> outputConfigs) throws CameraAccessException {
        if (outputConfigs == null || outputConfigs.size() == 0) {
            throw new IllegalArgumentException("deferred config is null or empty");
        }
        Object object = this.mInterfaceLock;
        synchronized (object) {
            for (OutputConfiguration config : outputConfigs) {
                int streamId = -1;
                for (int i = 0; i < this.mConfiguredOutputs.size(); ++i) {
                    if (!config.equals(this.mConfiguredOutputs.valueAt(i))) continue;
                    streamId = this.mConfiguredOutputs.keyAt(i);
                    break;
                }
                if (streamId == -1) {
                    throw new IllegalArgumentException("Deferred config is not part of this session");
                }
                if (config.getSurfaces().size() == 0) {
                    throw new IllegalArgumentException("The final config for stream " + streamId + " must have at least 1 surface");
                }
                this.mRemoteDevice.finalizeOutputConfigurations(streamId, config);
            }
        }
    }

    private final int $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$capture(CaptureRequest request, CaptureCallback callback, Handler handler) throws CameraAccessException {
        ArrayList<CaptureRequest> requestList = new ArrayList<CaptureRequest>();
        requestList.add(request);
        return this.submitCaptureRequest(requestList, callback, handler, false);
    }

    private final int $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$captureBurst(List<CaptureRequest> requests, CaptureCallback callback, Handler handler) throws CameraAccessException {
        if (requests == null || requests.isEmpty()) {
            throw new IllegalArgumentException("At least one request must be given");
        }
        return this.submitCaptureRequest(requests, callback, handler, false);
    }

    private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$checkEarlyTriggerSequenceComplete(int requestId, long lastFrameNumber) {
        if (lastFrameNumber == -1L) {
            CaptureCallbackHolder holder;
            int index = this.mCaptureCallbackMap.indexOfKey(requestId);
            CaptureCallbackHolder captureCallbackHolder = holder = index >= 0 ? this.mCaptureCallbackMap.valueAt(index) : null;
            if (holder != null) {
                this.mCaptureCallbackMap.removeAt(index);
            }
            if (holder != null) {
                Runnable resultDispatch = new Runnable(this, requestId, holder){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ int val$requestId;
                    /* synthetic */ CaptureCallbackHolder val$holder;
                    /* synthetic */ CameraDeviceImpl this$0;

                    private void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_9$__constructor__(CameraDeviceImpl this$0, int n, CaptureCallbackHolder captureCallbackHolder) {
                    }

                    private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_9$run() {
                        if (!this.this$0.isClosed()) {
                            this.val$holder.getCallback().onCaptureSequenceAborted(this.this$0, this.val$requestId);
                        }
                    }

                    private void __constructor__(CameraDeviceImpl cameraDeviceImpl, int n, CaptureCallbackHolder captureCallbackHolder) {
                        this.$$robo$$android_hardware_camera2_impl_CameraDeviceImpl_9$__constructor__(cameraDeviceImpl, n, captureCallbackHolder);
                    }
                    {
                        this.this$0 = cameraDeviceImpl;
                        this.val$requestId = n;
                        this.val$holder = captureCallbackHolder;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_9$__constructor__(android.hardware.camera2.impl.CameraDeviceImpl int android.hardware.camera2.impl.CameraDeviceImpl$CaptureCallbackHolder ), 0, this, cameraDeviceImpl, n, captureCallbackHolder);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_9$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                };
                holder.getHandler().post(resultDispatch);
            } else {
                Log.w(this.TAG, String.format("did not register callback to request %d", requestId));
            }
        } else {
            this.mRequestLastFrameNumbersList.add(new RequestLastFrameNumbersHolder(requestId, lastFrameNumber));
            this.checkAndFireSequenceComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$submitCaptureRequest(List<CaptureRequest> requestList, CaptureCallback callback, Handler handler, boolean repeating) throws CameraAccessException {
        handler = CameraDeviceImpl.checkHandler(handler, callback);
        for (CaptureRequest request : requestList) {
            if (request.getTargets().isEmpty()) {
                throw new IllegalArgumentException("Each request must have at least one Surface target");
            }
            for (Surface surface : request.getTargets()) {
                if (surface != null) continue;
                throw new IllegalArgumentException("Null Surface targets are not allowed");
            }
        }
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.checkIfCameraClosedOrInError();
            if (repeating) {
                this.stopRepeating();
            }
            CaptureRequest[] requestArray = requestList.toArray(new CaptureRequest[requestList.size()]);
            SubmitInfo requestInfo = this.mRemoteDevice.submitRequestList(requestArray, repeating);
            if (callback != null) {
                this.mCaptureCallbackMap.put(requestInfo.getRequestId(), new CaptureCallbackHolder(callback, requestList, handler, repeating, this.mNextSessionId - 1));
            }
            if (repeating) {
                if (this.mRepeatingRequestId != -1) {
                    this.checkEarlyTriggerSequenceComplete(this.mRepeatingRequestId, requestInfo.getLastFrameNumber());
                }
                this.mRepeatingRequestId = requestInfo.getRequestId();
            } else {
                this.mRequestLastFrameNumbersList.add(new RequestLastFrameNumbersHolder(requestList, requestInfo));
            }
            if (this.mIdle) {
                this.mDeviceHandler.post(this.mCallOnActive);
            }
            this.mIdle = false;
            return requestInfo.getRequestId();
        }
    }

    private final int $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$setRepeatingRequest(CaptureRequest request, CaptureCallback callback, Handler handler) throws CameraAccessException {
        ArrayList<CaptureRequest> requestList = new ArrayList<CaptureRequest>();
        requestList.add(request);
        return this.submitCaptureRequest(requestList, callback, handler, true);
    }

    private final int $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$setRepeatingBurst(List<CaptureRequest> requests, CaptureCallback callback, Handler handler) throws CameraAccessException {
        if (requests == null || requests.isEmpty()) {
            throw new IllegalArgumentException("At least one request must be given");
        }
        return this.submitCaptureRequest(requests, callback, handler, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$stopRepeating() throws CameraAccessException {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.checkIfCameraClosedOrInError();
            if (this.mRepeatingRequestId != -1) {
                long lastFrameNumber;
                int requestId = this.mRepeatingRequestId;
                this.mRepeatingRequestId = -1;
                try {
                    lastFrameNumber = this.mRemoteDevice.cancelRequest(requestId);
                }
                catch (IllegalArgumentException e) {
                    return;
                }
                this.checkEarlyTriggerSequenceComplete(requestId, lastFrameNumber);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$waitUntilIdle() throws CameraAccessException {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.checkIfCameraClosedOrInError();
            if (this.mRepeatingRequestId != -1) {
                throw new IllegalStateException("Active repeating request ongoing");
            }
            this.mRemoteDevice.waitUntilIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$flush() throws CameraAccessException {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            this.checkIfCameraClosedOrInError();
            this.mDeviceHandler.post(this.mCallOnBusy);
            if (this.mIdle) {
                this.mDeviceHandler.post(this.mCallOnIdle);
                return;
            }
            long lastFrameNumber = this.mRemoteDevice.flush();
            if (this.mRepeatingRequestId != -1) {
                this.checkEarlyTriggerSequenceComplete(this.mRepeatingRequestId, lastFrameNumber);
                this.mRepeatingRequestId = -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$close() {
        Object object = this.mInterfaceLock;
        synchronized (object) {
            if (this.mClosing.getAndSet(true)) {
                return;
            }
            if (this.mRemoteDevice != null) {
                this.mRemoteDevice.disconnect();
                this.mRemoteDevice.unlinkToDeath(this, 0);
            }
            if (this.mRemoteDevice != null || this.mInError) {
                this.mDeviceHandler.post(this.mCallOnClosed);
            }
            this.mRemoteDevice = null;
        }
    }

    private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$checkInputConfiguration(InputConfiguration inputConfig) {
        if (inputConfig != null) {
            Size[] inputSizes;
            StreamConfigurationMap configMap = this.mCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            int[] inputFormats = configMap.getInputFormats();
            boolean validFormat = false;
            for (int format : inputFormats) {
                if (format != inputConfig.getFormat()) continue;
                validFormat = true;
            }
            if (!validFormat) {
                throw new IllegalArgumentException("input format " + inputConfig.getFormat() + " is not valid");
            }
            boolean validSize = false;
            for (Size s : inputSizes = configMap.getInputSizes(inputConfig.getFormat())) {
                if (inputConfig.getWidth() != s.getWidth() || inputConfig.getHeight() != s.getHeight()) continue;
                validSize = true;
            }
            if (!validSize) {
                throw new IllegalArgumentException("input size " + inputConfig.getWidth() + "x" + inputConfig.getHeight() + " is not valid");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$checkAndFireSequenceComplete() {
        long completedFrameNumber = this.mFrameNumberTracker.getCompletedFrameNumber();
        long completedReprocessFrameNumber = this.mFrameNumberTracker.getCompletedReprocessFrameNumber();
        boolean isReprocess = false;
        Iterator<RequestLastFrameNumbersHolder> iter = this.mRequestLastFrameNumbersList.iterator();
        while (iter.hasNext()) {
            CaptureCallbackHolder holder;
            RequestLastFrameNumbersHolder requestLastFrameNumbers = iter.next();
            boolean sequenceCompleted = false;
            int requestId = requestLastFrameNumbers.getRequestId();
            Object object = this.mInterfaceLock;
            synchronized (object) {
                if (this.mRemoteDevice == null) {
                    Log.w(this.TAG, "Camera closed while checking sequences");
                    return;
                }
                int index = this.mCaptureCallbackMap.indexOfKey(requestId);
                CaptureCallbackHolder captureCallbackHolder = holder = index >= 0 ? this.mCaptureCallbackMap.valueAt(index) : null;
                if (holder != null) {
                    long lastRegularFrameNumber = requestLastFrameNumbers.getLastRegularFrameNumber();
                    long lastReprocessFrameNumber = requestLastFrameNumbers.getLastReprocessFrameNumber();
                    if (lastRegularFrameNumber <= completedFrameNumber && lastReprocessFrameNumber <= completedReprocessFrameNumber) {
                        sequenceCompleted = true;
                        this.mCaptureCallbackMap.removeAt(index);
                    }
                }
            }
            if (holder == null || sequenceCompleted) {
                iter.remove();
            }
            if (!sequenceCompleted) continue;
            Runnable resultDispatch = new Runnable(this, requestId, holder, requestLastFrameNumbers){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ int val$requestId;
                /* synthetic */ CaptureCallbackHolder val$holder;
                /* synthetic */ RequestLastFrameNumbersHolder val$requestLastFrameNumbers;
                /* synthetic */ CameraDeviceImpl this$0;

                private void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_10$__constructor__(CameraDeviceImpl this$0, int n, CaptureCallbackHolder captureCallbackHolder, RequestLastFrameNumbersHolder requestLastFrameNumbersHolder) {
                }

                private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_10$run() {
                    if (!this.this$0.isClosed()) {
                        this.val$holder.getCallback().onCaptureSequenceCompleted(this.this$0, this.val$requestId, this.val$requestLastFrameNumbers.getLastFrameNumber());
                    }
                }

                private void __constructor__(CameraDeviceImpl cameraDeviceImpl, int n, CaptureCallbackHolder captureCallbackHolder, RequestLastFrameNumbersHolder requestLastFrameNumbersHolder) {
                    this.$$robo$$android_hardware_camera2_impl_CameraDeviceImpl_10$__constructor__(cameraDeviceImpl, n, captureCallbackHolder, requestLastFrameNumbersHolder);
                }
                {
                    this.this$0 = cameraDeviceImpl;
                    this.val$requestId = n;
                    this.val$holder = captureCallbackHolder;
                    this.val$requestLastFrameNumbers = requestLastFrameNumbersHolder;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_10$__constructor__(android.hardware.camera2.impl.CameraDeviceImpl int android.hardware.camera2.impl.CameraDeviceImpl$CaptureCallbackHolder android.hardware.camera2.impl.CameraDeviceImpl$RequestLastFrameNumbersHolder ), 0, this, cameraDeviceImpl, n, captureCallbackHolder, requestLastFrameNumbersHolder);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_10$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            holder.getHandler().post(resultDispatch);
        }
    }

    private static final Handler $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$checkHandler(Handler handler) {
        if (handler == null) {
            Looper looper = Looper.myLooper();
            if (looper == null) {
                throw new IllegalArgumentException("No handler given, and current thread has no looper!");
            }
            handler = new Handler(looper);
        }
        return handler;
    }

    private static final <T> Handler $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$checkHandler(Handler handler, T callback) {
        if (callback != null) {
            return CameraDeviceImpl.checkHandler(handler);
        }
        return handler;
    }

    private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$checkIfCameraClosedOrInError() throws CameraAccessException {
        if (this.mRemoteDevice == null) {
            throw new IllegalStateException("CameraDevice was already closed");
        }
        if (this.mInError) {
            throw new CameraAccessException(3, "The camera device has encountered a serious error");
        }
    }

    private final boolean $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$isClosed() {
        return this.mClosing.get();
    }

    private final CameraCharacteristics $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$getCharacteristics() {
        return this.mCharacteristics;
    }

    private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$binderDied() {
        Log.w(this.TAG, "CameraDevice " + this.mCameraId + " died unexpectedly");
        if (this.mRemoteDevice == null) {
            return;
        }
        this.mInError = true;
        Runnable r = new Runnable(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ CameraDeviceImpl this$0;

            private void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_11$__constructor__(CameraDeviceImpl this$0) {
            }

            private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_11$run() {
                if (!this.this$0.isClosed()) {
                    this.this$0.mDeviceCallback.onError(this.this$0, 5);
                }
            }

            private void __constructor__(CameraDeviceImpl cameraDeviceImpl) {
                this.$$robo$$android_hardware_camera2_impl_CameraDeviceImpl_11$__constructor__(cameraDeviceImpl);
            }
            {
                this.this$0 = cameraDeviceImpl;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_11$__constructor__(android.hardware.camera2.impl.CameraDeviceImpl ), 0, this, cameraDeviceImpl);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_11$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mDeviceHandler.post(r);
    }

    private void __constructor__(String string2, CameraDevice.StateCallback stateCallback, Handler handler, CameraCharacteristics cameraCharacteristics, int n) {
        this.$$robo$$android_hardware_camera2_impl_CameraDeviceImpl$__constructor__(string2, stateCallback, handler, cameraCharacteristics, n);
    }

    public CameraDeviceImpl(String string2, CameraDevice.StateCallback stateCallback, Handler handler, CameraCharacteristics cameraCharacteristics, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$__constructor__(java.lang.String android.hardware.camera2.CameraDevice$StateCallback android.os.Handler android.hardware.camera2.CameraCharacteristics int ), 0, this, string2, stateCallback, handler, cameraCharacteristics, n);
    }

    public CameraDeviceCallbacks getCallbacks() {
        return InvokeDynamicSupport.bootstrap("getCallbacks", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$getCallbacks(), 0, this);
    }

    public void setRemoteDevice(ICameraDeviceUser iCameraDeviceUser) throws CameraAccessException {
        InvokeDynamicSupport.bootstrap("setRemoteDevice", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$setRemoteDevice(android.hardware.camera2.ICameraDeviceUser ), 0, this, iCameraDeviceUser);
    }

    public void setRemoteFailure(ServiceSpecificException serviceSpecificException) {
        InvokeDynamicSupport.bootstrap("setRemoteFailure", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$setRemoteFailure(android.os.ServiceSpecificException ), 0, this, serviceSpecificException);
    }

    @Override
    public String getId() {
        return InvokeDynamicSupport.bootstrap("getId", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$getId(), 0, this);
    }

    public void configureOutputs(List<Surface> list) throws CameraAccessException {
        InvokeDynamicSupport.bootstrap("configureOutputs", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$configureOutputs(java.util.List<android.view.Surface> ), 0, this, list);
    }

    public boolean configureStreamsChecked(InputConfiguration inputConfiguration, List<OutputConfiguration> list, int n) throws CameraAccessException {
        return (boolean)InvokeDynamicSupport.bootstrap("configureStreamsChecked", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$configureStreamsChecked(android.hardware.camera2.params.InputConfiguration java.util.List<android.hardware.camera2.params.OutputConfiguration> int ), 0, this, inputConfiguration, list, n);
    }

    @Override
    public void createCaptureSession(List<Surface> list, CameraCaptureSession.StateCallback stateCallback, Handler handler) throws CameraAccessException {
        InvokeDynamicSupport.bootstrap("createCaptureSession", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$createCaptureSession(java.util.List<android.view.Surface> android.hardware.camera2.CameraCaptureSession$StateCallback android.os.Handler ), 0, this, list, stateCallback, handler);
    }

    @Override
    public void createCaptureSessionByOutputConfigurations(List<OutputConfiguration> list, CameraCaptureSession.StateCallback stateCallback, Handler handler) throws CameraAccessException {
        InvokeDynamicSupport.bootstrap("createCaptureSessionByOutputConfigurations", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$createCaptureSessionByOutputConfigurations(java.util.List<android.hardware.camera2.params.OutputConfiguration> android.hardware.camera2.CameraCaptureSession$StateCallback android.os.Handler ), 0, this, list, stateCallback, handler);
    }

    @Override
    public void createReprocessableCaptureSession(InputConfiguration inputConfiguration, List<Surface> list, CameraCaptureSession.StateCallback stateCallback, Handler handler) throws CameraAccessException {
        InvokeDynamicSupport.bootstrap("createReprocessableCaptureSession", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$createReprocessableCaptureSession(android.hardware.camera2.params.InputConfiguration java.util.List<android.view.Surface> android.hardware.camera2.CameraCaptureSession$StateCallback android.os.Handler ), 0, this, inputConfiguration, list, stateCallback, handler);
    }

    @Override
    public void createReprocessableCaptureSessionByConfigurations(InputConfiguration inputConfiguration, List<OutputConfiguration> list, CameraCaptureSession.StateCallback stateCallback, Handler handler) throws CameraAccessException {
        InvokeDynamicSupport.bootstrap("createReprocessableCaptureSessionByConfigurations", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$createReprocessableCaptureSessionByConfigurations(android.hardware.camera2.params.InputConfiguration java.util.List<android.hardware.camera2.params.OutputConfiguration> android.hardware.camera2.CameraCaptureSession$StateCallback android.os.Handler ), 0, this, inputConfiguration, list, stateCallback, handler);
    }

    @Override
    public void createConstrainedHighSpeedCaptureSession(List<Surface> list, CameraCaptureSession.StateCallback stateCallback, Handler handler) throws CameraAccessException {
        InvokeDynamicSupport.bootstrap("createConstrainedHighSpeedCaptureSession", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$createConstrainedHighSpeedCaptureSession(java.util.List<android.view.Surface> android.hardware.camera2.CameraCaptureSession$StateCallback android.os.Handler ), 0, this, list, stateCallback, handler);
    }

    @Override
    public void createCustomCaptureSession(InputConfiguration inputConfiguration, List<OutputConfiguration> list, int n, CameraCaptureSession.StateCallback stateCallback, Handler handler) throws CameraAccessException {
        InvokeDynamicSupport.bootstrap("createCustomCaptureSession", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$createCustomCaptureSession(android.hardware.camera2.params.InputConfiguration java.util.List<android.hardware.camera2.params.OutputConfiguration> int android.hardware.camera2.CameraCaptureSession$StateCallback android.os.Handler ), 0, this, inputConfiguration, list, n, stateCallback, handler);
    }

    private void createCaptureSessionInternal(InputConfiguration inputConfiguration, List<OutputConfiguration> list, CameraCaptureSession.StateCallback stateCallback, Handler handler, int n) throws CameraAccessException {
        InvokeDynamicSupport.bootstrap("createCaptureSessionInternal", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$createCaptureSessionInternal(android.hardware.camera2.params.InputConfiguration java.util.List<android.hardware.camera2.params.OutputConfiguration> android.hardware.camera2.CameraCaptureSession$StateCallback android.os.Handler int ), 0, this, inputConfiguration, list, stateCallback, handler, n);
    }

    public void setSessionListener(StateCallbackKK stateCallbackKK) {
        InvokeDynamicSupport.bootstrap("setSessionListener", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$setSessionListener(android.hardware.camera2.impl.CameraDeviceImpl$StateCallbackKK ), 0, this, stateCallbackKK);
    }

    private void overrideEnableZsl(CameraMetadataNative cameraMetadataNative, boolean bl) {
        InvokeDynamicSupport.bootstrap("overrideEnableZsl", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$overrideEnableZsl(android.hardware.camera2.impl.CameraMetadataNative boolean ), 0, this, cameraMetadataNative, bl);
    }

    @Override
    public CaptureRequest.Builder createCaptureRequest(int n) throws CameraAccessException {
        return InvokeDynamicSupport.bootstrap("createCaptureRequest", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$createCaptureRequest(int ), 0, this, n);
    }

    @Override
    public CaptureRequest.Builder createReprocessCaptureRequest(TotalCaptureResult totalCaptureResult) throws CameraAccessException {
        return InvokeDynamicSupport.bootstrap("createReprocessCaptureRequest", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$createReprocessCaptureRequest(android.hardware.camera2.TotalCaptureResult ), 0, this, totalCaptureResult);
    }

    public void prepare(Surface surface) throws CameraAccessException {
        InvokeDynamicSupport.bootstrap("prepare", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$prepare(android.view.Surface ), 0, this, surface);
    }

    public void prepare(int n, Surface surface) throws CameraAccessException {
        InvokeDynamicSupport.bootstrap("prepare", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$prepare(int android.view.Surface ), 0, this, n, surface);
    }

    public void tearDown(Surface surface) throws CameraAccessException {
        InvokeDynamicSupport.bootstrap("tearDown", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$tearDown(android.view.Surface ), 0, this, surface);
    }

    public void finalizeOutputConfigs(List<OutputConfiguration> list) throws CameraAccessException {
        InvokeDynamicSupport.bootstrap("finalizeOutputConfigs", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$finalizeOutputConfigs(java.util.List<android.hardware.camera2.params.OutputConfiguration> ), 0, this, list);
    }

    public int capture(CaptureRequest captureRequest, CaptureCallback captureCallback, Handler handler) throws CameraAccessException {
        return (int)InvokeDynamicSupport.bootstrap("capture", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$capture(android.hardware.camera2.CaptureRequest android.hardware.camera2.impl.CameraDeviceImpl$CaptureCallback android.os.Handler ), 0, this, captureRequest, captureCallback, handler);
    }

    public int captureBurst(List<CaptureRequest> list, CaptureCallback captureCallback, Handler handler) throws CameraAccessException {
        return (int)InvokeDynamicSupport.bootstrap("captureBurst", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$captureBurst(java.util.List<android.hardware.camera2.CaptureRequest> android.hardware.camera2.impl.CameraDeviceImpl$CaptureCallback android.os.Handler ), 0, this, list, captureCallback, handler);
    }

    private void checkEarlyTriggerSequenceComplete(int n, long l) {
        InvokeDynamicSupport.bootstrap("checkEarlyTriggerSequenceComplete", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$checkEarlyTriggerSequenceComplete(int long ), 0, this, n, l);
    }

    private int submitCaptureRequest(List<CaptureRequest> list, CaptureCallback captureCallback, Handler handler, boolean bl) throws CameraAccessException {
        return (int)InvokeDynamicSupport.bootstrap("submitCaptureRequest", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$submitCaptureRequest(java.util.List<android.hardware.camera2.CaptureRequest> android.hardware.camera2.impl.CameraDeviceImpl$CaptureCallback android.os.Handler boolean ), 0, this, list, captureCallback, handler, bl);
    }

    public int setRepeatingRequest(CaptureRequest captureRequest, CaptureCallback captureCallback, Handler handler) throws CameraAccessException {
        return (int)InvokeDynamicSupport.bootstrap("setRepeatingRequest", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$setRepeatingRequest(android.hardware.camera2.CaptureRequest android.hardware.camera2.impl.CameraDeviceImpl$CaptureCallback android.os.Handler ), 0, this, captureRequest, captureCallback, handler);
    }

    public int setRepeatingBurst(List<CaptureRequest> list, CaptureCallback captureCallback, Handler handler) throws CameraAccessException {
        return (int)InvokeDynamicSupport.bootstrap("setRepeatingBurst", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$setRepeatingBurst(java.util.List<android.hardware.camera2.CaptureRequest> android.hardware.camera2.impl.CameraDeviceImpl$CaptureCallback android.os.Handler ), 0, this, list, captureCallback, handler);
    }

    public void stopRepeating() throws CameraAccessException {
        InvokeDynamicSupport.bootstrap("stopRepeating", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$stopRepeating(), 0, this);
    }

    private void waitUntilIdle() throws CameraAccessException {
        InvokeDynamicSupport.bootstrap("waitUntilIdle", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$waitUntilIdle(), 0, this);
    }

    public void flush() throws CameraAccessException {
        InvokeDynamicSupport.bootstrap("flush", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$flush(), 0, this);
    }

    @Override
    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$close(), 0, this);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$finalize(), 0, this);
    }

    private void checkInputConfiguration(InputConfiguration inputConfiguration) {
        InvokeDynamicSupport.bootstrap("checkInputConfiguration", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$checkInputConfiguration(android.hardware.camera2.params.InputConfiguration ), 0, this, inputConfiguration);
    }

    private void checkAndFireSequenceComplete() {
        InvokeDynamicSupport.bootstrap("checkAndFireSequenceComplete", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$checkAndFireSequenceComplete(), 0, this);
    }

    static Handler checkHandler(Handler handler) {
        return InvokeDynamicSupport.bootstrapStatic("checkHandler", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$checkHandler(android.os.Handler ), 0, (Handler)handler);
    }

    static <T> Handler checkHandler(Handler handler, T t) {
        return InvokeDynamicSupport.bootstrapStatic("checkHandler", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$checkHandler(android.os.Handler T ), 0, (Handler)handler, t);
    }

    private void checkIfCameraClosedOrInError() throws CameraAccessException {
        InvokeDynamicSupport.bootstrap("checkIfCameraClosedOrInError", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$checkIfCameraClosedOrInError(), 0, this);
    }

    private boolean isClosed() {
        return (boolean)InvokeDynamicSupport.bootstrap("isClosed", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$isClosed(), 0, this);
    }

    private CameraCharacteristics getCharacteristics() {
        return InvokeDynamicSupport.bootstrap("getCharacteristics", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$getCharacteristics(), 0, this);
    }

    @Override
    public void binderDied() {
        InvokeDynamicSupport.bootstrap("binderDied", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl$binderDied(), 0, this);
    }

    public /* synthetic */ CameraDeviceImpl() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CameraDeviceImpl)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class CameraDeviceCallbacks
    extends ICameraDeviceCallbacks.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ CameraDeviceImpl this$0;

        private void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks$__constructor__(CameraDeviceImpl this$0) {
        }

        private final IBinder $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks$asBinder() {
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks$onDeviceError(int errorCode, CaptureResultExtras resultExtras) {
            Object object = this.this$0.mInterfaceLock;
            synchronized (object) {
                if (this.this$0.mRemoteDevice == null) {
                    return;
                }
                switch (errorCode) {
                    case 0: {
                        this.this$0.mDeviceHandler.post(this.this$0.mCallOnDisconnected);
                        break;
                    }
                    default: {
                        Log.e(this.this$0.TAG, "Unknown error from camera device: " + errorCode);
                    }
                    case 1: 
                    case 2: {
                        this.this$0.mInError = true;
                        int publicErrorCode = errorCode == 1 ? 4 : 5;
                        Runnable r = new Runnable(this, publicErrorCode){
                            public transient /* synthetic */ Object __robo_data__;
                            /* synthetic */ int val$publicErrorCode;
                            /* synthetic */ CameraDeviceCallbacks this$1;

                            private void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks_1$__constructor__(CameraDeviceCallbacks this$1, int n) {
                            }

                            private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks_1$run() {
                                if (!this.this$1.this$0.isClosed()) {
                                    this.this$1.this$0.mDeviceCallback.onError(this.this$1.this$0, this.val$publicErrorCode);
                                }
                            }

                            private void __constructor__(CameraDeviceCallbacks cameraDeviceCallbacks, int n) {
                                this.$$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks_1$__constructor__(cameraDeviceCallbacks, n);
                            }
                            {
                                this.this$1 = cameraDeviceCallbacks;
                                this.val$publicErrorCode = n;
                                this.$$robo$init();
                                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks_1$__constructor__(android.hardware.camera2.impl.CameraDeviceImpl$CameraDeviceCallbacks int ), 0, this, cameraDeviceCallbacks, n);
                            }

                            @Override
                            public void run() {
                                InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks_1$run(), 0, this);
                            }
                            {
                                this.$$robo$init();
                            }

                            protected /* synthetic */ void $$robo$init() {
                                if (this.__robo_data__ == null) {
                                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                                }
                            }

                            public /* synthetic */ Object $$robo$getData() {
                                return this.__robo_data__;
                            }
                        };
                        this.this$0.mDeviceHandler.post(r);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        this.onCaptureErrorLocked(errorCode, resultExtras);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks$onRepeatingRequestError(long lastFrameNumber, int repeatingRequestId) {
            Object object = this.this$0.mInterfaceLock;
            synchronized (object) {
                if (this.this$0.mRemoteDevice == null || this.this$0.mRepeatingRequestId == -1) {
                    return;
                }
                this.this$0.checkEarlyTriggerSequenceComplete(this.this$0.mRepeatingRequestId, lastFrameNumber);
                if (this.this$0.mRepeatingRequestId == repeatingRequestId) {
                    this.this$0.mRepeatingRequestId = -1;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks$onDeviceIdle() {
            Object object = this.this$0.mInterfaceLock;
            synchronized (object) {
                if (this.this$0.mRemoteDevice == null) {
                    return;
                }
                if (!this.this$0.mIdle) {
                    this.this$0.mDeviceHandler.post(this.this$0.mCallOnIdle);
                }
                this.this$0.mIdle = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks$onCaptureStarted(CaptureResultExtras resultExtras, long timestamp) {
            int requestId = resultExtras.getRequestId();
            long frameNumber = resultExtras.getFrameNumber();
            Object object = this.this$0.mInterfaceLock;
            synchronized (object) {
                if (this.this$0.mRemoteDevice == null) {
                    return;
                }
                CaptureCallbackHolder holder = (CaptureCallbackHolder)this.this$0.mCaptureCallbackMap.get(requestId);
                if (holder == null) {
                    return;
                }
                if (this.this$0.isClosed()) {
                    return;
                }
                holder.getHandler().post(new Runnable(this, resultExtras, holder, timestamp, frameNumber){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ CaptureResultExtras val$resultExtras;
                    /* synthetic */ CaptureCallbackHolder val$holder;
                    /* synthetic */ long val$timestamp;
                    /* synthetic */ long val$frameNumber;
                    /* synthetic */ CameraDeviceCallbacks this$1;

                    private void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks_2$__constructor__(CameraDeviceCallbacks this$1, CaptureResultExtras captureResultExtras, CaptureCallbackHolder captureCallbackHolder, long l, long l2) {
                    }

                    private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks_2$run() {
                        if (!this.this$1.this$0.isClosed()) {
                            int subsequenceId = this.val$resultExtras.getSubsequenceId();
                            CaptureRequest request = this.val$holder.getRequest(subsequenceId);
                            if (this.val$holder.hasBatchedOutputs()) {
                                Range<Integer> fpsRange = request.get(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE);
                                for (int i = 0; i < this.val$holder.getRequestCount(); ++i) {
                                    this.val$holder.getCallback().onCaptureStarted(this.this$1.this$0, this.val$holder.getRequest(i), this.val$timestamp - (long)(subsequenceId - i) * 1000000000L / (long)fpsRange.getUpper().intValue(), this.val$frameNumber - (long)(subsequenceId - i));
                                }
                            } else {
                                this.val$holder.getCallback().onCaptureStarted(this.this$1.this$0, this.val$holder.getRequest(this.val$resultExtras.getSubsequenceId()), this.val$timestamp, this.val$frameNumber);
                            }
                        }
                    }

                    private void __constructor__(CameraDeviceCallbacks cameraDeviceCallbacks, CaptureResultExtras captureResultExtras, CaptureCallbackHolder captureCallbackHolder, long l, long l2) {
                        this.$$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks_2$__constructor__(cameraDeviceCallbacks, captureResultExtras, captureCallbackHolder, l, l2);
                    }
                    {
                        this.this$1 = cameraDeviceCallbacks;
                        this.val$resultExtras = captureResultExtras;
                        this.val$holder = captureCallbackHolder;
                        this.val$timestamp = l;
                        this.val$frameNumber = l2;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks_2$__constructor__(android.hardware.camera2.impl.CameraDeviceImpl$CameraDeviceCallbacks android.hardware.camera2.impl.CaptureResultExtras android.hardware.camera2.impl.CameraDeviceImpl$CaptureCallbackHolder long long ), 0, this, cameraDeviceCallbacks, captureResultExtras, captureCallbackHolder, l, l2);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks_2$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks$onResultReceived(CameraMetadataNative result, CaptureResultExtras resultExtras) throws RemoteException {
            int requestId = resultExtras.getRequestId();
            long frameNumber = resultExtras.getFrameNumber();
            Object object = this.this$0.mInterfaceLock;
            synchronized (object) {
                CaptureResult finalResult;
                if (this.this$0.mRemoteDevice == null) {
                    return;
                }
                result.set(CameraCharacteristics.LENS_INFO_SHADING_MAP_SIZE, this.this$0.getCharacteristics().get(CameraCharacteristics.LENS_INFO_SHADING_MAP_SIZE));
                CaptureCallbackHolder holder = (CaptureCallbackHolder)this.this$0.mCaptureCallbackMap.get(requestId);
                CaptureRequest request = holder.getRequest(resultExtras.getSubsequenceId());
                boolean isPartialResult = resultExtras.getPartialResultCount() < this.this$0.mTotalPartialCount;
                boolean isReprocess = request.isReprocess();
                if (holder == null) {
                    this.this$0.mFrameNumberTracker.updateTracker(frameNumber, null, isPartialResult, isReprocess);
                    return;
                }
                if (this.this$0.isClosed()) {
                    this.this$0.mFrameNumberTracker.updateTracker(frameNumber, null, isPartialResult, isReprocess);
                    return;
                }
                Runnable resultDispatch = null;
                CameraMetadataNative resultCopy = holder.hasBatchedOutputs() ? new CameraMetadataNative(result) : null;
                if (isPartialResult) {
                    CaptureResult resultAsCapture = new CaptureResult(result, request, resultExtras);
                    resultDispatch = new Runnable(this, holder, resultCopy, resultExtras, request, resultAsCapture){
                        public transient /* synthetic */ Object __robo_data__;
                        /* synthetic */ CaptureCallbackHolder val$holder;
                        /* synthetic */ CameraMetadataNative val$resultCopy;
                        /* synthetic */ CaptureResultExtras val$resultExtras;
                        /* synthetic */ CaptureRequest val$request;
                        /* synthetic */ CaptureResult val$resultAsCapture;
                        /* synthetic */ CameraDeviceCallbacks this$1;

                        private void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks_3$__constructor__(CameraDeviceCallbacks this$1, CaptureCallbackHolder captureCallbackHolder, CameraMetadataNative cameraMetadataNative, CaptureResultExtras captureResultExtras, CaptureRequest captureRequest, CaptureResult captureResult) {
                        }

                        private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks_3$run() {
                            if (!this.this$1.this$0.isClosed()) {
                                if (this.val$holder.hasBatchedOutputs()) {
                                    for (int i = 0; i < this.val$holder.getRequestCount(); ++i) {
                                        CameraMetadataNative resultLocal = new CameraMetadataNative(this.val$resultCopy);
                                        CaptureResult resultInBatch = new CaptureResult(resultLocal, this.val$holder.getRequest(i), this.val$resultExtras);
                                        this.val$holder.getCallback().onCaptureProgressed(this.this$1.this$0, this.val$holder.getRequest(i), resultInBatch);
                                    }
                                } else {
                                    this.val$holder.getCallback().onCaptureProgressed(this.this$1.this$0, this.val$request, this.val$resultAsCapture);
                                }
                            }
                        }

                        private void __constructor__(CameraDeviceCallbacks cameraDeviceCallbacks, CaptureCallbackHolder captureCallbackHolder, CameraMetadataNative cameraMetadataNative, CaptureResultExtras captureResultExtras, CaptureRequest captureRequest, CaptureResult captureResult) {
                            this.$$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks_3$__constructor__(cameraDeviceCallbacks, captureCallbackHolder, cameraMetadataNative, captureResultExtras, captureRequest, captureResult);
                        }
                        {
                            this.this$1 = cameraDeviceCallbacks;
                            this.val$holder = captureCallbackHolder;
                            this.val$resultCopy = cameraMetadataNative;
                            this.val$resultExtras = captureResultExtras;
                            this.val$request = captureRequest;
                            this.val$resultAsCapture = captureResult;
                            this.$$robo$init();
                            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks_3$__constructor__(android.hardware.camera2.impl.CameraDeviceImpl$CameraDeviceCallbacks android.hardware.camera2.impl.CameraDeviceImpl$CaptureCallbackHolder android.hardware.camera2.impl.CameraMetadataNative android.hardware.camera2.impl.CaptureResultExtras android.hardware.camera2.CaptureRequest android.hardware.camera2.CaptureResult ), 0, this, cameraDeviceCallbacks, captureCallbackHolder, cameraMetadataNative, captureResultExtras, captureRequest, captureResult);
                        }

                        @Override
                        public void run() {
                            InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks_3$run(), 0, this);
                        }
                        {
                            this.$$robo$init();
                        }

                        protected /* synthetic */ void $$robo$init() {
                            if (this.__robo_data__ == null) {
                                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                            }
                        }

                        public /* synthetic */ Object $$robo$getData() {
                            return this.__robo_data__;
                        }
                    };
                    finalResult = resultAsCapture;
                } else {
                    List<CaptureResult> partialResults = this.this$0.mFrameNumberTracker.popPartialResults(frameNumber);
                    long sensorTimestamp = result.get(CaptureResult.SENSOR_TIMESTAMP);
                    Range<Integer> fpsRange = request.get(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE);
                    int subsequenceId = resultExtras.getSubsequenceId();
                    TotalCaptureResult resultAsCapture = new TotalCaptureResult(result, request, resultExtras, partialResults, holder.getSessionId());
                    resultDispatch = new Runnable(this, holder, resultCopy, sensorTimestamp, subsequenceId, fpsRange, resultExtras, partialResults, request, resultAsCapture){
                        public transient /* synthetic */ Object __robo_data__;
                        /* synthetic */ CaptureCallbackHolder val$holder;
                        /* synthetic */ CameraMetadataNative val$resultCopy;
                        /* synthetic */ long val$sensorTimestamp;
                        /* synthetic */ int val$subsequenceId;
                        /* synthetic */ Range val$fpsRange;
                        /* synthetic */ CaptureResultExtras val$resultExtras;
                        /* synthetic */ List val$partialResults;
                        /* synthetic */ CaptureRequest val$request;
                        /* synthetic */ TotalCaptureResult val$resultAsCapture;
                        /* synthetic */ CameraDeviceCallbacks this$1;

                        private void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks_4$__constructor__(CameraDeviceCallbacks this$1, CaptureCallbackHolder captureCallbackHolder, CameraMetadataNative cameraMetadataNative, long l, int n, Range range, CaptureResultExtras captureResultExtras, List list, CaptureRequest captureRequest, TotalCaptureResult totalCaptureResult) {
                        }

                        private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks_4$run() {
                            if (!this.this$1.this$0.isClosed()) {
                                if (this.val$holder.hasBatchedOutputs()) {
                                    for (int i = 0; i < this.val$holder.getRequestCount(); ++i) {
                                        this.val$resultCopy.set(CaptureResult.SENSOR_TIMESTAMP, Long.valueOf(this.val$sensorTimestamp - (long)(this.val$subsequenceId - i) * 1000000000L / (long)((Integer)this.val$fpsRange.getUpper()).intValue()));
                                        CameraMetadataNative resultLocal = new CameraMetadataNative(this.val$resultCopy);
                                        TotalCaptureResult resultInBatch = new TotalCaptureResult(resultLocal, this.val$holder.getRequest(i), this.val$resultExtras, this.val$partialResults, this.val$holder.getSessionId());
                                        this.val$holder.getCallback().onCaptureCompleted(this.this$1.this$0, this.val$holder.getRequest(i), resultInBatch);
                                    }
                                } else {
                                    this.val$holder.getCallback().onCaptureCompleted(this.this$1.this$0, this.val$request, this.val$resultAsCapture);
                                }
                            }
                        }

                        private void __constructor__(CameraDeviceCallbacks cameraDeviceCallbacks, CaptureCallbackHolder captureCallbackHolder, CameraMetadataNative cameraMetadataNative, long l, int n, Range range, CaptureResultExtras captureResultExtras, List list, CaptureRequest captureRequest, TotalCaptureResult totalCaptureResult) {
                            this.$$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks_4$__constructor__(cameraDeviceCallbacks, captureCallbackHolder, cameraMetadataNative, l, n, range, captureResultExtras, list, captureRequest, totalCaptureResult);
                        }
                        {
                            this.this$1 = cameraDeviceCallbacks;
                            this.val$holder = captureCallbackHolder;
                            this.val$resultCopy = cameraMetadataNative;
                            this.val$sensorTimestamp = l;
                            this.val$subsequenceId = n;
                            this.val$fpsRange = range;
                            this.val$resultExtras = captureResultExtras;
                            this.val$partialResults = list;
                            this.val$request = captureRequest;
                            this.val$resultAsCapture = totalCaptureResult;
                            this.$$robo$init();
                            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks_4$__constructor__(android.hardware.camera2.impl.CameraDeviceImpl$CameraDeviceCallbacks android.hardware.camera2.impl.CameraDeviceImpl$CaptureCallbackHolder android.hardware.camera2.impl.CameraMetadataNative long int android.util.Range android.hardware.camera2.impl.CaptureResultExtras java.util.List android.hardware.camera2.CaptureRequest android.hardware.camera2.TotalCaptureResult ), 0, this, cameraDeviceCallbacks, captureCallbackHolder, cameraMetadataNative, l, n, range, captureResultExtras, list, captureRequest, totalCaptureResult);
                        }

                        @Override
                        public void run() {
                            InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks_4$run(), 0, this);
                        }
                        {
                            this.$$robo$init();
                        }

                        protected /* synthetic */ void $$robo$init() {
                            if (this.__robo_data__ == null) {
                                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                            }
                        }

                        public /* synthetic */ Object $$robo$getData() {
                            return this.__robo_data__;
                        }
                    };
                    finalResult = resultAsCapture;
                }
                holder.getHandler().post(resultDispatch);
                this.this$0.mFrameNumberTracker.updateTracker(frameNumber, finalResult, isPartialResult, isReprocess);
                if (!isPartialResult) {
                    this.this$0.checkAndFireSequenceComplete();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks$onPrepared(int streamId) {
            StateCallbackKK sessionCallback;
            OutputConfiguration output;
            Object object = this.this$0.mInterfaceLock;
            synchronized (object) {
                output = (OutputConfiguration)this.this$0.mConfiguredOutputs.get(streamId);
                sessionCallback = this.this$0.mSessionStateCallback;
            }
            if (sessionCallback == null) {
                return;
            }
            if (output == null) {
                Log.w(this.this$0.TAG, "onPrepared invoked for unknown output Surface");
                return;
            }
            List<Surface> surfaces = output.getSurfaces();
            for (Surface surface : surfaces) {
                sessionCallback.onSurfacePrepared(surface);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks$onRequestQueueEmpty() {
            StateCallbackKK sessionCallback;
            Object object = this.this$0.mInterfaceLock;
            synchronized (object) {
                sessionCallback = this.this$0.mSessionStateCallback;
            }
            if (sessionCallback == null) {
                return;
            }
            sessionCallback.onRequestQueueEmpty();
        }

        private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks$onCaptureErrorLocked(int errorCode, CaptureResultExtras resultExtras) {
            int requestId = resultExtras.getRequestId();
            int subsequenceId = resultExtras.getSubsequenceId();
            long frameNumber = resultExtras.getFrameNumber();
            CaptureCallbackHolder holder = (CaptureCallbackHolder)this.this$0.mCaptureCallbackMap.get(requestId);
            CaptureRequest request = holder.getRequest(subsequenceId);
            Runnable failureDispatch = null;
            if (errorCode == 5) {
                List<Surface> surfaces = ((OutputConfiguration)this.this$0.mConfiguredOutputs.get(resultExtras.getErrorStreamId())).getSurfaces();
                for (Surface surface : surfaces) {
                    if (!request.containsTarget(surface)) continue;
                    failureDispatch = new Runnable(this, holder, request, surface, frameNumber){
                        public transient /* synthetic */ Object __robo_data__;
                        /* synthetic */ CaptureCallbackHolder val$holder;
                        /* synthetic */ CaptureRequest val$request;
                        /* synthetic */ Surface val$surface;
                        /* synthetic */ long val$frameNumber;
                        /* synthetic */ CameraDeviceCallbacks this$1;

                        private void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks_5$__constructor__(CameraDeviceCallbacks this$1, CaptureCallbackHolder captureCallbackHolder, CaptureRequest captureRequest, Surface surface, long l) {
                        }

                        private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks_5$run() {
                            if (!this.this$1.this$0.isClosed()) {
                                this.val$holder.getCallback().onCaptureBufferLost(this.this$1.this$0, this.val$request, this.val$surface, this.val$frameNumber);
                            }
                        }

                        private void __constructor__(CameraDeviceCallbacks cameraDeviceCallbacks, CaptureCallbackHolder captureCallbackHolder, CaptureRequest captureRequest, Surface surface, long l) {
                            this.$$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks_5$__constructor__(cameraDeviceCallbacks, captureCallbackHolder, captureRequest, surface, l);
                        }
                        {
                            this.this$1 = cameraDeviceCallbacks;
                            this.val$holder = captureCallbackHolder;
                            this.val$request = captureRequest;
                            this.val$surface = surface;
                            this.val$frameNumber = l;
                            this.$$robo$init();
                            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks_5$__constructor__(android.hardware.camera2.impl.CameraDeviceImpl$CameraDeviceCallbacks android.hardware.camera2.impl.CameraDeviceImpl$CaptureCallbackHolder android.hardware.camera2.CaptureRequest android.view.Surface long ), 0, this, cameraDeviceCallbacks, captureCallbackHolder, captureRequest, surface, l);
                        }

                        @Override
                        public void run() {
                            InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks_5$run(), 0, this);
                        }
                        {
                            this.$$robo$init();
                        }

                        protected /* synthetic */ void $$robo$init() {
                            if (this.__robo_data__ == null) {
                                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                            }
                        }

                        public /* synthetic */ Object $$robo$getData() {
                            return this.__robo_data__;
                        }
                    };
                    holder.getHandler().post(failureDispatch);
                }
            } else {
                boolean mayHaveBuffers = errorCode == 4;
                int reason = this.this$0.mCurrentSession != null && this.this$0.mCurrentSession.isAborting() ? 1 : 0;
                CaptureFailure failure = new CaptureFailure(request, reason, mayHaveBuffers, requestId, frameNumber);
                failureDispatch = new Runnable(this, holder, request, failure){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ CaptureCallbackHolder val$holder;
                    /* synthetic */ CaptureRequest val$request;
                    /* synthetic */ CaptureFailure val$failure;
                    /* synthetic */ CameraDeviceCallbacks this$1;

                    private void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks_6$__constructor__(CameraDeviceCallbacks this$1, CaptureCallbackHolder captureCallbackHolder, CaptureRequest captureRequest, CaptureFailure captureFailure) {
                    }

                    private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks_6$run() {
                        if (!this.this$1.this$0.isClosed()) {
                            this.val$holder.getCallback().onCaptureFailed(this.this$1.this$0, this.val$request, this.val$failure);
                        }
                    }

                    private void __constructor__(CameraDeviceCallbacks cameraDeviceCallbacks, CaptureCallbackHolder captureCallbackHolder, CaptureRequest captureRequest, CaptureFailure captureFailure) {
                        this.$$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks_6$__constructor__(cameraDeviceCallbacks, captureCallbackHolder, captureRequest, captureFailure);
                    }
                    {
                        this.this$1 = cameraDeviceCallbacks;
                        this.val$holder = captureCallbackHolder;
                        this.val$request = captureRequest;
                        this.val$failure = captureFailure;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks_6$__constructor__(android.hardware.camera2.impl.CameraDeviceImpl$CameraDeviceCallbacks android.hardware.camera2.impl.CameraDeviceImpl$CaptureCallbackHolder android.hardware.camera2.CaptureRequest android.hardware.camera2.CaptureFailure ), 0, this, cameraDeviceCallbacks, captureCallbackHolder, captureRequest, captureFailure);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks_6$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                };
                this.this$0.mFrameNumberTracker.updateTracker(frameNumber, true, request.isReprocess());
                this.this$0.checkAndFireSequenceComplete();
                holder.getHandler().post(failureDispatch);
            }
        }

        private void __constructor__(CameraDeviceImpl cameraDeviceImpl) {
            this.$$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks$__constructor__(cameraDeviceImpl);
        }

        public CameraDeviceCallbacks(CameraDeviceImpl cameraDeviceImpl) {
            this.this$0 = cameraDeviceImpl;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks$__constructor__(android.hardware.camera2.impl.CameraDeviceImpl ), 0, this, cameraDeviceImpl);
        }

        @Override
        public IBinder asBinder() {
            return InvokeDynamicSupport.bootstrap("asBinder", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks$asBinder(), 0, this);
        }

        @Override
        public void onDeviceError(int n, CaptureResultExtras captureResultExtras) {
            InvokeDynamicSupport.bootstrap("onDeviceError", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks$onDeviceError(int android.hardware.camera2.impl.CaptureResultExtras ), 0, this, n, captureResultExtras);
        }

        @Override
        public void onRepeatingRequestError(long l, int n) {
            InvokeDynamicSupport.bootstrap("onRepeatingRequestError", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks$onRepeatingRequestError(long int ), 0, this, l, n);
        }

        @Override
        public void onDeviceIdle() {
            InvokeDynamicSupport.bootstrap("onDeviceIdle", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks$onDeviceIdle(), 0, this);
        }

        @Override
        public void onCaptureStarted(CaptureResultExtras captureResultExtras, long l) {
            InvokeDynamicSupport.bootstrap("onCaptureStarted", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks$onCaptureStarted(android.hardware.camera2.impl.CaptureResultExtras long ), 0, this, captureResultExtras, l);
        }

        @Override
        public void onResultReceived(CameraMetadataNative cameraMetadataNative, CaptureResultExtras captureResultExtras) throws RemoteException {
            InvokeDynamicSupport.bootstrap("onResultReceived", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks$onResultReceived(android.hardware.camera2.impl.CameraMetadataNative android.hardware.camera2.impl.CaptureResultExtras ), 0, this, cameraMetadataNative, captureResultExtras);
        }

        @Override
        public void onPrepared(int n) {
            InvokeDynamicSupport.bootstrap("onPrepared", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks$onPrepared(int ), 0, this, n);
        }

        @Override
        public void onRequestQueueEmpty() {
            InvokeDynamicSupport.bootstrap("onRequestQueueEmpty", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks$onRequestQueueEmpty(), 0, this);
        }

        private void onCaptureErrorLocked(int n, CaptureResultExtras captureResultExtras) {
            InvokeDynamicSupport.bootstrap("onCaptureErrorLocked", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CameraDeviceCallbacks$onCaptureErrorLocked(int android.hardware.camera2.impl.CaptureResultExtras ), 0, this, n, captureResultExtras);
        }

        public /* synthetic */ CameraDeviceCallbacks() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CameraDeviceCallbacks)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class FrameNumberTracker
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private long mCompletedFrameNumber;
        private long mCompletedReprocessFrameNumber;
        private LinkedList<Long> mSkippedRegularFrameNumbers;
        private LinkedList<Long> mSkippedReprocessFrameNumbers;
        private TreeMap<Long, Boolean> mFutureErrorMap;
        private HashMap<Long, List<CaptureResult>> mPartialResults;
        /* synthetic */ CameraDeviceImpl this$0;

        private void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_FrameNumberTracker$__constructor__(CameraDeviceImpl this$0) {
            this.mCompletedFrameNumber = -1L;
            this.mCompletedReprocessFrameNumber = -1L;
            this.mSkippedRegularFrameNumbers = new LinkedList();
            this.mSkippedReprocessFrameNumbers = new LinkedList();
            this.mFutureErrorMap = new TreeMap();
            this.mPartialResults = new HashMap();
        }

        private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_FrameNumberTracker$update() {
            Iterator<Map.Entry<Long, Boolean>> iter = this.mFutureErrorMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<Long, Boolean> pair = iter.next();
                Long errorFrameNumber = pair.getKey();
                Boolean reprocess = pair.getValue();
                Boolean removeError = true;
                if (reprocess.booleanValue()) {
                    if (errorFrameNumber == this.mCompletedReprocessFrameNumber + 1L) {
                        this.mCompletedReprocessFrameNumber = errorFrameNumber;
                    } else if (!this.mSkippedReprocessFrameNumbers.isEmpty() && errorFrameNumber == this.mSkippedReprocessFrameNumbers.element()) {
                        this.mCompletedReprocessFrameNumber = errorFrameNumber;
                        this.mSkippedReprocessFrameNumbers.remove();
                    } else {
                        removeError = false;
                    }
                } else if (errorFrameNumber == this.mCompletedFrameNumber + 1L) {
                    this.mCompletedFrameNumber = errorFrameNumber;
                } else if (!this.mSkippedRegularFrameNumbers.isEmpty() && errorFrameNumber == this.mSkippedRegularFrameNumbers.element()) {
                    this.mCompletedFrameNumber = errorFrameNumber;
                    this.mSkippedRegularFrameNumbers.remove();
                } else {
                    removeError = false;
                }
                if (!removeError.booleanValue()) continue;
                iter.remove();
            }
        }

        private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_FrameNumberTracker$updateTracker(long frameNumber, boolean isError, boolean isReprocess) {
            if (isError) {
                this.mFutureErrorMap.put(frameNumber, isReprocess);
            } else {
                try {
                    if (isReprocess) {
                        this.updateCompletedReprocessFrameNumber(frameNumber);
                    } else {
                        this.updateCompletedFrameNumber(frameNumber);
                    }
                }
                catch (IllegalArgumentException e) {
                    Log.e(this.this$0.TAG, e.getMessage());
                }
            }
            this.update();
        }

        private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_FrameNumberTracker$updateTracker(long frameNumber, CaptureResult result, boolean partial, boolean isReprocess) {
            if (!partial) {
                this.updateTracker(frameNumber, false, isReprocess);
                return;
            }
            if (result == null) {
                return;
            }
            List<CaptureResult> partials = this.mPartialResults.get(frameNumber);
            if (partials == null) {
                partials = new ArrayList<CaptureResult>();
                this.mPartialResults.put(frameNumber, partials);
            }
            partials.add(result);
        }

        private final List<CaptureResult> $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_FrameNumberTracker$popPartialResults(long frameNumber) {
            return this.mPartialResults.remove(frameNumber);
        }

        private final long $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_FrameNumberTracker$getCompletedFrameNumber() {
            return this.mCompletedFrameNumber;
        }

        private final long $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_FrameNumberTracker$getCompletedReprocessFrameNumber() {
            return this.mCompletedReprocessFrameNumber;
        }

        private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_FrameNumberTracker$updateCompletedFrameNumber(long frameNumber) throws IllegalArgumentException {
            if (frameNumber <= this.mCompletedFrameNumber) {
                throw new IllegalArgumentException("frame number " + frameNumber + " is a repeat");
            }
            if (frameNumber <= this.mCompletedReprocessFrameNumber) {
                if (this.mSkippedRegularFrameNumbers.isEmpty() || frameNumber < this.mSkippedRegularFrameNumbers.element()) {
                    throw new IllegalArgumentException("frame number " + frameNumber + " is a repeat");
                }
                if (frameNumber > this.mSkippedRegularFrameNumbers.element()) {
                    throw new IllegalArgumentException("frame number " + frameNumber + " comes out of order. Expecting " + this.mSkippedRegularFrameNumbers.element());
                }
                this.mSkippedRegularFrameNumbers.remove();
            } else {
                for (long i = Math.max(this.mCompletedFrameNumber, this.mCompletedReprocessFrameNumber) + 1L; i < frameNumber; ++i) {
                    this.mSkippedReprocessFrameNumbers.add(i);
                }
            }
            this.mCompletedFrameNumber = frameNumber;
        }

        private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_FrameNumberTracker$updateCompletedReprocessFrameNumber(long frameNumber) throws IllegalArgumentException {
            if (frameNumber < this.mCompletedReprocessFrameNumber) {
                throw new IllegalArgumentException("frame number " + frameNumber + " is a repeat");
            }
            if (frameNumber < this.mCompletedFrameNumber) {
                if (this.mSkippedReprocessFrameNumbers.isEmpty() || frameNumber < this.mSkippedReprocessFrameNumbers.element()) {
                    throw new IllegalArgumentException("frame number " + frameNumber + " is a repeat");
                }
                if (frameNumber > this.mSkippedReprocessFrameNumbers.element()) {
                    throw new IllegalArgumentException("frame number " + frameNumber + " comes out of order. Expecting " + this.mSkippedReprocessFrameNumbers.element());
                }
                this.mSkippedReprocessFrameNumbers.remove();
            } else {
                for (long i = Math.max(this.mCompletedFrameNumber, this.mCompletedReprocessFrameNumber) + 1L; i < frameNumber; ++i) {
                    this.mSkippedRegularFrameNumbers.add(i);
                }
            }
            this.mCompletedReprocessFrameNumber = frameNumber;
        }

        private void __constructor__(CameraDeviceImpl cameraDeviceImpl) {
            this.$$robo$$android_hardware_camera2_impl_CameraDeviceImpl_FrameNumberTracker$__constructor__(cameraDeviceImpl);
        }

        public FrameNumberTracker(CameraDeviceImpl cameraDeviceImpl) {
            this.this$0 = cameraDeviceImpl;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_FrameNumberTracker$__constructor__(android.hardware.camera2.impl.CameraDeviceImpl ), 0, this, cameraDeviceImpl);
        }

        private void update() {
            InvokeDynamicSupport.bootstrap("update", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_FrameNumberTracker$update(), 0, this);
        }

        public void updateTracker(long l, boolean bl, boolean bl2) {
            InvokeDynamicSupport.bootstrap("updateTracker", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_FrameNumberTracker$updateTracker(long boolean boolean ), 0, this, l, bl, bl2);
        }

        public void updateTracker(long l, CaptureResult captureResult, boolean bl, boolean bl2) {
            InvokeDynamicSupport.bootstrap("updateTracker", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_FrameNumberTracker$updateTracker(long android.hardware.camera2.CaptureResult boolean boolean ), 0, this, l, captureResult, bl, bl2);
        }

        public List<CaptureResult> popPartialResults(long l) {
            return InvokeDynamicSupport.bootstrap("popPartialResults", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_FrameNumberTracker$popPartialResults(long ), 0, this, l);
        }

        public long getCompletedFrameNumber() {
            return (long)InvokeDynamicSupport.bootstrap("getCompletedFrameNumber", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_FrameNumberTracker$getCompletedFrameNumber(), 0, this);
        }

        public long getCompletedReprocessFrameNumber() {
            return (long)InvokeDynamicSupport.bootstrap("getCompletedReprocessFrameNumber", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_FrameNumberTracker$getCompletedReprocessFrameNumber(), 0, this);
        }

        private void updateCompletedFrameNumber(long l) throws IllegalArgumentException {
            InvokeDynamicSupport.bootstrap("updateCompletedFrameNumber", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_FrameNumberTracker$updateCompletedFrameNumber(long ), 0, this, l);
        }

        private void updateCompletedReprocessFrameNumber(long l) throws IllegalArgumentException {
            InvokeDynamicSupport.bootstrap("updateCompletedReprocessFrameNumber", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_FrameNumberTracker$updateCompletedReprocessFrameNumber(long ), 0, this, l);
        }

        public /* synthetic */ FrameNumberTracker() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FrameNumberTracker)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class RequestLastFrameNumbersHolder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mRequestId;
        private long mLastRegularFrameNumber;
        private long mLastReprocessFrameNumber;

        private void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_RequestLastFrameNumbersHolder$__constructor__(List<CaptureRequest> requestList, SubmitInfo requestInfo) {
            long lastRegularFrameNumber = -1L;
            long lastReprocessFrameNumber = -1L;
            long frameNumber = requestInfo.getLastFrameNumber();
            if (requestInfo.getLastFrameNumber() < (long)(requestList.size() - 1)) {
                throw new IllegalArgumentException("lastFrameNumber: " + requestInfo.getLastFrameNumber() + " should be at least " + (requestList.size() - 1) + " for the number of " + " requests in the list: " + requestList.size());
            }
            for (int i = requestList.size() - 1; i >= 0; --i) {
                CaptureRequest request = requestList.get(i);
                if (request.isReprocess() && lastReprocessFrameNumber == -1L) {
                    lastReprocessFrameNumber = frameNumber;
                } else if (!request.isReprocess() && lastRegularFrameNumber == -1L) {
                    lastRegularFrameNumber = frameNumber;
                }
                if (lastReprocessFrameNumber != -1L && lastRegularFrameNumber != -1L) break;
                --frameNumber;
            }
            this.mLastRegularFrameNumber = lastRegularFrameNumber;
            this.mLastReprocessFrameNumber = lastReprocessFrameNumber;
            this.mRequestId = requestInfo.getRequestId();
        }

        private void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_RequestLastFrameNumbersHolder$__constructor__(int requestId, long lastRegularFrameNumber) {
            this.mLastRegularFrameNumber = lastRegularFrameNumber;
            this.mLastReprocessFrameNumber = -1L;
            this.mRequestId = requestId;
        }

        private final long $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_RequestLastFrameNumbersHolder$getLastRegularFrameNumber() {
            return this.mLastRegularFrameNumber;
        }

        private final long $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_RequestLastFrameNumbersHolder$getLastReprocessFrameNumber() {
            return this.mLastReprocessFrameNumber;
        }

        private final long $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_RequestLastFrameNumbersHolder$getLastFrameNumber() {
            return Math.max(this.mLastRegularFrameNumber, this.mLastReprocessFrameNumber);
        }

        private final int $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_RequestLastFrameNumbersHolder$getRequestId() {
            return this.mRequestId;
        }

        private void __constructor__(List<CaptureRequest> list, SubmitInfo submitInfo) {
            this.$$robo$$android_hardware_camera2_impl_CameraDeviceImpl_RequestLastFrameNumbersHolder$__constructor__(list, submitInfo);
        }

        public RequestLastFrameNumbersHolder(List<CaptureRequest> list, SubmitInfo submitInfo) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_RequestLastFrameNumbersHolder$__constructor__(java.util.List<android.hardware.camera2.CaptureRequest> android.hardware.camera2.utils.SubmitInfo ), 0, this, list, submitInfo);
        }

        private void __constructor__(int n, long l) {
            this.$$robo$$android_hardware_camera2_impl_CameraDeviceImpl_RequestLastFrameNumbersHolder$__constructor__(n, l);
        }

        public RequestLastFrameNumbersHolder(int n, long l) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_RequestLastFrameNumbersHolder$__constructor__(int long ), 0, this, n, l);
        }

        public long getLastRegularFrameNumber() {
            return (long)InvokeDynamicSupport.bootstrap("getLastRegularFrameNumber", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_RequestLastFrameNumbersHolder$getLastRegularFrameNumber(), 0, this);
        }

        public long getLastReprocessFrameNumber() {
            return (long)InvokeDynamicSupport.bootstrap("getLastReprocessFrameNumber", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_RequestLastFrameNumbersHolder$getLastReprocessFrameNumber(), 0, this);
        }

        public long getLastFrameNumber() {
            return (long)InvokeDynamicSupport.bootstrap("getLastFrameNumber", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_RequestLastFrameNumbersHolder$getLastFrameNumber(), 0, this);
        }

        public int getRequestId() {
            return (int)InvokeDynamicSupport.bootstrap("getRequestId", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_RequestLastFrameNumbersHolder$getRequestId(), 0, this);
        }

        public /* synthetic */ RequestLastFrameNumbersHolder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RequestLastFrameNumbersHolder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class CaptureCallbackHolder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private boolean mRepeating;
        private CaptureCallback mCallback;
        private List<CaptureRequest> mRequestList;
        private Handler mHandler;
        private int mSessionId;
        private boolean mHasBatchedOutputs;

        private void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CaptureCallbackHolder$__constructor__(CaptureCallback callback, List<CaptureRequest> requestList, Handler handler, boolean repeating, int sessionId) {
            if (callback == null || handler == null) {
                throw new UnsupportedOperationException("Must have a valid handler and a valid callback");
            }
            this.mRepeating = repeating;
            this.mHandler = handler;
            this.mRequestList = new ArrayList<CaptureRequest>(requestList);
            this.mCallback = callback;
            this.mSessionId = sessionId;
            boolean hasBatchedOutputs = true;
            for (int i = 0; i < requestList.size(); ++i) {
                Collection<Surface> targets;
                CaptureRequest request = requestList.get(i);
                if (!request.isPartOfCRequestList()) {
                    hasBatchedOutputs = false;
                    break;
                }
                if (i != 0 || (targets = request.getTargets()).size() == 2) continue;
                hasBatchedOutputs = false;
                break;
            }
            this.mHasBatchedOutputs = hasBatchedOutputs;
        }

        private final boolean $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CaptureCallbackHolder$isRepeating() {
            return this.mRepeating;
        }

        private final CaptureCallback $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CaptureCallbackHolder$getCallback() {
            return this.mCallback;
        }

        private final CaptureRequest $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CaptureCallbackHolder$getRequest(int subsequenceId) {
            if (subsequenceId >= this.mRequestList.size()) {
                throw new IllegalArgumentException(String.format("Requested subsequenceId %d is larger than request list size %d.", subsequenceId, this.mRequestList.size()));
            }
            if (subsequenceId < 0) {
                throw new IllegalArgumentException(String.format("Requested subsequenceId %d is negative", subsequenceId));
            }
            return this.mRequestList.get(subsequenceId);
        }

        private final CaptureRequest $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CaptureCallbackHolder$getRequest() {
            return this.getRequest(0);
        }

        private final Handler $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CaptureCallbackHolder$getHandler() {
            return this.mHandler;
        }

        private final int $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CaptureCallbackHolder$getSessionId() {
            return this.mSessionId;
        }

        private final int $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CaptureCallbackHolder$getRequestCount() {
            return this.mRequestList.size();
        }

        private final boolean $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CaptureCallbackHolder$hasBatchedOutputs() {
            return this.mHasBatchedOutputs;
        }

        private void __constructor__(CaptureCallback captureCallback, List<CaptureRequest> list, Handler handler, boolean bl, int n) {
            this.$$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CaptureCallbackHolder$__constructor__(captureCallback, list, handler, bl, n);
        }

        CaptureCallbackHolder(CaptureCallback captureCallback, List<CaptureRequest> list, Handler handler, boolean bl, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CaptureCallbackHolder$__constructor__(android.hardware.camera2.impl.CameraDeviceImpl$CaptureCallback java.util.List<android.hardware.camera2.CaptureRequest> android.os.Handler boolean int ), 0, this, captureCallback, list, handler, bl, n);
        }

        public boolean isRepeating() {
            return (boolean)InvokeDynamicSupport.bootstrap("isRepeating", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CaptureCallbackHolder$isRepeating(), 0, this);
        }

        public CaptureCallback getCallback() {
            return InvokeDynamicSupport.bootstrap("getCallback", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CaptureCallbackHolder$getCallback(), 0, this);
        }

        public CaptureRequest getRequest(int n) {
            return InvokeDynamicSupport.bootstrap("getRequest", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CaptureCallbackHolder$getRequest(int ), 0, this, n);
        }

        public CaptureRequest getRequest() {
            return InvokeDynamicSupport.bootstrap("getRequest", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CaptureCallbackHolder$getRequest(), 0, this);
        }

        public Handler getHandler() {
            return InvokeDynamicSupport.bootstrap("getHandler", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CaptureCallbackHolder$getHandler(), 0, this);
        }

        public int getSessionId() {
            return (int)InvokeDynamicSupport.bootstrap("getSessionId", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CaptureCallbackHolder$getSessionId(), 0, this);
        }

        public int getRequestCount() {
            return (int)InvokeDynamicSupport.bootstrap("getRequestCount", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CaptureCallbackHolder$getRequestCount(), 0, this);
        }

        public boolean hasBatchedOutputs() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasBatchedOutputs", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_CaptureCallbackHolder$hasBatchedOutputs(), 0, this);
        }

        public /* synthetic */ CaptureCallbackHolder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CaptureCallbackHolder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class StateCallbackKK
    extends CameraDevice.StateCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_StateCallbackKK$__constructor__() {
        }

        private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_StateCallbackKK$onUnconfigured(CameraDevice camera) {
        }

        private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_StateCallbackKK$onActive(CameraDevice camera) {
        }

        private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_StateCallbackKK$onBusy(CameraDevice camera) {
        }

        private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_StateCallbackKK$onIdle(CameraDevice camera) {
        }

        private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_StateCallbackKK$onRequestQueueEmpty() {
        }

        private final void $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_StateCallbackKK$onSurfacePrepared(Surface surface) {
        }

        private void __constructor__() {
            this.$$robo$$android_hardware_camera2_impl_CameraDeviceImpl_StateCallbackKK$__constructor__();
        }

        public StateCallbackKK() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_StateCallbackKK$__constructor__(), 0, this);
        }

        public void onUnconfigured(CameraDevice cameraDevice) {
            InvokeDynamicSupport.bootstrap("onUnconfigured", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_StateCallbackKK$onUnconfigured(android.hardware.camera2.CameraDevice ), 0, this, cameraDevice);
        }

        public void onActive(CameraDevice cameraDevice) {
            InvokeDynamicSupport.bootstrap("onActive", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_StateCallbackKK$onActive(android.hardware.camera2.CameraDevice ), 0, this, cameraDevice);
        }

        public void onBusy(CameraDevice cameraDevice) {
            InvokeDynamicSupport.bootstrap("onBusy", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_StateCallbackKK$onBusy(android.hardware.camera2.CameraDevice ), 0, this, cameraDevice);
        }

        public void onIdle(CameraDevice cameraDevice) {
            InvokeDynamicSupport.bootstrap("onIdle", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_StateCallbackKK$onIdle(android.hardware.camera2.CameraDevice ), 0, this, cameraDevice);
        }

        public void onRequestQueueEmpty() {
            InvokeDynamicSupport.bootstrap("onRequestQueueEmpty", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_StateCallbackKK$onRequestQueueEmpty(), 0, this);
        }

        public void onSurfacePrepared(Surface surface) {
            InvokeDynamicSupport.bootstrap("onSurfacePrepared", $$robo$$android_hardware_camera2_impl_CameraDeviceImpl_StateCallbackKK$onSurfacePrepared(android.view.Surface ), 0, this, surface);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StateCallbackKK)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface CaptureCallback
    extends InstrumentedInterface {
        public static final int NO_FRAMES_CAPTURED = -1;

        public void onCaptureStarted(CameraDevice var1, CaptureRequest var2, long var3, long var5);

        public void onCapturePartial(CameraDevice var1, CaptureRequest var2, CaptureResult var3);

        public void onCaptureProgressed(CameraDevice var1, CaptureRequest var2, CaptureResult var3);

        public void onCaptureCompleted(CameraDevice var1, CaptureRequest var2, TotalCaptureResult var3);

        public void onCaptureFailed(CameraDevice var1, CaptureRequest var2, CaptureFailure var3);

        public void onCaptureSequenceCompleted(CameraDevice var1, int var2, long var3);

        public void onCaptureSequenceAborted(CameraDevice var1, int var2);

        public void onCaptureBufferLost(CameraDevice var1, CaptureRequest var2, Surface var3, long var4);
    }
}

