/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.display;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.hardware.display.DisplayManager;
import android.hardware.display.IDisplayManager;
import android.hardware.display.IDisplayManagerCallback;
import android.hardware.display.IVirtualDisplayCallback;
import android.hardware.display.VirtualDisplay;
import android.hardware.display.WifiDisplayStatus;
import android.media.projection.IMediaProjection;
import android.media.projection.MediaProjection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseArray;
import android.view.Display;
import android.view.DisplayAdjustments;
import android.view.DisplayInfo;
import android.view.Surface;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class DisplayManagerGlobal
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "DisplayManager";
    private static boolean DEBUG = false;
    private static boolean USE_CACHE = false;
    public static int EVENT_DISPLAY_ADDED = 1;
    public static int EVENT_DISPLAY_CHANGED = 2;
    public static int EVENT_DISPLAY_REMOVED = 3;
    private static DisplayManagerGlobal sInstance;
    private Object mLock;
    private IDisplayManager mDm;
    private DisplayManagerCallback mCallback;
    private ArrayList<DisplayListenerDelegate> mDisplayListeners;
    private SparseArray<DisplayInfo> mDisplayInfoCache;
    private int[] mDisplayIdCache;
    private int mWifiDisplayScanNestCount;

    private void $$robo$$android_hardware_display_DisplayManagerGlobal$__constructor__(IDisplayManager dm) {
        this.mLock = new Object();
        this.mDisplayListeners = new ArrayList();
        this.mDisplayInfoCache = new SparseArray();
        this.mDm = dm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final DisplayManagerGlobal $$robo$$android_hardware_display_DisplayManagerGlobal$getInstance() {
        Class<DisplayManagerGlobal> clazz = DisplayManagerGlobal.class;
        synchronized (DisplayManagerGlobal.class) {
            IBinder b;
            if (sInstance == null && (b = ServiceManager.getService("display")) != null) {
                sInstance = new DisplayManagerGlobal(IDisplayManager.Stub.asInterface(b));
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DisplayInfo $$robo$$android_hardware_display_DisplayManagerGlobal$getDisplayInfo(int displayId) {
        try {
            Object object = this.mLock;
            synchronized (object) {
                DisplayInfo info = this.mDm.getDisplayInfo(displayId);
                if (info == null) {
                    return null;
                }
                this.registerCallbackIfNeededLocked();
                return info;
            }
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int[] $$robo$$android_hardware_display_DisplayManagerGlobal$getDisplayIds() {
        try {
            Object object = this.mLock;
            synchronized (object) {
                int[] displayIds = this.mDm.getDisplayIds();
                this.registerCallbackIfNeededLocked();
                return displayIds;
            }
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    private final Display $$robo$$android_hardware_display_DisplayManagerGlobal$getCompatibleDisplay(int displayId, DisplayAdjustments daj) {
        DisplayInfo displayInfo = this.getDisplayInfo(displayId);
        if (displayInfo == null) {
            return null;
        }
        return new Display(this, displayId, displayInfo, daj);
    }

    private final Display $$robo$$android_hardware_display_DisplayManagerGlobal$getCompatibleDisplay(int displayId, Resources resources) {
        DisplayInfo displayInfo = this.getDisplayInfo(displayId);
        if (displayInfo == null) {
            return null;
        }
        return new Display(this, displayId, displayInfo, resources);
    }

    private final Display $$robo$$android_hardware_display_DisplayManagerGlobal$getRealDisplay(int displayId) {
        return this.getCompatibleDisplay(displayId, DisplayAdjustments.DEFAULT_DISPLAY_ADJUSTMENTS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_display_DisplayManagerGlobal$registerDisplayListener(DisplayManager.DisplayListener listener, Handler handler) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            int index = this.findDisplayListenerLocked(listener);
            if (index < 0) {
                this.mDisplayListeners.add(new DisplayListenerDelegate(listener, handler));
                this.registerCallbackIfNeededLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_display_DisplayManagerGlobal$unregisterDisplayListener(DisplayManager.DisplayListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            int index = this.findDisplayListenerLocked(listener);
            if (index >= 0) {
                DisplayListenerDelegate d = this.mDisplayListeners.get(index);
                d.clearEvents();
                this.mDisplayListeners.remove(index);
            }
        }
    }

    private final int $$robo$$android_hardware_display_DisplayManagerGlobal$findDisplayListenerLocked(DisplayManager.DisplayListener listener) {
        int numListeners = this.mDisplayListeners.size();
        for (int i = 0; i < numListeners; ++i) {
            if (this.mDisplayListeners.get((int)i).mListener != listener) continue;
            return i;
        }
        return -1;
    }

    private final void $$robo$$android_hardware_display_DisplayManagerGlobal$registerCallbackIfNeededLocked() {
        if (this.mCallback == null) {
            this.mCallback = new DisplayManagerCallback(this);
            try {
                this.mDm.registerCallback(this.mCallback);
            }
            catch (RemoteException ex) {
                throw ex.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_display_DisplayManagerGlobal$handleDisplayEvent(int displayId, int event) {
        Object object = this.mLock;
        synchronized (object) {
            int numListeners = this.mDisplayListeners.size();
            for (int i = 0; i < numListeners; ++i) {
                this.mDisplayListeners.get(i).sendDisplayEvent(displayId, event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_display_DisplayManagerGlobal$startWifiDisplayScan() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mWifiDisplayScanNestCount++ == 0) {
                this.registerCallbackIfNeededLocked();
                try {
                    this.mDm.startWifiDisplayScan();
                }
                catch (RemoteException ex) {
                    throw ex.rethrowFromSystemServer();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_display_DisplayManagerGlobal$stopWifiDisplayScan() {
        Object object = this.mLock;
        synchronized (object) {
            if (--this.mWifiDisplayScanNestCount == 0) {
                try {
                    this.mDm.stopWifiDisplayScan();
                }
                catch (RemoteException ex) {
                    throw ex.rethrowFromSystemServer();
                }
            } else if (this.mWifiDisplayScanNestCount < 0) {
                Log.wtf("DisplayManager", "Wifi display scan nest count became negative: " + this.mWifiDisplayScanNestCount);
                this.mWifiDisplayScanNestCount = 0;
            }
        }
    }

    private final void $$robo$$android_hardware_display_DisplayManagerGlobal$connectWifiDisplay(String deviceAddress) {
        if (deviceAddress == null) {
            throw new IllegalArgumentException("deviceAddress must not be null");
        }
        try {
            this.mDm.connectWifiDisplay(deviceAddress);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_hardware_display_DisplayManagerGlobal$pauseWifiDisplay() {
        try {
            this.mDm.pauseWifiDisplay();
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_hardware_display_DisplayManagerGlobal$resumeWifiDisplay() {
        try {
            this.mDm.resumeWifiDisplay();
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_hardware_display_DisplayManagerGlobal$disconnectWifiDisplay() {
        try {
            this.mDm.disconnectWifiDisplay();
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_hardware_display_DisplayManagerGlobal$renameWifiDisplay(String deviceAddress, String alias) {
        if (deviceAddress == null) {
            throw new IllegalArgumentException("deviceAddress must not be null");
        }
        try {
            this.mDm.renameWifiDisplay(deviceAddress, alias);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_hardware_display_DisplayManagerGlobal$forgetWifiDisplay(String deviceAddress) {
        if (deviceAddress == null) {
            throw new IllegalArgumentException("deviceAddress must not be null");
        }
        try {
            this.mDm.forgetWifiDisplay(deviceAddress);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    private final WifiDisplayStatus $$robo$$android_hardware_display_DisplayManagerGlobal$getWifiDisplayStatus() {
        try {
            return this.mDm.getWifiDisplayStatus();
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_hardware_display_DisplayManagerGlobal$requestColorMode(int displayId, int colorMode) {
        try {
            this.mDm.requestColorMode(displayId, colorMode);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    private final VirtualDisplay $$robo$$android_hardware_display_DisplayManagerGlobal$createVirtualDisplay(Context context, MediaProjection projection, String name, int width, int height, int densityDpi, Surface surface, int flags, VirtualDisplay.Callback callback, Handler handler, String uniqueId) {
        int displayId;
        if (TextUtils.isEmpty(name)) {
            throw new IllegalArgumentException("name must be non-null and non-empty");
        }
        if (width <= 0 || height <= 0 || densityDpi <= 0) {
            throw new IllegalArgumentException("width, height, and densityDpi must be greater than 0");
        }
        VirtualDisplayCallback callbackWrapper = new VirtualDisplayCallback(callback, handler);
        IMediaProjection projectionToken = projection != null ? projection.getProjection() : null;
        try {
            displayId = this.mDm.createVirtualDisplay(callbackWrapper, projectionToken, context.getPackageName(), name, width, height, densityDpi, surface, flags, uniqueId);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
        if (displayId < 0) {
            Log.e("DisplayManager", "Could not create virtual display: " + name);
            return null;
        }
        Display display = this.getRealDisplay(displayId);
        if (display == null) {
            Log.wtf("DisplayManager", "Could not obtain display info for newly created virtual display: " + name);
            try {
                this.mDm.releaseVirtualDisplay(callbackWrapper);
            }
            catch (RemoteException ex) {
                throw ex.rethrowFromSystemServer();
            }
            return null;
        }
        return new VirtualDisplay(this, display, callbackWrapper, surface);
    }

    private final void $$robo$$android_hardware_display_DisplayManagerGlobal$setVirtualDisplaySurface(IVirtualDisplayCallback token, Surface surface) {
        try {
            this.mDm.setVirtualDisplaySurface(token, surface);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_hardware_display_DisplayManagerGlobal$resizeVirtualDisplay(IVirtualDisplayCallback token, int width, int height, int densityDpi) {
        try {
            this.mDm.resizeVirtualDisplay(token, width, height, densityDpi);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_hardware_display_DisplayManagerGlobal$releaseVirtualDisplay(IVirtualDisplayCallback token) {
        try {
            this.mDm.releaseVirtualDisplay(token);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    private final Point $$robo$$android_hardware_display_DisplayManagerGlobal$getStableDisplaySize() {
        try {
            return this.mDm.getStableDisplaySize();
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    private void __constructor__(IDisplayManager iDisplayManager) {
        this.$$robo$$android_hardware_display_DisplayManagerGlobal$__constructor__(iDisplayManager);
    }

    private DisplayManagerGlobal(IDisplayManager iDisplayManager) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_display_DisplayManagerGlobal$__constructor__(android.hardware.display.IDisplayManager ), 0, this, iDisplayManager);
    }

    public static DisplayManagerGlobal getInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_hardware_display_DisplayManagerGlobal$getInstance(), 0);
    }

    public DisplayInfo getDisplayInfo(int n) {
        return InvokeDynamicSupport.bootstrap("getDisplayInfo", $$robo$$android_hardware_display_DisplayManagerGlobal$getDisplayInfo(int ), 0, this, n);
    }

    public int[] getDisplayIds() {
        return InvokeDynamicSupport.bootstrap("getDisplayIds", $$robo$$android_hardware_display_DisplayManagerGlobal$getDisplayIds(), 0, this);
    }

    public Display getCompatibleDisplay(int n, DisplayAdjustments displayAdjustments) {
        return InvokeDynamicSupport.bootstrap("getCompatibleDisplay", $$robo$$android_hardware_display_DisplayManagerGlobal$getCompatibleDisplay(int android.view.DisplayAdjustments ), 0, this, n, displayAdjustments);
    }

    public Display getCompatibleDisplay(int n, Resources resources) {
        return InvokeDynamicSupport.bootstrap("getCompatibleDisplay", $$robo$$android_hardware_display_DisplayManagerGlobal$getCompatibleDisplay(int android.content.res.Resources ), 0, this, n, resources);
    }

    public Display getRealDisplay(int n) {
        return InvokeDynamicSupport.bootstrap("getRealDisplay", $$robo$$android_hardware_display_DisplayManagerGlobal$getRealDisplay(int ), 0, this, n);
    }

    public void registerDisplayListener(DisplayManager.DisplayListener displayListener, Handler handler) {
        InvokeDynamicSupport.bootstrap("registerDisplayListener", $$robo$$android_hardware_display_DisplayManagerGlobal$registerDisplayListener(android.hardware.display.DisplayManager$DisplayListener android.os.Handler ), 0, this, displayListener, handler);
    }

    public void unregisterDisplayListener(DisplayManager.DisplayListener displayListener) {
        InvokeDynamicSupport.bootstrap("unregisterDisplayListener", $$robo$$android_hardware_display_DisplayManagerGlobal$unregisterDisplayListener(android.hardware.display.DisplayManager$DisplayListener ), 0, this, displayListener);
    }

    private int findDisplayListenerLocked(DisplayManager.DisplayListener displayListener) {
        return (int)InvokeDynamicSupport.bootstrap("findDisplayListenerLocked", $$robo$$android_hardware_display_DisplayManagerGlobal$findDisplayListenerLocked(android.hardware.display.DisplayManager$DisplayListener ), 0, this, displayListener);
    }

    private void registerCallbackIfNeededLocked() {
        InvokeDynamicSupport.bootstrap("registerCallbackIfNeededLocked", $$robo$$android_hardware_display_DisplayManagerGlobal$registerCallbackIfNeededLocked(), 0, this);
    }

    private void handleDisplayEvent(int n, int n2) {
        InvokeDynamicSupport.bootstrap("handleDisplayEvent", $$robo$$android_hardware_display_DisplayManagerGlobal$handleDisplayEvent(int int ), 0, this, n, n2);
    }

    public void startWifiDisplayScan() {
        InvokeDynamicSupport.bootstrap("startWifiDisplayScan", $$robo$$android_hardware_display_DisplayManagerGlobal$startWifiDisplayScan(), 0, this);
    }

    public void stopWifiDisplayScan() {
        InvokeDynamicSupport.bootstrap("stopWifiDisplayScan", $$robo$$android_hardware_display_DisplayManagerGlobal$stopWifiDisplayScan(), 0, this);
    }

    public void connectWifiDisplay(String string2) {
        InvokeDynamicSupport.bootstrap("connectWifiDisplay", $$robo$$android_hardware_display_DisplayManagerGlobal$connectWifiDisplay(java.lang.String ), 0, this, string2);
    }

    public void pauseWifiDisplay() {
        InvokeDynamicSupport.bootstrap("pauseWifiDisplay", $$robo$$android_hardware_display_DisplayManagerGlobal$pauseWifiDisplay(), 0, this);
    }

    public void resumeWifiDisplay() {
        InvokeDynamicSupport.bootstrap("resumeWifiDisplay", $$robo$$android_hardware_display_DisplayManagerGlobal$resumeWifiDisplay(), 0, this);
    }

    public void disconnectWifiDisplay() {
        InvokeDynamicSupport.bootstrap("disconnectWifiDisplay", $$robo$$android_hardware_display_DisplayManagerGlobal$disconnectWifiDisplay(), 0, this);
    }

    public void renameWifiDisplay(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("renameWifiDisplay", $$robo$$android_hardware_display_DisplayManagerGlobal$renameWifiDisplay(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public void forgetWifiDisplay(String string2) {
        InvokeDynamicSupport.bootstrap("forgetWifiDisplay", $$robo$$android_hardware_display_DisplayManagerGlobal$forgetWifiDisplay(java.lang.String ), 0, this, string2);
    }

    public WifiDisplayStatus getWifiDisplayStatus() {
        return InvokeDynamicSupport.bootstrap("getWifiDisplayStatus", $$robo$$android_hardware_display_DisplayManagerGlobal$getWifiDisplayStatus(), 0, this);
    }

    public void requestColorMode(int n, int n2) {
        InvokeDynamicSupport.bootstrap("requestColorMode", $$robo$$android_hardware_display_DisplayManagerGlobal$requestColorMode(int int ), 0, this, n, n2);
    }

    public VirtualDisplay createVirtualDisplay(Context context, MediaProjection mediaProjection, String string2, int n, int n2, int n3, Surface surface, int n4, VirtualDisplay.Callback callback, Handler handler, String string3) {
        return InvokeDynamicSupport.bootstrap("createVirtualDisplay", $$robo$$android_hardware_display_DisplayManagerGlobal$createVirtualDisplay(android.content.Context android.media.projection.MediaProjection java.lang.String int int int android.view.Surface int android.hardware.display.VirtualDisplay$Callback android.os.Handler java.lang.String ), 0, this, context, mediaProjection, string2, n, n2, n3, surface, n4, callback, handler, string3);
    }

    public void setVirtualDisplaySurface(IVirtualDisplayCallback iVirtualDisplayCallback, Surface surface) {
        InvokeDynamicSupport.bootstrap("setVirtualDisplaySurface", $$robo$$android_hardware_display_DisplayManagerGlobal$setVirtualDisplaySurface(android.hardware.display.IVirtualDisplayCallback android.view.Surface ), 0, this, iVirtualDisplayCallback, surface);
    }

    public void resizeVirtualDisplay(IVirtualDisplayCallback iVirtualDisplayCallback, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("resizeVirtualDisplay", $$robo$$android_hardware_display_DisplayManagerGlobal$resizeVirtualDisplay(android.hardware.display.IVirtualDisplayCallback int int int ), 0, this, iVirtualDisplayCallback, n, n2, n3);
    }

    public void releaseVirtualDisplay(IVirtualDisplayCallback iVirtualDisplayCallback) {
        InvokeDynamicSupport.bootstrap("releaseVirtualDisplay", $$robo$$android_hardware_display_DisplayManagerGlobal$releaseVirtualDisplay(android.hardware.display.IVirtualDisplayCallback ), 0, this, iVirtualDisplayCallback);
    }

    public Point getStableDisplaySize() {
        return InvokeDynamicSupport.bootstrap("getStableDisplaySize", $$robo$$android_hardware_display_DisplayManagerGlobal$getStableDisplaySize(), 0, this);
    }

    public /* synthetic */ DisplayManagerGlobal() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DisplayManagerGlobal)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class VirtualDisplayCallbackDelegate
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int MSG_DISPLAY_PAUSED = 0;
        public static int MSG_DISPLAY_RESUMED = 1;
        public static int MSG_DISPLAY_STOPPED = 2;
        private VirtualDisplay.Callback mCallback;

        private void $$robo$$android_hardware_display_DisplayManagerGlobal_VirtualDisplayCallbackDelegate$__constructor__(VirtualDisplay.Callback callback, Handler handler) {
            this.mCallback = callback;
        }

        private final void $$robo$$android_hardware_display_DisplayManagerGlobal_VirtualDisplayCallbackDelegate$handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    this.mCallback.onPaused();
                    break;
                }
                case 1: {
                    this.mCallback.onResumed();
                    break;
                }
                case 2: {
                    this.mCallback.onStopped();
                }
            }
        }

        private void __constructor__(VirtualDisplay.Callback callback, Handler handler) {
            this.$$robo$$android_hardware_display_DisplayManagerGlobal_VirtualDisplayCallbackDelegate$__constructor__(callback, handler);
        }

        public VirtualDisplayCallbackDelegate(VirtualDisplay.Callback callback, Handler handler) {
            super(handler != null ? handler.getLooper() : Looper.myLooper(), null, true);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_display_DisplayManagerGlobal_VirtualDisplayCallbackDelegate$__constructor__(android.hardware.display.VirtualDisplay$Callback android.os.Handler ), 0, this, callback, handler);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_hardware_display_DisplayManagerGlobal_VirtualDisplayCallbackDelegate$handleMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ VirtualDisplayCallbackDelegate() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VirtualDisplayCallbackDelegate)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class VirtualDisplayCallback
    extends IVirtualDisplayCallback.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private VirtualDisplayCallbackDelegate mDelegate;

        private void $$robo$$android_hardware_display_DisplayManagerGlobal_VirtualDisplayCallback$__constructor__(VirtualDisplay.Callback callback, Handler handler) {
            if (callback != null) {
                this.mDelegate = new VirtualDisplayCallbackDelegate(callback, handler);
            }
        }

        private final void $$robo$$android_hardware_display_DisplayManagerGlobal_VirtualDisplayCallback$onPaused() {
            if (this.mDelegate != null) {
                this.mDelegate.sendEmptyMessage(0);
            }
        }

        private final void $$robo$$android_hardware_display_DisplayManagerGlobal_VirtualDisplayCallback$onResumed() {
            if (this.mDelegate != null) {
                this.mDelegate.sendEmptyMessage(1);
            }
        }

        private final void $$robo$$android_hardware_display_DisplayManagerGlobal_VirtualDisplayCallback$onStopped() {
            if (this.mDelegate != null) {
                this.mDelegate.sendEmptyMessage(2);
            }
        }

        private void __constructor__(VirtualDisplay.Callback callback, Handler handler) {
            this.$$robo$$android_hardware_display_DisplayManagerGlobal_VirtualDisplayCallback$__constructor__(callback, handler);
        }

        public VirtualDisplayCallback(VirtualDisplay.Callback callback, Handler handler) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_display_DisplayManagerGlobal_VirtualDisplayCallback$__constructor__(android.hardware.display.VirtualDisplay$Callback android.os.Handler ), 0, this, callback, handler);
        }

        @Override
        public void onPaused() {
            InvokeDynamicSupport.bootstrap("onPaused", $$robo$$android_hardware_display_DisplayManagerGlobal_VirtualDisplayCallback$onPaused(), 0, this);
        }

        @Override
        public void onResumed() {
            InvokeDynamicSupport.bootstrap("onResumed", $$robo$$android_hardware_display_DisplayManagerGlobal_VirtualDisplayCallback$onResumed(), 0, this);
        }

        @Override
        public void onStopped() {
            InvokeDynamicSupport.bootstrap("onStopped", $$robo$$android_hardware_display_DisplayManagerGlobal_VirtualDisplayCallback$onStopped(), 0, this);
        }

        public /* synthetic */ VirtualDisplayCallback() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VirtualDisplayCallback)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class DisplayListenerDelegate
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public DisplayManager.DisplayListener mListener;

        private void $$robo$$android_hardware_display_DisplayManagerGlobal_DisplayListenerDelegate$__constructor__(DisplayManager.DisplayListener listener, Handler handler) {
            this.mListener = listener;
        }

        private final void $$robo$$android_hardware_display_DisplayManagerGlobal_DisplayListenerDelegate$sendDisplayEvent(int displayId, int event) {
            Message msg = this.obtainMessage(event, displayId, 0);
            this.sendMessage(msg);
        }

        private final void $$robo$$android_hardware_display_DisplayManagerGlobal_DisplayListenerDelegate$clearEvents() {
            this.removeCallbacksAndMessages(null);
        }

        private final void $$robo$$android_hardware_display_DisplayManagerGlobal_DisplayListenerDelegate$handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    this.mListener.onDisplayAdded(msg.arg1);
                    break;
                }
                case 2: {
                    this.mListener.onDisplayChanged(msg.arg1);
                    break;
                }
                case 3: {
                    this.mListener.onDisplayRemoved(msg.arg1);
                }
            }
        }

        private void __constructor__(DisplayManager.DisplayListener displayListener, Handler handler) {
            this.$$robo$$android_hardware_display_DisplayManagerGlobal_DisplayListenerDelegate$__constructor__(displayListener, handler);
        }

        public DisplayListenerDelegate(DisplayManager.DisplayListener displayListener, Handler handler) {
            super(handler != null ? handler.getLooper() : Looper.myLooper(), null, true);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_display_DisplayManagerGlobal_DisplayListenerDelegate$__constructor__(android.hardware.display.DisplayManager$DisplayListener android.os.Handler ), 0, this, displayListener, handler);
        }

        public void sendDisplayEvent(int n, int n2) {
            InvokeDynamicSupport.bootstrap("sendDisplayEvent", $$robo$$android_hardware_display_DisplayManagerGlobal_DisplayListenerDelegate$sendDisplayEvent(int int ), 0, this, n, n2);
        }

        public void clearEvents() {
            InvokeDynamicSupport.bootstrap("clearEvents", $$robo$$android_hardware_display_DisplayManagerGlobal_DisplayListenerDelegate$clearEvents(), 0, this);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_hardware_display_DisplayManagerGlobal_DisplayListenerDelegate$handleMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ DisplayListenerDelegate() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DisplayListenerDelegate)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private final class DisplayManagerCallback
    extends IDisplayManagerCallback.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ DisplayManagerGlobal this$0;

        private void $$robo$$android_hardware_display_DisplayManagerGlobal_DisplayManagerCallback$__constructor__(DisplayManagerGlobal displayManagerGlobal) {
        }

        private final void $$robo$$android_hardware_display_DisplayManagerGlobal_DisplayManagerCallback$onDisplayEvent(int displayId, int event) {
            this.this$0.handleDisplayEvent(displayId, event);
        }

        private /* synthetic */ void $$robo$$android_hardware_display_DisplayManagerGlobal_DisplayManagerCallback$__constructor__(DisplayManagerGlobal x0, 1 x1) {
        }

        private void __constructor__(DisplayManagerGlobal displayManagerGlobal) {
            this.$$robo$$android_hardware_display_DisplayManagerGlobal_DisplayManagerCallback$__constructor__(displayManagerGlobal);
        }

        private DisplayManagerCallback(DisplayManagerGlobal displayManagerGlobal) {
            this.this$0 = displayManagerGlobal;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_display_DisplayManagerGlobal_DisplayManagerCallback$__constructor__(android.hardware.display.DisplayManagerGlobal ), 0, this, displayManagerGlobal);
        }

        @Override
        public void onDisplayEvent(int n, int n2) {
            InvokeDynamicSupport.bootstrap("onDisplayEvent", $$robo$$android_hardware_display_DisplayManagerGlobal_DisplayManagerCallback$onDisplayEvent(int int ), 0, this, n, n2);
        }

        private /* synthetic */ void __constructor__(DisplayManagerGlobal displayManagerGlobal, 1 var2_2) {
            this.$$robo$$android_hardware_display_DisplayManagerGlobal_DisplayManagerCallback$__constructor__(displayManagerGlobal, var2_2);
        }

        public /* synthetic */ DisplayManagerCallback() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DisplayManagerCallback)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

