/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.fingerprint;

import android.app.ActivityManager;
import android.content.Context;
import android.hardware.fingerprint.Fingerprint;
import android.hardware.fingerprint.IFingerprintService;
import android.hardware.fingerprint.IFingerprintServiceLockoutResetCallback;
import android.hardware.fingerprint.IFingerprintServiceReceiver;
import android.os.Binder;
import android.os.CancellationSignal;
import android.os.Handler;
import android.os.IBinder;
import android.os.IRemoteCallback;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.UserHandle;
import android.security.keystore.AndroidKeyStoreProvider;
import android.util.Log;
import android.util.Slog;
import com.google.errorprone.annotations.DoNotMock;
import java.security.Signature;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class FingerprintManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "FingerprintManager";
    private static boolean DEBUG = true;
    private static int MSG_ENROLL_RESULT = 100;
    private static int MSG_ACQUIRED = 101;
    private static int MSG_AUTHENTICATION_SUCCEEDED = 102;
    private static int MSG_AUTHENTICATION_FAILED = 103;
    private static int MSG_ERROR = 104;
    private static int MSG_REMOVED = 105;
    private static int MSG_ENUMERATED = 106;
    public static int FINGERPRINT_ERROR_HW_UNAVAILABLE = 1;
    public static int FINGERPRINT_ERROR_UNABLE_TO_PROCESS = 2;
    public static int FINGERPRINT_ERROR_TIMEOUT = 3;
    public static int FINGERPRINT_ERROR_NO_SPACE = 4;
    public static int FINGERPRINT_ERROR_CANCELED = 5;
    public static int FINGERPRINT_ERROR_UNABLE_TO_REMOVE = 6;
    public static int FINGERPRINT_ERROR_LOCKOUT = 7;
    public static int FINGERPRINT_ERROR_VENDOR = 8;
    public static int FINGERPRINT_ERROR_LOCKOUT_PERMANENT = 9;
    public static int FINGERPRINT_ERROR_USER_CANCELED = 10;
    public static int FINGERPRINT_ERROR_VENDOR_BASE = 1000;
    public static int FINGERPRINT_ACQUIRED_GOOD = 0;
    public static int FINGERPRINT_ACQUIRED_PARTIAL = 1;
    public static int FINGERPRINT_ACQUIRED_INSUFFICIENT = 2;
    public static int FINGERPRINT_ACQUIRED_IMAGER_DIRTY = 3;
    public static int FINGERPRINT_ACQUIRED_TOO_SLOW = 4;
    public static int FINGERPRINT_ACQUIRED_TOO_FAST = 5;
    public static int FINGERPRINT_ACQUIRED_VENDOR = 6;
    public static int FINGERPRINT_ACQUIRED_VENDOR_BASE = 1000;
    private IFingerprintService mService;
    private Context mContext;
    private IBinder mToken;
    private AuthenticationCallback mAuthenticationCallback;
    private EnrollmentCallback mEnrollmentCallback;
    private RemovalCallback mRemovalCallback;
    private EnumerateCallback mEnumerateCallback;
    private CryptoObject mCryptoObject;
    private Fingerprint mRemovalFingerprint;
    private Handler mHandler;
    private IFingerprintServiceReceiver mServiceReceiver;

    private final void $$robo$$android_hardware_fingerprint_FingerprintManager$authenticate(CryptoObject crypto, CancellationSignal cancel, int flags, AuthenticationCallback callback, Handler handler) {
        this.authenticate(crypto, cancel, flags, callback, handler, UserHandle.myUserId());
    }

    private final void $$robo$$android_hardware_fingerprint_FingerprintManager$useHandler(Handler handler) {
        if (handler != null) {
            this.mHandler = new MyHandler(this, handler.getLooper());
        } else if (this.mHandler.getLooper() != this.mContext.getMainLooper()) {
            this.mHandler = new MyHandler(this, this.mContext.getMainLooper());
        }
    }

    private final void $$robo$$android_hardware_fingerprint_FingerprintManager$authenticate(CryptoObject crypto, CancellationSignal cancel, int flags, AuthenticationCallback callback, Handler handler, int userId) {
        block6: {
            if (callback == null) {
                throw new IllegalArgumentException("Must supply an authentication callback");
            }
            if (cancel != null) {
                if (cancel.isCanceled()) {
                    Log.w("FingerprintManager", "authentication already canceled");
                    return;
                }
                cancel.setOnCancelListener(new OnAuthenticationCancelListener(this, crypto));
            }
            if (this.mService != null) {
                try {
                    this.useHandler(handler);
                    this.mAuthenticationCallback = callback;
                    this.mCryptoObject = crypto;
                    long sessionId = crypto != null ? crypto.getOpId() : 0L;
                    this.mService.authenticate(this.mToken, sessionId, userId, this.mServiceReceiver, flags, this.mContext.getOpPackageName());
                }
                catch (RemoteException e) {
                    Log.w("FingerprintManager", "Remote exception while authenticating: ", e);
                    if (callback == null) break block6;
                    callback.onAuthenticationError(1, this.getErrorString(1, 0));
                }
            }
        }
    }

    private final void $$robo$$android_hardware_fingerprint_FingerprintManager$enroll(byte[] token, CancellationSignal cancel, int flags, int userId, EnrollmentCallback callback) {
        block7: {
            if (userId == -2) {
                userId = this.getCurrentUserId();
            }
            if (callback == null) {
                throw new IllegalArgumentException("Must supply an enrollment callback");
            }
            if (cancel != null) {
                if (cancel.isCanceled()) {
                    Log.w("FingerprintManager", "enrollment already canceled");
                    return;
                }
                cancel.setOnCancelListener(new OnEnrollCancelListener(this));
            }
            if (this.mService != null) {
                try {
                    this.mEnrollmentCallback = callback;
                    this.mService.enroll(this.mToken, token, userId, this.mServiceReceiver, flags, this.mContext.getOpPackageName());
                }
                catch (RemoteException e) {
                    Log.w("FingerprintManager", "Remote exception in enroll: ", e);
                    if (callback == null) break block7;
                    callback.onEnrollmentError(1, this.getErrorString(1, 0));
                }
            }
        }
    }

    private final long $$robo$$android_hardware_fingerprint_FingerprintManager$preEnroll() {
        long result = 0L;
        if (this.mService != null) {
            try {
                result = this.mService.preEnroll(this.mToken);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return result;
    }

    private final int $$robo$$android_hardware_fingerprint_FingerprintManager$postEnroll() {
        int result = 0;
        if (this.mService != null) {
            try {
                result = this.mService.postEnroll(this.mToken);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return result;
    }

    private final void $$robo$$android_hardware_fingerprint_FingerprintManager$setActiveUser(int userId) {
        if (this.mService != null) {
            try {
                this.mService.setActiveUser(userId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final void $$robo$$android_hardware_fingerprint_FingerprintManager$remove(Fingerprint fp, int userId, RemovalCallback callback) {
        block3: {
            if (this.mService != null) {
                try {
                    this.mRemovalCallback = callback;
                    this.mRemovalFingerprint = fp;
                    this.mService.remove(this.mToken, fp.getFingerId(), fp.getGroupId(), userId, this.mServiceReceiver);
                }
                catch (RemoteException e) {
                    Log.w("FingerprintManager", "Remote exception in remove: ", e);
                    if (callback == null) break block3;
                    callback.onRemovalError(fp, 1, this.getErrorString(1, 0));
                }
            }
        }
    }

    private final void $$robo$$android_hardware_fingerprint_FingerprintManager$enumerate(int userId, EnumerateCallback callback) {
        block3: {
            if (this.mService != null) {
                try {
                    this.mEnumerateCallback = callback;
                    this.mService.enumerate(this.mToken, userId, this.mServiceReceiver);
                }
                catch (RemoteException e) {
                    Log.w("FingerprintManager", "Remote exception in enumerate: ", e);
                    if (callback == null) break block3;
                    callback.onEnumerateError(1, this.getErrorString(1, 0));
                }
            }
        }
    }

    private final void $$robo$$android_hardware_fingerprint_FingerprintManager$rename(int fpId, int userId, String newName) {
        if (this.mService != null) {
            try {
                this.mService.rename(fpId, userId, newName);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        } else {
            Log.w("FingerprintManager", "rename(): Service not connected!");
        }
    }

    private final List<Fingerprint> $$robo$$android_hardware_fingerprint_FingerprintManager$getEnrolledFingerprints(int userId) {
        if (this.mService != null) {
            try {
                return this.mService.getEnrolledFingerprints(userId, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    private final List<Fingerprint> $$robo$$android_hardware_fingerprint_FingerprintManager$getEnrolledFingerprints() {
        return this.getEnrolledFingerprints(UserHandle.myUserId());
    }

    private final boolean $$robo$$android_hardware_fingerprint_FingerprintManager$hasEnrolledFingerprints() {
        if (this.mService != null) {
            try {
                return this.mService.hasEnrolledFingerprints(UserHandle.myUserId(), this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    private final boolean $$robo$$android_hardware_fingerprint_FingerprintManager$hasEnrolledFingerprints(int userId) {
        if (this.mService != null) {
            try {
                return this.mService.hasEnrolledFingerprints(userId, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    private final boolean $$robo$$android_hardware_fingerprint_FingerprintManager$isHardwareDetected() {
        if (this.mService != null) {
            try {
                long deviceId = 0L;
                return this.mService.isHardwareDetected(deviceId, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        Log.w("FingerprintManager", "isFingerprintHardwareDetected(): Service not connected!");
        return false;
    }

    private final long $$robo$$android_hardware_fingerprint_FingerprintManager$getAuthenticatorId() {
        if (this.mService != null) {
            try {
                return this.mService.getAuthenticatorId(this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        Log.w("FingerprintManager", "getAuthenticatorId(): Service not connected!");
        return 0L;
    }

    private final void $$robo$$android_hardware_fingerprint_FingerprintManager$resetTimeout(byte[] token) {
        if (this.mService != null) {
            try {
                this.mService.resetTimeout(token);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        } else {
            Log.w("FingerprintManager", "resetTimeout(): Service not connected!");
        }
    }

    private final void $$robo$$android_hardware_fingerprint_FingerprintManager$addLockoutResetCallback(LockoutResetCallback callback) {
        if (this.mService != null) {
            try {
                PowerManager powerManager = this.mContext.getSystemService(PowerManager.class);
                this.mService.addLockoutResetCallback((IFingerprintServiceLockoutResetCallback)new ShadowedObject(this, powerManager, callback){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ PowerManager val$powerManager;
                    /* synthetic */ LockoutResetCallback val$callback;
                    /* synthetic */ FingerprintManager this$0;

                    private void $$robo$$android_hardware_fingerprint_FingerprintManager_1$__constructor__(FingerprintManager this$0, PowerManager powerManager, LockoutResetCallback lockoutResetCallback) {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    private final void $$robo$$android_hardware_fingerprint_FingerprintManager_1$onLockoutReset(long deviceId, IRemoteCallback serverCallback) throws RemoteException {
                        try {
                            PowerManager.WakeLock wakeLock = this.val$powerManager.newWakeLock(1, "lockoutResetCallback");
                            wakeLock.acquire();
                            this.this$0.mHandler.post(() -> {
                                try {
                                    this.val$callback.onLockoutReset();
                                }
                                finally {
                                    wakeLock.release();
                                }
                            });
                        }
                        finally {
                            serverCallback.sendResult(null);
                        }
                    }

                    private void __constructor__(FingerprintManager fingerprintManager, PowerManager powerManager, LockoutResetCallback lockoutResetCallback) {
                        this.$$robo$$android_hardware_fingerprint_FingerprintManager_1$__constructor__(fingerprintManager, powerManager, lockoutResetCallback);
                    }
                    {
                        this.this$0 = fingerprintManager;
                        this.val$powerManager = powerManager;
                        this.val$callback = lockoutResetCallback;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_fingerprint_FingerprintManager_1$__constructor__(android.hardware.fingerprint.FingerprintManager android.os.PowerManager android.hardware.fingerprint.FingerprintManager$LockoutResetCallback ), 0, this, fingerprintManager, powerManager, lockoutResetCallback);
                    }

                    @Override
                    public void onLockoutReset(long l, IRemoteCallback iRemoteCallback) throws RemoteException {
                        InvokeDynamicSupport.bootstrap("onLockoutReset", $$robo$$android_hardware_fingerprint_FingerprintManager_1$onLockoutReset(long android.os.IRemoteCallback ), 0, this, l, iRemoteCallback);
                    }
                    {
                        this.$$robo$init();
                    }

                    @Override
                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    @Override
                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        } else {
            Log.w("FingerprintManager", "addLockoutResetCallback(): Service not connected!");
        }
    }

    private void $$robo$$android_hardware_fingerprint_FingerprintManager$__constructor__(Context context, IFingerprintService service) {
        this.mToken = new Binder();
        this.mServiceReceiver = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ FingerprintManager this$0;

            private void $$robo$$android_hardware_fingerprint_FingerprintManager_2$__constructor__(FingerprintManager this$0) {
            }

            private final void $$robo$$android_hardware_fingerprint_FingerprintManager_2$onEnrollResult(long deviceId, int fingerId, int groupId, int remaining) {
                this.this$0.mHandler.obtainMessage(100, remaining, 0, new Fingerprint(null, groupId, fingerId, deviceId)).sendToTarget();
            }

            private final void $$robo$$android_hardware_fingerprint_FingerprintManager_2$onAcquired(long deviceId, int acquireInfo, int vendorCode) {
                this.this$0.mHandler.obtainMessage(101, acquireInfo, vendorCode, deviceId).sendToTarget();
            }

            private final void $$robo$$android_hardware_fingerprint_FingerprintManager_2$onAuthenticationSucceeded(long deviceId, Fingerprint fp, int userId) {
                this.this$0.mHandler.obtainMessage(102, userId, 0, fp).sendToTarget();
            }

            private final void $$robo$$android_hardware_fingerprint_FingerprintManager_2$onAuthenticationFailed(long deviceId) {
                this.this$0.mHandler.obtainMessage(103).sendToTarget();
            }

            private final void $$robo$$android_hardware_fingerprint_FingerprintManager_2$onError(long deviceId, int error, int vendorCode) {
                this.this$0.mHandler.obtainMessage(104, error, vendorCode, deviceId).sendToTarget();
            }

            private final void $$robo$$android_hardware_fingerprint_FingerprintManager_2$onRemoved(long deviceId, int fingerId, int groupId, int remaining) {
                this.this$0.mHandler.obtainMessage(105, remaining, 0, new Fingerprint(null, groupId, fingerId, deviceId)).sendToTarget();
            }

            private final void $$robo$$android_hardware_fingerprint_FingerprintManager_2$onEnumerated(long deviceId, int fingerId, int groupId, int remaining) {
                this.this$0.mHandler.obtainMessage(106, fingerId, groupId, deviceId).sendToTarget();
            }

            private void __constructor__(FingerprintManager fingerprintManager) {
                this.$$robo$$android_hardware_fingerprint_FingerprintManager_2$__constructor__(fingerprintManager);
            }
            {
                this.this$0 = fingerprintManager;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_fingerprint_FingerprintManager_2$__constructor__(android.hardware.fingerprint.FingerprintManager ), 0, this, fingerprintManager);
            }

            @Override
            public void onEnrollResult(long l, int n, int n2, int n3) {
                InvokeDynamicSupport.bootstrap("onEnrollResult", $$robo$$android_hardware_fingerprint_FingerprintManager_2$onEnrollResult(long int int int ), 0, this, l, n, n2, n3);
            }

            @Override
            public void onAcquired(long l, int n, int n2) {
                InvokeDynamicSupport.bootstrap("onAcquired", $$robo$$android_hardware_fingerprint_FingerprintManager_2$onAcquired(long int int ), 0, this, l, n, n2);
            }

            @Override
            public void onAuthenticationSucceeded(long l, Fingerprint fingerprint, int n) {
                InvokeDynamicSupport.bootstrap("onAuthenticationSucceeded", $$robo$$android_hardware_fingerprint_FingerprintManager_2$onAuthenticationSucceeded(long android.hardware.fingerprint.Fingerprint int ), 0, this, l, fingerprint, n);
            }

            @Override
            public void onAuthenticationFailed(long l) {
                InvokeDynamicSupport.bootstrap("onAuthenticationFailed", $$robo$$android_hardware_fingerprint_FingerprintManager_2$onAuthenticationFailed(long ), 0, this, l);
            }

            @Override
            public void onError(long l, int n, int n2) {
                InvokeDynamicSupport.bootstrap("onError", $$robo$$android_hardware_fingerprint_FingerprintManager_2$onError(long int int ), 0, this, l, n, n2);
            }

            @Override
            public void onRemoved(long l, int n, int n2, int n3) {
                InvokeDynamicSupport.bootstrap("onRemoved", $$robo$$android_hardware_fingerprint_FingerprintManager_2$onRemoved(long int int int ), 0, this, l, n, n2, n3);
            }

            @Override
            public void onEnumerated(long l, int n, int n2, int n3) {
                InvokeDynamicSupport.bootstrap("onEnumerated", $$robo$$android_hardware_fingerprint_FingerprintManager_2$onEnumerated(long int int int ), 0, this, l, n, n2, n3);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mContext = context;
        this.mService = service;
        if (this.mService == null) {
            Slog.v("FingerprintManager", "FingerprintManagerService was null");
        }
        this.mHandler = new MyHandler(this, context);
    }

    private final int $$robo$$android_hardware_fingerprint_FingerprintManager$getCurrentUserId() {
        try {
            return ActivityManager.getService().getCurrentUser().id;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_hardware_fingerprint_FingerprintManager$cancelEnrollment() {
        if (this.mService != null) {
            try {
                this.mService.cancelEnrollment(this.mToken);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final void $$robo$$android_hardware_fingerprint_FingerprintManager$cancelAuthentication(CryptoObject cryptoObject) {
        if (this.mService != null) {
            try {
                this.mService.cancelAuthentication(this.mToken, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private final String $$robo$$android_hardware_fingerprint_FingerprintManager$getErrorString(int errMsg, int vendorCode) {
        switch (errMsg) {
            case 2: {
                return this.mContext.getString(17039873);
            }
            case 1: {
                return this.mContext.getString(17039868);
            }
            case 4: {
                return this.mContext.getString(17039871);
            }
            case 3: {
                return this.mContext.getString(17039872);
            }
            case 5: {
                return this.mContext.getString(17039867);
            }
            case 7: {
                return this.mContext.getString(17039869);
            }
            case 9: {
                return this.mContext.getString(17039870);
            }
            case 8: {
                String[] msgArray = this.mContext.getResources().getStringArray(17236044);
                if (vendorCode >= msgArray.length) break;
                return msgArray[vendorCode];
            }
        }
        Slog.w("FingerprintManager", "Invalid error message: " + errMsg + ", " + vendorCode);
        return null;
    }

    private final String $$robo$$android_hardware_fingerprint_FingerprintManager$getAcquiredString(int acquireInfo, int vendorCode) {
        switch (acquireInfo) {
            case 0: {
                return null;
            }
            case 1: {
                return this.mContext.getString(17039864);
            }
            case 2: {
                return this.mContext.getString(17039863);
            }
            case 3: {
                return this.mContext.getString(17039862);
            }
            case 4: {
                return this.mContext.getString(17039866);
            }
            case 5: {
                return this.mContext.getString(17039865);
            }
            case 6: {
                String[] msgArray = this.mContext.getResources().getStringArray(17236043);
                if (vendorCode >= msgArray.length) break;
                return msgArray[vendorCode];
            }
        }
        Slog.w("FingerprintManager", "Invalid acquired message: " + acquireInfo + ", " + vendorCode);
        return null;
    }

    public void authenticate(CryptoObject cryptoObject, CancellationSignal cancellationSignal, int n, AuthenticationCallback authenticationCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("authenticate", $$robo$$android_hardware_fingerprint_FingerprintManager$authenticate(android.hardware.fingerprint.FingerprintManager$CryptoObject android.os.CancellationSignal int android.hardware.fingerprint.FingerprintManager$AuthenticationCallback android.os.Handler ), 0, this, cryptoObject, cancellationSignal, n, authenticationCallback, handler);
    }

    private void useHandler(Handler handler) {
        InvokeDynamicSupport.bootstrap("useHandler", $$robo$$android_hardware_fingerprint_FingerprintManager$useHandler(android.os.Handler ), 0, this, handler);
    }

    public void authenticate(CryptoObject cryptoObject, CancellationSignal cancellationSignal, int n, AuthenticationCallback authenticationCallback, Handler handler, int n2) {
        InvokeDynamicSupport.bootstrap("authenticate", $$robo$$android_hardware_fingerprint_FingerprintManager$authenticate(android.hardware.fingerprint.FingerprintManager$CryptoObject android.os.CancellationSignal int android.hardware.fingerprint.FingerprintManager$AuthenticationCallback android.os.Handler int ), 0, this, cryptoObject, cancellationSignal, n, authenticationCallback, handler, n2);
    }

    public void enroll(byte[] byArray, CancellationSignal cancellationSignal, int n, int n2, EnrollmentCallback enrollmentCallback) {
        InvokeDynamicSupport.bootstrap("enroll", $$robo$$android_hardware_fingerprint_FingerprintManager$enroll(byte[] android.os.CancellationSignal int int android.hardware.fingerprint.FingerprintManager$EnrollmentCallback ), 0, this, byArray, cancellationSignal, n, n2, enrollmentCallback);
    }

    public long preEnroll() {
        return (long)InvokeDynamicSupport.bootstrap("preEnroll", $$robo$$android_hardware_fingerprint_FingerprintManager$preEnroll(), 0, this);
    }

    public int postEnroll() {
        return (int)InvokeDynamicSupport.bootstrap("postEnroll", $$robo$$android_hardware_fingerprint_FingerprintManager$postEnroll(), 0, this);
    }

    public void setActiveUser(int n) {
        InvokeDynamicSupport.bootstrap("setActiveUser", $$robo$$android_hardware_fingerprint_FingerprintManager$setActiveUser(int ), 0, this, n);
    }

    public void remove(Fingerprint fingerprint, int n, RemovalCallback removalCallback) {
        InvokeDynamicSupport.bootstrap("remove", $$robo$$android_hardware_fingerprint_FingerprintManager$remove(android.hardware.fingerprint.Fingerprint int android.hardware.fingerprint.FingerprintManager$RemovalCallback ), 0, this, fingerprint, n, removalCallback);
    }

    public void enumerate(int n, EnumerateCallback enumerateCallback) {
        InvokeDynamicSupport.bootstrap("enumerate", $$robo$$android_hardware_fingerprint_FingerprintManager$enumerate(int android.hardware.fingerprint.FingerprintManager$EnumerateCallback ), 0, this, n, enumerateCallback);
    }

    public void rename(int n, int n2, String string2) {
        InvokeDynamicSupport.bootstrap("rename", $$robo$$android_hardware_fingerprint_FingerprintManager$rename(int int java.lang.String ), 0, this, n, n2, string2);
    }

    public List<Fingerprint> getEnrolledFingerprints(int n) {
        return InvokeDynamicSupport.bootstrap("getEnrolledFingerprints", $$robo$$android_hardware_fingerprint_FingerprintManager$getEnrolledFingerprints(int ), 0, this, n);
    }

    public List<Fingerprint> getEnrolledFingerprints() {
        return InvokeDynamicSupport.bootstrap("getEnrolledFingerprints", $$robo$$android_hardware_fingerprint_FingerprintManager$getEnrolledFingerprints(), 0, this);
    }

    public boolean hasEnrolledFingerprints() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasEnrolledFingerprints", $$robo$$android_hardware_fingerprint_FingerprintManager$hasEnrolledFingerprints(), 0, this);
    }

    public boolean hasEnrolledFingerprints(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasEnrolledFingerprints", $$robo$$android_hardware_fingerprint_FingerprintManager$hasEnrolledFingerprints(int ), 0, this, n);
    }

    public boolean isHardwareDetected() {
        return (boolean)InvokeDynamicSupport.bootstrap("isHardwareDetected", $$robo$$android_hardware_fingerprint_FingerprintManager$isHardwareDetected(), 0, this);
    }

    public long getAuthenticatorId() {
        return (long)InvokeDynamicSupport.bootstrap("getAuthenticatorId", $$robo$$android_hardware_fingerprint_FingerprintManager$getAuthenticatorId(), 0, this);
    }

    public void resetTimeout(byte[] byArray) {
        InvokeDynamicSupport.bootstrap("resetTimeout", $$robo$$android_hardware_fingerprint_FingerprintManager$resetTimeout(byte[] ), 0, this, byArray);
    }

    public void addLockoutResetCallback(LockoutResetCallback lockoutResetCallback) {
        InvokeDynamicSupport.bootstrap("addLockoutResetCallback", $$robo$$android_hardware_fingerprint_FingerprintManager$addLockoutResetCallback(android.hardware.fingerprint.FingerprintManager$LockoutResetCallback ), 0, this, lockoutResetCallback);
    }

    private void __constructor__(Context context, IFingerprintService iFingerprintService) {
        this.$$robo$$android_hardware_fingerprint_FingerprintManager$__constructor__(context, iFingerprintService);
    }

    public FingerprintManager(Context context, IFingerprintService iFingerprintService) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_fingerprint_FingerprintManager$__constructor__(android.content.Context android.hardware.fingerprint.IFingerprintService ), 0, this, context, iFingerprintService);
    }

    private int getCurrentUserId() {
        return (int)InvokeDynamicSupport.bootstrap("getCurrentUserId", $$robo$$android_hardware_fingerprint_FingerprintManager$getCurrentUserId(), 0, this);
    }

    private void cancelEnrollment() {
        InvokeDynamicSupport.bootstrap("cancelEnrollment", $$robo$$android_hardware_fingerprint_FingerprintManager$cancelEnrollment(), 0, this);
    }

    private void cancelAuthentication(CryptoObject cryptoObject) {
        InvokeDynamicSupport.bootstrap("cancelAuthentication", $$robo$$android_hardware_fingerprint_FingerprintManager$cancelAuthentication(android.hardware.fingerprint.FingerprintManager$CryptoObject ), 0, this, cryptoObject);
    }

    private String getErrorString(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getErrorString", $$robo$$android_hardware_fingerprint_FingerprintManager$getErrorString(int int ), 0, this, n, n2);
    }

    private String getAcquiredString(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getAcquiredString", $$robo$$android_hardware_fingerprint_FingerprintManager$getAcquiredString(int int ), 0, this, n, n2);
    }

    public /* synthetic */ FingerprintManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FingerprintManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class MyHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ FingerprintManager this$0;

        private void $$robo$$android_hardware_fingerprint_FingerprintManager_MyHandler$__constructor__(FingerprintManager fingerprintManager, Context context) {
        }

        private void $$robo$$android_hardware_fingerprint_FingerprintManager_MyHandler$__constructor__(FingerprintManager fingerprintManager, Looper looper) {
        }

        private final void $$robo$$android_hardware_fingerprint_FingerprintManager_MyHandler$handleMessage(Message msg) {
            switch (msg.what) {
                case 100: {
                    this.sendEnrollResult((Fingerprint)msg.obj, msg.arg1);
                    break;
                }
                case 101: {
                    this.sendAcquiredResult((Long)msg.obj, msg.arg1, msg.arg2);
                    break;
                }
                case 102: {
                    this.sendAuthenticatedSucceeded((Fingerprint)msg.obj, msg.arg1);
                    break;
                }
                case 103: {
                    this.sendAuthenticatedFailed();
                    break;
                }
                case 104: {
                    this.sendErrorResult((Long)msg.obj, msg.arg1, msg.arg2);
                    break;
                }
                case 105: {
                    this.sendRemovedResult((Fingerprint)msg.obj, msg.arg1);
                    break;
                }
                case 106: {
                    this.sendEnumeratedResult((Long)msg.obj, msg.arg1, msg.arg2);
                }
            }
        }

        private final void $$robo$$android_hardware_fingerprint_FingerprintManager_MyHandler$sendRemovedResult(Fingerprint fingerprint, int remaining) {
            int reqGroupId;
            if (this.this$0.mRemovalCallback == null) {
                return;
            }
            if (fingerprint == null) {
                Log.e("FingerprintManager", "Received MSG_REMOVED, but fingerprint is null");
                return;
            }
            int fingerId = fingerprint.getFingerId();
            int reqFingerId = this.this$0.mRemovalFingerprint.getFingerId();
            if (reqFingerId != 0 && fingerId != 0 && fingerId != reqFingerId) {
                Log.w("FingerprintManager", "Finger id didn't match: " + fingerId + " != " + reqFingerId);
                return;
            }
            int groupId = fingerprint.getGroupId();
            if (groupId != (reqGroupId = this.this$0.mRemovalFingerprint.getGroupId())) {
                Log.w("FingerprintManager", "Group id didn't match: " + groupId + " != " + reqGroupId);
                return;
            }
            this.this$0.mRemovalCallback.onRemovalSucceeded(fingerprint, remaining);
        }

        private final void $$robo$$android_hardware_fingerprint_FingerprintManager_MyHandler$sendEnumeratedResult(long deviceId, int fingerId, int groupId) {
            if (this.this$0.mEnumerateCallback != null) {
                this.this$0.mEnumerateCallback.onEnumerate(new Fingerprint(null, groupId, fingerId, deviceId));
            }
        }

        private final void $$robo$$android_hardware_fingerprint_FingerprintManager_MyHandler$sendErrorResult(long deviceId, int errMsgId, int vendorCode) {
            int clientErrMsgId;
            int n = clientErrMsgId = errMsgId == 8 ? vendorCode + 1000 : errMsgId;
            if (this.this$0.mEnrollmentCallback != null) {
                this.this$0.mEnrollmentCallback.onEnrollmentError(clientErrMsgId, this.this$0.getErrorString(errMsgId, vendorCode));
            } else if (this.this$0.mAuthenticationCallback != null) {
                this.this$0.mAuthenticationCallback.onAuthenticationError(clientErrMsgId, this.this$0.getErrorString(errMsgId, vendorCode));
            } else if (this.this$0.mRemovalCallback != null) {
                this.this$0.mRemovalCallback.onRemovalError(this.this$0.mRemovalFingerprint, clientErrMsgId, this.this$0.getErrorString(errMsgId, vendorCode));
            } else if (this.this$0.mEnumerateCallback != null) {
                this.this$0.mEnumerateCallback.onEnumerateError(clientErrMsgId, this.this$0.getErrorString(errMsgId, vendorCode));
            }
        }

        private final void $$robo$$android_hardware_fingerprint_FingerprintManager_MyHandler$sendEnrollResult(Fingerprint fp, int remaining) {
            if (this.this$0.mEnrollmentCallback != null) {
                this.this$0.mEnrollmentCallback.onEnrollmentProgress(remaining);
            }
        }

        private final void $$robo$$android_hardware_fingerprint_FingerprintManager_MyHandler$sendAuthenticatedSucceeded(Fingerprint fp, int userId) {
            if (this.this$0.mAuthenticationCallback != null) {
                AuthenticationResult result = new AuthenticationResult(this.this$0.mCryptoObject, fp, userId);
                this.this$0.mAuthenticationCallback.onAuthenticationSucceeded(result);
            }
        }

        private final void $$robo$$android_hardware_fingerprint_FingerprintManager_MyHandler$sendAuthenticatedFailed() {
            if (this.this$0.mAuthenticationCallback != null) {
                this.this$0.mAuthenticationCallback.onAuthenticationFailed();
            }
        }

        private final void $$robo$$android_hardware_fingerprint_FingerprintManager_MyHandler$sendAcquiredResult(long deviceId, int acquireInfo, int vendorCode) {
            int clientInfo;
            String msg;
            if (this.this$0.mAuthenticationCallback != null) {
                this.this$0.mAuthenticationCallback.onAuthenticationAcquired(acquireInfo);
            }
            if ((msg = this.this$0.getAcquiredString(acquireInfo, vendorCode)) == null) {
                return;
            }
            int n = clientInfo = acquireInfo == 6 ? vendorCode + 1000 : acquireInfo;
            if (this.this$0.mEnrollmentCallback != null) {
                this.this$0.mEnrollmentCallback.onEnrollmentHelp(clientInfo, msg);
            } else if (this.this$0.mAuthenticationCallback != null) {
                this.this$0.mAuthenticationCallback.onAuthenticationHelp(clientInfo, msg);
            }
        }

        private /* synthetic */ void $$robo$$android_hardware_fingerprint_FingerprintManager_MyHandler$__constructor__(FingerprintManager x0, Looper x1, 1 x2) {
        }

        private /* synthetic */ void $$robo$$android_hardware_fingerprint_FingerprintManager_MyHandler$__constructor__(FingerprintManager x0, Context x1, 1 x2) {
        }

        private void __constructor__(FingerprintManager fingerprintManager, Context context) {
            this.$$robo$$android_hardware_fingerprint_FingerprintManager_MyHandler$__constructor__(fingerprintManager, context);
        }

        private MyHandler(FingerprintManager fingerprintManager, Context context) {
            this.this$0 = fingerprintManager;
            super(context.getMainLooper());
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_fingerprint_FingerprintManager_MyHandler$__constructor__(android.hardware.fingerprint.FingerprintManager android.content.Context ), 0, this, fingerprintManager, context);
        }

        private void __constructor__(FingerprintManager fingerprintManager, Looper looper) {
            this.$$robo$$android_hardware_fingerprint_FingerprintManager_MyHandler$__constructor__(fingerprintManager, looper);
        }

        private MyHandler(FingerprintManager fingerprintManager, Looper looper) {
            this.this$0 = fingerprintManager;
            super(looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_fingerprint_FingerprintManager_MyHandler$__constructor__(android.hardware.fingerprint.FingerprintManager android.os.Looper ), 0, this, fingerprintManager, looper);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_hardware_fingerprint_FingerprintManager_MyHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        private void sendRemovedResult(Fingerprint fingerprint, int n) {
            InvokeDynamicSupport.bootstrap("sendRemovedResult", $$robo$$android_hardware_fingerprint_FingerprintManager_MyHandler$sendRemovedResult(android.hardware.fingerprint.Fingerprint int ), 0, this, fingerprint, n);
        }

        private void sendEnumeratedResult(long l, int n, int n2) {
            InvokeDynamicSupport.bootstrap("sendEnumeratedResult", $$robo$$android_hardware_fingerprint_FingerprintManager_MyHandler$sendEnumeratedResult(long int int ), 0, this, l, n, n2);
        }

        private void sendErrorResult(long l, int n, int n2) {
            InvokeDynamicSupport.bootstrap("sendErrorResult", $$robo$$android_hardware_fingerprint_FingerprintManager_MyHandler$sendErrorResult(long int int ), 0, this, l, n, n2);
        }

        private void sendEnrollResult(Fingerprint fingerprint, int n) {
            InvokeDynamicSupport.bootstrap("sendEnrollResult", $$robo$$android_hardware_fingerprint_FingerprintManager_MyHandler$sendEnrollResult(android.hardware.fingerprint.Fingerprint int ), 0, this, fingerprint, n);
        }

        private void sendAuthenticatedSucceeded(Fingerprint fingerprint, int n) {
            InvokeDynamicSupport.bootstrap("sendAuthenticatedSucceeded", $$robo$$android_hardware_fingerprint_FingerprintManager_MyHandler$sendAuthenticatedSucceeded(android.hardware.fingerprint.Fingerprint int ), 0, this, fingerprint, n);
        }

        private void sendAuthenticatedFailed() {
            InvokeDynamicSupport.bootstrap("sendAuthenticatedFailed", $$robo$$android_hardware_fingerprint_FingerprintManager_MyHandler$sendAuthenticatedFailed(), 0, this);
        }

        private void sendAcquiredResult(long l, int n, int n2) {
            InvokeDynamicSupport.bootstrap("sendAcquiredResult", $$robo$$android_hardware_fingerprint_FingerprintManager_MyHandler$sendAcquiredResult(long int int ), 0, this, l, n, n2);
        }

        private /* synthetic */ void __constructor__(FingerprintManager fingerprintManager, Looper looper, 1 var3_3) {
            this.$$robo$$android_hardware_fingerprint_FingerprintManager_MyHandler$__constructor__(fingerprintManager, looper, var3_3);
        }

        private /* synthetic */ void __constructor__(FingerprintManager fingerprintManager, Context context, 1 var3_3) {
            this.$$robo$$android_hardware_fingerprint_FingerprintManager_MyHandler$__constructor__(fingerprintManager, context, var3_3);
        }

        public /* synthetic */ MyHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MyHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class LockoutResetCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_hardware_fingerprint_FingerprintManager_LockoutResetCallback$__constructor__() {
        }

        private final void $$robo$$android_hardware_fingerprint_FingerprintManager_LockoutResetCallback$onLockoutReset() {
        }

        private void __constructor__() {
            this.$$robo$$android_hardware_fingerprint_FingerprintManager_LockoutResetCallback$__constructor__();
        }

        public LockoutResetCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_fingerprint_FingerprintManager_LockoutResetCallback$__constructor__(), 0, this);
        }

        public void onLockoutReset() {
            InvokeDynamicSupport.bootstrap("onLockoutReset", $$robo$$android_hardware_fingerprint_FingerprintManager_LockoutResetCallback$onLockoutReset(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LockoutResetCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class EnumerateCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_hardware_fingerprint_FingerprintManager_EnumerateCallback$__constructor__() {
        }

        private final void $$robo$$android_hardware_fingerprint_FingerprintManager_EnumerateCallback$onEnumerateError(int errMsgId, CharSequence errString) {
        }

        private final void $$robo$$android_hardware_fingerprint_FingerprintManager_EnumerateCallback$onEnumerate(Fingerprint fingerprint) {
        }

        private void __constructor__() {
            this.$$robo$$android_hardware_fingerprint_FingerprintManager_EnumerateCallback$__constructor__();
        }

        public EnumerateCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_fingerprint_FingerprintManager_EnumerateCallback$__constructor__(), 0, this);
        }

        public void onEnumerateError(int n, CharSequence charSequence) {
            InvokeDynamicSupport.bootstrap("onEnumerateError", $$robo$$android_hardware_fingerprint_FingerprintManager_EnumerateCallback$onEnumerateError(int java.lang.CharSequence ), 0, this, n, charSequence);
        }

        public void onEnumerate(Fingerprint fingerprint) {
            InvokeDynamicSupport.bootstrap("onEnumerate", $$robo$$android_hardware_fingerprint_FingerprintManager_EnumerateCallback$onEnumerate(android.hardware.fingerprint.Fingerprint ), 0, this, fingerprint);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EnumerateCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class RemovalCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_hardware_fingerprint_FingerprintManager_RemovalCallback$__constructor__() {
        }

        private final void $$robo$$android_hardware_fingerprint_FingerprintManager_RemovalCallback$onRemovalError(Fingerprint fp, int errMsgId, CharSequence errString) {
        }

        private final void $$robo$$android_hardware_fingerprint_FingerprintManager_RemovalCallback$onRemovalSucceeded(Fingerprint fp, int remaining) {
        }

        private void __constructor__() {
            this.$$robo$$android_hardware_fingerprint_FingerprintManager_RemovalCallback$__constructor__();
        }

        public RemovalCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_fingerprint_FingerprintManager_RemovalCallback$__constructor__(), 0, this);
        }

        public void onRemovalError(Fingerprint fingerprint, int n, CharSequence charSequence) {
            InvokeDynamicSupport.bootstrap("onRemovalError", $$robo$$android_hardware_fingerprint_FingerprintManager_RemovalCallback$onRemovalError(android.hardware.fingerprint.Fingerprint int java.lang.CharSequence ), 0, this, fingerprint, n, charSequence);
        }

        public void onRemovalSucceeded(Fingerprint fingerprint, int n) {
            InvokeDynamicSupport.bootstrap("onRemovalSucceeded", $$robo$$android_hardware_fingerprint_FingerprintManager_RemovalCallback$onRemovalSucceeded(android.hardware.fingerprint.Fingerprint int ), 0, this, fingerprint, n);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RemovalCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class EnrollmentCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_hardware_fingerprint_FingerprintManager_EnrollmentCallback$__constructor__() {
        }

        private final void $$robo$$android_hardware_fingerprint_FingerprintManager_EnrollmentCallback$onEnrollmentError(int errMsgId, CharSequence errString) {
        }

        private final void $$robo$$android_hardware_fingerprint_FingerprintManager_EnrollmentCallback$onEnrollmentHelp(int helpMsgId, CharSequence helpString) {
        }

        private final void $$robo$$android_hardware_fingerprint_FingerprintManager_EnrollmentCallback$onEnrollmentProgress(int remaining) {
        }

        private void __constructor__() {
            this.$$robo$$android_hardware_fingerprint_FingerprintManager_EnrollmentCallback$__constructor__();
        }

        public EnrollmentCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_fingerprint_FingerprintManager_EnrollmentCallback$__constructor__(), 0, this);
        }

        public void onEnrollmentError(int n, CharSequence charSequence) {
            InvokeDynamicSupport.bootstrap("onEnrollmentError", $$robo$$android_hardware_fingerprint_FingerprintManager_EnrollmentCallback$onEnrollmentError(int java.lang.CharSequence ), 0, this, n, charSequence);
        }

        public void onEnrollmentHelp(int n, CharSequence charSequence) {
            InvokeDynamicSupport.bootstrap("onEnrollmentHelp", $$robo$$android_hardware_fingerprint_FingerprintManager_EnrollmentCallback$onEnrollmentHelp(int java.lang.CharSequence ), 0, this, n, charSequence);
        }

        public void onEnrollmentProgress(int n) {
            InvokeDynamicSupport.bootstrap("onEnrollmentProgress", $$robo$$android_hardware_fingerprint_FingerprintManager_EnrollmentCallback$onEnrollmentProgress(int ), 0, this, n);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EnrollmentCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class AuthenticationCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_hardware_fingerprint_FingerprintManager_AuthenticationCallback$__constructor__() {
        }

        private final void $$robo$$android_hardware_fingerprint_FingerprintManager_AuthenticationCallback$onAuthenticationError(int errorCode, CharSequence errString) {
        }

        private final void $$robo$$android_hardware_fingerprint_FingerprintManager_AuthenticationCallback$onAuthenticationHelp(int helpCode, CharSequence helpString) {
        }

        private final void $$robo$$android_hardware_fingerprint_FingerprintManager_AuthenticationCallback$onAuthenticationSucceeded(AuthenticationResult result) {
        }

        private final void $$robo$$android_hardware_fingerprint_FingerprintManager_AuthenticationCallback$onAuthenticationFailed() {
        }

        private final void $$robo$$android_hardware_fingerprint_FingerprintManager_AuthenticationCallback$onAuthenticationAcquired(int acquireInfo) {
        }

        private void __constructor__() {
            this.$$robo$$android_hardware_fingerprint_FingerprintManager_AuthenticationCallback$__constructor__();
        }

        public AuthenticationCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_fingerprint_FingerprintManager_AuthenticationCallback$__constructor__(), 0, this);
        }

        public void onAuthenticationError(int n, CharSequence charSequence) {
            InvokeDynamicSupport.bootstrap("onAuthenticationError", $$robo$$android_hardware_fingerprint_FingerprintManager_AuthenticationCallback$onAuthenticationError(int java.lang.CharSequence ), 0, this, n, charSequence);
        }

        public void onAuthenticationHelp(int n, CharSequence charSequence) {
            InvokeDynamicSupport.bootstrap("onAuthenticationHelp", $$robo$$android_hardware_fingerprint_FingerprintManager_AuthenticationCallback$onAuthenticationHelp(int java.lang.CharSequence ), 0, this, n, charSequence);
        }

        public void onAuthenticationSucceeded(AuthenticationResult authenticationResult) {
            InvokeDynamicSupport.bootstrap("onAuthenticationSucceeded", $$robo$$android_hardware_fingerprint_FingerprintManager_AuthenticationCallback$onAuthenticationSucceeded(android.hardware.fingerprint.FingerprintManager$AuthenticationResult ), 0, this, authenticationResult);
        }

        public void onAuthenticationFailed() {
            InvokeDynamicSupport.bootstrap("onAuthenticationFailed", $$robo$$android_hardware_fingerprint_FingerprintManager_AuthenticationCallback$onAuthenticationFailed(), 0, this);
        }

        public void onAuthenticationAcquired(int n) {
            InvokeDynamicSupport.bootstrap("onAuthenticationAcquired", $$robo$$android_hardware_fingerprint_FingerprintManager_AuthenticationCallback$onAuthenticationAcquired(int ), 0, this, n);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AuthenticationCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class AuthenticationResult
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Fingerprint mFingerprint;
        private CryptoObject mCryptoObject;
        private int mUserId;

        private void $$robo$$android_hardware_fingerprint_FingerprintManager_AuthenticationResult$__constructor__(CryptoObject crypto, Fingerprint fingerprint, int userId) {
            this.mCryptoObject = crypto;
            this.mFingerprint = fingerprint;
            this.mUserId = userId;
        }

        private final CryptoObject $$robo$$android_hardware_fingerprint_FingerprintManager_AuthenticationResult$getCryptoObject() {
            return this.mCryptoObject;
        }

        private final Fingerprint $$robo$$android_hardware_fingerprint_FingerprintManager_AuthenticationResult$getFingerprint() {
            return this.mFingerprint;
        }

        private final int $$robo$$android_hardware_fingerprint_FingerprintManager_AuthenticationResult$getUserId() {
            return this.mUserId;
        }

        private void __constructor__(CryptoObject cryptoObject, Fingerprint fingerprint, int n) {
            this.$$robo$$android_hardware_fingerprint_FingerprintManager_AuthenticationResult$__constructor__(cryptoObject, fingerprint, n);
        }

        public AuthenticationResult(CryptoObject cryptoObject, Fingerprint fingerprint, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_fingerprint_FingerprintManager_AuthenticationResult$__constructor__(android.hardware.fingerprint.FingerprintManager$CryptoObject android.hardware.fingerprint.Fingerprint int ), 0, this, cryptoObject, fingerprint, n);
        }

        public CryptoObject getCryptoObject() {
            return InvokeDynamicSupport.bootstrap("getCryptoObject", $$robo$$android_hardware_fingerprint_FingerprintManager_AuthenticationResult$getCryptoObject(), 0, this);
        }

        public Fingerprint getFingerprint() {
            return InvokeDynamicSupport.bootstrap("getFingerprint", $$robo$$android_hardware_fingerprint_FingerprintManager_AuthenticationResult$getFingerprint(), 0, this);
        }

        public int getUserId() {
            return (int)InvokeDynamicSupport.bootstrap("getUserId", $$robo$$android_hardware_fingerprint_FingerprintManager_AuthenticationResult$getUserId(), 0, this);
        }

        public /* synthetic */ AuthenticationResult() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AuthenticationResult)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class CryptoObject
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Object mCrypto;

        private void $$robo$$android_hardware_fingerprint_FingerprintManager_CryptoObject$__constructor__(Signature signature) {
            this.mCrypto = signature;
        }

        private void $$robo$$android_hardware_fingerprint_FingerprintManager_CryptoObject$__constructor__(Cipher cipher) {
            this.mCrypto = cipher;
        }

        private void $$robo$$android_hardware_fingerprint_FingerprintManager_CryptoObject$__constructor__(Mac mac) {
            this.mCrypto = mac;
        }

        private final Signature $$robo$$android_hardware_fingerprint_FingerprintManager_CryptoObject$getSignature() {
            return this.mCrypto instanceof Signature ? (Signature)this.mCrypto : null;
        }

        private final Cipher $$robo$$android_hardware_fingerprint_FingerprintManager_CryptoObject$getCipher() {
            return this.mCrypto instanceof Cipher ? (Cipher)this.mCrypto : null;
        }

        private final Mac $$robo$$android_hardware_fingerprint_FingerprintManager_CryptoObject$getMac() {
            return this.mCrypto instanceof Mac ? (Mac)this.mCrypto : null;
        }

        private final long $$robo$$android_hardware_fingerprint_FingerprintManager_CryptoObject$getOpId() {
            return this.mCrypto != null ? AndroidKeyStoreProvider.getKeyStoreOperationHandle(this.mCrypto) : 0L;
        }

        private void __constructor__(Signature signature) {
            this.$$robo$$android_hardware_fingerprint_FingerprintManager_CryptoObject$__constructor__(signature);
        }

        public CryptoObject(Signature signature) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_fingerprint_FingerprintManager_CryptoObject$__constructor__(java.security.Signature ), 0, this, signature);
        }

        private void __constructor__(Cipher cipher) {
            this.$$robo$$android_hardware_fingerprint_FingerprintManager_CryptoObject$__constructor__(cipher);
        }

        public CryptoObject(Cipher cipher) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_fingerprint_FingerprintManager_CryptoObject$__constructor__(javax.crypto.Cipher ), 0, this, cipher);
        }

        private void __constructor__(Mac mac) {
            this.$$robo$$android_hardware_fingerprint_FingerprintManager_CryptoObject$__constructor__(mac);
        }

        public CryptoObject(Mac mac) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_fingerprint_FingerprintManager_CryptoObject$__constructor__(javax.crypto.Mac ), 0, this, mac);
        }

        public Signature getSignature() {
            return InvokeDynamicSupport.bootstrap("getSignature", $$robo$$android_hardware_fingerprint_FingerprintManager_CryptoObject$getSignature(), 0, this);
        }

        public Cipher getCipher() {
            return InvokeDynamicSupport.bootstrap("getCipher", $$robo$$android_hardware_fingerprint_FingerprintManager_CryptoObject$getCipher(), 0, this);
        }

        public Mac getMac() {
            return InvokeDynamicSupport.bootstrap("getMac", $$robo$$android_hardware_fingerprint_FingerprintManager_CryptoObject$getMac(), 0, this);
        }

        public long getOpId() {
            return (long)InvokeDynamicSupport.bootstrap("getOpId", $$robo$$android_hardware_fingerprint_FingerprintManager_CryptoObject$getOpId(), 0, this);
        }

        public /* synthetic */ CryptoObject() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CryptoObject)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class OnAuthenticationCancelListener
    implements CancellationSignal.OnCancelListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private CryptoObject mCrypto;
        /* synthetic */ FingerprintManager this$0;

        private void $$robo$$android_hardware_fingerprint_FingerprintManager_OnAuthenticationCancelListener$__constructor__(FingerprintManager fingerprintManager, CryptoObject crypto) {
            this.mCrypto = crypto;
        }

        private final void $$robo$$android_hardware_fingerprint_FingerprintManager_OnAuthenticationCancelListener$onCancel() {
            this.this$0.cancelAuthentication(this.mCrypto);
        }

        private void __constructor__(FingerprintManager fingerprintManager, CryptoObject cryptoObject) {
            this.$$robo$$android_hardware_fingerprint_FingerprintManager_OnAuthenticationCancelListener$__constructor__(fingerprintManager, cryptoObject);
        }

        public OnAuthenticationCancelListener(FingerprintManager fingerprintManager, CryptoObject cryptoObject) {
            this.this$0 = fingerprintManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_fingerprint_FingerprintManager_OnAuthenticationCancelListener$__constructor__(android.hardware.fingerprint.FingerprintManager android.hardware.fingerprint.FingerprintManager$CryptoObject ), 0, this, fingerprintManager, cryptoObject);
        }

        @Override
        public void onCancel() {
            InvokeDynamicSupport.bootstrap("onCancel", $$robo$$android_hardware_fingerprint_FingerprintManager_OnAuthenticationCancelListener$onCancel(), 0, this);
        }

        public /* synthetic */ OnAuthenticationCancelListener() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OnAuthenticationCancelListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class OnEnrollCancelListener
    implements CancellationSignal.OnCancelListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ FingerprintManager this$0;

        private void $$robo$$android_hardware_fingerprint_FingerprintManager_OnEnrollCancelListener$__constructor__(FingerprintManager fingerprintManager) {
        }

        private final void $$robo$$android_hardware_fingerprint_FingerprintManager_OnEnrollCancelListener$onCancel() {
            this.this$0.cancelEnrollment();
        }

        private /* synthetic */ void $$robo$$android_hardware_fingerprint_FingerprintManager_OnEnrollCancelListener$__constructor__(FingerprintManager x0, 1 x1) {
        }

        private void __constructor__(FingerprintManager fingerprintManager) {
            this.$$robo$$android_hardware_fingerprint_FingerprintManager_OnEnrollCancelListener$__constructor__(fingerprintManager);
        }

        private OnEnrollCancelListener(FingerprintManager fingerprintManager) {
            this.this$0 = fingerprintManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_fingerprint_FingerprintManager_OnEnrollCancelListener$__constructor__(android.hardware.fingerprint.FingerprintManager ), 0, this, fingerprintManager);
        }

        @Override
        public void onCancel() {
            InvokeDynamicSupport.bootstrap("onCancel", $$robo$$android_hardware_fingerprint_FingerprintManager_OnEnrollCancelListener$onCancel(), 0, this);
        }

        private /* synthetic */ void __constructor__(FingerprintManager fingerprintManager, 1 var2_2) {
            this.$$robo$$android_hardware_fingerprint_FingerprintManager_OnEnrollCancelListener$__constructor__(fingerprintManager, var2_2);
        }

        public /* synthetic */ OnEnrollCancelListener() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OnEnrollCancelListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

