/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.input;

import android.app.IInputForwarder;
import android.content.Context;
import android.hardware.input.IInputDevicesChangedListener;
import android.hardware.input.IInputManager;
import android.hardware.input.ITabletModeChangedListener;
import android.hardware.input.InputDeviceIdentifier;
import android.hardware.input.KeyboardLayout;
import android.hardware.input.TouchCalibration;
import android.media.AudioAttributes;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.VibrationEffect;
import android.os.Vibrator;
import android.provider.Settings;
import android.util.Log;
import android.util.SparseArray;
import android.view.InputDevice;
import android.view.InputEvent;
import android.view.PointerIcon;
import android.view.inputmethod.InputMethodInfo;
import android.view.inputmethod.InputMethodSubtype;
import com.android.internal.os.SomeArgs;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class InputManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "InputManager";
    private static boolean DEBUG = false;
    private static int MSG_DEVICE_ADDED = 1;
    private static int MSG_DEVICE_REMOVED = 2;
    private static int MSG_DEVICE_CHANGED = 3;
    private static InputManager sInstance;
    private IInputManager mIm;
    private Object mInputDevicesLock;
    private SparseArray<InputDevice> mInputDevices;
    private InputDevicesChangedListener mInputDevicesChangedListener;
    private ArrayList<InputDeviceListenerDelegate> mInputDeviceListeners;
    private Object mTabletModeLock;
    private TabletModeChangedListener mTabletModeChangedListener;
    private List<OnTabletModeChangedListenerDelegate> mOnTabletModeChangedListeners;
    public static String ACTION_QUERY_KEYBOARD_LAYOUTS = "android.hardware.input.action.QUERY_KEYBOARD_LAYOUTS";
    public static String META_DATA_KEYBOARD_LAYOUTS = "android.hardware.input.metadata.KEYBOARD_LAYOUTS";
    public static int MIN_POINTER_SPEED = -7;
    public static int MAX_POINTER_SPEED = 7;
    public static int DEFAULT_POINTER_SPEED = 0;
    public static int INJECT_INPUT_EVENT_MODE_ASYNC = 0;
    public static int INJECT_INPUT_EVENT_MODE_WAIT_FOR_RESULT = 1;
    public static int INJECT_INPUT_EVENT_MODE_WAIT_FOR_FINISH = 2;
    public static int SWITCH_STATE_UNKNOWN = -1;
    public static int SWITCH_STATE_OFF = 0;
    public static int SWITCH_STATE_ON = 1;

    private void $$robo$$android_hardware_input_InputManager$__constructor__(IInputManager im) {
        this.mInputDevicesLock = new Object();
        this.mInputDeviceListeners = new ArrayList();
        this.mTabletModeLock = new Object();
        this.mIm = im;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final InputManager $$robo$$android_hardware_input_InputManager$getInstance() {
        Class<InputManager> clazz = InputManager.class;
        synchronized (InputManager.class) {
            if (sInstance == null) {
                try {
                    sInstance = new InputManager(IInputManager.Stub.asInterface(ServiceManager.getServiceOrThrow("input")));
                }
                catch (ServiceManager.ServiceNotFoundException e) {
                    throw new IllegalStateException(e);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final InputDevice $$robo$$android_hardware_input_InputManager$getInputDevice(int id2) {
        Object object = this.mInputDevicesLock;
        synchronized (object) {
            this.populateInputDevicesLocked();
            int index = this.mInputDevices.indexOfKey(id2);
            if (index < 0) {
                return null;
            }
            InputDevice inputDevice = this.mInputDevices.valueAt(index);
            if (inputDevice == null) {
                try {
                    inputDevice = this.mIm.getInputDevice(id2);
                }
                catch (RemoteException ex) {
                    throw ex.rethrowFromSystemServer();
                }
                if (inputDevice != null) {
                    this.mInputDevices.setValueAt(index, inputDevice);
                }
            }
            return inputDevice;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final InputDevice $$robo$$android_hardware_input_InputManager$getInputDeviceByDescriptor(String descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException("descriptor must not be null.");
        }
        Object object = this.mInputDevicesLock;
        synchronized (object) {
            this.populateInputDevicesLocked();
            int numDevices = this.mInputDevices.size();
            for (int i = 0; i < numDevices; ++i) {
                InputDevice inputDevice = this.mInputDevices.valueAt(i);
                if (inputDevice == null) {
                    int id2 = this.mInputDevices.keyAt(i);
                    try {
                        inputDevice = this.mIm.getInputDevice(id2);
                    }
                    catch (RemoteException ex) {
                        throw ex.rethrowFromSystemServer();
                    }
                    if (inputDevice == null) continue;
                    this.mInputDevices.setValueAt(i, inputDevice);
                }
                if (!descriptor.equals(inputDevice.getDescriptor())) continue;
                return inputDevice;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int[] $$robo$$android_hardware_input_InputManager$getInputDeviceIds() {
        Object object = this.mInputDevicesLock;
        synchronized (object) {
            this.populateInputDevicesLocked();
            int count = this.mInputDevices.size();
            int[] ids = new int[count];
            for (int i = 0; i < count; ++i) {
                ids[i] = this.mInputDevices.keyAt(i);
            }
            return ids;
        }
    }

    private final boolean $$robo$$android_hardware_input_InputManager$isInputDeviceEnabled(int id2) {
        try {
            return this.mIm.isInputDeviceEnabled(id2);
        }
        catch (RemoteException ex) {
            Log.w("InputManager", "Could not check enabled status of input device with id = " + id2);
            throw ex.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_hardware_input_InputManager$enableInputDevice(int id2) {
        try {
            this.mIm.enableInputDevice(id2);
        }
        catch (RemoteException ex) {
            Log.w("InputManager", "Could not enable input device with id = " + id2);
            throw ex.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_hardware_input_InputManager$disableInputDevice(int id2) {
        try {
            this.mIm.disableInputDevice(id2);
        }
        catch (RemoteException ex) {
            Log.w("InputManager", "Could not disable input device with id = " + id2);
            throw ex.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_input_InputManager$registerInputDeviceListener(InputDeviceListener listener, Handler handler) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        Object object = this.mInputDevicesLock;
        synchronized (object) {
            this.populateInputDevicesLocked();
            int index = this.findInputDeviceListenerLocked(listener);
            if (index < 0) {
                this.mInputDeviceListeners.add(new InputDeviceListenerDelegate(listener, handler));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_input_InputManager$unregisterInputDeviceListener(InputDeviceListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        Object object = this.mInputDevicesLock;
        synchronized (object) {
            int index = this.findInputDeviceListenerLocked(listener);
            if (index >= 0) {
                InputDeviceListenerDelegate d = this.mInputDeviceListeners.get(index);
                d.removeCallbacksAndMessages(null);
                this.mInputDeviceListeners.remove(index);
            }
        }
    }

    private final int $$robo$$android_hardware_input_InputManager$findInputDeviceListenerLocked(InputDeviceListener listener) {
        int numListeners = this.mInputDeviceListeners.size();
        for (int i = 0; i < numListeners; ++i) {
            if (this.mInputDeviceListeners.get((int)i).mListener != listener) continue;
            return i;
        }
        return -1;
    }

    private final int $$robo$$android_hardware_input_InputManager$isInTabletMode() {
        try {
            return this.mIm.isInTabletMode();
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_input_InputManager$registerOnTabletModeChangedListener(OnTabletModeChangedListener listener, Handler handler) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        Object object = this.mTabletModeLock;
        synchronized (object) {
            int idx;
            if (this.mOnTabletModeChangedListeners == null) {
                this.initializeTabletModeListenerLocked();
            }
            if ((idx = this.findOnTabletModeChangedListenerLocked(listener)) < 0) {
                OnTabletModeChangedListenerDelegate d = new OnTabletModeChangedListenerDelegate(listener, handler);
                this.mOnTabletModeChangedListeners.add(d);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_input_InputManager$unregisterOnTabletModeChangedListener(OnTabletModeChangedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        Object object = this.mTabletModeLock;
        synchronized (object) {
            int idx = this.findOnTabletModeChangedListenerLocked(listener);
            if (idx >= 0) {
                OnTabletModeChangedListenerDelegate d = this.mOnTabletModeChangedListeners.remove(idx);
                d.removeCallbacksAndMessages(null);
            }
        }
    }

    private final void $$robo$$android_hardware_input_InputManager$initializeTabletModeListenerLocked() {
        TabletModeChangedListener listener = new TabletModeChangedListener(this);
        try {
            this.mIm.registerTabletModeChangedListener(listener);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
        this.mTabletModeChangedListener = listener;
        this.mOnTabletModeChangedListeners = new ArrayList<OnTabletModeChangedListenerDelegate>();
    }

    private final int $$robo$$android_hardware_input_InputManager$findOnTabletModeChangedListenerLocked(OnTabletModeChangedListener listener) {
        int N = this.mOnTabletModeChangedListeners.size();
        for (int i = 0; i < N; ++i) {
            if (this.mOnTabletModeChangedListeners.get((int)i).mListener != listener) continue;
            return i;
        }
        return -1;
    }

    private final KeyboardLayout[] $$robo$$android_hardware_input_InputManager$getKeyboardLayouts() {
        try {
            return this.mIm.getKeyboardLayouts();
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    private final KeyboardLayout[] $$robo$$android_hardware_input_InputManager$getKeyboardLayoutsForInputDevice(InputDeviceIdentifier identifier) {
        try {
            return this.mIm.getKeyboardLayoutsForInputDevice(identifier);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    private final KeyboardLayout $$robo$$android_hardware_input_InputManager$getKeyboardLayout(String keyboardLayoutDescriptor) {
        if (keyboardLayoutDescriptor == null) {
            throw new IllegalArgumentException("keyboardLayoutDescriptor must not be null");
        }
        try {
            return this.mIm.getKeyboardLayout(keyboardLayoutDescriptor);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    private final String $$robo$$android_hardware_input_InputManager$getCurrentKeyboardLayoutForInputDevice(InputDeviceIdentifier identifier) {
        try {
            return this.mIm.getCurrentKeyboardLayoutForInputDevice(identifier);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_hardware_input_InputManager$setCurrentKeyboardLayoutForInputDevice(InputDeviceIdentifier identifier, String keyboardLayoutDescriptor) {
        if (identifier == null) {
            throw new IllegalArgumentException("identifier must not be null");
        }
        if (keyboardLayoutDescriptor == null) {
            throw new IllegalArgumentException("keyboardLayoutDescriptor must not be null");
        }
        try {
            this.mIm.setCurrentKeyboardLayoutForInputDevice(identifier, keyboardLayoutDescriptor);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    private final String[] $$robo$$android_hardware_input_InputManager$getEnabledKeyboardLayoutsForInputDevice(InputDeviceIdentifier identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException("inputDeviceDescriptor must not be null");
        }
        try {
            return this.mIm.getEnabledKeyboardLayoutsForInputDevice(identifier);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_hardware_input_InputManager$addKeyboardLayoutForInputDevice(InputDeviceIdentifier identifier, String keyboardLayoutDescriptor) {
        if (identifier == null) {
            throw new IllegalArgumentException("inputDeviceDescriptor must not be null");
        }
        if (keyboardLayoutDescriptor == null) {
            throw new IllegalArgumentException("keyboardLayoutDescriptor must not be null");
        }
        try {
            this.mIm.addKeyboardLayoutForInputDevice(identifier, keyboardLayoutDescriptor);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_hardware_input_InputManager$removeKeyboardLayoutForInputDevice(InputDeviceIdentifier identifier, String keyboardLayoutDescriptor) {
        if (identifier == null) {
            throw new IllegalArgumentException("inputDeviceDescriptor must not be null");
        }
        if (keyboardLayoutDescriptor == null) {
            throw new IllegalArgumentException("keyboardLayoutDescriptor must not be null");
        }
        try {
            this.mIm.removeKeyboardLayoutForInputDevice(identifier, keyboardLayoutDescriptor);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    private final KeyboardLayout $$robo$$android_hardware_input_InputManager$getKeyboardLayoutForInputDevice(InputDeviceIdentifier identifier, InputMethodInfo inputMethodInfo, InputMethodSubtype inputMethodSubtype) {
        try {
            return this.mIm.getKeyboardLayoutForInputDevice(identifier, inputMethodInfo, inputMethodSubtype);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_hardware_input_InputManager$setKeyboardLayoutForInputDevice(InputDeviceIdentifier identifier, InputMethodInfo inputMethodInfo, InputMethodSubtype inputMethodSubtype, String keyboardLayoutDescriptor) {
        try {
            this.mIm.setKeyboardLayoutForInputDevice(identifier, inputMethodInfo, inputMethodSubtype, keyboardLayoutDescriptor);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    private final TouchCalibration $$robo$$android_hardware_input_InputManager$getTouchCalibration(String inputDeviceDescriptor, int surfaceRotation) {
        try {
            return this.mIm.getTouchCalibrationForInputDevice(inputDeviceDescriptor, surfaceRotation);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_hardware_input_InputManager$setTouchCalibration(String inputDeviceDescriptor, int surfaceRotation, TouchCalibration calibration) {
        try {
            this.mIm.setTouchCalibrationForInputDevice(inputDeviceDescriptor, surfaceRotation, calibration);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_hardware_input_InputManager$getPointerSpeed(Context context) {
        int speed = 0;
        try {
            speed = Settings.System.getInt(context.getContentResolver(), "pointer_speed");
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            // empty catch block
        }
        return speed;
    }

    private final void $$robo$$android_hardware_input_InputManager$setPointerSpeed(Context context, int speed) {
        if (speed < -7 || speed > 7) {
            throw new IllegalArgumentException("speed out of range");
        }
        Settings.System.putInt(context.getContentResolver(), "pointer_speed", speed);
    }

    private final void $$robo$$android_hardware_input_InputManager$tryPointerSpeed(int speed) {
        if (speed < -7 || speed > 7) {
            throw new IllegalArgumentException("speed out of range");
        }
        try {
            this.mIm.tryPointerSpeed(speed);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    private final boolean[] $$robo$$android_hardware_input_InputManager$deviceHasKeys(int[] keyCodes) {
        return this.deviceHasKeys(-1, keyCodes);
    }

    private final boolean[] $$robo$$android_hardware_input_InputManager$deviceHasKeys(int id2, int[] keyCodes) {
        boolean[] ret = new boolean[keyCodes.length];
        try {
            this.mIm.hasKeys(id2, -256, keyCodes, ret);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return ret;
    }

    private final boolean $$robo$$android_hardware_input_InputManager$injectInputEvent(InputEvent event, int mode) {
        if (event == null) {
            throw new IllegalArgumentException("event must not be null");
        }
        if (mode != 0 && mode != 2 && mode != 1) {
            throw new IllegalArgumentException("mode is invalid");
        }
        try {
            return this.mIm.injectInputEvent(event, mode);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_hardware_input_InputManager$setPointerIconType(int iconId) {
        try {
            this.mIm.setPointerIconType(iconId);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_hardware_input_InputManager$setCustomPointerIcon(PointerIcon icon) {
        try {
            this.mIm.setCustomPointerIcon(icon);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_hardware_input_InputManager$requestPointerCapture(IBinder windowToken, boolean enable) {
        try {
            this.mIm.requestPointerCapture(windowToken, enable);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    private final IInputForwarder $$robo$$android_hardware_input_InputManager$createInputForwarder(int displayId) {
        try {
            return this.mIm.createInputForwarder(displayId);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_hardware_input_InputManager$populateInputDevicesLocked() {
        if (this.mInputDevicesChangedListener == null) {
            InputDevicesChangedListener listener = new InputDevicesChangedListener(this);
            try {
                this.mIm.registerInputDevicesChangedListener(listener);
            }
            catch (RemoteException ex) {
                throw ex.rethrowFromSystemServer();
            }
            this.mInputDevicesChangedListener = listener;
        }
        if (this.mInputDevices == null) {
            int[] ids;
            try {
                ids = this.mIm.getInputDeviceIds();
            }
            catch (RemoteException ex) {
                throw ex.rethrowFromSystemServer();
            }
            this.mInputDevices = new SparseArray();
            for (int i = 0; i < ids.length; ++i) {
                this.mInputDevices.put(ids[i], null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_input_InputManager$onInputDevicesChanged(int[] deviceIdAndGeneration) {
        Object object = this.mInputDevicesLock;
        synchronized (object) {
            int deviceId;
            int i = this.mInputDevices.size();
            while (--i > 0) {
                deviceId = this.mInputDevices.keyAt(i);
                if (InputManager.containsDeviceId(deviceIdAndGeneration, deviceId)) continue;
                this.mInputDevices.removeAt(i);
                this.sendMessageToInputDeviceListenersLocked(2, deviceId);
            }
            for (i = 0; i < deviceIdAndGeneration.length; i += 2) {
                deviceId = deviceIdAndGeneration[i];
                int index = this.mInputDevices.indexOfKey(deviceId);
                if (index >= 0) {
                    InputDevice device = this.mInputDevices.valueAt(index);
                    if (device == null) continue;
                    int generation = deviceIdAndGeneration[i + 1];
                    if (device.getGeneration() == generation) continue;
                    this.mInputDevices.setValueAt(index, null);
                    this.sendMessageToInputDeviceListenersLocked(3, deviceId);
                    continue;
                }
                this.mInputDevices.put(deviceId, null);
                this.sendMessageToInputDeviceListenersLocked(1, deviceId);
            }
        }
    }

    private final void $$robo$$android_hardware_input_InputManager$sendMessageToInputDeviceListenersLocked(int what, int deviceId) {
        int numListeners = this.mInputDeviceListeners.size();
        for (int i = 0; i < numListeners; ++i) {
            InputDeviceListenerDelegate listener = this.mInputDeviceListeners.get(i);
            listener.sendMessage(listener.obtainMessage(what, deviceId, 0));
        }
    }

    private static final boolean $$robo$$android_hardware_input_InputManager$containsDeviceId(int[] deviceIdAndGeneration, int deviceId) {
        for (int i = 0; i < deviceIdAndGeneration.length; i += 2) {
            if (deviceIdAndGeneration[i] != deviceId) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_input_InputManager$onTabletModeChanged(long whenNanos, boolean inTabletMode) {
        Object object = this.mTabletModeLock;
        synchronized (object) {
            int N = this.mOnTabletModeChangedListeners.size();
            for (int i = 0; i < N; ++i) {
                OnTabletModeChangedListenerDelegate listener = this.mOnTabletModeChangedListeners.get(i);
                listener.sendTabletModeChanged(whenNanos, inTabletMode);
            }
        }
    }

    private final Vibrator $$robo$$android_hardware_input_InputManager$getInputDeviceVibrator(int deviceId) {
        return new InputDeviceVibrator(this, deviceId);
    }

    private void __constructor__(IInputManager iInputManager) {
        this.$$robo$$android_hardware_input_InputManager$__constructor__(iInputManager);
    }

    private InputManager(IInputManager iInputManager) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_input_InputManager$__constructor__(android.hardware.input.IInputManager ), 0, this, iInputManager);
    }

    public static InputManager getInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_hardware_input_InputManager$getInstance(), 0);
    }

    public InputDevice getInputDevice(int n) {
        return InvokeDynamicSupport.bootstrap("getInputDevice", $$robo$$android_hardware_input_InputManager$getInputDevice(int ), 0, this, n);
    }

    public InputDevice getInputDeviceByDescriptor(String string2) {
        return InvokeDynamicSupport.bootstrap("getInputDeviceByDescriptor", $$robo$$android_hardware_input_InputManager$getInputDeviceByDescriptor(java.lang.String ), 0, this, string2);
    }

    public int[] getInputDeviceIds() {
        return InvokeDynamicSupport.bootstrap("getInputDeviceIds", $$robo$$android_hardware_input_InputManager$getInputDeviceIds(), 0, this);
    }

    public boolean isInputDeviceEnabled(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isInputDeviceEnabled", $$robo$$android_hardware_input_InputManager$isInputDeviceEnabled(int ), 0, this, n);
    }

    public void enableInputDevice(int n) {
        InvokeDynamicSupport.bootstrap("enableInputDevice", $$robo$$android_hardware_input_InputManager$enableInputDevice(int ), 0, this, n);
    }

    public void disableInputDevice(int n) {
        InvokeDynamicSupport.bootstrap("disableInputDevice", $$robo$$android_hardware_input_InputManager$disableInputDevice(int ), 0, this, n);
    }

    public void registerInputDeviceListener(InputDeviceListener inputDeviceListener, Handler handler) {
        InvokeDynamicSupport.bootstrap("registerInputDeviceListener", $$robo$$android_hardware_input_InputManager$registerInputDeviceListener(android.hardware.input.InputManager$InputDeviceListener android.os.Handler ), 0, this, inputDeviceListener, handler);
    }

    public void unregisterInputDeviceListener(InputDeviceListener inputDeviceListener) {
        InvokeDynamicSupport.bootstrap("unregisterInputDeviceListener", $$robo$$android_hardware_input_InputManager$unregisterInputDeviceListener(android.hardware.input.InputManager$InputDeviceListener ), 0, this, inputDeviceListener);
    }

    private int findInputDeviceListenerLocked(InputDeviceListener inputDeviceListener) {
        return (int)InvokeDynamicSupport.bootstrap("findInputDeviceListenerLocked", $$robo$$android_hardware_input_InputManager$findInputDeviceListenerLocked(android.hardware.input.InputManager$InputDeviceListener ), 0, this, inputDeviceListener);
    }

    public int isInTabletMode() {
        return (int)InvokeDynamicSupport.bootstrap("isInTabletMode", $$robo$$android_hardware_input_InputManager$isInTabletMode(), 0, this);
    }

    public void registerOnTabletModeChangedListener(OnTabletModeChangedListener onTabletModeChangedListener, Handler handler) {
        InvokeDynamicSupport.bootstrap("registerOnTabletModeChangedListener", $$robo$$android_hardware_input_InputManager$registerOnTabletModeChangedListener(android.hardware.input.InputManager$OnTabletModeChangedListener android.os.Handler ), 0, this, onTabletModeChangedListener, handler);
    }

    public void unregisterOnTabletModeChangedListener(OnTabletModeChangedListener onTabletModeChangedListener) {
        InvokeDynamicSupport.bootstrap("unregisterOnTabletModeChangedListener", $$robo$$android_hardware_input_InputManager$unregisterOnTabletModeChangedListener(android.hardware.input.InputManager$OnTabletModeChangedListener ), 0, this, onTabletModeChangedListener);
    }

    private void initializeTabletModeListenerLocked() {
        InvokeDynamicSupport.bootstrap("initializeTabletModeListenerLocked", $$robo$$android_hardware_input_InputManager$initializeTabletModeListenerLocked(), 0, this);
    }

    private int findOnTabletModeChangedListenerLocked(OnTabletModeChangedListener onTabletModeChangedListener) {
        return (int)InvokeDynamicSupport.bootstrap("findOnTabletModeChangedListenerLocked", $$robo$$android_hardware_input_InputManager$findOnTabletModeChangedListenerLocked(android.hardware.input.InputManager$OnTabletModeChangedListener ), 0, this, onTabletModeChangedListener);
    }

    public KeyboardLayout[] getKeyboardLayouts() {
        return InvokeDynamicSupport.bootstrap("getKeyboardLayouts", $$robo$$android_hardware_input_InputManager$getKeyboardLayouts(), 0, this);
    }

    public KeyboardLayout[] getKeyboardLayoutsForInputDevice(InputDeviceIdentifier inputDeviceIdentifier) {
        return InvokeDynamicSupport.bootstrap("getKeyboardLayoutsForInputDevice", $$robo$$android_hardware_input_InputManager$getKeyboardLayoutsForInputDevice(android.hardware.input.InputDeviceIdentifier ), 0, this, inputDeviceIdentifier);
    }

    public KeyboardLayout getKeyboardLayout(String string2) {
        return InvokeDynamicSupport.bootstrap("getKeyboardLayout", $$robo$$android_hardware_input_InputManager$getKeyboardLayout(java.lang.String ), 0, this, string2);
    }

    public String getCurrentKeyboardLayoutForInputDevice(InputDeviceIdentifier inputDeviceIdentifier) {
        return InvokeDynamicSupport.bootstrap("getCurrentKeyboardLayoutForInputDevice", $$robo$$android_hardware_input_InputManager$getCurrentKeyboardLayoutForInputDevice(android.hardware.input.InputDeviceIdentifier ), 0, this, inputDeviceIdentifier);
    }

    public void setCurrentKeyboardLayoutForInputDevice(InputDeviceIdentifier inputDeviceIdentifier, String string2) {
        InvokeDynamicSupport.bootstrap("setCurrentKeyboardLayoutForInputDevice", $$robo$$android_hardware_input_InputManager$setCurrentKeyboardLayoutForInputDevice(android.hardware.input.InputDeviceIdentifier java.lang.String ), 0, this, inputDeviceIdentifier, string2);
    }

    public String[] getEnabledKeyboardLayoutsForInputDevice(InputDeviceIdentifier inputDeviceIdentifier) {
        return InvokeDynamicSupport.bootstrap("getEnabledKeyboardLayoutsForInputDevice", $$robo$$android_hardware_input_InputManager$getEnabledKeyboardLayoutsForInputDevice(android.hardware.input.InputDeviceIdentifier ), 0, this, inputDeviceIdentifier);
    }

    public void addKeyboardLayoutForInputDevice(InputDeviceIdentifier inputDeviceIdentifier, String string2) {
        InvokeDynamicSupport.bootstrap("addKeyboardLayoutForInputDevice", $$robo$$android_hardware_input_InputManager$addKeyboardLayoutForInputDevice(android.hardware.input.InputDeviceIdentifier java.lang.String ), 0, this, inputDeviceIdentifier, string2);
    }

    public void removeKeyboardLayoutForInputDevice(InputDeviceIdentifier inputDeviceIdentifier, String string2) {
        InvokeDynamicSupport.bootstrap("removeKeyboardLayoutForInputDevice", $$robo$$android_hardware_input_InputManager$removeKeyboardLayoutForInputDevice(android.hardware.input.InputDeviceIdentifier java.lang.String ), 0, this, inputDeviceIdentifier, string2);
    }

    public KeyboardLayout getKeyboardLayoutForInputDevice(InputDeviceIdentifier inputDeviceIdentifier, InputMethodInfo inputMethodInfo, InputMethodSubtype inputMethodSubtype) {
        return InvokeDynamicSupport.bootstrap("getKeyboardLayoutForInputDevice", $$robo$$android_hardware_input_InputManager$getKeyboardLayoutForInputDevice(android.hardware.input.InputDeviceIdentifier android.view.inputmethod.InputMethodInfo android.view.inputmethod.InputMethodSubtype ), 0, this, inputDeviceIdentifier, inputMethodInfo, inputMethodSubtype);
    }

    public void setKeyboardLayoutForInputDevice(InputDeviceIdentifier inputDeviceIdentifier, InputMethodInfo inputMethodInfo, InputMethodSubtype inputMethodSubtype, String string2) {
        InvokeDynamicSupport.bootstrap("setKeyboardLayoutForInputDevice", $$robo$$android_hardware_input_InputManager$setKeyboardLayoutForInputDevice(android.hardware.input.InputDeviceIdentifier android.view.inputmethod.InputMethodInfo android.view.inputmethod.InputMethodSubtype java.lang.String ), 0, this, inputDeviceIdentifier, inputMethodInfo, inputMethodSubtype, string2);
    }

    public TouchCalibration getTouchCalibration(String string2, int n) {
        return InvokeDynamicSupport.bootstrap("getTouchCalibration", $$robo$$android_hardware_input_InputManager$getTouchCalibration(java.lang.String int ), 0, this, string2, n);
    }

    public void setTouchCalibration(String string2, int n, TouchCalibration touchCalibration) {
        InvokeDynamicSupport.bootstrap("setTouchCalibration", $$robo$$android_hardware_input_InputManager$setTouchCalibration(java.lang.String int android.hardware.input.TouchCalibration ), 0, this, string2, n, touchCalibration);
    }

    public int getPointerSpeed(Context context) {
        return (int)InvokeDynamicSupport.bootstrap("getPointerSpeed", $$robo$$android_hardware_input_InputManager$getPointerSpeed(android.content.Context ), 0, this, context);
    }

    public void setPointerSpeed(Context context, int n) {
        InvokeDynamicSupport.bootstrap("setPointerSpeed", $$robo$$android_hardware_input_InputManager$setPointerSpeed(android.content.Context int ), 0, this, context, n);
    }

    public void tryPointerSpeed(int n) {
        InvokeDynamicSupport.bootstrap("tryPointerSpeed", $$robo$$android_hardware_input_InputManager$tryPointerSpeed(int ), 0, this, n);
    }

    public boolean[] deviceHasKeys(int[] nArray) {
        return InvokeDynamicSupport.bootstrap("deviceHasKeys", $$robo$$android_hardware_input_InputManager$deviceHasKeys(int[] ), 0, this, nArray);
    }

    public boolean[] deviceHasKeys(int n, int[] nArray) {
        return InvokeDynamicSupport.bootstrap("deviceHasKeys", $$robo$$android_hardware_input_InputManager$deviceHasKeys(int int[] ), 0, this, n, nArray);
    }

    public boolean injectInputEvent(InputEvent inputEvent, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("injectInputEvent", $$robo$$android_hardware_input_InputManager$injectInputEvent(android.view.InputEvent int ), 0, this, inputEvent, n);
    }

    public void setPointerIconType(int n) {
        InvokeDynamicSupport.bootstrap("setPointerIconType", $$robo$$android_hardware_input_InputManager$setPointerIconType(int ), 0, this, n);
    }

    public void setCustomPointerIcon(PointerIcon pointerIcon) {
        InvokeDynamicSupport.bootstrap("setCustomPointerIcon", $$robo$$android_hardware_input_InputManager$setCustomPointerIcon(android.view.PointerIcon ), 0, this, pointerIcon);
    }

    public void requestPointerCapture(IBinder iBinder, boolean bl) {
        InvokeDynamicSupport.bootstrap("requestPointerCapture", $$robo$$android_hardware_input_InputManager$requestPointerCapture(android.os.IBinder boolean ), 0, this, iBinder, bl);
    }

    public IInputForwarder createInputForwarder(int n) {
        return InvokeDynamicSupport.bootstrap("createInputForwarder", $$robo$$android_hardware_input_InputManager$createInputForwarder(int ), 0, this, n);
    }

    private void populateInputDevicesLocked() {
        InvokeDynamicSupport.bootstrap("populateInputDevicesLocked", $$robo$$android_hardware_input_InputManager$populateInputDevicesLocked(), 0, this);
    }

    private void onInputDevicesChanged(int[] nArray) {
        InvokeDynamicSupport.bootstrap("onInputDevicesChanged", $$robo$$android_hardware_input_InputManager$onInputDevicesChanged(int[] ), 0, this, nArray);
    }

    private void sendMessageToInputDeviceListenersLocked(int n, int n2) {
        InvokeDynamicSupport.bootstrap("sendMessageToInputDeviceListenersLocked", $$robo$$android_hardware_input_InputManager$sendMessageToInputDeviceListenersLocked(int int ), 0, this, n, n2);
    }

    private static boolean containsDeviceId(int[] nArray, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("containsDeviceId", $$robo$$android_hardware_input_InputManager$containsDeviceId(int[] int ), 0, (int[])nArray, (int)n);
    }

    private void onTabletModeChanged(long l, boolean bl) {
        InvokeDynamicSupport.bootstrap("onTabletModeChanged", $$robo$$android_hardware_input_InputManager$onTabletModeChanged(long boolean ), 0, this, l, bl);
    }

    public Vibrator getInputDeviceVibrator(int n) {
        return InvokeDynamicSupport.bootstrap("getInputDeviceVibrator", $$robo$$android_hardware_input_InputManager$getInputDeviceVibrator(int ), 0, this, n);
    }

    public /* synthetic */ InputManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InputManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private final class InputDeviceVibrator
    extends Vibrator
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mDeviceId;
        private Binder mToken;
        /* synthetic */ InputManager this$0;

        private void $$robo$$android_hardware_input_InputManager_InputDeviceVibrator$__constructor__(InputManager inputManager, int deviceId) {
            this.mDeviceId = deviceId;
            this.mToken = new Binder();
        }

        private final boolean $$robo$$android_hardware_input_InputManager_InputDeviceVibrator$hasVibrator() {
            return true;
        }

        private final boolean $$robo$$android_hardware_input_InputManager_InputDeviceVibrator$hasAmplitudeControl() {
            return false;
        }

        private final void $$robo$$android_hardware_input_InputManager_InputDeviceVibrator$vibrate(int uid, String opPkg, VibrationEffect effect, AudioAttributes attributes) {
            int repeat;
            long[] pattern;
            if (effect instanceof VibrationEffect.OneShot) {
                VibrationEffect.OneShot oneShot = (VibrationEffect.OneShot)effect;
                pattern = new long[]{0L, oneShot.getTiming()};
                repeat = -1;
            } else if (effect instanceof VibrationEffect.Waveform) {
                VibrationEffect.Waveform waveform = (VibrationEffect.Waveform)effect;
                pattern = waveform.getTimings();
                repeat = waveform.getRepeatIndex();
            } else {
                Log.w("InputManager", "Pre-baked effects aren't supported on input devices");
                return;
            }
            try {
                this.this$0.mIm.vibrate(this.mDeviceId, pattern, repeat, this.mToken);
            }
            catch (RemoteException ex) {
                throw ex.rethrowFromSystemServer();
            }
        }

        private final void $$robo$$android_hardware_input_InputManager_InputDeviceVibrator$cancel() {
            try {
                this.this$0.mIm.cancelVibrate(this.mDeviceId, this.mToken);
            }
            catch (RemoteException ex) {
                throw ex.rethrowFromSystemServer();
            }
        }

        private void __constructor__(InputManager inputManager, int n) {
            this.$$robo$$android_hardware_input_InputManager_InputDeviceVibrator$__constructor__(inputManager, n);
        }

        public InputDeviceVibrator(InputManager inputManager, int n) {
            this.this$0 = inputManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_input_InputManager_InputDeviceVibrator$__constructor__(android.hardware.input.InputManager int ), 0, this, inputManager, n);
        }

        @Override
        public boolean hasVibrator() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasVibrator", $$robo$$android_hardware_input_InputManager_InputDeviceVibrator$hasVibrator(), 0, this);
        }

        @Override
        public boolean hasAmplitudeControl() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasAmplitudeControl", $$robo$$android_hardware_input_InputManager_InputDeviceVibrator$hasAmplitudeControl(), 0, this);
        }

        @Override
        public void vibrate(int n, String string2, VibrationEffect vibrationEffect, AudioAttributes audioAttributes) {
            InvokeDynamicSupport.bootstrap("vibrate", $$robo$$android_hardware_input_InputManager_InputDeviceVibrator$vibrate(int java.lang.String android.os.VibrationEffect android.media.AudioAttributes ), 0, this, n, string2, vibrationEffect, audioAttributes);
        }

        @Override
        public void cancel() {
            InvokeDynamicSupport.bootstrap("cancel", $$robo$$android_hardware_input_InputManager_InputDeviceVibrator$cancel(), 0, this);
        }

        public /* synthetic */ InputDeviceVibrator() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InputDeviceVibrator)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class OnTabletModeChangedListenerDelegate
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int MSG_TABLET_MODE_CHANGED = 0;
        public OnTabletModeChangedListener mListener;

        private void $$robo$$android_hardware_input_InputManager_OnTabletModeChangedListenerDelegate$__constructor__(OnTabletModeChangedListener listener, Handler handler) {
            this.mListener = listener;
        }

        private final void $$robo$$android_hardware_input_InputManager_OnTabletModeChangedListenerDelegate$sendTabletModeChanged(long whenNanos, boolean inTabletMode) {
            SomeArgs args = SomeArgs.obtain();
            args.argi1 = (int)(whenNanos & 0xFFFFFFFFFFFFFFFFL);
            args.argi2 = (int)(whenNanos >> 32);
            args.arg1 = inTabletMode;
            this.obtainMessage(0, args).sendToTarget();
        }

        private final void $$robo$$android_hardware_input_InputManager_OnTabletModeChangedListenerDelegate$handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    long whenNanos = (long)args.argi1 & 0xFFFFFFFFL | (long)args.argi2 << 32;
                    boolean inTabletMode = (Boolean)args.arg1;
                    this.mListener.onTabletModeChanged(whenNanos, inTabletMode);
                }
            }
        }

        private void __constructor__(OnTabletModeChangedListener onTabletModeChangedListener, Handler handler) {
            this.$$robo$$android_hardware_input_InputManager_OnTabletModeChangedListenerDelegate$__constructor__(onTabletModeChangedListener, handler);
        }

        public OnTabletModeChangedListenerDelegate(OnTabletModeChangedListener onTabletModeChangedListener, Handler handler) {
            super(handler != null ? handler.getLooper() : Looper.myLooper());
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_input_InputManager_OnTabletModeChangedListenerDelegate$__constructor__(android.hardware.input.InputManager$OnTabletModeChangedListener android.os.Handler ), 0, this, onTabletModeChangedListener, handler);
        }

        public void sendTabletModeChanged(long l, boolean bl) {
            InvokeDynamicSupport.bootstrap("sendTabletModeChanged", $$robo$$android_hardware_input_InputManager_OnTabletModeChangedListenerDelegate$sendTabletModeChanged(long boolean ), 0, this, l, bl);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_hardware_input_InputManager_OnTabletModeChangedListenerDelegate$handleMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ OnTabletModeChangedListenerDelegate() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OnTabletModeChangedListenerDelegate)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private final class TabletModeChangedListener
    extends ITabletModeChangedListener.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ InputManager this$0;

        private void $$robo$$android_hardware_input_InputManager_TabletModeChangedListener$__constructor__(InputManager inputManager) {
        }

        private final void $$robo$$android_hardware_input_InputManager_TabletModeChangedListener$onTabletModeChanged(long whenNanos, boolean inTabletMode) {
            this.this$0.onTabletModeChanged(whenNanos, inTabletMode);
        }

        private /* synthetic */ void $$robo$$android_hardware_input_InputManager_TabletModeChangedListener$__constructor__(InputManager x0, 1 x1) {
        }

        private void __constructor__(InputManager inputManager) {
            this.$$robo$$android_hardware_input_InputManager_TabletModeChangedListener$__constructor__(inputManager);
        }

        private TabletModeChangedListener(InputManager inputManager) {
            this.this$0 = inputManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_input_InputManager_TabletModeChangedListener$__constructor__(android.hardware.input.InputManager ), 0, this, inputManager);
        }

        @Override
        public void onTabletModeChanged(long l, boolean bl) {
            InvokeDynamicSupport.bootstrap("onTabletModeChanged", $$robo$$android_hardware_input_InputManager_TabletModeChangedListener$onTabletModeChanged(long boolean ), 0, this, l, bl);
        }

        private /* synthetic */ void __constructor__(InputManager inputManager, 1 var2_2) {
            this.$$robo$$android_hardware_input_InputManager_TabletModeChangedListener$__constructor__(inputManager, var2_2);
        }

        public /* synthetic */ TabletModeChangedListener() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TabletModeChangedListener)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnTabletModeChangedListener
    extends InstrumentedInterface {
        public void onTabletModeChanged(long var1, boolean var3);
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class InputDeviceListenerDelegate
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public InputDeviceListener mListener;

        private void $$robo$$android_hardware_input_InputManager_InputDeviceListenerDelegate$__constructor__(InputDeviceListener listener, Handler handler) {
            this.mListener = listener;
        }

        private final void $$robo$$android_hardware_input_InputManager_InputDeviceListenerDelegate$handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    this.mListener.onInputDeviceAdded(msg.arg1);
                    break;
                }
                case 2: {
                    this.mListener.onInputDeviceRemoved(msg.arg1);
                    break;
                }
                case 3: {
                    this.mListener.onInputDeviceChanged(msg.arg1);
                }
            }
        }

        private void __constructor__(InputDeviceListener inputDeviceListener, Handler handler) {
            this.$$robo$$android_hardware_input_InputManager_InputDeviceListenerDelegate$__constructor__(inputDeviceListener, handler);
        }

        public InputDeviceListenerDelegate(InputDeviceListener inputDeviceListener, Handler handler) {
            super(handler != null ? handler.getLooper() : Looper.myLooper());
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_input_InputManager_InputDeviceListenerDelegate$__constructor__(android.hardware.input.InputManager$InputDeviceListener android.os.Handler ), 0, this, inputDeviceListener, handler);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_hardware_input_InputManager_InputDeviceListenerDelegate$handleMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ InputDeviceListenerDelegate() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InputDeviceListenerDelegate)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private final class InputDevicesChangedListener
    extends IInputDevicesChangedListener.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ InputManager this$0;

        private void $$robo$$android_hardware_input_InputManager_InputDevicesChangedListener$__constructor__(InputManager inputManager) {
        }

        private final void $$robo$$android_hardware_input_InputManager_InputDevicesChangedListener$onInputDevicesChanged(int[] deviceIdAndGeneration) throws RemoteException {
            this.this$0.onInputDevicesChanged(deviceIdAndGeneration);
        }

        private /* synthetic */ void $$robo$$android_hardware_input_InputManager_InputDevicesChangedListener$__constructor__(InputManager x0, 1 x1) {
        }

        private void __constructor__(InputManager inputManager) {
            this.$$robo$$android_hardware_input_InputManager_InputDevicesChangedListener$__constructor__(inputManager);
        }

        private InputDevicesChangedListener(InputManager inputManager) {
            this.this$0 = inputManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_input_InputManager_InputDevicesChangedListener$__constructor__(android.hardware.input.InputManager ), 0, this, inputManager);
        }

        @Override
        public void onInputDevicesChanged(int[] nArray) throws RemoteException {
            InvokeDynamicSupport.bootstrap("onInputDevicesChanged", $$robo$$android_hardware_input_InputManager_InputDevicesChangedListener$onInputDevicesChanged(int[] ), 0, this, nArray);
        }

        private /* synthetic */ void __constructor__(InputManager inputManager, 1 var2_2) {
            this.$$robo$$android_hardware_input_InputManager_InputDevicesChangedListener$__constructor__(inputManager, var2_2);
        }

        public /* synthetic */ InputDevicesChangedListener() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InputDevicesChangedListener)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface InputDeviceListener
    extends InstrumentedInterface {
        public void onInputDeviceAdded(int var1);

        public void onInputDeviceRemoved(int var1);

        public void onInputDeviceChanged(int var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SwitchState {
    }
}

