/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.location;

import android.annotation.SuppressLint;
import android.content.Context;
import android.hardware.location.ContextHubInfo;
import android.hardware.location.ContextHubMessage;
import android.hardware.location.IContextHubCallback;
import android.hardware.location.IContextHubService;
import android.hardware.location.NanoApp;
import android.hardware.location.NanoAppFilter;
import android.hardware.location.NanoAppInstanceInfo;
import android.os.Handler;
import android.os.Looper;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class ContextHubManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "ContextHubManager";
    private Looper mMainLooper;
    private IContextHubService mService;
    private Callback mCallback;
    private Handler mCallbackHandler;
    @Deprecated
    private ICallback mLocalCallback;
    private IContextHubCallback.Stub mClientCallback;

    private final int[] $$robo$$android_hardware_location_ContextHubManager$getContextHubHandles() {
        try {
            return this.mService.getContextHubHandles();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final ContextHubInfo $$robo$$android_hardware_location_ContextHubManager$getContextHubInfo(int hubHandle) {
        try {
            return this.mService.getContextHubInfo(hubHandle);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_hardware_location_ContextHubManager$loadNanoApp(int hubHandle, NanoApp app) {
        try {
            return this.mService.loadNanoApp(hubHandle, app);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_hardware_location_ContextHubManager$unloadNanoApp(int nanoAppHandle) {
        try {
            return this.mService.unloadNanoApp(nanoAppHandle);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final NanoAppInstanceInfo $$robo$$android_hardware_location_ContextHubManager$getNanoAppInstanceInfo(int nanoAppHandle) {
        try {
            return this.mService.getNanoAppInstanceInfo(nanoAppHandle);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int[] $$robo$$android_hardware_location_ContextHubManager$findNanoAppOnHub(int hubHandle, NanoAppFilter filter) {
        try {
            return this.mService.findNanoAppOnHub(hubHandle, filter);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_hardware_location_ContextHubManager$sendMessage(int hubHandle, int nanoAppHandle, ContextHubMessage message) {
        try {
            return this.mService.sendMessage(hubHandle, nanoAppHandle, message);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SuppressLint(value={"Doclava125"})
    private final int $$robo$$android_hardware_location_ContextHubManager$registerCallback(Callback callback) {
        return this.registerCallback(callback, null);
    }

    @Deprecated
    private final int $$robo$$android_hardware_location_ContextHubManager$registerCallback(ICallback callback) {
        if (this.mLocalCallback != null) {
            Log.w("ContextHubManager", "Max number of local callbacks reached!");
            return -1;
        }
        this.mLocalCallback = callback;
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"Doclava125"})
    private final int $$robo$$android_hardware_location_ContextHubManager$registerCallback(Callback callback, Handler handler) {
        ContextHubManager contextHubManager = this;
        synchronized (contextHubManager) {
            if (this.mCallback != null) {
                Log.w("ContextHubManager", "Max number of callbacks reached!");
                return -1;
            }
            this.mCallback = callback;
            this.mCallbackHandler = handler;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"Doclava125"})
    private final int $$robo$$android_hardware_location_ContextHubManager$unregisterCallback(Callback callback) {
        ContextHubManager contextHubManager = this;
        synchronized (contextHubManager) {
            if (callback != this.mCallback) {
                Log.w("ContextHubManager", "Cannot recognize callback!");
                return -1;
            }
            this.mCallback = null;
            this.mCallbackHandler = null;
        }
        return 0;
    }

    @Deprecated
    private final synchronized int $$robo$$android_hardware_location_ContextHubManager$unregisterCallback(ICallback callback) {
        if (callback != this.mLocalCallback) {
            Log.w("ContextHubManager", "Cannot recognize local callback!");
            return -1;
        }
        this.mLocalCallback = null;
        return 0;
    }

    private void $$robo$$android_hardware_location_ContextHubManager$__constructor__(Context context, Looper mainLooper) throws ServiceManager.ServiceNotFoundException {
        this.mClientCallback = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ContextHubManager this$0;

            private void $$robo$$android_hardware_location_ContextHubManager_1$__constructor__(ContextHubManager this$0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_hardware_location_ContextHubManager_1$onMessageReceipt(int hubId, int nanoAppId, ContextHubMessage message) {
                if (this.this$0.mCallback != null) {
                    1 var4_4 = this;
                    synchronized (var4_4) {
                        Callback callback = this.this$0.mCallback;
                        Handler handler = this.this$0.mCallbackHandler == null ? new Handler(this.this$0.mMainLooper) : this.this$0.mCallbackHandler;
                        handler.post(new Runnable(this, callback, hubId, nanoAppId, message){
                            public transient /* synthetic */ Object __robo_data__;
                            /* synthetic */ Callback val$callback;
                            /* synthetic */ int val$hubId;
                            /* synthetic */ int val$nanoAppId;
                            /* synthetic */ ContextHubMessage val$message;
                            /* synthetic */ 1 this$1;

                            private void $$robo$$android_hardware_location_ContextHubManager_1_1$__constructor__(1 this$1, Callback callback, int n, int n2, ContextHubMessage contextHubMessage) {
                            }

                            private final void $$robo$$android_hardware_location_ContextHubManager_1_1$run() {
                                this.val$callback.onMessageReceipt(this.val$hubId, this.val$nanoAppId, this.val$message);
                            }

                            private void __constructor__(1 var1_1, Callback callback, int n, int n2, ContextHubMessage contextHubMessage) {
                                this.$$robo$$android_hardware_location_ContextHubManager_1_1$__constructor__(var1_1, callback, n, n2, contextHubMessage);
                            }
                            {
                                this.this$1 = var1_1;
                                this.val$callback = callback;
                                this.val$hubId = n;
                                this.val$nanoAppId = n2;
                                this.val$message = contextHubMessage;
                                this.$$robo$init();
                                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_location_ContextHubManager_1_1$__constructor__(android.hardware.location.ContextHubManager$1 android.hardware.location.ContextHubManager$Callback int int android.hardware.location.ContextHubMessage ), 0, this, var1_1, callback, n, n2, contextHubMessage);
                            }

                            @Override
                            public void run() {
                                InvokeDynamicSupport.bootstrap("run", $$robo$$android_hardware_location_ContextHubManager_1_1$run(), 0, this);
                            }
                            {
                                this.$$robo$init();
                            }

                            protected /* synthetic */ void $$robo$init() {
                                if (this.__robo_data__ == null) {
                                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                                }
                            }

                            public /* synthetic */ Object $$robo$getData() {
                                return this.__robo_data__;
                            }
                        });
                    }
                } else if (this.this$0.mLocalCallback != null) {
                    1 var4_5 = this;
                    synchronized (var4_5) {
                        this.this$0.mLocalCallback.onMessageReceipt(hubId, nanoAppId, message);
                    }
                } else {
                    Log.d("ContextHubManager", "Context hub manager client callback is NULL");
                }
            }

            private void __constructor__(ContextHubManager contextHubManager) {
                this.$$robo$$android_hardware_location_ContextHubManager_1$__constructor__(contextHubManager);
            }
            {
                this.this$0 = contextHubManager;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_location_ContextHubManager_1$__constructor__(android.hardware.location.ContextHubManager ), 0, this, contextHubManager);
            }

            @Override
            public void onMessageReceipt(int n, int n2, ContextHubMessage contextHubMessage) {
                InvokeDynamicSupport.bootstrap("onMessageReceipt", $$robo$$android_hardware_location_ContextHubManager_1$onMessageReceipt(int int android.hardware.location.ContextHubMessage ), 0, this, n, n2, contextHubMessage);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mMainLooper = mainLooper;
        this.mService = IContextHubService.Stub.asInterface(ServiceManager.getServiceOrThrow("contexthub"));
        try {
            this.mService.registerCallback(this.mClientCallback);
        }
        catch (RemoteException e) {
            Log.w("ContextHubManager", "Could not register callback:" + e);
        }
    }

    public int[] getContextHubHandles() {
        return InvokeDynamicSupport.bootstrap("getContextHubHandles", $$robo$$android_hardware_location_ContextHubManager$getContextHubHandles(), 0, this);
    }

    public ContextHubInfo getContextHubInfo(int n) {
        return InvokeDynamicSupport.bootstrap("getContextHubInfo", $$robo$$android_hardware_location_ContextHubManager$getContextHubInfo(int ), 0, this, n);
    }

    public int loadNanoApp(int n, NanoApp nanoApp) {
        return (int)InvokeDynamicSupport.bootstrap("loadNanoApp", $$robo$$android_hardware_location_ContextHubManager$loadNanoApp(int android.hardware.location.NanoApp ), 0, this, n, nanoApp);
    }

    public int unloadNanoApp(int n) {
        return (int)InvokeDynamicSupport.bootstrap("unloadNanoApp", $$robo$$android_hardware_location_ContextHubManager$unloadNanoApp(int ), 0, this, n);
    }

    public NanoAppInstanceInfo getNanoAppInstanceInfo(int n) {
        return InvokeDynamicSupport.bootstrap("getNanoAppInstanceInfo", $$robo$$android_hardware_location_ContextHubManager$getNanoAppInstanceInfo(int ), 0, this, n);
    }

    public int[] findNanoAppOnHub(int n, NanoAppFilter nanoAppFilter) {
        return InvokeDynamicSupport.bootstrap("findNanoAppOnHub", $$robo$$android_hardware_location_ContextHubManager$findNanoAppOnHub(int android.hardware.location.NanoAppFilter ), 0, this, n, nanoAppFilter);
    }

    public int sendMessage(int n, int n2, ContextHubMessage contextHubMessage) {
        return (int)InvokeDynamicSupport.bootstrap("sendMessage", $$robo$$android_hardware_location_ContextHubManager$sendMessage(int int android.hardware.location.ContextHubMessage ), 0, this, n, n2, contextHubMessage);
    }

    public int registerCallback(Callback callback) {
        return (int)InvokeDynamicSupport.bootstrap("registerCallback", $$robo$$android_hardware_location_ContextHubManager$registerCallback(android.hardware.location.ContextHubManager$Callback ), 0, this, callback);
    }

    @Deprecated
    public int registerCallback(ICallback iCallback) {
        return (int)InvokeDynamicSupport.bootstrap("registerCallback", $$robo$$android_hardware_location_ContextHubManager$registerCallback(android.hardware.location.ContextHubManager$ICallback ), 0, this, iCallback);
    }

    public int registerCallback(Callback callback, Handler handler) {
        return (int)InvokeDynamicSupport.bootstrap("registerCallback", $$robo$$android_hardware_location_ContextHubManager$registerCallback(android.hardware.location.ContextHubManager$Callback android.os.Handler ), 0, this, callback, handler);
    }

    public int unregisterCallback(Callback callback) {
        return (int)InvokeDynamicSupport.bootstrap("unregisterCallback", $$robo$$android_hardware_location_ContextHubManager$unregisterCallback(android.hardware.location.ContextHubManager$Callback ), 0, this, callback);
    }

    @Deprecated
    public synchronized int unregisterCallback(ICallback iCallback) {
        return (int)InvokeDynamicSupport.bootstrap("unregisterCallback", $$robo$$android_hardware_location_ContextHubManager$unregisterCallback(android.hardware.location.ContextHubManager$ICallback ), 0, this, iCallback);
    }

    private void __constructor__(Context context, Looper looper) throws ServiceManager.ServiceNotFoundException {
        this.$$robo$$android_hardware_location_ContextHubManager$__constructor__(context, looper);
    }

    public ContextHubManager(Context context, Looper looper) throws ServiceManager.ServiceNotFoundException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_location_ContextHubManager$__constructor__(android.content.Context android.os.Looper ), 0, this, context, looper);
    }

    public /* synthetic */ ContextHubManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ContextHubManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @Deprecated
    public static interface ICallback
    extends InstrumentedInterface {
        public void onMessageReceipt(int var1, int var2, ContextHubMessage var3);
    }

    public static abstract class Callback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_hardware_location_ContextHubManager_Callback$__constructor__() {
        }

        public abstract void onMessageReceipt(int var1, int var2, ContextHubMessage var3);

        private void __constructor__() {
            this.$$robo$$android_hardware_location_ContextHubManager_Callback$__constructor__();
        }

        protected Callback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_location_ContextHubManager_Callback$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Callback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

