/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArrayMap;
import android.util.Log;
import android.util.SparseArray;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Set;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class RadioMetadata
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "BroadcastRadio.metadata";
    public static String METADATA_KEY_RDS_PI = "android.hardware.radio.metadata.RDS_PI";
    public static String METADATA_KEY_RDS_PS = "android.hardware.radio.metadata.RDS_PS";
    public static String METADATA_KEY_RDS_PTY = "android.hardware.radio.metadata.RDS_PTY";
    public static String METADATA_KEY_RBDS_PTY = "android.hardware.radio.metadata.RBDS_PTY";
    public static String METADATA_KEY_RDS_RT = "android.hardware.radio.metadata.RDS_RT";
    public static String METADATA_KEY_TITLE = "android.hardware.radio.metadata.TITLE";
    public static String METADATA_KEY_ARTIST = "android.hardware.radio.metadata.ARTIST";
    public static String METADATA_KEY_ALBUM = "android.hardware.radio.metadata.ALBUM";
    public static String METADATA_KEY_GENRE = "android.hardware.radio.metadata.GENRE";
    public static String METADATA_KEY_ICON = "android.hardware.radio.metadata.ICON";
    public static String METADATA_KEY_ART = "android.hardware.radio.metadata.ART";
    public static String METADATA_KEY_CLOCK = "android.hardware.radio.metadata.CLOCK";
    private static int METADATA_TYPE_INVALID = -1;
    private static int METADATA_TYPE_INT = 0;
    private static int METADATA_TYPE_TEXT = 1;
    private static int METADATA_TYPE_BITMAP = 2;
    private static int METADATA_TYPE_CLOCK = 3;
    private static ArrayMap<String, Integer> METADATA_KEYS_TYPE;
    private static int NATIVE_KEY_INVALID = -1;
    private static int NATIVE_KEY_RDS_PI = 0;
    private static int NATIVE_KEY_RDS_PS = 1;
    private static int NATIVE_KEY_RDS_PTY = 2;
    private static int NATIVE_KEY_RBDS_PTY = 3;
    private static int NATIVE_KEY_RDS_RT = 4;
    private static int NATIVE_KEY_TITLE = 5;
    private static int NATIVE_KEY_ARTIST = 6;
    private static int NATIVE_KEY_ALBUM = 7;
    private static int NATIVE_KEY_GENRE = 8;
    private static int NATIVE_KEY_ICON = 9;
    private static int NATIVE_KEY_ART = 10;
    private static int NATIVE_KEY_CLOCK = 11;
    private static SparseArray<String> NATIVE_KEY_MAPPING;
    private Bundle mBundle;
    public static Parcelable.Creator<RadioMetadata> CREATOR;

    private void $$robo$$android_hardware_radio_RadioMetadata$__constructor__() {
        this.mBundle = new Bundle();
    }

    private void $$robo$$android_hardware_radio_RadioMetadata$__constructor__(Bundle bundle) {
        this.mBundle = new Bundle(bundle);
    }

    private void $$robo$$android_hardware_radio_RadioMetadata$__constructor__(Parcel in) {
        this.mBundle = in.readBundle();
    }

    private final boolean $$robo$$android_hardware_radio_RadioMetadata$containsKey(String key) {
        return this.mBundle.containsKey(key);
    }

    private final String $$robo$$android_hardware_radio_RadioMetadata$getString(String key) {
        return this.mBundle.getString(key);
    }

    private static final void $$robo$$android_hardware_radio_RadioMetadata$putInt(Bundle bundle, String key, int value) {
        int type = METADATA_KEYS_TYPE.getOrDefault(key, -1);
        if (type != 0 && type != 2) {
            throw new IllegalArgumentException("The " + key + " key cannot be used to put an int");
        }
        bundle.putInt(key, value);
    }

    private final int $$robo$$android_hardware_radio_RadioMetadata$getInt(String key) {
        return this.mBundle.getInt(key, 0);
    }

    @Deprecated
    private final Bitmap $$robo$$android_hardware_radio_RadioMetadata$getBitmap(String key) {
        Bitmap bmp = null;
        try {
            bmp = (Bitmap)this.mBundle.getParcelable(key);
        }
        catch (Exception e) {
            Log.w("BroadcastRadio.metadata", "Failed to retrieve a key as Bitmap.", e);
        }
        return bmp;
    }

    private final int $$robo$$android_hardware_radio_RadioMetadata$getBitmapId(String key) {
        if (!"android.hardware.radio.metadata.ICON".equals(key) && !"android.hardware.radio.metadata.ART".equals(key)) {
            return 0;
        }
        return this.getInt(key);
    }

    private final Clock $$robo$$android_hardware_radio_RadioMetadata$getClock(String key) {
        Clock clock = null;
        try {
            clock = (Clock)this.mBundle.getParcelable(key);
        }
        catch (Exception e) {
            Log.w("BroadcastRadio.metadata", "Failed to retrieve a key as Clock.", e);
        }
        return clock;
    }

    private final int $$robo$$android_hardware_radio_RadioMetadata$describeContents() {
        return 0;
    }

    private final void $$robo$$android_hardware_radio_RadioMetadata$writeToParcel(Parcel dest, int flags) {
        dest.writeBundle(this.mBundle);
    }

    private final int $$robo$$android_hardware_radio_RadioMetadata$size() {
        return this.mBundle.size();
    }

    private final Set<String> $$robo$$android_hardware_radio_RadioMetadata$keySet() {
        return this.mBundle.keySet();
    }

    private static final String $$robo$$android_hardware_radio_RadioMetadata$getKeyFromNativeKey(int nativeKey) {
        return NATIVE_KEY_MAPPING.get(nativeKey, null);
    }

    private final int $$robo$$android_hardware_radio_RadioMetadata$putIntFromNative(int nativeKey, int value) {
        String key = RadioMetadata.getKeyFromNativeKey(nativeKey);
        try {
            RadioMetadata.putInt(this.mBundle, key, value);
            return 0;
        }
        catch (IllegalArgumentException ex) {
            return -1;
        }
    }

    private final int $$robo$$android_hardware_radio_RadioMetadata$putStringFromNative(int nativeKey, String value) {
        String key = RadioMetadata.getKeyFromNativeKey(nativeKey);
        if (!METADATA_KEYS_TYPE.containsKey(key) || METADATA_KEYS_TYPE.get(key) != 1) {
            return -1;
        }
        this.mBundle.putString(key, value);
        return 0;
    }

    private final int $$robo$$android_hardware_radio_RadioMetadata$putBitmapFromNative(int nativeKey, byte[] value) {
        String key = RadioMetadata.getKeyFromNativeKey(nativeKey);
        if (!METADATA_KEYS_TYPE.containsKey(key) || METADATA_KEYS_TYPE.get(key) != 2) {
            return -1;
        }
        Bitmap bmp = null;
        try {
            bmp = BitmapFactory.decodeByteArray(value, 0, value.length);
            if (bmp != null) {
                this.mBundle.putParcelable(key, bmp);
                return 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    private final int $$robo$$android_hardware_radio_RadioMetadata$putClockFromNative(int nativeKey, long utcEpochSeconds, int timezoneOffsetInMinutes) {
        String key = RadioMetadata.getKeyFromNativeKey(nativeKey);
        if (!METADATA_KEYS_TYPE.containsKey(key) || METADATA_KEYS_TYPE.get(key) != 3) {
            return -1;
        }
        this.mBundle.putParcelable(key, new Clock(utcEpochSeconds, timezoneOffsetInMinutes));
        return 0;
    }

    private /* synthetic */ void $$robo$$android_hardware_radio_RadioMetadata$__constructor__(Parcel x0, 1 x1) {
    }

    private /* synthetic */ void $$robo$$android_hardware_radio_RadioMetadata$__constructor__(Bundle x0, 1 x1) {
    }

    static void __staticInitializer__() {
        METADATA_KEYS_TYPE = new ArrayMap();
        METADATA_KEYS_TYPE.put("android.hardware.radio.metadata.RDS_PI", 0);
        METADATA_KEYS_TYPE.put("android.hardware.radio.metadata.RDS_PS", 1);
        METADATA_KEYS_TYPE.put("android.hardware.radio.metadata.RDS_PTY", 0);
        METADATA_KEYS_TYPE.put("android.hardware.radio.metadata.RBDS_PTY", 0);
        METADATA_KEYS_TYPE.put("android.hardware.radio.metadata.RDS_RT", 1);
        METADATA_KEYS_TYPE.put("android.hardware.radio.metadata.TITLE", 1);
        METADATA_KEYS_TYPE.put("android.hardware.radio.metadata.ARTIST", 1);
        METADATA_KEYS_TYPE.put("android.hardware.radio.metadata.ALBUM", 1);
        METADATA_KEYS_TYPE.put("android.hardware.radio.metadata.GENRE", 1);
        METADATA_KEYS_TYPE.put("android.hardware.radio.metadata.ICON", 2);
        METADATA_KEYS_TYPE.put("android.hardware.radio.metadata.ART", 2);
        METADATA_KEYS_TYPE.put("android.hardware.radio.metadata.CLOCK", 3);
        NATIVE_KEY_MAPPING = new SparseArray();
        NATIVE_KEY_MAPPING.put(0, "android.hardware.radio.metadata.RDS_PI");
        NATIVE_KEY_MAPPING.put(1, "android.hardware.radio.metadata.RDS_PS");
        NATIVE_KEY_MAPPING.put(2, "android.hardware.radio.metadata.RDS_PTY");
        NATIVE_KEY_MAPPING.put(3, "android.hardware.radio.metadata.RBDS_PTY");
        NATIVE_KEY_MAPPING.put(4, "android.hardware.radio.metadata.RDS_RT");
        NATIVE_KEY_MAPPING.put(5, "android.hardware.radio.metadata.TITLE");
        NATIVE_KEY_MAPPING.put(6, "android.hardware.radio.metadata.ARTIST");
        NATIVE_KEY_MAPPING.put(7, "android.hardware.radio.metadata.ALBUM");
        NATIVE_KEY_MAPPING.put(8, "android.hardware.radio.metadata.GENRE");
        NATIVE_KEY_MAPPING.put(9, "android.hardware.radio.metadata.ICON");
        NATIVE_KEY_MAPPING.put(10, "android.hardware.radio.metadata.ART");
        NATIVE_KEY_MAPPING.put(11, "android.hardware.radio.metadata.CLOCK");
        CREATOR = new Parcelable.Creator<RadioMetadata>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_hardware_radio_RadioMetadata_1$__constructor__() {
            }

            private final RadioMetadata $$robo$$android_hardware_radio_RadioMetadata_1$createFromParcel(Parcel in) {
                return new RadioMetadata(in);
            }

            private final RadioMetadata[] $$robo$$android_hardware_radio_RadioMetadata_1$newArray(int size) {
                return new RadioMetadata[size];
            }

            private void __constructor__() {
                this.$$robo$$android_hardware_radio_RadioMetadata_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_RadioMetadata_1$__constructor__(), 0, this);
            }

            @Override
            public RadioMetadata createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_hardware_radio_RadioMetadata_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public RadioMetadata[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_hardware_radio_RadioMetadata_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$android_hardware_radio_RadioMetadata$__constructor__();
    }

    RadioMetadata() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_RadioMetadata$__constructor__(), 0, this);
    }

    private void __constructor__(Bundle bundle) {
        this.$$robo$$android_hardware_radio_RadioMetadata$__constructor__(bundle);
    }

    private RadioMetadata(Bundle bundle) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_RadioMetadata$__constructor__(android.os.Bundle ), 0, this, bundle);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_hardware_radio_RadioMetadata$__constructor__(parcel);
    }

    private RadioMetadata(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_RadioMetadata$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    public boolean containsKey(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("containsKey", $$robo$$android_hardware_radio_RadioMetadata$containsKey(java.lang.String ), 0, this, string2);
    }

    public String getString(String string2) {
        return InvokeDynamicSupport.bootstrap("getString", $$robo$$android_hardware_radio_RadioMetadata$getString(java.lang.String ), 0, this, string2);
    }

    private static void putInt(Bundle bundle, String string2, int n) {
        InvokeDynamicSupport.bootstrapStatic("putInt", $$robo$$android_hardware_radio_RadioMetadata$putInt(android.os.Bundle java.lang.String int ), 0, (Bundle)bundle, (String)string2, (int)n);
    }

    public int getInt(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("getInt", $$robo$$android_hardware_radio_RadioMetadata$getInt(java.lang.String ), 0, this, string2);
    }

    @Deprecated
    public Bitmap getBitmap(String string2) {
        return InvokeDynamicSupport.bootstrap("getBitmap", $$robo$$android_hardware_radio_RadioMetadata$getBitmap(java.lang.String ), 0, this, string2);
    }

    public int getBitmapId(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("getBitmapId", $$robo$$android_hardware_radio_RadioMetadata$getBitmapId(java.lang.String ), 0, this, string2);
    }

    public Clock getClock(String string2) {
        return InvokeDynamicSupport.bootstrap("getClock", $$robo$$android_hardware_radio_RadioMetadata$getClock(java.lang.String ), 0, this, string2);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_hardware_radio_RadioMetadata$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_hardware_radio_RadioMetadata$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    public int size() {
        return (int)InvokeDynamicSupport.bootstrap("size", $$robo$$android_hardware_radio_RadioMetadata$size(), 0, this);
    }

    public Set<String> keySet() {
        return InvokeDynamicSupport.bootstrap("keySet", $$robo$$android_hardware_radio_RadioMetadata$keySet(), 0, this);
    }

    public static String getKeyFromNativeKey(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getKeyFromNativeKey", $$robo$$android_hardware_radio_RadioMetadata$getKeyFromNativeKey(int ), 0, (int)n);
    }

    int putIntFromNative(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("putIntFromNative", $$robo$$android_hardware_radio_RadioMetadata$putIntFromNative(int int ), 0, this, n, n2);
    }

    int putStringFromNative(int n, String string2) {
        return (int)InvokeDynamicSupport.bootstrap("putStringFromNative", $$robo$$android_hardware_radio_RadioMetadata$putStringFromNative(int java.lang.String ), 0, this, n, string2);
    }

    int putBitmapFromNative(int n, byte[] byArray) {
        return (int)InvokeDynamicSupport.bootstrap("putBitmapFromNative", $$robo$$android_hardware_radio_RadioMetadata$putBitmapFromNative(int byte[] ), 0, this, n, byArray);
    }

    int putClockFromNative(int n, long l, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("putClockFromNative", $$robo$$android_hardware_radio_RadioMetadata$putClockFromNative(int long int ), 0, this, n, l, n2);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_hardware_radio_RadioMetadata$__constructor__(parcel, var2_2);
    }

    private /* synthetic */ void __constructor__(Bundle bundle, 1 var2_2) {
        this.$$robo$$android_hardware_radio_RadioMetadata$__constructor__(bundle, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(RadioMetadata.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RadioMetadata)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class Builder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Bundle mBundle;

        private void $$robo$$android_hardware_radio_RadioMetadata_Builder$__constructor__() {
            this.mBundle = new Bundle();
        }

        private void $$robo$$android_hardware_radio_RadioMetadata_Builder$__constructor__(RadioMetadata source) {
            this.mBundle = new Bundle(source.mBundle);
        }

        private void $$robo$$android_hardware_radio_RadioMetadata_Builder$__constructor__(RadioMetadata source, int maxBitmapSize) {
            for (String key : this.mBundle.keySet()) {
                Bitmap bmp;
                Object value = this.mBundle.get(key);
                if (value == null || !(value instanceof Bitmap) || (bmp = (Bitmap)value).getHeight() <= maxBitmapSize && bmp.getWidth() <= maxBitmapSize) continue;
                this.putBitmap(key, this.scaleBitmap(bmp, maxBitmapSize));
            }
        }

        private final Builder $$robo$$android_hardware_radio_RadioMetadata_Builder$putString(String key, String value) {
            if (!METADATA_KEYS_TYPE.containsKey(key) || (Integer)METADATA_KEYS_TYPE.get(key) != 1) {
                throw new IllegalArgumentException("The " + key + " key cannot be used to put a String");
            }
            this.mBundle.putString(key, value);
            return this;
        }

        private final Builder $$robo$$android_hardware_radio_RadioMetadata_Builder$putInt(String key, int value) {
            RadioMetadata.putInt(this.mBundle, key, value);
            return this;
        }

        private final Builder $$robo$$android_hardware_radio_RadioMetadata_Builder$putBitmap(String key, Bitmap value) {
            if (!METADATA_KEYS_TYPE.containsKey(key) || (Integer)METADATA_KEYS_TYPE.get(key) != 2) {
                throw new IllegalArgumentException("The " + key + " key cannot be used to put a Bitmap");
            }
            this.mBundle.putParcelable(key, value);
            return this;
        }

        private final Builder $$robo$$android_hardware_radio_RadioMetadata_Builder$putClock(String key, long utcSecondsSinceEpoch, int timezoneOffsetMinutes) {
            if (!METADATA_KEYS_TYPE.containsKey(key) || (Integer)METADATA_KEYS_TYPE.get(key) != 3) {
                throw new IllegalArgumentException("The " + key + " key cannot be used to put a RadioMetadata.Clock.");
            }
            this.mBundle.putParcelable(key, new Clock(utcSecondsSinceEpoch, timezoneOffsetMinutes));
            return this;
        }

        private final RadioMetadata $$robo$$android_hardware_radio_RadioMetadata_Builder$build() {
            return new RadioMetadata(this.mBundle);
        }

        private final Bitmap $$robo$$android_hardware_radio_RadioMetadata_Builder$scaleBitmap(Bitmap bmp, int maxSize) {
            float maxSizeF = maxSize;
            float widthScale = maxSizeF / (float)bmp.getWidth();
            float heightScale = maxSizeF / (float)bmp.getHeight();
            float scale = Math.min(widthScale, heightScale);
            int height = (int)((float)bmp.getHeight() * scale);
            int width = (int)((float)bmp.getWidth() * scale);
            return Bitmap.createScaledBitmap(bmp, width, height, true);
        }

        private void __constructor__() {
            this.$$robo$$android_hardware_radio_RadioMetadata_Builder$__constructor__();
        }

        public Builder() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_RadioMetadata_Builder$__constructor__(), 0, this);
        }

        private void __constructor__(RadioMetadata radioMetadata) {
            this.$$robo$$android_hardware_radio_RadioMetadata_Builder$__constructor__(radioMetadata);
        }

        public Builder(RadioMetadata radioMetadata) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_RadioMetadata_Builder$__constructor__(android.hardware.radio.RadioMetadata ), 0, this, radioMetadata);
        }

        private void __constructor__(RadioMetadata radioMetadata, int n) {
            this.$$robo$$android_hardware_radio_RadioMetadata_Builder$__constructor__(radioMetadata, n);
        }

        public Builder(RadioMetadata radioMetadata, int n) {
            this(radioMetadata);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_RadioMetadata_Builder$__constructor__(android.hardware.radio.RadioMetadata int ), 0, this, radioMetadata, n);
        }

        public Builder putString(String string2, String string3) {
            return InvokeDynamicSupport.bootstrap("putString", $$robo$$android_hardware_radio_RadioMetadata_Builder$putString(java.lang.String java.lang.String ), 0, this, string2, string3);
        }

        public Builder putInt(String string2, int n) {
            return InvokeDynamicSupport.bootstrap("putInt", $$robo$$android_hardware_radio_RadioMetadata_Builder$putInt(java.lang.String int ), 0, this, string2, n);
        }

        public Builder putBitmap(String string2, Bitmap bitmap) {
            return InvokeDynamicSupport.bootstrap("putBitmap", $$robo$$android_hardware_radio_RadioMetadata_Builder$putBitmap(java.lang.String android.graphics.Bitmap ), 0, this, string2, bitmap);
        }

        public Builder putClock(String string2, long l, int n) {
            return InvokeDynamicSupport.bootstrap("putClock", $$robo$$android_hardware_radio_RadioMetadata_Builder$putClock(java.lang.String long int ), 0, this, string2, l, n);
        }

        public RadioMetadata build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_hardware_radio_RadioMetadata_Builder$build(), 0, this);
        }

        private Bitmap scaleBitmap(Bitmap bitmap, int n) {
            return InvokeDynamicSupport.bootstrap("scaleBitmap", $$robo$$android_hardware_radio_RadioMetadata_Builder$scaleBitmap(android.graphics.Bitmap int ), 0, this, bitmap, n);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class Clock
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private long mUtcEpochSeconds;
        private int mTimezoneOffsetMinutes;
        public static Parcelable.Creator<Clock> CREATOR;

        private final int $$robo$$android_hardware_radio_RadioMetadata_Clock$describeContents() {
            return 0;
        }

        private final void $$robo$$android_hardware_radio_RadioMetadata_Clock$writeToParcel(Parcel out, int flags) {
            out.writeLong(this.mUtcEpochSeconds);
            out.writeInt(this.mTimezoneOffsetMinutes);
        }

        private void $$robo$$android_hardware_radio_RadioMetadata_Clock$__constructor__(long utcEpochSeconds, int timezoneOffsetMinutes) {
            this.mUtcEpochSeconds = utcEpochSeconds;
            this.mTimezoneOffsetMinutes = timezoneOffsetMinutes;
        }

        private void $$robo$$android_hardware_radio_RadioMetadata_Clock$__constructor__(Parcel in) {
            this.mUtcEpochSeconds = in.readLong();
            this.mTimezoneOffsetMinutes = in.readInt();
        }

        private final long $$robo$$android_hardware_radio_RadioMetadata_Clock$getUtcEpochSeconds() {
            return this.mUtcEpochSeconds;
        }

        private final int $$robo$$android_hardware_radio_RadioMetadata_Clock$getTimezoneOffsetMinutes() {
            return this.mTimezoneOffsetMinutes;
        }

        private /* synthetic */ void $$robo$$android_hardware_radio_RadioMetadata_Clock$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<Clock>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_hardware_radio_RadioMetadata_Clock_1$__constructor__() {
                }

                private final Clock $$robo$$android_hardware_radio_RadioMetadata_Clock_1$createFromParcel(Parcel in) {
                    return new Clock(in);
                }

                private final Clock[] $$robo$$android_hardware_radio_RadioMetadata_Clock_1$newArray(int size) {
                    return new Clock[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_hardware_radio_RadioMetadata_Clock_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_RadioMetadata_Clock_1$__constructor__(), 0, this);
                }

                @Override
                public Clock createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_hardware_radio_RadioMetadata_Clock_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public Clock[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_hardware_radio_RadioMetadata_Clock_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_hardware_radio_RadioMetadata_Clock$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_hardware_radio_RadioMetadata_Clock$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        private void __constructor__(long l, int n) {
            this.$$robo$$android_hardware_radio_RadioMetadata_Clock$__constructor__(l, n);
        }

        public Clock(long l, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_RadioMetadata_Clock$__constructor__(long int ), 0, this, l, n);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_hardware_radio_RadioMetadata_Clock$__constructor__(parcel);
        }

        private Clock(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_RadioMetadata_Clock$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        public long getUtcEpochSeconds() {
            return (long)InvokeDynamicSupport.bootstrap("getUtcEpochSeconds", $$robo$$android_hardware_radio_RadioMetadata_Clock$getUtcEpochSeconds(), 0, this);
        }

        public int getTimezoneOffsetMinutes() {
            return (int)InvokeDynamicSupport.bootstrap("getTimezoneOffsetMinutes", $$robo$$android_hardware_radio_RadioMetadata_Clock$getTimezoneOffsetMinutes(), 0, this);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_hardware_radio_RadioMetadata_Clock$__constructor__(parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(Clock.class);
        }

        public /* synthetic */ Clock() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Clock)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

