/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio;

import android.graphics.Bitmap;
import android.hardware.radio.ITuner;
import android.hardware.radio.ProgramSelector;
import android.hardware.radio.RadioManager;
import android.hardware.radio.RadioTuner;
import android.os.RemoteException;
import android.util.Log;
import java.util.List;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TunerAdapter
extends RadioTuner
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "BroadcastRadio.TunerAdapter";
    private ITuner mTuner;
    private boolean mIsClosed;
    private int mBand;

    private void $$robo$$android_hardware_radio_TunerAdapter$__constructor__(ITuner tuner, int band) {
        this.mIsClosed = false;
        if (tuner == null) {
            throw new NullPointerException();
        }
        this.mTuner = tuner;
        this.mBand = band;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_hardware_radio_TunerAdapter$close() {
        ITuner iTuner = this.mTuner;
        synchronized (iTuner) {
            if (this.mIsClosed) {
                Log.v("BroadcastRadio.TunerAdapter", "Tuner is already closed");
                return;
            }
            this.mIsClosed = true;
        }
        try {
            this.mTuner.close();
        }
        catch (RemoteException e) {
            Log.e("BroadcastRadio.TunerAdapter", "Exception trying to close tuner", e);
        }
    }

    private final int $$robo$$android_hardware_radio_TunerAdapter$setConfiguration(RadioManager.BandConfig config) {
        try {
            this.mTuner.setConfiguration(config);
            this.mBand = config.getType();
            return 0;
        }
        catch (IllegalArgumentException e) {
            Log.e("BroadcastRadio.TunerAdapter", "Can't set configuration", e);
            return -22;
        }
        catch (RemoteException e) {
            Log.e("BroadcastRadio.TunerAdapter", "service died", e);
            return -32;
        }
    }

    private final int $$robo$$android_hardware_radio_TunerAdapter$getConfiguration(RadioManager.BandConfig[] config) {
        if (config == null || config.length != 1) {
            throw new IllegalArgumentException("The argument must be an array of length 1");
        }
        try {
            config[0] = this.mTuner.getConfiguration();
            return 0;
        }
        catch (RemoteException e) {
            Log.e("BroadcastRadio.TunerAdapter", "service died", e);
            return -32;
        }
    }

    private final int $$robo$$android_hardware_radio_TunerAdapter$setMute(boolean mute) {
        try {
            this.mTuner.setMuted(mute);
        }
        catch (IllegalStateException e) {
            Log.e("BroadcastRadio.TunerAdapter", "Can't set muted", e);
            return Integer.MIN_VALUE;
        }
        catch (RemoteException e) {
            Log.e("BroadcastRadio.TunerAdapter", "service died", e);
            return -32;
        }
        return 0;
    }

    private final boolean $$robo$$android_hardware_radio_TunerAdapter$getMute() {
        try {
            return this.mTuner.isMuted();
        }
        catch (RemoteException e) {
            Log.e("BroadcastRadio.TunerAdapter", "service died", e);
            return true;
        }
    }

    private final int $$robo$$android_hardware_radio_TunerAdapter$step(int direction, boolean skipSubChannel) {
        try {
            this.mTuner.step(direction == 1, skipSubChannel);
        }
        catch (IllegalStateException e) {
            Log.e("BroadcastRadio.TunerAdapter", "Can't step", e);
            return -38;
        }
        catch (RemoteException e) {
            Log.e("BroadcastRadio.TunerAdapter", "service died", e);
            return -32;
        }
        return 0;
    }

    private final int $$robo$$android_hardware_radio_TunerAdapter$scan(int direction, boolean skipSubChannel) {
        try {
            this.mTuner.scan(direction == 1, skipSubChannel);
        }
        catch (IllegalStateException e) {
            Log.e("BroadcastRadio.TunerAdapter", "Can't scan", e);
            return -38;
        }
        catch (RemoteException e) {
            Log.e("BroadcastRadio.TunerAdapter", "service died", e);
            return -32;
        }
        return 0;
    }

    private final int $$robo$$android_hardware_radio_TunerAdapter$tune(int channel, int subChannel) {
        try {
            this.mTuner.tune(ProgramSelector.createAmFmSelector(this.mBand, channel, subChannel));
        }
        catch (IllegalStateException e) {
            Log.e("BroadcastRadio.TunerAdapter", "Can't tune", e);
            return -38;
        }
        catch (IllegalArgumentException e) {
            Log.e("BroadcastRadio.TunerAdapter", "Can't tune", e);
            return -22;
        }
        catch (RemoteException e) {
            Log.e("BroadcastRadio.TunerAdapter", "service died", e);
            return -32;
        }
        return 0;
    }

    private final void $$robo$$android_hardware_radio_TunerAdapter$tune(ProgramSelector selector) {
        try {
            this.mTuner.tune(selector);
        }
        catch (RemoteException e) {
            throw new RuntimeException("service died", e);
        }
    }

    private final int $$robo$$android_hardware_radio_TunerAdapter$cancel() {
        try {
            this.mTuner.cancel();
        }
        catch (IllegalStateException e) {
            Log.e("BroadcastRadio.TunerAdapter", "Can't cancel", e);
            return -38;
        }
        catch (RemoteException e) {
            Log.e("BroadcastRadio.TunerAdapter", "service died", e);
            return -32;
        }
        return 0;
    }

    private final void $$robo$$android_hardware_radio_TunerAdapter$cancelAnnouncement() {
        try {
            this.mTuner.cancelAnnouncement();
        }
        catch (RemoteException e) {
            throw new RuntimeException("service died", e);
        }
    }

    private final int $$robo$$android_hardware_radio_TunerAdapter$getProgramInformation(RadioManager.ProgramInfo[] info) {
        if (info == null || info.length != 1) {
            throw new IllegalArgumentException("The argument must be an array of length 1");
        }
        try {
            info[0] = this.mTuner.getProgramInformation();
            return 0;
        }
        catch (RemoteException e) {
            Log.e("BroadcastRadio.TunerAdapter", "service died", e);
            return -32;
        }
    }

    private final Bitmap $$robo$$android_hardware_radio_TunerAdapter$getMetadataImage(int id2) {
        try {
            return this.mTuner.getImage(id2);
        }
        catch (RemoteException e) {
            throw new RuntimeException("service died", e);
        }
    }

    private final boolean $$robo$$android_hardware_radio_TunerAdapter$startBackgroundScan() {
        try {
            return this.mTuner.startBackgroundScan();
        }
        catch (RemoteException e) {
            throw new RuntimeException("service died", e);
        }
    }

    private final List<RadioManager.ProgramInfo> $$robo$$android_hardware_radio_TunerAdapter$getProgramList(Map<String, String> vendorFilter) {
        try {
            return this.mTuner.getProgramList(vendorFilter);
        }
        catch (RemoteException e) {
            throw new RuntimeException("service died", e);
        }
    }

    private final boolean $$robo$$android_hardware_radio_TunerAdapter$isAnalogForced() {
        try {
            return this.mTuner.isAnalogForced();
        }
        catch (RemoteException e) {
            throw new RuntimeException("service died", e);
        }
    }

    private final void $$robo$$android_hardware_radio_TunerAdapter$setAnalogForced(boolean isForced) {
        try {
            this.mTuner.setAnalogForced(isForced);
        }
        catch (RemoteException e) {
            throw new RuntimeException("service died", e);
        }
    }

    private final boolean $$robo$$android_hardware_radio_TunerAdapter$isAntennaConnected() {
        try {
            return this.mTuner.isAntennaConnected();
        }
        catch (RemoteException e) {
            throw new RuntimeException("service died", e);
        }
    }

    private final boolean $$robo$$android_hardware_radio_TunerAdapter$hasControl() {
        try {
            return !this.mTuner.isClosed();
        }
        catch (RemoteException e) {
            return false;
        }
    }

    private void __constructor__(ITuner iTuner, int n) {
        this.$$robo$$android_hardware_radio_TunerAdapter$__constructor__(iTuner, n);
    }

    TunerAdapter(ITuner iTuner, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_hardware_radio_TunerAdapter$__constructor__(android.hardware.radio.ITuner int ), 0, this, iTuner, n);
    }

    @Override
    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_hardware_radio_TunerAdapter$close(), 0, this);
    }

    @Override
    public int setConfiguration(RadioManager.BandConfig bandConfig) {
        return (int)InvokeDynamicSupport.bootstrap("setConfiguration", $$robo$$android_hardware_radio_TunerAdapter$setConfiguration(android.hardware.radio.RadioManager$BandConfig ), 0, this, bandConfig);
    }

    @Override
    public int getConfiguration(RadioManager.BandConfig[] bandConfigArray) {
        return (int)InvokeDynamicSupport.bootstrap("getConfiguration", $$robo$$android_hardware_radio_TunerAdapter$getConfiguration(android.hardware.radio.RadioManager$BandConfig[] ), 0, this, bandConfigArray);
    }

    @Override
    public int setMute(boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("setMute", $$robo$$android_hardware_radio_TunerAdapter$setMute(boolean ), 0, this, bl);
    }

    @Override
    public boolean getMute() {
        return (boolean)InvokeDynamicSupport.bootstrap("getMute", $$robo$$android_hardware_radio_TunerAdapter$getMute(), 0, this);
    }

    @Override
    public int step(int n, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("step", $$robo$$android_hardware_radio_TunerAdapter$step(int boolean ), 0, this, n, bl);
    }

    @Override
    public int scan(int n, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("scan", $$robo$$android_hardware_radio_TunerAdapter$scan(int boolean ), 0, this, n, bl);
    }

    @Override
    public int tune(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("tune", $$robo$$android_hardware_radio_TunerAdapter$tune(int int ), 0, this, n, n2);
    }

    @Override
    public void tune(ProgramSelector programSelector) {
        InvokeDynamicSupport.bootstrap("tune", $$robo$$android_hardware_radio_TunerAdapter$tune(android.hardware.radio.ProgramSelector ), 0, this, programSelector);
    }

    @Override
    public int cancel() {
        return (int)InvokeDynamicSupport.bootstrap("cancel", $$robo$$android_hardware_radio_TunerAdapter$cancel(), 0, this);
    }

    @Override
    public void cancelAnnouncement() {
        InvokeDynamicSupport.bootstrap("cancelAnnouncement", $$robo$$android_hardware_radio_TunerAdapter$cancelAnnouncement(), 0, this);
    }

    @Override
    public int getProgramInformation(RadioManager.ProgramInfo[] programInfoArray) {
        return (int)InvokeDynamicSupport.bootstrap("getProgramInformation", $$robo$$android_hardware_radio_TunerAdapter$getProgramInformation(android.hardware.radio.RadioManager$ProgramInfo[] ), 0, this, programInfoArray);
    }

    @Override
    public Bitmap getMetadataImage(int n) {
        return InvokeDynamicSupport.bootstrap("getMetadataImage", $$robo$$android_hardware_radio_TunerAdapter$getMetadataImage(int ), 0, this, n);
    }

    @Override
    public boolean startBackgroundScan() {
        return (boolean)InvokeDynamicSupport.bootstrap("startBackgroundScan", $$robo$$android_hardware_radio_TunerAdapter$startBackgroundScan(), 0, this);
    }

    @Override
    public List<RadioManager.ProgramInfo> getProgramList(Map<String, String> map) {
        return InvokeDynamicSupport.bootstrap("getProgramList", $$robo$$android_hardware_radio_TunerAdapter$getProgramList(java.util.Map<java.lang.String, java.lang.String> ), 0, this, map);
    }

    @Override
    public boolean isAnalogForced() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAnalogForced", $$robo$$android_hardware_radio_TunerAdapter$isAnalogForced(), 0, this);
    }

    @Override
    public void setAnalogForced(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAnalogForced", $$robo$$android_hardware_radio_TunerAdapter$setAnalogForced(boolean ), 0, this, bl);
    }

    @Override
    public boolean isAntennaConnected() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAntennaConnected", $$robo$$android_hardware_radio_TunerAdapter$isAntennaConnected(), 0, this);
    }

    @Override
    public boolean hasControl() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasControl", $$robo$$android_hardware_radio_TunerAdapter$hasControl(), 0, this);
    }

    public /* synthetic */ TunerAdapter() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TunerAdapter)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

