/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl;

import android.icu.impl.ICUResourceBundle;
import android.icu.impl.UResource;
import android.icu.util.ULocale;
import android.icu.util.UResourceBundle;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.TreeMap;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class CalendarUtil
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String CALKEY = "calendar";
    private static String DEFCAL = "gregorian";

    private void $$robo$$android_icu_impl_CalendarUtil$__constructor__() {
    }

    private static final String $$robo$$android_icu_impl_CalendarUtil$getCalendarType(ULocale loc) {
        String calType = loc.getKeywordValue("calendar");
        if (calType != null) {
            return calType;
        }
        ULocale canonical = ULocale.createCanonical(loc.toString());
        calType = canonical.getKeywordValue("calendar");
        if (calType != null) {
            return calType;
        }
        String region = ULocale.getRegionForSupplementalData(canonical, true);
        return CalendarPreferences.INSTANCE.getCalendarTypeForRegion(region);
    }

    private void __constructor__() {
        this.$$robo$$android_icu_impl_CalendarUtil$__constructor__();
    }

    public CalendarUtil() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_CalendarUtil$__constructor__(), 0, this);
    }

    public static String getCalendarType(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getCalendarType", $$robo$$android_icu_impl_CalendarUtil$getCalendarType(android.icu.util.ULocale ), 0, (ULocale)uLocale);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CalendarUtil)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class CalendarPreferences
    extends UResource.Sink
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static CalendarPreferences INSTANCE;
        Map<String, String> prefs;

        private void $$robo$$android_icu_impl_CalendarUtil_CalendarPreferences$__constructor__() {
            this.prefs = new TreeMap<String, String>();
            try {
                ICUResourceBundle rb = (ICUResourceBundle)UResourceBundle.getBundleInstance("android/icu/impl/data/icudt58b", "supplementalData");
                rb.getAllItemsWithFallback("calendarPreferenceData", this);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }

        private final String $$robo$$android_icu_impl_CalendarUtil_CalendarPreferences$getCalendarTypeForRegion(String region) {
            String type = this.prefs.get(region);
            return type == null ? "gregorian" : type;
        }

        private final void $$robo$$android_icu_impl_CalendarUtil_CalendarPreferences$put(UResource.Key key, UResource.Value value, boolean noFallback) {
            UResource.Table calendarPreferenceData = value.getTable();
            int i = 0;
            while (calendarPreferenceData.getKeyAndValue(i, key, value)) {
                String type;
                UResource.Array types = value.getArray();
                if (types.getValue(0, value) && !(type = value.getString()).equals("gregorian")) {
                    this.prefs.put(key.toString(), type);
                }
                ++i;
            }
        }

        static void __staticInitializer__() {
            INSTANCE = new CalendarPreferences();
        }

        private void __constructor__() {
            this.$$robo$$android_icu_impl_CalendarUtil_CalendarPreferences$__constructor__();
        }

        CalendarPreferences() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_CalendarUtil_CalendarPreferences$__constructor__(), 0, this);
        }

        String getCalendarTypeForRegion(String string2) {
            return InvokeDynamicSupport.bootstrap("getCalendarTypeForRegion", $$robo$$android_icu_impl_CalendarUtil_CalendarPreferences$getCalendarTypeForRegion(java.lang.String ), 0, this, string2);
        }

        @Override
        public void put(UResource.Key key, UResource.Value value, boolean bl) {
            InvokeDynamicSupport.bootstrap("put", $$robo$$android_icu_impl_CalendarUtil_CalendarPreferences$put(android.icu.impl.UResource$Key android.icu.impl.UResource$Value boolean ), 0, this, key, value, bl);
        }

        static {
            RobolectricInternals.classInitializing(CalendarPreferences.class);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CalendarPreferences)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

