/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl;

import android.icu.impl.ICUResourceBundle;
import android.icu.impl.UResource;
import android.icu.util.ICUException;
import android.icu.util.ULocale;
import com.google.errorprone.annotations.DoNotMock;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class DayPeriodRules
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static DayPeriodRulesData DATA;
    private boolean hasMidnight;
    private boolean hasNoon;
    private DayPeriod[] dayPeriodForHour;

    private void $$robo$$android_icu_impl_DayPeriodRules$__constructor__() {
        this.hasMidnight = false;
        this.hasNoon = false;
        this.dayPeriodForHour = new DayPeriod[24];
    }

    private static final DayPeriodRules $$robo$$android_icu_impl_DayPeriodRules$getInstance(ULocale locale) {
        String localeCode = locale.getName();
        if (localeCode.isEmpty()) {
            localeCode = "root";
        }
        Integer ruleSetNum = null;
        while (ruleSetNum == null && (ruleSetNum = DayPeriodRules.DATA.localesToRuleSetNumMap.get(localeCode)) == null && !(localeCode = ULocale.getFallback(localeCode)).isEmpty()) {
        }
        if (ruleSetNum == null || DayPeriodRules.DATA.rules[ruleSetNum] == null) {
            return null;
        }
        return DayPeriodRules.DATA.rules[ruleSetNum];
    }

    private final double $$robo$$android_icu_impl_DayPeriodRules$getMidPointForDayPeriod(DayPeriod dayPeriod) {
        int startHour = this.getStartHourForDayPeriod(dayPeriod);
        int endHour = this.getEndHourForDayPeriod(dayPeriod);
        double midPoint = (double)(startHour + endHour) / 2.0;
        if (startHour > endHour && (midPoint += 12.0) >= 24.0) {
            midPoint -= 24.0;
        }
        return midPoint;
    }

    private static final DayPeriodRulesData $$robo$$android_icu_impl_DayPeriodRules$loadData() {
        DayPeriodRulesData data = new DayPeriodRulesData();
        ICUResourceBundle rb = ICUResourceBundle.getBundleInstance("android/icu/impl/data/icudt58b", "dayPeriods", ICUResourceBundle.ICU_DATA_CLASS_LOADER, true);
        DayPeriodRulesCountSink countSink = new DayPeriodRulesCountSink(data);
        rb.getAllItemsWithFallback("rules", countSink);
        data.rules = new DayPeriodRules[data.maxRuleSetNum + 1];
        DayPeriodRulesDataSink sink = new DayPeriodRulesDataSink(data);
        rb.getAllItemsWithFallback("", sink);
        return data;
    }

    private final int $$robo$$android_icu_impl_DayPeriodRules$getStartHourForDayPeriod(DayPeriod dayPeriod) throws IllegalArgumentException {
        if (dayPeriod == DayPeriod.MIDNIGHT) {
            return 0;
        }
        if (dayPeriod == DayPeriod.NOON) {
            return 12;
        }
        if (this.dayPeriodForHour[0] == dayPeriod && this.dayPeriodForHour[23] == dayPeriod) {
            for (int i = 22; i >= 1; --i) {
                if (this.dayPeriodForHour[i] == dayPeriod) continue;
                return i + 1;
            }
        } else {
            for (int i = 0; i <= 23; ++i) {
                if (this.dayPeriodForHour[i] != dayPeriod) continue;
                return i;
            }
        }
        throw new IllegalArgumentException();
    }

    private final int $$robo$$android_icu_impl_DayPeriodRules$getEndHourForDayPeriod(DayPeriod dayPeriod) {
        if (dayPeriod == DayPeriod.MIDNIGHT) {
            return 0;
        }
        if (dayPeriod == DayPeriod.NOON) {
            return 12;
        }
        if (this.dayPeriodForHour[0] == dayPeriod && this.dayPeriodForHour[23] == dayPeriod) {
            for (int i = 1; i <= 22; ++i) {
                if (this.dayPeriodForHour[i] == dayPeriod) continue;
                return i;
            }
        } else {
            for (int i = 23; i >= 0; --i) {
                if (this.dayPeriodForHour[i] != dayPeriod) continue;
                return i + 1;
            }
        }
        throw new IllegalArgumentException();
    }

    private final boolean $$robo$$android_icu_impl_DayPeriodRules$hasMidnight() {
        return this.hasMidnight;
    }

    private final boolean $$robo$$android_icu_impl_DayPeriodRules$hasNoon() {
        return this.hasNoon;
    }

    private final DayPeriod $$robo$$android_icu_impl_DayPeriodRules$getDayPeriodForHour(int hour) {
        return this.dayPeriodForHour[hour];
    }

    private final void $$robo$$android_icu_impl_DayPeriodRules$add(int startHour, int limitHour, DayPeriod period) {
        for (int i = startHour; i != limitHour; ++i) {
            if (i == 24) {
                i = 0;
            }
            this.dayPeriodForHour[i] = period;
        }
    }

    private static final int $$robo$$android_icu_impl_DayPeriodRules$parseSetNum(String setNumStr) {
        if (!setNumStr.startsWith("set")) {
            throw new ICUException("Set number should start with \"set\".");
        }
        String numStr = setNumStr.substring(3);
        return Integer.parseInt(numStr);
    }

    private /* synthetic */ void $$robo$$android_icu_impl_DayPeriodRules$__constructor__(1 x0) {
    }

    static void __staticInitializer__() {
        DATA = DayPeriodRules.loadData();
    }

    private void __constructor__() {
        this.$$robo$$android_icu_impl_DayPeriodRules$__constructor__();
    }

    private DayPeriodRules() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_DayPeriodRules$__constructor__(), 0, this);
    }

    public static DayPeriodRules getInstance(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_icu_impl_DayPeriodRules$getInstance(android.icu.util.ULocale ), 0, (ULocale)uLocale);
    }

    public double getMidPointForDayPeriod(DayPeriod dayPeriod) {
        return (double)InvokeDynamicSupport.bootstrap("getMidPointForDayPeriod", $$robo$$android_icu_impl_DayPeriodRules$getMidPointForDayPeriod(android.icu.impl.DayPeriodRules$DayPeriod ), 0, this, dayPeriod);
    }

    private static DayPeriodRulesData loadData() {
        return InvokeDynamicSupport.bootstrapStatic("loadData", $$robo$$android_icu_impl_DayPeriodRules$loadData(), 0);
    }

    private int getStartHourForDayPeriod(DayPeriod dayPeriod) throws IllegalArgumentException {
        return (int)InvokeDynamicSupport.bootstrap("getStartHourForDayPeriod", $$robo$$android_icu_impl_DayPeriodRules$getStartHourForDayPeriod(android.icu.impl.DayPeriodRules$DayPeriod ), 0, this, dayPeriod);
    }

    private int getEndHourForDayPeriod(DayPeriod dayPeriod) {
        return (int)InvokeDynamicSupport.bootstrap("getEndHourForDayPeriod", $$robo$$android_icu_impl_DayPeriodRules$getEndHourForDayPeriod(android.icu.impl.DayPeriodRules$DayPeriod ), 0, this, dayPeriod);
    }

    public boolean hasMidnight() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasMidnight", $$robo$$android_icu_impl_DayPeriodRules$hasMidnight(), 0, this);
    }

    public boolean hasNoon() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasNoon", $$robo$$android_icu_impl_DayPeriodRules$hasNoon(), 0, this);
    }

    public DayPeriod getDayPeriodForHour(int n) {
        return InvokeDynamicSupport.bootstrap("getDayPeriodForHour", $$robo$$android_icu_impl_DayPeriodRules$getDayPeriodForHour(int ), 0, this, n);
    }

    private void add(int n, int n2, DayPeriod dayPeriod) {
        InvokeDynamicSupport.bootstrap("add", $$robo$$android_icu_impl_DayPeriodRules$add(int int android.icu.impl.DayPeriodRules$DayPeriod ), 0, this, n, n2, dayPeriod);
    }

    private static int parseSetNum(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("parseSetNum", $$robo$$android_icu_impl_DayPeriodRules$parseSetNum(java.lang.String ), 0, (String)string2);
    }

    private /* synthetic */ void __constructor__(1 var1_1) {
        this.$$robo$$android_icu_impl_DayPeriodRules$__constructor__(var1_1);
    }

    static {
        RobolectricInternals.classInitializing(DayPeriodRules.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DayPeriodRules)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class DayPeriodRulesCountSink
    extends UResource.Sink
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private DayPeriodRulesData data;

        private void $$robo$$android_icu_impl_DayPeriodRules_DayPeriodRulesCountSink$__constructor__(DayPeriodRulesData data) {
            this.data = data;
        }

        private final void $$robo$$android_icu_impl_DayPeriodRules_DayPeriodRulesCountSink$put(UResource.Key key, UResource.Value value, boolean noFallback) {
            UResource.Table rules = value.getTable();
            int i = 0;
            while (rules.getKeyAndValue(i, key, value)) {
                int setNum = DayPeriodRules.parseSetNum(key.toString());
                if (setNum > this.data.maxRuleSetNum) {
                    this.data.maxRuleSetNum = setNum;
                }
                ++i;
            }
        }

        private /* synthetic */ void $$robo$$android_icu_impl_DayPeriodRules_DayPeriodRulesCountSink$__constructor__(DayPeriodRulesData x0, 1 x1) {
        }

        private void __constructor__(DayPeriodRulesData dayPeriodRulesData) {
            this.$$robo$$android_icu_impl_DayPeriodRules_DayPeriodRulesCountSink$__constructor__(dayPeriodRulesData);
        }

        private DayPeriodRulesCountSink(DayPeriodRulesData dayPeriodRulesData) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_DayPeriodRules_DayPeriodRulesCountSink$__constructor__(android.icu.impl.DayPeriodRules$DayPeriodRulesData ), 0, this, dayPeriodRulesData);
        }

        @Override
        public void put(UResource.Key key, UResource.Value value, boolean bl) {
            InvokeDynamicSupport.bootstrap("put", $$robo$$android_icu_impl_DayPeriodRules_DayPeriodRulesCountSink$put(android.icu.impl.UResource$Key android.icu.impl.UResource$Value boolean ), 0, this, key, value, bl);
        }

        private /* synthetic */ void __constructor__(DayPeriodRulesData dayPeriodRulesData, 1 var2_2) {
            this.$$robo$$android_icu_impl_DayPeriodRules_DayPeriodRulesCountSink$__constructor__(dayPeriodRulesData, var2_2);
        }

        public /* synthetic */ DayPeriodRulesCountSink() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DayPeriodRulesCountSink)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class DayPeriodRulesDataSink
    extends UResource.Sink
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private DayPeriodRulesData data;
        private int[] cutoffs;
        private int ruleSetNum;
        private DayPeriod period;
        private CutoffType cutoffType;

        private void $$robo$$android_icu_impl_DayPeriodRules_DayPeriodRulesDataSink$__constructor__(DayPeriodRulesData data) {
            this.cutoffs = new int[25];
            this.data = data;
        }

        private final void $$robo$$android_icu_impl_DayPeriodRules_DayPeriodRulesDataSink$put(UResource.Key key, UResource.Value value, boolean noFallback) {
            UResource.Table dayPeriodData = value.getTable();
            int i = 0;
            while (dayPeriodData.getKeyAndValue(i, key, value)) {
                if (key.contentEquals("locales")) {
                    UResource.Table locales = value.getTable();
                    int j = 0;
                    while (locales.getKeyAndValue(j, key, value)) {
                        int setNum = DayPeriodRules.parseSetNum(value.getString());
                        this.data.localesToRuleSetNumMap.put(key.toString(), setNum);
                        ++j;
                    }
                } else if (key.contentEquals("rules")) {
                    UResource.Table rules = value.getTable();
                    this.processRules(rules, key, value);
                }
                ++i;
            }
        }

        private final void $$robo$$android_icu_impl_DayPeriodRules_DayPeriodRulesDataSink$processRules(UResource.Table rules, UResource.Key key, UResource.Value value) {
            int i = 0;
            while (rules.getKeyAndValue(i, key, value)) {
                this.ruleSetNum = DayPeriodRules.parseSetNum(key.toString());
                this.data.rules[this.ruleSetNum] = new DayPeriodRules();
                UResource.Table ruleSet = value.getTable();
                int j = 0;
                while (ruleSet.getKeyAndValue(j, key, value)) {
                    this.period = DayPeriod.fromStringOrNull(key);
                    if (this.period == null) {
                        throw new ICUException("Unknown day period in data.");
                    }
                    UResource.Table periodDefinition = value.getTable();
                    int k = 0;
                    while (periodDefinition.getKeyAndValue(k, key, value)) {
                        if (value.getType() == 0) {
                            CutoffType type = CutoffType.fromStringOrNull(key);
                            this.addCutoff(type, value.getString());
                        } else {
                            this.cutoffType = CutoffType.fromStringOrNull(key);
                            UResource.Array cutoffArray = value.getArray();
                            int length = cutoffArray.getSize();
                            for (int l = 0; l < length; ++l) {
                                cutoffArray.getValue(l, value);
                                this.addCutoff(this.cutoffType, value.getString());
                            }
                        }
                        ++k;
                    }
                    this.setDayPeriodForHoursFromCutoffs();
                    for (k = 0; k < this.cutoffs.length; ++k) {
                        this.cutoffs[k] = 0;
                    }
                    ++j;
                }
                for (DayPeriod period : this.data.rules[this.ruleSetNum].dayPeriodForHour) {
                    if (period != null) continue;
                    throw new ICUException("Rules in data don't cover all 24 hours (they should).");
                }
                ++i;
            }
        }

        private final void $$robo$$android_icu_impl_DayPeriodRules_DayPeriodRulesDataSink$addCutoff(CutoffType type, String hourStr) {
            int hour;
            if (type == null) {
                throw new ICUException("Cutoff type not recognized.");
            }
            int n = hour = DayPeriodRulesDataSink.parseHour(hourStr);
            this.cutoffs[n] = this.cutoffs[n] | 1 << type.ordinal();
        }

        private final void $$robo$$android_icu_impl_DayPeriodRules_DayPeriodRulesDataSink$setDayPeriodForHoursFromCutoffs() {
            DayPeriodRules rule = this.data.rules[this.ruleSetNum];
            block0: for (int startHour = 0; startHour <= 24; ++startHour) {
                if ((this.cutoffs[startHour] & 1 << CutoffType.AT.ordinal()) > 0) {
                    if (startHour == 0 && this.period == DayPeriod.MIDNIGHT) {
                        rule.hasMidnight = true;
                    } else if (startHour == 12 && this.period == DayPeriod.NOON) {
                        rule.hasNoon = true;
                    } else {
                        throw new ICUException("AT cutoff must only be set for 0:00 or 12:00.");
                    }
                }
                if ((this.cutoffs[startHour] & 1 << CutoffType.FROM.ordinal()) <= 0 && (this.cutoffs[startHour] & 1 << CutoffType.AFTER.ordinal()) <= 0) continue;
                int hour = startHour + 1;
                while (true) {
                    if (hour == startHour) {
                        throw new ICUException("FROM/AFTER cutoffs must have a matching BEFORE cutoff.");
                    }
                    if (hour == 25) {
                        hour = 0;
                    }
                    if ((this.cutoffs[hour] & 1 << CutoffType.BEFORE.ordinal()) > 0) {
                        rule.add(startHour, hour, this.period);
                        continue block0;
                    }
                    ++hour;
                }
            }
        }

        private static final int $$robo$$android_icu_impl_DayPeriodRules_DayPeriodRulesDataSink$parseHour(String str) {
            int firstColonPos = str.indexOf(58);
            if (firstColonPos < 0 || !str.substring(firstColonPos).equals(":00")) {
                throw new ICUException("Cutoff time must end in \":00\".");
            }
            String hourStr = str.substring(0, firstColonPos);
            if (firstColonPos != 1 && firstColonPos != 2) {
                throw new ICUException("Cutoff time must begin with h: or hh:");
            }
            int hour = Integer.parseInt(hourStr);
            if (hour < 0 || hour > 24) {
                throw new ICUException("Cutoff hour must be between 0 and 24, inclusive.");
            }
            return hour;
        }

        private /* synthetic */ void $$robo$$android_icu_impl_DayPeriodRules_DayPeriodRulesDataSink$__constructor__(DayPeriodRulesData x0, 1 x1) {
        }

        private void __constructor__(DayPeriodRulesData dayPeriodRulesData) {
            this.$$robo$$android_icu_impl_DayPeriodRules_DayPeriodRulesDataSink$__constructor__(dayPeriodRulesData);
        }

        private DayPeriodRulesDataSink(DayPeriodRulesData dayPeriodRulesData) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_DayPeriodRules_DayPeriodRulesDataSink$__constructor__(android.icu.impl.DayPeriodRules$DayPeriodRulesData ), 0, this, dayPeriodRulesData);
        }

        @Override
        public void put(UResource.Key key, UResource.Value value, boolean bl) {
            InvokeDynamicSupport.bootstrap("put", $$robo$$android_icu_impl_DayPeriodRules_DayPeriodRulesDataSink$put(android.icu.impl.UResource$Key android.icu.impl.UResource$Value boolean ), 0, this, key, value, bl);
        }

        private void processRules(UResource.Table table, UResource.Key key, UResource.Value value) {
            InvokeDynamicSupport.bootstrap("processRules", $$robo$$android_icu_impl_DayPeriodRules_DayPeriodRulesDataSink$processRules(android.icu.impl.UResource$Table android.icu.impl.UResource$Key android.icu.impl.UResource$Value ), 0, this, table, key, value);
        }

        private void addCutoff(CutoffType cutoffType, String string2) {
            InvokeDynamicSupport.bootstrap("addCutoff", $$robo$$android_icu_impl_DayPeriodRules_DayPeriodRulesDataSink$addCutoff(android.icu.impl.DayPeriodRules$CutoffType java.lang.String ), 0, this, cutoffType, string2);
        }

        private void setDayPeriodForHoursFromCutoffs() {
            InvokeDynamicSupport.bootstrap("setDayPeriodForHoursFromCutoffs", $$robo$$android_icu_impl_DayPeriodRules_DayPeriodRulesDataSink$setDayPeriodForHoursFromCutoffs(), 0, this);
        }

        private static int parseHour(String string2) {
            return (int)InvokeDynamicSupport.bootstrapStatic("parseHour", $$robo$$android_icu_impl_DayPeriodRules_DayPeriodRulesDataSink$parseHour(java.lang.String ), 0, (String)string2);
        }

        private /* synthetic */ void __constructor__(DayPeriodRulesData dayPeriodRulesData, 1 var2_2) {
            this.$$robo$$android_icu_impl_DayPeriodRules_DayPeriodRulesDataSink$__constructor__(dayPeriodRulesData, var2_2);
        }

        public /* synthetic */ DayPeriodRulesDataSink() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DayPeriodRulesDataSink)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class DayPeriodRulesData
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        Map<String, Integer> localesToRuleSetNumMap;
        DayPeriodRules[] rules;
        int maxRuleSetNum;

        private void $$robo$$android_icu_impl_DayPeriodRules_DayPeriodRulesData$__constructor__() {
            this.localesToRuleSetNumMap = new HashMap<String, Integer>();
            this.maxRuleSetNum = -1;
        }

        private /* synthetic */ void $$robo$$android_icu_impl_DayPeriodRules_DayPeriodRulesData$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_icu_impl_DayPeriodRules_DayPeriodRulesData$__constructor__();
        }

        private DayPeriodRulesData() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_DayPeriodRules_DayPeriodRulesData$__constructor__(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_icu_impl_DayPeriodRules_DayPeriodRulesData$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DayPeriodRulesData)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class CutoffType
    extends Enum<CutoffType> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ CutoffType BEFORE;
        public static /* enum */ CutoffType AFTER;
        public static /* enum */ CutoffType FROM;
        public static /* enum */ CutoffType AT;
        private static /* synthetic */ CutoffType[] $VALUES;

        private static final CutoffType[] $$robo$$android_icu_impl_DayPeriodRules_CutoffType$values() {
            return (CutoffType[])$VALUES.clone();
        }

        private static final CutoffType $$robo$$android_icu_impl_DayPeriodRules_CutoffType$valueOf(String name) {
            return Enum.valueOf(CutoffType.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_impl_DayPeriodRules_CutoffType$__constructor__(String string2, int n) {
        }

        private static final CutoffType $$robo$$android_icu_impl_DayPeriodRules_CutoffType$fromStringOrNull(CharSequence str) {
            if ("from".contentEquals(str)) {
                return FROM;
            }
            if ("before".contentEquals(str)) {
                return BEFORE;
            }
            if ("after".contentEquals(str)) {
                return AFTER;
            }
            if ("at".contentEquals(str)) {
                return AT;
            }
            return null;
        }

        static void __staticInitializer__() {
            BEFORE = new CutoffType();
            AFTER = new CutoffType();
            FROM = new CutoffType();
            AT = new CutoffType();
            $VALUES = new CutoffType[]{BEFORE, AFTER, FROM, AT};
        }

        public static CutoffType[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_impl_DayPeriodRules_CutoffType$values(), 0);
        }

        public static CutoffType valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_impl_DayPeriodRules_CutoffType$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_icu_impl_DayPeriodRules_CutoffType$__constructor__(string2, n);
        }

        private CutoffType() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_DayPeriodRules_CutoffType$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        private static CutoffType fromStringOrNull(CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrapStatic("fromStringOrNull", $$robo$$android_icu_impl_DayPeriodRules_CutoffType$fromStringOrNull(java.lang.CharSequence ), 0, (CharSequence)charSequence);
        }

        static {
            RobolectricInternals.classInitializing(CutoffType.class);
        }

        public /* synthetic */ CutoffType() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CutoffType)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class DayPeriod
    extends Enum<DayPeriod> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ DayPeriod MIDNIGHT;
        public static /* enum */ DayPeriod NOON;
        public static /* enum */ DayPeriod MORNING1;
        public static /* enum */ DayPeriod AFTERNOON1;
        public static /* enum */ DayPeriod EVENING1;
        public static /* enum */ DayPeriod NIGHT1;
        public static /* enum */ DayPeriod MORNING2;
        public static /* enum */ DayPeriod AFTERNOON2;
        public static /* enum */ DayPeriod EVENING2;
        public static /* enum */ DayPeriod NIGHT2;
        public static /* enum */ DayPeriod AM;
        public static /* enum */ DayPeriod PM;
        public static DayPeriod[] VALUES;
        private static /* synthetic */ DayPeriod[] $VALUES;

        private static final DayPeriod[] $$robo$$android_icu_impl_DayPeriodRules_DayPeriod$values() {
            return (DayPeriod[])$VALUES.clone();
        }

        private static final DayPeriod $$robo$$android_icu_impl_DayPeriodRules_DayPeriod$valueOf(String name) {
            return Enum.valueOf(DayPeriod.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_icu_impl_DayPeriodRules_DayPeriod$__constructor__(String string2, int n) {
        }

        private static final DayPeriod $$robo$$android_icu_impl_DayPeriodRules_DayPeriod$fromStringOrNull(CharSequence str) {
            if ("midnight".contentEquals(str)) {
                return MIDNIGHT;
            }
            if ("noon".contentEquals(str)) {
                return NOON;
            }
            if ("morning1".contentEquals(str)) {
                return MORNING1;
            }
            if ("afternoon1".contentEquals(str)) {
                return AFTERNOON1;
            }
            if ("evening1".contentEquals(str)) {
                return EVENING1;
            }
            if ("night1".contentEquals(str)) {
                return NIGHT1;
            }
            if ("morning2".contentEquals(str)) {
                return MORNING2;
            }
            if ("afternoon2".contentEquals(str)) {
                return AFTERNOON2;
            }
            if ("evening2".contentEquals(str)) {
                return EVENING2;
            }
            if ("night2".contentEquals(str)) {
                return NIGHT2;
            }
            if ("am".contentEquals(str)) {
                return AM;
            }
            if ("pm".contentEquals(str)) {
                return PM;
            }
            return null;
        }

        static void __staticInitializer__() {
            MIDNIGHT = new DayPeriod();
            NOON = new DayPeriod();
            MORNING1 = new DayPeriod();
            AFTERNOON1 = new DayPeriod();
            EVENING1 = new DayPeriod();
            NIGHT1 = new DayPeriod();
            MORNING2 = new DayPeriod();
            AFTERNOON2 = new DayPeriod();
            EVENING2 = new DayPeriod();
            NIGHT2 = new DayPeriod();
            AM = new DayPeriod();
            PM = new DayPeriod();
            $VALUES = new DayPeriod[]{MIDNIGHT, NOON, MORNING1, AFTERNOON1, EVENING1, NIGHT1, MORNING2, AFTERNOON2, EVENING2, NIGHT2, AM, PM};
            VALUES = DayPeriod.values();
        }

        public static DayPeriod[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_impl_DayPeriodRules_DayPeriod$values(), 0);
        }

        public static DayPeriod valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_impl_DayPeriodRules_DayPeriod$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_icu_impl_DayPeriodRules_DayPeriod$__constructor__(string2, n);
        }

        private DayPeriod() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_DayPeriodRules_DayPeriod$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        private static DayPeriod fromStringOrNull(CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrapStatic("fromStringOrNull", $$robo$$android_icu_impl_DayPeriodRules_DayPeriod$fromStringOrNull(java.lang.CharSequence ), 0, (CharSequence)charSequence);
        }

        static {
            RobolectricInternals.classInitializing(DayPeriod.class);
        }

        public /* synthetic */ DayPeriod() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DayPeriod)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

