/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl;

import android.icu.impl.ClassLoaderUtil;
import android.icu.impl.ICUResourceBundle;
import android.icu.impl.ICUService;
import android.icu.impl.LocaleUtility;
import android.icu.util.ULocale;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ICULocaleService
extends ICUService
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private ULocale fallbackLocale;
    private String fallbackLocaleName;

    private void $$robo$$android_icu_impl_ICULocaleService$__constructor__() {
    }

    private void $$robo$$android_icu_impl_ICULocaleService$__constructor__(String name) {
    }

    private final Object $$robo$$android_icu_impl_ICULocaleService$get(ULocale locale) {
        return this.get(locale, -1, null);
    }

    private final Object $$robo$$android_icu_impl_ICULocaleService$get(ULocale locale, int kind) {
        return this.get(locale, kind, null);
    }

    private final Object $$robo$$android_icu_impl_ICULocaleService$get(ULocale locale, ULocale[] actualReturn) {
        return this.get(locale, -1, actualReturn);
    }

    private final Object $$robo$$android_icu_impl_ICULocaleService$get(ULocale locale, int kind, ULocale[] actualReturn) {
        ICUService.Key key = this.createKey(locale, kind);
        if (actualReturn == null) {
            return this.getKey(key);
        }
        String[] temp = new String[1];
        Object result = this.getKey(key, temp);
        if (result != null) {
            int n = temp[0].indexOf("/");
            if (n >= 0) {
                temp[0] = temp[0].substring(n + 1);
            }
            actualReturn[0] = new ULocale(temp[0]);
        }
        return result;
    }

    private final ICUService.Factory $$robo$$android_icu_impl_ICULocaleService$registerObject(Object obj, ULocale locale) {
        return this.registerObject(obj, locale, -1, true);
    }

    private final ICUService.Factory $$robo$$android_icu_impl_ICULocaleService$registerObject(Object obj, ULocale locale, boolean visible) {
        return this.registerObject(obj, locale, -1, visible);
    }

    private final ICUService.Factory $$robo$$android_icu_impl_ICULocaleService$registerObject(Object obj, ULocale locale, int kind) {
        return this.registerObject(obj, locale, kind, true);
    }

    private final ICUService.Factory $$robo$$android_icu_impl_ICULocaleService$registerObject(Object obj, ULocale locale, int kind, boolean visible) {
        SimpleLocaleKeyFactory factory = new SimpleLocaleKeyFactory(obj, locale, kind, visible);
        return this.registerFactory(factory);
    }

    private final Locale[] $$robo$$android_icu_impl_ICULocaleService$getAvailableLocales() {
        Set<String> visIDs = this.getVisibleIDs();
        Locale[] locales = new Locale[visIDs.size()];
        int n = 0;
        for (String id2 : visIDs) {
            Locale loc = LocaleUtility.getLocaleFromName(id2);
            locales[n++] = loc;
        }
        return locales;
    }

    private final ULocale[] $$robo$$android_icu_impl_ICULocaleService$getAvailableULocales() {
        Set<String> visIDs = this.getVisibleIDs();
        ULocale[] locales = new ULocale[visIDs.size()];
        int n = 0;
        for (String id2 : visIDs) {
            locales[n++] = new ULocale(id2);
        }
        return locales;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String $$robo$$android_icu_impl_ICULocaleService$validateFallbackLocale() {
        ULocale loc = ULocale.getDefault();
        if (loc != this.fallbackLocale) {
            ICULocaleService iCULocaleService = this;
            synchronized (iCULocaleService) {
                if (loc != this.fallbackLocale) {
                    this.fallbackLocale = loc;
                    this.fallbackLocaleName = loc.getBaseName();
                    this.clearServiceCache();
                }
            }
        }
        return this.fallbackLocaleName;
    }

    private final ICUService.Key $$robo$$android_icu_impl_ICULocaleService$createKey(String id2) {
        return LocaleKey.createWithCanonicalFallback(id2, this.validateFallbackLocale());
    }

    private final ICUService.Key $$robo$$android_icu_impl_ICULocaleService$createKey(String id2, int kind) {
        return LocaleKey.createWithCanonicalFallback(id2, this.validateFallbackLocale(), kind);
    }

    private final ICUService.Key $$robo$$android_icu_impl_ICULocaleService$createKey(ULocale l, int kind) {
        return LocaleKey.createWithCanonical(l, this.validateFallbackLocale(), kind);
    }

    private void __constructor__() {
        this.$$robo$$android_icu_impl_ICULocaleService$__constructor__();
    }

    public ICULocaleService() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_ICULocaleService$__constructor__(), 0, this);
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_icu_impl_ICULocaleService$__constructor__(string2);
    }

    public ICULocaleService(String string2) {
        super(string2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_ICULocaleService$__constructor__(java.lang.String ), 0, this, string2);
    }

    public Object get(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrap("get", $$robo$$android_icu_impl_ICULocaleService$get(android.icu.util.ULocale ), 0, this, uLocale);
    }

    public Object get(ULocale uLocale, int n) {
        return InvokeDynamicSupport.bootstrap("get", $$robo$$android_icu_impl_ICULocaleService$get(android.icu.util.ULocale int ), 0, this, uLocale, n);
    }

    public Object get(ULocale uLocale, ULocale[] uLocaleArray) {
        return InvokeDynamicSupport.bootstrap("get", $$robo$$android_icu_impl_ICULocaleService$get(android.icu.util.ULocale android.icu.util.ULocale[] ), 0, this, uLocale, uLocaleArray);
    }

    public Object get(ULocale uLocale, int n, ULocale[] uLocaleArray) {
        return InvokeDynamicSupport.bootstrap("get", $$robo$$android_icu_impl_ICULocaleService$get(android.icu.util.ULocale int android.icu.util.ULocale[] ), 0, this, uLocale, n, uLocaleArray);
    }

    public ICUService.Factory registerObject(Object object, ULocale uLocale) {
        return InvokeDynamicSupport.bootstrap("registerObject", $$robo$$android_icu_impl_ICULocaleService$registerObject(java.lang.Object android.icu.util.ULocale ), 0, this, object, uLocale);
    }

    public ICUService.Factory registerObject(Object object, ULocale uLocale, boolean bl) {
        return InvokeDynamicSupport.bootstrap("registerObject", $$robo$$android_icu_impl_ICULocaleService$registerObject(java.lang.Object android.icu.util.ULocale boolean ), 0, this, object, uLocale, bl);
    }

    public ICUService.Factory registerObject(Object object, ULocale uLocale, int n) {
        return InvokeDynamicSupport.bootstrap("registerObject", $$robo$$android_icu_impl_ICULocaleService$registerObject(java.lang.Object android.icu.util.ULocale int ), 0, this, object, uLocale, n);
    }

    public ICUService.Factory registerObject(Object object, ULocale uLocale, int n, boolean bl) {
        return InvokeDynamicSupport.bootstrap("registerObject", $$robo$$android_icu_impl_ICULocaleService$registerObject(java.lang.Object android.icu.util.ULocale int boolean ), 0, this, object, uLocale, n, bl);
    }

    public Locale[] getAvailableLocales() {
        return InvokeDynamicSupport.bootstrap("getAvailableLocales", $$robo$$android_icu_impl_ICULocaleService$getAvailableLocales(), 0, this);
    }

    public ULocale[] getAvailableULocales() {
        return InvokeDynamicSupport.bootstrap("getAvailableULocales", $$robo$$android_icu_impl_ICULocaleService$getAvailableULocales(), 0, this);
    }

    public String validateFallbackLocale() {
        return InvokeDynamicSupport.bootstrap("validateFallbackLocale", $$robo$$android_icu_impl_ICULocaleService$validateFallbackLocale(), 0, this);
    }

    @Override
    public ICUService.Key createKey(String string2) {
        return InvokeDynamicSupport.bootstrap("createKey", $$robo$$android_icu_impl_ICULocaleService$createKey(java.lang.String ), 0, this, string2);
    }

    public ICUService.Key createKey(String string2, int n) {
        return InvokeDynamicSupport.bootstrap("createKey", $$robo$$android_icu_impl_ICULocaleService$createKey(java.lang.String int ), 0, this, string2, n);
    }

    public ICUService.Key createKey(ULocale uLocale, int n) {
        return InvokeDynamicSupport.bootstrap("createKey", $$robo$$android_icu_impl_ICULocaleService$createKey(android.icu.util.ULocale int ), 0, this, uLocale, n);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ICULocaleService)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class ICUResourceBundleFactory
    extends LocaleKeyFactory
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        protected String bundleName;

        private void $$robo$$android_icu_impl_ICULocaleService_ICUResourceBundleFactory$__constructor__() {
        }

        private void $$robo$$android_icu_impl_ICULocaleService_ICUResourceBundleFactory$__constructor__(String bundleName) {
            this.bundleName = bundleName;
        }

        private final Set<String> $$robo$$android_icu_impl_ICULocaleService_ICUResourceBundleFactory$getSupportedIDs() {
            return ICUResourceBundle.getFullLocaleNameSet(this.bundleName, this.loader());
        }

        private final void $$robo$$android_icu_impl_ICULocaleService_ICUResourceBundleFactory$updateVisibleIDs(Map<String, ICUService.Factory> result) {
            Set<String> visibleIDs = ICUResourceBundle.getAvailableLocaleNameSet(this.bundleName, this.loader());
            for (String id2 : visibleIDs) {
                result.put(id2, this);
            }
        }

        private final Object $$robo$$android_icu_impl_ICULocaleService_ICUResourceBundleFactory$handleCreate(ULocale loc, int kind, ICUService service) {
            return ICUResourceBundle.getBundleInstance(this.bundleName, loc, this.loader());
        }

        private final ClassLoader $$robo$$android_icu_impl_ICULocaleService_ICUResourceBundleFactory$loader() {
            return ClassLoaderUtil.getClassLoader(this.getClass());
        }

        private final String $$robo$$android_icu_impl_ICULocaleService_ICUResourceBundleFactory$toString() {
            return super.toString() + ", bundle: " + this.bundleName;
        }

        private void __constructor__() {
            this.$$robo$$android_icu_impl_ICULocaleService_ICUResourceBundleFactory$__constructor__();
        }

        public ICUResourceBundleFactory() {
            this("android/icu/impl/data/icudt58b");
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_ICULocaleService_ICUResourceBundleFactory$__constructor__(), 0, this);
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_icu_impl_ICULocaleService_ICUResourceBundleFactory$__constructor__(string2);
        }

        public ICUResourceBundleFactory(String string2) {
            super(true);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_ICULocaleService_ICUResourceBundleFactory$__constructor__(java.lang.String ), 0, this, string2);
        }

        @Override
        protected Set<String> getSupportedIDs() {
            return InvokeDynamicSupport.bootstrap("getSupportedIDs", $$robo$$android_icu_impl_ICULocaleService_ICUResourceBundleFactory$getSupportedIDs(), 0, this);
        }

        @Override
        public void updateVisibleIDs(Map<String, ICUService.Factory> map) {
            InvokeDynamicSupport.bootstrap("updateVisibleIDs", $$robo$$android_icu_impl_ICULocaleService_ICUResourceBundleFactory$updateVisibleIDs(java.util.Map<java.lang.String, android.icu.impl.ICUService$Factory> ), 0, this, map);
        }

        @Override
        protected Object handleCreate(ULocale uLocale, int n, ICUService iCUService) {
            return InvokeDynamicSupport.bootstrap("handleCreate", $$robo$$android_icu_impl_ICULocaleService_ICUResourceBundleFactory$handleCreate(android.icu.util.ULocale int android.icu.impl.ICUService ), 0, this, uLocale, n, iCUService);
        }

        protected ClassLoader loader() {
            return InvokeDynamicSupport.bootstrap("loader", $$robo$$android_icu_impl_ICULocaleService_ICUResourceBundleFactory$loader(), 0, this);
        }

        @Override
        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_impl_ICULocaleService_ICUResourceBundleFactory$toString(), 0, this);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ICUResourceBundleFactory)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class SimpleLocaleKeyFactory
    extends LocaleKeyFactory
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Object obj;
        private String id;
        private int kind;

        private void $$robo$$android_icu_impl_ICULocaleService_SimpleLocaleKeyFactory$__constructor__(Object obj, ULocale locale, int kind, boolean visible) {
        }

        private void $$robo$$android_icu_impl_ICULocaleService_SimpleLocaleKeyFactory$__constructor__(Object obj, ULocale locale, int kind, boolean visible, String name) {
            this.obj = obj;
            this.id = locale.getBaseName();
            this.kind = kind;
        }

        private final Object $$robo$$android_icu_impl_ICULocaleService_SimpleLocaleKeyFactory$create(ICUService.Key key, ICUService service) {
            if (!(key instanceof LocaleKey)) {
                return null;
            }
            LocaleKey lkey = (LocaleKey)key;
            if (this.kind != -1 && this.kind != lkey.kind()) {
                return null;
            }
            if (!this.id.equals(lkey.currentID())) {
                return null;
            }
            return this.obj;
        }

        private final boolean $$robo$$android_icu_impl_ICULocaleService_SimpleLocaleKeyFactory$isSupportedID(String idToCheck) {
            return this.id.equals(idToCheck);
        }

        private final void $$robo$$android_icu_impl_ICULocaleService_SimpleLocaleKeyFactory$updateVisibleIDs(Map<String, ICUService.Factory> result) {
            if (this.visible) {
                result.put(this.id, this);
            } else {
                result.remove(this.id);
            }
        }

        private final String $$robo$$android_icu_impl_ICULocaleService_SimpleLocaleKeyFactory$toString() {
            StringBuilder buf = new StringBuilder(super.toString());
            buf.append(", id: ");
            buf.append(this.id);
            buf.append(", kind: ");
            buf.append(this.kind);
            return buf.toString();
        }

        private void __constructor__(Object object, ULocale uLocale, int n, boolean bl) {
            this.$$robo$$android_icu_impl_ICULocaleService_SimpleLocaleKeyFactory$__constructor__(object, uLocale, n, bl);
        }

        public SimpleLocaleKeyFactory(Object object, ULocale uLocale, int n, boolean bl) {
            this(object, uLocale, n, bl, null);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_ICULocaleService_SimpleLocaleKeyFactory$__constructor__(java.lang.Object android.icu.util.ULocale int boolean ), 0, this, object, uLocale, n, bl);
        }

        private void __constructor__(Object object, ULocale uLocale, int n, boolean bl, String string2) {
            this.$$robo$$android_icu_impl_ICULocaleService_SimpleLocaleKeyFactory$__constructor__(object, uLocale, n, bl, string2);
        }

        public SimpleLocaleKeyFactory(Object object, ULocale uLocale, int n, boolean bl, String string2) {
            super(bl, string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_ICULocaleService_SimpleLocaleKeyFactory$__constructor__(java.lang.Object android.icu.util.ULocale int boolean java.lang.String ), 0, this, object, uLocale, n, bl, string2);
        }

        @Override
        public Object create(ICUService.Key key, ICUService iCUService) {
            return InvokeDynamicSupport.bootstrap("create", $$robo$$android_icu_impl_ICULocaleService_SimpleLocaleKeyFactory$create(android.icu.impl.ICUService$Key android.icu.impl.ICUService ), 0, this, key, iCUService);
        }

        @Override
        protected boolean isSupportedID(String string2) {
            return (boolean)InvokeDynamicSupport.bootstrap("isSupportedID", $$robo$$android_icu_impl_ICULocaleService_SimpleLocaleKeyFactory$isSupportedID(java.lang.String ), 0, this, string2);
        }

        @Override
        public void updateVisibleIDs(Map<String, ICUService.Factory> map) {
            InvokeDynamicSupport.bootstrap("updateVisibleIDs", $$robo$$android_icu_impl_ICULocaleService_SimpleLocaleKeyFactory$updateVisibleIDs(java.util.Map<java.lang.String, android.icu.impl.ICUService$Factory> ), 0, this, map);
        }

        @Override
        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_impl_ICULocaleService_SimpleLocaleKeyFactory$toString(), 0, this);
        }

        public /* synthetic */ SimpleLocaleKeyFactory() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SimpleLocaleKeyFactory)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class LocaleKeyFactory
    implements ICUService.Factory,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        protected String name;
        protected boolean visible;
        public static boolean VISIBLE = true;
        public static boolean INVISIBLE = false;

        private void $$robo$$android_icu_impl_ICULocaleService_LocaleKeyFactory$__constructor__(boolean visible) {
            this.visible = visible;
            this.name = null;
        }

        private void $$robo$$android_icu_impl_ICULocaleService_LocaleKeyFactory$__constructor__(boolean visible, String name) {
            this.visible = visible;
            this.name = name;
        }

        private final Object $$robo$$android_icu_impl_ICULocaleService_LocaleKeyFactory$create(ICUService.Key key, ICUService service) {
            if (this.handlesKey(key)) {
                LocaleKey lkey = (LocaleKey)key;
                int kind = lkey.kind();
                ULocale uloc = lkey.currentLocale();
                return this.handleCreate(uloc, kind, service);
            }
            return null;
        }

        private final boolean $$robo$$android_icu_impl_ICULocaleService_LocaleKeyFactory$handlesKey(ICUService.Key key) {
            if (key != null) {
                String id2 = key.currentID();
                Set<String> supported = this.getSupportedIDs();
                return supported.contains(id2);
            }
            return false;
        }

        private final void $$robo$$android_icu_impl_ICULocaleService_LocaleKeyFactory$updateVisibleIDs(Map<String, ICUService.Factory> result) {
            Set<String> cache = this.getSupportedIDs();
            for (String id2 : cache) {
                if (this.visible) {
                    result.put(id2, this);
                    continue;
                }
                result.remove(id2);
            }
        }

        private final String $$robo$$android_icu_impl_ICULocaleService_LocaleKeyFactory$getDisplayName(String id2, ULocale locale) {
            if (locale == null) {
                return id2;
            }
            ULocale loc = new ULocale(id2);
            return loc.getDisplayName(locale);
        }

        private final Object $$robo$$android_icu_impl_ICULocaleService_LocaleKeyFactory$handleCreate(ULocale loc, int kind, ICUService service) {
            return null;
        }

        private final boolean $$robo$$android_icu_impl_ICULocaleService_LocaleKeyFactory$isSupportedID(String id2) {
            return this.getSupportedIDs().contains(id2);
        }

        private final Set<String> $$robo$$android_icu_impl_ICULocaleService_LocaleKeyFactory$getSupportedIDs() {
            return Collections.emptySet();
        }

        private final String $$robo$$android_icu_impl_ICULocaleService_LocaleKeyFactory$toString() {
            StringBuilder buf = new StringBuilder(super.toString());
            if (this.name != null) {
                buf.append(", name: ");
                buf.append(this.name);
            }
            buf.append(", visible: ");
            buf.append(this.visible);
            return buf.toString();
        }

        private void __constructor__(boolean bl) {
            this.$$robo$$android_icu_impl_ICULocaleService_LocaleKeyFactory$__constructor__(bl);
        }

        protected LocaleKeyFactory(boolean bl) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_ICULocaleService_LocaleKeyFactory$__constructor__(boolean ), 0, this, bl);
        }

        private void __constructor__(boolean bl, String string2) {
            this.$$robo$$android_icu_impl_ICULocaleService_LocaleKeyFactory$__constructor__(bl, string2);
        }

        protected LocaleKeyFactory(boolean bl, String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_ICULocaleService_LocaleKeyFactory$__constructor__(boolean java.lang.String ), 0, this, bl, string2);
        }

        @Override
        public Object create(ICUService.Key key, ICUService iCUService) {
            return InvokeDynamicSupport.bootstrap("create", $$robo$$android_icu_impl_ICULocaleService_LocaleKeyFactory$create(android.icu.impl.ICUService$Key android.icu.impl.ICUService ), 0, this, key, iCUService);
        }

        protected boolean handlesKey(ICUService.Key key) {
            return (boolean)InvokeDynamicSupport.bootstrap("handlesKey", $$robo$$android_icu_impl_ICULocaleService_LocaleKeyFactory$handlesKey(android.icu.impl.ICUService$Key ), 0, this, key);
        }

        @Override
        public void updateVisibleIDs(Map<String, ICUService.Factory> map) {
            InvokeDynamicSupport.bootstrap("updateVisibleIDs", $$robo$$android_icu_impl_ICULocaleService_LocaleKeyFactory$updateVisibleIDs(java.util.Map<java.lang.String, android.icu.impl.ICUService$Factory> ), 0, this, map);
        }

        @Override
        public String getDisplayName(String string2, ULocale uLocale) {
            return InvokeDynamicSupport.bootstrap("getDisplayName", $$robo$$android_icu_impl_ICULocaleService_LocaleKeyFactory$getDisplayName(java.lang.String android.icu.util.ULocale ), 0, this, string2, uLocale);
        }

        protected Object handleCreate(ULocale uLocale, int n, ICUService iCUService) {
            return InvokeDynamicSupport.bootstrap("handleCreate", $$robo$$android_icu_impl_ICULocaleService_LocaleKeyFactory$handleCreate(android.icu.util.ULocale int android.icu.impl.ICUService ), 0, this, uLocale, n, iCUService);
        }

        protected boolean isSupportedID(String string2) {
            return (boolean)InvokeDynamicSupport.bootstrap("isSupportedID", $$robo$$android_icu_impl_ICULocaleService_LocaleKeyFactory$isSupportedID(java.lang.String ), 0, this, string2);
        }

        protected Set<String> getSupportedIDs() {
            return InvokeDynamicSupport.bootstrap("getSupportedIDs", $$robo$$android_icu_impl_ICULocaleService_LocaleKeyFactory$getSupportedIDs(), 0, this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_impl_ICULocaleService_LocaleKeyFactory$toString(), 0, this);
        }

        public /* synthetic */ LocaleKeyFactory() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LocaleKeyFactory)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class LocaleKey
    extends ICUService.Key
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int kind;
        private int varstart;
        private String primaryID;
        private String fallbackID;
        private String currentID;
        public static int KIND_ANY = -1;

        private static final LocaleKey $$robo$$android_icu_impl_ICULocaleService_LocaleKey$createWithCanonicalFallback(String primaryID, String canonicalFallbackID) {
            return LocaleKey.createWithCanonicalFallback(primaryID, canonicalFallbackID, -1);
        }

        private static final LocaleKey $$robo$$android_icu_impl_ICULocaleService_LocaleKey$createWithCanonicalFallback(String primaryID, String canonicalFallbackID, int kind) {
            if (primaryID == null) {
                return null;
            }
            String canonicalPrimaryID = ULocale.getName(primaryID);
            return new LocaleKey(primaryID, canonicalPrimaryID, canonicalFallbackID, kind);
        }

        private static final LocaleKey $$robo$$android_icu_impl_ICULocaleService_LocaleKey$createWithCanonical(ULocale locale, String canonicalFallbackID, int kind) {
            if (locale == null) {
                return null;
            }
            String canonicalPrimaryID = locale.getName();
            return new LocaleKey(canonicalPrimaryID, canonicalPrimaryID, canonicalFallbackID, kind);
        }

        private void $$robo$$android_icu_impl_ICULocaleService_LocaleKey$__constructor__(String primaryID, String canonicalPrimaryID, String canonicalFallbackID, int kind) {
            this.kind = kind;
            if (canonicalPrimaryID == null || canonicalPrimaryID.equalsIgnoreCase("root")) {
                this.primaryID = "";
                this.fallbackID = null;
            } else {
                int idx = canonicalPrimaryID.indexOf(64);
                if (idx == 4 && canonicalPrimaryID.regionMatches(true, 0, "root", 0, 4)) {
                    this.primaryID = canonicalPrimaryID.substring(4);
                    this.varstart = 0;
                    this.fallbackID = null;
                } else {
                    this.primaryID = canonicalPrimaryID;
                    this.varstart = idx;
                    this.fallbackID = canonicalFallbackID == null || this.primaryID.equals(canonicalFallbackID) ? "" : canonicalFallbackID;
                }
            }
            this.currentID = this.varstart == -1 ? this.primaryID : this.primaryID.substring(0, this.varstart);
        }

        private final String $$robo$$android_icu_impl_ICULocaleService_LocaleKey$prefix() {
            return this.kind == -1 ? null : Integer.toString(this.kind());
        }

        private final int $$robo$$android_icu_impl_ICULocaleService_LocaleKey$kind() {
            return this.kind;
        }

        private final String $$robo$$android_icu_impl_ICULocaleService_LocaleKey$canonicalID() {
            return this.primaryID;
        }

        private final String $$robo$$android_icu_impl_ICULocaleService_LocaleKey$currentID() {
            return this.currentID;
        }

        private final String $$robo$$android_icu_impl_ICULocaleService_LocaleKey$currentDescriptor() {
            String result = this.currentID();
            if (result != null) {
                StringBuilder buf = new StringBuilder();
                if (this.kind != -1) {
                    buf.append(this.prefix());
                }
                buf.append('/');
                buf.append(result);
                if (this.varstart != -1) {
                    buf.append(this.primaryID.substring(this.varstart, this.primaryID.length()));
                }
                result = buf.toString();
            }
            return result;
        }

        private final ULocale $$robo$$android_icu_impl_ICULocaleService_LocaleKey$canonicalLocale() {
            return new ULocale(this.primaryID);
        }

        private final ULocale $$robo$$android_icu_impl_ICULocaleService_LocaleKey$currentLocale() {
            if (this.varstart == -1) {
                return new ULocale(this.currentID);
            }
            return new ULocale(this.currentID + this.primaryID.substring(this.varstart));
        }

        private final boolean $$robo$$android_icu_impl_ICULocaleService_LocaleKey$fallback() {
            int x = this.currentID.lastIndexOf(95);
            if (x != -1) {
                while (--x >= 0 && this.currentID.charAt(x) == '_') {
                }
                this.currentID = this.currentID.substring(0, x + 1);
                return true;
            }
            if (this.fallbackID != null) {
                this.currentID = this.fallbackID;
                this.fallbackID = this.fallbackID.length() == 0 ? null : "";
                return true;
            }
            this.currentID = null;
            return false;
        }

        private final boolean $$robo$$android_icu_impl_ICULocaleService_LocaleKey$isFallbackOf(String id2) {
            return LocaleUtility.isFallbackOf(this.canonicalID(), id2);
        }

        public static LocaleKey createWithCanonicalFallback(String string2, String string3) {
            return InvokeDynamicSupport.bootstrapStatic("createWithCanonicalFallback", $$robo$$android_icu_impl_ICULocaleService_LocaleKey$createWithCanonicalFallback(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
        }

        public static LocaleKey createWithCanonicalFallback(String string2, String string3, int n) {
            return InvokeDynamicSupport.bootstrapStatic("createWithCanonicalFallback", $$robo$$android_icu_impl_ICULocaleService_LocaleKey$createWithCanonicalFallback(java.lang.String java.lang.String int ), 0, (String)string2, (String)string3, (int)n);
        }

        public static LocaleKey createWithCanonical(ULocale uLocale, String string2, int n) {
            return InvokeDynamicSupport.bootstrapStatic("createWithCanonical", $$robo$$android_icu_impl_ICULocaleService_LocaleKey$createWithCanonical(android.icu.util.ULocale java.lang.String int ), 0, (ULocale)uLocale, (String)string2, (int)n);
        }

        private void __constructor__(String string2, String string3, String string4, int n) {
            this.$$robo$$android_icu_impl_ICULocaleService_LocaleKey$__constructor__(string2, string3, string4, n);
        }

        protected LocaleKey(String string2, String string3, String string4, int n) {
            super(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_ICULocaleService_LocaleKey$__constructor__(java.lang.String java.lang.String java.lang.String int ), 0, this, string2, string3, string4, n);
        }

        public String prefix() {
            return InvokeDynamicSupport.bootstrap("prefix", $$robo$$android_icu_impl_ICULocaleService_LocaleKey$prefix(), 0, this);
        }

        public int kind() {
            return (int)InvokeDynamicSupport.bootstrap("kind", $$robo$$android_icu_impl_ICULocaleService_LocaleKey$kind(), 0, this);
        }

        @Override
        public String canonicalID() {
            return InvokeDynamicSupport.bootstrap("canonicalID", $$robo$$android_icu_impl_ICULocaleService_LocaleKey$canonicalID(), 0, this);
        }

        @Override
        public String currentID() {
            return InvokeDynamicSupport.bootstrap("currentID", $$robo$$android_icu_impl_ICULocaleService_LocaleKey$currentID(), 0, this);
        }

        @Override
        public String currentDescriptor() {
            return InvokeDynamicSupport.bootstrap("currentDescriptor", $$robo$$android_icu_impl_ICULocaleService_LocaleKey$currentDescriptor(), 0, this);
        }

        public ULocale canonicalLocale() {
            return InvokeDynamicSupport.bootstrap("canonicalLocale", $$robo$$android_icu_impl_ICULocaleService_LocaleKey$canonicalLocale(), 0, this);
        }

        public ULocale currentLocale() {
            return InvokeDynamicSupport.bootstrap("currentLocale", $$robo$$android_icu_impl_ICULocaleService_LocaleKey$currentLocale(), 0, this);
        }

        @Override
        public boolean fallback() {
            return (boolean)InvokeDynamicSupport.bootstrap("fallback", $$robo$$android_icu_impl_ICULocaleService_LocaleKey$fallback(), 0, this);
        }

        @Override
        public boolean isFallbackOf(String string2) {
            return (boolean)InvokeDynamicSupport.bootstrap("isFallbackOf", $$robo$$android_icu_impl_ICULocaleService_LocaleKey$isFallbackOf(java.lang.String ), 0, this, string2);
        }

        public /* synthetic */ LocaleKey() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LocaleKey)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

