/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl;

import android.icu.impl.ICUDebug;
import android.icu.impl.ICUNotifier;
import android.icu.impl.ICURWLock;
import android.icu.util.ULocale;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ICUService
extends ICUNotifier
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    protected String name;
    private static boolean DEBUG;
    private ICURWLock factoryLock;
    private List<Factory> factories;
    private int defaultSize;
    private Map<String, CacheEntry> cache;
    private Map<String, Factory> idcache;
    private LocaleRef dnref;

    private void $$robo$$android_icu_impl_ICUService$__constructor__() {
        this.factoryLock = new ICURWLock();
        this.factories = new ArrayList<Factory>();
        this.defaultSize = 0;
        this.name = "";
    }

    private void $$robo$$android_icu_impl_ICUService$__constructor__(String name) {
        this.factoryLock = new ICURWLock();
        this.factories = new ArrayList<Factory>();
        this.defaultSize = 0;
        this.name = name;
    }

    private final Object $$robo$$android_icu_impl_ICUService$get(String descriptor) {
        return this.getKey(this.createKey(descriptor), null);
    }

    private final Object $$robo$$android_icu_impl_ICUService$get(String descriptor, String[] actualReturn) {
        if (descriptor == null) {
            throw new NullPointerException("descriptor must not be null");
        }
        return this.getKey(this.createKey(descriptor), actualReturn);
    }

    private final Object $$robo$$android_icu_impl_ICUService$getKey(Key key) {
        return this.getKey(key, null);
    }

    private final Object $$robo$$android_icu_impl_ICUService$getKey(Key key, String[] actualReturn) {
        return this.getKey(key, actualReturn, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object $$robo$$android_icu_impl_ICUService$getKey(Key key, String[] actualReturn, Factory factory) {
        if (this.factories.size() == 0) {
            return this.handleDefault(key, actualReturn);
        }
        if (DEBUG) {
            System.out.println("Service: " + this.name + " key: " + key.canonicalID());
        }
        CacheEntry result = null;
        if (key != null) {
            try {
                this.factoryLock.acquireRead();
                Map<String, CacheEntry> cache = this.cache;
                if (cache == null) {
                    if (DEBUG) {
                        System.out.println("Service " + this.name + " cache was empty");
                    }
                    cache = new ConcurrentHashMap<String, CacheEntry>();
                }
                String currentDescriptor = null;
                ArrayList<String> cacheDescriptorList = null;
                boolean putInCache = false;
                int NDebug = 0;
                int startIndex = 0;
                int limit = this.factories.size();
                boolean cacheResult = true;
                if (factory != null) {
                    for (int i = 0; i < limit; ++i) {
                        if (factory != this.factories.get(i)) continue;
                        startIndex = i + 1;
                        break;
                    }
                    if (startIndex == 0) {
                        throw new IllegalStateException("Factory " + factory + "not registered with service: " + this);
                    }
                    cacheResult = false;
                }
                block4: do {
                    currentDescriptor = key.currentDescriptor();
                    if (DEBUG) {
                        System.out.println(this.name + "[" + NDebug++ + "] looking for: " + currentDescriptor);
                    }
                    if ((result = cache.get(currentDescriptor)) != null) {
                        if (!DEBUG) break;
                        System.out.println(this.name + " found with descriptor: " + currentDescriptor);
                        break;
                    }
                    if (DEBUG) {
                        System.out.println("did not find: " + currentDescriptor + " in cache");
                    }
                    putInCache = cacheResult;
                    int index = startIndex;
                    while (index < limit) {
                        Object service;
                        Factory f = this.factories.get(index++);
                        if (DEBUG) {
                            System.out.println("trying factory[" + (index - 1) + "] " + f.toString());
                        }
                        if ((service = f.create(key, this)) != null) {
                            result = new CacheEntry(currentDescriptor, service);
                            if (!DEBUG) break block4;
                            System.out.println(this.name + " factory supported: " + currentDescriptor + ", caching");
                            break block4;
                        }
                        if (!DEBUG) continue;
                        System.out.println("factory did not support: " + currentDescriptor);
                    }
                    if (cacheDescriptorList == null) {
                        cacheDescriptorList = new ArrayList<String>(5);
                    }
                    cacheDescriptorList.add(currentDescriptor);
                } while (key.fallback());
                if (result != null) {
                    if (putInCache) {
                        if (DEBUG) {
                            System.out.println("caching '" + result.actualDescriptor + "'");
                        }
                        cache.put(result.actualDescriptor, result);
                        if (cacheDescriptorList != null) {
                            for (String desc : cacheDescriptorList) {
                                if (DEBUG) {
                                    System.out.println(this.name + " adding descriptor: '" + desc + "' for actual: '" + result.actualDescriptor + "'");
                                }
                                cache.put(desc, result);
                            }
                        }
                        this.cache = cache;
                    }
                    if (actualReturn != null) {
                        actualReturn[0] = result.actualDescriptor.indexOf("/") == 0 ? result.actualDescriptor.substring(1) : result.actualDescriptor;
                    }
                    if (DEBUG) {
                        System.out.println("found in service: " + this.name);
                    }
                    Object object = result.service;
                    return object;
                }
            }
            finally {
                this.factoryLock.releaseRead();
            }
        }
        if (DEBUG) {
            System.out.println("not found in service: " + this.name);
        }
        return this.handleDefault(key, actualReturn);
    }

    private final Object $$robo$$android_icu_impl_ICUService$handleDefault(Key key, String[] actualIDReturn) {
        return null;
    }

    private final Set<String> $$robo$$android_icu_impl_ICUService$getVisibleIDs() {
        return this.getVisibleIDs(null);
    }

    private final Set<String> $$robo$$android_icu_impl_ICUService$getVisibleIDs(String matchID) {
        Set<String> result = this.getVisibleIDMap().keySet();
        Key fallbackKey = this.createKey(matchID);
        if (fallbackKey != null) {
            HashSet<String> temp = new HashSet<String>(result.size());
            for (String id2 : result) {
                if (!fallbackKey.isFallbackOf(id2)) continue;
                temp.add(id2);
            }
            result = temp;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<String, Factory> $$robo$$android_icu_impl_ICUService$getVisibleIDMap() {
        ICUService iCUService = this;
        synchronized (iCUService) {
            if (this.idcache == null) {
                try {
                    this.factoryLock.acquireRead();
                    HashMap<String, Factory> mutableMap = new HashMap<String, Factory>();
                    ListIterator<Factory> lIter = this.factories.listIterator(this.factories.size());
                    while (lIter.hasPrevious()) {
                        Factory f = lIter.previous();
                        f.updateVisibleIDs(mutableMap);
                    }
                    this.idcache = Collections.unmodifiableMap(mutableMap);
                }
                finally {
                    this.factoryLock.releaseRead();
                }
            }
        }
        return this.idcache;
    }

    private final String $$robo$$android_icu_impl_ICUService$getDisplayName(String id2) {
        return this.getDisplayName(id2, ULocale.getDefault(ULocale.Category.DISPLAY));
    }

    private final String $$robo$$android_icu_impl_ICUService$getDisplayName(String id2, ULocale locale) {
        Map<String, Factory> m = this.getVisibleIDMap();
        Factory f = m.get(id2);
        if (f != null) {
            return f.getDisplayName(id2, locale);
        }
        Key key = this.createKey(id2);
        while (key.fallback()) {
            f = m.get(key.currentID());
            if (f == null) continue;
            return f.getDisplayName(id2, locale);
        }
        return null;
    }

    private final SortedMap<String, String> $$robo$$android_icu_impl_ICUService$getDisplayNames() {
        ULocale locale = ULocale.getDefault(ULocale.Category.DISPLAY);
        return this.getDisplayNames(locale, null, null);
    }

    private final SortedMap<String, String> $$robo$$android_icu_impl_ICUService$getDisplayNames(ULocale locale) {
        return this.getDisplayNames(locale, null, null);
    }

    private final SortedMap<String, String> $$robo$$android_icu_impl_ICUService$getDisplayNames(ULocale locale, Comparator<Object> com) {
        return this.getDisplayNames(locale, com, null);
    }

    private final SortedMap<String, String> $$robo$$android_icu_impl_ICUService$getDisplayNames(ULocale locale, String matchID) {
        return this.getDisplayNames(locale, null, matchID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SortedMap<String, String> $$robo$$android_icu_impl_ICUService$getDisplayNames(ULocale locale, Comparator<Object> com, String matchID) {
        SortedMap<String, String> dncache = null;
        LocaleRef ref = this.dnref;
        if (ref != null) {
            dncache = ref.get(locale, com);
        }
        while (dncache == null) {
            ICUService iCUService = this;
            synchronized (iCUService) {
                if (ref == this.dnref || this.dnref == null) {
                    dncache = new TreeMap<Object, String>(com);
                    Map<String, Factory> m = this.getVisibleIDMap();
                    for (Map.Entry<String, Factory> entry : m.entrySet()) {
                        String id2 = entry.getKey();
                        Factory f = entry.getValue();
                        dncache.put(f.getDisplayName(id2, locale), id2);
                    }
                    dncache = Collections.unmodifiableSortedMap(dncache);
                    this.dnref = new LocaleRef(dncache, locale, com);
                } else {
                    ref = this.dnref;
                    dncache = ref.get(locale, com);
                }
            }
        }
        Key matchKey = this.createKey(matchID);
        if (matchKey == null) {
            return dncache;
        }
        TreeMap<String, String> result = new TreeMap<String, String>(dncache);
        Iterator iter = result.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (matchKey.isFallbackOf((String)entry.getValue())) continue;
            iter.remove();
        }
        return result;
    }

    private final List<Factory> $$robo$$android_icu_impl_ICUService$factories() {
        try {
            this.factoryLock.acquireRead();
            ArrayList<Factory> arrayList = new ArrayList<Factory>(this.factories);
            return arrayList;
        }
        finally {
            this.factoryLock.releaseRead();
        }
    }

    private final Factory $$robo$$android_icu_impl_ICUService$registerObject(Object obj, String id2) {
        return this.registerObject(obj, id2, true);
    }

    private final Factory $$robo$$android_icu_impl_ICUService$registerObject(Object obj, String id2, boolean visible) {
        String canonicalID = this.createKey(id2).canonicalID();
        return this.registerFactory(new SimpleFactory(obj, canonicalID, visible));
    }

    private final Factory $$robo$$android_icu_impl_ICUService$registerFactory(Factory factory) {
        if (factory == null) {
            throw new NullPointerException();
        }
        try {
            this.factoryLock.acquireWrite();
            this.factories.add(0, factory);
            this.clearCaches();
        }
        finally {
            this.factoryLock.releaseWrite();
        }
        this.notifyChanged();
        return factory;
    }

    private final boolean $$robo$$android_icu_impl_ICUService$unregisterFactory(Factory factory) {
        if (factory == null) {
            throw new NullPointerException();
        }
        boolean result = false;
        try {
            this.factoryLock.acquireWrite();
            if (this.factories.remove(factory)) {
                result = true;
                this.clearCaches();
            }
        }
        finally {
            this.factoryLock.releaseWrite();
        }
        if (result) {
            this.notifyChanged();
        }
        return result;
    }

    private final void $$robo$$android_icu_impl_ICUService$reset() {
        try {
            this.factoryLock.acquireWrite();
            this.reInitializeFactories();
            this.clearCaches();
        }
        finally {
            this.factoryLock.releaseWrite();
        }
        this.notifyChanged();
    }

    private final void $$robo$$android_icu_impl_ICUService$reInitializeFactories() {
        this.factories.clear();
    }

    private final boolean $$robo$$android_icu_impl_ICUService$isDefault() {
        return this.factories.size() == this.defaultSize;
    }

    private final void $$robo$$android_icu_impl_ICUService$markDefault() {
        this.defaultSize = this.factories.size();
    }

    private final Key $$robo$$android_icu_impl_ICUService$createKey(String id2) {
        return id2 == null ? null : new Key(id2);
    }

    private final void $$robo$$android_icu_impl_ICUService$clearCaches() {
        this.cache = null;
        this.idcache = null;
        this.dnref = null;
    }

    private final void $$robo$$android_icu_impl_ICUService$clearServiceCache() {
        this.cache = null;
    }

    private final boolean $$robo$$android_icu_impl_ICUService$acceptsListener(EventListener l) {
        return l instanceof ServiceListener;
    }

    private final void $$robo$$android_icu_impl_ICUService$notifyListener(EventListener l) {
        ((ServiceListener)l).serviceChanged(this);
    }

    private final String $$robo$$android_icu_impl_ICUService$stats() {
        ICURWLock.Stats stats = this.factoryLock.resetStats();
        if (stats != null) {
            return stats.toString();
        }
        return "no stats";
    }

    private final String $$robo$$android_icu_impl_ICUService$getName() {
        return this.name;
    }

    private final String $$robo$$android_icu_impl_ICUService$toString() {
        return super.toString() + "{" + this.name + "}";
    }

    static void __staticInitializer__() {
        DEBUG = ICUDebug.enabled("service");
    }

    private void __constructor__() {
        this.$$robo$$android_icu_impl_ICUService$__constructor__();
    }

    public ICUService() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_ICUService$__constructor__(), 0, this);
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_icu_impl_ICUService$__constructor__(string2);
    }

    public ICUService(String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_ICUService$__constructor__(java.lang.String ), 0, this, string2);
    }

    public Object get(String string2) {
        return InvokeDynamicSupport.bootstrap("get", $$robo$$android_icu_impl_ICUService$get(java.lang.String ), 0, this, string2);
    }

    public Object get(String string2, String[] stringArray) {
        return InvokeDynamicSupport.bootstrap("get", $$robo$$android_icu_impl_ICUService$get(java.lang.String java.lang.String[] ), 0, this, string2, stringArray);
    }

    public Object getKey(Key key) {
        return InvokeDynamicSupport.bootstrap("getKey", $$robo$$android_icu_impl_ICUService$getKey(android.icu.impl.ICUService$Key ), 0, this, key);
    }

    public Object getKey(Key key, String[] stringArray) {
        return InvokeDynamicSupport.bootstrap("getKey", $$robo$$android_icu_impl_ICUService$getKey(android.icu.impl.ICUService$Key java.lang.String[] ), 0, this, key, stringArray);
    }

    public Object getKey(Key key, String[] stringArray, Factory factory) {
        return InvokeDynamicSupport.bootstrap("getKey", $$robo$$android_icu_impl_ICUService$getKey(android.icu.impl.ICUService$Key java.lang.String[] android.icu.impl.ICUService$Factory ), 0, this, key, stringArray, factory);
    }

    protected Object handleDefault(Key key, String[] stringArray) {
        return InvokeDynamicSupport.bootstrap("handleDefault", $$robo$$android_icu_impl_ICUService$handleDefault(android.icu.impl.ICUService$Key java.lang.String[] ), 0, this, key, stringArray);
    }

    public Set<String> getVisibleIDs() {
        return InvokeDynamicSupport.bootstrap("getVisibleIDs", $$robo$$android_icu_impl_ICUService$getVisibleIDs(), 0, this);
    }

    public Set<String> getVisibleIDs(String string2) {
        return InvokeDynamicSupport.bootstrap("getVisibleIDs", $$robo$$android_icu_impl_ICUService$getVisibleIDs(java.lang.String ), 0, this, string2);
    }

    private Map<String, Factory> getVisibleIDMap() {
        return InvokeDynamicSupport.bootstrap("getVisibleIDMap", $$robo$$android_icu_impl_ICUService$getVisibleIDMap(), 0, this);
    }

    public String getDisplayName(String string2) {
        return InvokeDynamicSupport.bootstrap("getDisplayName", $$robo$$android_icu_impl_ICUService$getDisplayName(java.lang.String ), 0, this, string2);
    }

    public String getDisplayName(String string2, ULocale uLocale) {
        return InvokeDynamicSupport.bootstrap("getDisplayName", $$robo$$android_icu_impl_ICUService$getDisplayName(java.lang.String android.icu.util.ULocale ), 0, this, string2, uLocale);
    }

    public SortedMap<String, String> getDisplayNames() {
        return InvokeDynamicSupport.bootstrap("getDisplayNames", $$robo$$android_icu_impl_ICUService$getDisplayNames(), 0, this);
    }

    public SortedMap<String, String> getDisplayNames(ULocale uLocale) {
        return InvokeDynamicSupport.bootstrap("getDisplayNames", $$robo$$android_icu_impl_ICUService$getDisplayNames(android.icu.util.ULocale ), 0, this, uLocale);
    }

    public SortedMap<String, String> getDisplayNames(ULocale uLocale, Comparator<Object> comparator) {
        return InvokeDynamicSupport.bootstrap("getDisplayNames", $$robo$$android_icu_impl_ICUService$getDisplayNames(android.icu.util.ULocale java.util.Comparator<java.lang.Object> ), 0, this, uLocale, comparator);
    }

    public SortedMap<String, String> getDisplayNames(ULocale uLocale, String string2) {
        return InvokeDynamicSupport.bootstrap("getDisplayNames", $$robo$$android_icu_impl_ICUService$getDisplayNames(android.icu.util.ULocale java.lang.String ), 0, this, uLocale, string2);
    }

    public SortedMap<String, String> getDisplayNames(ULocale uLocale, Comparator<Object> comparator, String string2) {
        return InvokeDynamicSupport.bootstrap("getDisplayNames", $$robo$$android_icu_impl_ICUService$getDisplayNames(android.icu.util.ULocale java.util.Comparator<java.lang.Object> java.lang.String ), 0, this, uLocale, comparator, string2);
    }

    public List<Factory> factories() {
        return InvokeDynamicSupport.bootstrap("factories", $$robo$$android_icu_impl_ICUService$factories(), 0, this);
    }

    public Factory registerObject(Object object, String string2) {
        return InvokeDynamicSupport.bootstrap("registerObject", $$robo$$android_icu_impl_ICUService$registerObject(java.lang.Object java.lang.String ), 0, this, object, string2);
    }

    public Factory registerObject(Object object, String string2, boolean bl) {
        return InvokeDynamicSupport.bootstrap("registerObject", $$robo$$android_icu_impl_ICUService$registerObject(java.lang.Object java.lang.String boolean ), 0, this, object, string2, bl);
    }

    public Factory registerFactory(Factory factory) {
        return InvokeDynamicSupport.bootstrap("registerFactory", $$robo$$android_icu_impl_ICUService$registerFactory(android.icu.impl.ICUService$Factory ), 0, this, factory);
    }

    public boolean unregisterFactory(Factory factory) {
        return (boolean)InvokeDynamicSupport.bootstrap("unregisterFactory", $$robo$$android_icu_impl_ICUService$unregisterFactory(android.icu.impl.ICUService$Factory ), 0, this, factory);
    }

    public void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$android_icu_impl_ICUService$reset(), 0, this);
    }

    protected void reInitializeFactories() {
        InvokeDynamicSupport.bootstrap("reInitializeFactories", $$robo$$android_icu_impl_ICUService$reInitializeFactories(), 0, this);
    }

    public boolean isDefault() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDefault", $$robo$$android_icu_impl_ICUService$isDefault(), 0, this);
    }

    protected void markDefault() {
        InvokeDynamicSupport.bootstrap("markDefault", $$robo$$android_icu_impl_ICUService$markDefault(), 0, this);
    }

    public Key createKey(String string2) {
        return InvokeDynamicSupport.bootstrap("createKey", $$robo$$android_icu_impl_ICUService$createKey(java.lang.String ), 0, this, string2);
    }

    protected void clearCaches() {
        InvokeDynamicSupport.bootstrap("clearCaches", $$robo$$android_icu_impl_ICUService$clearCaches(), 0, this);
    }

    protected void clearServiceCache() {
        InvokeDynamicSupport.bootstrap("clearServiceCache", $$robo$$android_icu_impl_ICUService$clearServiceCache(), 0, this);
    }

    @Override
    protected boolean acceptsListener(EventListener eventListener) {
        return (boolean)InvokeDynamicSupport.bootstrap("acceptsListener", $$robo$$android_icu_impl_ICUService$acceptsListener(java.util.EventListener ), 0, this, eventListener);
    }

    @Override
    protected void notifyListener(EventListener eventListener) {
        InvokeDynamicSupport.bootstrap("notifyListener", $$robo$$android_icu_impl_ICUService$notifyListener(java.util.EventListener ), 0, this, eventListener);
    }

    public String stats() {
        return InvokeDynamicSupport.bootstrap("stats", $$robo$$android_icu_impl_ICUService$stats(), 0, this);
    }

    public String getName() {
        return InvokeDynamicSupport.bootstrap("getName", $$robo$$android_icu_impl_ICUService$getName(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_impl_ICUService$toString(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(ICUService.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ICUService)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface ServiceListener
    extends EventListener,
    InstrumentedInterface {
        public void serviceChanged(ICUService var1);
    }

    private static class LocaleRef
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private ULocale locale;
        private SortedMap<String, String> dnCache;
        private Comparator<Object> com;

        private void $$robo$$android_icu_impl_ICUService_LocaleRef$__constructor__(SortedMap<String, String> dnCache, ULocale locale, Comparator<Object> com) {
            this.locale = locale;
            this.com = com;
            this.dnCache = dnCache;
        }

        private final SortedMap<String, String> $$robo$$android_icu_impl_ICUService_LocaleRef$get(ULocale loc, Comparator<Object> comp) {
            SortedMap<String, String> m = this.dnCache;
            if (m != null && this.locale.equals(loc) && (this.com == comp || this.com != null && this.com.equals(comp))) {
                return m;
            }
            return null;
        }

        private void __constructor__(SortedMap<String, String> sortedMap, ULocale uLocale, Comparator<Object> comparator) {
            this.$$robo$$android_icu_impl_ICUService_LocaleRef$__constructor__(sortedMap, uLocale, comparator);
        }

        LocaleRef(SortedMap<String, String> sortedMap, ULocale uLocale, Comparator<Object> comparator) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_ICUService_LocaleRef$__constructor__(java.util.SortedMap<java.lang.String, java.lang.String> android.icu.util.ULocale java.util.Comparator<java.lang.Object> ), 0, this, sortedMap, uLocale, comparator);
        }

        SortedMap<String, String> get(ULocale uLocale, Comparator<Object> comparator) {
            return InvokeDynamicSupport.bootstrap("get", $$robo$$android_icu_impl_ICUService_LocaleRef$get(android.icu.util.ULocale java.util.Comparator<java.lang.Object> ), 0, this, uLocale, comparator);
        }

        public /* synthetic */ LocaleRef() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LocaleRef)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class CacheEntry
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        String actualDescriptor;
        Object service;

        private void $$robo$$android_icu_impl_ICUService_CacheEntry$__constructor__(String actualDescriptor, Object service) {
            this.actualDescriptor = actualDescriptor;
            this.service = service;
        }

        private void __constructor__(String string2, Object object) {
            this.$$robo$$android_icu_impl_ICUService_CacheEntry$__constructor__(string2, object);
        }

        CacheEntry(String string2, Object object) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_ICUService_CacheEntry$__constructor__(java.lang.String java.lang.Object ), 0, this, string2, object);
        }

        public /* synthetic */ CacheEntry() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CacheEntry)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class SimpleFactory
    implements Factory,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        protected Object instance;
        protected String id;
        protected boolean visible;

        private void $$robo$$android_icu_impl_ICUService_SimpleFactory$__constructor__(Object instance, String id2) {
        }

        private void $$robo$$android_icu_impl_ICUService_SimpleFactory$__constructor__(Object instance, String id2, boolean visible) {
            if (instance == null || id2 == null) {
                throw new IllegalArgumentException("Instance or id is null");
            }
            this.instance = instance;
            this.id = id2;
            this.visible = visible;
        }

        private final Object $$robo$$android_icu_impl_ICUService_SimpleFactory$create(Key key, ICUService service) {
            if (this.id.equals(key.currentID())) {
                return this.instance;
            }
            return null;
        }

        private final void $$robo$$android_icu_impl_ICUService_SimpleFactory$updateVisibleIDs(Map<String, Factory> result) {
            if (this.visible) {
                result.put(this.id, this);
            } else {
                result.remove(this.id);
            }
        }

        private final String $$robo$$android_icu_impl_ICUService_SimpleFactory$getDisplayName(String identifier, ULocale locale) {
            return this.visible && this.id.equals(identifier) ? identifier : null;
        }

        private final String $$robo$$android_icu_impl_ICUService_SimpleFactory$toString() {
            StringBuilder buf = new StringBuilder(super.toString());
            buf.append(", id: ");
            buf.append(this.id);
            buf.append(", visible: ");
            buf.append(this.visible);
            return buf.toString();
        }

        private void __constructor__(Object object, String string2) {
            this.$$robo$$android_icu_impl_ICUService_SimpleFactory$__constructor__(object, string2);
        }

        public SimpleFactory(Object object, String string2) {
            this(object, string2, true);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_ICUService_SimpleFactory$__constructor__(java.lang.Object java.lang.String ), 0, this, object, string2);
        }

        private void __constructor__(Object object, String string2, boolean bl) {
            this.$$robo$$android_icu_impl_ICUService_SimpleFactory$__constructor__(object, string2, bl);
        }

        public SimpleFactory(Object object, String string2, boolean bl) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_ICUService_SimpleFactory$__constructor__(java.lang.Object java.lang.String boolean ), 0, this, object, string2, bl);
        }

        @Override
        public Object create(Key key, ICUService iCUService) {
            return InvokeDynamicSupport.bootstrap("create", $$robo$$android_icu_impl_ICUService_SimpleFactory$create(android.icu.impl.ICUService$Key android.icu.impl.ICUService ), 0, this, key, iCUService);
        }

        @Override
        public void updateVisibleIDs(Map<String, Factory> map) {
            InvokeDynamicSupport.bootstrap("updateVisibleIDs", $$robo$$android_icu_impl_ICUService_SimpleFactory$updateVisibleIDs(java.util.Map<java.lang.String, android.icu.impl.ICUService$Factory> ), 0, this, map);
        }

        @Override
        public String getDisplayName(String string2, ULocale uLocale) {
            return InvokeDynamicSupport.bootstrap("getDisplayName", $$robo$$android_icu_impl_ICUService_SimpleFactory$getDisplayName(java.lang.String android.icu.util.ULocale ), 0, this, string2, uLocale);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_icu_impl_ICUService_SimpleFactory$toString(), 0, this);
        }

        public /* synthetic */ SimpleFactory() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SimpleFactory)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface Factory
    extends InstrumentedInterface {
        public Object create(Key var1, ICUService var2);

        public void updateVisibleIDs(Map<String, Factory> var1);

        public String getDisplayName(String var1, ULocale var2);
    }

    public static class Key
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private String id;

        private void $$robo$$android_icu_impl_ICUService_Key$__constructor__(String id2) {
            this.id = id2;
        }

        private final String $$robo$$android_icu_impl_ICUService_Key$id() {
            return this.id;
        }

        private final String $$robo$$android_icu_impl_ICUService_Key$canonicalID() {
            return this.id;
        }

        private final String $$robo$$android_icu_impl_ICUService_Key$currentID() {
            return this.canonicalID();
        }

        private final String $$robo$$android_icu_impl_ICUService_Key$currentDescriptor() {
            return "/" + this.currentID();
        }

        private final boolean $$robo$$android_icu_impl_ICUService_Key$fallback() {
            return false;
        }

        private final boolean $$robo$$android_icu_impl_ICUService_Key$isFallbackOf(String idToCheck) {
            return this.canonicalID().equals(idToCheck);
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_icu_impl_ICUService_Key$__constructor__(string2);
        }

        public Key(String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_ICUService_Key$__constructor__(java.lang.String ), 0, this, string2);
        }

        public String id() {
            return InvokeDynamicSupport.bootstrap("id", $$robo$$android_icu_impl_ICUService_Key$id(), 0, this);
        }

        public String canonicalID() {
            return InvokeDynamicSupport.bootstrap("canonicalID", $$robo$$android_icu_impl_ICUService_Key$canonicalID(), 0, this);
        }

        public String currentID() {
            return InvokeDynamicSupport.bootstrap("currentID", $$robo$$android_icu_impl_ICUService_Key$currentID(), 0, this);
        }

        public String currentDescriptor() {
            return InvokeDynamicSupport.bootstrap("currentDescriptor", $$robo$$android_icu_impl_ICUService_Key$currentDescriptor(), 0, this);
        }

        public boolean fallback() {
            return (boolean)InvokeDynamicSupport.bootstrap("fallback", $$robo$$android_icu_impl_ICUService_Key$fallback(), 0, this);
        }

        public boolean isFallbackOf(String string2) {
            return (boolean)InvokeDynamicSupport.bootstrap("isFallbackOf", $$robo$$android_icu_impl_ICUService_Key$isFallbackOf(java.lang.String ), 0, this, string2);
        }

        public /* synthetic */ Key() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Key)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

