/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl;

import android.icu.impl.Grego;
import android.icu.impl.ICUResourceBundle;
import android.icu.impl.SoftCache;
import android.icu.impl.TextTrieMap;
import android.icu.impl.UResource;
import android.icu.impl.Utility;
import android.icu.impl.ZoneMeta;
import android.icu.text.TimeZoneNames;
import android.icu.util.TimeZone;
import android.icu.util.ULocale;
import android.icu.util.UResourceBundle;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TimeZoneNamesImpl
extends TimeZoneNames
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static long serialVersionUID = -2179814848495897472L;
    private static String ZONE_STRINGS_BUNDLE = "zoneStrings";
    private static String MZ_PREFIX = "meta:";
    private static volatile Set<String> METAZONE_IDS;
    private static TZ2MZsCache TZ_TO_MZS_CACHE;
    private static MZ2TZsCache MZ_TO_TZS_CACHE;
    private transient ICUResourceBundle _zoneStrings;
    private transient ConcurrentHashMap<String, ZNames> _mzNamesMap;
    private transient ConcurrentHashMap<String, ZNames> _tzNamesMap;
    private transient boolean _namesFullyLoaded;
    private transient TextTrieMap<NameInfo> _namesTrie;
    private transient boolean _namesTrieFullyLoaded;
    private static Pattern LOC_EXCLUSION_PATTERN;

    private void $$robo$$android_icu_impl_TimeZoneNamesImpl$__constructor__(ULocale locale) {
        this.initialize(locale);
    }

    private final Set<String> $$robo$$android_icu_impl_TimeZoneNamesImpl$getAvailableMetaZoneIDs() {
        return TimeZoneNamesImpl._getAvailableMetaZoneIDs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Set<String> $$robo$$android_icu_impl_TimeZoneNamesImpl$_getAvailableMetaZoneIDs() {
        if (METAZONE_IDS != null) return METAZONE_IDS;
        Class<TimeZoneNamesImpl> clazz = TimeZoneNamesImpl.class;
        synchronized (TimeZoneNamesImpl.class) {
            if (METAZONE_IDS != null) return METAZONE_IDS;
            UResourceBundle bundle = UResourceBundle.getBundleInstance("android/icu/impl/data/icudt58b", "metaZones");
            UResourceBundle mapTimezones = bundle.get("mapTimezones");
            Set<String> keys = mapTimezones.keySet();
            METAZONE_IDS = Collections.unmodifiableSet(keys);
            // ** MonitorExit[var0] (shouldn't be in output)
            return METAZONE_IDS;
        }
    }

    private final Set<String> $$robo$$android_icu_impl_TimeZoneNamesImpl$getAvailableMetaZoneIDs(String tzID) {
        return TimeZoneNamesImpl._getAvailableMetaZoneIDs(tzID);
    }

    private static final Set<String> $$robo$$android_icu_impl_TimeZoneNamesImpl$_getAvailableMetaZoneIDs(String tzID) {
        if (tzID == null || tzID.length() == 0) {
            return Collections.emptySet();
        }
        List maps = (List)TZ_TO_MZS_CACHE.getInstance(tzID, tzID);
        if (maps.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> mzIDs = new HashSet<String>(maps.size());
        for (MZMapEntry map : maps) {
            mzIDs.add(map.mzID());
        }
        return Collections.unmodifiableSet(mzIDs);
    }

    private final String $$robo$$android_icu_impl_TimeZoneNamesImpl$getMetaZoneID(String tzID, long date) {
        return TimeZoneNamesImpl._getMetaZoneID(tzID, date);
    }

    private static final String $$robo$$android_icu_impl_TimeZoneNamesImpl$_getMetaZoneID(String tzID, long date) {
        if (tzID == null || tzID.length() == 0) {
            return null;
        }
        String mzID = null;
        List maps = (List)TZ_TO_MZS_CACHE.getInstance(tzID, tzID);
        for (MZMapEntry map : maps) {
            if (date < map.from() || date >= map.to()) continue;
            mzID = map.mzID();
            break;
        }
        return mzID;
    }

    private final String $$robo$$android_icu_impl_TimeZoneNamesImpl$getReferenceZoneID(String mzID, String region) {
        return TimeZoneNamesImpl._getReferenceZoneID(mzID, region);
    }

    private static final String $$robo$$android_icu_impl_TimeZoneNamesImpl$_getReferenceZoneID(String mzID, String region) {
        if (mzID == null || mzID.length() == 0) {
            return null;
        }
        String refID = null;
        Map regionTzMap = (Map)MZ_TO_TZS_CACHE.getInstance(mzID, mzID);
        if (!regionTzMap.isEmpty() && (refID = (String)regionTzMap.get(region)) == null) {
            refID = (String)regionTzMap.get("001");
        }
        return refID;
    }

    private final String $$robo$$android_icu_impl_TimeZoneNamesImpl$getMetaZoneDisplayName(String mzID, TimeZoneNames.NameType type) {
        if (mzID == null || mzID.length() == 0) {
            return null;
        }
        return this.loadMetaZoneNames(mzID).getName(type);
    }

    private final String $$robo$$android_icu_impl_TimeZoneNamesImpl$getTimeZoneDisplayName(String tzID, TimeZoneNames.NameType type) {
        if (tzID == null || tzID.length() == 0) {
            return null;
        }
        return this.loadTimeZoneNames(tzID).getName(type);
    }

    private final String $$robo$$android_icu_impl_TimeZoneNamesImpl$getExemplarLocationName(String tzID) {
        if (tzID == null || tzID.length() == 0) {
            return null;
        }
        String locName = this.loadTimeZoneNames(tzID).getName(TimeZoneNames.NameType.EXEMPLAR_LOCATION);
        return locName;
    }

    private final synchronized Collection<TimeZoneNames.MatchInfo> $$robo$$android_icu_impl_TimeZoneNamesImpl$find(CharSequence text, int start, EnumSet<TimeZoneNames.NameType> nameTypes) {
        if (text == null || text.length() == 0 || start < 0 || start >= text.length()) {
            throw new IllegalArgumentException("bad input text or range");
        }
        NameSearchHandler handler = new NameSearchHandler(nameTypes);
        Collection<TimeZoneNames.MatchInfo> matches = this.doFind(handler, text, start);
        if (matches != null) {
            return matches;
        }
        this.addAllNamesIntoTrie();
        matches = this.doFind(handler, text, start);
        if (matches != null) {
            return matches;
        }
        this.internalLoadAllDisplayNames();
        Set<String> tzIDs = TimeZone.getAvailableIDs(TimeZone.SystemTimeZoneType.CANONICAL, null, null);
        for (String tzID : tzIDs) {
            if (this._tzNamesMap.containsKey(tzID)) continue;
            ZNames.createTimeZoneAndPutInCache(this._tzNamesMap, null, tzID);
        }
        this.addAllNamesIntoTrie();
        this._namesTrieFullyLoaded = true;
        return this.doFind(handler, text, start);
    }

    private final Collection<TimeZoneNames.MatchInfo> $$robo$$android_icu_impl_TimeZoneNamesImpl$doFind(NameSearchHandler handler, CharSequence text, int start) {
        handler.resetResults();
        this._namesTrie.find(text, start, (TextTrieMap.ResultHandler<NameInfo>)handler);
        if (handler.getMaxMatchLen() == text.length() - start || this._namesTrieFullyLoaded) {
            return handler.getMatches();
        }
        return null;
    }

    private final synchronized void $$robo$$android_icu_impl_TimeZoneNamesImpl$loadAllDisplayNames() {
        this.internalLoadAllDisplayNames();
    }

    private final void $$robo$$android_icu_impl_TimeZoneNamesImpl$getDisplayNames(String tzID, TimeZoneNames.NameType[] types, long date, String[] dest, int destOffset) {
        if (tzID == null || tzID.length() == 0) {
            return;
        }
        ZNames tzNames = this.loadTimeZoneNames(tzID);
        ZNames mzNames = null;
        for (int i = 0; i < types.length; ++i) {
            TimeZoneNames.NameType type = types[i];
            String name = tzNames.getName(type);
            if (name == null) {
                if (mzNames == null) {
                    String mzID = this.getMetaZoneID(tzID, date);
                    mzNames = mzID == null || mzID.length() == 0 ? ZNames.EMPTY_ZNAMES : this.loadMetaZoneNames(mzID);
                }
                name = mzNames.getName(type);
            }
            dest[destOffset + i] = name;
        }
    }

    private final void $$robo$$android_icu_impl_TimeZoneNamesImpl$internalLoadAllDisplayNames() {
        if (!this._namesFullyLoaded) {
            this._namesFullyLoaded = true;
            new ZoneStringsLoader(this).load();
        }
    }

    private final void $$robo$$android_icu_impl_TimeZoneNamesImpl$addAllNamesIntoTrie() {
        for (Map.Entry<String, ZNames> entry : this._tzNamesMap.entrySet()) {
            entry.getValue().addAsTimeZoneIntoTrie(entry.getKey(), this._namesTrie);
        }
        for (Map.Entry<String, ZNames> entry : this._mzNamesMap.entrySet()) {
            entry.getValue().addAsMetaZoneIntoTrie(entry.getKey(), this._namesTrie);
        }
    }

    private final void $$robo$$android_icu_impl_TimeZoneNamesImpl$initialize(ULocale locale) {
        ICUResourceBundle bundle = (ICUResourceBundle)ICUResourceBundle.getBundleInstance("android/icu/impl/data/icudt58b/zone", locale);
        this._zoneStrings = (ICUResourceBundle)bundle.get("zoneStrings");
        this._tzNamesMap = new ConcurrentHashMap();
        this._mzNamesMap = new ConcurrentHashMap();
        this._namesFullyLoaded = false;
        this._namesTrie = new TextTrieMap(true);
        this._namesTrieFullyLoaded = false;
        TimeZone tz = TimeZone.getDefault();
        String tzCanonicalID = ZoneMeta.getCanonicalCLDRID(tz);
        if (tzCanonicalID != null) {
            this.loadStrings(tzCanonicalID);
        }
    }

    private final synchronized void $$robo$$android_icu_impl_TimeZoneNamesImpl$loadStrings(String tzCanonicalID) {
        if (tzCanonicalID == null || tzCanonicalID.length() == 0) {
            return;
        }
        this.loadTimeZoneNames(tzCanonicalID);
        Set<String> mzIDs = this.getAvailableMetaZoneIDs(tzCanonicalID);
        for (String mzID : mzIDs) {
            this.loadMetaZoneNames(mzID);
        }
    }

    private final void $$robo$$android_icu_impl_TimeZoneNamesImpl$writeObject(ObjectOutputStream out) throws IOException {
        ULocale locale = this._zoneStrings.getULocale();
        out.writeObject(locale);
    }

    private final void $$robo$$android_icu_impl_TimeZoneNamesImpl$readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ULocale locale = (ULocale)in.readObject();
        this.initialize(locale);
    }

    private final synchronized ZNames $$robo$$android_icu_impl_TimeZoneNamesImpl$loadMetaZoneNames(String mzID) {
        ZNames mznames = this._mzNamesMap.get(mzID);
        if (mznames == null) {
            ZNamesLoader loader = new ZNamesLoader();
            loader.loadMetaZone(this._zoneStrings, mzID);
            mznames = ZNames.createMetaZoneAndPutInCache(this._mzNamesMap, loader.getNames(), mzID);
        }
        return mznames;
    }

    private final synchronized ZNames $$robo$$android_icu_impl_TimeZoneNamesImpl$loadTimeZoneNames(String tzID) {
        ZNames tznames = this._tzNamesMap.get(tzID);
        if (tznames == null) {
            ZNamesLoader loader = new ZNamesLoader();
            loader.loadTimeZone(this._zoneStrings, tzID);
            tznames = ZNames.createTimeZoneAndPutInCache(this._tzNamesMap, loader.getNames(), tzID);
        }
        return tznames;
    }

    private static final String $$robo$$android_icu_impl_TimeZoneNamesImpl$getDefaultExemplarLocationName(String tzID) {
        if (tzID == null || tzID.length() == 0 || LOC_EXCLUSION_PATTERN.matcher(tzID).matches()) {
            return null;
        }
        String location = null;
        int sep = tzID.lastIndexOf(47);
        if (sep > 0 && sep + 1 < tzID.length()) {
            location = tzID.substring(sep + 1).replace('_', ' ');
        }
        return location;
    }

    static void __staticInitializer__() {
        TZ_TO_MZS_CACHE = new TZ2MZsCache();
        MZ_TO_TZS_CACHE = new MZ2TZsCache();
        LOC_EXCLUSION_PATTERN = Pattern.compile("Etc/.*|SystemV/.*|.*/Riyadh8[7-9]");
    }

    private void __constructor__(ULocale uLocale) {
        this.$$robo$$android_icu_impl_TimeZoneNamesImpl$__constructor__(uLocale);
    }

    public TimeZoneNamesImpl(ULocale uLocale) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_TimeZoneNamesImpl$__constructor__(android.icu.util.ULocale ), 0, this, uLocale);
    }

    @Override
    public Set<String> getAvailableMetaZoneIDs() {
        return InvokeDynamicSupport.bootstrap("getAvailableMetaZoneIDs", $$robo$$android_icu_impl_TimeZoneNamesImpl$getAvailableMetaZoneIDs(), 0, this);
    }

    static Set<String> _getAvailableMetaZoneIDs() {
        return InvokeDynamicSupport.bootstrapStatic("_getAvailableMetaZoneIDs", $$robo$$android_icu_impl_TimeZoneNamesImpl$_getAvailableMetaZoneIDs(), 0);
    }

    @Override
    public Set<String> getAvailableMetaZoneIDs(String string2) {
        return InvokeDynamicSupport.bootstrap("getAvailableMetaZoneIDs", $$robo$$android_icu_impl_TimeZoneNamesImpl$getAvailableMetaZoneIDs(java.lang.String ), 0, this, string2);
    }

    static Set<String> _getAvailableMetaZoneIDs(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("_getAvailableMetaZoneIDs", $$robo$$android_icu_impl_TimeZoneNamesImpl$_getAvailableMetaZoneIDs(java.lang.String ), 0, (String)string2);
    }

    @Override
    public String getMetaZoneID(String string2, long l) {
        return InvokeDynamicSupport.bootstrap("getMetaZoneID", $$robo$$android_icu_impl_TimeZoneNamesImpl$getMetaZoneID(java.lang.String long ), 0, this, string2, l);
    }

    static String _getMetaZoneID(String string2, long l) {
        return InvokeDynamicSupport.bootstrapStatic("_getMetaZoneID", $$robo$$android_icu_impl_TimeZoneNamesImpl$_getMetaZoneID(java.lang.String long ), 0, (String)string2, (long)l);
    }

    @Override
    public String getReferenceZoneID(String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("getReferenceZoneID", $$robo$$android_icu_impl_TimeZoneNamesImpl$getReferenceZoneID(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    static String _getReferenceZoneID(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("_getReferenceZoneID", $$robo$$android_icu_impl_TimeZoneNamesImpl$_getReferenceZoneID(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    @Override
    public String getMetaZoneDisplayName(String string2, TimeZoneNames.NameType nameType) {
        return InvokeDynamicSupport.bootstrap("getMetaZoneDisplayName", $$robo$$android_icu_impl_TimeZoneNamesImpl$getMetaZoneDisplayName(java.lang.String android.icu.text.TimeZoneNames$NameType ), 0, this, string2, nameType);
    }

    @Override
    public String getTimeZoneDisplayName(String string2, TimeZoneNames.NameType nameType) {
        return InvokeDynamicSupport.bootstrap("getTimeZoneDisplayName", $$robo$$android_icu_impl_TimeZoneNamesImpl$getTimeZoneDisplayName(java.lang.String android.icu.text.TimeZoneNames$NameType ), 0, this, string2, nameType);
    }

    @Override
    public String getExemplarLocationName(String string2) {
        return InvokeDynamicSupport.bootstrap("getExemplarLocationName", $$robo$$android_icu_impl_TimeZoneNamesImpl$getExemplarLocationName(java.lang.String ), 0, this, string2);
    }

    @Override
    public synchronized Collection<TimeZoneNames.MatchInfo> find(CharSequence charSequence, int n, EnumSet<TimeZoneNames.NameType> enumSet) {
        return InvokeDynamicSupport.bootstrap("find", $$robo$$android_icu_impl_TimeZoneNamesImpl$find(java.lang.CharSequence int java.util.EnumSet<android.icu.text.TimeZoneNames$NameType> ), 0, this, charSequence, n, enumSet);
    }

    private Collection<TimeZoneNames.MatchInfo> doFind(NameSearchHandler nameSearchHandler, CharSequence charSequence, int n) {
        return InvokeDynamicSupport.bootstrap("doFind", $$robo$$android_icu_impl_TimeZoneNamesImpl$doFind(android.icu.impl.TimeZoneNamesImpl$NameSearchHandler java.lang.CharSequence int ), 0, this, nameSearchHandler, charSequence, n);
    }

    @Override
    public synchronized void loadAllDisplayNames() {
        InvokeDynamicSupport.bootstrap("loadAllDisplayNames", $$robo$$android_icu_impl_TimeZoneNamesImpl$loadAllDisplayNames(), 0, this);
    }

    @Override
    public void getDisplayNames(String string2, TimeZoneNames.NameType[] nameTypeArray, long l, String[] stringArray, int n) {
        InvokeDynamicSupport.bootstrap("getDisplayNames", $$robo$$android_icu_impl_TimeZoneNamesImpl$getDisplayNames(java.lang.String android.icu.text.TimeZoneNames$NameType[] long java.lang.String[] int ), 0, this, string2, nameTypeArray, l, stringArray, n);
    }

    private void internalLoadAllDisplayNames() {
        InvokeDynamicSupport.bootstrap("internalLoadAllDisplayNames", $$robo$$android_icu_impl_TimeZoneNamesImpl$internalLoadAllDisplayNames(), 0, this);
    }

    private void addAllNamesIntoTrie() {
        InvokeDynamicSupport.bootstrap("addAllNamesIntoTrie", $$robo$$android_icu_impl_TimeZoneNamesImpl$addAllNamesIntoTrie(), 0, this);
    }

    private void initialize(ULocale uLocale) {
        InvokeDynamicSupport.bootstrap("initialize", $$robo$$android_icu_impl_TimeZoneNamesImpl$initialize(android.icu.util.ULocale ), 0, this, uLocale);
    }

    private synchronized void loadStrings(String string2) {
        InvokeDynamicSupport.bootstrap("loadStrings", $$robo$$android_icu_impl_TimeZoneNamesImpl$loadStrings(java.lang.String ), 0, this, string2);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        InvokeDynamicSupport.bootstrap("writeObject", $$robo$$android_icu_impl_TimeZoneNamesImpl$writeObject(java.io.ObjectOutputStream ), 0, this, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        InvokeDynamicSupport.bootstrap("readObject", $$robo$$android_icu_impl_TimeZoneNamesImpl$readObject(java.io.ObjectInputStream ), 0, this, objectInputStream);
    }

    private synchronized ZNames loadMetaZoneNames(String string2) {
        return InvokeDynamicSupport.bootstrap("loadMetaZoneNames", $$robo$$android_icu_impl_TimeZoneNamesImpl$loadMetaZoneNames(java.lang.String ), 0, this, string2);
    }

    private synchronized ZNames loadTimeZoneNames(String string2) {
        return InvokeDynamicSupport.bootstrap("loadTimeZoneNames", $$robo$$android_icu_impl_TimeZoneNamesImpl$loadTimeZoneNames(java.lang.String ), 0, this, string2);
    }

    public static String getDefaultExemplarLocationName(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getDefaultExemplarLocationName", $$robo$$android_icu_impl_TimeZoneNamesImpl$getDefaultExemplarLocationName(java.lang.String ), 0, (String)string2);
    }

    static {
        RobolectricInternals.classInitializing(TimeZoneNamesImpl.class);
    }

    public /* synthetic */ TimeZoneNamesImpl() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TimeZoneNamesImpl)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class MZ2TZsCache
    extends SoftCache<String, Map<String, String>, String> {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_icu_impl_TimeZoneNamesImpl_MZ2TZsCache$__constructor__() {
        }

        private final Map<String, String> $$robo$$android_icu_impl_TimeZoneNamesImpl_MZ2TZsCache$createInstance(String key, String data) {
            Map<String, String> map = null;
            UResourceBundle bundle = UResourceBundle.getBundleInstance("android/icu/impl/data/icudt58b", "metaZones");
            UResourceBundle mapTimezones = bundle.get("mapTimezones");
            try {
                UResourceBundle regionMap = mapTimezones.get(key);
                Set<String> regions = regionMap.keySet();
                map = new HashMap<String, String>(regions.size());
                for (String region : regions) {
                    String tzID = regionMap.getString(region).intern();
                    map.put(region.intern(), tzID);
                }
            }
            catch (MissingResourceException e) {
                map = Collections.emptyMap();
            }
            return map;
        }

        private /* synthetic */ void $$robo$$android_icu_impl_TimeZoneNamesImpl_MZ2TZsCache$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_icu_impl_TimeZoneNamesImpl_MZ2TZsCache$__constructor__();
        }

        private MZ2TZsCache() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_TimeZoneNamesImpl_MZ2TZsCache$__constructor__(), 0, this);
        }

        @Override
        protected Map<String, String> createInstance(String string2, String string3) {
            return InvokeDynamicSupport.bootstrap("createInstance", $$robo$$android_icu_impl_TimeZoneNamesImpl_MZ2TZsCache$createInstance(java.lang.String java.lang.String ), 0, this, string2, string3);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_icu_impl_TimeZoneNamesImpl_MZ2TZsCache$__constructor__(var1_1);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MZ2TZsCache)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class TZ2MZsCache
    extends SoftCache<String, List<MZMapEntry>, String> {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_icu_impl_TimeZoneNamesImpl_TZ2MZsCache$__constructor__() {
        }

        private final List<MZMapEntry> $$robo$$android_icu_impl_TimeZoneNamesImpl_TZ2MZsCache$createInstance(String key, String data) {
            List<MZMapEntry> mzMaps = null;
            UResourceBundle bundle = UResourceBundle.getBundleInstance("android/icu/impl/data/icudt58b", "metaZones");
            UResourceBundle metazoneInfoBundle = bundle.get("metazoneInfo");
            String tzkey = data.replace('/', ':');
            try {
                UResourceBundle zoneBundle = metazoneInfoBundle.get(tzkey);
                mzMaps = new ArrayList<MZMapEntry>(zoneBundle.getSize());
                for (int idx = 0; idx < zoneBundle.getSize(); ++idx) {
                    UResourceBundle mz = zoneBundle.get(idx);
                    String mzid = mz.getString(0);
                    String fromStr = "1970-01-01 00:00";
                    String toStr = "9999-12-31 23:59";
                    if (mz.getSize() == 3) {
                        fromStr = mz.getString(1);
                        toStr = mz.getString(2);
                    }
                    long from = TZ2MZsCache.parseDate(fromStr);
                    long to = TZ2MZsCache.parseDate(toStr);
                    mzMaps.add(new MZMapEntry(mzid, from, to));
                }
            }
            catch (MissingResourceException mre) {
                mzMaps = Collections.emptyList();
            }
            return mzMaps;
        }

        private static final long $$robo$$android_icu_impl_TimeZoneNamesImpl_TZ2MZsCache$parseDate(String text) {
            int n;
            int idx;
            int year = 0;
            int month = 0;
            int day = 0;
            int hour = 0;
            int min = 0;
            for (idx = 0; idx <= 3; ++idx) {
                n = text.charAt(idx) - 48;
                if (n < 0 || n >= 10) {
                    throw new IllegalArgumentException("Bad year");
                }
                year = 10 * year + n;
            }
            for (idx = 5; idx <= 6; ++idx) {
                n = text.charAt(idx) - 48;
                if (n < 0 || n >= 10) {
                    throw new IllegalArgumentException("Bad month");
                }
                month = 10 * month + n;
            }
            for (idx = 8; idx <= 9; ++idx) {
                n = text.charAt(idx) - 48;
                if (n < 0 || n >= 10) {
                    throw new IllegalArgumentException("Bad day");
                }
                day = 10 * day + n;
            }
            for (idx = 11; idx <= 12; ++idx) {
                n = text.charAt(idx) - 48;
                if (n < 0 || n >= 10) {
                    throw new IllegalArgumentException("Bad hour");
                }
                hour = 10 * hour + n;
            }
            for (idx = 14; idx <= 15; ++idx) {
                n = text.charAt(idx) - 48;
                if (n < 0 || n >= 10) {
                    throw new IllegalArgumentException("Bad minute");
                }
                min = 10 * min + n;
            }
            long date = Grego.fieldsToDay(year, month - 1, day) * 86400000L + (long)hour * 3600000L + (long)min * 60000L;
            return date;
        }

        private /* synthetic */ void $$robo$$android_icu_impl_TimeZoneNamesImpl_TZ2MZsCache$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_icu_impl_TimeZoneNamesImpl_TZ2MZsCache$__constructor__();
        }

        private TZ2MZsCache() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_TimeZoneNamesImpl_TZ2MZsCache$__constructor__(), 0, this);
        }

        @Override
        protected List<MZMapEntry> createInstance(String string2, String string3) {
            return InvokeDynamicSupport.bootstrap("createInstance", $$robo$$android_icu_impl_TimeZoneNamesImpl_TZ2MZsCache$createInstance(java.lang.String java.lang.String ), 0, this, string2, string3);
        }

        private static long parseDate(String string2) {
            return (long)InvokeDynamicSupport.bootstrapStatic("parseDate", $$robo$$android_icu_impl_TimeZoneNamesImpl_TZ2MZsCache$parseDate(java.lang.String ), 0, (String)string2);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_icu_impl_TimeZoneNamesImpl_TZ2MZsCache$__constructor__(var1_1);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TZ2MZsCache)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class MZMapEntry
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private String _mzID;
        private long _from;
        private long _to;

        private void $$robo$$android_icu_impl_TimeZoneNamesImpl_MZMapEntry$__constructor__(String mzID, long from, long to) {
            this._mzID = mzID;
            this._from = from;
            this._to = to;
        }

        private final String $$robo$$android_icu_impl_TimeZoneNamesImpl_MZMapEntry$mzID() {
            return this._mzID;
        }

        private final long $$robo$$android_icu_impl_TimeZoneNamesImpl_MZMapEntry$from() {
            return this._from;
        }

        private final long $$robo$$android_icu_impl_TimeZoneNamesImpl_MZMapEntry$to() {
            return this._to;
        }

        private void __constructor__(String string2, long l, long l2) {
            this.$$robo$$android_icu_impl_TimeZoneNamesImpl_MZMapEntry$__constructor__(string2, l, l2);
        }

        MZMapEntry(String string2, long l, long l2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_TimeZoneNamesImpl_MZMapEntry$__constructor__(java.lang.String long long ), 0, this, string2, l, l2);
        }

        String mzID() {
            return InvokeDynamicSupport.bootstrap("mzID", $$robo$$android_icu_impl_TimeZoneNamesImpl_MZMapEntry$mzID(), 0, this);
        }

        long from() {
            return (long)InvokeDynamicSupport.bootstrap("from", $$robo$$android_icu_impl_TimeZoneNamesImpl_MZMapEntry$from(), 0, this);
        }

        long to() {
            return (long)InvokeDynamicSupport.bootstrap("to", $$robo$$android_icu_impl_TimeZoneNamesImpl_MZMapEntry$to(), 0, this);
        }

        public /* synthetic */ MZMapEntry() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MZMapEntry)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class ZNames
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int NUM_NAME_TYPES = 7;
        static ZNames EMPTY_ZNAMES;
        private static int EX_LOC_INDEX;
        private String[] _names;
        private boolean didAddIntoTrie;

        private static final int $$robo$$android_icu_impl_TimeZoneNamesImpl_ZNames$getNameTypeIndex(TimeZoneNames.NameType type) {
            switch (1.$SwitchMap$android$icu$text$TimeZoneNames$NameType[type.ordinal()]) {
                case 1: {
                    return NameTypeIndex.EXEMPLAR_LOCATION.ordinal();
                }
                case 2: {
                    return NameTypeIndex.LONG_GENERIC.ordinal();
                }
                case 3: {
                    return NameTypeIndex.LONG_STANDARD.ordinal();
                }
                case 4: {
                    return NameTypeIndex.LONG_DAYLIGHT.ordinal();
                }
                case 5: {
                    return NameTypeIndex.SHORT_GENERIC.ordinal();
                }
                case 6: {
                    return NameTypeIndex.SHORT_STANDARD.ordinal();
                }
                case 7: {
                    return NameTypeIndex.SHORT_DAYLIGHT.ordinal();
                }
            }
            throw new AssertionError((Object)("No NameTypeIndex match for " + (Object)((Object)type)));
        }

        private static final TimeZoneNames.NameType $$robo$$android_icu_impl_TimeZoneNamesImpl_ZNames$getNameType(int index) {
            switch (1.$SwitchMap$android$icu$impl$TimeZoneNamesImpl$ZNames$NameTypeIndex[NameTypeIndex.values[index].ordinal()]) {
                case 1: {
                    return TimeZoneNames.NameType.EXEMPLAR_LOCATION;
                }
                case 2: {
                    return TimeZoneNames.NameType.LONG_GENERIC;
                }
                case 3: {
                    return TimeZoneNames.NameType.LONG_STANDARD;
                }
                case 4: {
                    return TimeZoneNames.NameType.LONG_DAYLIGHT;
                }
                case 5: {
                    return TimeZoneNames.NameType.SHORT_GENERIC;
                }
                case 6: {
                    return TimeZoneNames.NameType.SHORT_STANDARD;
                }
                case 7: {
                    return TimeZoneNames.NameType.SHORT_DAYLIGHT;
                }
            }
            throw new AssertionError((Object)("No NameType match for " + index));
        }

        private void $$robo$$android_icu_impl_TimeZoneNamesImpl_ZNames$__constructor__(String[] names) {
            this._names = names;
            this.didAddIntoTrie = names == null;
        }

        private static final ZNames $$robo$$android_icu_impl_TimeZoneNamesImpl_ZNames$createMetaZoneAndPutInCache(Map<String, ZNames> cache, String[] names, String mzID) {
            String key = mzID.intern();
            ZNames value = names == null ? EMPTY_ZNAMES : new ZNames(names);
            cache.put(key, value);
            return value;
        }

        private static final ZNames $$robo$$android_icu_impl_TimeZoneNamesImpl_ZNames$createTimeZoneAndPutInCache(Map<String, ZNames> cache, String[] names, String tzID) {
            String[] stringArray = names = names == null ? new String[EX_LOC_INDEX + 1] : names;
            if (names[EX_LOC_INDEX] == null) {
                names[ZNames.EX_LOC_INDEX] = TimeZoneNamesImpl.getDefaultExemplarLocationName(tzID);
            }
            String key = tzID.intern();
            ZNames value = new ZNames(names);
            cache.put(key, value);
            return value;
        }

        private final String $$robo$$android_icu_impl_TimeZoneNamesImpl_ZNames$getName(TimeZoneNames.NameType type) {
            int index = ZNames.getNameTypeIndex(type);
            if (this._names != null && index < this._names.length) {
                return this._names[index];
            }
            return null;
        }

        private final void $$robo$$android_icu_impl_TimeZoneNamesImpl_ZNames$addAsMetaZoneIntoTrie(String mzID, TextTrieMap<NameInfo> trie) {
            this.addNamesIntoTrie(mzID, null, trie);
        }

        private final void $$robo$$android_icu_impl_TimeZoneNamesImpl_ZNames$addAsTimeZoneIntoTrie(String tzID, TextTrieMap<NameInfo> trie) {
            this.addNamesIntoTrie(null, tzID, trie);
        }

        private final void $$robo$$android_icu_impl_TimeZoneNamesImpl_ZNames$addNamesIntoTrie(String mzID, String tzID, TextTrieMap<NameInfo> trie) {
            if (this._names == null || this.didAddIntoTrie) {
                return;
            }
            this.didAddIntoTrie = true;
            for (int i = 0; i < this._names.length; ++i) {
                String name = this._names[i];
                if (name == null) continue;
                NameInfo info = new NameInfo();
                info.mzID = mzID;
                info.tzID = tzID;
                info.type = ZNames.getNameType(i);
                trie.put(name, info);
            }
        }

        static void __staticInitializer__() {
            EMPTY_ZNAMES = new ZNames(null);
            EX_LOC_INDEX = NameTypeIndex.EXEMPLAR_LOCATION.ordinal();
        }

        private static int getNameTypeIndex(TimeZoneNames.NameType nameType) {
            return (int)InvokeDynamicSupport.bootstrapStatic("getNameTypeIndex", $$robo$$android_icu_impl_TimeZoneNamesImpl_ZNames$getNameTypeIndex(android.icu.text.TimeZoneNames$NameType ), 0, (TimeZoneNames.NameType)nameType);
        }

        private static TimeZoneNames.NameType getNameType(int n) {
            return InvokeDynamicSupport.bootstrapStatic("getNameType", $$robo$$android_icu_impl_TimeZoneNamesImpl_ZNames$getNameType(int ), 0, (int)n);
        }

        private void __constructor__(String[] stringArray) {
            this.$$robo$$android_icu_impl_TimeZoneNamesImpl_ZNames$__constructor__(stringArray);
        }

        protected ZNames(String[] stringArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_TimeZoneNamesImpl_ZNames$__constructor__(java.lang.String[] ), 0, this, stringArray);
        }

        public static ZNames createMetaZoneAndPutInCache(Map<String, ZNames> map, String[] stringArray, String string2) {
            return InvokeDynamicSupport.bootstrapStatic("createMetaZoneAndPutInCache", $$robo$$android_icu_impl_TimeZoneNamesImpl_ZNames$createMetaZoneAndPutInCache(java.util.Map<java.lang.String, android.icu.impl.TimeZoneNamesImpl$ZNames> java.lang.String[] java.lang.String ), 0, map, (String[])stringArray, (String)string2);
        }

        public static ZNames createTimeZoneAndPutInCache(Map<String, ZNames> map, String[] stringArray, String string2) {
            return InvokeDynamicSupport.bootstrapStatic("createTimeZoneAndPutInCache", $$robo$$android_icu_impl_TimeZoneNamesImpl_ZNames$createTimeZoneAndPutInCache(java.util.Map<java.lang.String, android.icu.impl.TimeZoneNamesImpl$ZNames> java.lang.String[] java.lang.String ), 0, map, (String[])stringArray, (String)string2);
        }

        public String getName(TimeZoneNames.NameType nameType) {
            return InvokeDynamicSupport.bootstrap("getName", $$robo$$android_icu_impl_TimeZoneNamesImpl_ZNames$getName(android.icu.text.TimeZoneNames$NameType ), 0, this, nameType);
        }

        public void addAsMetaZoneIntoTrie(String string2, TextTrieMap<NameInfo> textTrieMap) {
            InvokeDynamicSupport.bootstrap("addAsMetaZoneIntoTrie", $$robo$$android_icu_impl_TimeZoneNamesImpl_ZNames$addAsMetaZoneIntoTrie(java.lang.String android.icu.impl.TextTrieMap<android.icu.impl.TimeZoneNamesImpl$NameInfo> ), 0, this, string2, textTrieMap);
        }

        public void addAsTimeZoneIntoTrie(String string2, TextTrieMap<NameInfo> textTrieMap) {
            InvokeDynamicSupport.bootstrap("addAsTimeZoneIntoTrie", $$robo$$android_icu_impl_TimeZoneNamesImpl_ZNames$addAsTimeZoneIntoTrie(java.lang.String android.icu.impl.TextTrieMap<android.icu.impl.TimeZoneNamesImpl$NameInfo> ), 0, this, string2, textTrieMap);
        }

        private void addNamesIntoTrie(String string2, String string3, TextTrieMap<NameInfo> textTrieMap) {
            InvokeDynamicSupport.bootstrap("addNamesIntoTrie", $$robo$$android_icu_impl_TimeZoneNamesImpl_ZNames$addNamesIntoTrie(java.lang.String java.lang.String android.icu.impl.TextTrieMap<android.icu.impl.TimeZoneNamesImpl$NameInfo> ), 0, this, string2, string3, textTrieMap);
        }

        static {
            RobolectricInternals.classInitializing(ZNames.class);
        }

        public /* synthetic */ ZNames() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ZNames)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
        private static final class NameTypeIndex
        extends Enum<NameTypeIndex> {
            public transient /* synthetic */ Object __robo_data__;
            public static /* enum */ NameTypeIndex EXEMPLAR_LOCATION;
            public static /* enum */ NameTypeIndex LONG_GENERIC;
            public static /* enum */ NameTypeIndex LONG_STANDARD;
            public static /* enum */ NameTypeIndex LONG_DAYLIGHT;
            public static /* enum */ NameTypeIndex SHORT_GENERIC;
            public static /* enum */ NameTypeIndex SHORT_STANDARD;
            public static /* enum */ NameTypeIndex SHORT_DAYLIGHT;
            static NameTypeIndex[] values;
            private static /* synthetic */ NameTypeIndex[] $VALUES;

            private static final NameTypeIndex[] $$robo$$android_icu_impl_TimeZoneNamesImpl_ZNames_NameTypeIndex$values() {
                return (NameTypeIndex[])$VALUES.clone();
            }

            private static final NameTypeIndex $$robo$$android_icu_impl_TimeZoneNamesImpl_ZNames_NameTypeIndex$valueOf(String name) {
                return Enum.valueOf(NameTypeIndex.class, name);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            private void $$robo$$android_icu_impl_TimeZoneNamesImpl_ZNames_NameTypeIndex$__constructor__(String string2, int n) {
            }

            static void __staticInitializer__() {
                EXEMPLAR_LOCATION = new NameTypeIndex();
                LONG_GENERIC = new NameTypeIndex();
                LONG_STANDARD = new NameTypeIndex();
                LONG_DAYLIGHT = new NameTypeIndex();
                SHORT_GENERIC = new NameTypeIndex();
                SHORT_STANDARD = new NameTypeIndex();
                SHORT_DAYLIGHT = new NameTypeIndex();
                $VALUES = new NameTypeIndex[]{EXEMPLAR_LOCATION, LONG_GENERIC, LONG_STANDARD, LONG_DAYLIGHT, SHORT_GENERIC, SHORT_STANDARD, SHORT_DAYLIGHT};
                values = NameTypeIndex.values();
            }

            public static NameTypeIndex[] values() {
                return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_icu_impl_TimeZoneNamesImpl_ZNames_NameTypeIndex$values(), 0);
            }

            public static NameTypeIndex valueOf(String string2) {
                return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_icu_impl_TimeZoneNamesImpl_ZNames_NameTypeIndex$valueOf(java.lang.String ), 0, (String)string2);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            private void __constructor__(String string2, int n) {
                this.$$robo$$android_icu_impl_TimeZoneNamesImpl_ZNames_NameTypeIndex$__constructor__(string2, n);
            }

            private NameTypeIndex() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_TimeZoneNamesImpl_ZNames_NameTypeIndex$__constructor__(java.lang.String int ), 0, this, string2, n);
            }

            static {
                RobolectricInternals.classInitializing(NameTypeIndex.class);
            }

            public /* synthetic */ NameTypeIndex() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NameTypeIndex)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class ZNamesLoader
    extends UResource.Sink
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private String[] names;
        private static ZNamesLoader DUMMY_LOADER;
        static /* synthetic */ boolean $assertionsDisabled;

        private void $$robo$$android_icu_impl_TimeZoneNamesImpl_ZNamesLoader$__constructor__() {
        }

        private final void $$robo$$android_icu_impl_TimeZoneNamesImpl_ZNamesLoader$loadMetaZone(ICUResourceBundle zoneStrings, String mzID) {
            String key = "meta:" + mzID;
            this.loadNames(zoneStrings, key);
        }

        private final void $$robo$$android_icu_impl_TimeZoneNamesImpl_ZNamesLoader$loadTimeZone(ICUResourceBundle zoneStrings, String tzID) {
            String key = tzID.replace('/', ':');
            this.loadNames(zoneStrings, key);
        }

        private final void $$robo$$android_icu_impl_TimeZoneNamesImpl_ZNamesLoader$loadNames(ICUResourceBundle zoneStrings, String key) {
            if (!$assertionsDisabled && zoneStrings == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && key == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && key.length() <= 0) {
                throw new AssertionError();
            }
            this.names = null;
            try {
                zoneStrings.getAllItemsWithFallback(key, this);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }

        private static final ZNames.NameTypeIndex $$robo$$android_icu_impl_TimeZoneNamesImpl_ZNamesLoader$nameTypeIndexFromKey(UResource.Key key) {
            if (key.length() != 2) {
                return null;
            }
            char c0 = key.charAt(0);
            char c1 = key.charAt(1);
            if (c0 == 'l') {
                return c1 == 'g' ? ZNames.NameTypeIndex.LONG_GENERIC : (c1 == 's' ? ZNames.NameTypeIndex.LONG_STANDARD : (c1 == 'd' ? ZNames.NameTypeIndex.LONG_DAYLIGHT : null));
            }
            if (c0 == 's') {
                return c1 == 'g' ? ZNames.NameTypeIndex.SHORT_GENERIC : (c1 == 's' ? ZNames.NameTypeIndex.SHORT_STANDARD : (c1 == 'd' ? ZNames.NameTypeIndex.SHORT_DAYLIGHT : null));
            }
            if (c0 == 'e' && c1 == 'c') {
                return ZNames.NameTypeIndex.EXEMPLAR_LOCATION;
            }
            return null;
        }

        private final void $$robo$$android_icu_impl_TimeZoneNamesImpl_ZNamesLoader$setNameIfEmpty(UResource.Key key, UResource.Value value) {
            ZNames.NameTypeIndex index;
            if (this.names == null) {
                this.names = new String[7];
            }
            if ((index = ZNamesLoader.nameTypeIndexFromKey(key)) == null) {
                return;
            }
            if (!$assertionsDisabled && index.ordinal() >= 7) {
                throw new AssertionError();
            }
            if (this.names[index.ordinal()] == null) {
                this.names[index.ordinal()] = value.getString();
            }
        }

        private final void $$robo$$android_icu_impl_TimeZoneNamesImpl_ZNamesLoader$put(UResource.Key key, UResource.Value value, boolean noFallback) {
            UResource.Table namesTable = value.getTable();
            int i = 0;
            while (namesTable.getKeyAndValue(i, key, value)) {
                if (!$assertionsDisabled && value.getType() != 0) {
                    throw new AssertionError();
                }
                this.setNameIfEmpty(key, value);
                ++i;
            }
        }

        private final String[] $$robo$$android_icu_impl_TimeZoneNamesImpl_ZNamesLoader$getNames() {
            if (Utility.sameObjects(this.names, null)) {
                return null;
            }
            int length = 0;
            for (int i = 0; i < 7; ++i) {
                String name = this.names[i];
                if (name == null) continue;
                if (name.equals("\u2205\u2205\u2205")) {
                    this.names[i] = null;
                    continue;
                }
                length = i + 1;
            }
            Object result = length == 7 ? this.names : (length == 0 ? null : Arrays.copyOfRange(this.names, 0, length));
            return result;
        }

        private /* synthetic */ void $$robo$$android_icu_impl_TimeZoneNamesImpl_ZNamesLoader$__constructor__(1 x0) {
        }

        static void __staticInitializer__() {
            $assertionsDisabled = !TimeZoneNamesImpl.class.desiredAssertionStatus();
            DUMMY_LOADER = new ZNamesLoader();
        }

        private void __constructor__() {
            this.$$robo$$android_icu_impl_TimeZoneNamesImpl_ZNamesLoader$__constructor__();
        }

        private ZNamesLoader() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_TimeZoneNamesImpl_ZNamesLoader$__constructor__(), 0, this);
        }

        void loadMetaZone(ICUResourceBundle iCUResourceBundle, String string2) {
            InvokeDynamicSupport.bootstrap("loadMetaZone", $$robo$$android_icu_impl_TimeZoneNamesImpl_ZNamesLoader$loadMetaZone(android.icu.impl.ICUResourceBundle java.lang.String ), 0, this, iCUResourceBundle, string2);
        }

        void loadTimeZone(ICUResourceBundle iCUResourceBundle, String string2) {
            InvokeDynamicSupport.bootstrap("loadTimeZone", $$robo$$android_icu_impl_TimeZoneNamesImpl_ZNamesLoader$loadTimeZone(android.icu.impl.ICUResourceBundle java.lang.String ), 0, this, iCUResourceBundle, string2);
        }

        void loadNames(ICUResourceBundle iCUResourceBundle, String string2) {
            InvokeDynamicSupport.bootstrap("loadNames", $$robo$$android_icu_impl_TimeZoneNamesImpl_ZNamesLoader$loadNames(android.icu.impl.ICUResourceBundle java.lang.String ), 0, this, iCUResourceBundle, string2);
        }

        private static ZNames.NameTypeIndex nameTypeIndexFromKey(UResource.Key key) {
            return InvokeDynamicSupport.bootstrapStatic("nameTypeIndexFromKey", $$robo$$android_icu_impl_TimeZoneNamesImpl_ZNamesLoader$nameTypeIndexFromKey(android.icu.impl.UResource$Key ), 0, (UResource.Key)key);
        }

        private void setNameIfEmpty(UResource.Key key, UResource.Value value) {
            InvokeDynamicSupport.bootstrap("setNameIfEmpty", $$robo$$android_icu_impl_TimeZoneNamesImpl_ZNamesLoader$setNameIfEmpty(android.icu.impl.UResource$Key android.icu.impl.UResource$Value ), 0, this, key, value);
        }

        @Override
        public void put(UResource.Key key, UResource.Value value, boolean bl) {
            InvokeDynamicSupport.bootstrap("put", $$robo$$android_icu_impl_TimeZoneNamesImpl_ZNamesLoader$put(android.icu.impl.UResource$Key android.icu.impl.UResource$Value boolean ), 0, this, key, value, bl);
        }

        private String[] getNames() {
            return InvokeDynamicSupport.bootstrap("getNames", $$robo$$android_icu_impl_TimeZoneNamesImpl_ZNamesLoader$getNames(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_icu_impl_TimeZoneNamesImpl_ZNamesLoader$__constructor__(var1_1);
        }

        static {
            RobolectricInternals.classInitializing(ZNamesLoader.class);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ZNamesLoader)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class NameSearchHandler
    implements TextTrieMap.ResultHandler<NameInfo> {
        public transient /* synthetic */ Object __robo_data__;
        private EnumSet<TimeZoneNames.NameType> _nameTypes;
        private Collection<TimeZoneNames.MatchInfo> _matches;
        private int _maxMatchLen;
        static /* synthetic */ boolean $assertionsDisabled;

        private void $$robo$$android_icu_impl_TimeZoneNamesImpl_NameSearchHandler$__constructor__(EnumSet<TimeZoneNames.NameType> nameTypes) {
            this._nameTypes = nameTypes;
        }

        private final boolean $$robo$$android_icu_impl_TimeZoneNamesImpl_NameSearchHandler$handlePrefixMatch(int matchLength, Iterator<NameInfo> values) {
            while (values.hasNext()) {
                TimeZoneNames.MatchInfo minfo;
                NameInfo ninfo = values.next();
                if (this._nameTypes != null && !this._nameTypes.contains((Object)ninfo.type)) continue;
                if (ninfo.tzID != null) {
                    minfo = new TimeZoneNames.MatchInfo(ninfo.type, ninfo.tzID, null, matchLength);
                } else {
                    if (!$assertionsDisabled && ninfo.mzID == null) {
                        throw new AssertionError();
                    }
                    minfo = new TimeZoneNames.MatchInfo(ninfo.type, null, ninfo.mzID, matchLength);
                }
                if (this._matches == null) {
                    this._matches = new LinkedList<TimeZoneNames.MatchInfo>();
                }
                this._matches.add(minfo);
                if (matchLength <= this._maxMatchLen) continue;
                this._maxMatchLen = matchLength;
            }
            return true;
        }

        private final Collection<TimeZoneNames.MatchInfo> $$robo$$android_icu_impl_TimeZoneNamesImpl_NameSearchHandler$getMatches() {
            if (this._matches == null) {
                return Collections.emptyList();
            }
            return this._matches;
        }

        private final int $$robo$$android_icu_impl_TimeZoneNamesImpl_NameSearchHandler$getMaxMatchLen() {
            return this._maxMatchLen;
        }

        private final void $$robo$$android_icu_impl_TimeZoneNamesImpl_NameSearchHandler$resetResults() {
            this._matches = null;
            this._maxMatchLen = 0;
        }

        static void __staticInitializer__() {
            $assertionsDisabled = !TimeZoneNamesImpl.class.desiredAssertionStatus();
        }

        private void __constructor__(EnumSet<TimeZoneNames.NameType> enumSet) {
            this.$$robo$$android_icu_impl_TimeZoneNamesImpl_NameSearchHandler$__constructor__(enumSet);
        }

        NameSearchHandler(EnumSet<TimeZoneNames.NameType> enumSet) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_TimeZoneNamesImpl_NameSearchHandler$__constructor__(java.util.EnumSet<android.icu.text.TimeZoneNames$NameType> ), 0, this, enumSet);
        }

        @Override
        public boolean handlePrefixMatch(int n, Iterator<NameInfo> iterator) {
            return (boolean)InvokeDynamicSupport.bootstrap("handlePrefixMatch", $$robo$$android_icu_impl_TimeZoneNamesImpl_NameSearchHandler$handlePrefixMatch(int java.util.Iterator<android.icu.impl.TimeZoneNamesImpl$NameInfo> ), 0, this, n, iterator);
        }

        public Collection<TimeZoneNames.MatchInfo> getMatches() {
            return InvokeDynamicSupport.bootstrap("getMatches", $$robo$$android_icu_impl_TimeZoneNamesImpl_NameSearchHandler$getMatches(), 0, this);
        }

        public int getMaxMatchLen() {
            return (int)InvokeDynamicSupport.bootstrap("getMaxMatchLen", $$robo$$android_icu_impl_TimeZoneNamesImpl_NameSearchHandler$getMaxMatchLen(), 0, this);
        }

        public void resetResults() {
            InvokeDynamicSupport.bootstrap("resetResults", $$robo$$android_icu_impl_TimeZoneNamesImpl_NameSearchHandler$resetResults(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(NameSearchHandler.class);
        }

        public /* synthetic */ NameSearchHandler() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NameSearchHandler)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class NameInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        String tzID;
        String mzID;
        TimeZoneNames.NameType type;

        private void $$robo$$android_icu_impl_TimeZoneNamesImpl_NameInfo$__constructor__() {
        }

        private /* synthetic */ void $$robo$$android_icu_impl_TimeZoneNamesImpl_NameInfo$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_icu_impl_TimeZoneNamesImpl_NameInfo$__constructor__();
        }

        private NameInfo() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_TimeZoneNamesImpl_NameInfo$__constructor__(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_icu_impl_TimeZoneNamesImpl_NameInfo$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NameInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private final class ZoneStringsLoader
    extends UResource.Sink
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int INITIAL_NUM_ZONES = 300;
        private HashMap<UResource.Key, ZNamesLoader> keyToLoader;
        private StringBuilder sb;
        static /* synthetic */ boolean $assertionsDisabled;
        /* synthetic */ TimeZoneNamesImpl this$0;

        private void $$robo$$android_icu_impl_TimeZoneNamesImpl_ZoneStringsLoader$__constructor__(TimeZoneNamesImpl timeZoneNamesImpl) {
            this.keyToLoader = new HashMap(300);
            this.sb = new StringBuilder(32);
        }

        private final void $$robo$$android_icu_impl_TimeZoneNamesImpl_ZoneStringsLoader$load() {
            this.this$0._zoneStrings.getAllItemsWithFallback("", this);
            for (Map.Entry<UResource.Key, ZNamesLoader> entry : this.keyToLoader.entrySet()) {
                ZNamesLoader loader = entry.getValue();
                if (loader == ZNamesLoader.DUMMY_LOADER) continue;
                UResource.Key key = entry.getKey();
                if (this.isMetaZone(key)) {
                    String mzID = this.mzIDFromKey(key);
                    ZNames.createMetaZoneAndPutInCache(this.this$0._mzNamesMap, loader.getNames(), mzID);
                    continue;
                }
                String tzID = this.tzIDFromKey(key);
                ZNames.createTimeZoneAndPutInCache(this.this$0._tzNamesMap, loader.getNames(), tzID);
            }
        }

        private final void $$robo$$android_icu_impl_TimeZoneNamesImpl_ZoneStringsLoader$put(UResource.Key key, UResource.Value value, boolean noFallback) {
            UResource.Table timeZonesTable = value.getTable();
            int j = 0;
            while (timeZonesTable.getKeyAndValue(j, key, value)) {
                if (!$assertionsDisabled && value.isNoInheritanceMarker()) {
                    throw new AssertionError();
                }
                if (value.getType() == 2) {
                    this.consumeNamesTable(key, value, noFallback);
                }
                ++j;
            }
        }

        private final void $$robo$$android_icu_impl_TimeZoneNamesImpl_ZoneStringsLoader$consumeNamesTable(UResource.Key key, UResource.Value value, boolean noFallback) {
            ZNamesLoader loader = this.keyToLoader.get(key);
            if (loader == null) {
                if (this.isMetaZone(key)) {
                    String mzID = this.mzIDFromKey(key);
                    loader = this.this$0._mzNamesMap.containsKey(mzID) ? ZNamesLoader.DUMMY_LOADER : new ZNamesLoader();
                } else {
                    String tzID = this.tzIDFromKey(key);
                    loader = this.this$0._tzNamesMap.containsKey(tzID) ? ZNamesLoader.DUMMY_LOADER : new ZNamesLoader();
                }
                UResource.Key newKey = this.createKey(key);
                this.keyToLoader.put(newKey, loader);
            }
            if (loader != ZNamesLoader.DUMMY_LOADER) {
                loader.put(key, value, noFallback);
            }
        }

        private final UResource.Key $$robo$$android_icu_impl_TimeZoneNamesImpl_ZoneStringsLoader$createKey(UResource.Key key) {
            return key.clone();
        }

        private final boolean $$robo$$android_icu_impl_TimeZoneNamesImpl_ZoneStringsLoader$isMetaZone(UResource.Key key) {
            return key.startsWith("meta:");
        }

        private final String $$robo$$android_icu_impl_TimeZoneNamesImpl_ZoneStringsLoader$mzIDFromKey(UResource.Key key) {
            this.sb.setLength(0);
            for (int i = "meta:".length(); i < key.length(); ++i) {
                this.sb.append(key.charAt(i));
            }
            return this.sb.toString();
        }

        private final String $$robo$$android_icu_impl_TimeZoneNamesImpl_ZoneStringsLoader$tzIDFromKey(UResource.Key key) {
            this.sb.setLength(0);
            for (int i = 0; i < key.length(); ++i) {
                char c = key.charAt(i);
                if (c == ':') {
                    c = '/';
                }
                this.sb.append(c);
            }
            return this.sb.toString();
        }

        private /* synthetic */ void $$robo$$android_icu_impl_TimeZoneNamesImpl_ZoneStringsLoader$__constructor__(TimeZoneNamesImpl x0, 1 x1) {
        }

        static void __staticInitializer__() {
            $assertionsDisabled = !TimeZoneNamesImpl.class.desiredAssertionStatus();
        }

        private void __constructor__(TimeZoneNamesImpl timeZoneNamesImpl) {
            this.$$robo$$android_icu_impl_TimeZoneNamesImpl_ZoneStringsLoader$__constructor__(timeZoneNamesImpl);
        }

        private ZoneStringsLoader(TimeZoneNamesImpl timeZoneNamesImpl) {
            this.this$0 = timeZoneNamesImpl;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_icu_impl_TimeZoneNamesImpl_ZoneStringsLoader$__constructor__(android.icu.impl.TimeZoneNamesImpl ), 0, this, timeZoneNamesImpl);
        }

        void load() {
            InvokeDynamicSupport.bootstrap("load", $$robo$$android_icu_impl_TimeZoneNamesImpl_ZoneStringsLoader$load(), 0, this);
        }

        @Override
        public void put(UResource.Key key, UResource.Value value, boolean bl) {
            InvokeDynamicSupport.bootstrap("put", $$robo$$android_icu_impl_TimeZoneNamesImpl_ZoneStringsLoader$put(android.icu.impl.UResource$Key android.icu.impl.UResource$Value boolean ), 0, this, key, value, bl);
        }

        private void consumeNamesTable(UResource.Key key, UResource.Value value, boolean bl) {
            InvokeDynamicSupport.bootstrap("consumeNamesTable", $$robo$$android_icu_impl_TimeZoneNamesImpl_ZoneStringsLoader$consumeNamesTable(android.icu.impl.UResource$Key android.icu.impl.UResource$Value boolean ), 0, this, key, value, bl);
        }

        UResource.Key createKey(UResource.Key key) {
            return InvokeDynamicSupport.bootstrap("createKey", $$robo$$android_icu_impl_TimeZoneNamesImpl_ZoneStringsLoader$createKey(android.icu.impl.UResource$Key ), 0, this, key);
        }

        boolean isMetaZone(UResource.Key key) {
            return (boolean)InvokeDynamicSupport.bootstrap("isMetaZone", $$robo$$android_icu_impl_TimeZoneNamesImpl_ZoneStringsLoader$isMetaZone(android.icu.impl.UResource$Key ), 0, this, key);
        }

        private String mzIDFromKey(UResource.Key key) {
            return InvokeDynamicSupport.bootstrap("mzIDFromKey", $$robo$$android_icu_impl_TimeZoneNamesImpl_ZoneStringsLoader$mzIDFromKey(android.icu.impl.UResource$Key ), 0, this, key);
        }

        private String tzIDFromKey(UResource.Key key) {
            return InvokeDynamicSupport.bootstrap("tzIDFromKey", $$robo$$android_icu_impl_TimeZoneNamesImpl_ZoneStringsLoader$tzIDFromKey(android.icu.impl.UResource$Key ), 0, this, key);
        }

        private /* synthetic */ void __constructor__(TimeZoneNamesImpl timeZoneNamesImpl, 1 var2_2) {
            this.$$robo$$android_icu_impl_TimeZoneNamesImpl_ZoneStringsLoader$__constructor__(timeZoneNamesImpl, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(ZoneStringsLoader.class);
        }

        public /* synthetic */ ZoneStringsLoader() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ZoneStringsLoader)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

